(function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(require,module,exports){
/// <reference path="../../localtypings/pxtpackage.d.ts"/>
/// <reference path="../../built/pxtlib.d.ts"/>
/// <reference path="../../built/pxtblocks.d.ts"/>
/// <reference path="../../built/pxtsim.d.ts"/>
/// <reference path="../../built/pxtwinrt.d.ts"/>
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var React = require("react");
var ReactDOM = require("react-dom");
var workspace = require("./workspace");
var data = require("./data");
var pkg = require("./package");
var core = require("./core");
var sui = require("./sui");
var simulator = require("./simulator");
var compiler = require("./compiler");
var tdlegacy = require("./tdlegacy");
var cmds = require("./cmds");
var appcache = require("./appcache");
var screenshot = require("./screenshot");
var hidbridge = require("./hidbridge");
var share = require("./share");
var lang = require("./lang");
var tutorial = require("./tutorial");
var editortoolbar = require("./editortoolbar");
var filelist = require("./filelist");
var container = require("./container");
var scriptsearch = require("./scriptsearch");
var projects = require("./projects");
var sounds = require("./sounds");
var make = require("./make");
var baseToolbox = require("./toolbox");
var monacoToolbox = require("./monacoSnippets");
var monaco = require("./monaco");
var pxtjson = require("./pxtjson");
var blocks = require("./blocks");
var logview = require("./logview");
var draganddrop = require("./draganddrop");
var electron = require("./electron");
var Cloud = pxt.Cloud;
var Util = pxt.Util;
var CategoryMode = pxt.blocks.CategoryMode;
var lf = Util.lf;
pxsim.util.injectPolyphils();
var theEditor;
/*
class CloudSyncButton extends data.Component<ISettingsProps, {}> {
    renderCore() {
        Util.assert(pxt.appTarget.cloud && pxt.appTarget.cloud.workspaces);

        let par = this.props.parent
        let hd = par.state.header
        let hdId = hd ? hd.id : ""
        let btnClass = !hd || this.getData("pkg-status:" + hdId) == "saving" ? " disabled" : ""
        let save = () => {
            par.saveFileAsync()
                .then(() => par.state.currFile.epkg.savePkgAsync())
                .then(() => {
                    return workspace.syncAsync()
                })
                .done()
        }
        let needsUpload = hd && !hd.blobCurrent
        return <sui.Button class={btnClass} onClick={save}
            icon={"cloud " + (needsUpload ? "upload" : "") }
            popup={btnClass ? lf("Uploading...") : needsUpload ? lf("Will upload. Click to sync.") : lf("Stored in the cloud. Click to sync.") }
            />
    }
}*/
var ProjectView = (function (_super) {
    __extends(ProjectView, _super);
    function ProjectView(props) {
        var _this = this;
        _super.call(this, props);
        this.allEditors = [];
        this.autoRunBlocksSimulator = pxtc.Util.debounce(function () {
            if (Util.now() - _this.lastChangeTime < 1000)
                return;
            if (!_this.state.active)
                return;
            _this.runSimulator({ background: true });
        }, 1000, true);
        this.autoRunSimulator = pxtc.Util.debounce(function () {
            if (Util.now() - _this.lastChangeTime < 1000)
                return;
            if (!_this.state.active)
                return;
            _this.runSimulator({ background: true });
        }, 2000, true);
        this.typecheck = pxtc.Util.debounce(function () {
            var state = _this.editor.snapshotState();
            compiler.typecheckAsync()
                .done(function (resp) {
                _this.editor.setDiagnostics(_this.editorFile, state);
                if (pxt.appTarget.simulator && pxt.appTarget.simulator.autoRun) {
                    var output = pkg.mainEditorPkg().outputPkg.files["output.txt"];
                    if (output && !output.numDiagnosticsOverride
                        && !simulator.driver.runOptions.debug
                        && (simulator.driver.state == pxsim.SimulatorState.Running
                            || simulator.driver.state == pxsim.SimulatorState.Unloaded)) {
                        if (_this.editor == _this.blocksEditor)
                            _this.autoRunBlocksSimulator();
                        else
                            _this.autoRunSimulator();
                    }
                }
            });
        }, 1000, false);
        this.markdownChangeHandler = Util.debounce(function () {
            if (_this.state.currFile && /\.md$/i.test(_this.state.currFile.name))
                _this.setSideMarkdown(_this.editor.getCurrentSource());
        }, 4000, false);
        this.editorChangeHandler = Util.debounce(function () {
            if (!_this.editor.isIncomplete()) {
                _this.saveFileAsync().done(); // don't wait till save is done
                _this.typecheck();
            }
            _this.markdownChangeHandler();
        }, 500, false);
        this.hexFileImporters = [{
                id: "default",
                canImport: function (data) { return data.meta.cloudId == "ks/" + pxt.appTarget.id || data.meta.cloudId == pxt.CLOUD_ID + pxt.appTarget.id // match on targetid
                    || (Util.startsWith(data.meta.cloudId, pxt.CLOUD_ID + pxt.appTarget.id)); } // trying to load white-label file into main target
                ,
                importAsync: function (project, data) {
                    var h = {
                        target: pxt.appTarget.id,
                        editor: data.meta.editor,
                        name: data.meta.name,
                        meta: {},
                        pubId: "",
                        pubCurrent: false
                    };
                    var files = JSON.parse(data.source);
                    // we cannot load the workspace until we've loaded the project
                    return workspace.installAsync(h, files)
                        .then(function (hd) { return _this.loadHeaderAsync(hd, null); });
                }
            }];
        this.resourceImporters = [];
        // Close on escape
        this.closeOnEscape = function (e) {
            if (e.keyCode !== 27)
                return;
            e.preventDefault();
            _this.toggleSimulatorFullscreen();
        };
        this.debouncedSaveProjectName = Util.debounce(function () {
            _this.saveProjectNameAsync().done();
        }, 2000, false);
        document.title = pxt.appTarget.title || pxt.appTarget.name;
        this.reload = false; //set to true in case of reset of the project where we are going to reload the page.
        this.settings = JSON.parse(pxt.storage.getLocal("editorSettings") || "{}");
        this.state = {
            showFiles: false,
            active: document.visibilityState == 'visible',
            collapseEditorTools: pxt.appTarget.simulator.headless || pxt.BrowserUtils.isMobile()
        };
        if (!this.settings.editorFontSize)
            this.settings.editorFontSize = /mobile/i.test(navigator.userAgent) ? 15 : 20;
        if (!this.settings.fileHistory)
            this.settings.fileHistory = [];
    }
    ProjectView.prototype.updateVisibility = function () {
        var _this = this;
        var active = document.visibilityState == 'visible';
        pxt.debug("page visibility: " + active);
        this.setState({ active: active });
        if (!active) {
            this.stopSimulator();
            this.saveFileAsync().done();
        }
        else {
            if (workspace.isSessionOutdated()) {
                pxt.debug('workspace changed, reloading...');
                var id_1 = this.state.header ? this.state.header.id : '';
                workspace.initAsync()
                    .done(function () { return id_1 ? _this.loadHeaderAsync(workspace.getHeader(id_1)) : Promise.resolve(); });
            }
            else if (pxt.appTarget.simulator.autoRun && !this.state.running)
                this.runSimulator();
        }
    };
    ProjectView.prototype.saveSettings = function () {
        var sett = this.settings;
        if (this.reload) {
            return;
        }
        var f = this.editorFile;
        if (f && f.epkg.getTopHeader()) {
            var n_1 = {
                id: f.epkg.getTopHeader().id,
                name: f.getName(),
                pos: this.editor.getViewState()
            };
            sett.fileHistory = sett.fileHistory.filter(function (e) { return e.id != n_1.id || e.name != n_1.name; });
            while (sett.fileHistory.length > 100)
                sett.fileHistory.pop();
            sett.fileHistory.unshift(n_1);
        }
        pxt.storage.setLocal("editorSettings", JSON.stringify(this.settings));
    };
    ProjectView.prototype.componentDidUpdate = function () {
        this.saveSettings();
        this.editor.domUpdate();
        simulator.setState(this.state.header ? this.state.header.editor : '', this.state.tutorialOptions && !!this.state.tutorialOptions.tutorial);
        this.editor.resize();
    };
    ProjectView.prototype.fireResize = function () {
        if (document.createEvent) {
            var event_1 = document.createEvent('Event');
            event_1.initEvent('resize', true, true);
            window.dispatchEvent(event_1);
        }
        else {
            document.fireEvent('onresize');
        }
    };
    ProjectView.prototype.saveFileAsync = function () {
        var _this = this;
        if (!this.editorFile)
            return Promise.resolve();
        return this.saveTypeScriptAsync()
            .then(function () {
            var txt = _this.editor.getCurrentSource();
            if (txt != _this.editorFile.content)
                simulator.makeDirty();
            return _this.editorFile.setContentAsync(txt);
        });
    };
    ProjectView.prototype.isBlocksActive = function () {
        return !this.state.embedSimView && this.editor == this.blocksEditor
            && this.editorFile && this.editorFile.name == "main.blocks";
    };
    ProjectView.prototype.isJavaScriptActive = function () {
        return !this.state.embedSimView && this.editor == this.textEditor
            && this.editorFile && this.editorFile.name == "main.ts";
    };
    ProjectView.prototype.isAnyEditeableJavaScriptOrPackageActive = function () {
        return this.editor == this.textEditor
            && this.editorFile && !this.editorFile.isReadonly() && /(\.ts|pxt.json)$/.test(this.editorFile.name);
    };
    ProjectView.prototype.openJavaScript = function () {
        pxt.tickEvent("menu.javascript");
        if (this.isJavaScriptActive()) {
            if (this.state.embedSimView)
                this.setState({ embedSimView: false });
            return;
        }
        if (this.isBlocksActive())
            this.blocksEditor.openTypeScript();
        else
            this.setFile(pkg.mainEditorPkg().files["main.ts"]);
    };
    ProjectView.prototype.openBlocks = function () {
        var _this = this;
        pxt.tickEvent("menu.blocks");
        if (this.isBlocksActive()) {
            if (this.state.embedSimView)
                this.setState({ embedSimView: false });
            return;
        }
        if (this.isJavaScriptActive() || (this.shouldTryDecompile && !this.state.embedSimView))
            this.textEditor.openBlocks();
        else if (this.isAnyEditeableJavaScriptOrPackageActive()) {
            this.saveFileAsync()
                .then(function () {
                compiler.newProject();
                return compiler.getBlocksAsync();
            })
                .done(function (bi) {
                pxt.blocks.initBlocks(bi);
                _this.blocksEditor.updateBlocksInfo(bi);
                _this.setFile(pkg.mainEditorPkg().files["main.blocks"]);
            });
        }
        else
            this.setFile(pkg.mainEditorPkg().files["main.blocks"]);
        this.shouldTryDecompile = false;
    };
    ProjectView.prototype.openPreviousEditor = function () {
        if (this.prevEditorId == "monacoEditor") {
            this.openJavaScript();
        }
        else {
            this.openBlocks();
        }
    };
    ProjectView.prototype.openTypeScriptAsync = function () {
        var _this = this;
        return this.saveTypeScriptAsync(true)
            .then(function () {
            var header = _this.state.header;
            if (header) {
                header.editor = pxt.JAVASCRIPT_PROJECT_NAME;
                header.pubCurrent = false;
            }
        });
    };
    ProjectView.prototype.openSimView = function () {
        pxt.tickActivity("menu.simView");
        if (this.state.embedSimView) {
            this.startStopSimulator();
        }
        else {
            this.setState({ embedSimView: true });
            this.startSimulator();
        }
    };
    ProjectView.prototype.typecheckNow = function () {
        this.saveFileAsync().done(); // don't wait for saving to backend store to finish before typechecking
        this.typecheck();
    };
    ProjectView.prototype.initEditors = function () {
        var _this = this;
        this.textEditor = new monaco.Editor(this);
        this.pxtJsonEditor = new pxtjson.Editor(this);
        this.blocksEditor = new blocks.Editor(this);
        var changeHandler = function () {
            if (_this.editorFile) {
                if (_this.editorFile.inSyncWithEditor)
                    pxt.tickActivity("edit", "edit." + _this.editor.getId().replace(/Editor$/, ''));
                _this.editorFile.markDirty();
            }
            _this.lastChangeTime = Util.now();
            if (_this.state.running
                && pxt.appTarget.simulator && pxt.appTarget.simulator.stopOnChange)
                _this.stopSimulator();
            _this.editorChangeHandler();
        };
        this.allEditors = [this.pxtJsonEditor, this.blocksEditor, this.textEditor];
        this.allEditors.forEach(function (e) { return e.changeCallback = changeHandler; });
        this.editor = this.allEditors[this.allEditors.length - 1];
    };
    ProjectView.prototype.componentWillMount = function () {
        this.initEditors();
        this.initDragAndDrop();
    };
    ProjectView.prototype.componentDidMount = function () {
        var _this = this;
        this.allEditors.forEach(function (e) { return e.prepare(); });
        simulator.init($("#boardview")[0], {
            highlightStatement: function (stmt) {
                if (_this.editor)
                    _this.editor.highlightStatement(stmt);
            },
            restartSimulator: function () {
                core.hideDialog();
                _this.runSimulator();
            },
            editor: this.state.header ? this.state.header.editor : ''
        });
        if (pxt.appTarget.appTheme.allowParentController)
            pxt.editor.bindEditorMessages(this);
        this.forceUpdate(); // we now have editors prepared
    };
    ProjectView.prototype.pickEditorFor = function (f) {
        return this.allEditors.filter(function (e) { return e.acceptsFile(f); })[0];
    };
    ProjectView.prototype.updateEditorFile = function (editorOverride) {
        var _this = this;
        if (editorOverride === void 0) { editorOverride = null; }
        if (!this.state.active)
            return;
        if (this.state.currFile == this.editorFile && !editorOverride)
            return;
        this.saveSettings();
        var hc = this.state.highContrast;
        // save file before change
        this.saveFileAsync()
            .then(function () {
            _this.editorFile = _this.state.currFile; // TODO
            var previousEditor = _this.editor;
            _this.prevEditorId = previousEditor.getId();
            _this.editor = editorOverride || _this.pickEditorFor(_this.editorFile);
            _this.allEditors.forEach(function (e) { return e.setVisible(e == _this.editor); });
            return previousEditor ? previousEditor.unloadFileAsync() : Promise.resolve();
        })
            .then(function () { return _this.editor.loadFileAsync(_this.editorFile, hc); })
            .then(function () {
            _this.saveFileAsync().done(); // make sure state is up to date
            _this.typecheck();
            var e = _this.settings.fileHistory.filter(function (e) { return e.id == _this.state.header.id && e.name == _this.editorFile.getName(); })[0];
            if (e)
                _this.editor.setViewState(e.pos);
            container.SideDocs.notify({
                type: "fileloaded",
                name: _this.editorFile.getName(),
                locale: pxt.Util.localeInfo()
            });
            if (_this.state.showBlocks && _this.editor == _this.textEditor)
                _this.textEditor.openBlocks();
        }).finally(function () {
            _this.forceUpdate();
        });
    };
    ProjectView.prototype.setFile = function (fn) {
        if (!fn)
            return;
        if (fn.name === "main.ts") {
            this.shouldTryDecompile = true;
        }
        this.setState({
            currFile: fn,
            showBlocks: false,
            embedSimView: false
        });
        //this.fireResize();
    };
    ProjectView.prototype.setSideFile = function (fn) {
        var _this = this;
        var header = this.state.header;
        if (header) {
            header.editor = this.getPreferredEditor();
            header.pubCurrent = false;
        }
        var fileName = fn.name;
        var currFile = this.state.currFile.name;
        if (fileName != currFile && pkg.File.blocksFileNameRx.test(fileName)) {
            // Going from ts -> blocks
            pxt.tickEvent("sidebar.showBlocks");
            var tsFileName = fn.getVirtualFileName();
            var tsFile_1 = pkg.mainEditorPkg().lookupFile("this/" + tsFileName);
            if (currFile == tsFileName) {
                // current file is the ts file, so just switch
                this.textEditor.openBlocks();
            }
            else if (tsFile_1) {
                this.textEditor.decompileAsync(tsFile_1.name).then(function (success) {
                    if (!success) {
                        _this.setFile(tsFile_1);
                        _this.textEditor.showConversionFailedDialog(fn.name);
                    }
                    else {
                        _this.setFile(fn);
                    }
                });
            }
        }
        else {
            this.setFile(fn);
        }
    };
    ProjectView.prototype.removeFile = function (fn, skipConfirm) {
        var _this = this;
        if (skipConfirm === void 0) { skipConfirm = false; }
        var removeIt = function () {
            pkg.mainEditorPkg().removeFileAsync(fn.name)
                .then(function () { return pkg.mainEditorPkg().saveFilesAsync(true); })
                .then(function () { return _this.reloadHeaderAsync(); })
                .done();
        };
        if (skipConfirm) {
            removeIt();
            return;
        }
        core.confirmAsync({
            header: lf("Remove {0}", fn.name),
            body: lf("You are about to remove a file from your project. You can't undo this. Are you sure?"),
            agreeClass: "red",
            agreeIcon: "trash",
            agreeLbl: lf("Remove it"),
        }).done(function (res) {
            if (res)
                removeIt();
        });
    };
    ProjectView.prototype.updateFileAsync = function (name, content, open) {
        var _this = this;
        var p = pkg.mainEditorPkg();
        p.setFile(name, content);
        return p.updateConfigAsync(function (cfg) { return cfg.files.indexOf(name) < 0 ? cfg.files.push(name) : 0; })
            .then(function () {
            if (open)
                _this.setFile(p.lookupFile("this/" + name));
            return p.savePkgAsync();
        })
            .then(function () { return _this.reloadHeaderAsync(); });
    };
    ProjectView.prototype.setSideMarkdown = function (md) {
        var sd = this.refs["sidedoc"];
        if (!sd)
            return;
        sd.setMarkdown(md);
    };
    ProjectView.prototype.setSideDoc = function (path, blocksEditor) {
        if (blocksEditor === void 0) { blocksEditor = true; }
        var sd = this.refs["sidedoc"];
        if (!sd)
            return;
        if (path)
            sd.setPath(path, blocksEditor);
        else
            sd.collapse();
    };
    ProjectView.prototype.setTutorialStep = function (step) {
        // save and typecheck
        this.typecheckNow();
        // Notify tutorial content pane
        var tc = this.refs["tutorialcard"];
        if (!tc)
            return;
        if (step > -1) {
            var tutorialOptions = this.state.tutorialOptions;
            tutorialOptions.tutorialStep = step;
            this.setState({ tutorialOptions: tutorialOptions });
            var fullscreen = tutorialOptions.tutorialStepInfo[step].fullscreen;
            if (fullscreen)
                this.showTutorialHint();
            else
                tutorial.TutorialContent.refresh();
        }
    };
    ProjectView.prototype.handleMessage = function (msg) {
        switch (msg.type) {
            case "popoutcomplete":
                this.setState({ sideDocsCollapsed: true, sideDocsLoadUrl: '' });
                break;
            case "tutorial":
                var t = msg;
                switch (t.subtype) {
                    case 'loaded':
                        var tt = msg;
                        if (tt.toolboxSubset && Object.keys(tt.toolboxSubset).length > 0)
                            this.editor.filterToolbox({ blocks: tt.toolboxSubset, defaultState: pxt.editor.FilterState.Hidden }, CategoryMode.Basic);
                        var tutorialOptions = this.state.tutorialOptions;
                        tutorialOptions.tutorialReady = true;
                        tutorialOptions.tutorialStepInfo = tt.stepInfo;
                        this.setState({ tutorialOptions: tutorialOptions });
                        var fullscreen = tutorialOptions.tutorialStepInfo[0].fullscreen;
                        if (fullscreen)
                            this.showTutorialHint();
                        else
                            tutorial.TutorialContent.refresh();
                        core.hideLoading();
                        break;
                }
                break;
        }
    };
    ProjectView.prototype.reloadHeaderAsync = function () {
        return this.loadHeaderAsync(this.state.header, this.state.filters);
    };
    ProjectView.prototype.loadHeaderAsync = function (h, filters) {
        var _this = this;
        if (!h)
            return Promise.resolve();
        this.stopSimulator(true);
        pxt.blocks.cleanBlocks();
        var logs = this.refs["logs"];
        logs.clear();
        this.setState({
            showFiles: false,
            filters: filters
        });
        return pkg.loadPkgAsync(h.id)
            .then(function () {
            simulator.makeDirty();
            compiler.newProject();
            var e = _this.settings.fileHistory.filter(function (e) { return e.id == h.id; })[0];
            var main = pkg.getEditorPkg(pkg.mainPkg);
            var file = main.getMainFile();
            if (e)
                file = main.lookupFile(e.name) || file;
            if (!e && h.editor == pxt.JAVASCRIPT_PROJECT_NAME && !pkg.File.tsFileNameRx.test(file.getName()) && file.getVirtualFileName())
                file = main.lookupFile("this/" + file.getVirtualFileName()) || file;
            if (pkg.File.blocksFileNameRx.test(file.getName()) && file.getVirtualFileName()) {
                if (!file.content)
                    file = main.lookupFile("this/" + file.getVirtualFileName()) || file;
                else
                    _this.textEditor.decompileAsync(file.getVirtualFileName()).then(function (success) {
                        if (!success)
                            file = main.lookupFile("this/" + file.getVirtualFileName()) || file;
                    });
            }
            _this.setState({
                header: h,
                projectName: h.name,
                currFile: file,
                sideDocsLoadUrl: ''
            });
            if (file.name === "main.ts") {
                _this.shouldTryDecompile = true;
            }
            pkg.getEditorPkg(pkg.mainPkg).onupdate = function () {
                _this.loadHeaderAsync(h, _this.state.filters).done();
            };
            pkg.mainPkg.getCompileOptionsAsync()
                .catch(function (e) {
                if (e instanceof pxt.cpp.PkgConflictError) {
                    var confl = e;
                    var remove = function (lib) { return ({
                        label: lf("Remove {0}", lib.id),
                        class: "pink",
                        icon: "trash",
                        onclick: function () {
                            core.showLoading(lf("Removing {0}...", lib.id));
                            pkg.mainEditorPkg().removeDepAsync(lib.id)
                                .then(function () { return _this.reloadHeaderAsync(); })
                                .done(function () { return core.hideLoading(); });
                        }
                    }); };
                    core.dialogAsync({
                        hideCancel: true,
                        buttons: [
                            remove(confl.pkg1),
                            remove(confl.pkg0)
                        ],
                        header: lf("Packages cannot be used together"),
                        body: lf("Packages '{0}' and '{1}' cannot be used together, because they use incompatible settings ({2}).", confl.pkg1.id, confl.pkg0.id, confl.settingName)
                    });
                }
            })
                .done();
            var preferredEditor = _this.pickEditorFor(file);
            var readme = main.lookupFile("this/README.md");
            if (readme && readme.content && readme.content.trim())
                _this.setSideMarkdown(readme.content);
            else if (pkg.mainPkg && pkg.mainPkg.config && pkg.mainPkg.config.documentation)
                _this.setSideDoc(pkg.mainPkg.config.documentation, preferredEditor == _this.blocksEditor);
        });
    };
    ProjectView.prototype.removeProject = function () {
        var _this = this;
        if (!pkg.mainEditorPkg().header)
            return;
        core.confirmDelete(pkg.mainEditorPkg().header.name, function () {
            var curr = pkg.mainEditorPkg().header;
            curr.isDeleted = true;
            return workspace.saveAsync(curr, {})
                .then(function () {
                if (workspace.getHeaders().length > 0) {
                    _this.projects.showOpenProject();
                }
                else {
                    _this.newProject();
                }
            });
        });
    };
    ProjectView.prototype.importHexFile = function (file) {
        var _this = this;
        if (!file)
            return;
        pxt.cpp.unpackSourceFromHexFileAsync(file)
            .done(function (data) { return _this.importHex(data); });
    };
    ProjectView.prototype.importBlocksFiles = function (file) {
        var _this = this;
        if (!file)
            return;
        ts.pxtc.Util.fileReadAsTextAsync(file)
            .done(function (contents) {
            _this.newProject({
                filesOverride: { "main.blocks": contents, "main.ts": "  " },
                name: file.name.replace(/\.blocks$/i, '') || lf("Untitled")
            });
        });
    };
    ProjectView.prototype.importTypescriptFile = function (file) {
        var _this = this;
        if (!file)
            return;
        ts.pxtc.Util.fileReadAsTextAsync(file)
            .done(function (contents) {
            _this.newProject({
                filesOverride: { "main.blocks": '', "main.ts": contents || "  " },
                name: file.name.replace(/\.ts$/i, '') || lf("Untitled")
            });
        });
    };
    ProjectView.prototype.convertTouchDevelopToTypeScriptAsync = function (td) {
        return tdlegacy.td2tsAsync(td);
    };
    ProjectView.prototype.importHex = function (data, createNewIfFailed) {
        var _this = this;
        if (createNewIfFailed === void 0) { createNewIfFailed = false; }
        var targetId = pxt.appTarget.id;
        if (!data || !data.meta) {
            core.warningNotification(lf("Sorry, we could not recognize this file."));
            if (createNewIfFailed)
                this.newProject();
            return;
        }
        var importer = this.hexFileImporters.filter(function (fi) { return fi.canImport(data); })[0];
        if (importer) {
            pxt.tickEvent("import." + importer.id);
            core.showLoading(lf("loading project..."));
            importer.importAsync(this, data)
                .done(function () { return core.hideLoading(); }, function (e) {
                pxt.reportException(e, { importer: importer.id });
                core.hideLoading();
                core.errorNotification(lf("Oops, something went wrong when importing your project"));
                if (createNewIfFailed)
                    _this.newProject();
            });
        }
        else {
            core.warningNotification(lf("Sorry, we could not import this project."));
            pxt.tickEvent("warning.importfailed");
            if (createNewIfFailed)
                this.newProject();
        }
    };
    ProjectView.prototype.importProjectFile = function (file) {
        var _this = this;
        if (!file)
            return;
        ts.pxtc.Util.fileReadAsBufferAsync(file)
            .then(function (buf) { return pxt.lzmaDecompressAsync(buf); })
            .done(function (contents) {
            var data = JSON.parse(contents);
            _this.importHex(data);
        }, function (e) {
            core.warningNotification(lf("Sorry, we could not import this project."));
        });
    };
    ProjectView.prototype.importFile = function (file) {
        if (!file || pxt.shell.isReadOnly())
            return;
        if (isHexFile(file.name)) {
            this.importHexFile(file);
        }
        else if (isBlocksFile(file.name)) {
            this.importBlocksFiles(file);
        }
        else if (isTypescriptFile(file.name)) {
            this.importTypescriptFile(file);
        }
        else if (isProjectFile(file.name)) {
            this.importProjectFile(file);
        }
        else {
            var importer = this.resourceImporters.filter(function (fi) { return fi.canImport(file); })[0];
            if (importer) {
                importer.importAsync(this, file).done();
            }
            else {
                core.warningNotification(lf("Oops, don't know how to load this file!"));
            }
        }
    };
    ProjectView.prototype.importProjectAsync = function (project, filters) {
        var _this = this;
        var h = project.header;
        if (!h) {
            h = {
                target: pxt.appTarget.id,
                editor: pxt.BLOCKS_PROJECT_NAME,
                name: lf("Untitled"),
                meta: {},
                pubId: "",
                pubCurrent: false
            };
        }
        return workspace.installAsync(h, project.text)
            .then(function (hd) { return _this.loadHeaderAsync(hd, filters); });
    };
    ProjectView.prototype.initDragAndDrop = function () {
        var _this = this;
        draganddrop.setupDragAndDrop(document.body, function (file) { return file.size < 1000000 && isHexFile(file.name) || isBlocksFile(file.name); }, function (files) {
            if (files) {
                pxt.tickEvent("dragandrop.open");
                _this.importFile(files[0]);
            }
        });
    };
    ProjectView.prototype.openProject = function (tab) {
        pxt.tickEvent("menu.open");
        this.projects.showOpenProject(tab);
    };
    ProjectView.prototype.exportProjectToFileAsync = function () {
        var mpkg = pkg.mainPkg;
        return mpkg.compressToFileAsync(this.getPreferredEditor());
    };
    ProjectView.prototype.getPreferredEditor = function () {
        return this.editor == this.blocksEditor ? pxt.BLOCKS_PROJECT_NAME : pxt.JAVASCRIPT_PROJECT_NAME;
    };
    ProjectView.prototype.exportAsync = function () {
        pxt.debug("exporting project");
        return this.exportProjectToFileAsync()
            .then(function (buf) {
            return window.btoa(Util.uint8ArrayToString(buf));
        });
    };
    ProjectView.prototype.importProjectFromFileAsync = function (buf) {
        var _this = this;
        return pxt.lzmaDecompressAsync(buf)
            .then(function (project) {
            var hexFile = JSON.parse(project);
            return _this.importHex(hexFile);
        }).catch(function () {
            return _this.newProject();
        });
    };
    ProjectView.prototype.saveProjectToFileAsync = function () {
        var mpkg = pkg.mainPkg;
        return this.exportProjectToFileAsync()
            .then(function (buf) {
            var fn = pkg.genFileName(".mkcd");
            pxt.BrowserUtils.browserDownloadUInt8Array(buf, fn, 'application/octet-stream');
        });
    };
    ProjectView.prototype.addPackage = function () {
        pxt.tickEvent("menu.addpackage");
        this.scriptSearch.showAddPackages();
    };
    ProjectView.prototype.newEmptyProject = function (name, documentation) {
        this.setState({ tutorialOptions: {} });
        this.newProject({
            filesOverride: { "main.blocks": "<xml xmlns=\"http://www.w3.org/1999/xhtml\"></xml>" },
            name: name, documentation: documentation
        });
    };
    ProjectView.prototype.newProject = function (options) {
        if (options === void 0) { options = {}; }
        pxt.tickEvent("menu.newproject");
        core.showLoading(lf("creating new project..."));
        this.createProjectAsync(options)
            .then(function () { return Promise.delay(500); })
            .done(function () { return core.hideLoading(); });
    };
    ProjectView.prototype.createProjectAsync = function (options) {
        var _this = this;
        this.setSideDoc(undefined);
        if (!options.prj)
            options.prj = pxt.appTarget.blocksprj;
        var cfg = pxt.U.clone(options.prj.config);
        cfg.name = options.name || lf("Untitled");
        cfg.documentation = options.documentation;
        var files = Util.clone(options.prj.files);
        if (options.filesOverride)
            Util.jsonCopyFrom(files, options.filesOverride);
        files["pxt.json"] = JSON.stringify(cfg, null, 4) + "\n";
        return workspace.installAsync({
            name: cfg.name,
            meta: {},
            editor: options.prj.id,
            pubId: "",
            pubCurrent: false,
            target: pxt.appTarget.id,
            temporary: options.temporary
        }, files).then(function (hd) { return _this.loadHeaderAsync(hd, options.filters); });
    };
    ProjectView.prototype.switchTypeScript = function () {
        var mainPkg = pkg.mainEditorPkg();
        var tsName = this.editorFile.getVirtualFileName();
        var f = mainPkg.files[tsName];
        this.setFile(f);
    };
    ProjectView.prototype.saveBlocksToTypeScriptAsync = function () {
        return this.blocksEditor.saveToTypeScript();
    };
    ProjectView.prototype.saveTypeScriptAsync = function (open) {
        var _this = this;
        if (open === void 0) { open = false; }
        if (!this.editor || !this.state.currFile || this.editorFile.epkg != pkg.mainEditorPkg() || this.reload)
            return Promise.resolve();
        var promise = Promise.resolve().then(function () {
            return open ? _this.textEditor.loadMonacoAsync() : Promise.resolve();
        }).then(function () {
            return _this.editor.saveToTypeScript().then(function (src) {
                if (!src)
                    return Promise.resolve();
                // format before saving
                // if (open) src = pxtc.format(src, 0).formatted;
                var mainPkg = pkg.mainEditorPkg();
                var tsName = _this.editorFile.getVirtualFileName();
                Util.assert(tsName != _this.editorFile.name);
                return mainPkg.setContentAsync(tsName, src).then(function () {
                    if (open) {
                        var f = mainPkg.files[tsName];
                        _this.setFile(f);
                    }
                });
            });
        });
        if (open) {
            return core.showLoadingAsync(lf("switching to JavaScript..."), promise, 0);
        }
        else {
            return promise;
        }
    };
    ProjectView.prototype.reset = function () {
        var _this = this;
        pxt.tickEvent("reset");
        core.confirmAsync({
            header: lf("Reset"),
            body: lf("You are about to clear all projects. Are you sure? This operation cannot be undone."),
            agreeLbl: lf("Reset"),
            agreeClass: "red",
            agreeIcon: "sign out",
            disagreeLbl: lf("Cancel")
        }).then(function (r) {
            if (!r)
                return;
            _this.reload = true; //Indicate we are goint to reload next.
            workspace.resetAsync()
                .done(function () { return window.location.reload(); }, function () { return window.location.reload(); });
        });
    };
    ProjectView.prototype.promptRenameProjectAsync = function () {
        var _this = this;
        if (!this.state.header)
            return Promise.resolve(false);
        var opts = {
            header: lf("Rename your project"),
            agreeLbl: lf("Save"),
            input: lf("Enter your project name here")
        };
        return core.confirmAsync(opts).then(function (res) {
            if (!res || !opts.inputValue)
                return Promise.resolve(false); // cancelled
            return new Promise(function (resolve, reject) {
                _this.setState({ projectName: opts.inputValue }, function () { return resolve(); });
            }).then(function () { return _this.saveProjectNameAsync(); })
                .then(function () { return true; });
        });
    };
    ProjectView.prototype.saveAndCompile = function () {
        var _this = this;
        if (!this.state.header)
            return;
        this.setState({ isSaving: true });
        return (this.state.projectName !== lf("Untitled")
            ? Promise.resolve(true) : this.promptRenameProjectAsync())
            .then(function () { return _this.saveProjectNameAsync(); })
            .then(function () { return _this.saveFileAsync(); })
            .then(function () {
            if (!pxt.appTarget.compile.hasHex || pxt.appTarget.compile.useMkcd) {
                _this.saveProjectToFileAsync()
                    .finally(function () {
                    _this.setState({ isSaving: false });
                })
                    .done();
            }
            else {
                _this.compile(true);
            }
        });
    };
    ProjectView.prototype.beforeCompile = function () { };
    ProjectView.prototype.compile = function (saveOnly) {
        var _this = this;
        if (saveOnly === void 0) { saveOnly = false; }
        // the USB init has to be called from an event handler
        if (/webusb=1/i.test(window.location.href)) {
            pxt.usb.initAsync().catch(function (e) { });
        }
        this.beforeCompile();
        var userContextWindow = undefined;
        if (!pxt.appTarget.compile.useModulator && pxt.BrowserUtils.isBrowserDownloadInSameWindow())
            userContextWindow = window.open("");
        pxt.tickEvent("compile");
        pxt.debug('compiling...');
        if (this.state.compiling) {
            pxt.tickEvent("compile.double");
            return;
        }
        var simRestart = this.state.running;
        this.setState({ compiling: true });
        this.clearLog();
        this.editor.beforeCompile();
        if (simRestart)
            this.stopSimulator();
        var state = this.editor.snapshotState();
        compiler.compileAsync({ native: true, forceEmit: true, preferredEditor: this.getPreferredEditor() })
            .then(function (resp) {
            _this.editor.setDiagnostics(_this.editorFile, state);
            var fn = pxt.outputName();
            if (!resp.outfiles[fn]) {
                pxt.tickEvent("compile.noemit");
                core.warningNotification(lf("Compilation failed, please check your code for errors."));
                return Promise.resolve();
            }
            resp.saveOnly = saveOnly;
            resp.userContextWindow = userContextWindow;
            resp.downloadFileBaseName = pkg.genFileName("");
            resp.confirmAsync = core.confirmAsync;
            if (saveOnly) {
                return pxt.commands.saveOnlyAsync(resp);
            }
            return pxt.commands.deployCoreAsync(resp)
                .catch(function (e) {
                if (e.notifyUser) {
                    core.warningNotification(e.message);
                }
                else {
                    core.warningNotification(lf("Upload failed, please try again."));
                }
                pxt.reportException(e);
                if (userContextWindow)
                    try {
                        userContextWindow.close();
                    }
                    catch (e) { }
            });
        }).catch(function (e) {
            pxt.reportException(e);
            core.errorNotification(lf("Compilation failed, please contact support."));
            if (userContextWindow)
                try {
                    userContextWindow.close();
                }
                catch (e) { }
        }).finally(function () {
            _this.setState({ compiling: false, isSaving: false });
            if (simRestart)
                _this.runSimulator();
        })
            .done();
    };
    ProjectView.prototype.overrideTypescriptFile = function (text) {
        if (this.textEditor)
            this.textEditor.overrideFile(text);
    };
    ProjectView.prototype.startStopSimulator = function () {
        if (this.state.running) {
            pxt.tickEvent('simulator.stop');
            this.stopSimulator();
        }
        else {
            pxt.tickEvent('simulator.start');
            this.startSimulator();
        }
    };
    ProjectView.prototype.restartSimulator = function () {
        pxt.tickEvent('simulator.restart');
        this.stopSimulator();
        this.startSimulator();
    };
    ProjectView.prototype.toggleTrace = function (intervalSpeed) {
        if (this.state.tracing) {
            this.editor.clearHighlightedStatements();
            simulator.setTraceInterval(0);
        }
        else {
            simulator.setTraceInterval(intervalSpeed != undefined ? intervalSpeed : simulator.SLOW_TRACE_INTERVAL);
        }
        this.setState({ tracing: !this.state.tracing });
        this.restartSimulator();
    };
    ProjectView.prototype.startSimulator = function () {
        var _this = this;
        pxt.tickEvent('simulator.start');
        this.saveFileAsync()
            .then(function () { return _this.runSimulator(); });
    };
    ProjectView.prototype.stopSimulator = function (unload) {
        simulator.stop(unload);
        this.setState({ running: false });
    };
    ProjectView.prototype.proxySimulatorMessage = function (content) {
        simulator.proxy({
            type: "custom",
            content: content
        });
    };
    ProjectView.prototype.toggleSimulatorCollapse = function () {
        var state = this.state;
        if (!state.running && state.collapseEditorTools)
            this.startStopSimulator();
        if (state.collapseEditorTools) {
            this.expandSimulator();
        }
        else {
            this.collapseSimulator();
        }
    };
    ProjectView.prototype.expandSimulator = function () {
        if (pxt.appTarget.simulator.headless) {
            simulator.unhide();
        }
        else {
            this.startSimulator();
        }
        this.setState({ collapseEditorTools: false });
    };
    ProjectView.prototype.collapseSimulator = function () {
        var _this = this;
        simulator.hide(function () {
            _this.setState({ collapseEditorTools: true });
        });
    };
    ProjectView.prototype.toggleSimulatorFullscreen = function () {
        pxt.tickEvent("simulator.fullscreen", { view: 'computer', fullScreenTo: '' + !this.state.fullscreen });
        if (!this.state.fullscreen) {
            document.addEventListener('keydown', this.closeOnEscape);
        }
        else {
            document.removeEventListener('keydown', this.closeOnEscape);
        }
        this.setState({ fullscreen: !this.state.fullscreen });
    };
    ProjectView.prototype.toggleMute = function () {
        pxt.tickEvent("simulator.mute", { view: 'computer', muteTo: '' + !this.state.mute });
        simulator.mute(!this.state.mute);
        this.setState({ mute: !this.state.mute });
    };
    ProjectView.prototype.openInstructions = function () {
        var _this = this;
        pxt.tickEvent("simulator.make");
        var running = this.state.running;
        if (running)
            this.stopSimulator();
        make.makeAsync()
            .finally(function () {
            if (running)
                _this.startSimulator();
        });
    };
    ProjectView.prototype.clearLog = function () {
        var logs = this.refs["logs"];
        logs.clear();
    };
    ProjectView.prototype.hwDebug = function () {
        var start = Promise.resolve();
        if (!this.state.running || !simulator.driver.runOptions.debug)
            start = this.runSimulator({ debug: true });
        return start.then(function () {
            simulator.driver.setHwDebugger({
                postMessage: function (msg) {
                    pxt.HWDBG.handleMessage(msg);
                }
            });
            pxt.HWDBG.postMessage = function (msg) { return simulator.driver.handleHwDebuggerMsg(msg); };
            return Promise.join(compiler.compileAsync({ debug: true, native: true }), hidbridge.initAsync()).then(function (vals) { return pxt.HWDBG.startDebugAsync(vals[0], vals[1]); });
        });
    };
    ProjectView.prototype.runSimulator = function (opts) {
        var _this = this;
        if (opts === void 0) { opts = {}; }
        var editorId = this.editor ? this.editor.getId().replace(/Editor$/, '') : "unknown";
        if (opts.background)
            pxt.tickActivity("autorun", "autorun." + editorId);
        else
            pxt.tickEvent(opts.debug ? "debug" : "run", { editor: editorId });
        if (!opts.background)
            this.editor.beforeCompile();
        if (this.state.tracing) {
            opts.trace = true;
        }
        this.stopSimulator();
        this.clearLog();
        var state = this.editor.snapshotState();
        return compiler.compileAsync(opts)
            .then(function (resp) {
            _this.editor.setDiagnostics(_this.editorFile, state);
            if (resp.outfiles[pxtc.BINARY_JS]) {
                simulator.run(pkg.mainPkg, opts.debug, resp, _this.state.mute, _this.state.highContrast);
                _this.setState({ running: true, showParts: simulator.driver.runOptions.parts.length > 0 });
            }
            else if (!opts.background) {
                core.warningNotification(lf("Oops, we could not run this project. Please check your code for errors."));
            }
        });
    };
    ProjectView.prototype.editText = function () {
        if (this.editor != this.textEditor) {
            this.updateEditorFile(this.textEditor);
            this.forceUpdate();
        }
    };
    ProjectView.prototype.importFileDialog = function () {
        var _this = this;
        var input;
        var ext = ".mkcd";
        if (pxt.appTarget.compile && pxt.appTarget.compile.hasHex) {
            ext = ".hex";
        }
        if (pxt.appTarget.compile && pxt.appTarget.compile.useUF2) {
            ext = ".uf2";
        }
        core.confirmAsync({
            header: lf("Open {0} file", ext),
            onLoaded: function ($el) {
                input = $el.find('input')[0];
            },
            htmlBody: "<div class=\"ui form\">\n  <div class=\"ui field\">\n    <label>" + lf("Select a {0} file to open.", ext) + "</label>\n    <input type=\"file\" class=\"ui button blue fluid\"></input>\n  </div>\n</div>",
        }).done(function (res) {
            if (res) {
                pxt.tickEvent("menu.open.file");
                _this.importFile(input.files[0]);
            }
        });
    };
    ProjectView.prototype.showReportAbuse = function () {
        var _this = this;
        pxt.tickEvent("menu.reportabuse");
        var urlInput;
        var reasonInput;
        var shareUrl = pxt.appTarget.appTheme.shareUrl || "https://makecode.com/";
        core.confirmAsync({
            header: lf("Report Abuse"),
            onLoaded: function ($el) {
                urlInput = $el.find('input');
                reasonInput = $el.find('textarea');
                if (_this.state.header && _this.state.header.pubCurrent && _this.state.header.pubId)
                    urlInput.val(shareUrl + _this.state.header.pubId);
            },
            agreeLbl: lf("Submit"),
            htmlBody: "<div class=\"ui form\">\n  <div class=\"ui field\">\n    <label>" + lf("What is the URL of the offensive project?") + "</label>\n    <input type=\"url\" placeholder=\"Enter project URL here...\"></input>\n  </div>\n  <div class=\"ui field\">\n    <label>" + lf("Why do you find it offensive?") + "</label>\n    <textarea></textarea>\n  </div>\n</div>",
        }).done(function (res) {
            if (res) {
                pxt.tickEvent("menu.reportabuse.send");
                var id = pxt.Cloud.parseScriptId(urlInput.val());
                if (!id) {
                    core.errorNotification(lf("Sorry, the project url looks invalid."));
                }
                else {
                    core.infoNotification(lf("Sending abuse report..."));
                    Cloud.privatePostAsync(id + "/abusereports", {
                        text: reasonInput.val()
                    })
                        .then(function (res) {
                        core.infoNotification(lf("Report sent. Thank you!"));
                    })
                        .catch(core.handleNetworkError);
                }
            }
        });
    };
    ProjectView.prototype.importUrlDialog = function () {
        var input;
        var shareUrl = pxt.appTarget.appTheme.shareUrl || "https://makecode.com/";
        core.confirmAsync({
            header: lf("Open project URL"),
            onLoaded: function ($el) {
                input = $el.find('input')[0];
            },
            htmlBody: "<div class=\"ui form\">\n<div class=\"ui icon violet message\">\n    <i class=\"user icon\"></i>\n    <div class=\"content\">\n        <h3 class=\"header\">\n            " + lf("User-provided content") + "\n        </h3>\n        <p>\n            " + lf("The content below is provided by a user, and is not endorsed by Microsoft.") + "\n            " + lf("If you think it's not appropriate, please report abuse through Settings -> Report Abuse.") + "\n        </p>\n    </div>\n</div>\n  <div class=\"ui field\">\n    <label>" + lf("Copy the URL of the project.") + "</label>\n    <input type=\"url\" placeholder=\"" + shareUrl + "...\" class=\"ui button blue fluid\"></input>\n  </div>\n</div>",
        }).done(function (res) {
            if (res) {
                pxt.tickEvent("menu.open.url");
                var id = pxt.Cloud.parseScriptId(input.value);
                if (!id) {
                    core.errorNotification(lf("Sorry, the project url looks invalid."));
                }
                else {
                    loadHeaderBySharedId(id);
                }
            }
        });
    };
    ProjectView.prototype.launchFullEditor = function () {
        pxt.tickEvent("sandbox.openfulleditor");
        Util.assert(pxt.shell.isSandboxMode());
        var editUrl = pxt.appTarget.appTheme.embedUrl;
        if (!/\/$/.test(editUrl))
            editUrl += '/';
        var mpkg = pkg.mainPkg;
        var epkg = pkg.getEditorPkg(mpkg);
        if (pxt.shell.isReadOnly()) {
            if (epkg.header.pubId) { }
            editUrl += "#pub:" + epkg.header.pubId;
            window.open(editUrl, '_blank');
        }
        else
            this.exportAsync()
                .done(function (fileContent) {
                pxt.tickEvent("sandbox.openfulleditor");
                editUrl += "#project:" + fileContent;
                window.open(editUrl, '_blank');
            });
    };
    ProjectView.prototype.anonymousPublishAsync = function () {
        var _this = this;
        pxt.tickEvent("publish");
        this.setState({ publishing: true });
        var mpkg = pkg.mainPkg;
        var epkg = pkg.getEditorPkg(mpkg);
        return this.saveProjectNameAsync()
            .then(function () { return _this.saveFileAsync(); })
            .then(function () { return mpkg.filesToBePublishedAsync(true); })
            .then(function (files) {
            if (epkg.header.pubCurrent)
                return Promise.resolve(epkg.header.pubId);
            var meta = {
                description: mpkg.config.description,
            };
            var blocksSize = _this.blocksEditor.contentSize();
            if (blocksSize) {
                meta.blocksHeight = blocksSize.height;
                meta.blocksWidth = blocksSize.width;
            }
            return workspace.anonymousPublishAsync(epkg.header, files, meta)
                .then(function (inf) { return inf.id; });
        }).finally(function () {
            _this.setState({ publishing: false });
        })
            .catch(function (e) {
            core.errorNotification(e.message);
            throw e;
        });
    };
    ProjectView.prototype.updateHeaderName = function (name) {
        this.setState({
            projectName: name
        });
        this.debouncedSaveProjectName();
    };
    ProjectView.prototype.saveProjectNameAsync = function () {
        var _this = this;
        if (!this.state.projectName || !this.state.header)
            return Promise.resolve();
        try {
            // nothing to do?
            if (pkg.mainPkg.config.name == this.state.projectName)
                return Promise.resolve();
            //Save the name in the target MainPackage as well
            pkg.mainPkg.config.name = this.state.projectName;
            pxt.debug('saving project name to ' + this.state.projectName);
            var f = pkg.mainEditorPkg().lookupFile("this/" + pxt.CONFIG_NAME);
            var config = JSON.parse(f.content);
            config.name = this.state.projectName;
            return f.setContentAsync(JSON.stringify(config, null, 4) + "\n")
                .then(function () {
                if (_this.state.header)
                    _this.setState({
                        projectName: _this.state.header.name
                    });
            });
        }
        catch (e) {
            pxt.reportException(e);
            return Promise.resolve();
        }
    };
    ProjectView.prototype.isTextEditor = function () {
        return this.editor == this.textEditor;
    };
    ProjectView.prototype.isBlocksEditor = function () {
        return this.editor == this.blocksEditor;
    };
    ProjectView.prototype.about = function () {
        pxt.tickEvent("menu.about");
        var compileService = pxt.appTarget.compileService;
        core.confirmAsync({
            header: lf("About {0}", pxt.appTarget.name),
            hideCancel: true,
            agreeLbl: lf("Ok"),
            htmlBody: "\n<p>" + Util.htmlEscape(pxt.appTarget.description) + "</p>\n<p>" + lf("{0} version:", Util.htmlEscape(pxt.appTarget.name)) + " <a href=\"" + Util.htmlEscape(pxt.appTarget.appTheme.githubUrl) + "/releases/tag/v" + Util.htmlEscape(pxt.appTarget.versions.target) + "\" target=\"_blank\">" + Util.htmlEscape(pxt.appTarget.versions.target) + "</a></p>\n<p>" + lf("{0} version:", "Microsoft MakeCode") + " <a href=\"https://github.com/Microsoft/pxt/releases/tag/v" + Util.htmlEscape(pxt.appTarget.versions.pxt) + "\" target=\"_blank\">" + Util.htmlEscape(pxt.appTarget.versions.pxt) + "</a></p>\n" + (compileService && compileService.githubCorePackage && compileService.gittag ? "<p>" + lf("{0} version:", "C++ runtime") + " <a href=\"" + Util.htmlEscape("https://github.com/" + compileService.githubCorePackage + '/releases/tag/' + compileService.gittag) + "\" target=\"_blank\">" + Util.htmlEscape(compileService.gittag) + "</a></p>" : "") + "\n"
        }).done();
    };
    ProjectView.prototype.embed = function () {
        pxt.tickEvent("menu.embed");
        var header = this.state.header;
        this.shareEditor.show(header);
    };
    ProjectView.prototype.selectLang = function () {
        this.languagePicker.show();
    };
    ProjectView.prototype.renderBlocksAsync = function (req) {
        return compiler.getBlocksAsync()
            .then(function (blocksInfo) { return compiler.decompileSnippetAsync(req.ts, blocksInfo); })
            .then(function (resp) {
            var svg = pxt.blocks.render(resp, { snippetMode: true });
            var viewBox = svg.getAttribute("viewBox").split(/\s+/).map(function (d) { return parseInt(d); });
            return pxt.blocks.layout.blocklyToSvgAsync(svg, viewBox[0], viewBox[1], viewBox[2], viewBox[3]);
        }).then(function (re) { return re.xml; });
    };
    ProjectView.prototype.gettingStarted = function () {
        pxt.tickEvent("btn.gettingstarted");
        var targetTheme = pxt.appTarget.appTheme;
        Util.assert(!this.state.sideDocsLoadUrl && targetTheme && !!targetTheme.sideDoc);
        this.startTutorial(targetTheme.sideDoc);
    };
    ProjectView.prototype.openTutorials = function () {
        pxt.tickEvent("menu.openTutorials");
        this.projects.showOpenTutorials();
    };
    ProjectView.prototype.startTutorial = function (tutorialId) {
        pxt.tickEvent("tutorial.start");
        core.showLoading(lf("starting tutorial..."));
        this.startTutorialAsync(tutorialId)
            .then(function () { return Promise.delay(500); });
    };
    ProjectView.prototype.startTutorialAsync = function (tutorialId) {
        var _this = this;
        var title = tutorialId;
        var result = [];
        sounds.initTutorial(); // pre load sounds
        return pxt.Cloud.downloadMarkdownAsync(tutorialId)
            .then(function (md) {
            var titleRegex = /^#\s*(.*)/g.exec(md);
            if (!titleRegex || titleRegex.length < 1)
                return;
            title = titleRegex[1].trim();
            var steps = md.split(/^###[^#].*$/gmi);
            for (var step = 1; step < steps.length; step++) {
                var stepmd = "###" + steps[step];
                result.push(stepmd);
            }
            //TODO: parse for tutorial options, mainly initial blocks
        }).then(function () {
            var tutorialOptions = {
                tutorial: tutorialId,
                tutorialName: title,
                tutorialStep: 0,
                tutorialSteps: result
            };
            _this.setState({ tutorialOptions: tutorialOptions, tracing: undefined });
            var tc = _this.refs["tutorialcontent"];
            tc.setPath(tutorialId);
        }).then(function () {
            return _this.createProjectAsync({
                name: title
            });
        })
            .catch(function (e) {
            core.hideLoading();
            core.handleNetworkError(e);
        });
    };
    ProjectView.prototype.exitTutorial = function (keep) {
        pxt.tickEvent("tutorial.exit");
        core.showLoading(lf("leaving tutorial..."));
        this.exitTutorialAsync(keep)
            .then(function () { return Promise.delay(500); })
            .done(function () { return core.hideLoading(); });
    };
    ProjectView.prototype.exitTutorialAsync = function (keep) {
        var _this = this;
        // tutorial project is temporary, no need to delete
        var curr = pkg.mainEditorPkg().header;
        var files = pkg.mainEditorPkg().getAllFiles();
        if (!keep) {
            curr.isDeleted = true;
        }
        else {
            curr.temporary = false;
        }
        this.setState({ active: false, filters: undefined });
        return workspace.saveAsync(curr, {})
            .then(function () { return keep ? workspace.installAsync(curr, files) : Promise.resolve(null); })
            .then(function () {
            if (workspace.getHeaders().length > 0) {
                return _this.loadHeaderAsync(workspace.getHeaders()[0], null);
            }
            else {
                return _this.newProject();
            }
        })
            .finally(function () {
            core.hideLoading();
            _this.setState({ active: true, tutorialOptions: undefined, tracing: undefined });
        });
    };
    ProjectView.prototype.toggleHighContrast = function () {
        var _this = this;
        var hc = !this.state.highContrast;
        pxt.tickEvent("menu.highcontrast", { on: hc ? 1 : 0 });
        this.setState({ highContrast: hc }, function () { return _this.restartSimulator(); });
        if (this.editor && this.editor.isReady) {
            this.editor.setHighContrast(hc);
        }
    };
    ProjectView.prototype.completeTutorial = function () {
        pxt.tickEvent("tutorial.complete");
        this.tutorialComplete.show();
    };
    ProjectView.prototype.showTutorialHint = function () {
        var th = this.refs["tutorialhint"];
        th.showHint();
        var options = this.state.tutorialOptions;
        pxt.tickEvent("tutorial.showhint", { tutorial: options.tutorial, step: options.tutorialStep });
    };
    ProjectView.prototype.renderCore = function () {
        var _this = this;
        theEditor = this;
        if (this.editor && this.editor.isReady) {
            this.updateEditorFile();
        }
        //  ${targetTheme.accentColor ? "inverted accent " : ''}
        var settings = (Cloud.isLoggedIn() ? this.getData("cloud:me/settings?format=nonsensitive") : {}) || {};
        var targetTheme = pxt.appTarget.appTheme;
        var workspaces = pxt.appTarget.cloud && pxt.appTarget.cloud.workspaces;
        var packages = pxt.appTarget.cloud && pxt.appTarget.cloud.packages;
        var sharingEnabled = pxt.appTarget.cloud && pxt.appTarget.cloud.sharing;
        var reportAbuse = pxt.appTarget.cloud && pxt.appTarget.cloud.sharing && pxt.appTarget.cloud.publishing && pxt.appTarget.cloud.importing;
        var compile = pxt.appTarget.compile;
        var compileBtn = compile.hasHex;
        var simOpts = pxt.appTarget.simulator;
        var sandbox = pxt.shell.isSandboxMode();
        var make = !sandbox && this.state.showParts && simOpts && (simOpts.instructions || (simOpts.parts && pxt.options.debug));
        var rightLogo = sandbox ? targetTheme.portraitLogo : targetTheme.rightLogo;
        var compileTooltip = lf("Download your code to the {0}", targetTheme.boardName);
        var compileLoading = !!this.state.compiling;
        var runTooltip = this.state.running ? lf("Stop the simulator") : lf("Start the simulator");
        var makeTooltip = lf("Open assembly instructions");
        var restartTooltip = lf("Restart the simulator");
        var fullscreenTooltip = this.state.fullscreen ? lf("Exit fullscreen mode") : lf("Launch in fullscreen");
        var muteTooltip = this.state.mute ? lf("Unmute audio") : lf("Mute audio");
        var isBlocks = !this.editor.isVisible || this.getPreferredEditor() == pxt.BLOCKS_PROJECT_NAME;
        var sideDocs = !(sandbox || targetTheme.hideSideDocs);
        var tutorialOptions = this.state.tutorialOptions;
        var inTutorial = !!tutorialOptions && !!tutorialOptions.tutorial;
        var docMenu = targetTheme.docMenu && targetTheme.docMenu.length && !sandbox && !inTutorial;
        var gettingStarted = !sandbox && !inTutorial && !this.state.sideDocsLoadUrl && targetTheme && targetTheme.sideDoc && isBlocks && !targetTheme.useStartPage;
        var gettingStartedTooltip = lf("Open beginner tutorial");
        var run = true; // !compileBtn || !pxt.appTarget.simulator.autoRun || !isBlocks;
        var restart = run && !simOpts.hideRestart;
        var trace = run && simOpts.enableTrace;
        var fullscreen = run && !inTutorial && !simOpts.hideFullscreen;
        var audio = run && !inTutorial && targetTheme.hasAudio;
        var useModulator = compile.useModulator;
        var hideMenuBar = targetTheme.hideMenuBar, hideEditorToolbar = targetTheme.hideEditorToolbar;
        var isHeadless = simOpts.headless;
        var cookieKey = "cookieconsent";
        var cookieConsented = targetTheme.hideCookieNotice || electron.isElectron || pxt.winrt.isWinRT() || !!pxt.storage.getLocal(cookieKey)
            || sandbox;
        var simActive = this.state.embedSimView;
        var blockActive = this.isBlocksActive();
        var javascriptActive = this.isJavaScriptActive();
        var traceTooltip = this.state.tracing ? lf("Disable Slow-Mo") : lf("Slow-Mo");
        var selectLanguage = targetTheme.selectLanguage;
        var betaUrl = targetTheme.betaUrl;
        var consentCookie = function () {
            pxt.storage.setLocal(cookieKey, "1");
            _this.forceUpdate();
        };
        var showSideDoc = sideDocs && this.state.sideDocsLoadUrl && !this.state.sideDocsCollapsed;
        // update window title
        document.title = this.state.header ? this.state.header.name + " - " + pxt.appTarget.name : pxt.appTarget.name;
        var rootClasses = sui.cx([
            (this.state.hideEditorFloats || this.state.collapseEditorTools) && !inTutorial ? " hideEditorFloats" : '',
            this.state.collapseEditorTools && !inTutorial ? " collapsedEditorTools" : '',
            this.state.fullscreen ? 'fullscreensim' : '',
            showSideDoc ? 'sideDocs' : '',
            pxt.shell.layoutTypeClass(),
            inTutorial ? 'tutorial' : '',
            pxt.options.light ? 'light' : '',
            pxt.BrowserUtils.isTouchEnabled() ? 'has-touch' : '',
            hideMenuBar ? 'hideMenuBar' : '',
            hideEditorToolbar ? 'hideEditorToolbar' : '',
            sandbox && simActive ? 'simView' : '',
            'full-abs'
        ]);
        return (React.createElement("div", {id: 'root', className: rootClasses}, useModulator ? React.createElement("audio", {id: "modulatorAudioOutput", controls: true}) : undefined, useModulator ? React.createElement("div", {id: "modulatorWrapper"}, React.createElement("div", {id: "modulatorBubble"}, React.createElement("canvas", {id: "modulatorWavStrip"}))) : undefined, hideMenuBar ? undefined :
            React.createElement("div", {id: "menubar", role: "banner"}, React.createElement("div", {className: "ui borderless fixed " + (targetTheme.invertedMenu ? "inverted" : '') + " menu", role: "menubar"}, !sandbox ? React.createElement("div", {className: "left menu"}, React.createElement("span", {id: "logo", className: "ui item logo"}, targetTheme.logo || targetTheme.portraitLogo
                ? React.createElement("a", {className: "ui image", target: "_blank", rel: "noopener", href: targetTheme.logoUrl}, React.createElement("img", {className: "ui logo " + (targetTheme.portraitLogo ? " portrait hide" : ''), src: Util.toDataUri(targetTheme.logo || targetTheme.portraitLogo), alt: targetTheme.boardName + " Logo"}))
                : React.createElement("span", {className: "name"}, targetTheme.name), targetTheme.portraitLogo ? (React.createElement("a", {className: "ui", target: "_blank", rel: "noopener", href: targetTheme.logoUrl}, React.createElement("img", {className: 'ui mini image portrait only', src: Util.toDataUri(targetTheme.portraitLogo), alt: targetTheme.boardName + " Logo"}))) : null), !inTutorial ? React.createElement(sui.Item, {class: "icon openproject", role: "menuitem", textClass: "landscape only", icon: "folder open large", text: lf("Projects"), onClick: function () { return _this.openProject(); }}) : null, !inTutorial && this.state.header && sharingEnabled ? React.createElement(sui.Item, {class: "icon shareproject", role: "menuitem", textClass: "widedesktop only", text: lf("Share"), icon: "share alternate large", onClick: function () { return _this.embed(); }}) : null, inTutorial ? React.createElement(sui.Item, {class: "tutorialname", role: "menuitem", textClass: "landscape only", text: tutorialOptions.tutorialName}) : null) : React.createElement("div", {className: "left menu"}, React.createElement("span", {id: "logo", className: "ui item logo"}, React.createElement("img", {className: "ui mini image", src: Util.toDataUri(rightLogo), onClick: function () { return _this.launchFullEditor(); }, alt: targetTheme.boardName + " Logo"}))), !inTutorial && !targetTheme.blocksOnly ? React.createElement(sui.Item, {class: "editor-menuitem"}, React.createElement("div", {className: "ui grid padded"}, sandbox ? React.createElement(sui.Item, {class: "sim-menuitem thin portrait only", textClass: "landscape only", text: lf("Simulator"), icon: simActive && this.state.running ? "stop" : "play", active: simActive, onClick: function () { return _this.openSimView(); }, title: !simActive ? lf("Show Simulator") : runTooltip}) : undefined, React.createElement(sui.Item, {class: "blocks-menuitem", textClass: "landscape only", text: lf("Blocks"), icon: "xicon blocks", active: blockActive, onClick: function () { return _this.openBlocks(); }, title: lf("Convert code to Blocks")}), React.createElement(sui.Item, {class: "javascript-menuitem", textClass: "landscape only", text: lf("JavaScript"), icon: "xicon js", active: javascriptActive, onClick: function () { return _this.openJavaScript(); }, title: lf("Convert code to JavaScript")}), React.createElement("div", {className: "ui item toggle"}))) : undefined, inTutorial ? React.createElement(tutorial.TutorialMenuItem, {parent: this}) : undefined, React.createElement("div", {className: "right menu"}, docMenu ? React.createElement(container.DocsMenuItem, {parent: this}) : undefined, sandbox || inTutorial ? undefined :
                React.createElement(sui.DropdownMenuItem, {icon: 'setting large', title: lf("More..."), class: "more-dropdown-menuitem"}, this.state.header ? React.createElement(sui.Item, {role: "menuitem", icon: "options", text: lf("Project Settings"), onClick: function () { return _this.setFile(pkg.mainEditorPkg().lookupFile("this/pxt.json")); }}) : undefined, this.state.header && packages ? React.createElement(sui.Item, {role: "menuitem", icon: "disk outline", text: lf("Add Package..."), onClick: function () { return _this.addPackage(); }}) : undefined, this.state.header ? React.createElement(sui.Item, {role: "menuitem", icon: "trash", text: lf("Delete Project"), onClick: function () { return _this.removeProject(); }}) : undefined, reportAbuse ? React.createElement(sui.Item, {role: "menuitem", icon: "warning circle", text: lf("Report Abuse..."), onClick: function () { return _this.showReportAbuse(); }}) : undefined, React.createElement("div", {className: "ui divider"}), selectLanguage ? React.createElement(sui.Item, {icon: "xicon globe", role: "menuitem", text: lf("Language"), onClick: function () { return _this.selectLang(); }}) : undefined, targetTheme.highContrast ? React.createElement(sui.Item, {role: "menuitem", text: this.state.highContrast ? lf("High Contrast Off") : lf("High Contrast On"), onClick: function () { return _this.toggleHighContrast(); }}) : undefined, React.createElement(sui.Item, {role: "menuitem", icon: 'sign out', text: lf("Reset"), onClick: function () { return _this.reset(); }}), React.createElement("div", {className: "ui divider"}), targetTheme.privacyUrl ? React.createElement("a", {className: "ui item", href: targetTheme.privacyUrl, role: "menuitem", title: lf("Privacy & Cookies"), target: "_blank"}, lf("Privacy & Cookies")) : undefined, targetTheme.termsOfUseUrl ? React.createElement("a", {className: "ui item", href: targetTheme.termsOfUseUrl, role: "menuitem", title: lf("Terms Of Use"), target: "_blank"}, lf("Terms Of Use")) : undefined, React.createElement(sui.Item, {role: "menuitem", text: lf("About..."), onClick: function () { return _this.about(); }}), electron.isElectron ? React.createElement(sui.Item, {role: "menuitem", text: lf("Check for updates..."), onClick: function () { return electron.checkForUpdate(); }}) : undefined, targetTheme.feedbackUrl ? React.createElement("div", {className: "ui divider"}) : undefined, targetTheme.feedbackUrl ? React.createElement("a", {className: "ui item", href: targetTheme.feedbackUrl, role: "menuitem", title: lf("Give Feedback"), target: "_blank", rel: "noopener"}, lf("Give Feedback")) : undefined), sandbox && !targetTheme.hideEmbedEdit ? React.createElement(sui.Item, {role: "menuitem", icon: "external", textClass: "mobile hide", text: lf("Edit"), onClick: function () { return _this.launchFullEditor(); }}) : undefined, inTutorial ? React.createElement(sui.ButtonMenuItem, {class: "exit-tutorial-btn", role: "menuitem", icon: "external", text: lf("Exit tutorial"), textClass: "landscape only", onClick: function () { return _this.exitTutorial(true); }}) : undefined, !sandbox ? React.createElement("a", {id: "organization", href: targetTheme.organizationUrl, target: "blank", rel: "noopener", className: "ui item logo", onClick: function () { return pxt.tickEvent("menu.org"); }}, targetTheme.organizationWideLogo || targetTheme.organizationLogo
                ? React.createElement("img", {className: "ui logo " + (targetTheme.organizationWideLogo ? " portrait hide" : ''), src: Util.toDataUri(targetTheme.organizationWideLogo || targetTheme.organizationLogo), alt: targetTheme.organization + " Logo"})
                : React.createElement("span", {className: "name"}, targetTheme.organization), targetTheme.organizationLogo ? (React.createElement("img", {className: 'ui mini image portrait only', src: Util.toDataUri(targetTheme.organizationLogo), alt: targetTheme.organization + " Logo"})) : null) : undefined, betaUrl ? React.createElement("a", {href: "" + betaUrl, className: "ui red mini corner top left attached label betalabel"}, lf("Beta")) : undefined))), gettingStarted ?
            React.createElement("div", {id: "getting-started-btn"}, React.createElement(sui.Button, {class: "portrait hide bottom attached small getting-started-btn", title: gettingStartedTooltip, text: lf("Getting Started"), onClick: function () { return _this.gettingStarted(); }}))
            : undefined, React.createElement("div", {id: "simulator"}, React.createElement("div", {id: "filelist", className: "ui items", role: "complementary"}, React.createElement("div", {id: "boardview", className: "ui vertical editorFloat"}), !isHeadless ? React.createElement("div", {className: "ui item grid centered portrait hide simtoolbar"}, React.createElement("div", {className: "ui icon buttons " + (this.state.fullscreen ? 'massive' : ''), style: { padding: "0" }}, make ? React.createElement(sui.Button, {icon: 'configure', class: "fluid sixty secondary", text: lf("Make"), title: makeTooltip, onClick: function () { return _this.openInstructions(); }}) : undefined, run ? React.createElement(sui.Button, {key: 'runbtn', class: "play-button " + (this.state.running ? "stop" : "play"), icon: this.state.running ? "stop" : "play", title: runTooltip, onClick: function () { return _this.startStopSimulator(); }}) : undefined, restart ? React.createElement(sui.Button, {key: 'restartbtn', class: "restart-button", icon: "refresh", title: restartTooltip, onClick: function () { return _this.restartSimulator(); }}) : undefined, trace ? React.createElement(sui.Button, {key: 'debug', class: "trace-button " + (this.state.tracing ? 'orange' : ''), icon: "xicon turtle", title: traceTooltip, onClick: function () { return _this.toggleTrace(); }}) : undefined), React.createElement("div", {className: "ui icon buttons " + (this.state.fullscreen ? 'massive' : ''), style: { padding: "0" }}, audio ? React.createElement(sui.Button, {key: 'mutebtn', class: "mute-button " + (this.state.mute ? 'red' : ''), icon: "" + (this.state.mute ? 'volume off' : 'volume up'), title: muteTooltip, onClick: function () { return _this.toggleMute(); }}) : undefined, fullscreen ? React.createElement(sui.Button, {key: 'fullscreenbtn', class: "fullscreen-button", icon: "" + (this.state.fullscreen ? 'compress' : 'maximize'), title: fullscreenTooltip, onClick: function () { return _this.toggleSimulatorFullscreen(); }}) : undefined)) : undefined, React.createElement("div", {className: "ui item portrait hide"}, pxt.options.debug && !this.state.running ? React.createElement(sui.Button, {key: 'debugbtn', class: 'teal', icon: "xicon bug", text: "Sim Debug", onClick: function () { return _this.runSimulator({ debug: true }); }}) : '', pxt.options.debug ? React.createElement(sui.Button, {key: 'hwdebugbtn', class: 'teal', icon: "xicon chip", text: "Dev Debug", onClick: function () { return _this.hwDebug(); }}) : ''), React.createElement("div", {className: "ui editorFloat portrait hide"}, React.createElement(logview.LogView, {ref: "logs"})), sandbox || isBlocks ? undefined : React.createElement(filelist.FileList, {parent: this}))), React.createElement("div", {id: "maineditor", className: sandbox ? "sandbox" : "", role: "main"}, inTutorial ? React.createElement(tutorial.TutorialCard, {ref: "tutorialcard", parent: this}) : undefined, this.allEditors.map(function (e) { return e.displayOuter(); })), inTutorial ? React.createElement(tutorial.TutorialHint, {ref: "tutorialhint", parent: this}) : undefined, inTutorial ? React.createElement(tutorial.TutorialContent, {ref: "tutorialcontent", parent: this}) : undefined, hideEditorToolbar ? undefined : React.createElement("div", {id: "editortools", role: "complementary"}, React.createElement(editortoolbar.EditorToolbar, {ref: "editortools", parent: this})), sideDocs ? React.createElement(container.SideDocs, {ref: "sidedoc", parent: this}) : undefined, sandbox ? undefined : React.createElement(scriptsearch.ScriptSearch, {parent: this, ref: function (v) { return _this.scriptSearch = v; }}), sandbox ? undefined : React.createElement(projects.Projects, {parent: this, ref: function (v) { return _this.projects = v; }, hasGettingStarted: gettingStarted}), sandbox || !sharingEnabled ? undefined : React.createElement(share.ShareEditor, {parent: this, ref: function (v) { return _this.shareEditor = v; }}), selectLanguage ? React.createElement(lang.LanguagePicker, {parent: this, ref: function (v) { return _this.languagePicker = v; }}) : undefined, inTutorial ? React.createElement(tutorial.TutorialComplete, {parent: this, ref: function (v) { return _this.tutorialComplete = v; }}) : undefined, sandbox ? React.createElement("div", {className: "ui horizontal small divided link list sandboxfooter"}, targetTheme.organizationUrl && targetTheme.organization ? React.createElement("a", {className: "item", target: "_blank", rel: "noopener", href: targetTheme.organizationUrl}, targetTheme.organization) : undefined, React.createElement("a", {target: "_blank", className: "item", href: targetTheme.termsOfUseUrl, rel: "noopener"}, lf("Terms of Use")), React.createElement("a", {target: "_blank", className: "item", href: targetTheme.privacyUrl, rel: "noopener"}, lf("Privacy")), React.createElement("span", {className: "item"}, React.createElement("a", {className: "ui thin portrait only", title: compileTooltip, onClick: function () { return _this.compile(); }}, React.createElement("i", {className: "icon " + (pxt.appTarget.appTheme.downloadIcon || 'download')}), pxt.appTarget.appTheme.useUploadMessage ? lf("Upload") : lf("Download")))) : undefined, cookieConsented ? undefined : React.createElement("div", {id: 'cookiemsg', className: "ui teal inverted black segment"}, React.createElement("button", {"arial-label": lf("Ok"), className: "ui right floated icon button clear inverted", onClick: consentCookie}, React.createElement("i", {className: "remove icon"})), lf("By using this site you agree to the use of cookies for analytics."), React.createElement("a", {target: "_blank", className: "ui link", href: pxt.appTarget.appTheme.privacyUrl, rel: "noopener"}, lf("Learn more")))));
    };
    return ProjectView;
}(data.Component));
exports.ProjectView = ProjectView;
function render() {
    ReactDOM.render(React.createElement(ProjectView, null), $('#content')[0]);
}
function getEditor() {
    return theEditor;
}
function isHexFile(filename) {
    return /\.(hex|uf2)$/i.test(filename);
}
function isBlocksFile(filename) {
    return /\.blocks$/i.test(filename);
}
function isTypescriptFile(filename) {
    return /\.ts$/i.test(filename);
}
function isProjectFile(filename) {
    return /\.(pxt|mkcd)$/i.test(filename);
}
function initLogin() {
    {
        var qs = core.parseQueryString((location.hash || "#").slice(1).replace(/%23access_token/, "access_token"));
        if (qs["access_token"]) {
            var ex = pxt.storage.getLocal("oauthState");
            if (ex && ex == qs["state"]) {
                pxt.storage.setLocal("access_token", qs["access_token"]);
                pxt.storage.removeLocal("oauthState");
            }
            location.hash = location.hash.replace(/(%23)?[\#\&\?]*access_token.*/, "");
        }
        Cloud.accessToken = pxt.storage.getLocal("access_token") || "";
    }
    {
        var qs = core.parseQueryString((location.hash || "#").slice(1).replace(/%local_token/, "local_token"));
        if (qs["local_token"]) {
            pxt.storage.setLocal("local_token", qs["local_token"]);
            location.hash = location.hash.replace(/(%23)?[\#\&\?]*local_token.*/, "");
        }
        Cloud.localToken = pxt.storage.getLocal("local_token") || "";
    }
}
function initSerial() {
    if (!pxt.appTarget.serial || !pxt.winrt.isWinRT() && (!Cloud.isLocalHost() || !Cloud.localToken))
        return;
    if (hidbridge.shouldUse()) {
        hidbridge.initAsync()
            .then(function (dev) {
            dev.onSerial = function (buf, isErr) {
                window.postMessage({
                    type: 'serial',
                    id: 'n/a',
                    data: Util.fromUTF8(Util.uint8ArrayToString(buf))
                }, "*");
            };
        })
            .catch(function (e) {
            pxt.log("hidbridge failed to load, " + e);
        });
        return;
    }
    pxt.debug('initializing serial pipe');
    var ws = new WebSocket("ws://localhost:" + pxt.options.wsPort + "/" + Cloud.localToken + "/serial");
    ws.onopen = function (ev) {
        pxt.debug('serial: socket opened');
    };
    ws.onclose = function (ev) {
        pxt.debug('serial: socket closed');
    };
    ws.onmessage = function (ev) {
        try {
            var msg = JSON.parse(ev.data);
            if (msg && msg.type == 'serial')
                window.postMessage(msg, "*");
        }
        catch (e) {
            pxt.debug('unknown message: ' + ev.data);
        }
    };
}
function getsrc() {
    pxt.log(theEditor.editor.getCurrentSource());
}
function initScreenshots() {
    window.addEventListener('message', function (ev) {
        var msg = ev.data;
        if (msg && msg.type == "screenshot") {
            pxt.tickEvent("sim.screenshot");
            var scmsg = msg;
            pxt.debug('received screenshot');
            screenshot.saveAsync(theEditor.state.header, scmsg.data)
                .done(function () { pxt.debug('screenshot saved'); });
        }
        ;
    }, false);
}
function enableAnalytics() {
    pxt.analytics.enable();
    pxt.editor.enableControllerAnalytics();
    var stats = {};
    if (typeof window !== "undefined") {
        var screen_1 = window.screen;
        stats["screen.width"] = screen_1.width;
        stats["screen.height"] = screen_1.height;
        stats["screen.availwidth"] = screen_1.availWidth;
        stats["screen.availheight"] = screen_1.availHeight;
        stats["screen.devicepixelratio"] = pxt.BrowserUtils.devicePixelRatio();
    }
    pxt.tickEvent("editor.loaded", stats);
}
function showIcons() {
    var usedIcons = [
        "cancel", "certificate", "checkmark", "cloud", "cloud upload", "copy", "disk outline", "download",
        "dropdown", "edit", "file outline", "find", "folder", "folder open", "help circle",
        "keyboard", "lock", "play", "puzzle", "search", "setting", "settings",
        "share alternate", "sign in", "sign out", "square", "stop", "translate", "trash", "undo", "upload",
        "user", "wizard", "configure", "align left"
    ];
    core.confirmAsync({
        header: "Icons",
        htmlBody: usedIcons.map(function (s) { return ("<i style='font-size:2em' class=\"ui icon " + s + "\"></i>&nbsp;" + s + "&nbsp; "); }).join("\n")
    });
}
function assembleCurrent() {
    compiler.compileAsync({ native: true })
        .then(function () { return compiler.assembleAsync(getEditor().editorFile.content); })
        .then(function (v) {
        var nums = v.words;
        pxt.debug("[" + nums.map(function (n) { return "0x" + n.toString(16); }).join(",") + "]");
    });
}
function log(v) {
    console.log(v);
}
// This is for usage from JS console
var myexports = {
    workspace: workspace,
    require: require,
    core: core,
    getEditor: getEditor,
    monaco: monaco,
    blocks: blocks,
    compiler: compiler,
    pkg: pkg,
    getsrc: getsrc,
    sim: simulator,
    apiAsync: core.apiAsync,
    showIcons: showIcons,
    assembleCurrent: assembleCurrent,
    log: log
};
window.E = myexports;
function initTheme() {
    var theme = pxt.appTarget.appTheme;
    if (theme.accentColor) {
        var style = document.createElement('style');
        style.type = 'text/css';
        style.innerHTML = ".ui.accent { color: " + theme.accentColor + "; }\n        .ui.inverted.menu .accent.active.item, .ui.inverted.accent.menu  { background-color: " + theme.accentColor + "; }";
        document.getElementsByTagName('head')[0].appendChild(style);
    }
    // RTL languages
    if (Util.isUserLanguageRtl()) {
        pxt.debug("rtl layout");
        pxsim.U.addClass(document.body, "rtl");
        document.body.style.direction = "rtl";
        // replace semantic.css with rtlsemantic.css
        var links = Util.toArray(document.head.getElementsByTagName("link"));
        var semanticLink = links.filter(function (l) { return Util.endsWith(l.getAttribute("href"), "semantic.css"); })[0];
        var semanticHref = semanticLink.getAttribute("data-rtl");
        if (semanticHref) {
            pxt.debug("swapping to " + semanticHref);
            semanticLink.setAttribute("href", semanticHref);
        }
    }
    function patchCdn(url) {
        if (!url)
            return url;
        return url.replace("@cdnUrl@", pxt.getOnlineCdnUrl());
    }
    theme.appLogo = patchCdn(theme.appLogo);
    theme.cardLogo = patchCdn(theme.cardLogo);
    if (pxt.appTarget.simulator
        && pxt.appTarget.simulator.boardDefinition
        && pxt.appTarget.simulator.boardDefinition.visual) {
        var boardDef = pxt.appTarget.simulator.boardDefinition.visual;
        if (boardDef.image) {
            boardDef.image = patchCdn(boardDef.image);
            if (boardDef.outlineImage)
                boardDef.outlineImage = patchCdn(boardDef.outlineImage);
        }
    }
}
function parseHash() {
    var hashCmd = "";
    var hashArg = "";
    var hashM = /^#(\w+)(:([\/\-\+\=\w]+))?$/.exec(window.location.hash);
    if (hashM) {
        return { cmd: hashM[1], arg: hashM[3] || '' };
    }
    return { cmd: '', arg: '' };
}
function handleHash(hash) {
    if (!hash)
        return false;
    var editor = theEditor;
    if (!editor)
        return false;
    switch (hash.cmd) {
        case "doc":
            pxt.tickEvent("hash.doc");
            editor.setSideDoc(hash.arg, editor == this.blockEditor);
            break;
        case "follow":
            pxt.tickEvent("hash.follow");
            editor.newEmptyProject(undefined, hash.arg);
            return true;
        case "newproject":
            pxt.tickEvent("hash.newproject");
            editor.newProject();
            window.location.hash = "";
            return true;
        case "newjavascript":
            pxt.tickEvent("hash.newjavascript");
            editor.newProject({
                prj: pxt.appTarget.blocksprj,
                filesOverride: {
                    "main.blocks": ""
                }
            });
            window.location.hash = "";
            return true;
        case "gettingstarted":
            pxt.tickEvent("hash.gettingstarted");
            editor.newProject();
            window.location.hash = "";
            return true;
        case "tutorial":
            pxt.tickEvent("hash.tutorial");
            editor.startTutorial(hash.arg);
            window.location.hash = "";
            return true;
        case "projects":
            pxt.tickEvent("hash.projects");
            editor.openProject(hash.arg);
            window.location.hash = "";
            return true;
        case "sandbox":
        case "pub":
        case "edit":
            pxt.tickEvent("hash." + hash.cmd);
            window.location.hash = "";
            loadHeaderBySharedId(hash.arg);
            return true;
        case "sandboxproject":
        case "project":
            pxt.tickEvent("hash." + hash.cmd);
            var fileContents = Util.stringToUint8Array(atob(hash.arg));
            window.location.hash = "";
            core.showLoading(lf("loading project..."));
            theEditor.importProjectFromFileAsync(fileContents)
                .done(function () { return core.hideLoading(); });
            return true;
    }
    return false;
}
// Determines whether the hash argument affects the starting project
function isProjectRelatedHash(hash) {
    if (!hash) {
        return false;
    }
    switch (hash.cmd) {
        case "follow":
        case "newproject":
        case "newjavascript":
        // case "gettingstarted": // This should be true, #gettingstarted hash handling is not yet implemented
        case "tutorial":
        case "projects":
        case "sandbox":
        case "pub":
        case "edit":
        case "sandboxproject":
        case "project":
            return true;
        default:
            return false;
    }
}
function loadHeaderBySharedId(id) {
    var existing = workspace.getHeaders()
        .filter(function (h) { return h.pubCurrent && h.pubId == id; })[0];
    core.showLoading(lf("loading project..."));
    (existing
        ? theEditor.loadHeaderAsync(existing, null)
        : workspace.installByIdAsync(id)
            .then(function (hd) { return theEditor.loadHeaderAsync(hd, null); }))
        .catch(core.handleNetworkError)
        .finally(function () { return core.hideLoading(); });
}
function initHashchange() {
    window.addEventListener("hashchange", function (e) {
        handleHash(parseHash());
    });
}
function initExtensionsAsync() {
    if (!pxt.appTarget.appTheme || !pxt.appTarget.appTheme.extendEditor)
        return Promise.resolve();
    pxt.debug('loading editor extensions...');
    var opts = {};
    return pxt.BrowserUtils.loadScriptAsync(pxt.webConfig.commitCdnUrl + "editor.js")
        .then(function () { return pxt.editor.initExtensionsAsync(opts); })
        .then(function (res) {
        if (res.hexFileImporters) {
            res.hexFileImporters.forEach(function (fi) {
                pxt.debug("\tadded hex importer " + fi.id);
                theEditor.hexFileImporters.push(fi);
            });
        }
        if (res.resourceImporters) {
            res.resourceImporters.forEach(function (fi) {
                pxt.debug("\tadded resource importer " + fi.id);
                theEditor.resourceImporters.push(fi);
            });
        }
        if (res.deployCoreAsync) {
            pxt.debug("\tadded custom deploy core async");
            pxt.commands.deployCoreAsync = res.deployCoreAsync;
        }
        if (res.beforeCompile) {
            theEditor.beforeCompile = res.beforeCompile;
        }
        if (res.fieldEditors) {
            res.fieldEditors.forEach(function (fi) {
                pxt.blocks.registerFieldEditor(fi.selector, fi.editor, fi.validator);
            });
        }
        if (res.toolboxOptions) {
            if (res.toolboxOptions.blocklyXml) {
                baseToolbox.overrideBaseToolbox(res.toolboxOptions.blocklyXml);
            }
            if (res.toolboxOptions.monacoToolbox) {
                monacoToolbox.overrideToolbox(res.toolboxOptions.monacoToolbox);
            }
        }
    });
}
pxt.winrt.captureInitialActivation();
$(document).ready(function () {
    pxt.setupWebConfig(window.pxtConfig);
    var config = pxt.webConfig;
    pxt.options.debug = /dbg=1/i.test(window.location.href);
    pxt.options.light = /light=1/i.test(window.location.href) || pxt.BrowserUtils.isARM() || pxt.BrowserUtils.isIE();
    var wsPortMatch = /wsport=(\d+)/i.exec(window.location.href);
    if (wsPortMatch) {
        pxt.options.wsPort = parseInt(wsPortMatch[1]) || 3233;
        window.location.hash = window.location.hash.replace(wsPortMatch[0], "");
    }
    else {
        pxt.options.wsPort = 3233;
    }
    pkg.setupAppTarget(window.pxtTargetBundle);
    enableAnalytics();
    if (!pxt.BrowserUtils.isBrowserSupported() && !/skipbrowsercheck=1/i.exec(window.location.href)) {
        pxt.tickEvent("unsupported");
        window.location.href = "/browsers";
        core.showLoading(lf("Sorry, this browser is not supported."));
        return;
    }
    initLogin();
    var hash = parseHash();
    appcache.init(hash);
    pxt.docs.requireMarked = function () { return require("marked"); };
    var importHex = function (hex, createNewIfFailed) {
        if (createNewIfFailed === void 0) { createNewIfFailed = false; }
        return theEditor.importHex(hex, createNewIfFailed);
    };
    var hm = /^(https:\/\/[^/]+)/.exec(window.location.href);
    if (hm)
        Cloud.apiRoot = hm[1] + "/api/";
    var ws = /ws=(\w+)/.exec(window.location.href);
    var isSandbox = pxt.shell.isSandboxMode() || pxt.shell.isReadOnly();
    if (ws)
        workspace.setupWorkspace(ws[1]);
    else if (pxt.appTarget.appTheme.allowParentController)
        workspace.setupWorkspace("iframe");
    else if (isSandbox)
        workspace.setupWorkspace("mem");
    else if (pxt.winrt.isWinRT())
        workspace.setupWorkspace("uwp");
    else if (Cloud.isLocalHost())
        workspace.setupWorkspace("fs");
    Promise.resolve()
        .then(function () {
        var mlang = /(live)?lang=([a-z]{2,}(-[A-Z]+)?)/i.exec(window.location.href);
        if (mlang && window.location.hash.indexOf(mlang[0]) >= 0) {
            lang.setCookieLang(mlang[2]);
            window.location.hash = window.location.hash.replace(mlang[0], "");
        }
        var useLang = mlang ? mlang[2] : (lang.getCookieLang() || pxt.appTarget.appTheme.defaultLocale || navigator.userLanguage || navigator.language);
        var live = !pxt.appTarget.appTheme.disableLiveTranslations || (mlang && !!mlang[1]);
        if (useLang)
            pxt.tickEvent("locale." + useLang + (live ? ".live" : ""));
        lang.initialLang = useLang;
        return Util.updateLocalizationAsync(pxt.appTarget.id, false, config.commitCdnUrl, useLang, pxt.appTarget.versions.pxtCrowdinBranch, pxt.appTarget.versions.branch, live);
    })
        .then(function () { return initTheme(); })
        .then(function () { return cmds.initCommandsAsync(); })
        .then(function () {
        compiler.init();
        return workspace.initAsync();
    })
        .then(function () {
        $("#loading").remove();
        render();
        return workspace.syncAsync();
    })
        .then(function (state) {
        if (state) {
            theEditor.setState(state);
        }
        initSerial();
        initScreenshots();
        initHashchange();
        electron.init();
        return initExtensionsAsync();
    })
        .then(function () { return pxt.winrt.initAsync(importHex); })
        .then(function () { return pxt.winrt.hasActivationProjectAsync(); })
        .then(function (hasWinRTProject) {
        var ent = theEditor.settings.fileHistory.filter(function (e) { return !!workspace.getHeader(e.id); })[0];
        var hd = workspace.getHeaders()[0];
        if (ent)
            hd = workspace.getHeader(ent.id);
        // Only show the start page if there are no initial projects requested
        // (e.g. from the URL hash or from WinRT activation arguments)
        var shouldShowStartPage = !isSandbox && pxt.appTarget.appTheme.useStartPage && !hasWinRTProject && !isProjectRelatedHash(hash);
        if (shouldShowStartPage) {
            theEditor.projects.showInitialStartPage(hd);
            return Promise.resolve();
        }
        if (hash.cmd && handleHash(hash)) {
            return Promise.resolve();
        }
        if (hasWinRTProject) {
            return pxt.winrt.loadActivationProject();
        }
        // default handlers
        if (hd)
            return theEditor.loadHeaderAsync(hd, null);
        else
            theEditor.newProject();
        return Promise.resolve();
    })
        .then(function () { return workspace.importLegacyScriptsAsync(); })
        .done(function () { });
    document.addEventListener("visibilitychange", function (ev) {
        if (theEditor)
            theEditor.updateVisibility();
    });
    window.addEventListener("unload", function (ev) {
        if (theEditor)
            theEditor.saveSettings();
    });
    window.addEventListener("resize", function (ev) {
        if (theEditor && theEditor.editor)
            theEditor.editor.resize(ev);
    }, false);
    var ipcRenderer = window.ipcRenderer;
    if (ipcRenderer)
        ipcRenderer.on('responseFromApp', function (event, message) {
            // IPC renderer sends a string, we need to convert to an object to send to the simulator iframe
            try {
                simulator.driver.postMessage(JSON.parse(message));
            }
            catch (e) {
            }
        });
    window.addEventListener("message", function (ev) {
        var m = ev.data;
        if (!m) {
            return;
        }
        if (ev.data.__proxy == "parent") {
            pxt.debug("received parent proxy message" + ev.data);
            delete ev.data.__proxy;
            var ipcRenderer_1 = window.ipcRenderer;
            if (ipcRenderer_1)
                ipcRenderer_1.sendToHost("sendToApp", ev.data);
            else if (window.parent && window != window.parent)
                window.parent.postMessage(ev.data, "*");
        }
        if (m.type == "tutorial" || m.type == "popoutcomplete") {
            if (theEditor && theEditor.editor)
                theEditor.handleMessage(m);
        }
        if (m.type === "sidedocready" && Cloud.isLocalHost() && Cloud.localToken) {
            container.SideDocs.notify({
                type: "localtoken",
                localToken: Cloud.localToken
            });
            tutorial.TutorialContent.notify({
                type: "localtoken",
                localToken: Cloud.localToken
            });
        }
    }, false);
});

},{"./appcache":2,"./blocks":4,"./cmds":7,"./compiler":9,"./container":10,"./core":11,"./data":12,"./draganddrop":14,"./editortoolbar":15,"./electron":16,"./filelist":17,"./hidbridge":20,"./lang":22,"./logview":23,"./make":24,"./monaco":26,"./monacoSnippets":27,"./package":28,"./projects":29,"./pxtjson":30,"./screenshot":31,"./scriptsearch":32,"./share":33,"./simulator":34,"./sounds":35,"./sui":37,"./tdlegacy":38,"./toolbox":39,"./tutorial":40,"./workspace":41,"marked":110,"react":267,"react-dom":138}],2:[function(require,module,exports){
"use strict";
var core = require("./core");
function init(hash) {
    var appCache = window.applicationCache;
    appCache.addEventListener('updateready', function () {
        core.infoNotification(lf("Update download complete. Reloading... "));
        setTimeout(function () {
            // On embedded pages, preserve the loaded project
            if (pxt.BrowserUtils.isIFrame() && hash.cmd === "pub") {
                location.replace(location.origin + ("/#pub:" + hash.arg));
            }
            else {
                location.reload();
            }
        }, 5000);
    }, false);
}
exports.init = init;

},{"./core":11}],3:[function(require,module,exports){
"use strict";
var _context; // AudioContext
function context() {
    if (!_context)
        _context = freshContext();
    return _context;
}
function freshContext() {
    window.AudioContext = window.AudioContext || window.webkitAudioContext;
    if (window.AudioContext) {
        try {
            // this call might crash.
            // SyntaxError: audio resources unavailable for AudioContext construction
            return new window.AudioContext();
        }
        catch (e) { }
    }
    return undefined;
}
function play(buffer, volume) {
    if (volume === void 0) { volume = 1; }
    if (!buffer)
        return;
    var ctx = context();
    if (!ctx)
        return;
    var source = ctx.createBufferSource();
    source.buffer = buffer;
    var gain = ctx.createGain();
    gain.gain.value = volume;
    source.connect(gain);
    gain.connect(ctx.destination);
    source.start(0);
}
exports.play = play;
function loadAsync(buffer) {
    var ctx = context();
    return new Promise(function (resolve, reject) {
        ctx.decodeAudioData(buffer, function (b) { return resolve(b); }, function () { resolve(undefined); });
    });
}
exports.loadAsync = loadAsync;

},{}],4:[function(require,module,exports){
/// <reference path="../../localtypings/blockly.d.ts" />
/// <reference path="../../typings/globals/jquery/index.d.ts" />
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var React = require("react");
var pkg = require("./package");
var core = require("./core");
var srceditor = require("./srceditor");
var compiler = require("./compiler");
var baseToolbox = require("./toolbox");
var CategoryMode = pxt.blocks.CategoryMode;
var Util = pxt.Util;
var lf = Util.lf;
var iface;
var Editor = (function (_super) {
    __extends(Editor, _super);
    function Editor() {
        _super.apply(this, arguments);
        this.isFirstBlocklyLoad = true;
        this.showToolboxCategories = CategoryMode.Basic;
    }
    Editor.prototype.setVisible = function (v) {
        _super.prototype.setVisible.call(this, v);
        this.isVisible = v;
        var classes = '.blocklyToolboxDiv, .blocklyWidgetDiv, .blocklyToolboxDiv';
        if (this.isVisible) {
            $(classes).show();
            // Fire a resize event since the toolbox may have changed width and height.
            this.parent.fireResize();
        }
        else
            $(classes).hide();
    };
    Editor.prototype.saveToTypeScript = function () {
        var _this = this;
        if (!this.typeScriptSaveable)
            return Promise.resolve('');
        try {
            return pxt.blocks.compileAsync(this.editor, this.blockInfo)
                .then(function (compilationResult) {
                _this.compilationResult = compilationResult;
                pxt.tickActivity("blocks.compile");
                return _this.compilationResult.source;
            });
        }
        catch (e) {
            pxt.reportException(e);
            core.errorNotification(lf("Sorry, we were not able to convert this program."));
            return Promise.resolve('');
        }
    };
    Editor.prototype.updateBlocksInfo = function (bi) {
        this.blockInfo = bi;
        this.refreshToolbox();
    };
    Editor.prototype.domUpdate = function () {
        var _this = this;
        if (this.delayLoadXml) {
            if (this.loadingXml)
                return;
            this.loadingXml = true;
            var loading_1 = document.createElement("div");
            loading_1.className = "ui inverted loading";
            var editorArea = document.getElementById('blocksArea');
            var editorDiv_1 = document.getElementById("blocksEditor");
            editorDiv_1.appendChild(loading_1);
            this.loadingXmlPromise = compiler.getBlocksAsync()
                .finally(function () { _this.loadingXml = false; })
                .then(function (bi) {
                _this.blockInfo = bi;
                var showSearch = true;
                var toolbox = _this.getDefaultToolbox(_this.showToolboxCategories);
                // Search needs a toolbox with ALL blocks
                var tbAll;
                if (_this.showToolboxCategories !== CategoryMode.All) {
                    tbAll = pxt.blocks.initBlocks(_this.blockInfo, toolbox, CategoryMode.All, _this.filters);
                }
                var tb = pxt.blocks.initBlocks(_this.blockInfo, toolbox, _this.showToolboxCategories, _this.filters);
                _this.updateToolbox(tb, _this.showToolboxCategories);
                if (_this.showToolboxCategories !== CategoryMode.None && showSearch) {
                    pxt.blocks.initSearch(_this.editor, tb, tbAll || tb, function (searchFor) { return compiler.apiSearchAsync(searchFor)
                        .then(function (fns) { return fns; }); }, function (searchTb) { return _this.updateToolbox(searchTb, _this.showToolboxCategories, true); });
                }
                pxt.blocks.initFlyouts(_this.editor);
                var xml = _this.delayLoadXml;
                _this.delayLoadXml = undefined;
                _this.loadBlockly(xml);
                _this.resize();
                Blockly.svgResize(_this.editor);
                _this.isFirstBlocklyLoad = false;
            }).finally(function () {
                editorDiv_1.removeChild(loading_1);
            });
            if (this.isFirstBlocklyLoad) {
                core.showLoadingAsync(lf("loading..."), this.loadingXmlPromise).done();
            }
            else {
                this.loadingXmlPromise.done();
            }
            this.loadingXmlPromise = null;
        }
    };
    Editor.prototype.saveBlockly = function () {
        // make sure we don't return an empty document before we get started
        // otherwise it may get saved and we're in trouble
        if (this.delayLoadXml)
            return this.delayLoadXml;
        return this.serializeBlocks();
    };
    Editor.prototype.serializeBlocks = function (normalize) {
        var xml = pxt.blocks.saveWorkspaceXml(this.editor);
        // strip out id, x, y attributes
        if (normalize)
            xml = xml.replace(/(x|y|id)="[^"]*"/g, '');
        pxt.debug(xml);
        return xml;
    };
    Editor.prototype.loadBlockly = function (s) {
        if (this.serializeBlocks() == s) {
            this.typeScriptSaveable = true;
            pxt.debug('blocks already loaded...');
            return false;
        }
        this.typeScriptSaveable = false;
        this.editor.clear();
        try {
            var text = pxt.blocks.importXml(s || "<block type=\"" + ts.pxtc.ON_START_TYPE + "\"></block>", this.blockInfo, true);
            var xml = Blockly.Xml.textToDom(text);
            Blockly.Xml.domToWorkspace(xml, this.editor);
            this.initLayout();
            this.editor.clearUndo();
            this.reportDeprecatedBlocks();
            this.typeScriptSaveable = true;
        }
        catch (e) {
            pxt.log(e);
            this.editor.clear();
            this.switchToTypeScript();
            this.changeCallback();
            return false;
        }
        this.changeCallback();
        return true;
    };
    Editor.prototype.initLayout = function () {
        var minX;
        var minY;
        var needsLayout = false;
        this.editor.getTopBlocks(false).forEach(function (b) {
            var tp = b.getBoundingRectangle().topLeft;
            if (minX === undefined || tp.x < minX) {
                minX = tp.x;
            }
            if (minY === undefined || tp.y < minY) {
                minY = tp.y;
            }
            needsLayout = needsLayout || (b.type != ts.pxtc.ON_START_TYPE && tp.x == 0 && tp.y == 0);
        });
        if (needsLayout) {
            // If the blocks file has no location info (e.g. it's from the decompiler), format the code.
            pxt.blocks.layout.flow(this.editor, { useViewWidth: true });
        }
        else {
            // Otherwise translate the blocks so that they are positioned on the top left
            this.editor.getTopBlocks(false).forEach(function (b) { return b.moveBy(-minX, -minY); });
            this.editor.scrollX = 10;
            this.editor.scrollY = 10;
            // Forces scroll to take effect
            this.editor.resizeContents();
        }
    };
    Editor.prototype.initPrompts = function () {
        // Overriding blockly prompts to use semantic modals
        /**
         * Wrapper to window.alert() that app developers may override to
         * provide alternatives to the modal browser window.
         * @param {string} message The message to display to the user.
         * @param {function()=} opt_callback The callback when the alert is dismissed.
         */
        Blockly.alert = function (message, opt_callback) {
            return core.dialogAsync({
                hideCancel: true,
                header: lf("Alert"),
                body: message,
                size: "small"
            }).then(function () {
                if (opt_callback) {
                    opt_callback();
                }
            });
        };
        /**
         * Wrapper to window.confirm() that app developers may override to
         * provide alternatives to the modal browser window.
         * @param {string} message The message to display to the user.
         * @param {!function(boolean)} callback The callback for handling user response.
         */
        Blockly.confirm = function (message, callback) {
            return core.confirmAsync({
                header: lf("Confirm"),
                body: message,
                agreeLbl: lf("Yes"),
                agreeClass: "cancel",
                agreeIcon: "cancel",
                disagreeLbl: lf("No"),
                disagreeClass: "positive",
                disagreeIcon: "checkmark",
                size: "small"
            }).then(function (b) {
                callback(b == 1);
            });
        };
        /**
         * Wrapper to window.prompt() that app developers may override to provide
         * alternatives to the modal browser window. Built-in browser prompts are
         * often used for better text input experience on mobile device. We strongly
         * recommend testing mobile when overriding this.
         * @param {string} message The message to display to the user.
         * @param {string} defaultValue The value to initialize the prompt with.
         * @param {!function(string)} callback The callback for handling user reponse.
         */
        Blockly.prompt = function (message, defaultValue, callback) {
            return core.promptAsync({
                header: message,
                defaultValue: defaultValue,
                agreeLbl: lf("Ok"),
                disagreeLbl: lf("Cancel"),
                size: "small"
            }).then(function (value) {
                callback(value);
            });
        };
    };
    Editor.prototype.reportDeprecatedBlocks = function () {
        var deprecatedMap = {};
        var deprecatedBlocksFound = false;
        this.blockInfo.blocks.forEach(function (symbolInfo) {
            if (symbolInfo.attributes.deprecated) {
                deprecatedMap[symbolInfo.attributes.blockId] = 0;
            }
        });
        this.editor.getAllBlocks().forEach(function (block) {
            if (deprecatedMap[block.type] >= 0) {
                deprecatedMap[block.type]++;
                deprecatedBlocksFound = true;
            }
        });
        for (var block in deprecatedMap) {
            if (deprecatedMap[block] === 0) {
                delete deprecatedMap[block];
            }
        }
        if (deprecatedBlocksFound) {
            pxt.tickEvent("blocks.usingDeprecated", deprecatedMap);
        }
    };
    Editor.prototype.contentSize = function () {
        return this.editor ? pxt.blocks.blocksMetrics(this.editor) : undefined;
    };
    /**
     * Takes the XML definition of the block that will be shown on the help card and modifies the XML
     * so that the field names are updated to match any field names of dropdowns on the selected block
     */
    Editor.prototype.updateFields = function (originalXML, newFieldValues, mutation) {
        var parser = new DOMParser();
        var doc = parser.parseFromString(originalXML, "application/xml");
        var blocks = doc.getElementsByTagName("block");
        if (blocks.length >= 1) {
            //Setting innerText doesn't work if there are no children on the node
            var setInnerText = function (c, newValue) {
                //Remove any existing children
                while (c.firstChild) {
                    c.removeChild(c.firstChild);
                }
                var tn = doc.createTextNode(newValue);
                c.appendChild(tn);
            };
            var block = blocks[0];
            if (newFieldValues) {
                //Depending on the source, the nodeName may be capitalised
                var fieldNodes = Array.prototype.filter.call(block.childNodes, function (c) { return c.nodeName == 'field' || c.nodeName == 'FIELD'; });
                for (var i = 0; i < fieldNodes.length; i++) {
                    if (newFieldValues.hasOwnProperty(fieldNodes[i].getAttribute('name'))) {
                        setInnerText(fieldNodes[i], newFieldValues[fieldNodes[i].getAttribute('name')]);
                        delete newFieldValues[fieldNodes[i].getAttribute('name')];
                    }
                }
                //Now that existing field values have been reset, we can create new field values as appropriate
                for (var p in newFieldValues) {
                    var c = doc.createElement('field');
                    c.setAttribute('name', p);
                    setInnerText(c, newFieldValues[p]);
                    block.appendChild(c);
                }
            }
            else if (mutation) {
                var existingMutation = Array.prototype.filter.call(block.childNodes, function (c) { return c.nodeName == 'mutation' || c.nodeName == 'MUTATION'; });
                if (existingMutation.length) {
                    block.replaceChild(mutation, existingMutation[0]);
                }
                else {
                    block.appendChild(mutation);
                }
            }
            var serializer = new XMLSerializer();
            return serializer.serializeToString(doc);
        }
        else {
            return originalXML;
        }
    };
    Editor.prototype.isIncomplete = function () {
        return this.editor ? this.editor.isDragging() : false;
    };
    Editor.prototype.prepare = function () {
        var _this = this;
        pxt.blocks.openHelpUrl = function (url) {
            pxt.tickEvent("blocks.help", { url: url });
            var m = /^\/pkg\/([^#]+)#(.+)$/.exec(url);
            if (m) {
                var dep = pkg.mainPkg.deps[m[1]];
                if (dep && dep.verProtocol() == "github") {
                    // rewrite url to point to current endpoint
                    url = "/pkg/" + dep.verArgument().replace(/#.*$/, '') + "#" + m[2];
                    window.open(url, m[1]);
                    return; // TODO support serving package docs in docs frame.
                }
            }
            ;
            if (/^\//.test(url))
                _this.parent.setSideDoc(url);
            else
                window.open(url, 'docs');
        };
        this.prepareBlockly();
        this.isReady = true;
    };
    Editor.prototype.prepareBlockly = function (showCategories) {
        var _this = this;
        if (showCategories === void 0) { showCategories = this.showToolboxCategories; }
        var blocklyDiv = document.getElementById('blocksEditor');
        blocklyDiv.innerHTML = '';
        var blocklyOptions = this.getBlocklyOptions(showCategories);
        Util.jsonMergeFrom(blocklyOptions, pxt.appTarget.appTheme.blocklyOptions || {});
        this.editor = Blockly.inject(blocklyDiv, blocklyOptions);
        this.editor.addChangeListener(function (ev) {
            Blockly.Events.disableOrphans(ev);
            if (ev.type != 'ui') {
                _this.changeCallback();
            }
            if (ev.type == 'create') {
                var lastCategory = _this.editor.toolbox_ ?
                    (_this.editor.toolbox_.lastCategory_ ?
                        _this.editor.toolbox_.lastCategory_.element_.innerText.trim()
                        : 'unknown')
                    : 'flyout';
                var blockId = ev.xml.getAttribute('type');
                pxt.tickActivity("blocks.create", "blocks.create." + blockId);
                if (ev.xml.tagName == 'SHADOW')
                    _this.cleanUpShadowBlocks();
                _this.parent.setState({ hideEditorFloats: false });
            }
            if (ev.type == 'ui') {
                if (ev.element == 'category') {
                    var toolboxVisible = !!ev.newValue;
                    _this.parent.setState({ hideEditorFloats: toolboxVisible });
                    if (ev.newValue == lf("{id:category}Add Package")) {
                        _this.editor.toolbox_.clearSelection();
                        _this.parent.addPackage();
                    }
                    else if (ev.newValue == lf("{id:category}Advanced")) {
                        if (_this.showToolboxCategories === CategoryMode.All) {
                            _this.showToolboxCategories = CategoryMode.Basic;
                        }
                        else if (_this.showToolboxCategories === CategoryMode.Basic) {
                            _this.showToolboxCategories = CategoryMode.All;
                        }
                        _this.refreshToolbox();
                    }
                }
                else if (ev.element == 'commentOpen'
                    || ev.element == 'warningOpen') {
                    /*
                     * We override the default selection behavior so that when a block is selected, its
                     * comment is expanded. However, if a user selects a block by clicking on its comment
                     * icon (the blue question mark), there is a chance that the comment will be expanded
                     * and immediately collapse again because the icon click toggled the state. This hack
                     * prevents two events caused by the same click from opening and then closing a comment
                     */
                    if (ev.group) {
                        // newValue is true if the comment has been expanded
                        if (ev.newValue) {
                            _this.selectedEventGroup = ev.group;
                        }
                        else if (ev.group == _this.selectedEventGroup && _this.currentCommentOrWarning) {
                            _this.currentCommentOrWarning.setVisible(true);
                            _this.selectedEventGroup = undefined;
                        }
                    }
                }
                else if (ev.element == 'selected') {
                    if (_this.currentCommentOrWarning) {
                        _this.currentCommentOrWarning.setVisible(false);
                    }
                    var selected = Blockly.selected;
                    if (selected && selected.warning && typeof (selected.warning) !== "string") {
                        selected.warning.setVisible(true);
                        _this.currentCommentOrWarning = selected.warning;
                    }
                    else if (selected && selected.comment && typeof (selected.comment) !== "string") {
                        selected.comment.setVisible(true);
                        _this.currentCommentOrWarning = selected.comment;
                    }
                }
            }
        });
        this.initPrompts();
        this.resize();
    };
    Editor.prototype.resize = function (e) {
        var blocklyArea = document.getElementById('blocksArea');
        var blocklyDiv = document.getElementById('blocksEditor');
        // Position blocklyDiv over blocklyArea.
        if (blocklyArea && this.editor) {
            blocklyDiv.style.width = blocklyArea.offsetWidth + 'px';
            blocklyDiv.style.height = blocklyArea.offsetHeight + 'px';
            Blockly.svgResize(this.editor);
        }
    };
    Editor.prototype.hasUndo = function () {
        return this.editor ? this.editor.undoStack_.length != 0 : false;
    };
    Editor.prototype.undo = function () {
        if (!this.editor)
            return;
        this.editor.undo();
        this.parent.forceUpdate();
    };
    Editor.prototype.hasRedo = function () {
        return this.editor ? this.editor.redoStack_.length != 0 : false;
    };
    Editor.prototype.redo = function () {
        if (!this.editor)
            return;
        this.editor.undo(true);
        this.parent.forceUpdate();
    };
    Editor.prototype.zoomIn = function () {
        if (!this.editor)
            return;
        this.editor.zoomCenter(1);
    };
    Editor.prototype.zoomOut = function () {
        if (!this.editor)
            return;
        this.editor.zoomCenter(-1);
    };
    Editor.prototype.getId = function () {
        return "blocksArea";
    };
    Editor.prototype.display = function () {
        return (React.createElement("div", null, React.createElement("div", {id: "blocksEditor"})));
    };
    Editor.prototype.getViewState = function () {
        // ZOOM etc
        return {};
    };
    Editor.prototype.setViewState = function (pos) { };
    Editor.prototype.getCurrentSource = function () {
        return this.editor ? this.saveBlockly() : this.currSource;
    };
    Editor.prototype.acceptsFile = function (file) {
        return file.getExtension() == "blocks";
    };
    Editor.prototype.loadFileAsync = function (file) {
        this.currSource = file.content;
        this.typeScriptSaveable = false;
        this.setDiagnostics(file);
        this.delayLoadXml = file.content;
        this.editor.clearUndo();
        if (this.currFile && this.currFile != file) {
            this.filterToolbox(null);
        }
        if (this.parent.state.filters) {
            this.filterToolbox(this.parent.state.filters);
        }
        else {
            this.filters = null;
        }
        this.currFile = file;
        // Clear the search field if a value exists
        var searchField = document.getElementById('blocklySearchInputField');
        if (searchField && searchField.value) {
            searchField.value = '';
        }
        return Promise.resolve();
    };
    Editor.prototype.switchToTypeScript = function () {
        pxt.tickEvent("blocks.switchjavascript");
        this.parent.switchTypeScript();
    };
    Editor.prototype.setDiagnostics = function (file) {
        var _this = this;
        Util.assert(this.editor != undefined); // Guarded
        if (!this.compilationResult || this.delayLoadXml || this.loadingXml)
            return;
        // clear previous warnings on non-disabled blocks
        this.editor.getAllBlocks().filter(function (b) { return !b.disabled; }).forEach(function (b) { return b.setWarningText(null); });
        var tsfile = file.epkg.files[file.getVirtualFileName()];
        if (!tsfile || !tsfile.diagnostics)
            return;
        // only show errors
        var diags = tsfile.diagnostics.filter(function (d) { return d.category == ts.pxtc.DiagnosticCategory.Error; });
        var sourceMap = this.compilationResult.sourceMap;
        diags.filter(function (diag) { return diag.category == ts.pxtc.DiagnosticCategory.Error; }).forEach(function (diag) {
            var bid = pxt.blocks.findBlockId(sourceMap, { start: diag.line, length: 0 });
            if (bid) {
                var b = _this.editor.getBlockById(bid);
                if (b) {
                    var txt = ts.pxtc.flattenDiagnosticMessageText(diag.messageText, "\n");
                    b.setWarningText(txt);
                }
            }
        });
    };
    Editor.prototype.highlightStatement = function (brk) {
        if (!this.compilationResult || this.delayLoadXml || this.loadingXml)
            return;
        if (brk) {
            var bid = pxt.blocks.findBlockId(this.compilationResult.sourceMap, { start: brk.line, length: brk.endLine - brk.line });
            if (bid) {
                this.editor.highlightBlock(bid);
            }
        }
    };
    Editor.prototype.clearHighlightedStatements = function () {
        this.editor.highlightBlock(null);
    };
    Editor.prototype.openTypeScript = function () {
        pxt.tickEvent("blocks.showjavascript");
        this.parent.openTypeScriptAsync().done();
    };
    Editor.prototype.cleanUpShadowBlocks = function () {
        var blocks = this.editor.getTopBlocks(false);
        blocks.filter(function (b) { return b.isShadow_; }).forEach(function (b) { return b.dispose(false); });
    };
    Editor.prototype.getBlocklyOptions = function (showCategories) {
        if (showCategories === void 0) { showCategories = this.showToolboxCategories; }
        var readOnly = pxt.shell.isReadOnly();
        var toolbox = showCategories !== CategoryMode.None ?
            document.getElementById('blocklyToolboxDefinitionCategory')
            : document.getElementById('blocklyToolboxDefinitionFlyout');
        var blocklyOptions = {
            toolbox: readOnly ? undefined : toolbox,
            scrollbars: true,
            media: pxt.webConfig.commitCdnUrl + "blockly/media/",
            sound: true,
            trashcan: false,
            collapse: false,
            comments: true,
            disable: false,
            readOnly: readOnly,
            toolboxOptions: {
                colour: pxt.appTarget.appTheme.coloredToolbox,
                inverted: pxt.appTarget.appTheme.invertedToolbox
            },
            zoom: {
                enabled: false,
                controls: false,
                wheel: true,
                maxScale: 2.5,
                minScale: .2,
                scaleSpeed: 1.05,
                startScale: pxt.BrowserUtils.isMobile() ? 1.2 : 1.0
            },
            rtl: Util.isUserLanguageRtl()
        };
        return blocklyOptions;
    };
    Editor.prototype.getDefaultToolbox = function (showCategories) {
        if (showCategories === void 0) { showCategories = this.showToolboxCategories; }
        return showCategories !== CategoryMode.None ?
            baseToolbox.getBaseToolboxDom().documentElement
            : new DOMParser().parseFromString("<xml id=\"blocklyToolboxDefinition\" style=\"display: none\"></xml>", "text/xml").documentElement;
    };
    Editor.prototype.filterToolbox = function (filters, showCategories) {
        if (showCategories === void 0) { showCategories = this.showToolboxCategories; }
        this.filters = filters;
        this.showToolboxCategories = showCategories;
        return this.refreshToolbox();
    };
    Editor.prototype.refreshToolbox = function () {
        if (!this.blockInfo)
            return undefined;
        var toolbox = this.getDefaultToolbox(this.showToolboxCategories);
        var tbAll;
        if (this.showToolboxCategories !== CategoryMode.All) {
            tbAll = pxt.blocks.createToolbox(this.blockInfo, toolbox, CategoryMode.All, this.filters);
        }
        var tb = pxt.blocks.createToolbox(this.blockInfo, toolbox, this.showToolboxCategories, this.filters);
        this.updateToolbox(tb, this.showToolboxCategories);
        pxt.blocks.cachedSearchTb = tb;
        pxt.blocks.cachedSearchTbAll = tbAll || tb;
        return tb;
    };
    Editor.prototype.updateToolbox = function (tb, showCategories, search) {
        if (showCategories === void 0) { showCategories = this.showToolboxCategories; }
        if (search === void 0) { search = false; }
        // no toolbox when readonly
        if (pxt.shell.isReadOnly())
            return;
        pxt.debug('updating toolbox');
        var editor_ = this.editor;
        if ((editor_.toolbox_ && showCategories !== CategoryMode.None) || (editor_.flyout_ && showCategories === CategoryMode.None)) {
            // Toolbox is consistent with current mode, safe to update
            var tbString = new XMLSerializer().serializeToString(tb);
            if (tbString == this.cachedToolbox)
                return;
            this.cachedToolbox = tbString;
            this.editor.updateToolbox(tb);
            // We need to set the toolbox's selected item to null so that it doesn't
            // try to send key events to a category that no longer exists (exception)
            if (!search && editor_.toolbox_ && editor_.toolbox_.tree_) {
                editor_.toolbox_.tree_.setSelectedItem(null);
            }
        }
        else {
            // Toolbox mode is different, need to refresh.
            this.delayLoadXml = this.getCurrentSource();
            this.editor = undefined;
            this.loadingXml = false;
            if (this.loadingXmlPromise) {
                this.loadingXmlPromise.cancel();
                this.loadingXmlPromise = null;
            }
            this.prepareBlockly(showCategories);
            this.domUpdate();
            this.editor.scrollCenter();
        }
    };
    return Editor;
}(srceditor.Editor));
exports.Editor = Editor;

},{"./compiler":9,"./core":11,"./package":28,"./srceditor":36,"./toolbox":39,"react":267}],5:[function(require,module,exports){
/// <reference path="../../typings/globals/jquery/index.d.ts" />
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var React = require("react");
var ReactDOM = require("react-dom");
var BlocksPreview = (function (_super) {
    __extends(BlocksPreview, _super);
    function BlocksPreview(props) {
        _super.call(this, props);
        this.state = {};
    }
    BlocksPreview.prototype.renderSvg = function () {
        var el = $(ReactDOM.findDOMNode(this));
        var svg = pxt.blocks.render(this.props.xml);
        el.children().remove();
        el.append(svg);
    };
    BlocksPreview.prototype.componentDidMount = function () {
        this.renderSvg();
    };
    BlocksPreview.prototype.componentDidUpdate = function () {
        this.renderSvg();
    };
    BlocksPreview.prototype.render = function () {
        return (React.createElement("div", {style: { width: "100%", minHeight: "10em", direction: "ltr" }}));
    };
    return BlocksPreview;
}(React.Component));
exports.BlocksPreview = BlocksPreview;

},{"react":267,"react-dom":138}],6:[function(require,module,exports){
"use strict";
var db = require("./db");
var core = require("./core");
var pkg = require("./package");
var data = require("./data");
var ws = require("./workspace");
var headers = new db.Table("header");
var texts = new db.Table("text");
var U = pxt.Util;
var Cloud = pxt.Cloud;
var lf = U.lf;
var allScripts = [];
function lookup(id) {
    return allScripts.filter(function (x) { return x.id == id; })[0];
}
function getHeaders() {
    return allScripts.map(function (e) { return e.header; });
}
function getHeader(id) {
    var e = lookup(id);
    if (e && !e.header.isDeleted)
        return e.header;
    return null;
}
function initAsync(target) {
    // TODO getAllAsync aware of target?
    return headers.getAllAsync().then(function (h) {
        allScripts = h
            .filter(function (hh) {
            if (!hh.target)
                hh.target = "microbit";
            return hh.target == pxt.appTarget.id;
        })
            .map(function (hh) {
            return {
                id: hh.id,
                header: hh,
                text: null
            };
        });
    });
}
function fetchTextAsync(e) {
    return texts.getAsync(e.id)
        .then(function (resp) {
        if (!e.text) {
            // otherwise we were beaten to it
            e.text = ws.fixupFileNames(resp.files);
        }
        e.textRev = resp._rev;
        return e.text;
    });
}
var headerQ = new U.PromiseQueue();
function getTextAsync(id) {
    var e = lookup(id);
    if (!e)
        return Promise.resolve(null);
    if (e.text)
        return Promise.resolve(e.text);
    return headerQ.enqueue(id, function () { return fetchTextAsync(e); });
}
function fetchTextRevAsync(e) {
    if (e.textRev)
        return Promise.resolve();
    return fetchTextAsync(e).then(function () { }, function (err) { });
}
function saveCoreAsync(h, text) {
    if (h.temporary)
        return Promise.resolve();
    var e = lookup(h.id);
    U.assert(e.header === h);
    if (text) {
        h.saveId = null;
        e.textNeedsSave = true;
        e.text = text;
    }
    return headerQ.enqueue(h.id, function () {
        return (!text ? Promise.resolve() :
            fetchTextRevAsync(e)
                .then(function () {
                e.textNeedsSave = false;
                return texts.setAsync({
                    id: e.id,
                    files: e.text,
                    _rev: e.textRev
                }).then(function (rev) {
                    e.textRev = rev;
                });
            }))
            .then(function () { return headers.setAsync(e.header); })
            .then(function (rev) {
            h._rev = rev;
            data.invalidate("header:" + h.id);
            data.invalidate("header:*");
            if (text) {
                data.invalidate("text:" + h.id);
                h.saveId = null;
            }
        });
    });
}
function saveAsync(h, text) {
    return saveCoreAsync(h, text);
}
function installAsync(h0, text) {
    var h = h0;
    h.id = U.guidGen();
    h.recentUse = U.nowSeconds();
    h.modificationTime = h.recentUse;
    h.target = pxt.appTarget.id;
    var e = {
        id: h.id,
        header: h,
        text: text,
    };
    allScripts.push(e);
    return saveCoreAsync(h, text)
        .then(function () { return h; });
}
function isProject(h) {
    return /prj$/.test(h.editor);
}
function saveToCloudAsync(h) {
    if (!Cloud.isLoggedIn())
        return Promise.resolve();
    return syncOneUpAsync(h);
}
function syncOneUpAsync(h) {
    var saveId = {};
    var e = lookup(h.id);
    return getTextAsync(h.id)
        .then(function () {
        var scr = "";
        var files = e.text;
        if (isProject(h))
            scr = JSON.stringify(files);
        else
            scr = files[Object.keys(files)[0]] || "";
        var body = {
            guid: h.id,
            name: h.name,
            scriptId: h.pubId,
            scriptVersion: { time: h.modificationTime, baseSnapshot: "*" },
            meta: JSON.stringify(h.meta),
            status: h.pubCurrent ? "published" : "unpublished",
            recentUse: h.recentUse,
            editor: h.editor,
            script: scr,
            target: pxt.appTarget.id
        };
        pxt.debug("sync up " + h.id + "; " + body.script.length + " chars");
        h.saveId = saveId;
        return Cloud.privatePostAsync("me/installed", { bodies: [body] });
    })
        .then(function (resp) {
        var chd = resp.headers[0];
        h.blobId = chd.scriptVersion.baseSnapshot;
        if (h.saveId === saveId)
            h.blobCurrent = true;
        return saveCoreAsync(h);
    });
}
function syncAsync() {
    var numUp = 0;
    var numDown = 0;
    var blobConatiner = "";
    var updated = {};
    if (!Cloud.hasAccessToken())
        return Promise.resolve(undefined);
    function uninstallAsync(h) {
        pxt.debug("uninstall local " + h.id);
        var e = lookup(h.id);
        var idx = allScripts.indexOf(e);
        U.assert(idx >= 0);
        allScripts.splice(idx, 1);
        h.isDeleted = true;
        return headerQ.enqueue(h.id, function () {
            return headers.deleteAsync(h)
                .then(function () { return fetchTextRevAsync(e); })
                .then(function () { return texts.deleteAsync({ id: h.id, _rev: e.textRev }); });
        });
    }
    function syncDownAsync(header0, cloudHeader) {
        if (cloudHeader.status == "deleted") {
            if (!header0)
                return Promise.resolve();
            else
                return uninstallAsync(header0);
        }
        var header = header0;
        if (!header) {
            header = {
                id: cloudHeader.guid
            };
        }
        numDown++;
        U.assert(header.id == cloudHeader.guid);
        var blobId = cloudHeader.scriptVersion.baseSnapshot;
        pxt.debug("sync down " + header.id + " - " + blobId);
        return U.httpGetJsonAsync(blobConatiner + blobId)
            .catch(core.handleNetworkError)
            .then(function (resp) {
            U.assert(resp.guid == header.id);
            header.blobCurrent = true;
            header.blobId = blobId;
            header.modificationTime = cloudHeader.scriptVersion.time;
            header.editor = resp.editor;
            header.name = resp.name;
            var files = { "_default_": resp.script };
            if (isProject(header))
                files = JSON.parse(resp.script);
            header.recentUse = cloudHeader.recentUse;
            delete header.isDeleted;
            header.pubId = resp.scriptId;
            header.pubCurrent = (resp.status == "published");
            header.saveId = null;
            header.target = resp.target;
            if (!header0)
                allScripts.push({
                    header: header,
                    text: null,
                    id: header.id
                });
            updated[header.id] = 1;
            return saveCoreAsync(header, files);
        })
            .then(function () { return progress(--numDown); });
    }
    function progressMsg(m) {
        core.infoNotification(m);
    }
    function progress(dummy) {
        var msg = "";
        if (numDown == 0 && numUp == 0)
            msg = lf("All synced");
        else {
            msg = lf("Syncing") + " (";
            if (numDown)
                msg += lf("{0} down", numDown);
            if (numUp)
                msg += (numDown ? ", " : "") + lf("{0} up", numUp);
            msg += ")";
        }
        progressMsg(msg);
    }
    function syncUpAsync(h) {
        numUp++;
        return syncOneUpAsync(h)
            .then(function () { return progress(--numUp); });
    }
    function syncDeleteAsync(h) {
        var body = {
            guid: h.id,
            status: "deleted",
            scriptVersion: { time: U.nowSeconds(), baseSnapshot: "*" }
        };
        return Cloud.privatePostAsync("me/installed", { bodies: [body] })
            .then(function () { return uninstallAsync(h); });
    }
    return Cloud.privateGetAsync("me/installed?format=short")
        .then(function (resp) {
        blobConatiner = resp.blobcontainer;
        var cloudHeaders = U.toDictionary(resp.headers, function (h) { return h.guid; });
        var existingHeaders = U.toDictionary(allScripts, function (h) { return h.id; });
        var waitFor = allScripts.map(function (e) {
            var hd = e.header;
            if (cloudHeaders.hasOwnProperty(hd.id)) {
                var chd = cloudHeaders[hd.id];
                if (hd.isDeleted)
                    return syncDeleteAsync(hd);
                if (chd.scriptVersion.baseSnapshot == hd.blobId) {
                    if (hd.blobCurrent) {
                        if (hd.recentUse != chd.recentUse) {
                            hd.recentUse = chd.recentUse;
                            return saveCoreAsync(hd);
                        }
                        else {
                            // nothing to do
                            return Promise.resolve();
                        }
                    }
                    else {
                        return syncUpAsync(hd);
                    }
                }
                else {
                    if (hd.blobCurrent) {
                        return syncDownAsync(hd, chd);
                    }
                    else {
                        return syncUpAsync(hd);
                    }
                }
            }
            else {
                if (hd.blobId)
                    // this has been pushed once to the cloud - uninstall wins
                    return uninstallAsync(hd);
                else
                    // never pushed before
                    return syncUpAsync(hd);
            }
        });
        waitFor = waitFor.concat(resp.headers.filter(function (h) { return !existingHeaders[h.guid]; }).map(function (h) { return syncDownAsync(null, h); }));
        progress(0);
        return Promise.all(waitFor);
    })
        .then(function () { return progressMsg(lf("Syncing done")); })
        .then(function () { return pkg.notifySyncDone(updated); })
        .then(function () { return undefined; })
        .catch(core.handleNetworkError);
}
function resetAsync() {
    return db.destroyAsync()
        .then(function () {
        pxt.storage.clearLocal();
        data.clearCache();
    });
}
function importLegacyScriptsAsync() {
    var key = 'legacyScriptsImported';
    var legacyDomain = pxt.appTarget.appTheme.legacyDomain;
    if (!legacyDomain || !pxt.webConfig.targetUrl || !!pxt.storage.getLocal(key))
        return Promise.resolve();
    var targetDomain = pxt.webConfig.targetUrl.replace(/^https:\/\//i, '');
    if (legacyDomain == targetDomain)
        return Promise.resolve(); // nothing to do
    if (window.applicationCache.status == window.applicationCache.DOWNLOADING
        || window.applicationCache.status == window.applicationCache.UPDATEREADY) {
        pxt.debug('import skipped, app cached updating');
        return Promise.resolve();
    }
    pxt.debug('injecting import iframe');
    var frame = document.createElement("iframe");
    function clean(clear) {
        if (frame) {
            pxt.debug('cleaning import iframe');
            window.removeEventListener('message', receiveMessage, false);
            if (clear) {
                pxt.debug("sending clear command");
                frame.contentWindow.postMessage({
                    type: "transfer",
                    action: "clear"
                }, "https://" + legacyDomain);
            }
            var temp_1 = frame;
            setTimeout(function () { return document.documentElement.removeChild(temp_1); }, 2000);
            frame = undefined;
        }
    }
    function pushProjectAsync(dbdata) {
        if (!dbdata.header.length) {
            pxt.log('done importing scripts');
            pxt.storage.setLocal(key, '1');
            clean(true);
            return Promise.resolve();
        }
        var hd = dbdata.header.pop();
        var td = dbdata.text.pop();
        var text = td.files;
        delete hd._id;
        delete hd._rev;
        delete hd.id;
        pxt.log("importing " + hd.name);
        return installAsync(hd, text)
            .then(function () { return pushProjectAsync(dbdata); });
    }
    function receiveMessage(ev) {
        if (ev.data && ev.data.type == 'transfer' && ev.data.action == 'export' && ev.data.data) {
            var dbdata = ev.data.data;
            pxt.debug("received " + dbdata.header.length + " projects");
            pushProjectAsync(dbdata).done();
        }
    }
    window.addEventListener('message', receiveMessage, false);
    frame.setAttribute("style", "position:absolute; width:1px; height:1px; right:0em; bottom:0em;");
    var url = "https://" + legacyDomain + "/api/transfer/" + targetDomain + "?storageid=" + pxt.storage.storageId();
    pxt.debug('transfer from ' + url);
    frame.src = url;
    frame.onerror = function (e) {
        pxt.reportException(e);
        clean(false);
    };
    document.documentElement.appendChild(frame);
    return Promise.resolve();
}
exports.provider = {
    getHeaders: getHeaders,
    getHeader: getHeader,
    getTextAsync: getTextAsync,
    initAsync: initAsync,
    saveAsync: saveAsync,
    installAsync: installAsync,
    saveToCloudAsync: saveToCloudAsync,
    syncAsync: syncAsync,
    resetAsync: resetAsync,
    importLegacyScriptsAsync: importLegacyScriptsAsync
};

},{"./core":11,"./data":12,"./db":13,"./package":28,"./workspace":41}],7:[function(require,module,exports){
"use strict";
/// <reference path="../../built/pxtlib.d.ts"/>
var core = require("./core");
var pkg = require("./package");
var hidbridge = require("./hidbridge");
var Cloud = pxt.Cloud;
function browserDownloadAsync(text, name, contentType) {
    var url = pxt.BrowserUtils.browserDownloadBinText(text, name, contentType, undefined, function (e) { return core.errorNotification(lf("saving file failed...")); });
    return Promise.resolve();
}
function browserDownloadDeployCoreAsync(resp) {
    var url = "";
    var fn = "";
    var ext = pxt.outputName().replace(/[^.]*/, "");
    if (!pxt.isOutputText()) {
        var uf2 = resp.outfiles[pxt.outputName()];
        fn = pkg.genFileName(ext);
        pxt.debug('saving ' + fn);
        url = pxt.BrowserUtils.browserDownloadBase64(uf2, fn, "application/x-uf2", resp.userContextWindow, function (e) { return core.errorNotification(lf("saving file failed...")); });
    }
    else {
        var hex = resp.outfiles[pxt.outputName()];
        fn = pkg.genFileName(ext);
        pxt.debug('saving ' + fn);
        url = pxt.BrowserUtils.browserDownloadBinText(hex, fn, pxt.appTarget.compile.hexMimeType, resp.userContextWindow, function (e) { return core.errorNotification(lf("saving file failed...")); });
    }
    if (!resp.success) {
        return core.confirmAsync({
            header: lf("Compilation failed"),
            body: lf("Ooops, looks like there are errors in your program."),
            hideAgree: true,
            disagreeLbl: lf("Close")
        }).then(function () { });
    }
    if (resp.saveOnly || pxt.BrowserUtils.isBrowserDownloadInSameWindow())
        return Promise.resolve();
    else
        return showUploadInstructionsAsync(fn, url);
}
exports.browserDownloadDeployCoreAsync = browserDownloadDeployCoreAsync;
function showUploadInstructionsAsync(fn, url) {
    var boardName = pxt.appTarget.appTheme.boardName || "???";
    var boardDriveName = pxt.appTarget.appTheme.driveDisplayName || pxt.appTarget.compile.driveName || "???";
    // https://msdn.microsoft.com/en-us/library/cc848897.aspx
    // "For security reasons, data URIs are restricted to downloaded resources. 
    // Data URIs cannot be used for navigation, for scripting, or to populate frame or iframe elements"
    var downloadAgain = !pxt.BrowserUtils.isIE() && !pxt.BrowserUtils.isEdge();
    var docUrl = pxt.appTarget.appTheme.usbDocs;
    var saveAs = pxt.BrowserUtils.hasSaveAs();
    var useUF2 = pxt.appTarget.compile.useUF2;
    var body = saveAs ? lf("Click 'Save As' and save the {0} file to the {1} drive to transfer the code into your {2}.", useUF2 ? ".uf2" : ".hex", boardDriveName, boardName)
        : lf("Move the {0} file to the {1} drive to transfer the code into your {2}.", pxt.appTarget.compile.useUF2 ? ".uf2" : ".hex", boardDriveName, boardName);
    if (useUF2)
        body = lf("Press the `reset` button once on the {0}.", boardName) + " " + body;
    return core.confirmAsync({
        header: lf("Download completed..."),
        body: body,
        hideCancel: true,
        hideAgree: true,
        buttons: [downloadAgain ? {
                label: fn,
                icon: "download",
                class: "lightgrey",
                url: url,
                fileName: fn
            } : undefined, docUrl ? {
                label: lf("Help"),
                icon: "help",
                class: "lightgrey",
                url: docUrl
            } : undefined],
        timeout: 10000
    }).then(function () { });
}
function webusbDeployCoreAsync(resp) {
    pxt.debug('webusb deployment...');
    core.infoNotification(lf("Flashing device..."));
    var f = resp.outfiles[pxtc.BINARY_UF2];
    var blocks = pxtc.UF2.parseFile(Util.stringToUint8Array(atob(f)));
    return pxt.usb.initAsync()
        .then(function (dev) { return dev.reflashAsync(blocks); });
}
function hidDeployCoreAsync(resp) {
    pxt.debug('HID deployment...');
    core.infoNotification(lf("Flashing device..."));
    var f = resp.outfiles[pxtc.BINARY_UF2];
    var blocks = pxtc.UF2.parseFile(Util.stringToUint8Array(atob(f)));
    return hidbridge.initAsync()
        .then(function (dev) { return dev.reflashAsync(blocks); });
}
function localhostDeployCoreAsync(resp) {
    pxt.debug('local deployment...');
    core.infoNotification(lf("Uploading .hex file..."));
    var deploy = function () { return Util.requestAsync({
        url: "/api/deploy",
        headers: { "Authorization": Cloud.localToken },
        method: "POST",
        data: resp,
        allowHttpErrors: true // To prevent "Network request failed" warning in case of error. We're not actually doing network requests in localhost scenarios
    }).then(function (r) {
        if (r.statusCode !== 200) {
            core.errorNotification(lf("There was a problem, please try again"));
        }
        else if (r.json["boardCount"] === 0) {
            core.warningNotification(lf("Please connect your {0} to your computer and try again", pxt.appTarget.appTheme.boardName));
        }
    }); };
    return deploy();
}
function initCommandsAsync() {
    pxt.commands.browserDownloadAsync = browserDownloadAsync;
    pxt.commands.saveOnlyAsync = browserDownloadDeployCoreAsync;
    var forceHexDownload = /forceHexDownload/i.test(window.location.href);
    if (/webusb=1/i.test(window.location.href) && pxt.appTarget.compile.useUF2) {
        pxt.commands.deployCoreAsync = webusbDeployCoreAsync;
    }
    else if (pxt.winrt.isWinRT()) {
        if (pxt.appTarget.serial && pxt.appTarget.serial.useHF2) {
            pxt.HF2.mkPacketIOAsync = pxt.winrt.mkPacketIOAsync;
            pxt.commands.deployCoreAsync = hidDeployCoreAsync;
        }
        else {
            if (pxt.appTarget.serial && pxt.appTarget.serial.rawHID) {
                pxt.HF2.mkPacketIOAsync = pxt.winrt.mkPacketIOAsync;
            }
            pxt.commands.deployCoreAsync = pxt.winrt.driveDeployCoreAsync;
        }
        pxt.commands.browserDownloadAsync = pxt.winrt.browserDownloadAsync;
        pxt.commands.saveOnlyAsync = function (resp) {
            return pxt.winrt.saveOnlyAsync(resp)
                .then(function (saved) {
                if (saved) {
                    core.infoNotification(lf("file saved!"));
                }
            })
                .catch(function () { return core.errorNotification(lf("saving file failed...")); });
        };
    }
    else if (hidbridge.shouldUse() && !forceHexDownload) {
        pxt.commands.deployCoreAsync = hidDeployCoreAsync;
    }
    else if (Cloud.isLocalHost() && Cloud.localToken && !forceHexDownload) {
        pxt.commands.deployCoreAsync = localhostDeployCoreAsync;
    }
    else {
        pxt.commands.deployCoreAsync = browserDownloadDeployCoreAsync;
    }
    return Promise.resolve();
}
exports.initCommandsAsync = initCommandsAsync;

},{"./core":11,"./hidbridge":20,"./package":28}],8:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var React = require("react");
var blockspreview = require("./blockspreview");
var lf = pxt.Util.lf;
var repeat = pxt.Util.repeatMap;
var CodeCardView = (function (_super) {
    __extends(CodeCardView, _super);
    function CodeCardView(props) {
        _super.call(this, props);
        this.state = {};
    }
    CodeCardView.prototype.componentDidUpdate = function () {
        $('.ui.embed').embed();
    };
    CodeCardView.prototype.render = function () {
        var card = this.props;
        var color = card.color || "";
        if (!color) {
            if (card.hardware && !card.software)
                color = 'black';
            else if (card.software && !card.hardware)
                color = 'teal';
        }
        var renderMd = function (md) { return md.replace(/`/g, ''); };
        var url = card.url ? /^[^:]+:\/\//.test(card.url) ? card.url : ('/' + card.url.replace(/^\.?\/?/, ''))
            : undefined;
        var sideUrl = url && /^\//.test(url) ? "#doc:" + url : url;
        var className = card.className;
        var cardDiv = React.createElement("div", {className: "ui card " + color + " " + (card.onClick ? "link" : '') + " " + (className ? className : ''), title: card.title, onClick: function (e) { return card.onClick ? card.onClick(e) : undefined; }}, card.header || card.blocks || card.javascript || card.hardware || card.software || card.any ?
            React.createElement("div", {key: "header", className: "ui content " + (card.responsive ? " tall desktop only" : "")}, React.createElement("div", {className: "right floated meta"}, card.any ? (React.createElement("i", {key: "costany", className: "ui grey circular label tiny"}, card.any > 0 ? card.any : null)) : null, repeat(card.blocks, function (k) { return React.createElement("i", {key: "costblocks" + k, className: "puzzle orange icon"}); }), repeat(card.javascript, function (k) { return React.createElement("i", {key: "costjs" + k, className: "align left blue icon"}); }), repeat(card.hardware, function (k) { return React.createElement("i", {key: "costhardware" + k, className: "certificate black icon"}); }), repeat(card.software, function (k) { return React.createElement("i", {key: "costsoftware" + k, className: "square teal icon"}); })), card.header) : null, card.label || card.blocksXml || card.typeScript || card.imageUrl || card.youTubeId ? React.createElement("div", {className: "ui image"}, card.label ? React.createElement("label", {className: "ui orange right ribbon label"}, card.label) : undefined, card.blocksXml ? React.createElement(blockspreview.BlocksPreview, {key: "promoblocks", xml: card.blocksXml}) : undefined, card.typeScript ? React.createElement("pre", {key: "promots"}, card.typeScript) : undefined, card.imageUrl ? React.createElement("div", {className: "ui cardimage", style: { backgroundImage: "url(\"" + card.imageUrl + "\")" }}) : undefined, card.youTubeId ? React.createElement("div", {className: "ui cardimage", style: { backgroundImage: "url(\"https://img.youtube.com/vi/" + card.youTubeId + "/maxresdefault.jpg\")" }}) : undefined) : undefined, card.icon || card.iconContent ?
            React.createElement("div", {className: "ui"}, React.createElement("div", {className: "ui button massive fluid " + card.iconColor + " " + (card.iconContent ? "iconcontent" : "")}, card.icon ? React.createElement("i", {className: "" + ('icon ' + card.icon)}) : undefined, card.iconContent || undefined)) : undefined, card.shortName || card.name || card.description ?
            React.createElement("div", {className: "content"}, card.shortName || card.name ? React.createElement("div", {className: "header"}, card.shortName || card.name) : null, card.time ? React.createElement("div", {className: "meta tall"}, card.time ? React.createElement("span", {key: "date", className: "date"}, pxt.Util.timeSince(card.time)) : null) : undefined, card.description ? React.createElement("div", {className: "description tall"}, renderMd(card.description)) : null) : undefined);
        if (!card.onClick && url) {
            return (React.createElement("div", null, React.createElement("a", {href: url, target: "docs", className: "ui widedesktop hide"}, cardDiv), React.createElement("a", {href: sideUrl, className: "ui widedesktop only"}, cardDiv)));
        }
        else {
            return (cardDiv);
        }
    };
    return CodeCardView;
}(React.Component));
exports.CodeCardView = CodeCardView;

},{"./blockspreview":5,"react":267}],9:[function(require,module,exports){
"use strict";
var pkg = require("./package");
var core = require("./core");
var U = pxt.Util;
var iface;
function init() {
    if (!iface) {
        iface = pxt.worker.makeWebWorker(pxt.webConfig.workerjs);
    }
}
exports.init = init;
function setDiagnostics(diagnostics) {
    var mainPkg = pkg.mainEditorPkg();
    mainPkg.forEachFile(function (f) { return f.diagnostics = []; });
    var output = "";
    var _loop_1 = function(diagnostic) {
        if (diagnostic.fileName) {
            output += (diagnostic.category == ts.pxtc.DiagnosticCategory.Error ? lf("error") : diagnostic.category == ts.pxtc.DiagnosticCategory.Warning ? lf("warning") : lf("message")) + ": " + diagnostic.fileName + "(" + (diagnostic.line + 1) + "," + (diagnostic.column + 1) + "): ";
            var f_1 = mainPkg.filterFiles(function (f) { return f.getTypeScriptName() == diagnostic.fileName; })[0];
            if (f_1)
                f_1.diagnostics.push(diagnostic);
        }
        var category = ts.pxtc.DiagnosticCategory[diagnostic.category].toLowerCase();
        output += category + " TS" + diagnostic.code + ": " + ts.pxtc.flattenDiagnosticMessageText(diagnostic.messageText, "\n") + "\n";
    };
    for (var _i = 0, diagnostics_1 = diagnostics; _i < diagnostics_1.length; _i++) {
        var diagnostic = diagnostics_1[_i];
        _loop_1(diagnostic);
    }
    if (!output)
        output = U.lf("Everything seems fine!\n");
    var f = mainPkg.outputPkg.setFile("output.txt", output);
    // display total number of errors on the output file
    f.numDiagnosticsOverride = diagnostics.filter(function (d) { return d.category == ts.pxtc.DiagnosticCategory.Error; }).length;
}
var hang = new Promise(function () { });
function catchUserErrorAndSetDiags(r) {
    return function (v) {
        if (v.isUserError) {
            core.errorNotification(v.message);
            var mainPkg = pkg.mainEditorPkg();
            var f = mainPkg.outputPkg.setFile("output.txt", v.message);
            f.numDiagnosticsOverride = 1;
            return r;
        }
        else
            return Promise.reject(v);
    };
}
function compileAsync(options) {
    if (options === void 0) { options = {}; }
    var trg = pkg.mainPkg.getTargetOptions();
    trg.isNative = options.native;
    trg.preferredEditor = options.preferredEditor;
    return pkg.mainPkg.getCompileOptionsAsync(trg)
        .then(function (opts) {
        if (options.debug) {
            opts.breakpoints = true;
            opts.justMyCode = true;
        }
        if (options.trace) {
            opts.breakpoints = true;
            opts.justMyCode = true;
            opts.trace = true;
        }
        opts.computeUsedSymbols = true;
        if (options.forceEmit)
            opts.forceEmit = true;
        if (/test=1/i.test(window.location.href))
            opts.testMode = true;
        return opts;
    })
        .then(compileCoreAsync)
        .then(function (resp) {
        var outpkg = pkg.mainEditorPkg().outputPkg;
        // keep the assembly file - it is only generated when user hits "Download"
        // and is usually overwritten by the autorun very quickly, so it's impossible to see it
        var prevasm = outpkg.files[pxtc.BINARY_ASM];
        if (prevasm && !resp.outfiles[pxtc.BINARY_ASM]) {
            resp.outfiles[pxtc.BINARY_ASM] = prevasm.content;
        }
        pkg.mainEditorPkg().outputPkg.setFiles(resp.outfiles);
        setDiagnostics(resp.diagnostics);
        return ensureApisInfoAsync()
            .then(function () {
            if (!resp.usedSymbols)
                return resp;
            for (var _i = 0, _a = Object.keys(resp.usedSymbols); _i < _a.length; _i++) {
                var k = _a[_i];
                resp.usedSymbols[k] = U.lookup(cachedApis.byQName, k);
            }
            return resp;
        });
    })
        .catch(catchUserErrorAndSetDiags(hang));
}
exports.compileAsync = compileAsync;
function assembleCore(src) {
    return workerOpAsync("assemble", { fileContent: src });
}
function assembleAsync(src) {
    var stackBase = 0x20004000;
    return assembleCore(".startaddr " + (stackBase - 256) + "\n" + src)
        .then(function (r) {
        return assembleCore(".startaddr " + (stackBase - (r.words.length + 1) * 4) + "\n" + src)
            .then(function (rr) {
            U.assert(rr.words.length == r.words.length);
            return rr;
        });
    });
}
exports.assembleAsync = assembleAsync;
function compileCoreAsync(opts) {
    return workerOpAsync("compile", { options: opts });
}
function decompileAsync(fileName, blockInfo, oldWorkspace, blockFile) {
    var trg = pkg.mainPkg.getTargetOptions();
    return pkg.mainPkg.getCompileOptionsAsync(trg)
        .then(function (opts) {
        opts.ast = true;
        opts.alwaysDecompileOnStart = pxt.appTarget.runtime && pxt.appTarget.runtime.onStartUnDeletable;
        return decompileCoreAsync(opts, fileName);
    })
        .then(function (resp) {
        // try to patch event locations
        if (resp.success && blockInfo && oldWorkspace && blockFile) {
            var newXml = pxt.blocks.layout.patchBlocksFromOldWorkspace(blockInfo, oldWorkspace, resp.outfiles[blockFile]);
            resp.outfiles[blockFile] = newXml;
        }
        pkg.mainEditorPkg().outputPkg.setFiles(resp.outfiles);
        setDiagnostics(resp.diagnostics);
        return resp;
    });
}
exports.decompileAsync = decompileAsync;
function decompileSnippetAsync(code, blockInfo) {
    var snippetTs = "___snippet.ts";
    var snippetBlocks = "___snippet.blocks";
    var trg = pkg.mainPkg.getTargetOptions();
    return pkg.mainPkg.getCompileOptionsAsync(trg)
        .then(function (opts) {
        opts.fileSystem[snippetTs] = code;
        opts.fileSystem[snippetBlocks] = "";
        opts.sourceFiles.push(snippetTs);
        opts.sourceFiles.push(snippetBlocks);
        opts.ast = true;
        return decompileCoreAsync(opts, snippetTs);
    }).then(function (resp) {
        return resp.outfiles[snippetBlocks];
    });
}
exports.decompileSnippetAsync = decompileSnippetAsync;
function decompileCoreAsync(opts, fileName) {
    return workerOpAsync("decompile", { options: opts, fileName: fileName });
}
function workerOpAsync(op, arg) {
    init();
    return iface.opAsync(op, arg);
}
exports.workerOpAsync = workerOpAsync;
var firstTypecheck;
var cachedApis;
var cachedBlocks;
var refreshApis = false;
function waitForFirstTypecheckAsync() {
    if (firstTypecheck)
        return firstTypecheck;
    else
        return typecheckAsync();
}
function ensureApisInfoAsync() {
    if (refreshApis || !cachedApis)
        return workerOpAsync("apiInfo", {})
            .then(function (apis) {
            refreshApis = false;
            return ts.pxtc.localizeApisAsync(apis, pkg.mainPkg);
        }).then(function (apis) {
            cachedApis = apis;
        });
    else
        return Promise.resolve();
}
function apiSearchAsync(searchFor) {
    return ensureApisInfoAsync()
        .then(function () {
        searchFor.localizedApis = cachedApis;
        searchFor.localizedStrings = Util.getLocalizedStrings();
        return workerOpAsync("apiSearch", { search: searchFor });
    });
}
exports.apiSearchAsync = apiSearchAsync;
function formatAsync(input, pos) {
    return workerOpAsync("format", { format: { input: input, pos: pos } });
}
exports.formatAsync = formatAsync;
function typecheckAsync() {
    var p = pkg.mainPkg.getCompileOptionsAsync()
        .then(function (opts) {
        opts.testMode = true; // show errors in all top-level code
        return workerOpAsync("setOptions", { options: opts });
    })
        .then(function () { return workerOpAsync("allDiags", {}); })
        .then(setDiagnostics)
        .then(ensureApisInfoAsync)
        .catch(catchUserErrorAndSetDiags(null));
    if (!firstTypecheck)
        firstTypecheck = p;
    return p;
}
exports.typecheckAsync = typecheckAsync;
function getApisInfoAsync() {
    return waitForFirstTypecheckAsync()
        .then(function () { return cachedApis; });
}
exports.getApisInfoAsync = getApisInfoAsync;
function getBlocksAsync() {
    return cachedBlocks
        ? Promise.resolve(cachedBlocks)
        : getApisInfoAsync().then(function (info) { return cachedBlocks = pxtc.getBlocksInfo(info); });
}
exports.getBlocksAsync = getBlocksAsync;
function newProject() {
    firstTypecheck = null;
    cachedApis = null;
    cachedBlocks = null;
    workerOpAsync("reset", {}).done();
}
exports.newProject = newProject;

},{"./core":11,"./package":28}],10:[function(require,module,exports){
/// <reference path="../../typings/globals/react/index.d.ts" />
/// <reference path="../../typings/globals/react-dom/index.d.ts" />
/// <reference path="../../built/pxtlib.d.ts" />
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var React = require("react");
var data = require("./data");
var sui = require("./sui");
// common menu items -- do not remove
// lf("About")
// lf("Getting started")
// lf("Buy")
// lf("Blocks")
// lf("JavaScript")
// lf("Examples")
// lf("Tutorials")
// lf("Projects")
// lf("Reference")
// lf("Support")
// lf("Hardware")
var DocsMenuItem = (function (_super) {
    __extends(DocsMenuItem, _super);
    function DocsMenuItem(props) {
        _super.call(this, props);
    }
    DocsMenuItem.prototype.openTutorial = function (path) {
        pxt.tickEvent("docstutorial", { path: path });
        this.props.parent.startTutorial(path);
    };
    DocsMenuItem.prototype.openDocs = function (path) {
        pxt.tickEvent("docs", { path: path });
        this.props.parent.setSideDoc(path);
    };
    DocsMenuItem.prototype.render = function () {
        var _this = this;
        var targetTheme = pxt.appTarget.appTheme;
        return React.createElement(sui.DropdownMenuItem, {icon: "help circle large", class: "help-dropdown-menuitem", textClass: "landscape only", title: lf("Reference, lessons, ...")}, targetTheme.docMenu.map(function (m) {
            return !/^\//.test(m.path) ? React.createElement("a", {key: "docsmenulink" + m.path, role: "menuitem", className: "ui item link", href: m.path, target: "docs"}, Util.rlf(m.name))
                : !m.tutorial ? React.createElement(sui.Item, {key: "docsmenu" + m.path, role: "menuitem", text: Util.rlf(m.name), class: "", onClick: function () { return _this.openDocs(m.path); }})
                    : React.createElement(sui.Item, {key: "docsmenututorial" + m.path, role: "menuitem", text: Util.rlf(m.name), class: "", onClick: function () { return _this.openTutorial(m.path); }});
        }));
    };
    return DocsMenuItem;
}(data.Component));
exports.DocsMenuItem = DocsMenuItem;
var SideDocs = (function (_super) {
    __extends(SideDocs, _super);
    function SideDocs(props) {
        _super.call(this, props);
        this.firstLoad = true;
    }
    SideDocs.notify = function (message) {
        var sd = document.getElementById("sidedocsframe");
        if (sd && sd.contentWindow)
            sd.contentWindow.postMessage(message, "*");
    };
    SideDocs.prototype.setPath = function (path, blocksEditor) {
        var docsUrl = pxt.webConfig.docsUrl || '/--docs';
        var mode = blocksEditor ? "blocks" : "js";
        var url = docsUrl + "#doc:" + path + ":" + mode + ":" + pxt.Util.localeInfo();
        this.setUrl(url);
    };
    SideDocs.prototype.setMarkdown = function (md) {
        var docsUrl = pxt.webConfig.docsUrl || '/--docs';
        var mode = this.props.parent.isBlocksEditor() ? "blocks" : "js";
        var url = docsUrl + "#md:" + encodeURIComponent(md) + ":" + mode + ":" + pxt.Util.localeInfo();
        this.setUrl(url);
    };
    SideDocs.prototype.setUrl = function (url) {
        var el = document.getElementById("sidedocsframe");
        if (el)
            el.src = url;
        else
            this.props.parent.setState({ sideDocsLoadUrl: url });
        var sideDocsCollapsed = this.firstLoad && (pxt.BrowserUtils.isMobile() || pxt.options.light);
        this.props.parent.setState({ sideDocsCollapsed: sideDocsCollapsed });
        this.firstLoad = false;
    };
    SideDocs.prototype.collapse = function () {
        this.props.parent.setState({ sideDocsCollapsed: true });
    };
    SideDocs.prototype.popOut = function () {
        SideDocs.notify({
            type: "popout"
        });
    };
    SideDocs.prototype.toggleVisibility = function () {
        var state = this.props.parent.state;
        this.props.parent.setState({ sideDocsCollapsed: !state.sideDocsCollapsed });
    };
    SideDocs.prototype.componentDidUpdate = function () {
        this.props.parent.editor.resize();
    };
    SideDocs.prototype.renderCore = function () {
        var _this = this;
        var state = this.props.parent.state;
        var docsUrl = state.sideDocsLoadUrl;
        if (!docsUrl)
            return null;
        return React.createElement("div", null, React.createElement("button", {id: "sidedocstoggle", role: "button", className: "ui icon button", onClick: function () { return _this.toggleVisibility(); }}, React.createElement("i", {className: "icon large inverted " + (state.sideDocsCollapsed ? 'book' : 'chevron right')}), state.sideDocsCollapsed ? React.createElement("i", {className: "icon large inverted chevron left hover"}) : undefined), React.createElement("div", {id: "sidedocs"}, React.createElement("div", {id: "sidedocsbar"}, React.createElement("h3", null, React.createElement("a", {className: "ui icon link", "data-content": lf("Open documentation in new tab"), title: lf("Open documentation in new tab"), onClick: function () { return _this.popOut(); }}, React.createElement("i", {className: "external icon"})))), React.createElement("iframe", {id: "sidedocsframe", src: docsUrl, role: "complementary", sandbox: "allow-scripts allow-same-origin allow-forms allow-popups"})));
    };
    return SideDocs;
}(data.Component));
exports.SideDocs = SideDocs;

},{"./data":12,"./sui":37,"react":267}],11:[function(require,module,exports){
/// <reference path="../../typings/globals/react/index.d.ts" />
/// <reference path="../../typings/globals/react-dom/index.d.ts" />
/// <reference path="../../built/pxtlib.d.ts" />
"use strict";
var ReactDOM = require("react-dom");
var Cloud = pxt.Cloud;
var Util = pxt.Util;
var lf = Util.lf;
var dimmerInitialized = false;
function isLoading() {
    return !!$('.ui.page.dimmer .loadingcontent')[0];
}
exports.isLoading = isLoading;
function hideLoading() {
    $('.ui.page.dimmer .loadingcontent').remove();
    $('body.main').dimmer('hide');
    if (!dimmerInitialized) {
        initializeDimmer();
    }
    $('body.main').dimmer('hide');
}
exports.hideLoading = hideLoading;
function showLoading(msg) {
    initializeDimmer();
    $('body.main').dimmer('show');
    $('.ui.page.dimmer').html("\n  <div class=\"content loadingcontent\">\n    <div class=\"ui text large loader msg\">{lf(\"Please wait\")}</div>\n  </div>\n");
    $('.ui.page.dimmer .msg').text(msg);
}
exports.showLoading = showLoading;
function initializeDimmer() {
    $('body.main').dimmer({
        closable: false
    });
    dimmerInitialized = true;
}
var asyncLoadingTimeout;
function showLoadingAsync(msg, operation, delay) {
    if (delay === void 0) { delay = 700; }
    clearTimeout(asyncLoadingTimeout);
    asyncLoadingTimeout = setTimeout(function () {
        showLoading(msg);
    }, delay);
    return operation.finally(function () {
        cancelAsyncLoading();
    });
}
exports.showLoadingAsync = showLoadingAsync;
function cancelAsyncLoading() {
    clearTimeout(asyncLoadingTimeout);
    hideLoading();
}
exports.cancelAsyncLoading = cancelAsyncLoading;
function navigateInWindow(url) {
    window.location.href = url;
}
exports.navigateInWindow = navigateInWindow;
function findChild(c, selector) {
    var self = $(ReactDOM.findDOMNode(c));
    if (!selector)
        return self;
    return self.find(selector);
}
exports.findChild = findChild;
function parseQueryString(qs) {
    var r = {};
    qs.replace(/\+/g, " ").replace(/([^&=]+)=?([^&]*)/g, function (f, k, v) {
        r[decodeURIComponent(k)] = decodeURIComponent(v);
        return "";
    });
    return r;
}
exports.parseQueryString = parseQueryString;
var lastTime = {};
function htmlmsg(kind, msg) {
    var now = Date.now();
    var prev = lastTime[kind] || 0;
    if (now - prev < 100)
        $('#' + kind + 'msg').text(msg);
    else {
        lastTime[kind] = now;
        $('#' + kind + 'msg').finish().text(msg).fadeIn('fast').delay(3000).fadeOut('slow');
    }
}
function errorNotification(msg) {
    pxt.tickEvent("notification.error", { message: msg });
    htmlmsg("err", msg);
}
exports.errorNotification = errorNotification;
function warningNotification(msg) {
    pxt.log("warning: " + msg);
    htmlmsg("warn", msg);
}
exports.warningNotification = warningNotification;
function infoNotification(msg) {
    pxt.debug(msg);
    htmlmsg("info", msg);
}
exports.infoNotification = infoNotification;
function handleNetworkError(e, ignoredCodes) {
    var statusCode = parseInt(e.statusCode);
    if (e.isOffline || statusCode === 0) {
        warningNotification(lf("Network request failed; you appear to be offline"));
    }
    else if (!isNaN(statusCode) && statusCode !== 200) {
        if (ignoredCodes && ignoredCodes.indexOf(statusCode) !== -1) {
            return e;
        }
        warningNotification(lf("Network request failed"));
    }
    throw e;
}
exports.handleNetworkError = handleNetworkError;
function dialogAsync(options) {
    var buttons = options.buttons ? options.buttons.filter(function (b) { return !!b; }) : [];
    var logos = (options.logos || [])
        .filter(function (logo) { return !!logo; })
        .map(function (logo) { return ("<img class=\"ui logo\" src=\"" + Util.toDataUri(logo) + "\" />"); })
        .join(' ');
    var html = "\n  <div class=\"ui " + (options.size || "small") + " modal\">\n    <div class=\"header\">\n        " + Util.htmlEscape(options.header) + "\n    </div>\n    <div class=\"content\">\n      " + (options.body ? "<p>" + Util.htmlEscape(options.body) + "</p>" : "") + "\n      " + (options.htmlBody || "") + "\n      " + (options.input ? "<div class=\"ui fluid action input\">\n         <input class=\"userinput\" spellcheck=\"false\" placeholder=\"" + Util.htmlEscape(options.input) + "\" type=\"text\">\n         </div>" : "") + "\n      " + (options.copyable ? "<div class=\"ui fluid action input\">\n         <input class=\"linkinput\" readonly spellcheck=\"false\" type=\"text\" value=\"" + Util.htmlEscape(options.copyable) + "\">\n         <button class=\"ui teal right labeled icon button copybtn\" data-content=\"" + lf("Copied!") + "\">\n            " + lf("Copy") + "\n            <i class=\"copy icon\"></i>\n         </button>\n      </div>" : "") + "\n    </div>";
    html += "<div class=\"actions\">";
    html += logos;
    if (!options.hideCancel) {
        buttons.push({
            label: options.disagreeLbl || lf("Cancel"),
            class: options.disagreeClass || "cancel",
            icon: options.disagreeIcon || "cancel"
        });
    }
    var btnno = 0;
    for (var _i = 0, buttons_1 = buttons; _i < buttons_1.length; _i++) {
        var b = buttons_1[_i];
        html += "\n      <" + (b.url ? "a" : "button") + " class=\"ui right labeled icon button approve " + (b.class || "positive") + "\" data-btnid=\"" + btnno++ + "\" " + (b.url ? "href=\"" + b.url + "\"" : "") + " " + (b.fileName ? "download=\"" + Util.htmlEscape(b.fileName) + "\"" : '') + " target=\"_blank\">\n        " + Util.htmlEscape(b.label) + "\n        <i class=\"" + (b.icon || "checkmark") + " icon\"></i>\n      </" + (b.url ? "a" : "button") + ">";
    }
    html += "</div>";
    html += "</div>";
    var modal = $(html);
    if (options.copyable)
        enableCopyable(modal);
    if (options.input) {
        var ip_1 = modal.find('.userinput');
        ip_1.on('change', function (e) { return options.inputValue = ip_1.val(); });
    }
    var done = false;
    $('#root').append(modal);
    if (options.onLoaded)
        options.onLoaded(modal);
    modal.find('img').on('load', function () {
        modal.modal('refresh');
    });
    modal.find(".ui.accordion").accordion();
    return new Promise(function (resolve, reject) {
        var mo;
        var timer = options.timeout ? setTimeout(function () {
            timer = 0;
            mo.modal("hide");
        }, options.timeout) : 0;
        var onfinish = function (elt) {
            if (!done) {
                done = true;
                if (timer)
                    clearTimeout(timer);
                var id = elt.attr("data-btnid");
                if (id) {
                    var btn = buttons[+id];
                    if (btn.onclick)
                        return resolve(btn.onclick());
                }
                return resolve();
            }
        };
        mo = modal.modal({
            observeChanges: true,
            closeable: !options.hideCancel,
            context: "#root",
            onHidden: function () {
                modal.remove();
                mo.remove();
            },
            onApprove: onfinish,
            onDeny: onfinish,
            onHide: function () {
                if (!done) {
                    done = true;
                    if (timer)
                        clearTimeout(timer);
                    resolve();
                }
            },
        });
        mo.modal("show");
    });
}
exports.dialogAsync = dialogAsync;
function hideDialog() {
    $('.modal').modal("hide");
}
exports.hideDialog = hideDialog;
function confirmAsync(options) {
    if (!options.buttons)
        options.buttons = [];
    var result = 0;
    if (!options.hideAgree) {
        options.buttons.push({
            label: options.agreeLbl || lf("Go ahead!"),
            class: options.agreeClass,
            icon: options.agreeIcon,
            onclick: function () {
                result = 1;
            }
        });
    }
    if (options.deleteLbl) {
        options.buttons.push({
            label: options.deleteLbl,
            class: "delete red",
            icon: "trash",
            onclick: function () {
                result = 2;
            }
        });
    }
    return dialogAsync(options)
        .then(function () { return result; });
}
exports.confirmAsync = confirmAsync;
function confirmDelete(what, cb) {
    confirmAsync({
        header: lf("Would you like to delete '{0}'?", what),
        body: lf("It will be deleted for good. No undo."),
        agreeLbl: lf("Delete"),
        agreeClass: "red",
        agreeIcon: "trash",
    }).then(function (res) {
        if (res) {
            cb().done();
        }
    }).done();
}
exports.confirmDelete = confirmDelete;
function promptAsync(options) {
    if (!options.buttons)
        options.buttons = [];
    var result = "";
    if (!options.hideAgree) {
        options.buttons.push({
            label: options.agreeLbl || lf("Go ahead!"),
            class: options.agreeClass,
            icon: options.agreeIcon,
            onclick: function () {
                var dialogInput = document.getElementById('promptDialogInput');
                result = dialogInput.value;
            }
        });
    }
    options.htmlBody = "<div class=\"ui fluid icon input\">\n                            <input type=\"text\" id=\"promptDialogInput\" value=\"" + options.defaultValue + "\">\n                        </div>";
    options.onLoaded = function () {
        var dialogInput = document.getElementById('promptDialogInput');
        if (dialogInput) {
            dialogInput.setSelectionRange(0, 9999);
            dialogInput.onkeyup = function (e) {
                var charCode = (typeof e.which == "number") ? e.which : e.keyCode;
                if (charCode === 13 || charCode === 32) {
                    e.preventDefault();
                    document.getElementsByClassName("approve positive").item(0).click();
                }
            };
        }
    };
    return dialogAsync(options)
        .then(function () { return result; });
}
exports.promptAsync = promptAsync;
function shareLinkAsync(options) {
    var html = "\n  <div class=\"ui small modal\">\n    <div class=\"header\">\n        " + Util.htmlEscape(options.header) + "\n    </div>\n    <div class=\"content\">\n      <p>" + Util.htmlEscape(options.body || "") + "</p>\n      <div class=\"ui fluid action input\">\n         <input class=\"linkinput\" readonly spellcheck=\"false\" type=\"text\" value=\"" + Util.htmlEscape(options.link) + "\">\n         <button class=\"ui teal right labeled icon button copybtn\" data-content=\"" + lf("Copied!") + "\">\n            " + lf("Copy") + "\n            <i class=\"copy icon\"></i>\n         </button>\n      </div>\n    </div>\n    <div class=\"actions\">\n      <div class=\"ui approve right labeled icon button " + (options.okClass || "teal") + "\">\n        " + Util.htmlEscape(options.okLabel || lf("Ok")) + "\n        <i class=\"" + (options.okIcon || "checkmark") + " icon\"></i>\n      </div>\n    </div>\n  </div>\n  ";
    var modal = $(html);
    enableCopyable(modal);
    var done = false;
    $('body.main').append(modal);
    return new Promise(function (resolve, reject) {
        return modal.modal({
            onHidden: function () {
                modal.remove();
            },
            onHide: function () {
                if (!done) {
                    done = true;
                    resolve(false);
                }
            },
        }).modal("show");
    });
}
exports.shareLinkAsync = shareLinkAsync;
function enableCopyable(modal) {
    var btn = modal.find('.copybtn');
    btn.click(function () {
        try {
            var inp = modal.find('.linkinput')[0];
            inp.focus();
            inp.setSelectionRange(0, inp.value.length);
            document.execCommand("copy");
            btn.popup({
                on: "manual",
                inline: true
            });
            btn.popup("show");
        }
        catch (e) {
        }
    });
}
function scrollIntoView(item, margin) {
    if (margin === void 0) { margin = 0; }
    if (!item.length)
        return;
    var parent = item.offsetParent();
    var itemTop = Math.max(item.position().top - margin, 0);
    var itemBottom = item.position().top + item.outerHeight(true) + margin;
    var selfTop = $(parent).scrollTop();
    var selfH = $(parent).height();
    var newTop = selfTop;
    if (itemTop < selfTop) {
        newTop = itemTop;
    }
    else if (itemBottom > selfTop + selfH) {
        newTop = itemBottom - selfH;
    }
    if (newTop != selfTop) {
        parent.scrollTop(newTop);
    }
}
exports.scrollIntoView = scrollIntoView;
// for JavaScript console
function apiAsync(path, data) {
    return (data ?
        Cloud.privatePostAsync(path, data) :
        Cloud.privateGetAsync(path))
        .then(function (resp) {
        console.log("*");
        console.log("*******", path, "--->");
        console.log("*");
        console.log(resp);
        console.log("*");
        return resp;
    }, function (err) {
        console.log(err.message);
    });
}
exports.apiAsync = apiAsync;

},{"react-dom":138}],12:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var React = require("react");
var core = require("./core");
var gallery = require("./gallery");
var Cloud = pxt.Cloud;
var Util = pxt.Util;
var virtualApis = {};
var targetConfig = undefined;
mountVirtualApi("cloud", {
    getAsync: function (p) { return Cloud.privateGetAsync(stripProtocol(p)).catch(core.handleNetworkError); },
    expirationTime: function (p) { return 60 * 1000; },
    isOffline: function () { return !Cloud.isOnline(); },
});
mountVirtualApi("cloud-search", {
    getAsync: function (p) { return Cloud.privateGetAsync(stripProtocol(p)).catch(function (e) { return core.handleNetworkError(e, [404]); }); },
    expirationTime: function (p) { return 60 * 1000; },
    isOffline: function () { return !Cloud.isOnline(); },
});
mountVirtualApi("gallery", {
    getAsync: function (p) { return gallery.loadGalleryAsync(stripProtocol(p)).catch(function (e) {
        return Promise.resolve(e);
    }); },
    expirationTime: function (p) { return 3600 * 1000; }
});
mountVirtualApi("td-cloud", {
    getAsync: function (p) {
        return Util.httpGetJsonAsync("https://www.touchdevelop.com/api/" + stripProtocol(p))
            .catch(core.handleNetworkError);
    },
    expirationTime: function (p) { return 60 * 1000; },
});
mountVirtualApi("gh-search", {
    getAsync: function (query) { return pxt.targetConfigAsync()
        .then(function (config) { return pxt.github.searchAsync(stripProtocol(query), config ? config.packages : undefined); })
        .catch(core.handleNetworkError); },
    expirationTime: function (p) { return 60 * 1000; },
    isOffline: function () { return !Cloud.isOnline(); },
});
mountVirtualApi("gh-pkgcfg", {
    getAsync: function (query) {
        return pxt.github.pkgConfigAsync(stripProtocol(query)).catch(core.handleNetworkError);
    },
    expirationTime: function (p) { return 60 * 1000; },
    isOffline: function () { return !Cloud.isOnline(); },
});
mountVirtualApi("target-config", {
    getAsync: function (query) {
        return pxt.targetConfigAsync().catch(core.handleNetworkError);
    },
    expirationTime: function (p) { return 60 * 1000; },
    isOffline: function () { return !Cloud.isOnline(); }
});
var cachedData = {};
function subscribe(component, path) {
    var e = lookup(path);
    var lst = e.components;
    if (lst.indexOf(component) < 0) {
        lst.push(component);
        component.subscriptions.push(e);
    }
}
function unsubscribe(component) {
    var lst = component.subscriptions;
    if (lst.length == 0)
        return;
    component.subscriptions = [];
    lst.forEach(function (ce) {
        var idx = ce.components.indexOf(component);
        if (idx >= 0)
            ce.components.splice(idx, 1);
    });
}
function expired(ce) {
    if (!ce.api.expirationTime)
        return ce.data != null;
    return ce.data == null || (Date.now() - ce.lastRefresh) > ce.api.expirationTime(ce.path);
}
function shouldCache(ce) {
    if (!ce.data || ce.data instanceof Error)
        return false;
    return /^cloud:(me\/settings|ptr-pkg-)/.test(ce.path);
}
function clearCache() {
    cachedData = {};
    saveCache();
}
exports.clearCache = clearCache;
function loadCache() {
    JSON.parse(pxt.storage.getLocal("apiCache2") || "[]").forEach(function (e) {
        var ce = lookup(e.path);
        ce.data = e.data;
    });
}
function saveCache() {
    var obj = Util.values(cachedData).filter(function (e) { return shouldCache(e); }).map(function (e) {
        return {
            path: e.path,
            data: e.data
        };
    });
    pxt.storage.setLocal("apiCache2", JSON.stringify(obj));
}
function matches(ce, prefix) {
    return ce.path.slice(0, prefix.length) == prefix;
}
function notify(ce) {
    if (shouldCache(ce))
        saveCache();
    var lst = ce.callbackOnce;
    if (lst.length > 0) {
        ce.callbackOnce = [];
        Util.nextTick(function () { return lst.forEach(function (f) { return f(); }); });
    }
    if (ce.components.length > 0)
        Util.nextTick(function () { return ce.components.forEach(function (c) { return c.forceUpdate(); }); });
}
function getVirtualApi(path) {
    var m = /^([\w\-]+):/.exec(path);
    if (!m || !virtualApis[m[1]])
        Util.oops("bad data protocol: " + path);
    return virtualApis[m[1]];
}
function queue(ce) {
    if (ce.queued)
        return;
    if (ce.api.isOffline && ce.api.isOffline())
        return;
    ce.queued = true;
    var final = function (res) {
        ce.data = res;
        ce.lastRefresh = Date.now();
        ce.queued = false;
        notify(ce);
    };
    if (ce.api.isSync)
        final(ce.api.getSync(ce.path));
    else
        ce.api.getAsync(ce.path).done(final);
}
function lookup(path) {
    if (!cachedData.hasOwnProperty(path))
        cachedData[path] = {
            path: path,
            data: null,
            lastRefresh: 0,
            queued: false,
            callbackOnce: [],
            components: [],
            api: getVirtualApi(path)
        };
    return cachedData[path];
}
function getCached(component, path) {
    subscribe(component, path);
    var r = lookup(path);
    if (r.api.isSync)
        return r.api.getSync(r.path);
    if (expired(r) || r.data instanceof Error)
        queue(r);
    return r.data;
}
function mountVirtualApi(protocol, handler) {
    Util.assert(!virtualApis[protocol]);
    Util.assert(!!handler.getSync || !!handler.getAsync);
    Util.assert(!!handler.getSync != !!handler.getAsync);
    handler.isSync = !!handler.getSync;
    virtualApis[protocol] = handler;
}
exports.mountVirtualApi = mountVirtualApi;
function stripProtocol(path) {
    var m = /^([\w\-]+):(.*)/.exec(path);
    if (m)
        return m[2];
    else
        Util.oops("protocol missing in: " + path);
    return path;
}
exports.stripProtocol = stripProtocol;
function invalidate(prefix) {
    Util.values(cachedData).forEach(function (ce) {
        if (matches(ce, prefix)) {
            ce.lastRefresh = 0;
            if (ce.components.length > 0)
                queue(lookup(ce.path));
        }
    });
}
exports.invalidate = invalidate;
function getAsync(path) {
    var ce = lookup(path);
    if (ce.api.isSync)
        return Promise.resolve(ce.api.getSync(ce.path));
    if (!Cloud.isOnline() || !expired(ce))
        return Promise.resolve(ce.data);
    return new Promise(function (resolve, reject) {
        ce.callbackOnce.push(function () {
            resolve(ce.data);
        });
        queue(ce);
    });
}
exports.getAsync = getAsync;
var Component = (function (_super) {
    __extends(Component, _super);
    function Component(props) {
        _super.call(this, props);
        this.subscriptions = [];
        this.renderCoreOk = false;
        this.state = {};
    }
    Component.prototype.getData = function (path) {
        if (!this.renderCoreOk)
            Util.oops("Override renderCore() not render()");
        return getCached(this, path);
    };
    Component.prototype.componentWillUnmount = function () {
        unsubscribe(this);
    };
    Component.prototype.child = function (selector) {
        return core.findChild(this, selector);
    };
    Component.prototype.renderCore = function () {
        return null;
    };
    Component.prototype.render = function () {
        unsubscribe(this);
        this.renderCoreOk = true;
        return this.renderCore();
    };
    return Component;
}(React.Component));
exports.Component = Component;
function wrapWorkspace(ws) {
    return {
        initAsync: ws.initAsync,
        resetAsync: function () { return ws.resetAsync().then(function () {
            clearCache();
        }); },
        getHeaders: ws.getHeaders,
        getHeader: ws.getHeader,
        syncAsync: function () { return ws.syncAsync().then(function (state) {
            invalidate("header:*");
            invalidate("text:*");
            return state;
        }); },
        getTextAsync: ws.getTextAsync,
        saveAsync: function (h, t) { return ws.saveAsync(h, t).then(function () {
            invalidate("header:" + h.id);
            invalidate("text:" + h.id);
        }); },
        saveToCloudAsync: ws.saveToCloudAsync,
        saveScreenshotAsync: ws.saveScreenshotAsync,
        installAsync: ws.installAsync
    };
}
exports.wrapWorkspace = wrapWorkspace;
loadCache();

},{"./core":11,"./gallery":19,"react":267}],13:[function(require,module,exports){
"use strict";
var Promise = require("bluebird");
window.Promise = Promise;
var PouchDB = require("pouchdb");
require('pouchdb/extras/memory');
Promise.config({
    // Enables all warnings except forgotten return statements.
    warnings: {
        wForgottenReturn: false
    }
});
var _db = undefined;
var inMemory = false;
function memoryDb() {
    pxt.debug('db: in memory...');
    inMemory = true;
    _db = new PouchDB("pxt-" + pxt.storage.storageId(), {
        adapter: 'memory'
    });
    return Promise.resolve(_db);
}
function getDbAsync() {
    if (_db)
        return Promise.resolve(_db);
    if (pxt.shell.isSandboxMode() || pxt.shell.isReadOnly())
        return memoryDb();
    var temp = new PouchDB("pxt-" + pxt.storage.storageId(), { revs_limit: 2 });
    return temp.get('pouchdbsupportabletest')
        .catch(function (error) {
        if (error && error.error && error.name == 'indexed_db_went_bad') {
            return memoryDb();
        }
        else {
            _db = temp;
            return Promise.resolve(_db);
        }
    });
}
exports.getDbAsync = getDbAsync;
function destroyAsync() {
    return !_db ? Promise.resolve() : _db.destroy();
}
exports.destroyAsync = destroyAsync;
var Table = (function () {
    function Table(name) {
        this.name = name;
    }
    Table.prototype.getAsync = function (id) {
        var _this = this;
        return getDbAsync().then(function (db) { return db.get(_this.name + "--" + id); }).then(function (v) {
            v.id = id;
            return v;
        });
    };
    Table.prototype.getAllAsync = function () {
        var _this = this;
        return getDbAsync().then(function (db) { return db.allDocs({
            include_docs: true,
            startkey: _this.name + "--",
            endkey: _this.name + "--\uffff"
        }); }).then(function (resp) { return resp.rows.map(function (e) { return e.doc; }); });
    };
    Table.prototype.deleteAsync = function (obj) {
        return getDbAsync().then(function (db) { return db.remove(obj); });
    };
    Table.prototype.forceSetAsync = function (obj) {
        var _this = this;
        return this.getAsync(obj.id)
            .then(function (o) {
            obj._rev = o._rev;
            return _this.setAsync(obj);
        }, function (e) { return _this.setAsync(obj); });
    };
    Table.prototype.setAsync = function (obj) {
        if (obj.id && !obj._id)
            obj._id = this.name + "--" + obj.id;
        return getDbAsync().then(function (db) { return db.put(obj); }).then(function (resp) { return resp.rev; });
    };
    return Table;
}());
exports.Table = Table;

},{"bluebird":44,"pouchdb":122,"pouchdb/extras/memory":120}],14:[function(require,module,exports){
"use strict";
function setupDragAndDrop(r, filter, dragged) {
    var dragAndDrop = document && document.createElement && 'draggable' in document.createElement('span');
    r.addEventListener('paste', function (e) {
        if (e.clipboardData) {
            // has file?
            var files = Util.toArray(e.clipboardData.files).filter(filter);
            if (files.length > 0) {
                e.stopPropagation(); // Stops some browsers from redirecting.
                e.preventDefault();
                dragged(files);
            }
            else if (e.clipboardData.items && e.clipboardData.items.length > 0) {
                var f = e.clipboardData.items[0].getAsFile();
                if (f) {
                    e.stopPropagation(); // Stops some browsers from redirecting.
                    e.preventDefault();
                    dragged([f]);
                }
            }
        }
    });
    r.addEventListener('dragover', function (e) {
        var types = e.dataTransfer.types;
        var found = false;
        for (var i = 0; i < types.length; ++i)
            if (types[i] == "Files")
                found = true;
        if (found) {
            if (e.preventDefault)
                e.preventDefault(); // Necessary. Allows us to drop.
            e.dataTransfer.dropEffect = 'copy'; // See the section on the DataTransfer object.
            return false;
        }
        return true;
    }, false);
    r.addEventListener('drop', function (e) {
        var files = Util.toArray(e.dataTransfer.files);
        if (files.length > 0) {
            e.stopPropagation(); // Stops some browsers from redirecting.
            e.preventDefault();
            dragged(files);
        }
        return false;
    }, false);
    r.addEventListener('dragend', function (e) {
        return false;
    }, false);
}
exports.setupDragAndDrop = setupDragAndDrop;

},{}],15:[function(require,module,exports){
/// <reference path="../../typings/globals/react/index.d.ts" />
/// <reference path="../../typings/globals/react-dom/index.d.ts" />
/// <reference path="../../built/pxtlib.d.ts" />
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var React = require("react");
var data = require("./data");
var sui = require("./sui");
var EditorToolbar = (function (_super) {
    __extends(EditorToolbar, _super);
    function EditorToolbar(props) {
        _super.call(this, props);
    }
    EditorToolbar.prototype.saveProjectName = function (name, view) {
        pxt.tickEvent("editortools.projectrename", { view: view });
        this.props.parent.updateHeaderName(name);
    };
    EditorToolbar.prototype.compile = function (view) {
        pxt.tickEvent("editortools.download", { view: view, collapsed: this.getCollapsedState() });
        this.props.parent.compile();
    };
    EditorToolbar.prototype.saveFile = function (view) {
        pxt.tickEvent("editortools.save", { view: view, collapsed: this.getCollapsedState() });
        this.props.parent.saveAndCompile();
    };
    EditorToolbar.prototype.undo = function (view) {
        pxt.tickEvent("editortools.undo", { view: view, collapsed: this.getCollapsedState() });
        this.props.parent.editor.undo();
    };
    EditorToolbar.prototype.redo = function (view) {
        pxt.tickEvent("editortools.redo", { view: view, collapsed: this.getCollapsedState() });
        this.props.parent.editor.redo();
    };
    EditorToolbar.prototype.zoomIn = function (view) {
        pxt.tickEvent("editortools.zoomIn", { view: view, collapsed: this.getCollapsedState() });
        this.props.parent.editor.zoomIn();
    };
    EditorToolbar.prototype.zoomOut = function (view) {
        pxt.tickEvent("editortools.zoomOut", { view: view, collapsed: this.getCollapsedState() });
        this.props.parent.editor.zoomOut();
    };
    EditorToolbar.prototype.startStopSimulator = function (view) {
        pxt.tickEvent("editortools.startStopSimulator", { view: view, collapsed: this.getCollapsedState(), headless: this.getHeadlessState() });
        this.props.parent.startStopSimulator();
    };
    EditorToolbar.prototype.restartSimulator = function (view) {
        pxt.tickEvent("editortools.restart", { view: view, collapsed: this.getCollapsedState(), headless: this.getHeadlessState() });
        this.props.parent.restartSimulator();
    };
    EditorToolbar.prototype.toggleTrace = function (view) {
        pxt.tickEvent("editortools.trace", { view: view, collapsed: this.getCollapsedState(), headless: this.getHeadlessState() });
        this.props.parent.toggleTrace();
    };
    EditorToolbar.prototype.toggleCollapse = function (view) {
        pxt.tickEvent("editortools.toggleCollapse", { view: view, collapsedTo: '' + !this.props.parent.state.collapseEditorTools });
        this.props.parent.toggleSimulatorCollapse();
    };
    EditorToolbar.prototype.getCollapsedState = function () {
        return '' + this.props.parent.state.collapseEditorTools;
    };
    EditorToolbar.prototype.getHeadlessState = function () {
        return pxt.appTarget.simulator.headless ? "true" : "false";
    };
    EditorToolbar.prototype.render = function () {
        var _this = this;
        var _a = this.props.parent.state, tutorialOptions = _a.tutorialOptions, hideEditorFloats = _a.hideEditorFloats, collapseEditorTools = _a.collapseEditorTools, projectName = _a.projectName, showParts = _a.showParts, compiling = _a.compiling, isSaving = _a.isSaving, running = _a.running;
        var sandbox = pxt.shell.isSandboxMode();
        var readOnly = pxt.shell.isReadOnly();
        var tutorial = tutorialOptions ? tutorialOptions.tutorial : false;
        var collapsed = (hideEditorFloats || collapseEditorTools) && !tutorial;
        var isEditor = this.props.parent.isBlocksEditor() || this.props.parent.isTextEditor();
        if (!isEditor)
            return React.createElement("div", null);
        var targetTheme = pxt.appTarget.appTheme;
        var compile = pxt.appTarget.compile;
        var compileBtn = compile.hasHex;
        var simOpts = pxt.appTarget.simulator;
        var make = !sandbox && showParts && simOpts && (simOpts.instructions || (simOpts.parts && pxt.options.debug));
        var compileTooltip = lf("Download your code to the {0}", targetTheme.boardName);
        var compileLoading = !!compiling;
        var runTooltip = running ? lf("Stop the simulator") : lf("Start the simulator");
        var makeTooltip = lf("Open assembly instructions");
        var restartTooltip = lf("Restart the simulator");
        var collapseTooltip = collapsed ? lf("Show the simulator") : lf("Hide the simulator");
        var headless = simOpts.headless;
        var hasUndo = this.props.parent.editor.hasUndo();
        var hasRedo = this.props.parent.editor.hasRedo();
        var showCollapsed = !tutorial;
        var showProjectRename = !tutorial && !readOnly;
        var showUndoRedo = !tutorial && !readOnly;
        var showZoomControls = !tutorial;
        var run = true;
        var restart = run && !simOpts.hideRestart;
        var trace = run && simOpts.enableTrace;
        var tracing = this.props.parent.state.tracing;
        var traceTooltip = tracing ? lf("Disable Slow-Mo") : lf("Slow-Mo");
        var downloadIcon = pxt.appTarget.appTheme.downloadIcon || "download";
        var downloadText = pxt.appTarget.appTheme.useUploadMessage ? lf("Upload") : lf("Download");
        var downloadButtonClasses = "";
        var saveButtonClasses = "";
        if (isSaving) {
            downloadButtonClasses = "disabled";
            saveButtonClasses = "loading disabled";
        }
        else if (compileLoading) {
            downloadButtonClasses = "loading disabled";
            saveButtonClasses = "disabled";
        }
        return React.createElement("div", {className: "ui equal width grid right aligned padded"}, React.createElement("div", {className: "column mobile only"}, collapsed ?
            React.createElement("div", {className: "ui equal width grid"}, React.createElement("div", {className: "left aligned column"}, React.createElement("div", {className: "ui icon small buttons"}, React.createElement(sui.Button, {icon: "" + (collapsed ? 'toggle up' : 'toggle down'), class: "collapse-button " + (collapsed ? 'collapsed' : '') + " " + (hideEditorFloats ? 'disabled' : ''), title: collapseTooltip, onClick: function () { return _this.toggleCollapse('mobile'); }}), headless && run ? React.createElement(sui.Button, {class: "play-button " + (running ? "stop" : "play"), key: 'runmenubtn', icon: running ? "stop" : "play", title: runTooltip, onClick: function () { return _this.startStopSimulator('mobile'); }}) : undefined, headless && restart ? React.createElement(sui.Button, {key: 'restartbtn', class: "restart-button", icon: "refresh", title: restartTooltip, onClick: function () { return _this.restartSimulator('mobile'); }}) : undefined, headless && trace ? React.createElement(sui.Button, {key: 'tracebtn', class: "trace-button " + (tracing ? 'orange' : ''), icon: "xicon turtle", title: traceTooltip, onClick: function () { return _this.toggleTrace('mobile'); }}) : undefined, compileBtn ? React.createElement(sui.Button, {class: "primary download-button download-button-full " + downloadButtonClasses, icon: downloadIcon, title: compileTooltip, onClick: function () { return _this.compile('mobile'); }}) : undefined)), React.createElement("div", {className: "right aligned column"}, !readOnly ?
                React.createElement("div", {className: "ui icon small buttons"}, React.createElement(sui.Button, {icon: 'save', class: "editortools-btn save-editortools-btn " + saveButtonClasses, title: lf("Save"), onClick: function () { return _this.saveFile('mobile'); }}), showUndoRedo ? React.createElement(sui.Button, {icon: 'xicon undo', class: "editortools-btn undo-editortools-btn} " + (!hasUndo ? 'disabled' : ''), title: lf("Undo"), onClick: function () { return _this.undo('mobile'); }}) : undefined) : undefined), React.createElement("div", {className: "right aligned column"}, showZoomControls ?
                React.createElement("div", {className: "ui icon small buttons"}, React.createElement(sui.Button, {icon: 'plus circle', class: "editortools-btn zoomin-editortools-btn", title: lf("Zoom In"), onClick: function () { return _this.zoomIn('mobile'); }}), React.createElement(sui.Button, {icon: 'minus circle', class: "editortools-btn zoomout-editortools-btn", title: lf("Zoom Out"), onClick: function () { return _this.zoomOut('mobile'); }})) : undefined)) :
            React.createElement("div", {className: "ui equal width grid"}, React.createElement("div", {className: "left aligned two wide column"}, React.createElement("div", {className: "ui vertical icon small buttons"}, run ? React.createElement(sui.Button, {class: "play-button " + (running ? "stop" : "play"), key: 'runmenubtn', icon: running ? "stop" : "play", title: runTooltip, onClick: function () { return _this.startStopSimulator('mobile'); }}) : undefined, restart ? React.createElement(sui.Button, {key: 'restartbtn', class: "restart-button", icon: "refresh", title: restartTooltip, onClick: function () { return _this.restartSimulator('mobile'); }}) : undefined), showCollapsed ?
                React.createElement("div", {className: "row", style: { paddingTop: "1rem" }}, React.createElement("div", {className: "ui vertical icon small buttons"}, React.createElement(sui.Button, {icon: "" + (collapsed ? 'toggle up' : 'toggle down'), class: "collapse-button " + (collapsed ? 'collapsed' : ''), title: collapseTooltip, onClick: function () { return _this.toggleCollapse('mobile'); }}))) : undefined), React.createElement("div", {className: "three wide column"}), React.createElement("div", {className: "ui grid column"}, readOnly || !showUndoRedo ? undefined :
                React.createElement("div", {className: "row"}, React.createElement("div", {className: "column"}, React.createElement("div", {className: "ui icon large buttons"}, React.createElement(sui.Button, {icon: 'xicon undo', class: "editortools-btn undo-editortools-btn} " + (!hasUndo ? 'disabled' : ''), title: lf("Undo"), onClick: function () { return _this.undo('mobile'); }})))), React.createElement("div", {className: "row", style: readOnly || !showUndoRedo ? undefined : { paddingTop: 0 }}, React.createElement("div", {className: "column"}, React.createElement("div", {className: "ui icon large buttons"}, trace ? React.createElement(sui.Button, {key: 'tracebtn', class: "trace-button " + (tracing ? 'orange' : ''), icon: "xicon turtle", title: traceTooltip, onClick: function () { return _this.toggleTrace('mobile'); }}) : undefined, compileBtn ? React.createElement(sui.Button, {class: "primary download-button download-button-full " + downloadButtonClasses, icon: downloadIcon, title: compileTooltip, onClick: function () { return _this.compile('mobile'); }}) : undefined)))))), React.createElement("div", {className: "column tablet only"}, collapsed ?
            React.createElement("div", {className: "ui grid seven column"}, headless ?
                React.createElement("div", {className: "left aligned six wide column"}, React.createElement("div", {className: "ui icon buttons"}, React.createElement(sui.Button, {icon: "" + (collapsed ? 'toggle up' : 'toggle down'), class: "collapse-button " + (collapsed ? 'collapsed' : '') + " " + (hideEditorFloats ? 'disabled' : ''), title: collapseTooltip, onClick: function () { return _this.toggleCollapse('tablet'); }}), run ? React.createElement(sui.Button, {role: "menuitem", class: "play-button " + (running ? "stop" : "play"), key: 'runmenubtn', icon: running ? "stop" : "play", title: runTooltip, onClick: function () { return _this.startStopSimulator('tablet'); }}) : undefined, restart ? React.createElement(sui.Button, {key: 'restartbtn', class: "restart-button", icon: "refresh", title: restartTooltip, onClick: function () { return _this.restartSimulator('tablet'); }}) : undefined, trace ? React.createElement(sui.Button, {key: 'tracebtn', class: "trace-button " + (tracing ? 'orange' : ''), icon: "xicon turtle", title: traceTooltip, onClick: function () { return _this.toggleTrace('tablet'); }}) : undefined, compileBtn ? React.createElement(sui.Button, {class: "primary download-button download-button-full " + downloadButtonClasses, icon: downloadIcon, title: compileTooltip, onClick: function () { return _this.compile('tablet'); }}) : undefined)) :
                React.createElement("div", {className: "left aligned six wide column"}, React.createElement("div", {className: "ui icon buttons"}, React.createElement(sui.Button, {icon: "" + (collapsed ? 'toggle up' : 'toggle down'), class: "collapse-button " + (collapsed ? 'collapsed' : '') + " " + (hideEditorFloats ? 'disabled' : ''), title: collapseTooltip, onClick: function () { return _this.toggleCollapse('tablet'); }}), compileBtn ? React.createElement(sui.Button, {class: "primary download-button download-button-full " + downloadButtonClasses, icon: downloadIcon, text: downloadText, title: compileTooltip, onClick: function () { return _this.compile('tablet'); }}) : undefined)), React.createElement("div", {className: "column four wide"}, readOnly ? undefined :
                React.createElement(sui.Button, {icon: 'save', class: "small editortools-btn save-editortools-btn " + saveButtonClasses, title: lf("Save"), onClick: function () { return _this.saveFile('tablet'); }})), React.createElement("div", {className: "column six wide right aligned"}, showUndoRedo ?
                React.createElement("div", {className: "ui icon small buttons"}, React.createElement(sui.Button, {icon: 'xicon undo', class: "editortools-btn undo-editortools-btn} " + (!hasUndo ? 'disabled' : ''), title: lf("Undo"), onClick: function () { return _this.undo('tablet'); }}), React.createElement(sui.Button, {icon: 'xicon redo', class: "editortools-btn redo-editortools-btn} " + (!hasRedo ? 'disabled' : ''), title: lf("Redo"), onClick: function () { return _this.redo('tablet'); }})) : undefined, showZoomControls ?
                React.createElement("div", {className: "ui icon small buttons"}, React.createElement(sui.Button, {icon: 'plus circle', class: "editortools-btn zoomin-editortools-btn", title: lf("Zoom In"), onClick: function () { return _this.zoomIn('tablet'); }}), React.createElement(sui.Button, {icon: 'minus circle', class: "editortools-btn zoomout-editortools-btn", title: lf("Zoom Out"), onClick: function () { return _this.zoomOut('tablet'); }})) : undefined))
            : React.createElement("div", {className: "ui grid"}, React.createElement("div", {className: "left aligned two wide column"}, React.createElement("div", {className: "ui vertical icon small buttons"}, run ? React.createElement(sui.Button, {role: "menuitem", class: "play-button " + (running ? "stop" : "play"), key: 'runmenubtn', icon: running ? "stop" : "play", title: runTooltip, onClick: function () { return _this.startStopSimulator('tablet'); }}) : undefined, restart ? React.createElement(sui.Button, {key: 'restartbtn', class: "restart-button", icon: "refresh", title: restartTooltip, onClick: function () { return _this.restartSimulator('tablet'); }}) : undefined), showCollapsed ?
                React.createElement("div", {className: "row", style: { paddingTop: "1rem" }}, React.createElement("div", {className: "ui vertical icon small buttons"}, React.createElement(sui.Button, {icon: "" + (collapsed ? 'toggle up' : 'toggle down'), class: "collapse-button " + (collapsed ? 'collapsed' : ''), title: collapseTooltip, onClick: function () { return _this.toggleCollapse('tablet'); }}))) : undefined), React.createElement("div", {className: "three wide column"}), React.createElement("div", {className: "five wide column"}, React.createElement("div", {className: "ui grid right aligned"}, compileBtn ? React.createElement("div", {className: "row"}, React.createElement("div", {className: "column"}, React.createElement(sui.Button, {role: "menuitem", class: "primary large fluid download-button download-button-full " + downloadButtonClasses, icon: downloadIcon, text: downloadText, title: compileTooltip, onClick: function () { return _this.compile('tablet'); }}))) : undefined, showProjectRename ?
                React.createElement("div", {className: "row", style: compileBtn ? { paddingTop: 0 } : {}}, React.createElement("div", {className: "column"}, React.createElement("div", {className: "ui item large right labeled fluid input projectname-input projectname-tablet", title: lf("Pick a name for your project")}, React.createElement("input", {id: "fileNameInput", type: "text", placeholder: lf("Pick a name..."), value: projectName || '', onChange: function (e) { return _this.saveProjectName(e.target.value, 'tablet'); }}), React.createElement(sui.Button, {icon: 'save', class: "large right attached editortools-btn save-editortools-btn " + saveButtonClasses, title: lf("Save"), onClick: function () { return _this.saveFile('tablet'); }})))) : undefined)), React.createElement("div", {className: "six wide column right aligned"}, React.createElement("div", {className: "ui grid right aligned"}, showUndoRedo || showZoomControls ?
                React.createElement("div", {className: "row"}, React.createElement("div", {className: "column"}, showUndoRedo ?
                    React.createElement("div", {className: "ui icon large buttons"}, React.createElement(sui.Button, {icon: 'xicon undo', class: "editortools-btn undo-editortools-btn} " + (!hasUndo ? 'disabled' : ''), title: lf("Undo"), onClick: function () { return _this.undo(); }}), React.createElement(sui.Button, {icon: 'xicon redo', class: "editortools-btn redo-editortools-btn} " + (!hasRedo ? 'disabled' : ''), title: lf("Redo"), onClick: function () { return _this.redo(); }})) : undefined, showZoomControls ?
                    React.createElement("div", {className: "ui icon large buttons"}, React.createElement(sui.Button, {icon: 'plus circle', class: "editortools-btn zoomin-editortools-btn", title: lf("Zoom In"), onClick: function () { return _this.zoomIn(); }}), React.createElement(sui.Button, {icon: 'minus circle', class: "editortools-btn zoomout-editortools-btn", title: lf("Zoom Out"), onClick: function () { return _this.zoomOut(); }})) : undefined)) : undefined, trace ?
                React.createElement("div", {className: "row", style: showUndoRedo || showZoomControls ? { paddingTop: 0 } : {}}, React.createElement("div", {className: "column"}, React.createElement(sui.Button, {key: 'tracebtn', class: "large trace-button " + (tracing ? 'orange' : ''), icon: "xicon turtle", title: traceTooltip, onClick: function () { return _this.toggleTrace('tablet'); }}))) : undefined)))), React.createElement("div", {className: "column computer only"}, React.createElement("div", {className: "ui grid equal width"}, React.createElement("div", {id: "downloadArea", className: "ui column items"}, headless ?
            React.createElement("div", {className: "ui item"}, React.createElement("div", {className: "ui icon large buttons"}, showCollapsed ? React.createElement(sui.Button, {icon: "" + (collapseEditorTools ? 'toggle right' : 'toggle left'), class: "large collapse-button " + (collapsed ? 'collapsed' : ''), title: collapseTooltip, onClick: function () { return _this.toggleCollapse('computer'); }}) : undefined, run ? React.createElement(sui.Button, {role: "menuitem", class: "large play-button " + (running ? "stop" : "play"), key: 'runmenubtn', icon: running ? "stop" : "play", title: runTooltip, onClick: function () { return _this.startStopSimulator('computer'); }}) : undefined, restart ? React.createElement(sui.Button, {key: 'restartbtn', class: "large restart-button", icon: "refresh", title: restartTooltip, onClick: function () { return _this.restartSimulator('computer'); }}) : undefined, trace ? React.createElement(sui.Button, {key: 'tracebtn', class: "large trace-button " + (tracing ? 'orange' : ''), icon: "xicon turtle", title: traceTooltip, onClick: function () { return _this.toggleTrace('computer'); }}) : undefined, compileBtn ? React.createElement(sui.Button, {icon: downloadIcon, class: "primary large download-button " + downloadButtonClasses, title: compileTooltip, onClick: function () { return _this.compile('computer'); }}) : undefined)) :
            React.createElement("div", {className: "ui item"}, showCollapsed ? React.createElement(sui.Button, {icon: "" + (collapseEditorTools ? 'toggle right' : 'toggle left'), class: "large collapse-button " + (collapsed ? 'collapsed' : ''), title: collapseTooltip, onClick: function () { return _this.toggleCollapse('computer'); }}) : undefined, compileBtn ? React.createElement(sui.Button, {icon: downloadIcon, class: "primary huge fluid download-button " + downloadButtonClasses, text: downloadText, title: compileTooltip, onClick: function () { return _this.compile('computer'); }}) : undefined)), showProjectRename ?
            React.createElement("div", {className: "column left aligned"}, React.createElement("div", {className: "ui right labeled input projectname-input projectname-computer", title: lf("Pick a name for your project")}, React.createElement("input", {id: "fileNameInput", type: "text", placeholder: lf("Pick a name..."), value: projectName || '', onChange: function (e) { return _this.saveProjectName(e.target.value, 'computer'); }}), React.createElement(sui.Button, {icon: 'save', class: "small right attached editortools-btn save-editortools-btn " + saveButtonClasses, title: lf("Save"), onClick: function () { return _this.saveFile('computer'); }}))) : undefined, React.createElement("div", {className: "column right aligned"}, showUndoRedo ?
            React.createElement("div", {className: "ui icon small buttons"}, React.createElement(sui.Button, {icon: 'xicon undo', class: "editortools-btn undo-editortools-btn} " + (!hasUndo ? 'disabled' : ''), title: lf("Undo"), onClick: function () { return _this.undo('computer'); }}), React.createElement(sui.Button, {icon: 'xicon redo', class: "editortools-btn redo-editortools-btn} " + (!hasRedo ? 'disabled' : ''), title: lf("Redo"), onClick: function () { return _this.redo('computer'); }})) : undefined, showZoomControls ?
            React.createElement("div", {className: "ui icon small buttons"}, React.createElement(sui.Button, {icon: 'plus circle', class: "editortools-btn zoomin-editortools-btn", title: lf("Zoom In"), onClick: function () { return _this.zoomIn('computer'); }}), React.createElement(sui.Button, {icon: 'minus circle', class: "editortools-btn zoomout-editortools-btn", title: lf("Zoom Out"), onClick: function () { return _this.zoomOut('computer'); }})) : undefined))));
    };
    return EditorToolbar;
}(data.Component));
exports.EditorToolbar = EditorToolbar;

},{"./data":12,"./sui":37,"react":267}],16:[function(require,module,exports){
"use strict";
var core = require("./core");
var Cloud = pxt.Cloud;
var UpdateEventType;
(function (UpdateEventType) {
    UpdateEventType[UpdateEventType["Critical"] = 1] = "Critical";
    UpdateEventType[UpdateEventType["Notification"] = 2] = "Notification";
    UpdateEventType[UpdateEventType["Prompt"] = 3] = "Prompt";
})(UpdateEventType || (UpdateEventType = {}));
var electronSocket = null;
exports.isElectron = /[?&]electron=1/.test(window.location.href);
function init() {
    if (!exports.isElectron || !Cloud.isLocalHost() || !Cloud.localToken) {
        return;
    }
    function onCriticalUpdate(args) {
        var isUrl = /^https:\/\//.test(args.targetVersion);
        var body = lf("To continue using {0}, you must install an update.", args.appName || lf("this application"));
        var agreeLbl = lf("Update");
        if (isUrl) {
            body = lf("To continue using {0}, you must install an update from the website.", args.appName || lf("this application"));
            agreeLbl = lf("Go to website");
        }
        core.confirmAsync({
            header: lf("Critical update required"),
            body: body,
            agreeLbl: agreeLbl,
            disagreeLbl: lf("Quit"),
            disagreeClass: "red",
            size: "medium"
        }).then(function (b) {
            if (!b) {
                pxt.tickEvent("update.refusedCritical");
                sendMessage("quit");
            }
            else {
                pxt.tickEvent("update.acceptedCritical");
                core.showLoading(lf("Downloading update..."));
                sendMessage("update", {
                    targetVersion: args.targetVersion,
                    type: args.type
                });
            }
        });
    }
    function onUpdateAvailable(args) {
        var isUrl = /^https:\/\//.test(args.targetVersion);
        var header = lf("Version {0} available", args.targetVersion);
        var body = lf("A new version of {0} is ready to download and install. The app will restart during the update. Update now?", args.appName || lf("this application"));
        var agreeLbl = lf("Update");
        if (isUrl) {
            header = lf("Update available from website");
            body = lf("A new version of {0} is available from the website.", args.appName || lf("this application"));
            agreeLbl = lf("Go to website");
        }
        if (args.type === UpdateEventType.Notification) {
            core.infoNotification(lf("A new version is available. Select 'Check for updates...' in the menu.", args.targetVersion));
        }
        else if (args.type === UpdateEventType.Prompt) {
            core.confirmAsync({
                header: header,
                body: body,
                agreeLbl: agreeLbl,
                disagreeLbl: lf("Not now"),
                size: "medium"
            }).then(function (b) {
                if (!b) {
                    if (args.isInitialCheck) {
                        pxt.tickEvent("update.refusedInitial");
                    }
                    else {
                        pxt.tickEvent("update.refused");
                    }
                }
                else {
                    if (args.isInitialCheck) {
                        pxt.tickEvent("update.acceptedInitial");
                    }
                    else {
                        pxt.tickEvent("update.accepted");
                    }
                    if (!isUrl) {
                        core.showLoading(lf("Downloading update..."));
                    }
                    sendMessage("update", {
                        targetVersion: args.targetVersion,
                        type: args.type
                    });
                }
            });
        }
    }
    function onUpdateNotAvailable() {
        core.confirmAsync({
            body: lf("You are using the latest version available."),
            header: lf("Good to go!"),
            agreeLbl: lf("Ok"),
            hideCancel: true
        });
    }
    function onUpdateCheckError() {
        displayUpdateError(lf("Unable to check for updates"), lf("Ok"));
    }
    function onUpdateDownloadError(args) {
        var isCritical = args && args.type === UpdateEventType.Critical;
        core.hideLoading();
        displayUpdateError(lf("There was an error downloading the update"), isCritical ? lf("Quit") : lf("Ok"))
            .finally(function () {
            if (isCritical) {
                sendMessage("quit");
            }
        });
    }
    function displayUpdateError(header, btnLabel) {
        return core.confirmAsync({
            header: header,
            body: lf("Please ensure you are connected to the Internet and try again later."),
            agreeClass: "red",
            agreeIcon: "cancel",
            agreeLbl: btnLabel,
            hideCancel: true
        });
    }
    pxt.log('initializing electron socket');
    electronSocket = new WebSocket("ws://localhost:" + pxt.options.wsPort + "/" + Cloud.localToken + "/electron");
    electronSocket.onopen = function (ev) {
        pxt.log('electron: socket opened');
        sendMessage("ready");
    };
    electronSocket.onclose = function (ev) {
        pxt.log('electron: socket closed');
        electronSocket = null;
    };
    electronSocket.onmessage = function (ev) {
        try {
            var msg = JSON.parse(ev.data);
            switch (msg.type) {
                case "critical-update":
                    onCriticalUpdate(msg.args);
                    break;
                case "update-available":
                    onUpdateAvailable(msg.args);
                    break;
                case "update-not-available":
                    onUpdateNotAvailable();
                    break;
                case "update-check-error":
                    onUpdateCheckError();
                    break;
                case "update-download-error":
                    onUpdateDownloadError(msg.args);
                    break;
                case "telemetry":
                    var telemetryInfo = msg.args;
                    if (!telemetryInfo) {
                        pxt.debug('invalid telemetry message: ' + ev.data);
                        return;
                    }
                    pxt.tickEvent(telemetryInfo.event, telemetryInfo.data);
                default:
                    pxt.debug('unknown electron message: ' + ev.data);
                    break;
            }
        }
        catch (e) {
            pxt.debug('unknown electron message: ' + ev.data);
        }
    };
}
exports.init = init;
function sendMessage(type, args) {
    if (!electronSocket) {
        return;
    }
    var message = {
        type: type,
        args: args
    };
    // Sending messages to the web socket sometimes hangs the app briefly; use setTimeout to smoothen the UI animations a bit 
    setTimeout(function () {
        electronSocket.send(JSON.stringify(message));
    }, 150);
}
exports.sendMessage = sendMessage;
function checkForUpdate() {
    pxt.tickEvent("menu.electronupdate");
    sendMessage("check-for-update");
}
exports.checkForUpdate = checkForUpdate;

},{"./core":11}],17:[function(require,module,exports){
/// <reference path="../../typings/globals/react/index.d.ts" />
/// <reference path="../../typings/globals/react-dom/index.d.ts" />
/// <reference path="../../built/pxtlib.d.ts" />
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var React = require("react");
var data = require("./data");
var sui = require("./sui");
var pkg = require("./package");
var core = require("./core");
var customFile = "custom.ts";
var FileList = (function (_super) {
    __extends(FileList, _super);
    function FileList(props) {
        _super.call(this, props);
        this.state = {
            expands: {}
        };
    }
    FileList.prototype.removePkg = function (e, p) {
        var _this = this;
        e.stopPropagation();
        core.confirmAsync({
            header: lf("Remove {0} package", p.getPkgId()),
            body: lf("You are about to remove a package from your project. Are you sure?"),
            agreeClass: "red",
            agreeIcon: "trash",
            agreeLbl: lf("Remove it"),
        }).done(function (res) {
            if (res) {
                pkg.mainEditorPkg().removeDepAsync(p.getPkgId())
                    .then(function () { return _this.props.parent.reloadHeaderAsync(); })
                    .done();
            }
        });
    };
    FileList.prototype.removeFile = function (e, f) {
        e.stopPropagation();
        this.props.parent.removeFile(f);
    };
    FileList.prototype.updatePkg = function (e, p) {
        var _this = this;
        e.stopPropagation();
        pkg.mainEditorPkg().updateDepAsync(p.getPkgId())
            .then(function () { return _this.props.parent.reloadHeaderAsync(); })
            .done();
    };
    FileList.prototype.filesOf = function (pkg) {
        var _this = this;
        var deleteFiles = pkg.getPkgId() == "this";
        var parent = this.props.parent;
        return pkg.sortedFiles().map(function (file) {
            var meta = _this.getData("open-meta:" + file.getName());
            return (React.createElement("a", {key: file.getName(), onClick: function () { return parent.setSideFile(file); }, className: (parent.state.currFile == file ? "active " : "") + (pkg.isTopLevel() ? "" : "nested ") + "item"}, file.name, " ", meta.isSaved ? "" : "*", /\.ts$/.test(file.name) ? React.createElement("i", {className: "align left icon"}) : /\.blocks$/.test(file.name) ? React.createElement("i", {className: "puzzle icon"}) : undefined, meta.isReadonly ? React.createElement("i", {className: "lock icon"}) : null, !meta.numErrors ? null : React.createElement("span", {className: 'ui label red'}, meta.numErrors), deleteFiles && /\.blocks$/i.test(file.getName()) ? React.createElement(sui.Button, {class: "primary label", icon: "trash", onClick: function (e) { return _this.removeFile(e, file); }}) : ''));
        });
    };
    FileList.prototype.packageOf = function (p) {
        var _this = this;
        var expands = this.state.expands;
        var del = p.getPkgId() != pxt.appTarget.id
            && p.getPkgId() != "built"
            && p.getPkgId() != pxt.appTarget.corepkg;
        var upd = p.getKsPkg() && p.getKsPkg().verProtocol() == "github";
        return [React.createElement("div", {key: "hd-" + p.getPkgId(), className: "header link item", onClick: function () { return _this.togglePkg(p); }}, React.createElement("i", {className: "chevron " + (expands[p.getPkgId()] ? "down" : "right") + " icon"}), upd ? React.createElement(sui.Button, {class: "primary label", icon: "refresh", onClick: function (e) { return _this.updatePkg(e, p); }}) : '', del ? React.createElement(sui.Button, {class: "primary label", icon: "trash", onClick: function (e) { return _this.removePkg(e, p); }}) : '', p.getPkgId())
        ].concat(expands[p.getPkgId()] ? this.filesOf(p) : []);
    };
    FileList.prototype.togglePkg = function (p) {
        var expands = this.state.expands;
        expands[p.getPkgId()] = !expands[p.getPkgId()];
        this.forceUpdate();
    };
    FileList.prototype.filesWithHeader = function (p) {
        return p.isTopLevel() ? this.filesOf(p) : this.packageOf(p);
    };
    FileList.prototype.toggleVisibility = function () {
        this.props.parent.setState({ showFiles: !this.props.parent.state.showFiles });
    };
    FileList.prototype.addCustomBlocksFile = function () {
        var _this = this;
        core.confirmAsync({
            header: lf("Add custom blocks?"),
            body: lf("A new JavaScript file, custom.ts, will be added to your project. You can define custom functions and blocks in that file.")
        }).then(function (v) {
            if (!v)
                return;
            return _this.props.parent.updateFileAsync(customFile, "\n/**\n * " + lf("Use this file to define custom functions and blocks.") + "\n * " + lf("Read more at {0}", pxt.appTarget.appTheme.homeUrl + 'blocks/custom') + "\n */\n\nenum MyEnum {\n    //% block=\"one\"\n    One,\n    //% block=\"two\"\n    Two\n}\n\n/**\n * " + lf("Custom blocks") + "\n */\n//% weight=100 color=#0fbc11 icon=\"\uF0C3\"\nnamespace custom {\n    /**\n     * TODO: " + lf("describe your function here") + "\n     * @param n " + lf("describe parameter here") + ", eg: 5\n     * @param s " + lf("describe parameter here") + ", eg: \"Hello\"\n     * @param e " + lf("describe parameter here") + "\n     */    \n    //% block\n    export function foo(n: number, s: string, e: MyEnum): void {\n        // Add code here\n    }\n\n    /**\n     * TODO: " + lf("describe your function here") + "\n     * @param value " + lf("describe value here") + ", eg: 5\n     */    \n    //% block\n    export function fib(value: number): number {\n        return value <= 1 ? value : fib(value -1) + fib(value - 2);\n    }\n}\n", true);
        });
    };
    FileList.prototype.renderCore = function () {
        var _this = this;
        var show = !!this.props.parent.state.showFiles;
        var targetTheme = pxt.appTarget.appTheme;
        var plus = show && !pkg.mainEditorPkg().files[customFile];
        return React.createElement("div", {className: "ui tiny vertical " + (targetTheme.invertedMenu ? "inverted" : '') + " menu filemenu landscape only"}, React.createElement("div", {key: "projectheader", className: "link item", onClick: function () { return _this.toggleVisibility(); }}, lf("Explorer"), React.createElement("i", {className: "chevron " + (show ? "down" : "right") + " icon"}), plus ? React.createElement(sui.Button, {class: "primary label", icon: "plus", onClick: function (e) { return _this.addCustomBlocksFile(); }}) : undefined), show ? Util.concat(pkg.allEditorPkgs().map(function (p) { return _this.filesWithHeader(p); })) : undefined);
    };
    return FileList;
}(data.Component));
exports.FileList = FileList;

},{"./core":11,"./data":12,"./package":28,"./sui":37,"react":267}],18:[function(require,module,exports){
"use strict";
var db = require("./db");
var core = require("./core");
var data = require("./data");
var U = pxt.Util;
var Cloud = pxt.Cloud;
var lf = U.lf;
var allScripts = [];
var currentTarget;
function lookup(id) {
    return allScripts.filter(function (x) { return x.id == id; })[0];
}
function getHeaders() {
    return allScripts.map(function (e) { return e.header; });
}
function getHeader(id) {
    var e = lookup(id);
    if (e && !e.header.isDeleted)
        return e.header;
    return null;
}
function apiAsync(path, data) {
    return U.requestAsync({
        url: "/api/" + path,
        headers: { "Authorization": Cloud.localToken },
        method: data ? "POST" : "GET",
        data: data || undefined
    }).then(function (r) { return r.json; }).catch(core.handleNetworkError);
}
function mergeFsPkg(pkg) {
    var e = lookup(pkg.path);
    if (!e) {
        e = {
            id: pkg.path,
            header: null,
            text: null,
            fsText: null
        };
        allScripts.push(e);
    }
    var time = pkg.files.map(function (f) { return f.mtime; });
    time.sort(function (a, b) { return b - a; });
    var modTime = Math.round(time[0] / 1000) || U.nowSeconds();
    var hd = {
        target: currentTarget,
        name: pkg.config.name,
        meta: {},
        editor: pxt.JAVASCRIPT_PROJECT_NAME,
        pubId: pkg.config.installedVersion,
        pubCurrent: false,
        _rev: null,
        id: pkg.path,
        recentUse: modTime,
        modificationTime: modTime,
        blobId: null,
        blobCurrent: false,
        isDeleted: false,
        icon: pkg.icon
    };
    if (!e.header) {
        e.header = hd;
    }
    else {
        var eh = e.header;
        eh.name = hd.name;
        eh.pubId = hd.pubId;
        eh.modificationTime = hd.modificationTime;
        eh.isDeleted = hd.isDeleted;
        eh.icon = hd.icon;
    }
}
function initAsync(target) {
    allScripts = [];
    currentTarget = target;
    // TODO check that target is correct.
    return syncAsync().then(function () { });
}
function fetchTextAsync(e) {
    return apiAsync("pkg/" + e.id)
        .then(function (resp) {
        if (!e.text) {
            // otherwise we were beaten to it
            e.text = {};
            e.mtime = 0;
            for (var _i = 0, _a = resp.files; _i < _a.length; _i++) {
                var f = _a[_i];
                e.text[f.name] = f.content;
                e.mtime = Math.max(e.mtime, f.mtime);
            }
            e.fsText = U.flatClone(e.text);
        }
        return e.text;
    });
}
var headerQ = new U.PromiseQueue();
function getTextAsync(id) {
    var e = lookup(id);
    if (!e)
        return Promise.resolve(null);
    if (e.text)
        return Promise.resolve(e.text);
    return headerQ.enqueue(id, function () { return fetchTextAsync(e); });
}
function saveCoreAsync(h, text) {
    if (h.temporary)
        return Promise.resolve();
    var e = lookup(h.id);
    U.assert(e.header === h);
    if (!text)
        return Promise.resolve();
    h.saveId = null;
    e.textNeedsSave = true;
    e.text = text;
    return headerQ.enqueue(h.id, function () {
        U.assert(!!e.fsText);
        var pkg = {
            files: [],
            config: null,
            path: h.id,
        };
        for (var _i = 0, _a = Object.keys(e.text); _i < _a.length; _i++) {
            var fn = _a[_i];
            if (e.text[fn] !== e.fsText[fn])
                pkg.files.push({
                    name: fn,
                    mtime: null,
                    content: e.text[fn],
                    prevContent: e.fsText[fn]
                });
        }
        var savedText = U.flatClone(e.text);
        if (pkg.files.length == 0)
            return Promise.resolve();
        return apiAsync("pkg/" + h.id, pkg)
            .then(function (pkg) {
            e.fsText = savedText;
            mergeFsPkg(pkg);
            data.invalidate("header:" + h.id);
            data.invalidate("header:*");
            if (text) {
                data.invalidate("text:" + h.id);
                h.saveId = null;
            }
        })
            .catch(function (e) { return core.errorNotification(lf("Save failed!")); });
    });
}
function saveAsync(h, text) {
    return saveCoreAsync(h, text);
}
function installAsync(h0, text) {
    var h = h0;
    var path = h.name.replace(/[^a-zA-Z0-9]+/g, " ").trim().replace(/ /g, "-");
    if (lookup(path)) {
        var n = 2;
        while (lookup(path + "-" + n))
            n++;
        path += "-" + n;
        h.name += " " + n;
    }
    h.id = path;
    h.recentUse = U.nowSeconds();
    h.modificationTime = h.recentUse;
    h.target = currentTarget;
    var e = {
        id: h.id,
        header: h,
        text: text,
        fsText: {}
    };
    allScripts.push(e);
    return saveCoreAsync(h, text)
        .then(function () { return h; });
}
function saveToCloudAsync(h) {
    return Promise.resolve();
}
function syncAsync() {
    return apiAsync("list").then(function (h) {
        h.pkgs.forEach(mergeFsPkg);
        data.invalidate("header:");
        data.invalidate("text:");
        return undefined;
    });
}
function saveScreenshotAsync(h, screenshot, icon) {
    return apiAsync("screenshot/" + h.id, { screenshot: screenshot, icon: icon });
}
function resetAsync() {
    return db.destroyAsync()
        .then(function () {
        allScripts = [];
        pxt.storage.clearLocal();
        data.clearCache();
    });
}
exports.provider = {
    getHeaders: getHeaders,
    getHeader: getHeader,
    getTextAsync: getTextAsync,
    initAsync: initAsync,
    saveAsync: saveAsync,
    installAsync: installAsync,
    saveToCloudAsync: saveToCloudAsync,
    syncAsync: syncAsync,
    resetAsync: resetAsync,
    saveScreenshotAsync: saveScreenshotAsync
};

},{"./core":11,"./data":12,"./db":13}],19:[function(require,module,exports){
"use strict";
function parseExampleMarkdown(name, md) {
    if (!md)
        return undefined;
    var m = /```(blocks?|typescript)\s*((.|\s)+?)\s*```/i.exec(md);
    if (!m)
        return undefined;
    return {
        name: name,
        filesOverride: {
            "main.blocks": "",
            "main.ts": m[2]
        }
    };
}
function parseGalleryMardown(md) {
    if (!md)
        return [];
    // second level titles are categories
    // ## foo bar
    // fenced code ```cards are sections of cards
    var galleries = [];
    var incard = false;
    var name = undefined;
    var cards = "";
    md.split(/\r?\n/).forEach(function (line) {
        // new category
        if (/^##/.test(line)) {
            name = line.substr(2).trim();
        }
        else if (/^```codecard$/.test(line)) {
            incard = true;
        }
        else if (/^```$/.test(line)) {
            incard = false;
            if (name && cards) {
                try {
                    var cardsJSON = JSON.parse(cards);
                    if (cardsJSON && cardsJSON.length > 0)
                        galleries.push({ name: name, cards: cardsJSON });
                }
                catch (e) {
                    pxt.log('invalid card format in gallery');
                }
            }
            cards = "";
            name = undefined;
        }
        else if (incard)
            cards += line + '\n';
    });
    return galleries;
}
function loadGalleryAsync(name) {
    return pxt.Cloud.downloadMarkdownAsync(name, pxt.Util.userLanguage(), pxt.Util.localizeLive)
        .then(function (md) { return parseGalleryMardown(md); });
}
exports.loadGalleryAsync = loadGalleryAsync;
function loadExampleAsync(name, path) {
    return pxt.Cloud.downloadMarkdownAsync(path, pxt.Util.userLanguage(), pxt.Util.localizeLive)
        .then(function (md) { return parseExampleMarkdown(name, md); });
}
exports.loadExampleAsync = loadExampleAsync;

},{}],20:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var Cloud = pxt.Cloud;
var U = pxt.Util;
var iface;
var devPath;
var HIDError = (function (_super) {
    __extends(HIDError, _super);
    function HIDError(msg) {
        _super.call(this, msg);
        this.message = msg;
    }
    return HIDError;
}(Error));
exports.HIDError = HIDError;
var bridgeByPath = {};
function onOOB(v) {
    var b = U.lookup(bridgeByPath, v.result.path);
    if (b) {
        b.onOOB(v);
    }
    else {
        console.error("Dropping data for " + v.result.path);
    }
}
function init() {
    if (!iface) {
        if (!Cloud.isLocalHost() || !Cloud.localToken)
            return;
        pxt.debug('initializing hid pipe');
        iface = pxt.worker.makeWebSocket("ws://localhost:" + pxt.options.wsPort + "/" + Cloud.localToken + "/hid", onOOB);
    }
}
function shouldUse() {
    var serial = pxt.appTarget.serial;
    return serial && serial.useHF2 && (Cloud.isLocalHost() && !!Cloud.localToken || pxt.winrt.isWinRT());
}
exports.shouldUse = shouldUse;
function mkBridgeAsync() {
    init();
    var raw = false;
    if (pxt.appTarget.serial && pxt.appTarget.serial.rawHID)
        raw = true;
    var b = new BridgeIO(raw);
    return b.initAsync()
        .then(function () { return b; });
}
pxt.HF2.mkPacketIOAsync = mkBridgeAsync;
var BridgeIO = (function () {
    function BridgeIO(rawMode) {
        var _this = this;
        if (rawMode === void 0) { rawMode = false; }
        this.rawMode = rawMode;
        this.onData = function (v) { };
        this.onEvent = function (v) { };
        this.onError = function (e) { };
        this.onSerial = function (v, isErr) { };
        if (rawMode)
            this.onEvent = function (v) { return _this.onData(v); };
    }
    BridgeIO.prototype.onOOB = function (v) {
        if (v.op == "serial") {
            this.onSerial(U.fromHex(v.result.data), v.result.isError);
        }
        else if (v.op = "event") {
            this.onEvent(U.fromHex(v.result.data));
        }
    };
    BridgeIO.prototype.talksAsync = function (cmds) {
        return iface.opAsync("talk", {
            path: this.dev.path,
            cmds: cmds.map(function (c) { return ({ cmd: c.cmd, data: c.data ? U.toHex(c.data) : "" }); })
        })
            .then(function (resp) {
            return resp.map(function (v) { return U.fromHex(v.data); });
        });
    };
    BridgeIO.prototype.error = function (msg) {
        throw new HIDError(U.lf("USB/HID error on device {0} ({1})", this.dev.product, msg));
    };
    BridgeIO.prototype.reconnectAsync = function () {
        return this.initAsync();
    };
    BridgeIO.prototype.disconnectAsync = function () {
        return iface.opAsync("disconnect", {
            path: this.dev.path
        });
    };
    BridgeIO.prototype.sendPacketAsync = function (pkt) {
        if (this.rawMode)
            return iface.opAsync("send", {
                path: this.dev.path,
                data: U.toHex(pkt),
                raw: true
            });
        throw new Error("should use talksAsync()!");
    };
    BridgeIO.prototype.sendSerialAsync = function (buf, useStdErr) {
        return iface.opAsync("sendserial", {
            path: this.dev.path,
            data: U.toHex(buf),
            isError: useStdErr
        });
    };
    BridgeIO.prototype.initAsync = function () {
        var _this = this;
        return iface.opAsync("list", {})
            .then(function (devs0) {
            var devs = devs0.devices;
            var d0 = devs.filter(function (d) { return (d.release & 0xff00) == 0x4200; })[0];
            if (pxt.appTarget.serial && pxt.appTarget.serial.rawHID)
                d0 = devs[0];
            if (d0) {
                if (_this.dev)
                    delete bridgeByPath[_this.dev.path];
                _this.dev = d0;
                bridgeByPath[_this.dev.path] = _this;
            }
            else
                throw new Error("No device connected");
        })
            .then(function () { return iface.opAsync("init", {
            path: _this.dev.path,
            raw: _this.rawMode,
        }); });
    };
    return BridgeIO;
}());
function hf2Async() {
    return pxt.HF2.mkPacketIOAsync()
        .then(function (h) {
        var w = new pxt.HF2.Wrapper(h);
        return w.reconnectAsync(true)
            .then(function () { return w; });
    });
}
var initPromise;
function initAsync() {
    var isFirstInit = false;
    if (!initPromise) {
        isFirstInit = true;
        initPromise = hf2Async()
            .catch(function (err) {
            initPromise = null;
            return Promise.reject(err);
        });
    }
    var wrapper;
    return initPromise
        .then(function (w) {
        wrapper = w;
        if (pxt.winrt.isWinRT() && !isFirstInit) {
            // For WinRT, disconnecting the device after flashing once puts the wrapper in a bad state.
            // To workaround this, reconnect every time.
            return wrapper.reconnectAsync();
        }
        return Promise.resolve();
    })
        .then(function () { return wrapper; });
}
exports.initAsync = initAsync;

},{}],21:[function(require,module,exports){
"use strict";
var data = require("./data");
var mem = require("./memoryworkspace");
function getHeaders() {
    return mem.provider.getHeaders();
}
function getHeader(id) {
    return mem.provider.getHeader(id);
}
function getTextAsync(id) {
    return mem.provider.getTextAsync(id);
}
function initAsync(trg) {
    return mem.provider.initAsync(trg);
}
function saveAsync(header, text) {
    return mem.provider.saveAsync(header, text)
        .then(function () { return pxt.editor.postHostMessageAsync({
        type: "pxthost",
        action: "workspacesave",
        project: { header: header, text: text },
        response: false
    }); }).then(function () { });
}
function installAsync(h0, text) {
    return mem.provider.installAsync(h0, text);
}
function saveToCloudAsync(h) {
    return mem.provider.saveToCloudAsync(h);
}
function syncAsync() {
    return pxt.editor.postHostMessageAsync({
        type: "pxthost",
        action: "workspacesync",
        response: true
    }).then(function (msg) {
        (msg.projects || []).forEach(mem.merge);
        data.invalidate("header:");
        data.invalidate("text:");
        return msg.editor;
    });
}
function resetAsync() {
    return mem.provider.resetAsync()
        .then(function () { return pxt.editor.postHostMessageAsync({
        type: "pxthost",
        action: "workspacereset",
        response: true
    }); }).then(function () { });
}
exports.provider = {
    getHeaders: getHeaders,
    getHeader: getHeader,
    getTextAsync: getTextAsync,
    initAsync: initAsync,
    saveAsync: saveAsync,
    installAsync: installAsync,
    saveToCloudAsync: saveToCloudAsync,
    syncAsync: syncAsync,
    resetAsync: resetAsync
};

},{"./data":12,"./memoryworkspace":25}],22:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var React = require("react");
var sui = require("./sui");
var codecard = require("./codecard");
var data = require("./data");
var lf = pxt.Util.lf;
var allLanguages = {
    "af": { englishName: "Afrikaans", localizedName: "Afrikaans" },
    "ar": { englishName: "Arabic", localizedName: "العربية" },
    "ca": { englishName: "Catalan", localizedName: "Català" },
    "cs": { englishName: "Czech", localizedName: "Čeština" },
    "da": { englishName: "Danish", localizedName: "Dansk" },
    "de": { englishName: "German", localizedName: "Deutsch" },
    "el": { englishName: "Greek", localizedName: "Ελληνικά" },
    "en": { englishName: "English", localizedName: "English" },
    "es-ES": { englishName: "Spanish (Spain)", localizedName: "Español (España)" },
    "fi": { englishName: "Finnish", localizedName: "Suomi" },
    "fr": { englishName: "French", localizedName: "Français" },
    "he": { englishName: "Hebrew", localizedName: "עברית" },
    "hu": { englishName: "Hungarian", localizedName: "Magyar" },
    "it": { englishName: "Italian", localizedName: "Italiano" },
    "ja": { englishName: "Japanese", localizedName: "日本語" },
    "ko": { englishName: "Korean", localizedName: "한국어" },
    "nl": { englishName: "Dutch", localizedName: "Nederlands" },
    "no": { englishName: "Norwegian", localizedName: "Norsk" },
    "pl": { englishName: "Polish", localizedName: "Polski" },
    "pt-BR": { englishName: "Portuguese (Brazil)", localizedName: "Português (Brasil)" },
    "pt-PT": { englishName: "Portuguese (Portugal)", localizedName: "Português (Portugal)" },
    "ro": { englishName: "Romanian", localizedName: "Română" },
    "ru": { englishName: "Russian", localizedName: "Русский" },
    "si-LK": { englishName: "Sinhala (Sri Lanka)", localizedName: "සිංහල (ශ්රී ලංකා)" },
    "sr": { englishName: "Serbian", localizedName: "Srpski" },
    "sv-SE": { englishName: "Swedish (Sweden)", localizedName: "Svenska (Sverige)" },
    "tr": { englishName: "Turkish", localizedName: "Türkçe" },
    "uk": { englishName: "Ukrainian", localizedName: "Українська" },
    "vi": { englishName: "Vietnamese", localizedName: "Tiếng việt" },
    "zh-CN": { englishName: "Chinese (Simplified, China)", localizedName: "简体中文 (中国)" },
    "zh-TW": { englishName: "Chinese (Traditional, Taiwan)", localizedName: "中文 (台湾)" },
};
var pxtLangCookieId = "PXT_LANG";
var langCookieExpirationDays = 30;
var defaultLanguages = ["en"];
function getCookieLang() {
    var cookiePropRegex = new RegExp(pxt.Util.escapeForRegex(pxtLangCookieId) + "=(.*?)(?:;|$)");
    var cookieValue = cookiePropRegex.exec(document.cookie);
    return cookieValue && cookieValue[1] || null;
}
exports.getCookieLang = getCookieLang;
function setCookieLang(langId) {
    if (!allLanguages[langId]) {
        return;
    }
    if (langId !== getCookieLang()) {
        pxt.tickEvent("menu.lang.setcookielang." + langId);
        var expiration = new Date();
        expiration.setTime(expiration.getTime() + (langCookieExpirationDays * 24 * 60 * 60 * 1000));
        document.cookie = pxtLangCookieId + "=" + langId + "; expires=" + expiration.toUTCString();
    }
}
exports.setCookieLang = setCookieLang;
var LanguagePicker = (function (_super) {
    __extends(LanguagePicker, _super);
    function LanguagePicker(props) {
        _super.call(this, props);
        this.state = {
            visible: false
        };
    }
    LanguagePicker.prototype.fetchLanguages = function () {
        if (!pxt.appTarget.appTheme.selectLanguage)
            return undefined;
        var targetConfig = this.getData("target-config:");
        return targetConfig ? targetConfig.languages : undefined;
    };
    LanguagePicker.prototype.changeLanguage = function (langId) {
        if (!allLanguages[langId]) {
            return;
        }
        setCookieLang(langId);
        if (langId !== exports.initialLang) {
            pxt.tickEvent("menu.lang.changelang." + langId);
            window.location.reload();
        }
        else {
            pxt.tickEvent("menu.lang.samelang." + langId);
            this.hide();
        }
    };
    LanguagePicker.prototype.hide = function () {
        this.setState({ visible: false });
    };
    LanguagePicker.prototype.show = function () {
        this.setState({ visible: true });
    };
    LanguagePicker.prototype.renderCore = function () {
        var _this = this;
        if (!this.state.visible)
            return React.createElement("div", null);
        var targetTheme = pxt.appTarget.appTheme;
        var fetchedLangs = this.fetchLanguages();
        var languagesToShow = fetchedLangs && fetchedLangs.length ? fetchedLangs : defaultLanguages;
        var modalSize = languagesToShow.length > 4 ? "large" : "small";
        return (React.createElement(sui.Modal, {open: this.state.visible, header: lf("Select Language"), size: modalSize, onClose: function () { return _this.hide(); }, dimmer: true, closeIcon: true, closeOnDimmerClick: true, closeOnDocumentClick: true}, !fetchedLangs ?
            React.createElement("div", {className: "ui message info"}, lf("loading...")) : undefined, fetchedLangs ? React.createElement("div", {className: "group"}, React.createElement("div", {className: "ui cards centered"}, languagesToShow.map(function (langId) {
            return React.createElement(codecard.CodeCardView, {className: "card-selected", key: langId, name: allLanguages[langId].localizedName, description: allLanguages[langId].englishName, onClick: function () { return _this.changeLanguage(langId); }});
        }))) : undefined, React.createElement("p", null, React.createElement("br", null), React.createElement("br", null), React.createElement("a", {href: "https://crowdin.com/project/" + targetTheme.crowdinProject, target: "_blank"}, lf("Help us translate")))));
    };
    return LanguagePicker;
}(data.Component));
exports.LanguagePicker = LanguagePicker;

},{"./codecard":8,"./data":12,"./sui":37,"react":267}],23:[function(require,module,exports){
/// <reference path="../../built/pxtsim.d.ts" />
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var React = require("react");
var ReactDOM = require("react-dom");
var core = require("./core");
var STREAM_INTERVAL = 30000;
var LogView = (function (_super) {
    __extends(LogView, _super);
    function LogView(props) {
        var _this = this;
        _super.call(this, props);
        this.lastStreamUploadTime = 0;
        this.streamUploadTimeout = 0;
        // resolve chrome extension info
        var serial = pxt.appTarget.serial || {};
        var chromeExtension = serial.chromeExtension;
        var m = /chromeserial=([a-z]+)/i.exec(window.location.href);
        if (m)
            chromeExtension = m[1];
        // init view
        this.view = new pxsim.logs.LogViewElement({
            maxEntries: 80,
            maxAccValues: 500,
            onClick: function (es) { return _this.onClick(es); },
            onTrendChartChanged: function () { return _this.setState({ trends: _this.view.hasTrends() }); },
            chromeExtension: chromeExtension,
            useHF2: serial.useHF2,
            productId: serial.productId,
            vendorId: serial.vendorId,
            nameFilter: serial.nameFilter
        });
        this.state = {};
    }
    LogView.prototype.componentDidMount = function () {
        var node = ReactDOM.findDOMNode(this);
        node.appendChild(this.view.element);
    };
    LogView.prototype.clear = function () {
        this.view.clear();
    };
    LogView.prototype.render = function () {
        return React.createElement("div", null);
    };
    LogView.prototype.componentDidUpdate = function () {
        var streams = pxt.appTarget.simulator && !!pxt.appTarget.simulator.streams;
        if (streams && this.state.stream)
            this.view.setLabel(lf("streaming to cloud"), "green cloudflash");
        else if (streams && this.state.trends)
            this.view.setLabel(lf("streaming off"), "gray");
        else
            this.view.setLabel(undefined);
        if (this.state.stream)
            this.scheduleStreamData();
    };
    LogView.prototype.cancelStreamData = function () {
        if (this.streamUploadTimeout) {
            clearTimeout(this.streamUploadTimeout);
            this.streamUploadTimeout = 0;
        }
    };
    LogView.prototype.scheduleStreamData = function () {
        var _this = this;
        this.cancelStreamData();
        var towait = Math.max(100, STREAM_INTERVAL - (Util.now() - this.lastStreamUploadTime));
        this.streamUploadTimeout = setTimeout(function () { return _this.streamData(); }, towait);
    };
    LogView.prototype.streamData = function () {
        var _this = this;
        var stream = this.state.stream;
        if (!stream) {
            if (this.streamUploadTimeout) {
                clearTimeout(this.streamUploadTimeout);
                this.streamUploadTimeout = 0;
            }
            return;
        }
        if (!pxt.Cloud.isOnline()) {
            this.scheduleStreamData();
            return;
        }
        pxt.debug('streaming payload...');
        var data = this.view.streamPayload(this.lastStreamUploadTime);
        this.lastStreamUploadTime = Util.now();
        if (!data) {
            this.scheduleStreamData();
            return;
        }
        pxt.streams.postPayloadAsync(stream, data)
            .catch(function (e) {
            core.warningNotification(lf("Oops, we could not upload your data..."));
            _this.scheduleStreamData();
        }).done(function () { return _this.scheduleStreamData(); });
    };
    LogView.prototype.setStream = function (stream) {
        this.setState({ stream: stream });
    };
    LogView.prototype.onClick = function (entries) {
        this.showStreamDialog(entries);
    };
    LogView.prototype.showStreamDialog = function (entries) {
        var _this = this;
        var targetTheme = pxt.appTarget.appTheme;
        var streaming = pxt.appTarget.simulator && !!pxt.appTarget.simulator.streams;
        var rootUrl = targetTheme.embedUrl;
        if (!rootUrl) {
            pxt.commands.browserDownloadAsync(pxsim.logs.entriesToCSV(entries), "data.csv", 'text/csv');
            return;
        }
        if (!/\/$/.test(rootUrl))
            rootUrl += '/';
        var streamUrl = this.state.stream ? rootUrl + this.state.stream.id : undefined;
        core.confirmAsync({
            logos: streaming ? ["https://az851932.vo.msecnd.net/pub/hjlxsmaf"] : undefined,
            header: lf("Analyze Data"),
            hideAgree: true,
            disagreeLbl: lf("Close"),
            onLoaded: function (_) {
                _.find('#datasavelocalfile').click(function () {
                    _.modal('hide');
                    pxt.commands.browserDownloadAsync(pxsim.logs.entriesToCSV(entries), "data.csv", 'text/csv');
                }),
                    _.find('#datastreamstart').click(function () {
                        _.modal('hide');
                        core.showLoading(lf("creating stream in Microsoft Azure..."));
                        pxt.streams.createStreamAsync(pxt.appTarget.id)
                            .then(function (stream) {
                            core.hideLoading();
                            _this.setStream(stream);
                        }).catch(function (e) {
                            pxt.reportException(e, {});
                            core.hideLoading();
                            core.warningNotification(lf("Oops, we could not create the stream. Please try again later."));
                        }).done();
                    });
                _.find('#datastreamstop').click(function () {
                    _.modal('hide');
                    _this.setStream(null);
                });
            },
            htmlBody: "\n<div class=\"ui cards\">\n    <div class=\"ui card\">\n        <div class=\"content\">\n            <div class=\"header\">" + lf("Local File") + "</div>\n            <div class=\"description\">\n                " + lf("Save the data to your 'Downloads' folder.") + "\n            </div>\n        </div>\n        <div id=\"datasavelocalfile\" class=\"ui bottom attached button\">\n            <i class=\"download icon\"></i>\n            " + lf("Download data") + "\n        </div>        \n    </div>\n    " + (streaming ?
                "<div id=\"datastreamcard\" class=\"ui card\">\n        <div class=\"content\">\n            <div class=\"header\">" + lf("Stream to Cloud") + "</div>\n            <div class=\"description\">\n                " + (streamUrl ? lf("We are uploading your data to Microsoft Azure every minute.")
                    : lf("Upload your data to Microsoft Azure to analyze it.")) + "\n            </div>\n        </div>\n        " + (streamUrl ?
                    "<div id=\"datastream\" class=\"ui bottom attached two buttons\">\n        <a target=\"_blank\" href=\"" + streamUrl + "\" class=\"ui green button\">Open</a>\n        <div id=\"datastreamstop\" class=\"ui button\">Stop</div>\n            </div>" :
                    "<div id=\"datastreamstart\" class=\"ui bottom attached green button\">\n                <i class=\"play icon\"></i>\n                " + lf("Start") + "\n                </div>") + "\n  </div>" : "") + "\n</div>"
        }).done();
    };
    return LogView;
}(React.Component));
exports.LogView = LogView;

},{"./core":11,"react":267,"react-dom":138}],24:[function(require,module,exports){
"use strict";
var pkg = require("./package");
var core = require("./core");
var compiler = require("./compiler");
function makeAsync() {
    return compiler.compileAsync({ native: true })
        .then(function (resp) {
        var p = pkg.mainEditorPkg();
        var code = p.files["main.ts"];
        var data = {
            name: p.header.name || lf("Untitled"),
            code: code ? code.content : "basic.showString(\"Hi!\");",
            board: JSON.stringify(pxt.appTarget.simulator.boardDefinition)
        };
        var parts = ts.pxtc.computeUsedParts(resp);
        if (parts.length) {
            data.parts = parts.join(" ");
            data.partdefs = JSON.stringify(pkg.mainPkg.computePartDefinitions(parts));
        }
        var fnArgs = resp.usedArguments;
        if (fnArgs)
            data.fnArgs = JSON.stringify(fnArgs);
        data.package = Util.values(pkg.mainPkg.deps).filter(function (p) { return p.id != "this"; }).map(function (p) { return (p.id + "=" + p._verspec); }).join('\n');
        var urlData = Object.keys(data).map(function (k) { return (k + "=" + encodeURIComponent(data[k])); }).join('&');
        var url = pxt.webConfig.partsUrl + "?" + urlData;
        return core.dialogAsync({
            hideCancel: true,
            header: lf("Make"),
            size: "large",
            htmlBody: "\n        <div class=\"ui container\">\n            <div style=\"position:relative;height:0;padding-bottom:40%;overflow:hidden;\">\n                <iframe style=\"position:absolute;top:0;left:0;width:100%;height:100%;\" src=\"" + url + "\" sandbox=\"allow-popups allow-forms allow-scripts allow-same-origin\"\n                    frameborder=\"0\"></iframe>\n            </div>\n        </div>",
            buttons: [{
                    label: lf("Open"),
                    url: url,
                    icon: "external"
                }]
        });
    }).then(function (r) {
    });
}
exports.makeAsync = makeAsync;

},{"./compiler":9,"./core":11,"./package":28}],25:[function(require,module,exports){
"use strict";
var U = pxt.Util;
exports.projects = {};
var target = "";
function merge(prj) {
    var h = prj.header;
    if (!h) {
        prj.header = h = {
            id: U.guidGen(),
            recentUse: U.nowSeconds(),
            modificationTime: U.nowSeconds(),
            target: target,
            _rev: undefined,
            blobId: undefined,
            blobCurrent: undefined,
            isDeleted: false,
            name: lf("Untitled"),
            meta: {},
            editor: pxt.BLOCKS_PROJECT_NAME,
            pubId: undefined,
            pubCurrent: undefined
        };
    }
    exports.projects[prj.header.id] = prj;
}
exports.merge = merge;
function getHeaders() {
    return Util.values(exports.projects).map(function (p) { return p.header; });
}
function getHeader(id) {
    var p = exports.projects[id];
    return p ? p.header : undefined;
}
function getTextAsync(id) {
    var p = exports.projects[id];
    return Promise.resolve(p ? p.text : undefined);
}
function initAsync(trg) {
    target = trg;
    return Promise.resolve();
}
function saveAsync(h, text) {
    exports.projects[h.id] = {
        header: h,
        text: text
    };
    return Promise.resolve();
}
function installAsync(h0, text) {
    var h = h0;
    h.id = U.guidGen();
    h.recentUse = U.nowSeconds();
    h.modificationTime = h.recentUse;
    h.target = pxt.appTarget.id;
    return saveAsync(h, text).then(function () { return h; });
}
function saveToCloudAsync(h) {
    return Promise.resolve();
}
function syncAsync() {
    return Promise.resolve(undefined);
}
function resetAsync() {
    exports.projects = {};
    target = "";
    return Promise.resolve();
}
exports.provider = {
    getHeaders: getHeaders,
    getHeader: getHeader,
    getTextAsync: getTextAsync,
    initAsync: initAsync,
    saveAsync: saveAsync,
    installAsync: installAsync,
    saveToCloudAsync: saveToCloudAsync,
    syncAsync: syncAsync,
    resetAsync: resetAsync
};

},{}],26:[function(require,module,exports){
/// <reference path="../../localtypings/monaco.d.ts" />
/// <reference path="../../built/pxteditor.d.ts" />
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var React = require("react");
var pkg = require("./package");
var core = require("./core");
var srceditor = require("./srceditor");
var compiler = require("./compiler");
var snippets = require("./monacoSnippets");
var Util = pxt.Util;
var lf = Util.lf;
var MIN_EDITOR_FONT_SIZE = 10;
var MAX_EDITOR_FONT_SIZE = 40;
var FileType;
(function (FileType) {
    FileType[FileType["Unknown"] = 0] = "Unknown";
    FileType[FileType["TypeScript"] = 1] = "TypeScript";
    FileType[FileType["Markdown"] = 2] = "Markdown";
})(FileType || (FileType = {}));
var Editor = (function (_super) {
    __extends(Editor, _super);
    function Editor() {
        _super.apply(this, arguments);
        this.fileType = FileType.Unknown;
        this.highlightDecorations = [];
    }
    Editor.prototype.hasBlocks = function () {
        if (!this.currFile)
            return true;
        var blockFile = this.currFile.getVirtualFileName();
        return (blockFile && pkg.mainEditorPkg().files[blockFile] != null);
    };
    Editor.prototype.openBlocks = function () {
        var _this = this;
        pxt.tickEvent("typescript.showBlocks");
        var header = this.parent.state.header;
        if (header) {
            header.editor = pxt.BLOCKS_PROJECT_NAME;
            header.pubCurrent = false;
        }
        var promise = Promise.resolve().then(function () {
            if (!_this.hasBlocks())
                return;
            var blockFile = _this.currFile.getVirtualFileName();
            if (!blockFile) {
                var mainPkg_1 = pkg.mainEditorPkg();
                if (!mainPkg_1 || !mainPkg_1.files["main.blocks"]) {
                    if (mainPkg_1) {
                        _this.parent.setFile(mainPkg_1.files["main.ts"]);
                    }
                    return;
                }
                _this.currFile = mainPkg_1.files["main.ts"];
                blockFile = _this.currFile.getVirtualFileName();
            }
            var failedAsync = function (file) {
                core.cancelAsyncLoading();
                _this.forceDiagnosticsUpdate();
                return _this.showConversionFailedDialog(file);
            };
            // might be undefined
            var mainPkg = pkg.mainEditorPkg();
            var xml;
            // it's a bit for a wild round trip:
            // 1) convert blocks to js to see if any changes happened, otherwise, just reload blocks
            // 2) decompile js -> blocks then take the decompiled blocks -> js
            // 3) check that decompiled js == current js % white space
            var blocksInfo;
            return _this.parent.saveFileAsync()
                .then(function () { return compiler.getBlocksAsync(); })
                .then(function (bi) {
                blocksInfo = bi;
                pxt.blocks.initBlocks(blocksInfo);
                var oldWorkspace = pxt.blocks.loadWorkspaceXml(mainPkg.files[blockFile].content);
                if (oldWorkspace) {
                    return pxt.blocks.compileAsync(oldWorkspace, blocksInfo).then(function (compilationResult) {
                        var oldJs = compilationResult.source;
                        return compiler.formatAsync(oldJs, 0).then(function (oldFormatted) {
                            return compiler.formatAsync(_this.editor.getValue(), 0).then(function (newFormatted) {
                                if (oldFormatted.formatted == newFormatted.formatted) {
                                    pxt.debug('js not changed, skipping decompile');
                                    pxt.tickEvent("typescript.noChanges");
                                    _this.parent.setFile(mainPkg.files[blockFile]);
                                    return [oldWorkspace, false]; // return false to indicate we don't want to decompile
                                }
                                else {
                                    return [oldWorkspace, true];
                                }
                            });
                        });
                    });
                }
                return [oldWorkspace, true];
            }).then(function (values) {
                if (!values)
                    return Promise.resolve();
                var oldWorkspace = values[0];
                var shouldDecompile = values[1];
                if (!shouldDecompile)
                    return Promise.resolve();
                return compiler.decompileAsync(_this.currFile.name, blocksInfo, oldWorkspace, blockFile)
                    .then(function (resp) {
                    if (!resp.success) {
                        _this.currFile.diagnostics = resp.diagnostics;
                        return failedAsync(blockFile);
                    }
                    xml = resp.outfiles[blockFile];
                    Util.assert(!!xml);
                    return mainPkg.setContentAsync(blockFile, xml)
                        .then(function () { return _this.parent.setFile(mainPkg.files[blockFile]); });
                });
            }).catch(function (e) {
                pxt.reportException(e);
                core.errorNotification(lf("Oops, something went wrong trying to convert your code."));
            });
        });
        core.showLoadingAsync(lf("switching to blocks..."), promise).done();
    };
    Editor.prototype.showConversionFailedDialog = function (blockFile) {
        var _this = this;
        var bf = pkg.mainEditorPkg().files[blockFile];
        return core.confirmAsync({
            header: lf("Oops, there is a problem converting your code."),
            body: lf("We are unable to convert your JavaScript code back to blocks. You can keep working in JavaScript or discard your changes and go back to the previous Blocks version."),
            agreeLbl: lf("Discard and go to Blocks"),
            agreeClass: "cancel",
            agreeIcon: "cancel",
            disagreeLbl: lf("Stay in JavaScript"),
            disagreeClass: "positive",
            disagreeIcon: "checkmark",
            size: "medium",
            hideCancel: !bf
        }).then(function (b) {
            // discard
            if (!b) {
                pxt.tickEvent("typescript.keepText");
            }
            else {
                pxt.tickEvent("typescript.discardText");
                _this.parent.saveBlocksToTypeScriptAsync().then(function (src) {
                    _this.overrideFile(src);
                    _this.parent.setFile(bf);
                });
            }
        });
    };
    Editor.prototype.decompileAsync = function (blockFile) {
        return compiler.decompileAsync(blockFile)
            .then(function (resp) { return resp.success; });
    };
    Editor.prototype.display = function () {
        return (React.createElement("div", {className: 'full-abs', id: "monacoEditorArea"}, React.createElement("div", {id: 'monacoEditorToolbox', className: 'injectionDiv'}), React.createElement("div", {id: 'monacoEditorInner'})));
    };
    Editor.prototype.defineEditorTheme = function (hc) {
        var _this = this;
        var inverted = pxt.appTarget.appTheme.invertedMonaco;
        var invertedColorluminosityMultipler = 0.6;
        var rules = [];
        if (!hc) {
            this.getNamespaces().forEach(function (ns) {
                var metaData = _this.getNamespaceAttrs(ns);
                var blocks = snippets.isBuiltin(ns) ? snippets.getBuiltinCategory(ns).blocks : _this.nsMap[ns];
                if (metaData.color && blocks) {
                    var hexcolor_1 = pxt.blocks.convertColour(metaData.color);
                    hexcolor_1 = (inverted ? Blockly.PXTUtils.fadeColour(hexcolor_1, invertedColorluminosityMultipler, true) : hexcolor_1).replace('#', '');
                    blocks.forEach(function (fn) {
                        rules.push({ token: "identifier.ts " + fn.name, foreground: hexcolor_1 });
                    });
                    rules.push({ token: "identifier.ts " + ns, foreground: hexcolor_1 });
                }
            });
            rules.push({ token: "identifier.ts if", foreground: '5B80A5', });
            rules.push({ token: "identifier.ts else", foreground: '5B80A5', });
            rules.push({ token: "identifier.ts while", foreground: '5BA55B', });
            rules.push({ token: "identifier.ts for", foreground: '5BA55B', });
        }
        var colors = pxt.appTarget.appTheme.monacoColors || {};
        monaco.editor.defineTheme('pxtTheme', {
            base: hc ? 'hc-black' : (inverted ? 'vs-dark' : 'vs'),
            inherit: true,
            rules: rules,
            colors: hc ? {} : colors
        });
        monaco.editor.setTheme('pxtTheme');
    };
    Editor.prototype.setHighContrast = function (hc) {
        this.defineEditorTheme(hc);
    };
    Editor.prototype.beforeCompile = function () {
        if (this.editor)
            this.editor.getAction('editor.action.formatDocument').run();
    };
    Editor.prototype.textAndPosition = function (pos) {
        var programText = this.editor.getValue();
        var lines = pos.lineNumber;
        var chars = pos.column;
        var charNo = 0;
        for (; charNo < programText.length; ++charNo) {
            if (lines == 0) {
                if (chars-- == 0)
                    break;
            }
            else if (programText[charNo] == '\n')
                lines--;
        }
        return { programText: programText, charNo: charNo };
    };
    Editor.prototype.isIncomplete = function () {
        return this.editor && this.editor._view ?
            this.editor._view.contentWidgets._widgets["editor.widget.suggestWidget"].isVisible :
            false;
    };
    Editor.prototype.resize = function (e) {
        var monacoArea = document.getElementById('monacoEditorArea');
        var monacoToolbox = document.getElementById('monacoEditorToolbox');
        if (monacoArea && monacoToolbox && this.editor) {
            this.editor.layout({ width: monacoArea.offsetWidth - monacoToolbox.clientWidth, height: monacoArea.offsetHeight });
        }
    };
    Editor.prototype.prepare = function () {
        this.isReady = true;
    };
    Editor.prototype.loadMonacoAsync = function () {
        var _this = this;
        if (this.editor || this.loadingMonaco)
            return Promise.resolve();
        this.loadingMonaco = true;
        this.extraLibs = Object.create(null);
        var editorArea = document.getElementById("monacoEditorArea");
        var editorElement = document.getElementById("monacoEditorInner");
        return pxt.vs.initMonacoAsync(editorElement).then(function (editor) {
            _this.editor = editor;
            _this.loadingMonaco = false;
            _this.editor.updateOptions({ fontSize: _this.parent.settings.editorFontSize });
            _this.editor.addAction({
                id: "save",
                label: lf("Save"),
                keybindings: [monaco.KeyMod.CtrlCmd | monaco.KeyCode.KEY_S],
                keybindingContext: "!editorReadonly",
                precondition: "!editorReadonly",
                contextMenuGroupId: "0_pxtnavigation",
                contextMenuOrder: 0.2,
                run: function () { return Promise.resolve(_this.parent.typecheckNow()); }
            });
            _this.editor.addAction({
                id: "runSimulator",
                label: lf("Run Simulator"),
                keybindings: [monaco.KeyMod.CtrlCmd | monaco.KeyCode.Enter],
                keybindingContext: "!editorReadonly",
                precondition: "!editorReadonly",
                contextMenuGroupId: "0_pxtnavigation",
                contextMenuOrder: 0.21,
                run: function () { return Promise.resolve(_this.parent.runSimulator()); }
            });
            if (pxt.appTarget.compile && pxt.appTarget.compile.hasHex) {
                _this.editor.addAction({
                    id: "compileHex",
                    label: lf("Download"),
                    keybindings: [monaco.KeyMod.CtrlCmd | monaco.KeyMod.Alt | monaco.KeyCode.Enter],
                    keybindingContext: "!editorReadonly",
                    precondition: "!editorReadonly",
                    contextMenuGroupId: "0_pxtnavigation",
                    contextMenuOrder: 0.22,
                    run: function () { return Promise.resolve(_this.parent.compile()); }
                });
            }
            _this.editor.addAction({
                id: "zoomIn",
                label: lf("Zoom In"),
                keybindings: [monaco.KeyMod.CtrlCmd | monaco.KeyCode.NUMPAD_ADD, monaco.KeyMod.CtrlCmd | monaco.KeyCode.US_EQUAL],
                run: function () { return Promise.resolve(_this.zoomIn()); }
            });
            _this.editor.addAction({
                id: "zoomOut",
                label: lf("Zoom Out"),
                keybindings: [monaco.KeyMod.CtrlCmd | monaco.KeyCode.NUMPAD_SUBTRACT, monaco.KeyMod.CtrlCmd | monaco.KeyCode.US_MINUS],
                run: function () { return Promise.resolve(_this.zoomOut()); }
            });
            if (pxt.appTarget.appTheme.hasReferenceDocs) {
                var referenceContextKey_1 = _this.editor.createContextKey("editorHasReference", false);
                _this.editor.addAction({
                    id: "reference",
                    label: lf("Help"),
                    keybindingContext: "!editorReadonly && editorHasReference",
                    precondition: "!editorReadonly && editorHasReference",
                    contextMenuGroupId: "navigation",
                    contextMenuOrder: 0.1,
                    run: function () { return Promise.resolve(_this.loadReference()); }
                });
                _this.editor.onDidChangeCursorPosition(function (e) {
                    var word = _this.editor.getModel().getWordUntilPosition(e.position);
                    if (word && word.word != "") {
                        referenceContextKey_1.set(true);
                    }
                    else {
                        referenceContextKey_1.reset();
                    }
                });
            }
            _this.editor.onDidLayoutChange(function (e) {
                // Update editor font size in settings after a ctrl+scroll zoom
                var currentFont = _this.editor.getConfiguration().fontInfo.fontSize;
                if (_this.parent.settings.editorFontSize != currentFont) {
                    _this.parent.settings.editorFontSize = currentFont;
                    _this.forceDiagnosticsUpdate();
                }
                // Update widgets
                var toolbox = document.getElementById('monacoEditorToolbox');
                toolbox.style.height = _this.editor.getLayoutInfo().contentHeight + "px";
                var flyout = document.getElementById('monacoFlyoutWidget');
                flyout.style.height = _this.editor.getLayoutInfo().contentHeight + "px";
            });
            var monacoEditorInner = document.getElementById('monacoEditorInner');
            monacoEditorInner.ondragenter = (function (ev) {
                ev.preventDefault();
                ev.stopPropagation();
            });
            monacoEditorInner.ondragover = (function (ev) {
                ev.preventDefault();
                ev.stopPropagation();
                var mouseTarget = _this.editor.getTargetAtClientPoint(ev.clientX, ev.clientY);
                var position = mouseTarget.position;
                if (position && _this.editor.getPosition() != position)
                    _this.editor.setPosition(position);
                _this.editor.focus();
            });
            monacoEditorInner.ondrop = (function (ev) {
                var insertText = ev.dataTransfer.getData('text'); // IE11 only support "text"
                if (!insertText)
                    return;
                ev.preventDefault();
                ev.stopPropagation();
                var mouseTarget = _this.editor.getTargetAtClientPoint(ev.clientX, ev.clientY);
                var position = mouseTarget.position;
                var model = _this.editor.getModel();
                var currPos = _this.editor.getPosition();
                var cursor = model.getOffsetAt(currPos);
                if (!position)
                    position = currPos;
                insertText = (currPos.column > 1) ? '\n' + insertText :
                    model.getWordUntilPosition(currPos) != undefined && model.getWordUntilPosition(currPos).word != '' ?
                        insertText + '\n' : insertText;
                if (insertText.indexOf('{{}}') > -1) {
                    cursor += (insertText.indexOf('{{}}'));
                    insertText = insertText.replace('{{}}', '');
                }
                else
                    cursor += (insertText.length);
                _this.editor.pushUndoStop();
                _this.editor.executeEdits("", [
                    {
                        identifier: { major: 0, minor: 0 },
                        range: new monaco.Range(position.lineNumber, position.column, position.lineNumber, position.column),
                        text: insertText,
                        forceMoveMarkers: true,
                        isAutoWhitespaceEdit: true
                    }
                ]);
                _this.beforeCompile();
                _this.editor.pushUndoStop();
                var endPos = model.getPositionAt(cursor);
                _this.editor.setPosition(endPos);
                _this.editor.focus();
            });
            _this.editor.onDidFocusEditorText(function () {
                _this.resetFlyout(true);
            });
            _this.editorViewZones = [];
            _this.setupToolbox(editorArea);
        });
    };
    Editor.prototype.undo = function () {
        if (!this.editor)
            return;
        this.editor.trigger('keyboard', 'undo', null);
    };
    Editor.prototype.redo = function () {
        if (!this.editor)
            return;
        this.editor.trigger('keyboard', 'redo', null);
    };
    Editor.prototype.zoomIn = function () {
        if (!this.editor)
            return;
        if (this.parent.settings.editorFontSize >= MAX_EDITOR_FONT_SIZE)
            return;
        var currentFont = this.editor.getConfiguration().fontInfo.fontSize;
        this.parent.settings.editorFontSize = currentFont + 1;
        this.editor.updateOptions({ fontSize: this.parent.settings.editorFontSize });
        this.forceDiagnosticsUpdate();
    };
    Editor.prototype.zoomOut = function () {
        if (!this.editor)
            return;
        if (this.parent.settings.editorFontSize <= MIN_EDITOR_FONT_SIZE)
            return;
        var currentFont = this.editor.getConfiguration().fontInfo.fontSize;
        this.parent.settings.editorFontSize = currentFont - 1;
        this.editor.updateOptions({ fontSize: this.parent.settings.editorFontSize });
        this.forceDiagnosticsUpdate();
    };
    Editor.prototype.loadReference = function () {
        Util.assert(this.editor != undefined); // Guarded
        var currentPosition = this.editor.getPosition();
        var wordInfo = this.editor.getModel().getWordAtPosition(currentPosition);
        if (!wordInfo)
            return;
        var prevWordInfo = this.editor.getModel().getWordUntilPosition(new monaco.Position(currentPosition.lineNumber, wordInfo.startColumn - 1));
        if (prevWordInfo && wordInfo) {
            var namespaceName = prevWordInfo.word.replace(/([A-Z]+)/g, "-$1");
            var methodName = wordInfo.word.replace(/([A-Z]+)/g, "-$1");
            this.parent.setSideDoc("/reference/" + namespaceName + "/" + methodName, false);
        }
        else if (wordInfo) {
            var methodName = wordInfo.word.replace(/([A-Z]+)/g, "-$1");
            this.parent.setSideDoc("/reference/" + methodName, false);
        }
    };
    Editor.prototype.setupToolbox = function (editorElement) {
        // Monaco flyout widget
        var flyoutWidget = {
            getId: function () {
                return 'pxt.flyout.widget';
            },
            getDomNode: function () {
                if (!this.domNode) {
                    this.domNode = document.createElement('div');
                    this.domNode.id = 'monacoFlyoutWidget';
                    this.domNode.style.top = "0";
                    this.domNode.className = 'monacoFlyout';
                    // Hide by default
                    this.domNode.style.display = 'none';
                    this.domNode.innerText = 'Flyout';
                }
                return this.domNode;
            },
            getPosition: function () {
                return null;
            }
        };
        this.editor.addOverlayWidget(flyoutWidget);
    };
    Editor.prototype.resetFlyout = function (clear) {
        // Hide the flyout
        var flyout = document.getElementById('monacoFlyoutWidget');
        flyout.innerHTML = '';
        flyout.style.display = 'none';
        // Hide the currnet toolbox category
        if (this.selectedCategoryRow) {
            this.selectedCategoryRow.style.background = "" + this.selectedCategoryBackgroundColor;
            this.selectedCategoryRow.style.color = "" + this.selectedCategoryColor;
            this.selectedCategoryRow.className = 'blocklyTreeRow';
        }
        this.parent.setState({ hideEditorFloats: !clear });
        if (clear) {
            this.selectedCategoryRow = null;
        }
    };
    Editor.prototype.updateToolbox = function () {
        var _this = this;
        var appTheme = pxt.appTarget.appTheme;
        if (!appTheme.monacoToolbox || pxt.shell.isReadOnly())
            return;
        // Toolbox div
        var toolbox = document.getElementById('monacoEditorToolbox');
        // Move the monaco editor to make room for the toolbox div
        this.editor.getLayoutInfo().glyphMarginLeft = 200;
        this.editor.layout();
        var monacoEditor = this;
        // clear the toolbox
        toolbox.innerHTML = '';
        // Add an overlay widget for the toolbox
        toolbox.style.height = monacoEditor.editor.getLayoutInfo().contentHeight + "px";
        var root = document.createElement('div');
        root.className = 'blocklyTreeRoot';
        toolbox.appendChild(root);
        var group = document.createElement('div');
        group.setAttribute('role', 'group');
        root.appendChild(group);
        var namespaces = this.getNamespaces().map(function (ns) { return [ns, _this.getNamespaceAttrs(ns)]; });
        var hasAdvanced = namespaces.some(function (_a) {
            var md = _a[1];
            return md.advanced;
        });
        // Non-advanced categories
        appendCategories(group, namespaces.filter(function (_a) {
            var md = _a[1];
            return !(md.advanced);
        }));
        if (hasAdvanced) {
            // Advanced seperator
            group.appendChild(Editor.createTreeSeperator());
            // Advanced toggle
            group.appendChild(this.createCategoryElement("", pxt.blocks.getNamespaceColor('advanced'), this.showAdvanced ? 'advancedexpanded' : 'advancedcollapsed', false, null, function () {
                _this.showAdvanced = !_this.showAdvanced;
                _this.updateToolbox();
                _this.parent.setState({ hideEditorFloats: false });
                _this.resize();
            }, lf("{id:category}Advanced")));
        }
        if (this.showAdvanced) {
            appendCategories(group, namespaces.filter(function (_a) {
                var md = _a[1];
                return md.advanced;
            }));
        }
        if ((!hasAdvanced || this.showAdvanced) && pxt.appTarget.cloud && pxt.appTarget.cloud.packages) {
            if (!hasAdvanced) {
                // Add a seperator
                group.appendChild(Editor.createTreeSeperator());
            }
            // Add package button
            group.appendChild(this.createCategoryElement("", "#717171", "addpackage", false, null, function () {
                _this.resetFlyout();
                _this.parent.addPackage();
            }, lf("{id:category}Add Package")));
        }
        // Inject toolbox icon css
        pxt.blocks.injectToolboxIconCss();
        function appendCategories(group, names) {
            return names
                .sort(function (_a, _b) {
                var md1 = _a[1];
                var md2 = _b[1];
                // sort by fn weight
                var w2 = (md2 ? md2.weight || 50 : 50);
                var w1 = (md1 ? md1.weight || 50 : 50);
                return w2 - w1;
            }).forEach(function (_a) {
                var ns = _a[0], md = _a[1];
                var el;
                if (!snippets.isBuiltin(ns)) {
                    var blocks_1 = monacoEditor.nsMap[ns].filter(function (block) { return !(block.attributes.blockHidden || block.attributes.deprecated); });
                    var categoryName = md.block ? md.block : undefined;
                    el = monacoEditor.createCategoryElement(ns, md.color, md.icon, true, blocks_1, undefined, categoryName, md.groups, md.labelLineWidth);
                }
                else {
                    var cat = snippets.getBuiltinCategory(ns);
                    var blocks_2 = cat.blocks;
                    var name_1 = cat.name;
                    if (!blocks_2 || !blocks_2.length) {
                        return;
                    }
                    blocks_2.forEach(function (b) { b.noNamespace = true; });
                    if (monacoEditor.nsMap[ns.toLowerCase()])
                        blocks_2 = blocks_2.concat(monacoEditor.nsMap[ns.toLowerCase()].filter(function (block) { return !(block.attributes.blockHidden || block.attributes.deprecated); }));
                    el = monacoEditor.createCategoryElement(ns, md.color, md.icon, false, blocks_2, null, name_1);
                }
                if (el)
                    group.appendChild(el);
            });
        }
    };
    Editor.prototype.getNamespaceAttrs = function (ns) {
        var builtin = snippets.getBuiltinCategory(ns);
        if (builtin) {
            builtin.attributes.color = pxt.blocks.getNamespaceColor(builtin.nameid);
            return builtin.attributes;
        }
        var info = this.blockInfo.apis.byQName[ns];
        if (info && info.attributes.color) {
            return info.attributes;
        }
        return undefined;
    };
    Editor.prototype.getNamespaces = function () {
        var _this = this;
        var namespaces = Object.keys(this.nsMap).filter(function (ns) { return !snippets.isBuiltin(ns) && !!_this.getNamespaceAttrs(ns); });
        var config = pxt.appTarget.runtime || {};
        if (config.loopsBlocks && !snippets.loops.removed)
            namespaces.push(snippets.loops.nameid);
        if (config.logicBlocks && !snippets.logic.removed)
            namespaces.push(snippets.logic.nameid);
        if (config.variablesBlocks && !snippets.variables.removed)
            namespaces.push(snippets.variables.nameid);
        if (config.mathBlocks && !snippets.maths.removed)
            namespaces.push(snippets.maths.nameid);
        if (config.functionBlocks && !snippets.functions.removed)
            namespaces.push(snippets.functions.nameid);
        if (config.textBlocks && !snippets.text.removed)
            namespaces.push(snippets.text.nameid);
        if (config.listsBlocks && !snippets.arrays.removed)
            namespaces.push(snippets.arrays.nameid);
        return namespaces;
    };
    Editor.createTreeSeperator = function () {
        var treeitem = Editor.createTreeItem();
        var treeSeperator = document.createElement("div");
        treeSeperator.setAttribute("class", "blocklyTreeSeparator");
        treeitem.appendChild(treeSeperator);
        return treeitem;
    };
    Editor.createTreeItem = function () {
        var treeitem = document.createElement('div');
        treeitem.setAttribute('role', 'treeitem');
        return treeitem;
    };
    Editor.prototype.createCategoryElement = function (ns, metaColor, icon, injectIconClass, fns, onClick, category, groups, labelLineWidth) {
        var _this = this;
        if (injectIconClass === void 0) { injectIconClass = true; }
        // Filter the toolbox
        var filters = this.parent.state.filters;
        var categoryState = filters ? (filters.namespaces && filters.namespaces[ns] != undefined ? filters.namespaces[ns] : filters.defaultState) : undefined;
        var hasChild = false;
        if (filters && categoryState !== undefined && fns) {
            Object.keys(fns).forEach(function (fn) {
                var fnState = filters.fns && filters.fns[fn] != undefined ? filters.fns[fn] : (categoryState != undefined ? categoryState : filters.defaultState);
                if (fnState == pxt.editor.FilterState.Disabled || fnState == pxt.editor.FilterState.Visible)
                    hasChild = true;
            });
        }
        else {
            hasChild = true;
        }
        if (!hasChild)
            return;
        var appTheme = pxt.appTarget.appTheme;
        var monacoEditor = this;
        // Create a tree item
        var treeitem = Editor.createTreeItem();
        var treerow = document.createElement('div');
        var color = pxt.blocks.convertColour(metaColor);
        treeitem.onclick = function (ev) {
            pxt.tickEvent("monaco.toolbox.click");
            var monacoFlyout = document.getElementById('monacoFlyoutWidget');
            monacoEditor.resetFlyout(false);
            // Hide the toolbox if the current category is clicked twice
            if (monacoEditor.selectedCategoryRow == treerow) {
                monacoEditor.selectedCategoryRow = null;
                monacoFlyout.style.display = 'none';
                treerow.className = 'blocklyTreeRow';
                _this.parent.setState({ hideEditorFloats: false });
                return;
            }
            else {
                // Selected category
                treerow.style.background = appTheme.invertedToolbox ?
                    "" + Blockly.PXTUtils.fadeColour(color, Blockly.Options.invertedMultiplier, false) :
                    "" + color;
                treerow.style.color = '#fff';
                treerow.className += ' blocklyTreeSelected';
                monacoEditor.selectedCategoryRow = treerow;
                if (appTheme.invertedToolbox) {
                    // Inverted toolbox
                    monacoEditor.selectedCategoryColor = '#fff';
                    monacoEditor.selectedCategoryBackgroundColor = color;
                }
                else {
                    monacoEditor.selectedCategoryColor = color;
                    monacoEditor.selectedCategoryBackgroundColor = 'none';
                }
            }
            monacoFlyout.style.left = monacoEditor.editor.getLayoutInfo().lineNumbersLeft + "px";
            monacoFlyout.style.height = monacoEditor.editor.getLayoutInfo().contentHeight + "px";
            monacoFlyout.style.display = 'block';
            monacoFlyout.className = 'monacoFlyout';
            monacoFlyout.style.transform = 'none';
            if (onClick) {
                // No flyout
                onClick();
            }
            else {
                // Create a flyout and add the category methods in there
                // Add the heading label
                if (!pxt.appTarget.appTheme.hideFlyoutHeadings && pxt.BrowserUtils.isMobile()) {
                    var monacoHeadingLabel = document.createElement('div');
                    monacoHeadingLabel.className = 'monacoFlyoutLabel monacoFlyoutHeading';
                    var monacoHeadingIcon = document.createElement('span');
                    var iconClass_1 = ("blocklyTreeIcon" + (icon ? (ns || icon).toLowerCase() : 'Default')).replace(/\s/g, '');
                    monacoHeadingIcon.className = "monacoFlyoutHeadingIcon blocklyTreeIcon " + iconClass_1;
                    monacoHeadingIcon.setAttribute('role', 'presentation');
                    monacoHeadingIcon.style.display = 'inline-block';
                    monacoHeadingIcon.style.color = "" + color;
                    var monacoHeadingText = document.createElement('div');
                    monacoHeadingText.className = "monacoFlyoutHeadingText";
                    monacoHeadingText.style.display = 'inline-block';
                    monacoHeadingText.style.fontSize = (monacoEditor.parent.settings.editorFontSize + 5) + "px";
                    monacoHeadingText.textContent = category ? category : "" + Util.capitalize(ns);
                    monacoHeadingLabel.appendChild(monacoHeadingIcon);
                    monacoHeadingLabel.appendChild(monacoHeadingText);
                    monacoFlyout.appendChild(monacoHeadingLabel);
                }
                // Organize and rearrange methods into groups
                var blockGroups = {};
                var sortedGroups_1 = [];
                if (groups)
                    sortedGroups_1 = groups;
                // Organize the blocks into the different groups
                for (var bi = 0; bi < fns.length; ++bi) {
                    var blk = fns[bi];
                    var group = blk.attributes.group || 'other';
                    if (!blockGroups[group])
                        blockGroups[group] = [];
                    blockGroups[group].push(blk);
                }
                // Add any missing groups to the sorted groups list
                Object.keys(blockGroups).sort().forEach(function (group) {
                    if (sortedGroups_1.indexOf(group) == -1) {
                        sortedGroups_1.push(group);
                    }
                });
                // Add labels and insert the blocks into the flyout
                for (var bg = 0; bg < sortedGroups_1.length; ++bg) {
                    var group = sortedGroups_1[bg];
                    // Add the group label
                    if (group != 'other') {
                        var groupLabel = document.createElement('div');
                        groupLabel.className = 'monacoFlyoutLabel blocklyFlyoutGroup';
                        var groupLabelText = document.createElement('div');
                        groupLabelText.className = 'monacoFlyoutLabelText';
                        groupLabelText.style.fontSize = monacoEditor.parent.settings.editorFontSize + "px";
                        groupLabelText.textContent = pxt.Util.rlf("{id:group}" + group);
                        groupLabel.appendChild(groupLabelText);
                        monacoFlyout.appendChild(groupLabel);
                        var groupLabelLine = document.createElement('hr');
                        groupLabelLine.className = 'monacoFlyoutLabelLine';
                        groupLabelLine.align = 'left';
                        groupLabelLine.style.width = (labelLineWidth || groupLabelText.offsetWidth) + "px";
                        groupLabel.appendChild(groupLabelLine);
                    }
                    // Add the blocks in that group
                    if (blockGroups[group])
                        _this.createMonacoBlocks(monacoEditor, monacoFlyout, ns, blockGroups[group], color, filters, categoryState);
                }
            }
        };
        treerow.className = 'blocklyTreeRow';
        treeitem.appendChild(treerow);
        var iconBlank = document.createElement('span');
        var iconNone = document.createElement('span');
        var label = document.createElement('span');
        var iconClass = ("blocklyTreeIcon" + (icon ? (ns || icon).toLowerCase() : 'Default')).replace(/\s/g, '');
        iconBlank.className = 'blocklyTreeIcon';
        iconBlank.setAttribute('role', 'presentation');
        iconNone.className = "blocklyTreeIcon " + iconClass;
        iconNone.setAttribute('role', 'presentation');
        iconNone.style.display = 'inline-block';
        label.className = 'blocklyTreeLabel';
        treerow.appendChild(iconBlank);
        treerow.appendChild(iconNone);
        treerow.appendChild(label);
        if (appTheme.coloredToolbox) {
            // Colored toolbox
            treerow.style.color = "" + color;
            treerow.style.borderLeft = "8px solid " + color;
        }
        else if (appTheme.invertedToolbox) {
            // Inverted toolbox
            treerow.style.color = '#fff';
            treerow.style.background = (color || '#ddd');
            treerow.onmouseenter = function () {
                if (treerow != monacoEditor.selectedCategoryRow) {
                    treerow.style.background = Blockly.PXTUtils.fadeColour(color || '#ddd', Blockly.Options.invertedMultiplier, false);
                }
            };
            treerow.onmouseleave = function () {
                if (treerow != monacoEditor.selectedCategoryRow) {
                    treerow.style.background = (color || '#ddd');
                }
            };
        }
        else {
            // Standard toolbox
            treerow.style.borderLeft = "8px solid " + color;
        }
        if (icon && injectIconClass) {
            pxt.blocks.appendToolboxIconCss(iconClass, icon);
        }
        treerow.style.paddingLeft = '0px';
        label.innerText = category ? category : "" + Util.capitalize(ns);
        return treeitem;
    };
    Editor.prototype.createMonacoBlocks = function (monacoEditor, monacoFlyout, ns, fns, color, filters, categoryState) {
        var _this = this;
        // Render the method blocks
        fns.sort(function (f1, f2) {
            // sort by fn weight
            var w2 = (f2.attributes.weight || 50) + (f2.attributes.advanced ? 0 : 1000);
            var w1 = (f1.attributes.weight || 50) + (f1.attributes.advanced ? 0 : 1000);
            return w2 - w1;
        })
            .forEach(function (fn) {
            var monacoBlockDisabled = false;
            var fnState = filters ? (filters.fns && filters.fns[fn.name] != undefined ? filters.fns[fn.name] : (categoryState != undefined ? categoryState : filters.defaultState)) : undefined;
            monacoBlockDisabled = fnState == pxt.editor.FilterState.Disabled;
            if (fnState == pxt.editor.FilterState.Hidden)
                return;
            var monacoBlockArea = document.createElement('div');
            var monacoBlock = document.createElement('div');
            monacoBlock.className = 'monacoDraggableBlock';
            monacoBlock.style.fontSize = monacoEditor.parent.settings.editorFontSize + "px";
            monacoBlock.style.backgroundColor = monacoBlockDisabled ?
                "" + Blockly.PXTUtils.fadeColour(color || '#ddd', 0.8, false) :
                "" + color;
            monacoBlock.style.borderColor = "" + color;
            var snippet = fn.snippet;
            var comment = fn.attributes.jsDoc;
            var snippetPrefix = fn.noNamespace ? "" : ns;
            var element = fn;
            if (element.attributes.block) {
                if (element.attributes.defaultInstance) {
                    snippetPrefix = element.attributes.defaultInstance;
                }
                else {
                    var nsInfo_1 = _this.blockInfo.apis.byQName[element.namespace];
                    if (nsInfo_1.kind === pxtc.SymbolKind.Class) {
                        return;
                    }
                    else if (nsInfo_1.attributes.fixedInstances) {
                        var instances = Util.values(_this.blockInfo.apis.byQName).filter(function (value) {
                            return value.kind === pxtc.SymbolKind.Variable &&
                                value.attributes.fixedInstance &&
                                value.retType === nsInfo_1.name;
                        })
                            .sort(function (v1, v2) { return v1.name.localeCompare(v2.name); });
                        if (instances.length) {
                            snippetPrefix = instances[0].namespace + "." + instances[0].name;
                        }
                    }
                }
            }
            var sigToken = document.createElement('span');
            if (!fn.snippetOnly) {
                sigToken.className = 'sig';
            }
            // completion is a bit busted but looks better
            sigToken.innerText = snippet
                .replace(/^[^(]*\(/, '(')
                .replace(/^\s*\{\{\}\}\n/gm, '')
                .replace(/\{\n\}/g, '{}')
                .replace(/(?:\{\{)|(?:\}\})/g, '');
            monacoBlock.title = comment;
            if (!monacoBlockDisabled) {
                monacoBlock.draggable = true;
                monacoBlock.onclick = function (ev2) {
                    pxt.tickEvent("monaco.toolbox.itemclick");
                    monacoEditor.resetFlyout(true);
                    var model = monacoEditor.editor.getModel();
                    var currPos = monacoEditor.editor.getPosition();
                    var cursor = model.getOffsetAt(currPos);
                    var insertText = snippetPrefix ? snippetPrefix + "." + snippet : snippet;
                    insertText = (currPos.column > 1) ? '\n' + insertText :
                        model.getWordUntilPosition(currPos) != undefined && model.getWordUntilPosition(currPos).word != '' ?
                            insertText + '\n' : insertText;
                    if (insertText.indexOf('{{}}') > -1) {
                        cursor += (insertText.indexOf('{{}}'));
                        insertText = insertText.replace('{{}}', '');
                    }
                    else
                        cursor += (insertText.length);
                    insertText = insertText.replace(/(?:\{\{)|(?:\}\})/g, '');
                    monacoEditor.editor.pushUndoStop();
                    monacoEditor.editor.executeEdits("", [
                        {
                            identifier: { major: 0, minor: 0 },
                            range: new monaco.Range(currPos.lineNumber, currPos.column, currPos.lineNumber, currPos.column),
                            text: insertText,
                            forceMoveMarkers: false
                        }
                    ]);
                    monacoEditor.beforeCompile();
                    monacoEditor.editor.pushUndoStop();
                    var endPos = model.getPositionAt(cursor);
                    monacoEditor.editor.setPosition(endPos);
                    monacoEditor.editor.focus();
                    //monacoEditor.editor.setSelection(new monaco.Range(currPos.lineNumber, currPos.column, endPos.lineNumber, endPos.column));
                };
                monacoBlock.ondragstart = function (ev2) {
                    pxt.tickEvent("monaco.toolbox.itemdrag");
                    var clone = monacoBlock.cloneNode(true);
                    setTimeout(function () {
                        monacoFlyout.style.transform = "translateX(-9999px)";
                    });
                    var insertText = snippetPrefix ? snippetPrefix + "." + snippet : snippet;
                    ev2.dataTransfer.setData('text', insertText); // IE11 only supports text
                };
                monacoBlock.ondragend = function (ev2) {
                    monacoFlyout.style.transform = "none";
                    monacoEditor.resetFlyout(true);
                };
            }
            if (!fn.snippetOnly) {
                var methodToken = document.createElement('span');
                methodToken.innerText = fn.name;
                monacoBlock.appendChild(methodToken);
            }
            monacoBlock.appendChild(sigToken);
            monacoBlockArea.appendChild(monacoBlock);
            monacoFlyout.appendChild(monacoBlockArea);
        });
    };
    Editor.prototype.getId = function () {
        return "monacoEditor";
    };
    Editor.prototype.getViewState = function () {
        return this.editor ? this.editor.getPosition() : {};
    };
    Editor.prototype.getCurrentSource = function () {
        return this.editor ? this.editor.getValue() : this.currSource;
    };
    Editor.prototype.acceptsFile = function (file) {
        return true;
    };
    Editor.prototype.setValue = function (v) {
        this.editor.setValue(v);
    };
    Editor.prototype.overrideFile = function (content) {
        Util.assert(this.editor != undefined); // Guarded
        this.editor.setValue(content);
    };
    Editor.prototype.loadFileAsync = function (file, hc) {
        var _this = this;
        var mode = "text";
        this.currSource = file.content;
        var loading = document.createElement("div");
        loading.className = "ui inverted loading dimmer active";
        var editorArea = document.getElementById("monacoEditorArea");
        var editorDiv = document.getElementById("monacoEditorInner");
        editorArea.insertBefore(loading, editorDiv);
        return this.loadMonacoAsync()
            .then(function () {
            if (!_this.editor)
                return;
            var toolbox = document.getElementById('monacoEditorToolbox');
            var ext = file.getExtension();
            var modeMap = {
                "cpp": "cpp",
                "h": "cpp",
                "json": "json",
                "md": "text",
                "ts": "typescript",
                "js": "javascript",
                "svg": "xml",
                "blocks": "xml",
                "asm": "asm"
            };
            if (modeMap.hasOwnProperty(ext))
                mode = modeMap[ext];
            var readOnly = file.isReadonly() || pxt.shell.isReadOnly();
            _this.editor.updateOptions({ readOnly: readOnly });
            var proto = "pkg:" + file.getName();
            var model = monaco.editor.getModels().filter(function (model) { return model.uri.toString() == proto; })[0];
            if (!model)
                model = monaco.editor.createModel(pkg.mainPkg.readFile(file.getName()), mode, monaco.Uri.parse(proto));
            if (model)
                _this.editor.setModel(model);
            if (mode == "typescript") {
                toolbox.innerHTML = '';
                _this.beginLoadToolbox(file, hc);
            }
            // Set the current file
            _this.currFile = file;
            _this.setValue(file.content);
            _this.setDiagnostics(file, _this.snapshotState());
            _this.fileType = mode == "typescript" ? FileType.TypeScript : ext == "md" ? FileType.Markdown : FileType.Unknown;
            if (_this.fileType == FileType.Markdown)
                _this.parent.setSideMarkdown(file.content);
            _this.currFile.setForceChangeCallback(function (from, to) {
                if (from != to) {
                    pxt.debug("File changed (from " + from + ", to " + to + "). Reloading editor");
                    _this.loadFileAsync(_this.currFile);
                }
            });
            if (!file.isReadonly()) {
                model.onDidChangeContent(function (e) {
                    // Remove any Highlighted lines
                    _this.clearHighlightedStatements();
                    // Remove any current error shown, as a change has been made.
                    var viewZones = _this.editorViewZones || [];
                    _this.editor.changeViewZones(function (changeAccessor) {
                        viewZones.forEach(function (id) {
                            changeAccessor.removeZone(id);
                        });
                    });
                    _this.editorViewZones = [];
                    if (!e.isRedoing && !e.isUndoing && !_this.editor.getValue()) {
                        _this.editor.setValue(" ");
                    }
                    _this.updateDiagnostics();
                    _this.changeCallback();
                });
            }
            if (mode == "typescript" && !file.isReadonly()) {
                toolbox.className = 'monacoToolboxDiv';
            }
            else {
                toolbox.className = 'monacoToolboxDiv hide';
            }
            _this.resize();
            _this.resetFlyout(true);
        }).finally(function () {
            editorArea.removeChild(loading);
        });
    };
    Editor.prototype.beginLoadToolbox = function (file, hc) {
        var _this = this;
        compiler.getBlocksAsync().then(function (bi) {
            _this.blockInfo = bi;
            _this.nsMap = _this.partitionBlocks();
            pxt.vs.syncModels(pkg.mainPkg, _this.extraLibs, file.getName(), file.isReadonly());
            _this.defineEditorTheme(hc);
            _this.updateToolbox();
            _this.resize();
        });
    };
    Editor.prototype.unloadFileAsync = function () {
        if (this.currFile && this.currFile.getName() == "this/" + pxt.CONFIG_NAME) {
            // Reload the header if a change was made to the config file: pxt.json
            return this.parent.reloadHeaderAsync();
        }
        return Promise.resolve();
    };
    Editor.prototype.snapshotState = function () {
        return this.editor && this.editor.getModel() ? this.editor.getModel().getLinesContent() : null;
    };
    Editor.prototype.setViewState = function (pos) {
        if (!this.editor)
            return;
        if (!pos || Object.keys(pos).length === 0)
            return;
        this.editor.setPosition(pos);
        this.editor.setScrollPosition(pos);
    };
    Editor.prototype.setDiagnostics = function (file, snapshot) {
        Util.assert(this.editor != undefined); // Guarded
        Util.assert(this.currFile == file);
        this.diagSnapshot = snapshot;
        this.forceDiagnosticsUpdate();
    };
    Editor.prototype.updateDiagnostics = function () {
        if (this.needsDiagUpdate())
            this.forceDiagnosticsUpdate();
    };
    Editor.prototype.needsDiagUpdate = function () {
        if (!this.annotationLines)
            return false;
        var lines = this.editor.getModel().getLinesContent();
        for (var _i = 0, _a = this.annotationLines; _i < _a.length; _i++) {
            var line = _a[_i];
            if (this.diagSnapshot[line] !== lines[line])
                return true;
        }
        return false;
    };
    Editor.prototype.forceDiagnosticsUpdate = function () {
        if (this.fileType != FileType.TypeScript)
            return;
        var file = this.currFile;
        var monacoErrors = [];
        if (file && file.diagnostics) {
            var model = monaco.editor.getModel(monaco.Uri.parse("pkg:" + file.getName()));
            var _loop_1 = function(d) {
                var endPos = model.getPositionAt(d.start + d.length);
                if (typeof d.messageText === 'string') {
                    addErrorMessage(d.messageText);
                }
                else {
                    var curr = d.messageText;
                    while (curr.next != undefined) {
                        addErrorMessage(curr.messageText);
                        curr = curr.next;
                    }
                }
                function addErrorMessage(message) {
                    monacoErrors.push({
                        severity: monaco.Severity.Error,
                        message: message,
                        startLineNumber: d.line + 1,
                        startColumn: d.column,
                        endLineNumber: (d.endLine || endPos.lineNumber) + 1,
                        endColumn: d.endColumn || endPos.column
                    });
                }
            };
            for (var _i = 0, _a = file.diagnostics; _i < _a.length; _i++) {
                var d = _a[_i];
                _loop_1(d);
            }
            monaco.editor.setModelMarkers(model, 'typescript', monacoErrors);
        }
    };
    Editor.prototype.highlightStatement = function (brk) {
        if (!brk || !this.currFile || this.currFile.name != brk.fileName || !this.editor)
            return;
        var position = this.editor.getModel().getPositionAt(brk.start);
        var end = this.editor.getModel().getPositionAt(brk.start + brk.length);
        if (!position || !end)
            return;
        this.highlightDecorations = this.editor.deltaDecorations(this.highlightDecorations, [
            {
                range: new monaco.Range(position.lineNumber, position.column, end.lineNumber, end.column),
                options: { inlineClassName: 'highlight-statement' }
            },
        ]);
    };
    Editor.prototype.clearHighlightedStatements = function () {
        if (this.highlightDecorations)
            this.editor.deltaDecorations(this.highlightDecorations, []);
    };
    Editor.prototype.partitionBlocks = function () {
        var res = {};
        this.blockInfo.blocks.forEach(function (fn) {
            var ns = (fn.attributes.blockNamespace || fn.namespace).split('.')[0];
            if (!res[ns]) {
                res[ns] = [];
            }
            res[ns].push(fn);
        });
        return res;
    };
    return Editor;
}(srceditor.Editor));
exports.Editor = Editor;

},{"./compiler":9,"./core":11,"./monacoSnippets":27,"./package":28,"./srceditor":36,"react":267}],27:[function(require,module,exports){
"use strict";
exports.loops = {
    name: lf("{id:category}Loops"),
    nameid: 'loops',
    blocks: [
        {
            name: "while",
            snippet: "while(true) {\n\n}",
            attributes: {
                jsDoc: lf("Repeat code while condition is true")
            }
        },
        {
            name: "for",
            snippet: "for(let i = 0; i < 5; i++) {\n\n}",
            attributes: {
                jsDoc: lf("Repeat code a number of times in a loop")
            }
        },
    ],
    attributes: {
        callingConvention: ts.pxtc.ir.CallingConvention.Plain,
        icon: "loops",
        weight: 50.09,
        paramDefl: {}
    }
};
exports.logic = {
    name: lf("{id:category}Logic"),
    nameid: 'logic',
    blocks: [
        {
            name: "if",
            snippet: "if (true) {\n\n}",
            attributes: {
                jsDoc: lf("Runs code if the condition is true")
            }
        },
        {
            name: "if",
            snippet: "if (true) {\n\n} else {\n\n}",
            attributes: {
                jsDoc: lf("Runs code if the condition is true; else run other code")
            }
        },
        {
            name: "switch",
            snippet: "switch(item) {\n    case 0:\n        break;\n    case 1:\n        break;\n}",
            attributes: {
                jsDoc: lf("Runs different code based on a value")
            }
        },
    ],
    attributes: {
        callingConvention: ts.pxtc.ir.CallingConvention.Plain,
        weight: 50.08,
        icon: "logic",
        paramDefl: {}
    }
};
exports.variables = {
    name: lf("{id:category}Variables"),
    nameid: 'variables',
    blocks: [
        {
            name: "let",
            snippet: "let item: number",
            snippetOnly: true,
            attributes: {
                jsDoc: lf("Declares a variable named 'item'")
            }
        },
        {
            name: "equals",
            snippet: "item = 0",
            snippetOnly: true,
            attributes: {
                jsDoc: lf("Assigns a value to a variable")
            }
        },
        {
            name: "change",
            snippet: "item += 1",
            snippetOnly: true,
            attributes: {
                jsDoc: lf("Changes the value of item by 1")
            }
        },
    ],
    attributes: {
        callingConvention: ts.pxtc.ir.CallingConvention.Plain,
        weight: 50.07,
        icon: "variables",
        paramDefl: {}
    }
};
exports.maths = {
    name: lf("{id:category}Math"),
    nameid: 'math',
    blocks: [
        {
            name: "plus",
            snippet: "1 + 1",
            snippetOnly: true,
            attributes: {
                jsDoc: lf("Adds two numbers together")
            }
        },
        {
            name: "minus",
            snippet: "1 - 1",
            snippetOnly: true,
            attributes: {
                jsDoc: lf("Subtracts the value of one number from another")
            }
        },
        {
            name: "multiply",
            snippet: "1 * 1",
            snippetOnly: true,
            attributes: {
                jsDoc: lf("Multiplies two numbers together")
            }
        },
        {
            name: "divide",
            snippet: "1 / 1",
            snippetOnly: true,
            attributes: {
                jsDoc: lf("Returns the quotient of one number divided by another")
            }
        },
        {
            name: "remainder",
            snippet: "1 % 2",
            snippetOnly: true,
            attributes: {
                jsDoc: lf("Returns the remainder of one number divided by another")
            }
        },
        {
            name: "max",
            snippet: "Math.max(1, 2)",
            attributes: {
                jsDoc: lf("Returns the largest of two numbers")
            }
        },
        {
            name: "min",
            snippet: "Math.min(1, 2)",
            attributes: {
                jsDoc: lf("Returns the smallest of two numbers")
            }
        },
        {
            name: "abs",
            snippet: "Math.abs(-1)",
            attributes: {
                jsDoc: lf("Returns the absolute value of a number")
            }
        },
        {
            name: "random",
            snippet: "Math.random(4)",
            attributes: {
                jsDoc: lf("Returns a random number between 0 and an upper bound")
            }
        },
        {
            name: "randomBoolean",
            snippet: "Math.randomBoolean()",
            attributes: {
                jsDoc: lf("Randomly returns either true or false")
            }
        },
    ],
    attributes: {
        callingConvention: ts.pxtc.ir.CallingConvention.Plain,
        weight: 50.06,
        icon: "math",
        paramDefl: {}
    }
};
exports.text = {
    name: lf("{id:category}Text"),
    nameid: 'text',
    blocks: [
        {
            name: "length",
            snippet: "\"\".length",
            snippetOnly: true,
            attributes: {
                jsDoc: lf("Returns the number of characters in a string")
            }
        },
        {
            name: "concat",
            snippet: "\"\" + 5",
            snippetOnly: true,
            attributes: {
                jsDoc: lf("Combines a string with a number, boolean, string, or other object into one string")
            }
        },
        {
            name: "compare",
            snippet: "\"\".compare(\"\")",
            attributes: {
                jsDoc: lf("Compares one string against another alphabetically and returns a number")
            }
        },
        {
            name: "parseInt",
            snippet: "parseInt(\"5\")",
            attributes: {
                jsDoc: lf("Converts a number written as text into a number")
            }
        },
        {
            name: "substr",
            snippet: "\"\".substr(0, 0)",
            attributes: {
                jsDoc: lf("Returns the part of a string starting at a given index with the given length")
            }
        },
        {
            name: "charAt",
            snippet: "\"\".charAt(0)",
            attributes: {
                jsDoc: lf("Returns the character at the given index")
            }
        },
    ],
    attributes: {
        advanced: true,
        icon: "text",
        callingConvention: ts.pxtc.ir.CallingConvention.Plain,
        paramDefl: {}
    }
};
exports.arrays = {
    name: lf("{id:category}Arrays"),
    nameid: "arrays",
    blocks: [
        {
            name: "create",
            snippet: "let " + lf("{id:snippets}list") + " = [1, 2, 3];",
            snippetOnly: true,
            attributes: {
                weight: 100,
                jsDoc: lf("Creates a new Array")
            }
        },
        {
            name: "length",
            snippet: lf("{id:snippets}list") + ".length",
            snippetOnly: true,
            attributes: {
                weight: 99,
                jsDoc: lf("Returns the number of values in an Array")
            }
        },
        {
            name: "get",
            snippet: lf("{id:snippets}list") + "[0]",
            snippetOnly: true,
            attributes: {
                weight: 98,
                jsDoc: lf("Returns the value in the Array at the given index")
            }
        },
        {
            name: "set",
            snippet: lf("{id:snippets}list") + "[0] = 1",
            snippetOnly: true,
            attributes: {
                weight: 97,
                jsDoc: lf("Overwrites the value in an Array at the given index")
            }
        },
        {
            name: "push",
            snippet: lf("{id:snippets}list") + ".push(1)",
            attributes: {
                weight: 96,
                jsDoc: lf("Adds a value to the end of an Array")
            }
        },
        {
            name: "pop",
            snippet: lf("{id:snippets}list") + ".pop()",
            attributes: {
                weight: 95,
                jsDoc: lf("Removes and returns the value at the end of an Array")
            }
        },
        {
            name: "insertAt",
            snippet: lf("{id:snippets}list") + ".insertAt(0, 0)",
            attributes: {
                weight: 50,
                jsDoc: lf("Inserts a value into the Array at the given index"),
                advanced: true
            }
        },
        {
            name: "removeAt",
            snippet: lf("{id:snippets}list") + ".removeAt(0)",
            attributes: {
                weight: 49,
                jsDoc: lf("Removes a value from the Array at the given index and returns it"),
                advanced: true
            }
        },
        {
            name: "shift",
            snippet: lf("{id:snippets}list") + ".shift()",
            attributes: {
                weight: 48,
                jsDoc: lf("Removes and returns the value at the front of an Array"),
                advanced: true
            }
        },
        {
            name: "unshift",
            snippet: lf("{id:snippets}list") + ".unshift(0)",
            attributes: {
                weight: 47,
                jsDoc: lf("Inserts a value at the beginning of an Array"),
                advanced: true
            }
        },
        {
            name: "indexOf",
            snippet: "[\"A\", \"B\", \"C\"].indexOf(\"B\")",
            attributes: {
                weight: 46,
                jsDoc: lf("Returns the first index in the Array that contains the given value or -1 if it does not exist in the Array"),
                advanced: true
            }
        },
        {
            name: "reverse",
            snippet: lf("{id:snippets}list") + ".reverse()",
            attributes: {
                weight: 45,
                jsDoc: lf("Reverses the contents of an Array"),
                advanced: true
            }
        },
    ],
    attributes: {
        advanced: true,
        color: pxt.blocks.blockColors["arrays"].toString(),
        icon: "arrays",
        callingConvention: ts.pxtc.ir.CallingConvention.Plain,
        paramDefl: {}
    }
};
exports.functions = {
    name: lf("{id:category}Functions"),
    nameid: 'functions',
    blocks: [
        {
            name: "function doSomething",
            snippet: "function doSomething() {\n\n}",
            attributes: {
                jsDoc: lf("Define a function")
            }
        },
        {
            name: "doSomething",
            snippet: "doSomething()",
            attributes: {
                jsDoc: lf("Call a function")
            }
        },
    ],
    attributes: {
        advanced: true,
        callingConvention: ts.pxtc.ir.CallingConvention.Plain,
        color: pxt.blocks.blockColors["functions"].toString(),
        icon: "functions",
        paramDefl: {}
    }
};
function getBuiltinCategory(ns) {
    switch (ns) {
        case exports.loops.nameid: return exports.loops;
        case exports.logic.nameid: return exports.logic;
        case exports.variables.nameid: return exports.variables;
        case exports.maths.nameid: return exports.maths;
        case exports.text.nameid: return exports.text;
        case exports.arrays.nameid: return exports.arrays;
        case exports.functions.nameid: return exports.functions;
    }
    return undefined;
}
exports.getBuiltinCategory = getBuiltinCategory;
function isBuiltin(ns) {
    switch (ns) {
        case exports.loops.nameid:
        case exports.logic.nameid:
        case exports.variables.nameid:
        case exports.maths.nameid:
        case exports.text.nameid:
        case exports.arrays.nameid:
        case exports.functions.nameid:
            return true;
    }
    return false;
}
exports.isBuiltin = isBuiltin;
function overrideCategory(ns, def) {
    var cat = getBuiltinCategory(ns);
    if (def && cat) {
        if (def.name) {
            cat.name = def.name;
        }
        if (def.weight !== undefined) {
            cat.attributes.weight = def.weight;
        }
        if (def.advanced !== undefined) {
            cat.attributes.advanced = def.advanced;
        }
        if (def.removed !== undefined) {
            cat.removed = def.removed;
        }
        if (def.blocks) {
            var currentWeight_1 = 100;
            if (def.appendBlocks) {
                currentWeight_1 = 50;
                def.blocks.forEach(function (b, i) {
                    if (b.weight) {
                        currentWeight_1 = b.weight;
                    }
                    else {
                        currentWeight_1--;
                    }
                    var blk = {
                        name: b.name,
                        snippet: b.snippet,
                        snippetOnly: b.snippetOnly,
                        attributes: {
                            weight: currentWeight_1,
                            advanced: b.advanced,
                            jsDoc: b.jsDoc,
                            group: b.group,
                        },
                        noNamespace: true
                    };
                    cat.blocks.push(blk);
                });
            }
            else {
                cat.blocks = def.blocks.map(function (b, i) {
                    if (b.weight) {
                        currentWeight_1 = b.weight;
                    }
                    else {
                        currentWeight_1--;
                    }
                    return {
                        name: b.name,
                        snippet: b.snippet,
                        snippetOnly: b.snippetOnly,
                        attributes: {
                            weight: currentWeight_1,
                            advanced: b.advanced,
                            jsDoc: b.jsDoc,
                            group: b.group,
                        },
                        noNamespace: true
                    };
                });
            }
        }
    }
}
exports.overrideCategory = overrideCategory;
function overrideToolbox(def) {
    overrideCategory(exports.loops.nameid, def.loops);
    overrideCategory(exports.logic.nameid, def.logic);
    overrideCategory(exports.variables.nameid, def.variables);
    overrideCategory(exports.maths.nameid, def.maths);
    overrideCategory(exports.text.nameid, def.text);
    overrideCategory(exports.arrays.nameid, def.arrays);
    overrideCategory(exports.functions.nameid, def.functions);
}
exports.overrideToolbox = overrideToolbox;

},{}],28:[function(require,module,exports){
"use strict";
var workspace = require("./workspace");
var data = require("./data");
var core = require("./core");
var db = require("./db");
var Util = pxt.Util;
var lf = Util.lf;
var hostCache = new db.Table("hostcache");
var extWeight = {
    "ts": 10,
    "blocks": 20,
    "json": 30,
    "md": 40,
};
function setupAppTarget(trgbundle) {
    //if (!trgbundle.appTheme) trgbundle.appTheme = {};
    pxt.setAppTarget(trgbundle);
}
exports.setupAppTarget = setupAppTarget;
var File = (function () {
    function File(epkg, name, content) {
        this.epkg = epkg;
        this.name = name;
        this.content = content;
        this.inSyncWithEditor = true;
        this.inSyncWithDisk = true;
    }
    File.prototype.isReadonly = function () {
        return !this.epkg.header;
    };
    File.prototype.getName = function () {
        return this.epkg.getPkgId() + "/" + this.name;
    };
    File.prototype.getTypeScriptName = function () {
        if (this.epkg.isTopLevel())
            return this.name;
        else
            return "pxt_modules/" + this.epkg.getPkgId() + "/" + this.name;
    };
    File.prototype.getExtension = function () {
        var m = /\.([^\.]+)$/.exec(this.name);
        if (m)
            return m[1];
        return "";
    };
    File.prototype.getVirtualFileName = function () {
        if (File.blocksFileNameRx.test(this.name))
            return this.name.replace(File.blocksFileNameRx, '.ts');
        if (File.tsFileNameRx.test(this.name))
            return this.name.replace(File.tsFileNameRx, '.blocks');
        return undefined;
    };
    File.prototype.weight = function () {
        if (/^main\./.test(this.name))
            return 5;
        if (extWeight.hasOwnProperty(this.getExtension()))
            return extWeight[this.getExtension()];
        return 60;
    };
    File.prototype.markDirty = function () {
        this.inSyncWithEditor = false;
        this.updateStatus();
    };
    File.prototype.updateStatus = function () {
        data.invalidate("open-meta:" + this.getName());
    };
    File.prototype.setContentAsync = function (newContent, force) {
        var _this = this;
        Util.assert(newContent !== undefined);
        this.inSyncWithEditor = true;
        if (newContent != this.content) {
            var prevContent_1 = this.content;
            this.inSyncWithDisk = false;
            this.content = newContent;
            this.updateStatus();
            return this.epkg.saveFilesAsync()
                .then(function () {
                if (_this.content == newContent) {
                    _this.inSyncWithDisk = true;
                    _this.updateStatus();
                }
                if (force && _this.forceChangeCallback)
                    _this.forceChangeCallback(prevContent_1, newContent);
            });
        }
        else {
            this.updateStatus();
            return Promise.resolve();
        }
    };
    File.prototype.setForceChangeCallback = function (callback) {
        this.forceChangeCallback = callback;
    };
    File.tsFileNameRx = /\.ts$/;
    File.blocksFileNameRx = /\.blocks$/;
    return File;
}());
exports.File = File;
var EditorPackage = (function () {
    function EditorPackage(ksPkg, topPkg) {
        this.ksPkg = ksPkg;
        this.topPkg = topPkg;
        this.files = {};
        this.onupdate = function () { };
        this.saveScheduled = false;
        this.savingNow = 0;
        if (ksPkg && ksPkg.verProtocol() == "workspace")
            this.header = workspace.getHeader(ksPkg.verArgument());
    }
    EditorPackage.prototype.getTopHeader = function () {
        return this.topPkg.header;
    };
    EditorPackage.prototype.makeTopLevel = function () {
        this.topPkg = this;
        this.outputPkg = new EditorPackage(null, this);
        this.outputPkg.id = "built";
    };
    EditorPackage.prototype.updateConfigAsync = function (update) {
        var cfgFile = this.files[pxt.CONFIG_NAME];
        if (cfgFile) {
            try {
                var cfg = JSON.parse(cfgFile.content);
                update(cfg);
                return cfgFile.setContentAsync(JSON.stringify(cfg, null, 4) + "\n");
            }
            catch (e) { }
        }
        return null;
    };
    EditorPackage.prototype.updateDepAsync = function (pkgid) {
        var _this = this;
        var p = this.ksPkg.resolveDep(pkgid);
        if (!p || p.verProtocol() != "github")
            return Promise.resolve();
        var parsed = pxt.github.parseRepoId(p.verArgument());
        return pxt.packagesConfigAsync()
            .then(function (config) { return pxt.github.latestVersionAsync(parsed.fullName, config); })
            .then(function (tag) { parsed.tag = tag; })
            .then(function () { return pxt.github.pkgConfigAsync(parsed.fullName, parsed.tag); })
            .catch(core.handleNetworkError)
            .then(function (cfg) { return _this.addDepAsync(cfg.name, pxt.github.stringifyRepo(parsed)); });
    };
    EditorPackage.prototype.removeDepAsync = function (pkgid) {
        var _this = this;
        return this.updateConfigAsync(function (cfg) { return delete cfg.dependencies[pkgid]; })
            .then(function () { return _this.saveFilesAsync(true); });
    };
    EditorPackage.prototype.addDepAsync = function (pkgid, pkgversion) {
        var _this = this;
        return this.updateConfigAsync(function (cfg) { return cfg.dependencies[pkgid] = pkgversion; })
            .then(function () { return _this.saveFilesAsync(true); });
    };
    EditorPackage.prototype.getKsPkg = function () {
        return this.ksPkg;
    };
    EditorPackage.prototype.getPkgId = function () {
        return this.ksPkg ? this.ksPkg.id : this.id;
    };
    EditorPackage.prototype.isTopLevel = function () {
        return this.ksPkg && this.ksPkg.level == 0;
    };
    EditorPackage.prototype.setFile = function (n, v) {
        var f = new File(this, n, v);
        this.files[n] = f;
        data.invalidate("open-meta:");
        return f;
    };
    EditorPackage.prototype.removeFileAsync = function (n) {
        delete this.files[n];
        data.invalidate("open-meta:");
        return this.updateConfigAsync(function (cfg) { return cfg.files = cfg.files.filter(function (f) { return f != n; }); });
    };
    EditorPackage.prototype.setContentAsync = function (n, v) {
        var f = this.files[n];
        if (!f)
            f = this.setFile(n, v);
        return f.setContentAsync(v);
    };
    EditorPackage.prototype.setFiles = function (files) {
        var _this = this;
        this.files = Util.mapMap(files, function (k, v) { return new File(_this, k, v); });
        data.invalidate("open-meta:");
    };
    EditorPackage.prototype.updateStatus = function () {
        data.invalidate("pkg-status:" + this.header.id);
    };
    EditorPackage.prototype.savePkgAsync = function () {
        var _this = this;
        if (this.header.blobCurrent)
            return Promise.resolve();
        this.savingNow++;
        this.updateStatus();
        return workspace.saveToCloudAsync(this.header)
            .then(function () {
            _this.savingNow--;
            _this.updateStatus();
            if (!_this.header.blobCurrent)
                _this.scheduleSave();
        });
    };
    EditorPackage.prototype.scheduleSave = function () {
        var _this = this;
        if (this.saveScheduled)
            return;
        this.saveScheduled = true;
        setTimeout(function () {
            _this.saveScheduled = false;
            _this.savePkgAsync().done();
        }, 5000);
    };
    EditorPackage.prototype.getAllFiles = function () {
        return Util.mapMap(this.files, function (k, f) { return f.content; });
    };
    EditorPackage.prototype.saveFilesAsync = function (immediate) {
        var _this = this;
        if (!this.header)
            return Promise.resolve();
        var cfgFile = this.files[pxt.CONFIG_NAME];
        if (cfgFile) {
            try {
                var cfg = JSON.parse(cfgFile.content);
                this.header.name = cfg.name;
            }
            catch (e) {
            }
        }
        return workspace.saveAsync(this.header, this.getAllFiles())
            .then(function () { return immediate ? _this.savePkgAsync() : _this.scheduleSave(); });
    };
    EditorPackage.prototype.sortedFiles = function () {
        var lst = Util.values(this.files);
        lst.sort(function (a, b) { return a.weight() - b.weight() || Util.strcmp(a.name, b.name); });
        return lst;
    };
    EditorPackage.prototype.forEachFile = function (cb) {
        this.pkgAndDeps().forEach(function (p) {
            Util.values(p.files).forEach(cb);
        });
    };
    EditorPackage.prototype.getMainFile = function () {
        return this.sortedFiles()[0];
    };
    EditorPackage.prototype.pkgAndDeps = function () {
        if (this.topPkg != this)
            return this.topPkg.pkgAndDeps();
        return Util.values(this.ksPkg.deps).map(getEditorPkg).concat([this.outputPkg]);
    };
    EditorPackage.prototype.filterFiles = function (cond) {
        return Util.concat(this.pkgAndDeps().map(function (e) { return Util.values(e.files).filter(cond); }));
    };
    EditorPackage.prototype.lookupFile = function (name) {
        return this.filterFiles(function (f) { return f.getName() == name; })[0];
    };
    return EditorPackage;
}());
exports.EditorPackage = EditorPackage;
var Host = (function () {
    function Host() {
    }
    Host.prototype.readFile = function (module, filename) {
        var epkg = getEditorPkg(module);
        var file = epkg.files[filename];
        return file ? file.content : null;
    };
    Host.prototype.writeFile = function (module, filename, contents, force) {
        if (filename == pxt.CONFIG_NAME || force) {
            // only write config writes
            var epkg = getEditorPkg(module);
            var file = epkg.files[filename];
            file.setContentAsync(contents, force).done();
            return;
        }
        throw Util.oops("trying to write " + module + " / " + filename);
    };
    Host.prototype.getHexInfoAsync = function (extInfo) {
        return pxt.hex.getHexInfoAsync(this, extInfo).catch(core.handleNetworkError);
    };
    Host.prototype.cacheStoreAsync = function (id, val) {
        return hostCache.forceSetAsync({
            id: id,
            val: val
        }).then(function () { }, function (e) {
            pxt.tickEvent('cache.store.failed', { error: e.name });
            pxt.log("cache store failed for " + id + ": " + e.name);
        });
    };
    Host.prototype.cacheGetAsync = function (id) {
        return hostCache.getAsync(id)
            .then(function (v) { return v.val; }, function (e) { return null; });
    };
    Host.prototype.downloadPackageAsync = function (pkg) {
        var proto = pkg.verProtocol();
        var epkg = getEditorPkg(pkg);
        if (proto == "pub") {
            // make sure it sits in cache
            return workspace.getPublishedScriptAsync(pkg.verArgument())
                .then(function (files) { return epkg.setFiles(files); });
        }
        else if (proto == "github") {
            return workspace.getPublishedScriptAsync(pkg.version())
                .then(function (files) { return epkg.setFiles(files); });
        }
        else if (proto == "workspace") {
            return workspace.getTextAsync(pkg.verArgument())
                .then(function (scr) { return epkg.setFiles(scr); });
        }
        else if (proto == "file") {
            var arg = pkg.verArgument();
            if (arg[0] == ".")
                arg = resolvePath(pkg.parent.verArgument() + "/" + arg);
            return workspace.getTextAsync(arg)
                .then(function (scr) { return epkg.setFiles(scr); });
        }
        else if (proto == "embed") {
            epkg.setFiles(pxt.getEmbeddedScript(pkg.verArgument()));
            return Promise.resolve();
        }
        else {
            return Promise.reject("Cannot download " + pkg.version() + "; unknown protocol");
        }
    };
    return Host;
}());
function resolvePath(p) {
    return p.replace(/\/+/g, "/").replace(/[^\/]+\/\.\.\//g, "").replace(/\/\.\//g, "/");
}
var theHost = new Host();
exports.mainPkg = new pxt.MainPackage(theHost);
function getEditorPkg(p) {
    var r = p._editorPkg;
    if (r)
        return r;
    var top = null;
    if (p != exports.mainPkg)
        top = getEditorPkg(exports.mainPkg);
    var newOne = new EditorPackage(p, top);
    if (p == exports.mainPkg)
        newOne.makeTopLevel();
    p._editorPkg = newOne;
    return newOne;
}
exports.getEditorPkg = getEditorPkg;
function mainEditorPkg() {
    return getEditorPkg(exports.mainPkg);
}
exports.mainEditorPkg = mainEditorPkg;
function genFileName(extension) {
    var sanitizedName = mainEditorPkg().header.name.replace(/[\\\/.?*^:<>|"\x00-\x1F ]/g, "-");
    var fn = (pxt.appTarget.nickname || pxt.appTarget.id) + "-" + sanitizedName + extension;
    return fn;
}
exports.genFileName = genFileName;
function allEditorPkgs() {
    return getEditorPkg(exports.mainPkg).pkgAndDeps();
}
exports.allEditorPkgs = allEditorPkgs;
function notifySyncDone(updated) {
    var newOnes = Util.values(exports.mainPkg.deps).filter(function (d) { return d.verProtocol() == "workspace" && updated.hasOwnProperty(d.verArgument()); });
    if (newOnes.length > 0) {
        getEditorPkg(exports.mainPkg).onupdate();
    }
}
exports.notifySyncDone = notifySyncDone;
function loadPkgAsync(id) {
    exports.mainPkg = new pxt.MainPackage(theHost);
    exports.mainPkg._verspec = "workspace:" + id;
    return theHost.downloadPackageAsync(exports.mainPkg)
        .catch(core.handleNetworkError)
        .then(function () { return theHost.readFile(exports.mainPkg, pxt.CONFIG_NAME); })
        .then(function (str) {
        if (!str)
            return Promise.resolve();
        return exports.mainPkg.installAllAsync()
            .catch(function (e) {
            core.errorNotification(lf("Cannot load package: {0}", e.message));
        });
    });
}
exports.loadPkgAsync = loadPkgAsync;
/*
    open-meta:<pkgName>/<filename> - readonly/saved/unsaved + number of errors
*/
data.mountVirtualApi("open-meta", {
    getSync: function (p) {
        p = data.stripProtocol(p);
        var f = getEditorPkg(exports.mainPkg).lookupFile(p);
        if (!f)
            return {};
        var fs = {
            isReadonly: f.isReadonly(),
            isSaved: f.inSyncWithEditor && f.inSyncWithDisk,
            numErrors: f.numDiagnosticsOverride
        };
        if (fs.numErrors == null)
            fs.numErrors = f.diagnostics ? f.diagnostics.length : 0;
        return fs;
    },
});
// pkg-status:<guid>
data.mountVirtualApi("pkg-status", {
    getSync: function (p) {
        p = data.stripProtocol(p);
        var ep = allEditorPkgs().filter(function (pkg) { return pkg.header && pkg.header.id == p; })[0];
        if (ep)
            return ep.savingNow ? "saving" : "";
        return "";
    },
});

},{"./core":11,"./data":12,"./db":13,"./workspace":41}],29:[function(require,module,exports){
/// <reference path="../../typings/globals/react/index.d.ts" />
/// <reference path="../../typings/globals/react-dom/index.d.ts" />
/// <reference path="../../built/pxtlib.d.ts" />
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var React = require("react");
var ReactDOM = require("react-dom");
var workspace = require("./workspace");
var data = require("./data");
var sui = require("./sui");
var pkg = require("./package");
var core = require("./core");
var compiler = require("./compiler");
var codecard = require("./codecard");
var gallery = require("./gallery");
var WELCOME = "__welcome";
var MYSTUFF = "__mystuff";
var Projects = (function (_super) {
    __extends(Projects, _super);
    function Projects(props) {
        _super.call(this, props);
        this.prevGhData = [];
        this.prevUrlData = [];
        this.prevGalleries = {};
        this.galleryFetchErrors = {};
        this.state = {
            visible: false,
            tab: MYSTUFF
        };
    }
    Projects.prototype.hide = function (closeOnly) {
        if (closeOnly === void 0) { closeOnly = false; }
        if (this.state.isInitialStartPage && closeOnly) {
            // If this was the initial start page and the dialog was close without a selection being made, load the
            // previous project if available or create a new one
            pxt.tickEvent("projects.welcome.hide");
            if (this.state.resumeProject) {
                this.props.parent.loadHeaderAsync(this.state.resumeProject);
            }
            else {
                this.props.parent.newProject();
            }
        }
        this.setState({ visible: false, isInitialStartPage: false });
    };
    Projects.prototype.showInitialStartPage = function (resumeProject) {
        this.setState({
            visible: true,
            tab: WELCOME,
            isInitialStartPage: true,
            resumeProject: resumeProject
        });
    };
    Projects.prototype.showOpenProject = function (tab) {
        var gals = pxt.appTarget.appTheme.galleries || {};
        tab = (!tab || !gals[tab]) ? MYSTUFF : tab;
        this.setState({ visible: true, tab: tab || MYSTUFF });
    };
    Projects.prototype.showOpenTutorials = function () {
        var gals = Object.keys(pxt.appTarget.appTheme.galleries || {});
        this.setState({ visible: true, tab: gals[0] || MYSTUFF });
    };
    Projects.prototype.fetchGallery = function (tab, path) {
        if (this.state.tab != tab)
            return [];
        var res = this.getData("gallery:" + encodeURIComponent(path));
        if (res) {
            if (res instanceof Error) {
                this.galleryFetchErrors[tab] = true;
            }
            else {
                this.prevGalleries[path] = Util.concat(res.map(function (g) { return g.cards; }));
            }
        }
        return this.prevGalleries[path] || [];
    };
    Projects.prototype.fetchUrlData = function () {
        var scriptid = pxt.Cloud.parseScriptId(this.state.searchFor);
        if (scriptid) {
            var res = this.getData("cloud-search:" + scriptid);
            if (res) {
                if (res.statusCode !== 404) {
                    if (!this.prevUrlData)
                        this.prevUrlData = [res];
                    else
                        this.prevUrlData.push(res);
                }
            }
        }
        return this.prevUrlData;
    };
    Projects.prototype.fetchLocalData = function () {
        var _this = this;
        if (this.state.tab != MYSTUFF)
            return [];
        var headers = this.getData("header:*");
        if (this.state.searchFor)
            headers = headers.filter(function (hdr) { return hdr.name.toLowerCase().indexOf(_this.state.searchFor.toLowerCase()) > -1; });
        return headers;
    };
    Projects.prototype.shouldComponentUpdate = function (nextProps, nextState, nextContext) {
        return this.state.visible != nextState.visible
            || this.state.tab != nextState.tab
            || this.state.searchFor != nextState.searchFor
            || this.state.welcomeDescription != nextState.welcomeDescription;
    };
    Projects.prototype.numDaysOld = function (d1) {
        var diff = Math.abs((Date.now() / 1000) - d1);
        return Math.floor(diff / (60 * 60 * 24));
    };
    Projects.prototype.renderCore = function () {
        var _this = this;
        var _a = this.state, visible = _a.visible, tab = _a.tab;
        var theme = pxt.appTarget.appTheme;
        var galleries = theme.galleries || {};
        var galleryNames = Object.keys(galleries);
        var tabs = (pxt.appTarget.appTheme.useStartPage ? [WELCOME, MYSTUFF] : [MYSTUFF]).concat(Object.keys(galleries));
        // lf("Make")
        // lf("Code")
        // lf("Projects")
        // lf("Examples")
        // lf("Tutorials")
        var headers = this.fetchLocalData();
        var urldata = this.fetchUrlData();
        this.galleryFetchErrors = {};
        var gals = Util.mapMap(galleries, function (k) { return _this.fetchGallery(k, galleries[k]); });
        var chgHeader = function (hdr) {
            pxt.tickEvent(tab == WELCOME ? "projects.welcome.resume" : "projects.header");
            _this.hide();
            _this.props.parent.loadHeaderAsync(hdr);
        };
        var chgGallery = function (scr) {
            pxt.tickEvent("projects.gallery", { name: scr.name });
            _this.hide();
            switch (scr.cardType) {
                case "example":
                    chgCode(scr);
                    break;
                case "blocksExample":
                    chgCode(scr, true);
                    break;
                case "tutorial":
                    _this.props.parent.startTutorial(scr.url);
                    break;
                default:
                    var m = /^\/#tutorial:([a-z0A-Z0-9\-\/]+)$/.exec(scr.url);
                    if (m)
                        _this.props.parent.startTutorial(m[1]);
                    else {
                        if (scr.youTubeId && !scr.url)
                            window.open('https://youtu.be/' + scr.youTubeId, 'yt');
                        else
                            _this.props.parent.newEmptyProject(scr.name.toLowerCase(), scr.url);
                    }
            }
        };
        var chgCode = function (scr, loadBlocks) {
            core.showLoading(lf("Loading..."));
            gallery.loadExampleAsync(scr.name.toLowerCase(), scr.url)
                .done(function (opts) {
                core.hideLoading();
                if (opts) {
                    if (loadBlocks) {
                        var ts_1 = opts.filesOverride["main.ts"];
                        compiler.getBlocksAsync()
                            .then(function (blocksInfo) { return compiler.decompileSnippetAsync(ts_1, blocksInfo); })
                            .then(function (resp) {
                            opts.filesOverride["main.blocks"] = resp;
                            _this.props.parent.newProject(opts);
                        });
                    }
                    else {
                        _this.props.parent.newProject(opts);
                    }
                }
            });
        };
        var upd = function (v) {
            var str = ReactDOM.findDOMNode(_this.refs["searchInput"]).value;
            _this.setState({ searchFor: str });
        };
        var kupd = function (ev) {
            if (ev.keyCode == 13)
                upd(ev);
        };
        var installScript = function (scr) {
            _this.hide();
            core.showLoading(lf("loading project..."));
            workspace.installByIdAsync(scr.id)
                .then(function (r) { return _this.props.parent.loadHeaderAsync(r); })
                .done(function () { return core.hideLoading(); });
        };
        var importHex = function () {
            pxt.tickEvent("projects.import");
            _this.hide();
            _this.props.parent.importFileDialog();
        };
        var importUrl = function () {
            pxt.tickEvent("projects.importurl");
            _this.hide();
            _this.props.parent.importUrlDialog();
        };
        var newProject = function () {
            pxt.tickEvent(tab == WELCOME ? "projects.welcome.new" : "projects.new");
            _this.hide();
            _this.props.parent.newProject();
        };
        var renameProject = function () {
            pxt.tickEvent("projects.rename");
            _this.hide();
            _this.props.parent.setFile(pkg.mainEditorPkg().files[pxt.CONFIG_NAME]);
        };
        var resume = function () {
            if (_this.state.isInitialStartPage) {
                chgHeader(_this.state.resumeProject);
            }
            else {
                // The msot recent project is already loaded in the editor, so this is a no-op
                _this.hide();
            }
        };
        var gettingStarted = function () {
            pxt.tickEvent("projects.welcome.gettingstarted");
            _this.hide();
            _this.props.parent.gettingStarted();
        };
        var loadProject = function () {
            pxt.tickEvent("projects.welcome.loadproject");
            _this.setState({ tab: MYSTUFF });
        };
        var projectGalleries = function () {
            pxt.tickEvent("projects.welcome.galleries");
            _this.setState({ tab: galleryNames[0] });
        };
        var isEmpty = function () {
            if (_this.state.searchFor) {
                if (headers.length > 0
                    || urldata.length > 0)
                    return false;
                return true;
            }
            return false;
        };
        var targetTheme = pxt.appTarget.appTheme;
        var headersToday = headers.filter(function (h) { var days = _this.numDaysOld(h.modificationTime); return days == 0; });
        var headersYesterday = headers.filter(function (h) { var days = _this.numDaysOld(h.modificationTime); return days == 1; });
        var headersThisWeek = headers.filter(function (h) { var days = _this.numDaysOld(h.modificationTime); return days > 1 && days <= 7; });
        var headersLastWeek = headers.filter(function (h) { var days = _this.numDaysOld(h.modificationTime); return days > 7 && days <= 14; });
        var headersThisMonth = headers.filter(function (h) { var days = _this.numDaysOld(h.modificationTime); return days > 14 && days <= 30; });
        var headersOlder = headers.filter(function (h) { var days = _this.numDaysOld(h.modificationTime); return days > 30; });
        var headersGrouped = [
            { name: lf("Today"), headers: headersToday },
            { name: lf("Yesterday"), headers: headersYesterday },
            { name: lf("This Week"), headers: headersThisWeek },
            { name: lf("Last Week"), headers: headersLastWeek },
            { name: lf("This Month"), headers: headersThisMonth },
            { name: lf("Older"), headers: headersOlder },
        ];
        var hadFetchError = this.galleryFetchErrors[tab];
        var isLoading = tab != WELCOME && tab != MYSTUFF && !hadFetchError && !gals[tab].length;
        var tabClasses = sui.cx([
            isLoading ? 'loading' : '',
            'ui segment bottom attached tab active tabsegment'
        ]);
        return (React.createElement(sui.Modal, {open: visible, className: "projectsdialog", size: "fullscreen", closeIcon: false, onClose: function () { return _this.hide(/* closeOnly */ true); }, dimmer: true, closeOnDimmerClick: true}, React.createElement(sui.Segment, {inverted: targetTheme.invertedMenu, attached: "top"}, React.createElement(sui.Menu, {inverted: targetTheme.invertedMenu, secondary: true}, tabs.map(function (t) {
            var name;
            if (t == MYSTUFF)
                name = lf("My Stuff");
            else if (t == WELCOME)
                name = lf("Welcome!");
            else
                name = Util.rlf(t);
            return (React.createElement(sui.MenuItem, {key: "tab" + t, active: tab == t, name: name, onClick: function () { return _this.setState({ tab: t }); }}));
        }), React.createElement("div", {className: "right menu"}, React.createElement(sui.Button, {icon: 'close', class: "huge clear " + (targetTheme.invertedMenu ? 'inverted' : ''), onClick: function () { return _this.hide(/* closeOnly */ true); }})))), tab == WELCOME ? React.createElement("div", {className: tabClasses}, React.createElement("div", {className: "ui stackable two column grid welcomegrid"}, React.createElement("div", {className: "six wide column labelsgroup"}, React.createElement("h2", {className: "editorname"}, pxt.appTarget.name), React.createElement("div", {className: "large ui loader editoravatar"})), React.createElement("div", {className: "group ten wide column"}, React.createElement("div", {className: "ui cards centered"}, this.state.resumeProject ? React.createElement(codecard.CodeCardView, {key: 'resume', iconColor: "teal", iconContent: lf("Resume"), description: lf("Load the last project you worked on"), onClick: function () { return resume(); }}) : undefined, pxt.appTarget.appTheme.sideDoc ? React.createElement(codecard.CodeCardView, {key: 'gettingstarted', iconColor: "green", iconContent: lf("Getting started"), description: lf("Create a fun, beginner project in a guided tutorial"), onClick: function () { return gettingStarted(); }}) : undefined, React.createElement(codecard.CodeCardView, {key: 'newproject', iconColor: "brown", iconContent: lf("New project"), description: lf("Start a new, empty project"), onClick: function () { return newProject(); }}), React.createElement(codecard.CodeCardView, {key: 'loadproject', iconColor: "grey", iconContent: lf("Load project"), description: lf("Load a previous project"), onClick: function () { return loadProject(); }}), galleryNames.length > 0 ? React.createElement(codecard.CodeCardView, {key: 'projectgalleries', iconColor: "orange", iconContent: lf("Project galleries"), description: lf("Browse guided tutorials, project samples and awesome activities"), onClick: function () { return projectGalleries(); }}) : undefined)))) : undefined, tab == MYSTUFF ? React.createElement("div", {className: tabClasses}, React.createElement("div", {className: "group"}, React.createElement("div", {className: "ui cards"}, React.createElement(codecard.CodeCardView, {key: 'newproject', icon: "file outline", iconColor: "primary", name: lf("New Project..."), description: lf("Creates a new empty project"), onClick: function () { return newProject(); }}), pxt.appTarget.compile ?
            React.createElement(codecard.CodeCardView, {key: 'import', icon: "upload", iconColor: "secondary", name: lf("Import File..."), description: lf("Open files from your computer"), onClick: function () { return importHex(); }}) : undefined, pxt.appTarget.cloud && pxt.appTarget.cloud.sharing && pxt.appTarget.cloud.publishing && pxt.appTarget.cloud.importing ?
            React.createElement(codecard.CodeCardView, {key: 'importurl', icon: "cloud download", iconColor: "secondary", name: lf("Import URL..."), description: lf("Open a shared project URL"), onClick: function () { return importUrl(); }}) : undefined)), headersGrouped.filter(function (g) { return g.headers.length != 0; }).map(function (headerGroup) {
            return React.createElement("div", {key: 'localgroup' + headerGroup.name, className: "group"}, React.createElement("h3", {className: "ui dividing header disabled"}, headerGroup.name), React.createElement("div", {className: "ui cards"}, headerGroup.headers.map(function (scr) {
                return React.createElement(codecard.CodeCardView, {key: 'local' + scr.id, name: scr.name, time: scr.recentUse, imageUrl: scr.icon, url: scr.pubId && scr.pubCurrent ? "/" + scr.pubId : "", onClick: function () { return chgHeader(scr); }});
            })));
        }), React.createElement("div", {className: "group"}, React.createElement("div", {className: "ui cards"}, urldata.map(function (scr) {
            return React.createElement(codecard.CodeCardView, {name: scr.name, time: scr.time, header: '/' + scr.id, description: scr.description, key: 'cloud' + scr.id, onClick: function () { return installScript(scr); }, url: '/' + scr.id, color: "blue"});
        })))) : undefined, tab != MYSTUFF && tab != WELCOME ? React.createElement("div", {className: tabClasses}, hadFetchError ?
            React.createElement("p", {className: "ui red inverted segment"}, lf("Oops! There was an error. Please ensure you are connected to the Internet and try again."))
            : React.createElement("div", {className: "ui cards centered"}, gals[tab].map(function (scr) { return React.createElement(codecard.CodeCardView, {key: tab + scr.name, name: scr.name, description: scr.description, url: scr.url, imageUrl: scr.imageUrl, youTubeId: scr.youTubeId, onClick: function () { return chgGallery(scr); }}); }))) : undefined, isEmpty() ?
            React.createElement("div", {className: "ui items"}, React.createElement("div", {className: "ui item"}, lf("We couldn't find any projects matching '{0}'", this.state.searchFor)))
            : undefined));
    };
    return Projects;
}(data.Component));
exports.Projects = Projects;

},{"./codecard":8,"./compiler":9,"./core":11,"./data":12,"./gallery":19,"./package":28,"./sui":37,"./workspace":41,"react":267,"react-dom":138}],30:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var React = require("react");
var pkg = require("./package");
var srceditor = require("./srceditor");
var sui = require("./sui");
var Util = pxt.Util;
var lf = Util.lf;
var Editor = (function (_super) {
    __extends(Editor, _super);
    function Editor() {
        _super.apply(this, arguments);
        this.config = {};
        this.changeMade = false;
    }
    Editor.prototype.prepare = function () {
        this.isReady = true;
    };
    Editor.prototype.getId = function () {
        return "pxtJsonEditor";
    };
    Editor.prototype.display = function () {
        var _this = this;
        var c = this.config;
        var save = function () {
            _this.isSaving = true;
            var f = pkg.mainEditorPkg().lookupFile("this/" + pxt.CONFIG_NAME);
            f.setContentAsync(JSON.stringify(_this.config, null, 4) + "\n").then(function () {
                pkg.mainPkg.config.name = c.name;
                _this.parent.setState({ projectName: c.name });
                _this.parent.forceUpdate();
                Util.nextTick(_this.changeCallback);
                _this.isSaving = false;
                _this.changeMade = true;
                // switch to previous coding experience
                _this.parent.openPreviousEditor();
            });
        };
        var setFileName = function (v) {
            c.name = v;
            _this.parent.forceUpdate();
        };
        var deleteProject = function () {
            _this.parent.removeProject();
        };
        var initCard = function () {
            if (!c.card)
                c.card = {};
        };
        var card = c.card || {};
        var userConfigs = [];
        pkg.allEditorPkgs().map(function (ep) { return ep.getKsPkg(); })
            .filter(function (dep) { return !!dep && dep.isLoaded && !!dep.config && !!dep.config.yotta && !!dep.config.yotta.userConfigs; })
            .forEach(function (dep) { return userConfigs = userConfigs.concat(dep.config.yotta.userConfigs); });
        var isUserConfigActive = function (uc) {
            var cfg = Util.jsonFlatten(_this.config.yotta ? _this.config.yotta.config : {});
            var ucfg = Util.jsonFlatten(uc.config);
            return !Object.keys(ucfg).some(function (k) { return ucfg[k] === null ? !!cfg[k] : cfg[k] !== ucfg[k]; });
        };
        var applyUserConfig = function (uc) {
            var cfg = Util.jsonFlatten(_this.config.yotta ? _this.config.yotta.config : {});
            var ucfg = Util.jsonFlatten(uc.config);
            if (isUserConfigActive(uc)) {
                Object.keys(ucfg).forEach(function (k) { return delete cfg[k]; });
            }
            else {
                Object.keys(ucfg).forEach(function (k) { return cfg[k] = ucfg[k]; });
            }
            // update cfg
            if (Object.keys(cfg).length) {
                if (!_this.config.yotta)
                    _this.config.yotta = {};
                Object.keys(cfg).filter(function (k) { return cfg[k] === null; }).forEach(function (k) { return delete cfg[k]; });
                _this.config.yotta.config = Util.jsonUnFlatten(cfg);
            }
            else {
                if (_this.config.yotta) {
                    delete _this.config.yotta.config;
                    if (!Object.keys(_this.config.yotta).length)
                        delete _this.config.yotta;
                }
            }
            // trigger update            
            save();
        };
        return (React.createElement("div", {className: "ui content"}, React.createElement("div", {className: "ui segment form text", style: { backgroundColor: "white" }}, React.createElement(sui.Input, {label: lf("Name"), value: c.name, onChange: setFileName}), userConfigs.map(function (uc) {
            return React.createElement(sui.Checkbox, {key: "userconfig-" + uc.description, inputLabel: uc.description, checked: isUserConfigActive(uc), onChange: function () { return applyUserConfig(uc); }});
        }), React.createElement(sui.Field, null, React.createElement(sui.Button, {text: lf("Save"), class: "green " + (this.isSaving ? 'disabled' : ''), onClick: function () { return save(); }}), React.createElement(sui.Button, {text: lf("Edit Settings As text"), onClick: function () { return _this.editSettingsText(); }})))));
    };
    Editor.prototype.editSettingsText = function () {
        this.changeMade = false;
        this.parent.editText();
    };
    Editor.prototype.getCurrentSource = function () {
        return JSON.stringify(this.config, null, 4) + "\n";
    };
    Editor.prototype.acceptsFile = function (file) {
        if (file.name != pxt.CONFIG_NAME)
            return false;
        if (file.isReadonly()) {
            // TODO add read-only support
            return false;
        }
        try {
            var cfg = JSON.parse(file.content);
            // TODO validate?
            return true;
        }
        catch (e) {
            return false;
        }
    };
    Editor.prototype.loadFileAsync = function (file) {
        this.config = JSON.parse(file.content);
        this.setDiagnostics(file, this.snapshotState());
        this.changeMade = false;
        return Promise.resolve();
    };
    Editor.prototype.unloadFileAsync = function () {
        if (this.changeMade) {
            return this.parent.reloadHeaderAsync();
        }
        return Promise.resolve();
    };
    return Editor;
}(srceditor.Editor));
exports.Editor = Editor;

},{"./package":28,"./srceditor":36,"./sui":37,"react":267}],31:[function(require,module,exports){
"use strict";
var workspace = require("./workspace");
var data = require("./data");
function renderIcon(img) {
    var icon = null;
    if (img && img.width > 0 && img.height > 0) {
        var cvs = document.createElement("canvas");
        cvs.width = 305;
        cvs.height = 200;
        var ox = 0;
        var oy = 0;
        var iw = 0;
        var ih = 0;
        if (img.height > img.width) {
            ox = 0;
            iw = img.width;
            ih = iw / cvs.width * cvs.height;
            oy = (img.height - ih) / 2;
        }
        else {
            oy = 0;
            ih = img.height;
            iw = ih / cvs.height * cvs.width;
            ox = (img.width - iw) / 2;
        }
        var ctx = cvs.getContext("2d");
        ctx.drawImage(img, ox, oy, iw, ih, 0, 0, cvs.width, cvs.height);
        icon = cvs.toDataURL('image/jpeg', 85);
    }
    return icon;
}
function saveAsync(header, screenshot) {
    return pxt.BrowserUtils.loadImageAsync(screenshot)
        .then(function (img) {
        var icon = renderIcon(img);
        return workspace.saveScreenshotAsync(header, screenshot, icon)
            .then(function () {
            data.invalidate("header:" + header.id);
            data.invalidate("header:*");
        });
    });
}
exports.saveAsync = saveAsync;

},{"./data":12,"./workspace":41}],32:[function(require,module,exports){
/// <reference path="../../typings/globals/react/index.d.ts" />
/// <reference path="../../typings/globals/react-dom/index.d.ts" />
/// <reference path="../../built/pxtlib.d.ts" />
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var React = require("react");
var ReactDOM = require("react-dom");
var data = require("./data");
var sui = require("./sui");
var pkg = require("./package");
var core = require("./core");
var codecard = require("./codecard");
var ScriptSearch = (function (_super) {
    __extends(ScriptSearch, _super);
    function ScriptSearch(props) {
        _super.call(this, props);
        this.prevGhData = [];
        this.prevUrlData = [];
        this.prevGalleries = [];
        this.state = {
            searchFor: '',
            visible: false
        };
    }
    ScriptSearch.prototype.hide = function () {
        this.setState({ visible: false });
    };
    ScriptSearch.prototype.showAddPackages = function () {
        this.setState({ visible: true, searchFor: '' });
    };
    ScriptSearch.prototype.fetchUrlData = function () {
        if (!this.state.searchFor)
            return [];
        var scriptid = pxt.Cloud.parseScriptId(this.state.searchFor);
        if (scriptid) {
            var res = this.getData("cloud-search:" + scriptid);
            if (res) {
                if (res.statusCode !== 404)
                    this.prevUrlData = [res];
                else
                    this.prevUrlData = [];
            }
        }
        else {
            this.prevUrlData = [];
        }
        return this.prevUrlData;
    };
    ScriptSearch.prototype.fetchGhData = function () {
        var cloud = pxt.appTarget.cloud || {};
        if (!cloud.packages)
            return [];
        var searchFor = cloud.githubPackages ? this.state.searchFor : undefined;
        var preferredPackages = undefined;
        if (!searchFor) {
            var packageConfig = this.getData("target-config:");
            preferredPackages = packageConfig && packageConfig.packages
                ? packageConfig.packages.preferredRepos
                : undefined;
        }
        var res = searchFor || preferredPackages
            ? this.getData("gh-search:" + (searchFor || preferredPackages.join('|')))
            : null;
        if (res)
            this.prevGhData = res;
        return this.prevGhData || [];
    };
    ScriptSearch.prototype.fetchBundled = function () {
        var query = this.state.searchFor;
        var bundled = pxt.appTarget.bundledpkgs;
        return Object.keys(bundled).filter(function (k) { return !/prj$/.test(k); })
            .map(function (k) { return JSON.parse(bundled[k]["pxt.json"]); })
            .filter(function (pk) { return !query || pk.name.toLowerCase().indexOf(query.toLowerCase()) > -1; }) // search filter
            .filter(function (pk) { return !pkg.mainPkg.deps[pk.name]; }); // don't show package already referenced
    };
    ScriptSearch.prototype.shouldComponentUpdate = function (nextProps, nextState, nextContext) {
        return this.state.visible != nextState.visible
            || this.state.searchFor != nextState.searchFor;
    };
    ScriptSearch.prototype.renderCore = function () {
        var _this = this;
        if (!this.state.visible)
            return React.createElement("div", null);
        var targetTheme = pxt.appTarget.appTheme;
        var bundles = this.fetchBundled();
        var ghdata = this.fetchGhData();
        var urldata = this.fetchUrlData();
        var addUrl = function (scr) {
            _this.hide();
            var p = pkg.mainEditorPkg();
            return p.addDepAsync(scr.name, "pub:" + scr.id)
                .then(function () { return _this.props.parent.reloadHeaderAsync(); });
        };
        var addBundle = function (scr) {
            pxt.tickEvent("packages.bundled", { name: scr.name });
            _this.hide();
            addDepIfNoConflict(scr, "*")
                .done();
        };
        var upd = function (v) {
            var str = ReactDOM.findDOMNode(_this.refs["searchInput"]).value;
            // Hidden way to navigate to /beta, useful for UWP app testing
            if (str === "@/beta") {
                var homeUrl = pxt.appTarget.appTheme.homeUrl;
                if (!/\/$/.test(homeUrl)) {
                    homeUrl += "/";
                }
                window.location.href = homeUrl + "beta";
            }
            else {
                _this.setState({ searchFor: str });
            }
        };
        var kupd = function (ev) {
            if (ev.keyCode == 13)
                upd(ev);
        };
        var installGh = function (scr) {
            pxt.tickEvent("packages.github");
            _this.hide();
            var p = pkg.mainEditorPkg();
            core.showLoading(lf("downloading package..."));
            pxt.packagesConfigAsync()
                .then(function (config) { return pxt.github.latestVersionAsync(scr.fullName, config); })
                .then(function (tag) { return pxt.github.pkgConfigAsync(scr.fullName, tag)
                .then(function (cfg) { return addDepIfNoConflict(cfg, "github:" + scr.fullName + "#" + tag); }); })
                .catch(core.handleNetworkError)
                .finally(function () { return core.hideLoading(); });
        };
        var addDepIfNoConflict = function (config, version) {
            return pkg.mainPkg.findConflictsAsync(config, version)
                .then(function (conflicts) {
                var inUse = conflicts.filter(function (c) { return pkg.mainPkg.isPackageInUse(c.pkg0.id); });
                var addDependencyPromise = Promise.resolve(true);
                if (inUse.length) {
                    addDependencyPromise = addDependencyPromise
                        .then(function () { return core.confirmAsync({
                        header: lf("Cannot add {0} package", config.name),
                        hideCancel: true,
                        agreeLbl: lf("Ok"),
                        body: lf("Remove all the blocks from the {0} package and try again.", inUse[0].pkg0.id)
                    }); })
                        .then(function () {
                        return false;
                    });
                }
                else if (conflicts.length) {
                    var body_1 = conflicts.length === 1 ?
                        // Single conflict: "Package a is..."
                        lf("Package {0} is incompatible with {1}. Remove {0} and add {1}?", conflicts[0].pkg0.id, config.name) :
                        // 2 conflicts: "Packages A and B are..."; 3+ conflicts: "Packages A, B, C and D are..."
                        lf("Packages {0} and {1} are incompatible with {2}. Remove them and add {2}?", conflicts.slice(0, -1).map(function (c) { return c.pkg0.id; }).join(","), conflicts.slice(-1)[0].pkg0.id, config.name);
                    addDependencyPromise = addDependencyPromise
                        .then(function () { return core.confirmAsync({
                        header: lf("Some packages will be removed"),
                        agreeLbl: lf("Remove package(s) and add {0}", config.name),
                        agreeClass: "pink",
                        body: body_1
                    }); })
                        .then(function (buttonPressed) {
                        if (buttonPressed !== 0) {
                            var p_1 = pkg.mainEditorPkg();
                            return Promise.all(conflicts.map(function (c) {
                                return p_1.removeDepAsync(c.pkg0.id);
                            }))
                                .then(function () { return true; });
                        }
                        return Promise.resolve(false);
                    });
                }
                return addDependencyPromise
                    .then(function (shouldAdd) {
                    if (shouldAdd) {
                        var p = pkg.mainEditorPkg();
                        return p.addDepAsync(config.name, version)
                            .then(function () { return _this.props.parent.reloadHeaderAsync(); });
                    }
                    return Promise.resolve();
                });
            });
        };
        var isEmpty = function () {
            if (_this.state.searchFor) {
                if (bundles.length || ghdata.length || urldata.length)
                    return false;
                return true;
            }
            return false;
        };
        var headerText = lf("Add Package...");
        return (React.createElement(sui.Modal, {open: this.state.visible, dimmer: true, header: headerText, className: "searchdialog", size: "large", onClose: function () { return _this.setState({ visible: false }); }, closeIcon: true, helpUrl: "/packages", closeOnDimmerClick: true}, React.createElement("div", {className: "ui vertical segment"}, React.createElement("div", {className: "ui search"}, React.createElement("div", {className: "ui fluid action input", role: "search"}, React.createElement("input", {ref: "searchInput", type: "text", placeholder: lf("Search or enter project URL..."), onKeyUp: kupd}), React.createElement("button", {title: lf("Search"), className: "ui right icon button", onClick: upd}, React.createElement("i", {className: "search icon"})))), React.createElement("div", {className: "ui cards"}, urldata.map(function (scr) {
            return React.createElement(codecard.CodeCardView, {key: 'url' + scr.id, name: scr.name, description: scr.description, url: "/" + scr.id, onClick: function () { return addUrl(scr); }, color: "red"});
        }), bundles.map(function (scr) {
            return React.createElement(codecard.CodeCardView, {key: 'bundled' + scr.name, name: scr.name, description: scr.description, url: "/" + scr.installedVersion, imageUrl: scr.icon, onClick: function () { return addBundle(scr); }});
        }), ghdata.filter(function (repo) { return repo.status == pxt.github.GitRepoStatus.Approved; }).map(function (scr) {
            return React.createElement(codecard.CodeCardView, {name: scr.name.replace(/^pxt-/, ""), description: scr.description, key: 'gha' + scr.fullName, onClick: function () { return installGh(scr); }, url: 'github:' + scr.fullName, color: "blue", imageUrl: pxt.github.repoIconUrl(scr), label: /\bbeta\b/i.test(scr.description) ? lf("Beta") : undefined});
        }), ghdata.filter(function (repo) { return repo.status != pxt.github.GitRepoStatus.Approved; }).map(function (scr) {
            return React.createElement(codecard.CodeCardView, {name: scr.name.replace(/^pxt-/, ""), description: lf("User provided package, not endorsed by Microsoft.") + (scr.description || ""), key: 'ghd' + scr.fullName, onClick: function () { return installGh(scr); }, url: 'github:' + scr.fullName, color: "red"});
        })), isEmpty() ?
            React.createElement("div", {className: "ui items"}, React.createElement("div", {className: "ui item"}, lf("We couldn't find any packages matching '{0}'", this.state.searchFor)))
            : undefined)));
    };
    return ScriptSearch;
}(data.Component));
exports.ScriptSearch = ScriptSearch;

},{"./codecard":8,"./core":11,"./data":12,"./package":28,"./sui":37,"react":267,"react-dom":138}],33:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var React = require("react");
var data = require("./data");
var sui = require("./sui");
var pkg = require("./package");
(function (ShareMode) {
    ShareMode[ShareMode["Screenshot"] = 0] = "Screenshot";
    ShareMode[ShareMode["Url"] = 1] = "Url";
    ShareMode[ShareMode["Editor"] = 2] = "Editor";
    ShareMode[ShareMode["Simulator"] = 3] = "Simulator";
    ShareMode[ShareMode["Cli"] = 4] = "Cli";
})(exports.ShareMode || (exports.ShareMode = {}));
var ShareMode = exports.ShareMode;
var ShareEditor = (function (_super) {
    __extends(ShareEditor, _super);
    function ShareEditor(props) {
        _super.call(this, props);
        this.state = {
            currentPubId: undefined,
            pubCurrent: false,
            visible: false,
            advancedMenu: false
        };
    }
    ShareEditor.prototype.hide = function () {
        this.setState({ visible: false });
    };
    ShareEditor.prototype.show = function (header) {
        this.setState({ visible: true, mode: ShareMode.Screenshot, pubCurrent: header.pubCurrent, sharingError: false });
    };
    ShareEditor.prototype.shouldComponentUpdate = function (nextProps, nextState, nextContext) {
        return this.state.visible != nextState.visible
            || this.state.advancedMenu != nextState.advancedMenu
            || this.state.mode != nextState.mode
            || this.state.pubCurrent != nextState.pubCurrent
            || this.state.screenshotId != nextState.screenshotId
            || this.state.currentPubId != nextState.currentPubId
            || this.state.sharingError != nextState.sharingError;
    };
    ShareEditor.prototype.renderCore = function () {
        var _this = this;
        var visible = this.state.visible;
        var targetTheme = pxt.appTarget.appTheme;
        var cloud = pxt.appTarget.cloud || {};
        var embedding = !!cloud.embedding;
        var header = this.props.parent.state.header;
        var advancedMenu = !!this.state.advancedMenu;
        var showSocialIcons = !!pxt.appTarget.appTheme.socialOptions;
        var ready = false;
        var mode = this.state.mode;
        var url = '';
        var embed = '';
        var help = lf("Copy this HTML to your website or blog.");
        if (header) {
            var shareUrl = pxt.appTarget.appTheme.shareUrl || "https://makecode.com/";
            if (!/\/$/.test(shareUrl))
                shareUrl += '/';
            var rootUrl = pxt.appTarget.appTheme.embedUrl;
            if (!/\/$/.test(rootUrl))
                rootUrl += '/';
            var isBlocks = this.props.parent.getPreferredEditor() == pxt.BLOCKS_PROJECT_NAME;
            var pubCurrent = header ? header.pubCurrent : false;
            var currentPubId_1 = (header ? header.pubId : undefined) || this.state.currentPubId;
            ready = (!!currentPubId_1 && header.pubCurrent);
            if (ready) {
                url = "" + shareUrl + currentPubId_1;
                var editUrl = rootUrl + "#pub:" + currentPubId_1;
                switch (mode) {
                    case ShareMode.Cli:
                        embed = "pxt target " + pxt.appTarget.id + "\npxt extract " + url;
                        help = lf("Run this command from a shell.");
                        break;
                    case ShareMode.Editor:
                        embed = pxt.docs.embedUrl(rootUrl, "pub", header.pubId);
                        break;
                    case ShareMode.Simulator:
                        var padding = '81.97%';
                        // TODO: parts aspect ratio
                        if (pxt.appTarget.simulator)
                            padding = (100 / pxt.appTarget.simulator.aspectRatio).toPrecision(4) + '%';
                        var runUrl = rootUrl + (pxt.webConfig.runUrl || "--run").replace(/^\//, '');
                        embed = pxt.docs.runUrl(runUrl, padding, header.pubId);
                        break;
                    case ShareMode.Url:
                        embed = editUrl;
                        break;
                    default:
                        if (isBlocks && pxt.blocks.layout.screenshotEnabled()) {
                            // Render screenshot
                            if (this.state.screenshotId == currentPubId_1) {
                                if (this.state.screenshotUri)
                                    embed = "<a href=\"" + editUrl + "\"><img src=\"" + this.state.screenshotUri + "\" /></a>";
                                else
                                    embed = lf("Ooops, no screenshot available.");
                            }
                            else {
                                pxt.debug("rendering share-editor screenshot png");
                                embed = lf("rendering...");
                                pxt.blocks.layout.toPngAsync(this.props.parent.editor.editor)
                                    .done(function (uri) { return _this.setState({ screenshotId: currentPubId_1, screenshotUri: uri }); });
                            }
                        }
                        else {
                            // Render javascript code
                            pxt.debug("rendering share-editor javascript markdown");
                            embed = lf("rendering...");
                            var main = pkg.getEditorPkg(pkg.mainPkg);
                            var file = main.getMainFile();
                            if (pkg.File.blocksFileNameRx.test(file.getName()) && file.getVirtualFileName())
                                file = main.lookupFile("this/" + file.getVirtualFileName()) || file;
                            if (pkg.File.tsFileNameRx.test(file.getName())) {
                                var fileContents = file.content;
                                var mdContent = pxt.docs.renderMarkdown({
                                    template: "@body@",
                                    markdown: "```javascript\n" + fileContents + "\n```"
                                });
                                embed = "<a style=\"text-decoration: none;\" href=\"" + editUrl + "\">" + mdContent + "</a>";
                            }
                        }
                        break;
                }
            }
        }
        var publish = function () {
            pxt.tickEvent("menu.embed.publish");
            _this.setState({ sharingError: false });
            _this.props.parent.anonymousPublishAsync()
                .catch(function (e) {
                _this.setState({ sharingError: true });
            })
                .done(function () {
                _this.setState({ pubCurrent: true });
                _this.forceUpdate();
            });
            _this.forceUpdate();
        };
        var formats = [{ mode: ShareMode.Screenshot, label: lf("Screenshot") },
            { mode: ShareMode.Editor, label: lf("Editor") },
            { mode: ShareMode.Simulator, label: lf("Simulator") },
            { mode: ShareMode.Cli, label: lf("Command line") }
        ];
        var action = !ready ? lf("Publish project") : undefined;
        var actionLoading = this.props.parent.state.publishing && !this.state.sharingError;
        var fbUrl = '';
        var twitterUrl = '';
        if (showSocialIcons) {
            var twitterText = lf("Check out what I made!");
            var socialOptions = pxt.appTarget.appTheme.socialOptions;
            if (socialOptions.twitterHandle && socialOptions.orgTwitterHandle) {
                twitterText = lf("Check out what I made with @{0} and @{1}!", socialOptions.twitterHandle, socialOptions.orgTwitterHandle);
            }
            else if (socialOptions.twitterHandle) {
                twitterText = lf("Check out what I made with @{0}!", socialOptions.twitterHandle);
            }
            else if (socialOptions.orgTwitterHandle) {
                twitterText = lf("Check out what I made with @{0}!", socialOptions.orgTwitterHandle);
            }
            fbUrl = "https://www.facebook.com/sharer/sharer.php?u=" + encodeURIComponent(url);
            twitterUrl = ("https://twitter.com/intent/tweet?url=" + encodeURIComponent(url)) +
                ("&text=" + encodeURIComponent(twitterText)) +
                (socialOptions.hashtags ? "&hashtags=" + encodeURIComponent(socialOptions.hashtags) : '');
            (socialOptions.related ? "&related=" + encodeURIComponent(socialOptions.related) : '');
        }
        var showFbPopup = function () {
            pxt.tickEvent('share.facebook');
            sui.popupWindow(fbUrl, lf("Share on Facebook"), 600, 600);
        };
        var showTwtPopup = function () {
            pxt.tickEvent('share.twitter');
            sui.popupWindow(twitterUrl, lf("Share on Twitter"), 600, 600);
        };
        return (React.createElement(sui.Modal, {open: this.state.visible, className: "sharedialog", header: lf("Share Project"), size: "small", onClose: function () { return _this.setState({ visible: false }); }, dimmer: true, action: action, actionClick: publish, actionLoading: actionLoading, closeIcon: true, closeOnDimmerClick: true, closeOnDocumentClick: true}, React.createElement("div", {className: "ui form"}, action ?
            React.createElement("div", null, React.createElement("p", null, lf("You need to publish your project to share it or embed it in other web pages.") + " " +
                lf("You acknowledge having consent to publish this project.")), this.state.sharingError ?
                React.createElement("p", {className: "ui red inverted segment"}, lf("Oops! There was an error. Please ensure you are connected to the Internet and try again."))
                : undefined)
            : undefined, url && ready ? React.createElement("div", null, React.createElement("p", null, lf("Your project is ready! Use the address below to share your projects.")), React.createElement(sui.Input, {class: "mini", readOnly: true, lines: 1, value: url, copy: true, selectOnClick: true}), showSocialIcons ? React.createElement("div", {className: "social-icons"}, React.createElement("a", {className: "ui button large icon facebook", onClick: function (e) { showFbPopup(); e.preventDefault(); return false; }}, React.createElement("i", {className: "icon facebook"})), React.createElement("a", {className: "ui button large icon twitter", onClick: function (e) { showTwtPopup(); e.preventDefault(); return false; }}, React.createElement("i", {className: "icon twitter"}))) : undefined)
            : undefined, ready ? React.createElement("div", null, React.createElement("div", {className: "ui divider"}), React.createElement(sui.Button, {class: "labeled", icon: "chevron " + (advancedMenu ? "down" : "right"), text: lf("Embed"), onClick: function () { return _this.setState({ advancedMenu: !advancedMenu }); }}), advancedMenu ?
            React.createElement(sui.Menu, {pointing: true, secondary: true}, formats.map(function (f) {
                return React.createElement(sui.MenuItem, {key: "tab" + f.label, active: mode == f.mode, name: f.label, onClick: function () { return _this.setState({ mode: f.mode }); }});
            })) : undefined, advancedMenu ?
            React.createElement(sui.Field, null, React.createElement(sui.Input, {class: "mini", readOnly: true, lines: 4, value: embed, copy: ready, disabled: !ready, selectOnClick: true})) : null) : undefined)));
    };
    return ShareEditor;
}(data.Component));
exports.ShareEditor = ShareEditor;

},{"./data":12,"./package":28,"./sui":37,"react":267}],34:[function(require,module,exports){
/// <reference path="../../built/pxtsim.d.ts" />
/// <reference path="../../localtypings/pxtparts.d.ts" />
"use strict";
var core = require("./core");
var U = pxt.U;
exports.FAST_TRACE_INTERVAL = 100;
exports.SLOW_TRACE_INTERVAL = 500;
var nextFrameId = 0;
var themes = ["blue", "red", "green", "yellow"];
var config;
var lastCompileResult;
var tutorialMode;
var $debugger;
function init(root, cfg) {
    $(root).html("\n        <div id=\"simulators\" class='simulator'>\n        </div>\n        <div id=\"debugger\" class=\"ui item landscape only\">\n        </div>\n        ");
    $debugger = $('#debugger');
    var options = {
        revealElement: function (el) {
            $(el).transition({
                animation: pxt.appTarget.appTheme.simAnimationEnter || 'fly right in',
                duration: '0.5s',
            });
        },
        removeElement: function (el, completeHandler) {
            if (pxt.appTarget.simulator.headless) {
                $(el).addClass('simHeadless');
                completeHandler();
            }
            else {
                $(el).transition({
                    animation: pxt.appTarget.appTheme.simAnimationExit || 'fly right out',
                    duration: '0.5s',
                    onComplete: function () {
                        if (completeHandler)
                            completeHandler();
                        //$(el).remove();
                    }
                }).error(function () {
                    // Problem with animation, still complete
                    if (completeHandler)
                        completeHandler();
                    //$(el).remove();
                });
            }
        },
        unhideElement: function (el) {
            $(el).removeClass("simHeadless");
        },
        onDebuggerBreakpoint: function (brk) {
            updateDebuggerButtons(brk);
            var brkInfo = lastCompileResult.breakpoints[brk.breakpointId];
            if (config)
                config.highlightStatement(brkInfo);
            if (brk.exceptionMessage) {
                core.errorNotification(lf("Program Error: {0}", brk.exceptionMessage));
            }
            postSimEditorEvent("stopped", brk.exceptionMessage);
        },
        onTraceMessage: function (msg) {
            var brkInfo = lastCompileResult.breakpoints[msg.breakpointId];
            if (config)
                config.highlightStatement(brkInfo);
        },
        onDebuggerWarning: function (wrn) {
            for (var _i = 0, _a = wrn.breakpointIds; _i < _a.length; _i++) {
                var id = _a[_i];
                var brkInfo = lastCompileResult.breakpoints[id];
                if (brkInfo) {
                    if (!U.startsWith("pxt_modules/", brkInfo.fileName)) {
                        if (config)
                            config.highlightStatement(brkInfo);
                        break;
                    }
                }
            }
        },
        onDebuggerResume: function () {
            postSimEditorEvent("resumed");
            if (config)
                config.highlightStatement(null);
            updateDebuggerButtons();
        },
        onStateChanged: function (state) {
            if (state === pxsim.SimulatorState.Stopped) {
                postSimEditorEvent("stopped");
            }
            updateDebuggerButtons();
        },
        onSimulatorCommand: function (msg) {
            switch (msg.command) {
                case "restart":
                    cfg.restartSimulator();
                    break;
                case "modal":
                    stop();
                    if (!tutorialMode && !pxt.shell.isSandboxMode()) {
                        var modalOpts = {
                            header: msg.header,
                            body: msg.body,
                            size: "large",
                            copyable: msg.copyable,
                            disagreeLbl: lf("Close")
                        };
                        var trustedSimUrls = pxt.appTarget.simulator.trustedUrls;
                        var hasTrustedLink_1 = msg.linkButtonHref && trustedSimUrls && trustedSimUrls.indexOf(msg.linkButtonHref) !== -1;
                        if (hasTrustedLink_1) {
                            modalOpts.agreeLbl = msg.linkButtonLabel;
                        }
                        else {
                            modalOpts.hideAgree = true;
                        }
                        core.confirmAsync(modalOpts)
                            .then(function (selection) {
                            if (hasTrustedLink_1 && selection == 1) {
                                window.open(msg.linkButtonHref, '_blank');
                            }
                        })
                            .done();
                    }
                    break;
            }
        },
        onTopLevelCodeEnd: function () {
            postSimEditorEvent("toplevelfinished");
        }
    };
    exports.driver = new pxsim.SimulatorDriver($('#simulators')[0], options);
    config = cfg;
    updateDebuggerButtons();
}
exports.init = init;
function postSimEditorEvent(subtype, exception) {
    if (pxt.appTarget.appTheme.allowParentController && pxt.BrowserUtils.isIFrame()) {
        pxt.editor.postHostMessageAsync({
            type: "pxthost",
            action: "simevent",
            subtype: subtype,
            exception: exception
        });
    }
}
function setState(editor, tutMode) {
    if (config && config.editor != editor) {
        config.editor = editor;
        config.highlightStatement(null);
        updateDebuggerButtons();
    }
    tutorialMode = tutMode;
}
exports.setState = setState;
function makeDirty() {
    pxsim.U.addClass(exports.driver.container, "sepia");
}
exports.makeDirty = makeDirty;
function isDirty() {
    return /sepia/.test(exports.driver.container.className);
}
exports.isDirty = isDirty;
function run(pkg, debug, res, mute, highContrast) {
    pxsim.U.removeClass(exports.driver.container, "sepia");
    var js = res.outfiles[pxtc.BINARY_JS];
    var boardDefinition = pxt.appTarget.simulator.boardDefinition;
    var parts = pxtc.computeUsedParts(res, true);
    var fnArgs = res.usedArguments;
    lastCompileResult = res;
    var opts = {
        boardDefinition: boardDefinition,
        mute: mute,
        parts: parts,
        debug: debug,
        fnArgs: fnArgs,
        highContrast: highContrast,
        aspectRatio: parts.length ? pxt.appTarget.simulator.partsAspectRatio : pxt.appTarget.simulator.aspectRatio,
        partDefinitions: pkg.computePartDefinitions(parts),
        cdnUrl: pxt.webConfig.commitCdnUrl
    };
    postSimEditorEvent("started");
    exports.driver.run(js, opts);
}
exports.run = run;
function mute(mute) {
    exports.driver.mute(mute);
    $debugger.empty();
}
exports.mute = mute;
function stop(unload) {
    if (!exports.driver)
        return;
    pxsim.U.removeClass(exports.driver.container, "sepia");
    exports.driver.stop(unload);
    $debugger.empty();
}
exports.stop = stop;
function hide(completeHandler) {
    if (!pxt.appTarget.simulator.headless) {
        pxsim.U.addClass(exports.driver.container, "sepia");
    }
    exports.driver.hide(completeHandler);
    $debugger.empty();
}
exports.hide = hide;
function unhide() {
    exports.driver.unhide();
}
exports.unhide = unhide;
function setTraceInterval(intervalMs) {
    exports.driver.setTraceInterval(intervalMs);
}
exports.setTraceInterval = setTraceInterval;
function proxy(message) {
    if (!exports.driver)
        return;
    exports.driver.postMessage(message);
    $debugger.empty();
}
exports.proxy = proxy;
function updateDebuggerButtons(brk) {
    if (brk === void 0) { brk = null; }
    function btn(icon, name, label, click) {
        var b = $("<button class=\"ui mini button teal\" title=\"" + Util.htmlEscape(label) + "\"></button>");
        if (icon)
            b.addClass("icon").append("<i class=\"" + icon + " icon\"></i>");
        if (name)
            b.append(Util.htmlEscape(name));
        return b.click(click);
    }
    $debugger.empty();
    if (!exports.driver.runOptions.debug)
        return;
    var advanced = config.editor == 'tsprj';
    if (exports.driver.state == pxsim.SimulatorState.Paused) {
        var $resume = btn("play", lf("Resume"), lf("Resume execution"), function () { return exports.driver.resume(pxsim.SimulatorDebuggerCommand.Resume); });
        var $stepOver = btn("xicon stepover", lf("Step over"), lf("Step over next function call"), function () { return exports.driver.resume(pxsim.SimulatorDebuggerCommand.StepOver); });
        var $stepInto = btn("xicon stepinto", lf("Step into"), lf("Step into next function call"), function () { return exports.driver.resume(pxsim.SimulatorDebuggerCommand.StepInto); });
        $debugger.append($resume).append($stepOver);
        if (advanced)
            $debugger.append($stepInto);
    }
    else if (exports.driver.state == pxsim.SimulatorState.Running) {
        var $pause = btn("pause", lf("Pause"), lf("Pause execution on the next instruction"), function () { return exports.driver.resume(pxsim.SimulatorDebuggerCommand.Pause); });
        $debugger.append($pause);
    }
    if (!brk || !advanced)
        return;
    function vars(hd, frame) {
        var frameView = $("<div><h4>" + U.htmlEscape(hd) + "</h4></div>");
        for (var _i = 0, _a = Object.keys(frame); _i < _a.length; _i++) {
            var k = _a[_i];
            var v = frame[k];
            var sv = "";
            switch (typeof (v)) {
                case "number":
                    sv = v + "";
                    break;
                case "string":
                    sv = JSON.stringify(v);
                    break;
                case "object":
                    if (v == null)
                        sv = "null";
                    else if (v.id !== undefined)
                        sv = "(object)";
                    else if (v.text)
                        sv = v.text;
                    else
                        sv = "(unknown)";
                    break;
                default: U.oops();
            }
            var n = k.replace(/___\d+$/, "");
            frameView.append("<div>" + U.htmlEscape(n) + ": " + U.htmlEscape(sv) + "</div>");
        }
        return frameView;
    }
    var dbgView = $("<div class=\"ui segment debuggerview\"></div>");
    dbgView.append(vars(U.lf("globals"), brk.globals));
    brk.stackframes.forEach(function (sf) {
        var info = sf.funcInfo;
        dbgView.append(vars(info.functionName, sf.locals));
    });
    $('#debugger').append(dbgView);
}

},{"./core":11}],35:[function(require,module,exports){
"use strict";
var audio = require("./audio");
var sounds = {};
var volume = 0.2;
function loadSoundAsync(id) {
    var path = ((pxt.appTarget.appTheme.sounds) || {})[id];
    if (pxt.options.light || !path)
        return Promise.resolve(undefined);
    var buffer = sounds[path];
    if (buffer)
        return Promise.resolve(buffer);
    var url = pxt.webConfig.commitCdnUrl + "sounds/" + path;
    return Util.requestAsync({
        url: url,
        headers: {
            "Accept": "audio/" + path.slice(-3)
        },
        responseArrayBuffer: true
    }).then(function (resp) { return audio.loadAsync(resp.buffer); })
        .then(function (buffer) { return sounds[path] = buffer; });
}
function playSound(id) {
    if (pxt.options.light)
        return;
    loadSoundAsync(id)
        .done(function (buf) { return buf ? audio.play(buf, volume) : undefined; });
}
function tutorialStep() { playSound('tutorialStep'); }
exports.tutorialStep = tutorialStep;
function tutorialNext() { playSound('tutorialNext'); }
exports.tutorialNext = tutorialNext;
function click() { playSound('click'); }
exports.click = click;
function initTutorial() {
    if (pxt.options.light)
        return;
    Promise.all([
        loadSoundAsync('tutorialStep'),
        loadSoundAsync('tutorialNext'),
        loadSoundAsync('click')
    ]).done();
}
exports.initTutorial = initTutorial;

},{"./audio":3}],36:[function(require,module,exports){
"use strict";
var React = require("react");
var Editor = (function () {
    function Editor(parent) {
        this.parent = parent;
        this.isVisible = false;
        this.changeCallback = function () { };
        this.isReady = false;
    }
    Editor.prototype.setVisible = function (v) {
        this.isVisible = v;
    };
    /*******************************
     Methods called before loadFile
      this.editor may be undefined
      Always check that this.editor exists
    *******************************/
    Editor.prototype.acceptsFile = function (file) {
        return false;
    };
    Editor.prototype.getViewState = function () {
        return {};
    };
    Editor.prototype.getCurrentSource = function () {
        return this.currSource;
    };
    Editor.prototype.getId = function () {
        return "editor";
    };
    Editor.prototype.displayOuter = function () {
        return (React.createElement("div", {className: 'full-abs', key: this.getId(), id: this.getId(), style: { display: this.isVisible ? "block" : "none" }}, this.display()));
    };
    Editor.prototype.display = function () {
        return null;
    };
    Editor.prototype.beforeCompile = function () { };
    Editor.prototype.prepare = function () {
        this.isReady = true;
    };
    Editor.prototype.resize = function (e) { };
    Editor.prototype.snapshotState = function () {
        return null;
    };
    Editor.prototype.unloadFileAsync = function () { return Promise.resolve(); };
    Editor.prototype.isIncomplete = function () {
        return false;
    };
    Editor.prototype.hasUndo = function () { return true; };
    Editor.prototype.hasRedo = function () { return true; };
    Editor.prototype.undo = function () { };
    Editor.prototype.redo = function () { };
    Editor.prototype.zoomIn = function () { };
    Editor.prototype.zoomOut = function () { };
    /*******************************
     loadFile
    *******************************/
    Editor.prototype.loadFileAsync = function (file, hc) {
        this.currSource = file.content;
        this.setDiagnostics(file, this.snapshotState());
        return Promise.resolve();
    };
    /*******************************
     Methods called after loadFile
      this.editor != undefined
    *******************************/
    Editor.prototype.domUpdate = function () { };
    Editor.prototype.setDiagnostics = function (file, snapshot) { };
    Editor.prototype.setViewState = function (view) { };
    Editor.prototype.saveToTypeScript = function () {
        return Promise.resolve('');
    };
    Editor.prototype.highlightStatement = function (brk) { };
    Editor.prototype.clearHighlightedStatements = function () { };
    Editor.prototype.filterToolbox = function (filters, showCategories) {
        if (showCategories === void 0) { showCategories = pxt.blocks.CategoryMode.All; }
        return null;
    };
    Editor.prototype.setHighContrast = function (hc) { };
    return Editor;
}());
exports.Editor = Editor;

},{"react":267}],37:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var React = require("react");
var ReactDOM = require("react-dom");
var data = require("./data");
function cx(classes) {
    return classes.filter(function (c) { return c && c.length !== 0 && c.trim() != ''; }).join(' ');
}
exports.cx = cx;
function genericClassName(cls, props, ignoreIcon) {
    if (ignoreIcon === void 0) { ignoreIcon = false; }
    return cls + " " + (ignoreIcon ? '' : props.icon && props.text ? 'icon-and-text' : props.icon ? 'icon' : "") + " " + (props.class || "");
}
function genericContent(props) {
    return [
        props.icon ? (React.createElement("i", {key: 'iconkey', className: props.icon + " icon " + (props.text ? " icon-and-text " : "") + (props.iconClass ? " " + props.iconClass : '')})) : null,
        props.text ? (React.createElement("span", {key: 'textkey', className: 'ui text' + (props.textClass ? ' ' + props.textClass : '')}, props.text)) : null,
    ];
}
function popupWindow(url, title, width, height) {
    return window.open(url, title, "resizable=no, copyhistory=no, " +
        ("width=" + width + ", height=" + height + ", top=" + ((screen.height / 2) - (height / 2)) + ", left=" + ((screen.width / 2) - (width / 2))));
}
exports.popupWindow = popupWindow;
var UiElement = (function (_super) {
    __extends(UiElement, _super);
    function UiElement() {
        _super.apply(this, arguments);
    }
    UiElement.prototype.popup = function () {
        if (this.props.popup) {
            var ch_1 = this.child("");
            ch_1.popup({
                content: this.props.popup
            });
            if (!ch_1.data("hasPopupHide")) {
                ch_1.data("hasPopupHide", "yes");
                ch_1.on("click", function () {
                    ch_1.popup("hide");
                });
            }
        }
    };
    UiElement.prototype.componentDidMount = function () {
        this.popup();
    };
    UiElement.prototype.componentDidUpdate = function () {
        this.popup();
    };
    return UiElement;
}(data.Component));
exports.UiElement = UiElement;
var DropdownMenuItem = (function (_super) {
    __extends(DropdownMenuItem, _super);
    function DropdownMenuItem() {
        _super.apply(this, arguments);
    }
    DropdownMenuItem.prototype.componentDidMount = function () {
        var _this = this;
        this.popup();
        this.child("").dropdown({
            action: "hide",
            fullTextSearch: true,
            onChange: function (v) {
                if (_this.props.onChange && v != _this.props.value) {
                    _this.props.onChange(v);
                }
            }
        });
    };
    DropdownMenuItem.prototype.componentDidUpdate = function () {
        this.child("").dropdown("refresh");
        this.popup();
    };
    DropdownMenuItem.prototype.renderCore = function () {
        return (React.createElement("div", {className: genericClassName("ui dropdown item", this.props), role: this.props.role, title: this.props.title}, genericContent(this.props), React.createElement("div", {className: "menu"}, this.props.children)));
    };
    return DropdownMenuItem;
}(UiElement));
exports.DropdownMenuItem = DropdownMenuItem;
var Item = (function (_super) {
    __extends(Item, _super);
    function Item() {
        _super.apply(this, arguments);
    }
    Item.prototype.renderCore = function () {
        return (React.createElement("div", {className: genericClassName("ui item link", this.props, true) + (" " + (this.props.active ? 'active' : '')), role: this.props.role, title: this.props.title || this.props.text, key: this.props.value, "data-value": this.props.value, onClick: this.props.onClick}, genericContent(this.props), this.props.children));
    };
    return Item;
}(data.Component));
exports.Item = Item;
var ButtonMenuItem = (function (_super) {
    __extends(ButtonMenuItem, _super);
    function ButtonMenuItem() {
        _super.apply(this, arguments);
    }
    ButtonMenuItem.prototype.renderCore = function () {
        return (React.createElement("div", {className: genericClassName("ui item link", this.props, true) + (" " + (this.props.active ? 'active' : '')), role: this.props.role, title: this.props.title || this.props.text, key: this.props.value, "data-value": this.props.value, onClick: this.props.onClick}, React.createElement("div", {className: genericClassName("ui button", this.props)}, genericContent(this.props), this.props.children)));
    };
    return ButtonMenuItem;
}(UiElement));
exports.ButtonMenuItem = ButtonMenuItem;
var Button = (function (_super) {
    __extends(Button, _super);
    function Button() {
        _super.apply(this, arguments);
    }
    Button.prototype.renderCore = function () {
        return (React.createElement("button", {className: genericClassName("ui button", this.props) + " " + (this.props.disabled ? "disabled" : ""), role: this.props.role, title: this.props.title, "aria-label": this.props.title || this.props.text, onClick: this.props.onClick}, genericContent(this.props), this.props.children));
    };
    return Button;
}(UiElement));
exports.Button = Button;
var Popup = (function (_super) {
    __extends(Popup, _super);
    function Popup() {
        _super.apply(this, arguments);
    }
    Popup.prototype.componentDidMount = function () {
        this.child(".popup-button").popup({
            position: "bottom right",
            on: "click",
            hoverable: true,
            delay: {
                show: 50,
                hide: 1000
            }
        });
    };
    Popup.prototype.componentDidUpdate = function () {
        this.child(".popup-button").popup('refresh');
    };
    Popup.prototype.renderCore = function () {
        return (React.createElement("div", {role: this.props.role}, React.createElement("div", {className: genericClassName("ui button popup-button", this.props)}, genericContent(this.props)), React.createElement("div", {className: "ui popup transition hidden"}, this.props.children)));
    };
    return Popup;
}(data.Component));
exports.Popup = Popup;
var Field = (function (_super) {
    __extends(Field, _super);
    function Field() {
        _super.apply(this, arguments);
    }
    Field.prototype.renderCore = function () {
        return (React.createElement("div", {className: "field"}, this.props.label ? React.createElement("label", null, this.props.label) : null, this.props.children));
    };
    return Field;
}(data.Component));
exports.Field = Field;
var Input = (function (_super) {
    __extends(Input, _super);
    function Input() {
        _super.apply(this, arguments);
    }
    Input.prototype.copy = function () {
        var p = this.props;
        var el = ReactDOM.findDOMNode(this);
        if (!p.lines || p.lines == 1) {
            var inp = el.getElementsByTagName("input")[0];
            inp.focus();
            inp.setSelectionRange(0, 9999);
        }
        else {
            var inp = el.getElementsByTagName("textarea")[0];
            inp.focus();
            inp.setSelectionRange(0, 9999);
        }
        try {
            var success = document.execCommand("copy");
            pxt.debug('copy: ' + success);
        }
        catch (e) {
        }
    };
    Input.prototype.renderCore = function () {
        var _this = this;
        var p = this.props;
        var copyBtn = p.copy && document.queryCommandSupported('copy')
            ? React.createElement(Button, {class: "ui right labeled primary icon button", text: lf("Copy"), icon: "copy", onClick: function () { return _this.copy(); }})
            : null;
        return (React.createElement(Field, {label: p.label}, React.createElement("div", {className: "ui input" + (p.inputLabel ? " labelled" : "") + (p.copy ? " action fluid" : "") + (p.disabled ? " disabled" : "")}, p.inputLabel ? (React.createElement("div", {className: "ui label"}, p.inputLabel)) : "", !p.lines || p.lines == 1 ? React.createElement("input", {className: p.class || "", type: p.type || "text", placeholder: p.placeholder, value: p.value, readOnly: !!p.readOnly, onClick: function (e) { return p.selectOnClick ? e.target.setSelectionRange(0, 9999) : undefined; }, onChange: function (v) { return p.onChange(v.target.value); }})
            : React.createElement("textarea", {className: "ui input " + (p.class || "") + (p.inputLabel ? " labelled" : ""), rows: p.lines, placeholder: p.placeholder, value: p.value, readOnly: !!p.readOnly, onClick: function (e) { return p.selectOnClick ? e.target.setSelectionRange(0, 9999) : undefined; }, onChange: function (v) { return p.onChange(v.target.value); }}), copyBtn)));
    };
    return Input;
}(data.Component));
exports.Input = Input;
var Checkbox = (function (_super) {
    __extends(Checkbox, _super);
    function Checkbox() {
        _super.apply(this, arguments);
    }
    Checkbox.prototype.renderCore = function () {
        var p = this.props;
        return React.createElement(Field, {label: p.label}, React.createElement("div", {className: "ui toggle checkbox"}, React.createElement("input", {type: "checkbox", checked: p.checked, onChange: function (v) { return p.onChange(v.target.value); }}), p.inputLabel ? React.createElement("label", null, p.inputLabel) : undefined));
    };
    return Checkbox;
}(data.Component));
exports.Checkbox = Checkbox;
var Segment = (function (_super) {
    __extends(Segment, _super);
    function Segment() {
        _super.apply(this, arguments);
    }
    Segment.prototype.renderCore = function () {
        var _a = this.props, attached = _a.attached, basic = _a.basic, children = _a.children, circular = _a.circular, className = _a.className, clearing = _a.clearing, color = _a.color, compact = _a.compact, disabled = _a.disabled, floated = _a.floated, inverted = _a.inverted, loading = _a.loading, padded = _a.padded, piled = _a.piled, raised = _a.raised, secondary = _a.secondary, size = _a.size, stacked = _a.stacked, tertiary = _a.tertiary, textAlign = _a.textAlign, vertical = _a.vertical;
        var classes = cx([
            'ui',
            color,
            size,
            basic ? 'basic' : '',
            circular ? 'circular' : '',
            clearing ? 'clearing' : '',
            compact ? 'compact' : '',
            disabled ? 'disabled' : '',
            inverted ? 'inverted' : '',
            loading ? 'loading' : '',
            piled ? 'piled' : '',
            raised ? 'raised' : '',
            secondary ? 'secondary' : '',
            stacked ? 'stacked' : '',
            tertiary ? 'tertiary' : '',
            vertical ? 'vertical' : '',
            attached ? attached + " attached" : '',
            padded ? padded + " padded" : '',
            textAlign ? (textAlign == 'justified' ? 'justified' : textAlign + " aligned") : '',
            floated ? floated + " floated" : '',
            'segment',
            className,
        ]);
        return (React.createElement("div", {className: classes}, children));
    };
    return Segment;
}(data.Component));
exports.Segment = Segment;
var MenuItem = (function (_super) {
    __extends(MenuItem, _super);
    function MenuItem(props) {
        var _this = this;
        _super.call(this, props);
        this.handleClick = function (e) {
            var onClick = _this.props.onClick;
            if (onClick)
                onClick(e, _this.props);
        };
    }
    MenuItem.prototype.renderCore = function () {
        var _a = this.props, active = _a.active, children = _a.children, className = _a.className, color = _a.color, content = _a.content, fitted = _a.fitted, header = _a.header, icon = _a.icon, link = _a.link, name = _a.name, onClick = _a.onClick, position = _a.position;
        var classes = cx([
            color,
            position,
            active ? 'active' : '',
            icon === true || icon && !(name || content) ? 'icon' : '',
            header ? 'header' : '',
            link || onClick ? 'link' : '',
            fitted ? (fitted == true ? "" + fitted : "fitted " + fitted) : '',
            'item',
            className
        ]);
        if (children) {
            return React.createElement("div", {className: classes, onClick: this.handleClick}, children);
        }
        return (React.createElement("div", {className: classes, onClick: this.handleClick}, icon ? React.createElement("i", {className: "icon " + icon}) : undefined, content || name));
    };
    return MenuItem;
}(data.Component));
exports.MenuItem = MenuItem;
var Menu = (function (_super) {
    __extends(Menu, _super);
    function Menu(props) {
        _super.call(this, props);
    }
    Menu.prototype.renderCore = function () {
        var _a = this.props, attached = _a.attached, borderless = _a.borderless, children = _a.children, className = _a.className, color = _a.color, compact = _a.compact, fixed = _a.fixed, floated = _a.floated, fluid = _a.fluid, icon = _a.icon, inverted = _a.inverted, pagination = _a.pagination, pointing = _a.pointing, secondary = _a.secondary, size = _a.size, stackable = _a.stackable, tabular = _a.tabular, text = _a.text, vertical = _a.vertical;
        var classes = cx([
            'ui',
            color,
            size,
            borderless ? 'borderless' : '',
            compact ? 'compact' : '',
            fluid ? 'fluid' : '',
            inverted ? 'inverted' : '',
            pagination ? 'pagination' : '',
            pointing ? 'pointing' : '',
            secondary ? 'secondary' : '',
            stackable ? 'stackable' : '',
            text ? 'text' : '',
            vertical ? 'vertical' : '',
            attached ? (attached == true ? 'attached' : attached + " attached ") : '',
            floated ? (floated == true ? 'floated' : floated + " floated") : '',
            icon ? (icon == true ? 'icon' : icon + " icon") : '',
            tabular ? (tabular == true ? 'tabular' : tabular + " tabular") : '',
            fixed ? "tabular " + tabular : '',
            className,
            'menu'
        ]);
        return (React.createElement("div", {className: classes}, children));
    };
    return Menu;
}(data.Component));
exports.Menu = Menu;
var Modal = (function (_super) {
    __extends(Modal, _super);
    function Modal(props) {
        var _this = this;
        _super.call(this, props);
        this.getMountNode = function () { return _this.props.mountNode || document.body; };
        this.handleClose = function (e) {
            var onClose = _this.props.onClose;
            if (onClose)
                onClose(e, _this.props);
            if (_this.state.open != false)
                _this.setState({ open: false });
        };
        this.handleOpen = function (e) {
            var onOpen = _this.props.onOpen;
            if (onOpen)
                onOpen(e, _this.props);
            if (_this.state.open != true)
                _this.setState({ open: true });
        };
        this.setPosition = function () {
            if (_this.ref) {
                var mountNode = _this.getMountNode();
                var height = void 0;
                // Check to make sure the ref is actually in the DOM or else IE11 throws an exception
                if (_this.ref.parentElement) {
                    height = _this.ref.getBoundingClientRect().height;
                }
                else {
                    height = 0;
                }
                // const marginTop = -Math.round(height / 2);
                var marginTop = 0;
                var scrolling = height >= window.innerHeight;
                var newState = {};
                if (_this.state.marginTop !== marginTop) {
                    newState.marginTop = marginTop;
                }
                if (_this.state.scrolling !== scrolling) {
                    newState.scrolling = scrolling;
                    if (scrolling) {
                        mountNode.classList.add('scrolling');
                    }
                    else {
                        mountNode.classList.remove('scrolling');
                    }
                }
                if (Object.keys(newState).length > 0)
                    _this.setState(newState);
            }
            _this.animationId = requestAnimationFrame(_this.setPosition);
        };
        this.handlePortalMount = function () {
            var dimmer = _this.props.dimmer;
            var mountNode = _this.getMountNode();
            if (dimmer) {
                mountNode.classList.add('dimmable', 'dimmed');
                if (dimmer === 'blurring' && !pxt.options.light) {
                    mountNode.classList.add('blurring');
                }
            }
            _this.setPosition();
        };
        this.handleRef = function (c) { return (_this.ref = c); };
        this.handlePortalUnmount = function () {
            var mountNode = _this.getMountNode();
            mountNode.classList.remove('blurring', 'dimmable', 'dimmed', 'scrollable');
            if (_this.animationId)
                cancelAnimationFrame(_this.animationId);
        };
        this.id = Util.guidGen();
        this.state = {
            open: this.props.open
        };
    }
    Modal.prototype.componentWillUnmount = function () {
        this.handlePortalUnmount();
    };
    Modal.prototype.componentWillMount = function () {
        var open = this.props.open;
        this.state = { open: open };
    };
    Modal.prototype.componentWillReceiveProps = function (nextProps) {
        var newState = {};
        if (nextProps.open != undefined) {
            newState.open = nextProps.open;
        }
        if (Object.keys(newState).length > 0)
            this.setState(newState);
    };
    Modal.prototype.renderCore = function () {
        var _this = this;
        var open = this.state.open;
        var _a = this.props, basic = _a.basic, children = _a.children, className = _a.className, closeIcon = _a.closeIcon, closeOnDimmerClick = _a.closeOnDimmerClick, closeOnDocumentClick = _a.closeOnDocumentClick, dimmer = _a.dimmer, dimmerClassName = _a.dimmerClassName, size = _a.size;
        var _b = this.state, marginTop = _b.marginTop, scrolling = _b.scrolling;
        var classes = cx([
            'ui',
            size,
            basic ? 'basic' : '',
            scrolling ? 'scrolling' : '',
            'modal transition visible active',
            className,
        ]);
        var closeIconName = closeIcon === true ? 'close' : closeIcon;
        var modalJSX = (React.createElement("div", {className: classes, style: { marginTop: marginTop }, ref: this.handleRef, role: "dialog", "aria-labelledby": this.id + 'title', "aria-describedby": this.id + 'desc'}, this.props.closeIcon ? React.createElement(Button, {icon: closeIconName, class: "huge clear right floated", onClick: function () { return _this.handleClose(null); }}) : undefined, this.props.helpUrl ?
            React.createElement("a", {className: "ui button huge icon clear right floated", href: this.props.helpUrl, target: "_docs"}, React.createElement("i", {className: "help icon"}))
            : undefined, this.props.header ? React.createElement("div", {id: this.id + 'title', className: "header " + (this.props.headerClass || "")}, this.props.header) : undefined, React.createElement("div", {id: this.id + 'desc', className: "content"}, children), this.props.action && this.props.actionClick ?
            React.createElement("div", {className: "actions"}, React.createElement(Button, {text: this.props.action, class: "approve primary " + (this.props.actionLoading ? "loading disabled" : ""), onClick: function () {
                _this.props.actionClick();
            }})) : undefined));
        var dimmerClasses = !dimmer
            ? null
            : cx([
                'ui',
                dimmer === 'inverted' ? 'inverted' : '',
                pxt.options.light ? '' : "transition",
                'page modals dimmer visible active',
                dimmerClassName
            ]);
        var blurring = dimmer === 'blurring';
        return (React.createElement(Portal, {closeOnRootNodeClick: closeOnDimmerClick, closeOnDocumentClick: closeOnDocumentClick, className: dimmerClasses, mountNode: this.getMountNode(), onMount: this.handlePortalMount, onUnmount: this.handlePortalUnmount, onClose: this.handleClose, onOpen: this.handleOpen, open: open}, modalJSX));
    };
    return Modal;
}(data.Component));
exports.Modal = Modal;
var Portal = (function (_super) {
    __extends(Portal, _super);
    function Portal(props) {
        var _this = this;
        _super.call(this, props);
        this.handleDocumentClick = function (e) {
            var _a = _this.props, closeOnDocumentClick = _a.closeOnDocumentClick, closeOnRootNodeClick = _a.closeOnRootNodeClick;
            if (!_this.rootNode || !_this.portalNode || _this.portalNode.contains(e.target))
                return;
            var didClickInRootNode = _this.rootNode.contains(e.target);
            if (closeOnDocumentClick && !didClickInRootNode || closeOnRootNodeClick && didClickInRootNode) {
                _this.close(e);
            }
        };
        this.close = function (e) {
            var onClose = _this.props.onClose;
            if (onClose)
                onClose(e);
            if (_this.state.open != false)
                _this.setState({ open: false });
        };
        this.open = function (e) {
            var onOpen = _this.props.onOpen;
            if (onOpen)
                onOpen(e);
            if (_this.state.open != true)
                _this.setState({ open: true });
        };
        this.mountPortal = function () {
            if (_this.rootNode)
                return;
            var _a = _this.props.mountNode, mountNode = _a === void 0 ? document.body : _a;
            _this.rootNode = document.createElement('div');
            mountNode.appendChild(_this.rootNode);
            document.addEventListener('click', _this.handleDocumentClick);
            var onMount = _this.props.onMount;
            if (onMount)
                onMount();
        };
        this.unmountPortal = function () {
            if (!_this.rootNode)
                return;
            ReactDOM.unmountComponentAtNode(_this.rootNode);
            _this.rootNode.parentNode.removeChild(_this.rootNode);
            _this.rootNode = null;
            _this.portalNode = null;
            document.removeEventListener('click', _this.handleDocumentClick);
            var onUnmount = _this.props.onUnmount;
            if (onUnmount)
                onUnmount();
        };
    }
    Portal.prototype.componentDidMount = function () {
        if (this.state.open) {
            this.renderPortal();
        }
    };
    Portal.prototype.componentDidUpdate = function (prevProps, prevState) {
        if (this.state.open) {
            this.renderPortal();
        }
        if (prevState.open && !this.state.open) {
            this.unmountPortal();
        }
    };
    Portal.prototype.componentWillUnmount = function () {
        this.unmountPortal();
    };
    Portal.prototype.componentWillMount = function () {
        var open = this.props.open;
        this.state = { open: open };
    };
    Portal.prototype.componentWillReceiveProps = function (nextProps) {
        var newState = {};
        if (nextProps.open != undefined) {
            newState.open = nextProps.open;
        }
        if (Object.keys(newState).length > 0)
            this.setState(newState);
    };
    Portal.prototype.renderPortal = function () {
        var _a = this.props, children = _a.children, className = _a.className, open = _a.open;
        this.mountPortal();
        this.rootNode.className = className || '';
        ReactDOM.unstable_renderSubtreeIntoContainer(this, React.Children.only(children), this.rootNode);
        this.portalNode = this.rootNode.firstElementChild;
    };
    Portal.prototype.renderCore = function () {
        return React.createElement("div", null);
    };
    return Portal;
}(data.Component));
exports.Portal = Portal;

},{"./data":12,"react":267,"react-dom":138}],38:[function(require,module,exports){
"use strict";
var pkg = require("./package");
var compiler = require("./compiler");
var iface;
function td2tsAsync(td) {
    if (!iface)
        iface = pxt.worker.makeWebWorker(pxt.webConfig.tdworkerjs);
    return pkg.mainPkg.getCompileOptionsAsync()
        .then(function (opts) {
        opts.ast = true;
        return compiler.workerOpAsync("compileTd", { options: opts });
    })
        .then(function (apiinfo) {
        var arg = {
            text: td,
            useExtensions: true,
            apiInfo: apiinfo
        };
        return iface.opAsync("td2ts", arg);
    })
        .then(function (resp) {
        pxt.debug(resp);
        return resp.text;
    });
}
exports.td2tsAsync = td2tsAsync;

},{"./compiler":9,"./package":28}],39:[function(require,module,exports){
"use strict";
var defaultToolboxString = "<xml id=\"blocklyToolboxDefinition\" style=\"display: none\">\n    <category name=\"Loops\" nameid=\"loops\" colour=\"#107c10\" category=\"50\" web-icon=\"\uF01E\" iconclass=\"blocklyTreeIconloops\" expandedclass=\"blocklyTreeIconloops\">\n        <block type=\"controls_repeat_ext\">\n            <value name=\"TIMES\">\n                <shadow type=\"math_number\">\n                    <field name=\"NUM\">4</field>\n                </shadow>\n            </value>\n        </block>\n        <block type=\"device_while\">\n            <value name=\"COND\">\n                <shadow type=\"logic_boolean\"></shadow>\n            </value>\n        </block>\n        <block type=\"controls_simple_for\">\n            <value name=\"TO\">\n                <shadow type=\"math_number\">\n                    <field name=\"NUM\">4</field>\n                </shadow>\n            </value>\n        </block>\n        <block type=\"controls_for_of\">\n            <value name=\"LIST\">\n                <shadow type=\"variables_get\">\n                    <field name=\"VAR\">list</field>\n                </shadow>\n            </value>\n        </block>\n    </category>\n    <category name=\"Logic\" nameid=\"logic\" colour=\"#006970\" category=\"49\" web-icon=\"\uF074\" iconclass=\"blocklyTreeIconlogic\" expandedclass=\"blocklyTreeIconlogic\">\n        <block type=\"controls_if\" gap=\"8\">\n            <value name=\"IF0\">\n                <shadow type=\"logic_boolean\">\n                    <field name=\"BOOL\">TRUE</field>\n                </shadow>\n            </value>\n        </block>\n        <block type=\"controls_if\" gap=\"8\">\n            <mutation else=\"1\"></mutation>\n            <value name=\"IF0\">\n                <shadow type=\"logic_boolean\">\n                    <field name=\"BOOL\">TRUE</field>\n                </shadow>\n            </value>\n        </block>\n        <block type=\"logic_compare\" gap=\"8\">\n            <value name=\"A\">\n                <shadow type=\"math_number\">\n                    <field name=\"NUM\">0</field>\n                </shadow>\n            </value>\n            <value name=\"B\">\n                <shadow type=\"math_number\">\n                    <field name=\"NUM\">0</field>\n                </shadow>\n            </value>\n        </block>\n        <block type=\"logic_compare\">\n            <field name=\"OP\">LT</field>\n            <value name=\"A\">\n                <shadow type=\"math_number\">\n                    <field name=\"NUM\">0</field>\n                </shadow>\n            </value>\n            <value name=\"B\">\n                <shadow type=\"math_number\">\n                    <field name=\"NUM\">0</field>\n                </shadow>\n            </value>\n        </block>\n        <block type=\"logic_operation\" gap=\"8\"></block>\n        <block type=\"logic_operation\" gap=\"8\">\n            <field name=\"OP\">OR</field>\n        </block>\n        <block type=\"logic_negate\"></block>\n        <block type=\"logic_boolean\" gap=\"8\"></block>\n        <block type=\"logic_boolean\">\n            <field name=\"BOOL\">FALSE</field>\n        </block>\n    </category>\n    <category name=\"Math\" nameid=\"math\" colour=\"#712672\" category=\"47\" web-icon=\"\uF1EC\" iconclass=\"blocklyTreeIconmath\" expandedclass=\"blocklyTreeIconmath\">\n        <block type=\"math_arithmetic\" gap=\"8\">\n            <value name=\"A\">\n                <shadow type=\"math_number\">\n                    <field name=\"NUM\">0</field>\n                </shadow>\n            </value>\n            <value name=\"B\">\n                <shadow type=\"math_number\">\n                    <field name=\"NUM\">0</field>\n                </shadow>\n            </value>\n        </block>\n        <block type=\"math_arithmetic\" gap=\"8\">\n            <value name=\"A\">\n                <shadow type=\"math_number\">\n                    <field name=\"NUM\">0</field>\n                </shadow>\n            </value>\n            <value name=\"B\">\n                <shadow type=\"math_number\">\n                    <field name=\"NUM\">0</field>\n                </shadow>\n            </value>\n            <field name=\"OP\">MINUS</field>\n        </block>\n        <block type=\"math_arithmetic\" gap=\"8\">\n            <value name=\"A\">\n                <shadow type=\"math_number\">\n                    <field name=\"NUM\">0</field>\n                </shadow>\n            </value>\n            <value name=\"B\">\n                <shadow type=\"math_number\">\n                    <field name=\"NUM\">0</field>\n                </shadow>\n            </value>\n            <field name=\"OP\">MULTIPLY</field>\n        </block>\n        <block type=\"math_arithmetic\" gap=\"8\">\n            <value name=\"A\">\n                <shadow type=\"math_number\">\n                    <field name=\"NUM\">0</field>\n                </shadow>\n            </value>\n            <value name=\"B\">\n                <shadow type=\"math_number\">\n                    <field name=\"NUM\">0</field>\n                </shadow>\n            </value>\n            <field name=\"OP\">DIVIDE</field>\n        </block>\n        <block type=\"math_number\" gap=\"8\">\n            <field name=\"NUM\">0</field>\n        </block>\n        <category colour=\"#712672\" name=\"More\" nameid=\"more\" iconclass=\"blocklyTreeIconmore\" expandedclass=\"blocklyTreeIconmore\">\n            <block type=\"math_modulo\">\n                <value name=\"DIVIDEND\">\n                    <shadow type=\"math_number\">\n                        <field name=\"NUM\">0</field>\n                    </shadow>\n                </value>\n                <value name=\"DIVISOR\">\n                    <shadow type=\"math_number\">\n                        <field name=\"NUM\">1</field>\n                    </shadow>\n                </value>\n            </block>\n            <block type=\"math_op2\" gap=\"8\">\n                <value name=\"x\">\n                    <shadow type=\"math_number\">\n                        <field name=\"NUM\">0</field>\n                    </shadow>\n                </value>\n                <value name=\"y\">\n                    <shadow type=\"math_number\">\n                        <field name=\"NUM\">0</field>\n                    </shadow>\n                </value>\n            </block>\n            <block type=\"math_op2\" gap=\"8\">\n                <value name=\"x\">\n                    <shadow type=\"math_number\">\n                        <field name=\"NUM\">0</field>\n                    </shadow>\n                </value>\n                <value name=\"y\">\n                    <shadow type=\"math_number\">\n                        <field name=\"NUM\">0</field>\n                    </shadow>\n                </value>\n                <field name=\"op\">max</field>\n            </block>\n            <block type=\"math_op3\">\n                <value name=\"x\">\n                    <shadow type=\"math_number\">\n                        <field name=\"NUM\">0</field>\n                    </shadow>\n                </value>\n            </block>\n        </category>\n    </category>\n    <category name=\"Variables\" nameid=\"variables\" colour=\"#A80000\" custom=\"VARIABLE\" category=\"48\" iconclass=\"blocklyTreeIconvariables\" expandedclass=\"blocklyTreeIconvariables\">\n    </category>\n    <category name=\"Functions\" nameid=\"functions\" colour=\"#005a9e\" custom=\"PROCEDURE\" category=\"46\" iconclass=\"blocklyTreeIconfunctions\" expandedclass=\"blocklyTreeIconfunctions\" advanced=\"true\">\n    </category>\n    <category colour=\"#66672C\" name=\"Arrays\" nameid=\"arrays\" category=\"45\" web-icon=\"\uF0CB\" iconclass=\"blocklyTreeIconarrays\" expandedclass=\"blocklyTreeIconarrays\" advanced=\"true\">\n        <block type=\"lists_create_with\">\n            <mutation items=\"1\"></mutation>\n            <value name=\"ADD0\">\n                <shadow type=\"math_number\">\n                    <field name=\"NUM\">0</field>\n                </shadow>\n            </value>\n        </block>\n        <block type=\"lists_create_with\">\n            <mutation items=\"2\"></mutation>\n            <value name=\"ADD0\">\n                <shadow type=\"text\">\n                    <field name=\"TEXT\"></field>\n                </shadow>\n            </value>\n            <value name=\"ADD1\">\n                <shadow type=\"text\">\n                    <field name=\"TEXT\"></field>\n                </shadow>\n            </value>\n        </block>\n        <block type=\"lists_length\"></block>\n        <block type=\"lists_index_get\">\n            <value name=\"LIST\">\n                <block type=\"variables_get\">\n                    <field name=\"VAR\">list</field>\n                </block>\n            </value>\n            <value name=\"INDEX\">\n                <shadow type=\"math_number\">\n                    <field name=\"NUM\">0</field>\n                </shadow>\n            </value>\n        </block>\n        <block type=\"lists_index_set\">\n            <value name=\"LIST\">\n                <block type=\"variables_get\">\n                    <field name=\"VAR\">list</field>\n                </block>\n            </value>\n            <value name=\"INDEX\">\n                <shadow type=\"math_number\">\n                    <field name=\"NUM\">0</field>\n                </shadow>\n            </value>\n        </block>\n    </category>\n    <category colour=\"#996600\" name=\"Text\" nameid=\"text\" category=\"46\" web-icon=\"\uF035\" iconclass=\"blocklyTreeIcontext\" expandedclass=\"blocklyTreeIcontext\" advanced=\"true\">\n        <block type=\"text\"></block>\n        <block type=\"text_length\">\n            <value name=\"VALUE\">\n                <shadow type=\"text\">\n                    <field name=\"TEXT\">abc</field>\n                </shadow>\n            </value>\n        </block>\n        <block type=\"text_join\">\n            <mutation items=\"2\"></mutation>\n            <value name=\"ADD0\">\n                <shadow type=\"text\">\n                    <field name=\"TEXT\"></field>\n                </shadow>\n            </value>\n            <value name=\"ADD1\">\n                <shadow type=\"text\">\n                    <field name=\"TEXT\"></field>\n                </shadow>\n            </value>\n        </block>\n    </category>\n</xml>";
var cachedToolboxDom;
function getBaseToolboxDom() {
    if (!cachedToolboxDom) {
        overrideBaseToolbox(defaultToolboxString);
    }
    return cachedToolboxDom;
}
exports.getBaseToolboxDom = getBaseToolboxDom;
function overrideBaseToolbox(xml) {
    cachedToolboxDom = new DOMParser().parseFromString(xml, 'text/xml');
}
exports.overrideBaseToolbox = overrideBaseToolbox;

},{}],40:[function(require,module,exports){
/// <reference path="../../typings/globals/react/index.d.ts" />
/// <reference path="../../typings/globals/react-dom/index.d.ts" />
/// <reference path="../../built/pxtlib.d.ts" />
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var React = require("react");
var data = require("./data");
var sui = require("./sui");
var sounds = require("./sounds");
var TutorialMenuItem = (function (_super) {
    __extends(TutorialMenuItem, _super);
    function TutorialMenuItem(props) {
        _super.call(this, props);
    }
    TutorialMenuItem.prototype.openTutorialStep = function (step) {
        var options = this.props.parent.state.tutorialOptions;
        options.tutorialStep = step;
        pxt.tickEvent("tutorial.step", { tutorial: options.tutorial, step: step });
        this.props.parent.setTutorialStep(step);
    };
    TutorialMenuItem.prototype.render = function () {
        var _this = this;
        var _a = this.props.parent.state.tutorialOptions, tutorialReady = _a.tutorialReady, tutorialSteps = _a.tutorialSteps, tutorialStep = _a.tutorialStep, tutorialName = _a.tutorialName;
        var state = this.props.parent.state;
        var targetTheme = pxt.appTarget.appTheme;
        var currentStep = tutorialStep;
        return React.createElement("div", {className: "ui item"}, React.createElement("div", {className: "ui item tutorial-menuitem"}, tutorialSteps.map(function (step, index) {
            return (index == currentStep) ?
                React.createElement("span", {className: "step-label", key: 'tutorialStep' + index}, React.createElement("a", {className: "ui circular label " + (currentStep == index ? 'blue selected' : 'inverted') + " " + (!tutorialReady ? 'disabled' : ''), onClick: function () { return _this.openTutorialStep(index); }}, index + 1)) :
                React.createElement("span", {className: "step-label", key: 'tutorialStep' + index, "data-tooltip": "" + (index + 1), "data-inverted": "", "data-position": "bottom center"}, React.createElement("a", {className: "ui empty circular label " + (!tutorialReady ? 'disabled' : '') + " clear", onClick: function () { return _this.openTutorialStep(index); }}));
        })));
    };
    return TutorialMenuItem;
}(data.Component));
exports.TutorialMenuItem = TutorialMenuItem;
var TutorialContent = (function (_super) {
    __extends(TutorialContent, _super);
    function TutorialContent(props) {
        _super.call(this, props);
    }
    TutorialContent.notify = function (message) {
        var tc = document.getElementById("tutorialcontent");
        if (tc && tc.contentWindow)
            tc.contentWindow.postMessage(message, "*");
    };
    TutorialContent.prototype.setPath = function (path) {
        var docsUrl = pxt.webConfig.docsUrl || '/--docs';
        var mode = this.props.parent.isBlocksEditor() ? "blocks" : "js";
        var url = docsUrl + "#tutorial:" + path + ":" + mode + ":" + pxt.Util.localeInfo();
        this.setUrl(url);
    };
    TutorialContent.prototype.setUrl = function (url) {
        var el = document.getElementById("tutorialcontent");
        if (el)
            el.src = url;
        else
            this.setState({ tutorialUrl: url });
    };
    TutorialContent.prototype.shouldComponentUpdate = function (nextProps, nextState, nextContext) {
        return this.state.tutorialUrl != nextState.tutorialUrl;
    };
    TutorialContent.refresh = function () {
        // Show light box
        sounds.tutorialStep();
        $('#root')
            .dimmer({ 'closable': true })
            .dimmer('show');
    };
    TutorialContent.prototype.renderCore = function () {
        var tutorialUrl = this.state.tutorialUrl;
        if (!tutorialUrl)
            return null;
        return React.createElement("iframe", {id: "tutorialcontent", style: { "width": "1px", "height": "1px" }, src: tutorialUrl, role: "complementary", sandbox: "allow-scripts allow-same-origin allow-popups allow-forms"});
    };
    return TutorialContent;
}(data.Component));
exports.TutorialContent = TutorialContent;
var TutorialHint = (function (_super) {
    __extends(TutorialHint, _super);
    function TutorialHint(props) {
        _super.call(this, props);
    }
    TutorialHint.prototype.showHint = function () {
        this.setState({ visible: true });
    };
    TutorialHint.prototype.renderCore = function () {
        var _this = this;
        var visible = this.state.visible;
        var options = this.props.parent.state.tutorialOptions;
        var tutorialReady = options.tutorialReady, tutorialStepInfo = options.tutorialStepInfo, tutorialStep = options.tutorialStep, tutorialName = options.tutorialName;
        if (!tutorialReady)
            return React.createElement("div", null);
        var tutorialHint = tutorialStepInfo[tutorialStep].content;
        var tutorialFullscreen = tutorialStepInfo[tutorialStep].fullscreen;
        // TODO: Use step name instead of tutorial Name in full screen mode.
        var header = tutorialFullscreen ? tutorialName : lf("Hint");
        return React.createElement(sui.Modal, {open: visible, className: "hintdialog", size: "small", header: header, closeIcon: true, onClose: function () { return _this.setState({ visible: false }); }, dimmer: true, closeOnDimmerClick: true, closeOnDocumentClick: true}, React.createElement("div", {className: "content"}, React.createElement("div", {dangerouslySetInnerHTML: { __html: tutorialHint }})), React.createElement("div", {className: "actions", style: { textAlign: "right" }}, React.createElement(sui.Button, {class: "green", icon: "check", text: lf("Ok"), onClick: function () { return _this.setState({ visible: false }); }})));
    };
    return TutorialHint;
}(data.Component));
exports.TutorialHint = TutorialHint;
var TutorialCard = (function (_super) {
    __extends(TutorialCard, _super);
    function TutorialCard(props) {
        _super.call(this, props);
    }
    TutorialCard.prototype.previousTutorialStep = function () {
        var options = this.props.parent.state.tutorialOptions;
        var currentStep = options.tutorialStep;
        var previousStep = currentStep - 1;
        options.tutorialStep = previousStep;
        pxt.tickEvent("tutorial.previous", { tutorial: options.tutorial, step: previousStep });
        this.props.parent.setTutorialStep(previousStep);
    };
    TutorialCard.prototype.nextTutorialStep = function () {
        var options = this.props.parent.state.tutorialOptions;
        var currentStep = options.tutorialStep;
        var nextStep = currentStep + 1;
        options.tutorialStep = nextStep;
        pxt.tickEvent("tutorial.next", { tutorial: options.tutorial, step: nextStep });
        this.props.parent.setTutorialStep(nextStep);
    };
    TutorialCard.prototype.finishTutorial = function () {
        this.closeLightbox();
        this.props.parent.completeTutorial();
    };
    TutorialCard.prototype.closeLightbox = function () {
        // Hide light box
        sounds.tutorialNext();
        $('#root')
            .dimmer('hide');
    };
    TutorialCard.prototype.componentWillUpdate = function () {
        $('#tutorialhint')
            .modal('attach events', '#tutorialcard .ui.button.hintbutton', 'show');
        ;
    };
    TutorialCard.prototype.showHint = function () {
        this.closeLightbox();
        this.props.parent.showTutorialHint();
    };
    TutorialCard.prototype.render = function () {
        var _this = this;
        var options = this.props.parent.state.tutorialOptions;
        var tutorialReady = options.tutorialReady, tutorialStepInfo = options.tutorialStepInfo, tutorialStep = options.tutorialStep, tutorialSteps = options.tutorialSteps;
        if (!tutorialReady)
            return React.createElement("div", null);
        var tutorialHeaderContent = tutorialStepInfo[tutorialStep].headerContent;
        var currentStep = tutorialStep;
        var maxSteps = tutorialSteps.length;
        var hasPrevious = tutorialReady && currentStep != 0;
        var hasNext = tutorialReady && currentStep != maxSteps - 1;
        var hasFinish = currentStep == maxSteps - 1;
        var hasHint = tutorialStepInfo[tutorialStep].hasHint;
        return React.createElement("div", {id: "tutorialcard", className: "ui " + (tutorialReady ? 'tutorialReady' : '')}, React.createElement("div", {className: 'ui buttons'}, React.createElement("div", {className: "ui segment attached message"}, React.createElement("div", {className: 'avatar-image', onClick: function () { return _this.showHint(); }}), hasHint ? React.createElement(sui.Button, {class: "mini blue hintbutton hidelightbox", text: lf("Hint"), onClick: function () { return _this.showHint(); }}) : undefined, React.createElement("div", {className: 'tutorialmessage', onClick: function () { return _this.showHint(); }}, React.createElement("div", {className: "content", dangerouslySetInnerHTML: { __html: tutorialHeaderContent }})), React.createElement(sui.Button, {class: "large green okbutton showlightbox", text: lf("Ok"), onClick: function () { return _this.closeLightbox(); }})), hasNext ? React.createElement(sui.Button, {icon: "right chevron", class: "ui right icon button nextbutton right attached green " + (!hasNext ? 'disabled' : ''), text: lf("Next"), onClick: function () { return _this.nextTutorialStep(); }}) : undefined, hasFinish ? React.createElement(sui.Button, {icon: "left checkmark", class: "ui icon orange button " + (!tutorialReady ? 'disabled' : ''), text: lf("Finish"), onClick: function () { return _this.finishTutorial(); }}) : undefined));
    };
    return TutorialCard;
}(data.Component));
exports.TutorialCard = TutorialCard;
var TutorialComplete = (function (_super) {
    __extends(TutorialComplete, _super);
    function TutorialComplete(props) {
        _super.call(this, props);
        this.state = {
            visible: false
        };
    }
    TutorialComplete.prototype.hide = function () {
        this.setState({ visible: false });
    };
    TutorialComplete.prototype.show = function () {
        this.setState({ visible: true });
    };
    TutorialComplete.prototype.moreTutorials = function () {
        pxt.tickEvent("tutorial.completed.more");
        this.props.parent.openTutorials();
    };
    TutorialComplete.prototype.exitTutorial = function () {
        pxt.tickEvent("tutorial.completed.exit");
        this.hide();
        this.props.parent.exitTutorial(true);
    };
    TutorialComplete.prototype.renderCore = function () {
        var _this = this;
        var visible = this.state.visible;
        return (React.createElement(sui.Modal, {open: this.state.visible, className: "sharedialog", header: lf("Congratulations! What's next?"), size: "small", onClose: function () { return _this.setState({ visible: false }); }, dimmer: true, closeIcon: true, closeOnDimmerClick: true, closeOnDocumentClick: true}, React.createElement("div", {className: "ui two stackable cards"}, React.createElement("div", {className: "ui grid centered link card", onClick: function () { return _this.moreTutorials(); }}, React.createElement("div", {className: "content"}, React.createElement("i", {className: "avatar-image icon huge", style: { fontSize: '100px' }})), React.createElement("div", {className: "content"}, React.createElement("div", {className: "header"}, lf("More Tutorials")))), React.createElement("div", {className: "ui grid centered link card", onClick: function () { return _this.exitTutorial(); }}, React.createElement("div", {className: "content"}, React.createElement("i", {className: "external icon huge black", style: { fontSize: '100px' }})), React.createElement("div", {className: "content"}, React.createElement("div", {className: "header"}, lf("Exit Tutorial")))))));
    };
    return TutorialComplete;
}(data.Component));
exports.TutorialComplete = TutorialComplete;

},{"./data":12,"./sounds":35,"./sui":37,"react":267}],41:[function(require,module,exports){
/// <reference path="../../built/pxtlib.d.ts" />
/// <reference path="../../built/pxteditor.d.ts" />
/// <reference path="../../built/pxtwinrt.d.ts" />
"use strict";
var db = require("./db");
var core = require("./core");
var data = require("./data");
var cloudworkspace = require("./cloudworkspace");
var fileworkspace = require("./fileworkspace");
var memoryworkspace = require("./memoryworkspace");
var iframeworkspace = require("./iframeworkspace");
var scripts = new db.Table("script");
var U = pxt.Util;
var Cloud = pxt.Cloud;
var lf = U.lf;
var impl;
function setupWorkspace(id) {
    U.assert(!impl, "workspace set twice");
    pxt.debug("workspace: " + id);
    switch (id) {
        case "fs":
        case "file":
            impl = fileworkspace.provider;
            break;
        case "mem":
        case "memory":
            impl = memoryworkspace.provider;
            break;
        case "iframe":
            impl = iframeworkspace.provider;
            break;
        case "uwp":
            impl = data.wrapWorkspace(pxt.winrt.workspace.provider);
            break;
        case "cloud":
        default:
            impl = cloudworkspace.provider;
            break;
    }
}
exports.setupWorkspace = setupWorkspace;
function getHeaders(withDeleted) {
    if (withDeleted === void 0) { withDeleted = false; }
    checkSession();
    var r = impl.getHeaders();
    if (!withDeleted)
        r = r.filter(function (r) { return !r.isDeleted; });
    r.sort(function (a, b) { return b.recentUse - a.recentUse; });
    return r;
}
exports.getHeaders = getHeaders;
function getHeader(id) {
    checkSession();
    var hd = impl.getHeader(id);
    if (hd && !hd.isDeleted)
        return hd;
    return null;
}
exports.getHeader = getHeader;
function importLegacyScriptsAsync() {
    checkSession();
    return impl.importLegacyScriptsAsync ? impl.importLegacyScriptsAsync() : Promise.resolve();
}
exports.importLegacyScriptsAsync = importLegacyScriptsAsync;
var sessionID;
function isSessionOutdated() {
    return pxt.storage.getLocal('pxt_workspace_session_id') != sessionID;
}
exports.isSessionOutdated = isSessionOutdated;
function checkSession() {
    if (isSessionOutdated()) {
        Util.assert(false, "trying to access outdated session");
    }
}
function initAsync() {
    if (!impl)
        impl = cloudworkspace.provider;
    // generate new workspace session id to avoid races with other tabs
    sessionID = Util.guidGen();
    pxt.storage.setLocal('pxt_workspace_session_id', sessionID);
    pxt.debug("workspace session: " + sessionID);
    return impl.initAsync(pxt.appTarget.id);
}
exports.initAsync = initAsync;
function getTextAsync(id) {
    checkSession();
    return impl.getTextAsync(id);
}
exports.getTextAsync = getTextAsync;
// https://github.com/Microsoft/pxt-backend/blob/master/docs/sharing.md#anonymous-publishing
function anonymousPublishAsync(h, text, meta) {
    var saveId = {};
    h.saveId = saveId;
    var stext = JSON.stringify(text, null, 2) + "\n";
    var scrReq = {
        name: h.name,
        target: h.target,
        description: meta.description,
        editor: h.editor,
        text: text,
        meta: {
            versions: pxt.appTarget.versions,
            blocksHeight: meta.blocksHeight,
            blocksWidth: meta.blocksWidth
        }
    };
    pxt.debug("publishing script; " + stext.length + " bytes");
    return Cloud.privatePostAsync("scripts", scrReq)
        .then(function (inf) {
        if (inf.shortid)
            inf.id = inf.shortid;
        h.pubId = inf.shortid;
        h.pubCurrent = h.saveId === saveId;
        h.meta = inf.meta;
        pxt.debug("published; id /" + h.pubId);
        return saveAsync(h)
            .then(function () { return inf; });
    });
}
exports.anonymousPublishAsync = anonymousPublishAsync;
function saveAsync(h, text) {
    checkSession();
    if (text || h.isDeleted) {
        h.pubCurrent = false;
        h.blobCurrent = false;
        h.modificationTime = U.nowSeconds();
    }
    h.recentUse = U.nowSeconds();
    return impl.saveAsync(h, text);
}
exports.saveAsync = saveAsync;
function installAsync(h0, text) {
    checkSession();
    return impl.installAsync(h0, text);
}
exports.installAsync = installAsync;
function saveScreenshotAsync(h, data, icon) {
    checkSession();
    return impl.saveScreenshotAsync
        ? impl.saveScreenshotAsync(h, data, icon)
        : Promise.resolve();
}
exports.saveScreenshotAsync = saveScreenshotAsync;
function fixupFileNames(txt) {
    if (!txt)
        return txt;
    for (var oldName in ["kind.json", "yelm.json"]) {
        if (!txt[pxt.CONFIG_NAME] && txt[oldName]) {
            txt[pxt.CONFIG_NAME] = txt[oldName];
            delete txt[oldName];
        }
    }
    return txt;
}
exports.fixupFileNames = fixupFileNames;
var scriptDlQ = new U.PromiseQueue();
//let scriptCache:any = {}
function getPublishedScriptAsync(id) {
    checkSession();
    //if (scriptCache.hasOwnProperty(id)) return Promise.resolve(scriptCache[id])
    if (pxt.github.isGithubId(id))
        id = pxt.github.noramlizeRepoId(id);
    var eid = encodeURIComponent(id);
    return pxt.packagesConfigAsync()
        .then(function (config) { return scriptDlQ.enqueue(id, function () { return scripts.getAsync(eid)
        .then(function (v) { return v.files; }, function (e) {
        return (pxt.github.isGithubId(id) ?
            pxt.github.downloadPackageAsync(id, config).then(function (v) { return v.files; }) :
            Cloud.downloadScriptFilesAsync(id))
            .catch(core.handleNetworkError)
            .then(function (files) { return scripts.setAsync({ id: eid, files: files })
            .then(function () {
            //return (scriptCache[id] = files)
            return files;
        }); });
    })
        .then(fixupFileNames); }); });
}
exports.getPublishedScriptAsync = getPublishedScriptAsync;
function installByIdAsync(id) {
    return Cloud.privateGetAsync(id)
        .then(function (scr) {
        return getPublishedScriptAsync(scr.id)
            .then(function (files) { return installAsync({
            name: scr.name,
            pubId: id,
            pubCurrent: true,
            meta: scr.meta,
            editor: scr.editor,
            target: scr.target,
        }, files); });
    });
}
exports.installByIdAsync = installByIdAsync;
function saveToCloudAsync(h) {
    checkSession();
    return impl.saveToCloudAsync(h);
}
exports.saveToCloudAsync = saveToCloudAsync;
function syncAsync() {
    checkSession();
    return impl.syncAsync();
}
exports.syncAsync = syncAsync;
function resetAsync() {
    checkSession();
    return impl.resetAsync();
}
exports.resetAsync = resetAsync;
/*
    header:<guid>   - one header
    header:*        - all headers
*/
data.mountVirtualApi("header", {
    getSync: function (p) {
        p = data.stripProtocol(p);
        if (p == "*")
            return getHeaders();
        return getHeader(p);
    },
});
/*
    text:<guid>            - all files
    text:<guid>/<filename> - one file
*/
data.mountVirtualApi("text", {
    getAsync: function (p) {
        var m = /^[\w\-]+:([^\/]+)(\/(.*))?/.exec(p);
        return getTextAsync(m[1])
            .then(function (files) {
            if (m[3])
                return files[m[3]];
            else
                return files;
        });
    },
});

},{"./cloudworkspace":6,"./core":11,"./data":12,"./db":13,"./fileworkspace":18,"./iframeworkspace":21,"./memoryworkspace":25}],42:[function(require,module,exports){
'use strict';

module.exports = argsArray;

function argsArray(fun) {
  return function () {
    var len = arguments.length;
    if (len) {
      var args = [];
      var i = -1;
      while (++i < len) {
        args[i] = arguments[i];
      }
      return fun.call(this, args);
    } else {
      return fun.call(this, []);
    }
  };
}
},{}],43:[function(require,module,exports){
'use strict'

exports.byteLength = byteLength
exports.toByteArray = toByteArray
exports.fromByteArray = fromByteArray

var lookup = []
var revLookup = []
var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array

var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
for (var i = 0, len = code.length; i < len; ++i) {
  lookup[i] = code[i]
  revLookup[code.charCodeAt(i)] = i
}

// Support decoding URL-safe base64 strings, as Node.js does.
// See: https://en.wikipedia.org/wiki/Base64#URL_applications
revLookup['-'.charCodeAt(0)] = 62
revLookup['_'.charCodeAt(0)] = 63

function getLens (b64) {
  var len = b64.length

  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4')
  }

  // Trim off extra bytes after placeholder bytes are found
  // See: https://github.com/beatgammit/base64-js/issues/42
  var validLen = b64.indexOf('=')
  if (validLen === -1) validLen = len

  var placeHoldersLen = validLen === len
    ? 0
    : 4 - (validLen % 4)

  return [validLen, placeHoldersLen]
}

// base64 is 4/3 + up to two characters of the original data
function byteLength (b64) {
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function _byteLength (b64, validLen, placeHoldersLen) {
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function toByteArray (b64) {
  var tmp
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]

  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen))

  var curByte = 0

  // if there are placeholders, only get up to the last complete 4 chars
  var len = placeHoldersLen > 0
    ? validLen - 4
    : validLen

  for (var i = 0; i < len; i += 4) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 18) |
      (revLookup[b64.charCodeAt(i + 1)] << 12) |
      (revLookup[b64.charCodeAt(i + 2)] << 6) |
      revLookup[b64.charCodeAt(i + 3)]
    arr[curByte++] = (tmp >> 16) & 0xFF
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 2) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 2) |
      (revLookup[b64.charCodeAt(i + 1)] >> 4)
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 1) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 10) |
      (revLookup[b64.charCodeAt(i + 1)] << 4) |
      (revLookup[b64.charCodeAt(i + 2)] >> 2)
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  return arr
}

function tripletToBase64 (num) {
  return lookup[num >> 18 & 0x3F] +
    lookup[num >> 12 & 0x3F] +
    lookup[num >> 6 & 0x3F] +
    lookup[num & 0x3F]
}

function encodeChunk (uint8, start, end) {
  var tmp
  var output = []
  for (var i = start; i < end; i += 3) {
    tmp =
      ((uint8[i] << 16) & 0xFF0000) +
      ((uint8[i + 1] << 8) & 0xFF00) +
      (uint8[i + 2] & 0xFF)
    output.push(tripletToBase64(tmp))
  }
  return output.join('')
}

function fromByteArray (uint8) {
  var tmp
  var len = uint8.length
  var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes
  var parts = []
  var maxChunkLength = 16383 // must be multiple of 3

  // go through the array every three bytes, we'll deal with trailing stuff later
  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(
      uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)
    ))
  }

  // pad the end with zeros, but make sure to not forget the extra bytes
  if (extraBytes === 1) {
    tmp = uint8[len - 1]
    parts.push(
      lookup[tmp >> 2] +
      lookup[(tmp << 4) & 0x3F] +
      '=='
    )
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + uint8[len - 1]
    parts.push(
      lookup[tmp >> 10] +
      lookup[(tmp >> 4) & 0x3F] +
      lookup[(tmp << 2) & 0x3F] +
      '='
    )
  }

  return parts.join('')
}

},{}],44:[function(require,module,exports){
(function (process,global,setImmediate){
/* @preserve
 * The MIT License (MIT)
 * 
 * Copyright (c) 2013-2017 Petka Antonov
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 */
/**
 * bluebird build version 3.5.1
 * Features enabled: core, race, call_get, generators, map, nodeify, promisify, props, reduce, settle, some, using, timers, filter, any, each
*/
!function(e){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=e();else if("function"==typeof define&&define.amd)define([],e);else{var f;"undefined"!=typeof window?f=window:"undefined"!=typeof global?f=global:"undefined"!=typeof self&&(f=self),f.Promise=e()}}(function(){var define,module,exports;return (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof _dereq_=="function"&&_dereq_;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof _dereq_=="function"&&_dereq_;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(_dereq_,module,exports){
"use strict";
module.exports = function(Promise) {
var SomePromiseArray = Promise._SomePromiseArray;
function any(promises) {
    var ret = new SomePromiseArray(promises);
    var promise = ret.promise();
    ret.setHowMany(1);
    ret.setUnwrap();
    ret.init();
    return promise;
}

Promise.any = function (promises) {
    return any(promises);
};

Promise.prototype.any = function () {
    return any(this);
};

};

},{}],2:[function(_dereq_,module,exports){
"use strict";
var firstLineError;
try {throw new Error(); } catch (e) {firstLineError = e;}
var schedule = _dereq_("./schedule");
var Queue = _dereq_("./queue");
var util = _dereq_("./util");

function Async() {
    this._customScheduler = false;
    this._isTickUsed = false;
    this._lateQueue = new Queue(16);
    this._normalQueue = new Queue(16);
    this._haveDrainedQueues = false;
    this._trampolineEnabled = true;
    var self = this;
    this.drainQueues = function () {
        self._drainQueues();
    };
    this._schedule = schedule;
}

Async.prototype.setScheduler = function(fn) {
    var prev = this._schedule;
    this._schedule = fn;
    this._customScheduler = true;
    return prev;
};

Async.prototype.hasCustomScheduler = function() {
    return this._customScheduler;
};

Async.prototype.enableTrampoline = function() {
    this._trampolineEnabled = true;
};

Async.prototype.disableTrampolineIfNecessary = function() {
    if (util.hasDevTools) {
        this._trampolineEnabled = false;
    }
};

Async.prototype.haveItemsQueued = function () {
    return this._isTickUsed || this._haveDrainedQueues;
};


Async.prototype.fatalError = function(e, isNode) {
    if (isNode) {
        process.stderr.write("Fatal " + (e instanceof Error ? e.stack : e) +
            "\n");
        process.exit(2);
    } else {
        this.throwLater(e);
    }
};

Async.prototype.throwLater = function(fn, arg) {
    if (arguments.length === 1) {
        arg = fn;
        fn = function () { throw arg; };
    }
    if (typeof setTimeout !== "undefined") {
        setTimeout(function() {
            fn(arg);
        }, 0);
    } else try {
        this._schedule(function() {
            fn(arg);
        });
    } catch (e) {
        throw new Error("No async scheduler available\u000a\u000a    See http://goo.gl/MqrFmX\u000a");
    }
};

function AsyncInvokeLater(fn, receiver, arg) {
    this._lateQueue.push(fn, receiver, arg);
    this._queueTick();
}

function AsyncInvoke(fn, receiver, arg) {
    this._normalQueue.push(fn, receiver, arg);
    this._queueTick();
}

function AsyncSettlePromises(promise) {
    this._normalQueue._pushOne(promise);
    this._queueTick();
}

if (!util.hasDevTools) {
    Async.prototype.invokeLater = AsyncInvokeLater;
    Async.prototype.invoke = AsyncInvoke;
    Async.prototype.settlePromises = AsyncSettlePromises;
} else {
    Async.prototype.invokeLater = function (fn, receiver, arg) {
        if (this._trampolineEnabled) {
            AsyncInvokeLater.call(this, fn, receiver, arg);
        } else {
            this._schedule(function() {
                setTimeout(function() {
                    fn.call(receiver, arg);
                }, 100);
            });
        }
    };

    Async.prototype.invoke = function (fn, receiver, arg) {
        if (this._trampolineEnabled) {
            AsyncInvoke.call(this, fn, receiver, arg);
        } else {
            this._schedule(function() {
                fn.call(receiver, arg);
            });
        }
    };

    Async.prototype.settlePromises = function(promise) {
        if (this._trampolineEnabled) {
            AsyncSettlePromises.call(this, promise);
        } else {
            this._schedule(function() {
                promise._settlePromises();
            });
        }
    };
}

Async.prototype._drainQueue = function(queue) {
    while (queue.length() > 0) {
        var fn = queue.shift();
        if (typeof fn !== "function") {
            fn._settlePromises();
            continue;
        }
        var receiver = queue.shift();
        var arg = queue.shift();
        fn.call(receiver, arg);
    }
};

Async.prototype._drainQueues = function () {
    this._drainQueue(this._normalQueue);
    this._reset();
    this._haveDrainedQueues = true;
    this._drainQueue(this._lateQueue);
};

Async.prototype._queueTick = function () {
    if (!this._isTickUsed) {
        this._isTickUsed = true;
        this._schedule(this.drainQueues);
    }
};

Async.prototype._reset = function () {
    this._isTickUsed = false;
};

module.exports = Async;
module.exports.firstLineError = firstLineError;

},{"./queue":26,"./schedule":29,"./util":36}],3:[function(_dereq_,module,exports){
"use strict";
module.exports = function(Promise, INTERNAL, tryConvertToPromise, debug) {
var calledBind = false;
var rejectThis = function(_, e) {
    this._reject(e);
};

var targetRejected = function(e, context) {
    context.promiseRejectionQueued = true;
    context.bindingPromise._then(rejectThis, rejectThis, null, this, e);
};

var bindingResolved = function(thisArg, context) {
    if (((this._bitField & 50397184) === 0)) {
        this._resolveCallback(context.target);
    }
};

var bindingRejected = function(e, context) {
    if (!context.promiseRejectionQueued) this._reject(e);
};

Promise.prototype.bind = function (thisArg) {
    if (!calledBind) {
        calledBind = true;
        Promise.prototype._propagateFrom = debug.propagateFromFunction();
        Promise.prototype._boundValue = debug.boundValueFunction();
    }
    var maybePromise = tryConvertToPromise(thisArg);
    var ret = new Promise(INTERNAL);
    ret._propagateFrom(this, 1);
    var target = this._target();
    ret._setBoundTo(maybePromise);
    if (maybePromise instanceof Promise) {
        var context = {
            promiseRejectionQueued: false,
            promise: ret,
            target: target,
            bindingPromise: maybePromise
        };
        target._then(INTERNAL, targetRejected, undefined, ret, context);
        maybePromise._then(
            bindingResolved, bindingRejected, undefined, ret, context);
        ret._setOnCancel(maybePromise);
    } else {
        ret._resolveCallback(target);
    }
    return ret;
};

Promise.prototype._setBoundTo = function (obj) {
    if (obj !== undefined) {
        this._bitField = this._bitField | 2097152;
        this._boundTo = obj;
    } else {
        this._bitField = this._bitField & (~2097152);
    }
};

Promise.prototype._isBound = function () {
    return (this._bitField & 2097152) === 2097152;
};

Promise.bind = function (thisArg, value) {
    return Promise.resolve(value).bind(thisArg);
};
};

},{}],4:[function(_dereq_,module,exports){
"use strict";
var old;
if (typeof Promise !== "undefined") old = Promise;
function noConflict() {
    try { if (Promise === bluebird) Promise = old; }
    catch (e) {}
    return bluebird;
}
var bluebird = _dereq_("./promise")();
bluebird.noConflict = noConflict;
module.exports = bluebird;

},{"./promise":22}],5:[function(_dereq_,module,exports){
"use strict";
var cr = Object.create;
if (cr) {
    var callerCache = cr(null);
    var getterCache = cr(null);
    callerCache[" size"] = getterCache[" size"] = 0;
}

module.exports = function(Promise) {
var util = _dereq_("./util");
var canEvaluate = util.canEvaluate;
var isIdentifier = util.isIdentifier;

var getMethodCaller;
var getGetter;
if (!true) {
var makeMethodCaller = function (methodName) {
    return new Function("ensureMethod", "                                    \n\
        return function(obj) {                                               \n\
            'use strict'                                                     \n\
            var len = this.length;                                           \n\
            ensureMethod(obj, 'methodName');                                 \n\
            switch(len) {                                                    \n\
                case 1: return obj.methodName(this[0]);                      \n\
                case 2: return obj.methodName(this[0], this[1]);             \n\
                case 3: return obj.methodName(this[0], this[1], this[2]);    \n\
                case 0: return obj.methodName();                             \n\
                default:                                                     \n\
                    return obj.methodName.apply(obj, this);                  \n\
            }                                                                \n\
        };                                                                   \n\
        ".replace(/methodName/g, methodName))(ensureMethod);
};

var makeGetter = function (propertyName) {
    return new Function("obj", "                                             \n\
        'use strict';                                                        \n\
        return obj.propertyName;                                             \n\
        ".replace("propertyName", propertyName));
};

var getCompiled = function(name, compiler, cache) {
    var ret = cache[name];
    if (typeof ret !== "function") {
        if (!isIdentifier(name)) {
            return null;
        }
        ret = compiler(name);
        cache[name] = ret;
        cache[" size"]++;
        if (cache[" size"] > 512) {
            var keys = Object.keys(cache);
            for (var i = 0; i < 256; ++i) delete cache[keys[i]];
            cache[" size"] = keys.length - 256;
        }
    }
    return ret;
};

getMethodCaller = function(name) {
    return getCompiled(name, makeMethodCaller, callerCache);
};

getGetter = function(name) {
    return getCompiled(name, makeGetter, getterCache);
};
}

function ensureMethod(obj, methodName) {
    var fn;
    if (obj != null) fn = obj[methodName];
    if (typeof fn !== "function") {
        var message = "Object " + util.classString(obj) + " has no method '" +
            util.toString(methodName) + "'";
        throw new Promise.TypeError(message);
    }
    return fn;
}

function caller(obj) {
    var methodName = this.pop();
    var fn = ensureMethod(obj, methodName);
    return fn.apply(obj, this);
}
Promise.prototype.call = function (methodName) {
    var args = [].slice.call(arguments, 1);;
    if (!true) {
        if (canEvaluate) {
            var maybeCaller = getMethodCaller(methodName);
            if (maybeCaller !== null) {
                return this._then(
                    maybeCaller, undefined, undefined, args, undefined);
            }
        }
    }
    args.push(methodName);
    return this._then(caller, undefined, undefined, args, undefined);
};

function namedGetter(obj) {
    return obj[this];
}
function indexedGetter(obj) {
    var index = +this;
    if (index < 0) index = Math.max(0, index + obj.length);
    return obj[index];
}
Promise.prototype.get = function (propertyName) {
    var isIndex = (typeof propertyName === "number");
    var getter;
    if (!isIndex) {
        if (canEvaluate) {
            var maybeGetter = getGetter(propertyName);
            getter = maybeGetter !== null ? maybeGetter : namedGetter;
        } else {
            getter = namedGetter;
        }
    } else {
        getter = indexedGetter;
    }
    return this._then(getter, undefined, undefined, propertyName, undefined);
};
};

},{"./util":36}],6:[function(_dereq_,module,exports){
"use strict";
module.exports = function(Promise, PromiseArray, apiRejection, debug) {
var util = _dereq_("./util");
var tryCatch = util.tryCatch;
var errorObj = util.errorObj;
var async = Promise._async;

Promise.prototype["break"] = Promise.prototype.cancel = function() {
    if (!debug.cancellation()) return this._warn("cancellation is disabled");

    var promise = this;
    var child = promise;
    while (promise._isCancellable()) {
        if (!promise._cancelBy(child)) {
            if (child._isFollowing()) {
                child._followee().cancel();
            } else {
                child._cancelBranched();
            }
            break;
        }

        var parent = promise._cancellationParent;
        if (parent == null || !parent._isCancellable()) {
            if (promise._isFollowing()) {
                promise._followee().cancel();
            } else {
                promise._cancelBranched();
            }
            break;
        } else {
            if (promise._isFollowing()) promise._followee().cancel();
            promise._setWillBeCancelled();
            child = promise;
            promise = parent;
        }
    }
};

Promise.prototype._branchHasCancelled = function() {
    this._branchesRemainingToCancel--;
};

Promise.prototype._enoughBranchesHaveCancelled = function() {
    return this._branchesRemainingToCancel === undefined ||
           this._branchesRemainingToCancel <= 0;
};

Promise.prototype._cancelBy = function(canceller) {
    if (canceller === this) {
        this._branchesRemainingToCancel = 0;
        this._invokeOnCancel();
        return true;
    } else {
        this._branchHasCancelled();
        if (this._enoughBranchesHaveCancelled()) {
            this._invokeOnCancel();
            return true;
        }
    }
    return false;
};

Promise.prototype._cancelBranched = function() {
    if (this._enoughBranchesHaveCancelled()) {
        this._cancel();
    }
};

Promise.prototype._cancel = function() {
    if (!this._isCancellable()) return;
    this._setCancelled();
    async.invoke(this._cancelPromises, this, undefined);
};

Promise.prototype._cancelPromises = function() {
    if (this._length() > 0) this._settlePromises();
};

Promise.prototype._unsetOnCancel = function() {
    this._onCancelField = undefined;
};

Promise.prototype._isCancellable = function() {
    return this.isPending() && !this._isCancelled();
};

Promise.prototype.isCancellable = function() {
    return this.isPending() && !this.isCancelled();
};

Promise.prototype._doInvokeOnCancel = function(onCancelCallback, internalOnly) {
    if (util.isArray(onCancelCallback)) {
        for (var i = 0; i < onCancelCallback.length; ++i) {
            this._doInvokeOnCancel(onCancelCallback[i], internalOnly);
        }
    } else if (onCancelCallback !== undefined) {
        if (typeof onCancelCallback === "function") {
            if (!internalOnly) {
                var e = tryCatch(onCancelCallback).call(this._boundValue());
                if (e === errorObj) {
                    this._attachExtraTrace(e.e);
                    async.throwLater(e.e);
                }
            }
        } else {
            onCancelCallback._resultCancelled(this);
        }
    }
};

Promise.prototype._invokeOnCancel = function() {
    var onCancelCallback = this._onCancel();
    this._unsetOnCancel();
    async.invoke(this._doInvokeOnCancel, this, onCancelCallback);
};

Promise.prototype._invokeInternalOnCancel = function() {
    if (this._isCancellable()) {
        this._doInvokeOnCancel(this._onCancel(), true);
        this._unsetOnCancel();
    }
};

Promise.prototype._resultCancelled = function() {
    this.cancel();
};

};

},{"./util":36}],7:[function(_dereq_,module,exports){
"use strict";
module.exports = function(NEXT_FILTER) {
var util = _dereq_("./util");
var getKeys = _dereq_("./es5").keys;
var tryCatch = util.tryCatch;
var errorObj = util.errorObj;

function catchFilter(instances, cb, promise) {
    return function(e) {
        var boundTo = promise._boundValue();
        predicateLoop: for (var i = 0; i < instances.length; ++i) {
            var item = instances[i];

            if (item === Error ||
                (item != null && item.prototype instanceof Error)) {
                if (e instanceof item) {
                    return tryCatch(cb).call(boundTo, e);
                }
            } else if (typeof item === "function") {
                var matchesPredicate = tryCatch(item).call(boundTo, e);
                if (matchesPredicate === errorObj) {
                    return matchesPredicate;
                } else if (matchesPredicate) {
                    return tryCatch(cb).call(boundTo, e);
                }
            } else if (util.isObject(e)) {
                var keys = getKeys(item);
                for (var j = 0; j < keys.length; ++j) {
                    var key = keys[j];
                    if (item[key] != e[key]) {
                        continue predicateLoop;
                    }
                }
                return tryCatch(cb).call(boundTo, e);
            }
        }
        return NEXT_FILTER;
    };
}

return catchFilter;
};

},{"./es5":13,"./util":36}],8:[function(_dereq_,module,exports){
"use strict";
module.exports = function(Promise) {
var longStackTraces = false;
var contextStack = [];

Promise.prototype._promiseCreated = function() {};
Promise.prototype._pushContext = function() {};
Promise.prototype._popContext = function() {return null;};
Promise._peekContext = Promise.prototype._peekContext = function() {};

function Context() {
    this._trace = new Context.CapturedTrace(peekContext());
}
Context.prototype._pushContext = function () {
    if (this._trace !== undefined) {
        this._trace._promiseCreated = null;
        contextStack.push(this._trace);
    }
};

Context.prototype._popContext = function () {
    if (this._trace !== undefined) {
        var trace = contextStack.pop();
        var ret = trace._promiseCreated;
        trace._promiseCreated = null;
        return ret;
    }
    return null;
};

function createContext() {
    if (longStackTraces) return new Context();
}

function peekContext() {
    var lastIndex = contextStack.length - 1;
    if (lastIndex >= 0) {
        return contextStack[lastIndex];
    }
    return undefined;
}
Context.CapturedTrace = null;
Context.create = createContext;
Context.deactivateLongStackTraces = function() {};
Context.activateLongStackTraces = function() {
    var Promise_pushContext = Promise.prototype._pushContext;
    var Promise_popContext = Promise.prototype._popContext;
    var Promise_PeekContext = Promise._peekContext;
    var Promise_peekContext = Promise.prototype._peekContext;
    var Promise_promiseCreated = Promise.prototype._promiseCreated;
    Context.deactivateLongStackTraces = function() {
        Promise.prototype._pushContext = Promise_pushContext;
        Promise.prototype._popContext = Promise_popContext;
        Promise._peekContext = Promise_PeekContext;
        Promise.prototype._peekContext = Promise_peekContext;
        Promise.prototype._promiseCreated = Promise_promiseCreated;
        longStackTraces = false;
    };
    longStackTraces = true;
    Promise.prototype._pushContext = Context.prototype._pushContext;
    Promise.prototype._popContext = Context.prototype._popContext;
    Promise._peekContext = Promise.prototype._peekContext = peekContext;
    Promise.prototype._promiseCreated = function() {
        var ctx = this._peekContext();
        if (ctx && ctx._promiseCreated == null) ctx._promiseCreated = this;
    };
};
return Context;
};

},{}],9:[function(_dereq_,module,exports){
"use strict";
module.exports = function(Promise, Context) {
var getDomain = Promise._getDomain;
var async = Promise._async;
var Warning = _dereq_("./errors").Warning;
var util = _dereq_("./util");
var canAttachTrace = util.canAttachTrace;
var unhandledRejectionHandled;
var possiblyUnhandledRejection;
var bluebirdFramePattern =
    /[\\\/]bluebird[\\\/]js[\\\/](release|debug|instrumented)/;
var nodeFramePattern = /\((?:timers\.js):\d+:\d+\)/;
var parseLinePattern = /[\/<\(](.+?):(\d+):(\d+)\)?\s*$/;
var stackFramePattern = null;
var formatStack = null;
var indentStackFrames = false;
var printWarning;
var debugging = !!(util.env("BLUEBIRD_DEBUG") != 0 &&
                        (true ||
                         util.env("BLUEBIRD_DEBUG") ||
                         util.env("NODE_ENV") === "development"));

var warnings = !!(util.env("BLUEBIRD_WARNINGS") != 0 &&
    (debugging || util.env("BLUEBIRD_WARNINGS")));

var longStackTraces = !!(util.env("BLUEBIRD_LONG_STACK_TRACES") != 0 &&
    (debugging || util.env("BLUEBIRD_LONG_STACK_TRACES")));

var wForgottenReturn = util.env("BLUEBIRD_W_FORGOTTEN_RETURN") != 0 &&
    (warnings || !!util.env("BLUEBIRD_W_FORGOTTEN_RETURN"));

Promise.prototype.suppressUnhandledRejections = function() {
    var target = this._target();
    target._bitField = ((target._bitField & (~1048576)) |
                      524288);
};

Promise.prototype._ensurePossibleRejectionHandled = function () {
    if ((this._bitField & 524288) !== 0) return;
    this._setRejectionIsUnhandled();
    var self = this;
    setTimeout(function() {
        self._notifyUnhandledRejection();
    }, 1);
};

Promise.prototype._notifyUnhandledRejectionIsHandled = function () {
    fireRejectionEvent("rejectionHandled",
                                  unhandledRejectionHandled, undefined, this);
};

Promise.prototype._setReturnedNonUndefined = function() {
    this._bitField = this._bitField | 268435456;
};

Promise.prototype._returnedNonUndefined = function() {
    return (this._bitField & 268435456) !== 0;
};

Promise.prototype._notifyUnhandledRejection = function () {
    if (this._isRejectionUnhandled()) {
        var reason = this._settledValue();
        this._setUnhandledRejectionIsNotified();
        fireRejectionEvent("unhandledRejection",
                                      possiblyUnhandledRejection, reason, this);
    }
};

Promise.prototype._setUnhandledRejectionIsNotified = function () {
    this._bitField = this._bitField | 262144;
};

Promise.prototype._unsetUnhandledRejectionIsNotified = function () {
    this._bitField = this._bitField & (~262144);
};

Promise.prototype._isUnhandledRejectionNotified = function () {
    return (this._bitField & 262144) > 0;
};

Promise.prototype._setRejectionIsUnhandled = function () {
    this._bitField = this._bitField | 1048576;
};

Promise.prototype._unsetRejectionIsUnhandled = function () {
    this._bitField = this._bitField & (~1048576);
    if (this._isUnhandledRejectionNotified()) {
        this._unsetUnhandledRejectionIsNotified();
        this._notifyUnhandledRejectionIsHandled();
    }
};

Promise.prototype._isRejectionUnhandled = function () {
    return (this._bitField & 1048576) > 0;
};

Promise.prototype._warn = function(message, shouldUseOwnTrace, promise) {
    return warn(message, shouldUseOwnTrace, promise || this);
};

Promise.onPossiblyUnhandledRejection = function (fn) {
    var domain = getDomain();
    possiblyUnhandledRejection =
        typeof fn === "function" ? (domain === null ?
                                            fn : util.domainBind(domain, fn))
                                 : undefined;
};

Promise.onUnhandledRejectionHandled = function (fn) {
    var domain = getDomain();
    unhandledRejectionHandled =
        typeof fn === "function" ? (domain === null ?
                                            fn : util.domainBind(domain, fn))
                                 : undefined;
};

var disableLongStackTraces = function() {};
Promise.longStackTraces = function () {
    if (async.haveItemsQueued() && !config.longStackTraces) {
        throw new Error("cannot enable long stack traces after promises have been created\u000a\u000a    See http://goo.gl/MqrFmX\u000a");
    }
    if (!config.longStackTraces && longStackTracesIsSupported()) {
        var Promise_captureStackTrace = Promise.prototype._captureStackTrace;
        var Promise_attachExtraTrace = Promise.prototype._attachExtraTrace;
        config.longStackTraces = true;
        disableLongStackTraces = function() {
            if (async.haveItemsQueued() && !config.longStackTraces) {
                throw new Error("cannot enable long stack traces after promises have been created\u000a\u000a    See http://goo.gl/MqrFmX\u000a");
            }
            Promise.prototype._captureStackTrace = Promise_captureStackTrace;
            Promise.prototype._attachExtraTrace = Promise_attachExtraTrace;
            Context.deactivateLongStackTraces();
            async.enableTrampoline();
            config.longStackTraces = false;
        };
        Promise.prototype._captureStackTrace = longStackTracesCaptureStackTrace;
        Promise.prototype._attachExtraTrace = longStackTracesAttachExtraTrace;
        Context.activateLongStackTraces();
        async.disableTrampolineIfNecessary();
    }
};

Promise.hasLongStackTraces = function () {
    return config.longStackTraces && longStackTracesIsSupported();
};

var fireDomEvent = (function() {
    try {
        if (typeof CustomEvent === "function") {
            var event = new CustomEvent("CustomEvent");
            util.global.dispatchEvent(event);
            return function(name, event) {
                var domEvent = new CustomEvent(name.toLowerCase(), {
                    detail: event,
                    cancelable: true
                });
                return !util.global.dispatchEvent(domEvent);
            };
        } else if (typeof Event === "function") {
            var event = new Event("CustomEvent");
            util.global.dispatchEvent(event);
            return function(name, event) {
                var domEvent = new Event(name.toLowerCase(), {
                    cancelable: true
                });
                domEvent.detail = event;
                return !util.global.dispatchEvent(domEvent);
            };
        } else {
            var event = document.createEvent("CustomEvent");
            event.initCustomEvent("testingtheevent", false, true, {});
            util.global.dispatchEvent(event);
            return function(name, event) {
                var domEvent = document.createEvent("CustomEvent");
                domEvent.initCustomEvent(name.toLowerCase(), false, true,
                    event);
                return !util.global.dispatchEvent(domEvent);
            };
        }
    } catch (e) {}
    return function() {
        return false;
    };
})();

var fireGlobalEvent = (function() {
    if (util.isNode) {
        return function() {
            return process.emit.apply(process, arguments);
        };
    } else {
        if (!util.global) {
            return function() {
                return false;
            };
        }
        return function(name) {
            var methodName = "on" + name.toLowerCase();
            var method = util.global[methodName];
            if (!method) return false;
            method.apply(util.global, [].slice.call(arguments, 1));
            return true;
        };
    }
})();

function generatePromiseLifecycleEventObject(name, promise) {
    return {promise: promise};
}

var eventToObjectGenerator = {
    promiseCreated: generatePromiseLifecycleEventObject,
    promiseFulfilled: generatePromiseLifecycleEventObject,
    promiseRejected: generatePromiseLifecycleEventObject,
    promiseResolved: generatePromiseLifecycleEventObject,
    promiseCancelled: generatePromiseLifecycleEventObject,
    promiseChained: function(name, promise, child) {
        return {promise: promise, child: child};
    },
    warning: function(name, warning) {
        return {warning: warning};
    },
    unhandledRejection: function (name, reason, promise) {
        return {reason: reason, promise: promise};
    },
    rejectionHandled: generatePromiseLifecycleEventObject
};

var activeFireEvent = function (name) {
    var globalEventFired = false;
    try {
        globalEventFired = fireGlobalEvent.apply(null, arguments);
    } catch (e) {
        async.throwLater(e);
        globalEventFired = true;
    }

    var domEventFired = false;
    try {
        domEventFired = fireDomEvent(name,
                    eventToObjectGenerator[name].apply(null, arguments));
    } catch (e) {
        async.throwLater(e);
        domEventFired = true;
    }

    return domEventFired || globalEventFired;
};

Promise.config = function(opts) {
    opts = Object(opts);
    if ("longStackTraces" in opts) {
        if (opts.longStackTraces) {
            Promise.longStackTraces();
        } else if (!opts.longStackTraces && Promise.hasLongStackTraces()) {
            disableLongStackTraces();
        }
    }
    if ("warnings" in opts) {
        var warningsOption = opts.warnings;
        config.warnings = !!warningsOption;
        wForgottenReturn = config.warnings;

        if (util.isObject(warningsOption)) {
            if ("wForgottenReturn" in warningsOption) {
                wForgottenReturn = !!warningsOption.wForgottenReturn;
            }
        }
    }
    if ("cancellation" in opts && opts.cancellation && !config.cancellation) {
        if (async.haveItemsQueued()) {
            throw new Error(
                "cannot enable cancellation after promises are in use");
        }
        Promise.prototype._clearCancellationData =
            cancellationClearCancellationData;
        Promise.prototype._propagateFrom = cancellationPropagateFrom;
        Promise.prototype._onCancel = cancellationOnCancel;
        Promise.prototype._setOnCancel = cancellationSetOnCancel;
        Promise.prototype._attachCancellationCallback =
            cancellationAttachCancellationCallback;
        Promise.prototype._execute = cancellationExecute;
        propagateFromFunction = cancellationPropagateFrom;
        config.cancellation = true;
    }
    if ("monitoring" in opts) {
        if (opts.monitoring && !config.monitoring) {
            config.monitoring = true;
            Promise.prototype._fireEvent = activeFireEvent;
        } else if (!opts.monitoring && config.monitoring) {
            config.monitoring = false;
            Promise.prototype._fireEvent = defaultFireEvent;
        }
    }
    return Promise;
};

function defaultFireEvent() { return false; }

Promise.prototype._fireEvent = defaultFireEvent;
Promise.prototype._execute = function(executor, resolve, reject) {
    try {
        executor(resolve, reject);
    } catch (e) {
        return e;
    }
};
Promise.prototype._onCancel = function () {};
Promise.prototype._setOnCancel = function (handler) { ; };
Promise.prototype._attachCancellationCallback = function(onCancel) {
    ;
};
Promise.prototype._captureStackTrace = function () {};
Promise.prototype._attachExtraTrace = function () {};
Promise.prototype._clearCancellationData = function() {};
Promise.prototype._propagateFrom = function (parent, flags) {
    ;
    ;
};

function cancellationExecute(executor, resolve, reject) {
    var promise = this;
    try {
        executor(resolve, reject, function(onCancel) {
            if (typeof onCancel !== "function") {
                throw new TypeError("onCancel must be a function, got: " +
                                    util.toString(onCancel));
            }
            promise._attachCancellationCallback(onCancel);
        });
    } catch (e) {
        return e;
    }
}

function cancellationAttachCancellationCallback(onCancel) {
    if (!this._isCancellable()) return this;

    var previousOnCancel = this._onCancel();
    if (previousOnCancel !== undefined) {
        if (util.isArray(previousOnCancel)) {
            previousOnCancel.push(onCancel);
        } else {
            this._setOnCancel([previousOnCancel, onCancel]);
        }
    } else {
        this._setOnCancel(onCancel);
    }
}

function cancellationOnCancel() {
    return this._onCancelField;
}

function cancellationSetOnCancel(onCancel) {
    this._onCancelField = onCancel;
}

function cancellationClearCancellationData() {
    this._cancellationParent = undefined;
    this._onCancelField = undefined;
}

function cancellationPropagateFrom(parent, flags) {
    if ((flags & 1) !== 0) {
        this._cancellationParent = parent;
        var branchesRemainingToCancel = parent._branchesRemainingToCancel;
        if (branchesRemainingToCancel === undefined) {
            branchesRemainingToCancel = 0;
        }
        parent._branchesRemainingToCancel = branchesRemainingToCancel + 1;
    }
    if ((flags & 2) !== 0 && parent._isBound()) {
        this._setBoundTo(parent._boundTo);
    }
}

function bindingPropagateFrom(parent, flags) {
    if ((flags & 2) !== 0 && parent._isBound()) {
        this._setBoundTo(parent._boundTo);
    }
}
var propagateFromFunction = bindingPropagateFrom;

function boundValueFunction() {
    var ret = this._boundTo;
    if (ret !== undefined) {
        if (ret instanceof Promise) {
            if (ret.isFulfilled()) {
                return ret.value();
            } else {
                return undefined;
            }
        }
    }
    return ret;
}

function longStackTracesCaptureStackTrace() {
    this._trace = new CapturedTrace(this._peekContext());
}

function longStackTracesAttachExtraTrace(error, ignoreSelf) {
    if (canAttachTrace(error)) {
        var trace = this._trace;
        if (trace !== undefined) {
            if (ignoreSelf) trace = trace._parent;
        }
        if (trace !== undefined) {
            trace.attachExtraTrace(error);
        } else if (!error.__stackCleaned__) {
            var parsed = parseStackAndMessage(error);
            util.notEnumerableProp(error, "stack",
                parsed.message + "\n" + parsed.stack.join("\n"));
            util.notEnumerableProp(error, "__stackCleaned__", true);
        }
    }
}

function checkForgottenReturns(returnValue, promiseCreated, name, promise,
                               parent) {
    if (returnValue === undefined && promiseCreated !== null &&
        wForgottenReturn) {
        if (parent !== undefined && parent._returnedNonUndefined()) return;
        if ((promise._bitField & 65535) === 0) return;

        if (name) name = name + " ";
        var handlerLine = "";
        var creatorLine = "";
        if (promiseCreated._trace) {
            var traceLines = promiseCreated._trace.stack.split("\n");
            var stack = cleanStack(traceLines);
            for (var i = stack.length - 1; i >= 0; --i) {
                var line = stack[i];
                if (!nodeFramePattern.test(line)) {
                    var lineMatches = line.match(parseLinePattern);
                    if (lineMatches) {
                        handlerLine  = "at " + lineMatches[1] +
                            ":" + lineMatches[2] + ":" + lineMatches[3] + " ";
                    }
                    break;
                }
            }

            if (stack.length > 0) {
                var firstUserLine = stack[0];
                for (var i = 0; i < traceLines.length; ++i) {

                    if (traceLines[i] === firstUserLine) {
                        if (i > 0) {
                            creatorLine = "\n" + traceLines[i - 1];
                        }
                        break;
                    }
                }

            }
        }
        var msg = "a promise was created in a " + name +
            "handler " + handlerLine + "but was not returned from it, " +
            "see http://goo.gl/rRqMUw" +
            creatorLine;
        promise._warn(msg, true, promiseCreated);
    }
}

function deprecated(name, replacement) {
    var message = name +
        " is deprecated and will be removed in a future version.";
    if (replacement) message += " Use " + replacement + " instead.";
    return warn(message);
}

function warn(message, shouldUseOwnTrace, promise) {
    if (!config.warnings) return;
    var warning = new Warning(message);
    var ctx;
    if (shouldUseOwnTrace) {
        promise._attachExtraTrace(warning);
    } else if (config.longStackTraces && (ctx = Promise._peekContext())) {
        ctx.attachExtraTrace(warning);
    } else {
        var parsed = parseStackAndMessage(warning);
        warning.stack = parsed.message + "\n" + parsed.stack.join("\n");
    }

    if (!activeFireEvent("warning", warning)) {
        formatAndLogError(warning, "", true);
    }
}

function reconstructStack(message, stacks) {
    for (var i = 0; i < stacks.length - 1; ++i) {
        stacks[i].push("From previous event:");
        stacks[i] = stacks[i].join("\n");
    }
    if (i < stacks.length) {
        stacks[i] = stacks[i].join("\n");
    }
    return message + "\n" + stacks.join("\n");
}

function removeDuplicateOrEmptyJumps(stacks) {
    for (var i = 0; i < stacks.length; ++i) {
        if (stacks[i].length === 0 ||
            ((i + 1 < stacks.length) && stacks[i][0] === stacks[i+1][0])) {
            stacks.splice(i, 1);
            i--;
        }
    }
}

function removeCommonRoots(stacks) {
    var current = stacks[0];
    for (var i = 1; i < stacks.length; ++i) {
        var prev = stacks[i];
        var currentLastIndex = current.length - 1;
        var currentLastLine = current[currentLastIndex];
        var commonRootMeetPoint = -1;

        for (var j = prev.length - 1; j >= 0; --j) {
            if (prev[j] === currentLastLine) {
                commonRootMeetPoint = j;
                break;
            }
        }

        for (var j = commonRootMeetPoint; j >= 0; --j) {
            var line = prev[j];
            if (current[currentLastIndex] === line) {
                current.pop();
                currentLastIndex--;
            } else {
                break;
            }
        }
        current = prev;
    }
}

function cleanStack(stack) {
    var ret = [];
    for (var i = 0; i < stack.length; ++i) {
        var line = stack[i];
        var isTraceLine = "    (No stack trace)" === line ||
            stackFramePattern.test(line);
        var isInternalFrame = isTraceLine && shouldIgnore(line);
        if (isTraceLine && !isInternalFrame) {
            if (indentStackFrames && line.charAt(0) !== " ") {
                line = "    " + line;
            }
            ret.push(line);
        }
    }
    return ret;
}

function stackFramesAsArray(error) {
    var stack = error.stack.replace(/\s+$/g, "").split("\n");
    for (var i = 0; i < stack.length; ++i) {
        var line = stack[i];
        if ("    (No stack trace)" === line || stackFramePattern.test(line)) {
            break;
        }
    }
    if (i > 0 && error.name != "SyntaxError") {
        stack = stack.slice(i);
    }
    return stack;
}

function parseStackAndMessage(error) {
    var stack = error.stack;
    var message = error.toString();
    stack = typeof stack === "string" && stack.length > 0
                ? stackFramesAsArray(error) : ["    (No stack trace)"];
    return {
        message: message,
        stack: error.name == "SyntaxError" ? stack : cleanStack(stack)
    };
}

function formatAndLogError(error, title, isSoft) {
    if (typeof console !== "undefined") {
        var message;
        if (util.isObject(error)) {
            var stack = error.stack;
            message = title + formatStack(stack, error);
        } else {
            message = title + String(error);
        }
        if (typeof printWarning === "function") {
            printWarning(message, isSoft);
        } else if (typeof console.log === "function" ||
            typeof console.log === "object") {
            console.log(message);
        }
    }
}

function fireRejectionEvent(name, localHandler, reason, promise) {
    var localEventFired = false;
    try {
        if (typeof localHandler === "function") {
            localEventFired = true;
            if (name === "rejectionHandled") {
                localHandler(promise);
            } else {
                localHandler(reason, promise);
            }
        }
    } catch (e) {
        async.throwLater(e);
    }

    if (name === "unhandledRejection") {
        if (!activeFireEvent(name, reason, promise) && !localEventFired) {
            formatAndLogError(reason, "Unhandled rejection ");
        }
    } else {
        activeFireEvent(name, promise);
    }
}

function formatNonError(obj) {
    var str;
    if (typeof obj === "function") {
        str = "[function " +
            (obj.name || "anonymous") +
            "]";
    } else {
        str = obj && typeof obj.toString === "function"
            ? obj.toString() : util.toString(obj);
        var ruselessToString = /\[object [a-zA-Z0-9$_]+\]/;
        if (ruselessToString.test(str)) {
            try {
                var newStr = JSON.stringify(obj);
                str = newStr;
            }
            catch(e) {

            }
        }
        if (str.length === 0) {
            str = "(empty array)";
        }
    }
    return ("(<" + snip(str) + ">, no stack trace)");
}

function snip(str) {
    var maxChars = 41;
    if (str.length < maxChars) {
        return str;
    }
    return str.substr(0, maxChars - 3) + "...";
}

function longStackTracesIsSupported() {
    return typeof captureStackTrace === "function";
}

var shouldIgnore = function() { return false; };
var parseLineInfoRegex = /[\/<\(]([^:\/]+):(\d+):(?:\d+)\)?\s*$/;
function parseLineInfo(line) {
    var matches = line.match(parseLineInfoRegex);
    if (matches) {
        return {
            fileName: matches[1],
            line: parseInt(matches[2], 10)
        };
    }
}

function setBounds(firstLineError, lastLineError) {
    if (!longStackTracesIsSupported()) return;
    var firstStackLines = firstLineError.stack.split("\n");
    var lastStackLines = lastLineError.stack.split("\n");
    var firstIndex = -1;
    var lastIndex = -1;
    var firstFileName;
    var lastFileName;
    for (var i = 0; i < firstStackLines.length; ++i) {
        var result = parseLineInfo(firstStackLines[i]);
        if (result) {
            firstFileName = result.fileName;
            firstIndex = result.line;
            break;
        }
    }
    for (var i = 0; i < lastStackLines.length; ++i) {
        var result = parseLineInfo(lastStackLines[i]);
        if (result) {
            lastFileName = result.fileName;
            lastIndex = result.line;
            break;
        }
    }
    if (firstIndex < 0 || lastIndex < 0 || !firstFileName || !lastFileName ||
        firstFileName !== lastFileName || firstIndex >= lastIndex) {
        return;
    }

    shouldIgnore = function(line) {
        if (bluebirdFramePattern.test(line)) return true;
        var info = parseLineInfo(line);
        if (info) {
            if (info.fileName === firstFileName &&
                (firstIndex <= info.line && info.line <= lastIndex)) {
                return true;
            }
        }
        return false;
    };
}

function CapturedTrace(parent) {
    this._parent = parent;
    this._promisesCreated = 0;
    var length = this._length = 1 + (parent === undefined ? 0 : parent._length);
    captureStackTrace(this, CapturedTrace);
    if (length > 32) this.uncycle();
}
util.inherits(CapturedTrace, Error);
Context.CapturedTrace = CapturedTrace;

CapturedTrace.prototype.uncycle = function() {
    var length = this._length;
    if (length < 2) return;
    var nodes = [];
    var stackToIndex = {};

    for (var i = 0, node = this; node !== undefined; ++i) {
        nodes.push(node);
        node = node._parent;
    }
    length = this._length = i;
    for (var i = length - 1; i >= 0; --i) {
        var stack = nodes[i].stack;
        if (stackToIndex[stack] === undefined) {
            stackToIndex[stack] = i;
        }
    }
    for (var i = 0; i < length; ++i) {
        var currentStack = nodes[i].stack;
        var index = stackToIndex[currentStack];
        if (index !== undefined && index !== i) {
            if (index > 0) {
                nodes[index - 1]._parent = undefined;
                nodes[index - 1]._length = 1;
            }
            nodes[i]._parent = undefined;
            nodes[i]._length = 1;
            var cycleEdgeNode = i > 0 ? nodes[i - 1] : this;

            if (index < length - 1) {
                cycleEdgeNode._parent = nodes[index + 1];
                cycleEdgeNode._parent.uncycle();
                cycleEdgeNode._length =
                    cycleEdgeNode._parent._length + 1;
            } else {
                cycleEdgeNode._parent = undefined;
                cycleEdgeNode._length = 1;
            }
            var currentChildLength = cycleEdgeNode._length + 1;
            for (var j = i - 2; j >= 0; --j) {
                nodes[j]._length = currentChildLength;
                currentChildLength++;
            }
            return;
        }
    }
};

CapturedTrace.prototype.attachExtraTrace = function(error) {
    if (error.__stackCleaned__) return;
    this.uncycle();
    var parsed = parseStackAndMessage(error);
    var message = parsed.message;
    var stacks = [parsed.stack];

    var trace = this;
    while (trace !== undefined) {
        stacks.push(cleanStack(trace.stack.split("\n")));
        trace = trace._parent;
    }
    removeCommonRoots(stacks);
    removeDuplicateOrEmptyJumps(stacks);
    util.notEnumerableProp(error, "stack", reconstructStack(message, stacks));
    util.notEnumerableProp(error, "__stackCleaned__", true);
};

var captureStackTrace = (function stackDetection() {
    var v8stackFramePattern = /^\s*at\s*/;
    var v8stackFormatter = function(stack, error) {
        if (typeof stack === "string") return stack;

        if (error.name !== undefined &&
            error.message !== undefined) {
            return error.toString();
        }
        return formatNonError(error);
    };

    if (typeof Error.stackTraceLimit === "number" &&
        typeof Error.captureStackTrace === "function") {
        Error.stackTraceLimit += 6;
        stackFramePattern = v8stackFramePattern;
        formatStack = v8stackFormatter;
        var captureStackTrace = Error.captureStackTrace;

        shouldIgnore = function(line) {
            return bluebirdFramePattern.test(line);
        };
        return function(receiver, ignoreUntil) {
            Error.stackTraceLimit += 6;
            captureStackTrace(receiver, ignoreUntil);
            Error.stackTraceLimit -= 6;
        };
    }
    var err = new Error();

    if (typeof err.stack === "string" &&
        err.stack.split("\n")[0].indexOf("stackDetection@") >= 0) {
        stackFramePattern = /@/;
        formatStack = v8stackFormatter;
        indentStackFrames = true;
        return function captureStackTrace(o) {
            o.stack = new Error().stack;
        };
    }

    var hasStackAfterThrow;
    try { throw new Error(); }
    catch(e) {
        hasStackAfterThrow = ("stack" in e);
    }
    if (!("stack" in err) && hasStackAfterThrow &&
        typeof Error.stackTraceLimit === "number") {
        stackFramePattern = v8stackFramePattern;
        formatStack = v8stackFormatter;
        return function captureStackTrace(o) {
            Error.stackTraceLimit += 6;
            try { throw new Error(); }
            catch(e) { o.stack = e.stack; }
            Error.stackTraceLimit -= 6;
        };
    }

    formatStack = function(stack, error) {
        if (typeof stack === "string") return stack;

        if ((typeof error === "object" ||
            typeof error === "function") &&
            error.name !== undefined &&
            error.message !== undefined) {
            return error.toString();
        }
        return formatNonError(error);
    };

    return null;

})([]);

if (typeof console !== "undefined" && typeof console.warn !== "undefined") {
    printWarning = function (message) {
        console.warn(message);
    };
    if (util.isNode && process.stderr.isTTY) {
        printWarning = function(message, isSoft) {
            var color = isSoft ? "\u001b[33m" : "\u001b[31m";
            console.warn(color + message + "\u001b[0m\n");
        };
    } else if (!util.isNode && typeof (new Error().stack) === "string") {
        printWarning = function(message, isSoft) {
            console.warn("%c" + message,
                        isSoft ? "color: darkorange" : "color: red");
        };
    }
}

var config = {
    warnings: warnings,
    longStackTraces: false,
    cancellation: false,
    monitoring: false
};

if (longStackTraces) Promise.longStackTraces();

return {
    longStackTraces: function() {
        return config.longStackTraces;
    },
    warnings: function() {
        return config.warnings;
    },
    cancellation: function() {
        return config.cancellation;
    },
    monitoring: function() {
        return config.monitoring;
    },
    propagateFromFunction: function() {
        return propagateFromFunction;
    },
    boundValueFunction: function() {
        return boundValueFunction;
    },
    checkForgottenReturns: checkForgottenReturns,
    setBounds: setBounds,
    warn: warn,
    deprecated: deprecated,
    CapturedTrace: CapturedTrace,
    fireDomEvent: fireDomEvent,
    fireGlobalEvent: fireGlobalEvent
};
};

},{"./errors":12,"./util":36}],10:[function(_dereq_,module,exports){
"use strict";
module.exports = function(Promise) {
function returner() {
    return this.value;
}
function thrower() {
    throw this.reason;
}

Promise.prototype["return"] =
Promise.prototype.thenReturn = function (value) {
    if (value instanceof Promise) value.suppressUnhandledRejections();
    return this._then(
        returner, undefined, undefined, {value: value}, undefined);
};

Promise.prototype["throw"] =
Promise.prototype.thenThrow = function (reason) {
    return this._then(
        thrower, undefined, undefined, {reason: reason}, undefined);
};

Promise.prototype.catchThrow = function (reason) {
    if (arguments.length <= 1) {
        return this._then(
            undefined, thrower, undefined, {reason: reason}, undefined);
    } else {
        var _reason = arguments[1];
        var handler = function() {throw _reason;};
        return this.caught(reason, handler);
    }
};

Promise.prototype.catchReturn = function (value) {
    if (arguments.length <= 1) {
        if (value instanceof Promise) value.suppressUnhandledRejections();
        return this._then(
            undefined, returner, undefined, {value: value}, undefined);
    } else {
        var _value = arguments[1];
        if (_value instanceof Promise) _value.suppressUnhandledRejections();
        var handler = function() {return _value;};
        return this.caught(value, handler);
    }
};
};

},{}],11:[function(_dereq_,module,exports){
"use strict";
module.exports = function(Promise, INTERNAL) {
var PromiseReduce = Promise.reduce;
var PromiseAll = Promise.all;

function promiseAllThis() {
    return PromiseAll(this);
}

function PromiseMapSeries(promises, fn) {
    return PromiseReduce(promises, fn, INTERNAL, INTERNAL);
}

Promise.prototype.each = function (fn) {
    return PromiseReduce(this, fn, INTERNAL, 0)
              ._then(promiseAllThis, undefined, undefined, this, undefined);
};

Promise.prototype.mapSeries = function (fn) {
    return PromiseReduce(this, fn, INTERNAL, INTERNAL);
};

Promise.each = function (promises, fn) {
    return PromiseReduce(promises, fn, INTERNAL, 0)
              ._then(promiseAllThis, undefined, undefined, promises, undefined);
};

Promise.mapSeries = PromiseMapSeries;
};


},{}],12:[function(_dereq_,module,exports){
"use strict";
var es5 = _dereq_("./es5");
var Objectfreeze = es5.freeze;
var util = _dereq_("./util");
var inherits = util.inherits;
var notEnumerableProp = util.notEnumerableProp;

function subError(nameProperty, defaultMessage) {
    function SubError(message) {
        if (!(this instanceof SubError)) return new SubError(message);
        notEnumerableProp(this, "message",
            typeof message === "string" ? message : defaultMessage);
        notEnumerableProp(this, "name", nameProperty);
        if (Error.captureStackTrace) {
            Error.captureStackTrace(this, this.constructor);
        } else {
            Error.call(this);
        }
    }
    inherits(SubError, Error);
    return SubError;
}

var _TypeError, _RangeError;
var Warning = subError("Warning", "warning");
var CancellationError = subError("CancellationError", "cancellation error");
var TimeoutError = subError("TimeoutError", "timeout error");
var AggregateError = subError("AggregateError", "aggregate error");
try {
    _TypeError = TypeError;
    _RangeError = RangeError;
} catch(e) {
    _TypeError = subError("TypeError", "type error");
    _RangeError = subError("RangeError", "range error");
}

var methods = ("join pop push shift unshift slice filter forEach some " +
    "every map indexOf lastIndexOf reduce reduceRight sort reverse").split(" ");

for (var i = 0; i < methods.length; ++i) {
    if (typeof Array.prototype[methods[i]] === "function") {
        AggregateError.prototype[methods[i]] = Array.prototype[methods[i]];
    }
}

es5.defineProperty(AggregateError.prototype, "length", {
    value: 0,
    configurable: false,
    writable: true,
    enumerable: true
});
AggregateError.prototype["isOperational"] = true;
var level = 0;
AggregateError.prototype.toString = function() {
    var indent = Array(level * 4 + 1).join(" ");
    var ret = "\n" + indent + "AggregateError of:" + "\n";
    level++;
    indent = Array(level * 4 + 1).join(" ");
    for (var i = 0; i < this.length; ++i) {
        var str = this[i] === this ? "[Circular AggregateError]" : this[i] + "";
        var lines = str.split("\n");
        for (var j = 0; j < lines.length; ++j) {
            lines[j] = indent + lines[j];
        }
        str = lines.join("\n");
        ret += str + "\n";
    }
    level--;
    return ret;
};

function OperationalError(message) {
    if (!(this instanceof OperationalError))
        return new OperationalError(message);
    notEnumerableProp(this, "name", "OperationalError");
    notEnumerableProp(this, "message", message);
    this.cause = message;
    this["isOperational"] = true;

    if (message instanceof Error) {
        notEnumerableProp(this, "message", message.message);
        notEnumerableProp(this, "stack", message.stack);
    } else if (Error.captureStackTrace) {
        Error.captureStackTrace(this, this.constructor);
    }

}
inherits(OperationalError, Error);

var errorTypes = Error["__BluebirdErrorTypes__"];
if (!errorTypes) {
    errorTypes = Objectfreeze({
        CancellationError: CancellationError,
        TimeoutError: TimeoutError,
        OperationalError: OperationalError,
        RejectionError: OperationalError,
        AggregateError: AggregateError
    });
    es5.defineProperty(Error, "__BluebirdErrorTypes__", {
        value: errorTypes,
        writable: false,
        enumerable: false,
        configurable: false
    });
}

module.exports = {
    Error: Error,
    TypeError: _TypeError,
    RangeError: _RangeError,
    CancellationError: errorTypes.CancellationError,
    OperationalError: errorTypes.OperationalError,
    TimeoutError: errorTypes.TimeoutError,
    AggregateError: errorTypes.AggregateError,
    Warning: Warning
};

},{"./es5":13,"./util":36}],13:[function(_dereq_,module,exports){
var isES5 = (function(){
    "use strict";
    return this === undefined;
})();

if (isES5) {
    module.exports = {
        freeze: Object.freeze,
        defineProperty: Object.defineProperty,
        getDescriptor: Object.getOwnPropertyDescriptor,
        keys: Object.keys,
        names: Object.getOwnPropertyNames,
        getPrototypeOf: Object.getPrototypeOf,
        isArray: Array.isArray,
        isES5: isES5,
        propertyIsWritable: function(obj, prop) {
            var descriptor = Object.getOwnPropertyDescriptor(obj, prop);
            return !!(!descriptor || descriptor.writable || descriptor.set);
        }
    };
} else {
    var has = {}.hasOwnProperty;
    var str = {}.toString;
    var proto = {}.constructor.prototype;

    var ObjectKeys = function (o) {
        var ret = [];
        for (var key in o) {
            if (has.call(o, key)) {
                ret.push(key);
            }
        }
        return ret;
    };

    var ObjectGetDescriptor = function(o, key) {
        return {value: o[key]};
    };

    var ObjectDefineProperty = function (o, key, desc) {
        o[key] = desc.value;
        return o;
    };

    var ObjectFreeze = function (obj) {
        return obj;
    };

    var ObjectGetPrototypeOf = function (obj) {
        try {
            return Object(obj).constructor.prototype;
        }
        catch (e) {
            return proto;
        }
    };

    var ArrayIsArray = function (obj) {
        try {
            return str.call(obj) === "[object Array]";
        }
        catch(e) {
            return false;
        }
    };

    module.exports = {
        isArray: ArrayIsArray,
        keys: ObjectKeys,
        names: ObjectKeys,
        defineProperty: ObjectDefineProperty,
        getDescriptor: ObjectGetDescriptor,
        freeze: ObjectFreeze,
        getPrototypeOf: ObjectGetPrototypeOf,
        isES5: isES5,
        propertyIsWritable: function() {
            return true;
        }
    };
}

},{}],14:[function(_dereq_,module,exports){
"use strict";
module.exports = function(Promise, INTERNAL) {
var PromiseMap = Promise.map;

Promise.prototype.filter = function (fn, options) {
    return PromiseMap(this, fn, options, INTERNAL);
};

Promise.filter = function (promises, fn, options) {
    return PromiseMap(promises, fn, options, INTERNAL);
};
};

},{}],15:[function(_dereq_,module,exports){
"use strict";
module.exports = function(Promise, tryConvertToPromise, NEXT_FILTER) {
var util = _dereq_("./util");
var CancellationError = Promise.CancellationError;
var errorObj = util.errorObj;
var catchFilter = _dereq_("./catch_filter")(NEXT_FILTER);

function PassThroughHandlerContext(promise, type, handler) {
    this.promise = promise;
    this.type = type;
    this.handler = handler;
    this.called = false;
    this.cancelPromise = null;
}

PassThroughHandlerContext.prototype.isFinallyHandler = function() {
    return this.type === 0;
};

function FinallyHandlerCancelReaction(finallyHandler) {
    this.finallyHandler = finallyHandler;
}

FinallyHandlerCancelReaction.prototype._resultCancelled = function() {
    checkCancel(this.finallyHandler);
};

function checkCancel(ctx, reason) {
    if (ctx.cancelPromise != null) {
        if (arguments.length > 1) {
            ctx.cancelPromise._reject(reason);
        } else {
            ctx.cancelPromise._cancel();
        }
        ctx.cancelPromise = null;
        return true;
    }
    return false;
}

function succeed() {
    return finallyHandler.call(this, this.promise._target()._settledValue());
}
function fail(reason) {
    if (checkCancel(this, reason)) return;
    errorObj.e = reason;
    return errorObj;
}
function finallyHandler(reasonOrValue) {
    var promise = this.promise;
    var handler = this.handler;

    if (!this.called) {
        this.called = true;
        var ret = this.isFinallyHandler()
            ? handler.call(promise._boundValue())
            : handler.call(promise._boundValue(), reasonOrValue);
        if (ret === NEXT_FILTER) {
            return ret;
        } else if (ret !== undefined) {
            promise._setReturnedNonUndefined();
            var maybePromise = tryConvertToPromise(ret, promise);
            if (maybePromise instanceof Promise) {
                if (this.cancelPromise != null) {
                    if (maybePromise._isCancelled()) {
                        var reason =
                            new CancellationError("late cancellation observer");
                        promise._attachExtraTrace(reason);
                        errorObj.e = reason;
                        return errorObj;
                    } else if (maybePromise.isPending()) {
                        maybePromise._attachCancellationCallback(
                            new FinallyHandlerCancelReaction(this));
                    }
                }
                return maybePromise._then(
                    succeed, fail, undefined, this, undefined);
            }
        }
    }

    if (promise.isRejected()) {
        checkCancel(this);
        errorObj.e = reasonOrValue;
        return errorObj;
    } else {
        checkCancel(this);
        return reasonOrValue;
    }
}

Promise.prototype._passThrough = function(handler, type, success, fail) {
    if (typeof handler !== "function") return this.then();
    return this._then(success,
                      fail,
                      undefined,
                      new PassThroughHandlerContext(this, type, handler),
                      undefined);
};

Promise.prototype.lastly =
Promise.prototype["finally"] = function (handler) {
    return this._passThrough(handler,
                             0,
                             finallyHandler,
                             finallyHandler);
};


Promise.prototype.tap = function (handler) {
    return this._passThrough(handler, 1, finallyHandler);
};

Promise.prototype.tapCatch = function (handlerOrPredicate) {
    var len = arguments.length;
    if(len === 1) {
        return this._passThrough(handlerOrPredicate,
                                 1,
                                 undefined,
                                 finallyHandler);
    } else {
         var catchInstances = new Array(len - 1),
            j = 0, i;
        for (i = 0; i < len - 1; ++i) {
            var item = arguments[i];
            if (util.isObject(item)) {
                catchInstances[j++] = item;
            } else {
                return Promise.reject(new TypeError(
                    "tapCatch statement predicate: "
                    + "expecting an object but got " + util.classString(item)
                ));
            }
        }
        catchInstances.length = j;
        var handler = arguments[i];
        return this._passThrough(catchFilter(catchInstances, handler, this),
                                 1,
                                 undefined,
                                 finallyHandler);
    }

};

return PassThroughHandlerContext;
};

},{"./catch_filter":7,"./util":36}],16:[function(_dereq_,module,exports){
"use strict";
module.exports = function(Promise,
                          apiRejection,
                          INTERNAL,
                          tryConvertToPromise,
                          Proxyable,
                          debug) {
var errors = _dereq_("./errors");
var TypeError = errors.TypeError;
var util = _dereq_("./util");
var errorObj = util.errorObj;
var tryCatch = util.tryCatch;
var yieldHandlers = [];

function promiseFromYieldHandler(value, yieldHandlers, traceParent) {
    for (var i = 0; i < yieldHandlers.length; ++i) {
        traceParent._pushContext();
        var result = tryCatch(yieldHandlers[i])(value);
        traceParent._popContext();
        if (result === errorObj) {
            traceParent._pushContext();
            var ret = Promise.reject(errorObj.e);
            traceParent._popContext();
            return ret;
        }
        var maybePromise = tryConvertToPromise(result, traceParent);
        if (maybePromise instanceof Promise) return maybePromise;
    }
    return null;
}

function PromiseSpawn(generatorFunction, receiver, yieldHandler, stack) {
    if (debug.cancellation()) {
        var internal = new Promise(INTERNAL);
        var _finallyPromise = this._finallyPromise = new Promise(INTERNAL);
        this._promise = internal.lastly(function() {
            return _finallyPromise;
        });
        internal._captureStackTrace();
        internal._setOnCancel(this);
    } else {
        var promise = this._promise = new Promise(INTERNAL);
        promise._captureStackTrace();
    }
    this._stack = stack;
    this._generatorFunction = generatorFunction;
    this._receiver = receiver;
    this._generator = undefined;
    this._yieldHandlers = typeof yieldHandler === "function"
        ? [yieldHandler].concat(yieldHandlers)
        : yieldHandlers;
    this._yieldedPromise = null;
    this._cancellationPhase = false;
}
util.inherits(PromiseSpawn, Proxyable);

PromiseSpawn.prototype._isResolved = function() {
    return this._promise === null;
};

PromiseSpawn.prototype._cleanup = function() {
    this._promise = this._generator = null;
    if (debug.cancellation() && this._finallyPromise !== null) {
        this._finallyPromise._fulfill();
        this._finallyPromise = null;
    }
};

PromiseSpawn.prototype._promiseCancelled = function() {
    if (this._isResolved()) return;
    var implementsReturn = typeof this._generator["return"] !== "undefined";

    var result;
    if (!implementsReturn) {
        var reason = new Promise.CancellationError(
            "generator .return() sentinel");
        Promise.coroutine.returnSentinel = reason;
        this._promise._attachExtraTrace(reason);
        this._promise._pushContext();
        result = tryCatch(this._generator["throw"]).call(this._generator,
                                                         reason);
        this._promise._popContext();
    } else {
        this._promise._pushContext();
        result = tryCatch(this._generator["return"]).call(this._generator,
                                                          undefined);
        this._promise._popContext();
    }
    this._cancellationPhase = true;
    this._yieldedPromise = null;
    this._continue(result);
};

PromiseSpawn.prototype._promiseFulfilled = function(value) {
    this._yieldedPromise = null;
    this._promise._pushContext();
    var result = tryCatch(this._generator.next).call(this._generator, value);
    this._promise._popContext();
    this._continue(result);
};

PromiseSpawn.prototype._promiseRejected = function(reason) {
    this._yieldedPromise = null;
    this._promise._attachExtraTrace(reason);
    this._promise._pushContext();
    var result = tryCatch(this._generator["throw"])
        .call(this._generator, reason);
    this._promise._popContext();
    this._continue(result);
};

PromiseSpawn.prototype._resultCancelled = function() {
    if (this._yieldedPromise instanceof Promise) {
        var promise = this._yieldedPromise;
        this._yieldedPromise = null;
        promise.cancel();
    }
};

PromiseSpawn.prototype.promise = function () {
    return this._promise;
};

PromiseSpawn.prototype._run = function () {
    this._generator = this._generatorFunction.call(this._receiver);
    this._receiver =
        this._generatorFunction = undefined;
    this._promiseFulfilled(undefined);
};

PromiseSpawn.prototype._continue = function (result) {
    var promise = this._promise;
    if (result === errorObj) {
        this._cleanup();
        if (this._cancellationPhase) {
            return promise.cancel();
        } else {
            return promise._rejectCallback(result.e, false);
        }
    }

    var value = result.value;
    if (result.done === true) {
        this._cleanup();
        if (this._cancellationPhase) {
            return promise.cancel();
        } else {
            return promise._resolveCallback(value);
        }
    } else {
        var maybePromise = tryConvertToPromise(value, this._promise);
        if (!(maybePromise instanceof Promise)) {
            maybePromise =
                promiseFromYieldHandler(maybePromise,
                                        this._yieldHandlers,
                                        this._promise);
            if (maybePromise === null) {
                this._promiseRejected(
                    new TypeError(
                        "A value %s was yielded that could not be treated as a promise\u000a\u000a    See http://goo.gl/MqrFmX\u000a\u000a".replace("%s", String(value)) +
                        "From coroutine:\u000a" +
                        this._stack.split("\n").slice(1, -7).join("\n")
                    )
                );
                return;
            }
        }
        maybePromise = maybePromise._target();
        var bitField = maybePromise._bitField;
        ;
        if (((bitField & 50397184) === 0)) {
            this._yieldedPromise = maybePromise;
            maybePromise._proxy(this, null);
        } else if (((bitField & 33554432) !== 0)) {
            Promise._async.invoke(
                this._promiseFulfilled, this, maybePromise._value()
            );
        } else if (((bitField & 16777216) !== 0)) {
            Promise._async.invoke(
                this._promiseRejected, this, maybePromise._reason()
            );
        } else {
            this._promiseCancelled();
        }
    }
};

Promise.coroutine = function (generatorFunction, options) {
    if (typeof generatorFunction !== "function") {
        throw new TypeError("generatorFunction must be a function\u000a\u000a    See http://goo.gl/MqrFmX\u000a");
    }
    var yieldHandler = Object(options).yieldHandler;
    var PromiseSpawn$ = PromiseSpawn;
    var stack = new Error().stack;
    return function () {
        var generator = generatorFunction.apply(this, arguments);
        var spawn = new PromiseSpawn$(undefined, undefined, yieldHandler,
                                      stack);
        var ret = spawn.promise();
        spawn._generator = generator;
        spawn._promiseFulfilled(undefined);
        return ret;
    };
};

Promise.coroutine.addYieldHandler = function(fn) {
    if (typeof fn !== "function") {
        throw new TypeError("expecting a function but got " + util.classString(fn));
    }
    yieldHandlers.push(fn);
};

Promise.spawn = function (generatorFunction) {
    debug.deprecated("Promise.spawn()", "Promise.coroutine()");
    if (typeof generatorFunction !== "function") {
        return apiRejection("generatorFunction must be a function\u000a\u000a    See http://goo.gl/MqrFmX\u000a");
    }
    var spawn = new PromiseSpawn(generatorFunction, this);
    var ret = spawn.promise();
    spawn._run(Promise.spawn);
    return ret;
};
};

},{"./errors":12,"./util":36}],17:[function(_dereq_,module,exports){
"use strict";
module.exports =
function(Promise, PromiseArray, tryConvertToPromise, INTERNAL, async,
         getDomain) {
var util = _dereq_("./util");
var canEvaluate = util.canEvaluate;
var tryCatch = util.tryCatch;
var errorObj = util.errorObj;
var reject;

if (!true) {
if (canEvaluate) {
    var thenCallback = function(i) {
        return new Function("value", "holder", "                             \n\
            'use strict';                                                    \n\
            holder.pIndex = value;                                           \n\
            holder.checkFulfillment(this);                                   \n\
            ".replace(/Index/g, i));
    };

    var promiseSetter = function(i) {
        return new Function("promise", "holder", "                           \n\
            'use strict';                                                    \n\
            holder.pIndex = promise;                                         \n\
            ".replace(/Index/g, i));
    };

    var generateHolderClass = function(total) {
        var props = new Array(total);
        for (var i = 0; i < props.length; ++i) {
            props[i] = "this.p" + (i+1);
        }
        var assignment = props.join(" = ") + " = null;";
        var cancellationCode= "var promise;\n" + props.map(function(prop) {
            return "                                                         \n\
                promise = " + prop + ";                                      \n\
                if (promise instanceof Promise) {                            \n\
                    promise.cancel();                                        \n\
                }                                                            \n\
            ";
        }).join("\n");
        var passedArguments = props.join(", ");
        var name = "Holder$" + total;


        var code = "return function(tryCatch, errorObj, Promise, async) {    \n\
            'use strict';                                                    \n\
            function [TheName](fn) {                                         \n\
                [TheProperties]                                              \n\
                this.fn = fn;                                                \n\
                this.asyncNeeded = true;                                     \n\
                this.now = 0;                                                \n\
            }                                                                \n\
                                                                             \n\
            [TheName].prototype._callFunction = function(promise) {          \n\
                promise._pushContext();                                      \n\
                var ret = tryCatch(this.fn)([ThePassedArguments]);           \n\
                promise._popContext();                                       \n\
                if (ret === errorObj) {                                      \n\
                    promise._rejectCallback(ret.e, false);                   \n\
                } else {                                                     \n\
                    promise._resolveCallback(ret);                           \n\
                }                                                            \n\
            };                                                               \n\
                                                                             \n\
            [TheName].prototype.checkFulfillment = function(promise) {       \n\
                var now = ++this.now;                                        \n\
                if (now === [TheTotal]) {                                    \n\
                    if (this.asyncNeeded) {                                  \n\
                        async.invoke(this._callFunction, this, promise);     \n\
                    } else {                                                 \n\
                        this._callFunction(promise);                         \n\
                    }                                                        \n\
                                                                             \n\
                }                                                            \n\
            };                                                               \n\
                                                                             \n\
            [TheName].prototype._resultCancelled = function() {              \n\
                [CancellationCode]                                           \n\
            };                                                               \n\
                                                                             \n\
            return [TheName];                                                \n\
        }(tryCatch, errorObj, Promise, async);                               \n\
        ";

        code = code.replace(/\[TheName\]/g, name)
            .replace(/\[TheTotal\]/g, total)
            .replace(/\[ThePassedArguments\]/g, passedArguments)
            .replace(/\[TheProperties\]/g, assignment)
            .replace(/\[CancellationCode\]/g, cancellationCode);

        return new Function("tryCatch", "errorObj", "Promise", "async", code)
                           (tryCatch, errorObj, Promise, async);
    };

    var holderClasses = [];
    var thenCallbacks = [];
    var promiseSetters = [];

    for (var i = 0; i < 8; ++i) {
        holderClasses.push(generateHolderClass(i + 1));
        thenCallbacks.push(thenCallback(i + 1));
        promiseSetters.push(promiseSetter(i + 1));
    }

    reject = function (reason) {
        this._reject(reason);
    };
}}

Promise.join = function () {
    var last = arguments.length - 1;
    var fn;
    if (last > 0 && typeof arguments[last] === "function") {
        fn = arguments[last];
        if (!true) {
            if (last <= 8 && canEvaluate) {
                var ret = new Promise(INTERNAL);
                ret._captureStackTrace();
                var HolderClass = holderClasses[last - 1];
                var holder = new HolderClass(fn);
                var callbacks = thenCallbacks;

                for (var i = 0; i < last; ++i) {
                    var maybePromise = tryConvertToPromise(arguments[i], ret);
                    if (maybePromise instanceof Promise) {
                        maybePromise = maybePromise._target();
                        var bitField = maybePromise._bitField;
                        ;
                        if (((bitField & 50397184) === 0)) {
                            maybePromise._then(callbacks[i], reject,
                                               undefined, ret, holder);
                            promiseSetters[i](maybePromise, holder);
                            holder.asyncNeeded = false;
                        } else if (((bitField & 33554432) !== 0)) {
                            callbacks[i].call(ret,
                                              maybePromise._value(), holder);
                        } else if (((bitField & 16777216) !== 0)) {
                            ret._reject(maybePromise._reason());
                        } else {
                            ret._cancel();
                        }
                    } else {
                        callbacks[i].call(ret, maybePromise, holder);
                    }
                }

                if (!ret._isFateSealed()) {
                    if (holder.asyncNeeded) {
                        var domain = getDomain();
                        if (domain !== null) {
                            holder.fn = util.domainBind(domain, holder.fn);
                        }
                    }
                    ret._setAsyncGuaranteed();
                    ret._setOnCancel(holder);
                }
                return ret;
            }
        }
    }
    var args = [].slice.call(arguments);;
    if (fn) args.pop();
    var ret = new PromiseArray(args).promise();
    return fn !== undefined ? ret.spread(fn) : ret;
};

};

},{"./util":36}],18:[function(_dereq_,module,exports){
"use strict";
module.exports = function(Promise,
                          PromiseArray,
                          apiRejection,
                          tryConvertToPromise,
                          INTERNAL,
                          debug) {
var getDomain = Promise._getDomain;
var util = _dereq_("./util");
var tryCatch = util.tryCatch;
var errorObj = util.errorObj;
var async = Promise._async;

function MappingPromiseArray(promises, fn, limit, _filter) {
    this.constructor$(promises);
    this._promise._captureStackTrace();
    var domain = getDomain();
    this._callback = domain === null ? fn : util.domainBind(domain, fn);
    this._preservedValues = _filter === INTERNAL
        ? new Array(this.length())
        : null;
    this._limit = limit;
    this._inFlight = 0;
    this._queue = [];
    async.invoke(this._asyncInit, this, undefined);
}
util.inherits(MappingPromiseArray, PromiseArray);

MappingPromiseArray.prototype._asyncInit = function() {
    this._init$(undefined, -2);
};

MappingPromiseArray.prototype._init = function () {};

MappingPromiseArray.prototype._promiseFulfilled = function (value, index) {
    var values = this._values;
    var length = this.length();
    var preservedValues = this._preservedValues;
    var limit = this._limit;

    if (index < 0) {
        index = (index * -1) - 1;
        values[index] = value;
        if (limit >= 1) {
            this._inFlight--;
            this._drainQueue();
            if (this._isResolved()) return true;
        }
    } else {
        if (limit >= 1 && this._inFlight >= limit) {
            values[index] = value;
            this._queue.push(index);
            return false;
        }
        if (preservedValues !== null) preservedValues[index] = value;

        var promise = this._promise;
        var callback = this._callback;
        var receiver = promise._boundValue();
        promise._pushContext();
        var ret = tryCatch(callback).call(receiver, value, index, length);
        var promiseCreated = promise._popContext();
        debug.checkForgottenReturns(
            ret,
            promiseCreated,
            preservedValues !== null ? "Promise.filter" : "Promise.map",
            promise
        );
        if (ret === errorObj) {
            this._reject(ret.e);
            return true;
        }

        var maybePromise = tryConvertToPromise(ret, this._promise);
        if (maybePromise instanceof Promise) {
            maybePromise = maybePromise._target();
            var bitField = maybePromise._bitField;
            ;
            if (((bitField & 50397184) === 0)) {
                if (limit >= 1) this._inFlight++;
                values[index] = maybePromise;
                maybePromise._proxy(this, (index + 1) * -1);
                return false;
            } else if (((bitField & 33554432) !== 0)) {
                ret = maybePromise._value();
            } else if (((bitField & 16777216) !== 0)) {
                this._reject(maybePromise._reason());
                return true;
            } else {
                this._cancel();
                return true;
            }
        }
        values[index] = ret;
    }
    var totalResolved = ++this._totalResolved;
    if (totalResolved >= length) {
        if (preservedValues !== null) {
            this._filter(values, preservedValues);
        } else {
            this._resolve(values);
        }
        return true;
    }
    return false;
};

MappingPromiseArray.prototype._drainQueue = function () {
    var queue = this._queue;
    var limit = this._limit;
    var values = this._values;
    while (queue.length > 0 && this._inFlight < limit) {
        if (this._isResolved()) return;
        var index = queue.pop();
        this._promiseFulfilled(values[index], index);
    }
};

MappingPromiseArray.prototype._filter = function (booleans, values) {
    var len = values.length;
    var ret = new Array(len);
    var j = 0;
    for (var i = 0; i < len; ++i) {
        if (booleans[i]) ret[j++] = values[i];
    }
    ret.length = j;
    this._resolve(ret);
};

MappingPromiseArray.prototype.preservedValues = function () {
    return this._preservedValues;
};

function map(promises, fn, options, _filter) {
    if (typeof fn !== "function") {
        return apiRejection("expecting a function but got " + util.classString(fn));
    }

    var limit = 0;
    if (options !== undefined) {
        if (typeof options === "object" && options !== null) {
            if (typeof options.concurrency !== "number") {
                return Promise.reject(
                    new TypeError("'concurrency' must be a number but it is " +
                                    util.classString(options.concurrency)));
            }
            limit = options.concurrency;
        } else {
            return Promise.reject(new TypeError(
                            "options argument must be an object but it is " +
                             util.classString(options)));
        }
    }
    limit = typeof limit === "number" &&
        isFinite(limit) && limit >= 1 ? limit : 0;
    return new MappingPromiseArray(promises, fn, limit, _filter).promise();
}

Promise.prototype.map = function (fn, options) {
    return map(this, fn, options, null);
};

Promise.map = function (promises, fn, options, _filter) {
    return map(promises, fn, options, _filter);
};


};

},{"./util":36}],19:[function(_dereq_,module,exports){
"use strict";
module.exports =
function(Promise, INTERNAL, tryConvertToPromise, apiRejection, debug) {
var util = _dereq_("./util");
var tryCatch = util.tryCatch;

Promise.method = function (fn) {
    if (typeof fn !== "function") {
        throw new Promise.TypeError("expecting a function but got " + util.classString(fn));
    }
    return function () {
        var ret = new Promise(INTERNAL);
        ret._captureStackTrace();
        ret._pushContext();
        var value = tryCatch(fn).apply(this, arguments);
        var promiseCreated = ret._popContext();
        debug.checkForgottenReturns(
            value, promiseCreated, "Promise.method", ret);
        ret._resolveFromSyncValue(value);
        return ret;
    };
};

Promise.attempt = Promise["try"] = function (fn) {
    if (typeof fn !== "function") {
        return apiRejection("expecting a function but got " + util.classString(fn));
    }
    var ret = new Promise(INTERNAL);
    ret._captureStackTrace();
    ret._pushContext();
    var value;
    if (arguments.length > 1) {
        debug.deprecated("calling Promise.try with more than 1 argument");
        var arg = arguments[1];
        var ctx = arguments[2];
        value = util.isArray(arg) ? tryCatch(fn).apply(ctx, arg)
                                  : tryCatch(fn).call(ctx, arg);
    } else {
        value = tryCatch(fn)();
    }
    var promiseCreated = ret._popContext();
    debug.checkForgottenReturns(
        value, promiseCreated, "Promise.try", ret);
    ret._resolveFromSyncValue(value);
    return ret;
};

Promise.prototype._resolveFromSyncValue = function (value) {
    if (value === util.errorObj) {
        this._rejectCallback(value.e, false);
    } else {
        this._resolveCallback(value, true);
    }
};
};

},{"./util":36}],20:[function(_dereq_,module,exports){
"use strict";
var util = _dereq_("./util");
var maybeWrapAsError = util.maybeWrapAsError;
var errors = _dereq_("./errors");
var OperationalError = errors.OperationalError;
var es5 = _dereq_("./es5");

function isUntypedError(obj) {
    return obj instanceof Error &&
        es5.getPrototypeOf(obj) === Error.prototype;
}

var rErrorKey = /^(?:name|message|stack|cause)$/;
function wrapAsOperationalError(obj) {
    var ret;
    if (isUntypedError(obj)) {
        ret = new OperationalError(obj);
        ret.name = obj.name;
        ret.message = obj.message;
        ret.stack = obj.stack;
        var keys = es5.keys(obj);
        for (var i = 0; i < keys.length; ++i) {
            var key = keys[i];
            if (!rErrorKey.test(key)) {
                ret[key] = obj[key];
            }
        }
        return ret;
    }
    util.markAsOriginatingFromRejection(obj);
    return obj;
}

function nodebackForPromise(promise, multiArgs) {
    return function(err, value) {
        if (promise === null) return;
        if (err) {
            var wrapped = wrapAsOperationalError(maybeWrapAsError(err));
            promise._attachExtraTrace(wrapped);
            promise._reject(wrapped);
        } else if (!multiArgs) {
            promise._fulfill(value);
        } else {
            var args = [].slice.call(arguments, 1);;
            promise._fulfill(args);
        }
        promise = null;
    };
}

module.exports = nodebackForPromise;

},{"./errors":12,"./es5":13,"./util":36}],21:[function(_dereq_,module,exports){
"use strict";
module.exports = function(Promise) {
var util = _dereq_("./util");
var async = Promise._async;
var tryCatch = util.tryCatch;
var errorObj = util.errorObj;

function spreadAdapter(val, nodeback) {
    var promise = this;
    if (!util.isArray(val)) return successAdapter.call(promise, val, nodeback);
    var ret =
        tryCatch(nodeback).apply(promise._boundValue(), [null].concat(val));
    if (ret === errorObj) {
        async.throwLater(ret.e);
    }
}

function successAdapter(val, nodeback) {
    var promise = this;
    var receiver = promise._boundValue();
    var ret = val === undefined
        ? tryCatch(nodeback).call(receiver, null)
        : tryCatch(nodeback).call(receiver, null, val);
    if (ret === errorObj) {
        async.throwLater(ret.e);
    }
}
function errorAdapter(reason, nodeback) {
    var promise = this;
    if (!reason) {
        var newReason = new Error(reason + "");
        newReason.cause = reason;
        reason = newReason;
    }
    var ret = tryCatch(nodeback).call(promise._boundValue(), reason);
    if (ret === errorObj) {
        async.throwLater(ret.e);
    }
}

Promise.prototype.asCallback = Promise.prototype.nodeify = function (nodeback,
                                                                     options) {
    if (typeof nodeback == "function") {
        var adapter = successAdapter;
        if (options !== undefined && Object(options).spread) {
            adapter = spreadAdapter;
        }
        this._then(
            adapter,
            errorAdapter,
            undefined,
            this,
            nodeback
        );
    }
    return this;
};
};

},{"./util":36}],22:[function(_dereq_,module,exports){
"use strict";
module.exports = function() {
var makeSelfResolutionError = function () {
    return new TypeError("circular promise resolution chain\u000a\u000a    See http://goo.gl/MqrFmX\u000a");
};
var reflectHandler = function() {
    return new Promise.PromiseInspection(this._target());
};
var apiRejection = function(msg) {
    return Promise.reject(new TypeError(msg));
};
function Proxyable() {}
var UNDEFINED_BINDING = {};
var util = _dereq_("./util");

var getDomain;
if (util.isNode) {
    getDomain = function() {
        var ret = process.domain;
        if (ret === undefined) ret = null;
        return ret;
    };
} else {
    getDomain = function() {
        return null;
    };
}
util.notEnumerableProp(Promise, "_getDomain", getDomain);

var es5 = _dereq_("./es5");
var Async = _dereq_("./async");
var async = new Async();
es5.defineProperty(Promise, "_async", {value: async});
var errors = _dereq_("./errors");
var TypeError = Promise.TypeError = errors.TypeError;
Promise.RangeError = errors.RangeError;
var CancellationError = Promise.CancellationError = errors.CancellationError;
Promise.TimeoutError = errors.TimeoutError;
Promise.OperationalError = errors.OperationalError;
Promise.RejectionError = errors.OperationalError;
Promise.AggregateError = errors.AggregateError;
var INTERNAL = function(){};
var APPLY = {};
var NEXT_FILTER = {};
var tryConvertToPromise = _dereq_("./thenables")(Promise, INTERNAL);
var PromiseArray =
    _dereq_("./promise_array")(Promise, INTERNAL,
                               tryConvertToPromise, apiRejection, Proxyable);
var Context = _dereq_("./context")(Promise);
 /*jshint unused:false*/
var createContext = Context.create;
var debug = _dereq_("./debuggability")(Promise, Context);
var CapturedTrace = debug.CapturedTrace;
var PassThroughHandlerContext =
    _dereq_("./finally")(Promise, tryConvertToPromise, NEXT_FILTER);
var catchFilter = _dereq_("./catch_filter")(NEXT_FILTER);
var nodebackForPromise = _dereq_("./nodeback");
var errorObj = util.errorObj;
var tryCatch = util.tryCatch;
function check(self, executor) {
    if (self == null || self.constructor !== Promise) {
        throw new TypeError("the promise constructor cannot be invoked directly\u000a\u000a    See http://goo.gl/MqrFmX\u000a");
    }
    if (typeof executor !== "function") {
        throw new TypeError("expecting a function but got " + util.classString(executor));
    }

}

function Promise(executor) {
    if (executor !== INTERNAL) {
        check(this, executor);
    }
    this._bitField = 0;
    this._fulfillmentHandler0 = undefined;
    this._rejectionHandler0 = undefined;
    this._promise0 = undefined;
    this._receiver0 = undefined;
    this._resolveFromExecutor(executor);
    this._promiseCreated();
    this._fireEvent("promiseCreated", this);
}

Promise.prototype.toString = function () {
    return "[object Promise]";
};

Promise.prototype.caught = Promise.prototype["catch"] = function (fn) {
    var len = arguments.length;
    if (len > 1) {
        var catchInstances = new Array(len - 1),
            j = 0, i;
        for (i = 0; i < len - 1; ++i) {
            var item = arguments[i];
            if (util.isObject(item)) {
                catchInstances[j++] = item;
            } else {
                return apiRejection("Catch statement predicate: " +
                    "expecting an object but got " + util.classString(item));
            }
        }
        catchInstances.length = j;
        fn = arguments[i];
        return this.then(undefined, catchFilter(catchInstances, fn, this));
    }
    return this.then(undefined, fn);
};

Promise.prototype.reflect = function () {
    return this._then(reflectHandler,
        reflectHandler, undefined, this, undefined);
};

Promise.prototype.then = function (didFulfill, didReject) {
    if (debug.warnings() && arguments.length > 0 &&
        typeof didFulfill !== "function" &&
        typeof didReject !== "function") {
        var msg = ".then() only accepts functions but was passed: " +
                util.classString(didFulfill);
        if (arguments.length > 1) {
            msg += ", " + util.classString(didReject);
        }
        this._warn(msg);
    }
    return this._then(didFulfill, didReject, undefined, undefined, undefined);
};

Promise.prototype.done = function (didFulfill, didReject) {
    var promise =
        this._then(didFulfill, didReject, undefined, undefined, undefined);
    promise._setIsFinal();
};

Promise.prototype.spread = function (fn) {
    if (typeof fn !== "function") {
        return apiRejection("expecting a function but got " + util.classString(fn));
    }
    return this.all()._then(fn, undefined, undefined, APPLY, undefined);
};

Promise.prototype.toJSON = function () {
    var ret = {
        isFulfilled: false,
        isRejected: false,
        fulfillmentValue: undefined,
        rejectionReason: undefined
    };
    if (this.isFulfilled()) {
        ret.fulfillmentValue = this.value();
        ret.isFulfilled = true;
    } else if (this.isRejected()) {
        ret.rejectionReason = this.reason();
        ret.isRejected = true;
    }
    return ret;
};

Promise.prototype.all = function () {
    if (arguments.length > 0) {
        this._warn(".all() was passed arguments but it does not take any");
    }
    return new PromiseArray(this).promise();
};

Promise.prototype.error = function (fn) {
    return this.caught(util.originatesFromRejection, fn);
};

Promise.getNewLibraryCopy = module.exports;

Promise.is = function (val) {
    return val instanceof Promise;
};

Promise.fromNode = Promise.fromCallback = function(fn) {
    var ret = new Promise(INTERNAL);
    ret._captureStackTrace();
    var multiArgs = arguments.length > 1 ? !!Object(arguments[1]).multiArgs
                                         : false;
    var result = tryCatch(fn)(nodebackForPromise(ret, multiArgs));
    if (result === errorObj) {
        ret._rejectCallback(result.e, true);
    }
    if (!ret._isFateSealed()) ret._setAsyncGuaranteed();
    return ret;
};

Promise.all = function (promises) {
    return new PromiseArray(promises).promise();
};

Promise.cast = function (obj) {
    var ret = tryConvertToPromise(obj);
    if (!(ret instanceof Promise)) {
        ret = new Promise(INTERNAL);
        ret._captureStackTrace();
        ret._setFulfilled();
        ret._rejectionHandler0 = obj;
    }
    return ret;
};

Promise.resolve = Promise.fulfilled = Promise.cast;

Promise.reject = Promise.rejected = function (reason) {
    var ret = new Promise(INTERNAL);
    ret._captureStackTrace();
    ret._rejectCallback(reason, true);
    return ret;
};

Promise.setScheduler = function(fn) {
    if (typeof fn !== "function") {
        throw new TypeError("expecting a function but got " + util.classString(fn));
    }
    return async.setScheduler(fn);
};

Promise.prototype._then = function (
    didFulfill,
    didReject,
    _,    receiver,
    internalData
) {
    var haveInternalData = internalData !== undefined;
    var promise = haveInternalData ? internalData : new Promise(INTERNAL);
    var target = this._target();
    var bitField = target._bitField;

    if (!haveInternalData) {
        promise._propagateFrom(this, 3);
        promise._captureStackTrace();
        if (receiver === undefined &&
            ((this._bitField & 2097152) !== 0)) {
            if (!((bitField & 50397184) === 0)) {
                receiver = this._boundValue();
            } else {
                receiver = target === this ? undefined : this._boundTo;
            }
        }
        this._fireEvent("promiseChained", this, promise);
    }

    var domain = getDomain();
    if (!((bitField & 50397184) === 0)) {
        var handler, value, settler = target._settlePromiseCtx;
        if (((bitField & 33554432) !== 0)) {
            value = target._rejectionHandler0;
            handler = didFulfill;
        } else if (((bitField & 16777216) !== 0)) {
            value = target._fulfillmentHandler0;
            handler = didReject;
            target._unsetRejectionIsUnhandled();
        } else {
            settler = target._settlePromiseLateCancellationObserver;
            value = new CancellationError("late cancellation observer");
            target._attachExtraTrace(value);
            handler = didReject;
        }

        async.invoke(settler, target, {
            handler: domain === null ? handler
                : (typeof handler === "function" &&
                    util.domainBind(domain, handler)),
            promise: promise,
            receiver: receiver,
            value: value
        });
    } else {
        target._addCallbacks(didFulfill, didReject, promise, receiver, domain);
    }

    return promise;
};

Promise.prototype._length = function () {
    return this._bitField & 65535;
};

Promise.prototype._isFateSealed = function () {
    return (this._bitField & 117506048) !== 0;
};

Promise.prototype._isFollowing = function () {
    return (this._bitField & 67108864) === 67108864;
};

Promise.prototype._setLength = function (len) {
    this._bitField = (this._bitField & -65536) |
        (len & 65535);
};

Promise.prototype._setFulfilled = function () {
    this._bitField = this._bitField | 33554432;
    this._fireEvent("promiseFulfilled", this);
};

Promise.prototype._setRejected = function () {
    this._bitField = this._bitField | 16777216;
    this._fireEvent("promiseRejected", this);
};

Promise.prototype._setFollowing = function () {
    this._bitField = this._bitField | 67108864;
    this._fireEvent("promiseResolved", this);
};

Promise.prototype._setIsFinal = function () {
    this._bitField = this._bitField | 4194304;
};

Promise.prototype._isFinal = function () {
    return (this._bitField & 4194304) > 0;
};

Promise.prototype._unsetCancelled = function() {
    this._bitField = this._bitField & (~65536);
};

Promise.prototype._setCancelled = function() {
    this._bitField = this._bitField | 65536;
    this._fireEvent("promiseCancelled", this);
};

Promise.prototype._setWillBeCancelled = function() {
    this._bitField = this._bitField | 8388608;
};

Promise.prototype._setAsyncGuaranteed = function() {
    if (async.hasCustomScheduler()) return;
    this._bitField = this._bitField | 134217728;
};

Promise.prototype._receiverAt = function (index) {
    var ret = index === 0 ? this._receiver0 : this[
            index * 4 - 4 + 3];
    if (ret === UNDEFINED_BINDING) {
        return undefined;
    } else if (ret === undefined && this._isBound()) {
        return this._boundValue();
    }
    return ret;
};

Promise.prototype._promiseAt = function (index) {
    return this[
            index * 4 - 4 + 2];
};

Promise.prototype._fulfillmentHandlerAt = function (index) {
    return this[
            index * 4 - 4 + 0];
};

Promise.prototype._rejectionHandlerAt = function (index) {
    return this[
            index * 4 - 4 + 1];
};

Promise.prototype._boundValue = function() {};

Promise.prototype._migrateCallback0 = function (follower) {
    var bitField = follower._bitField;
    var fulfill = follower._fulfillmentHandler0;
    var reject = follower._rejectionHandler0;
    var promise = follower._promise0;
    var receiver = follower._receiverAt(0);
    if (receiver === undefined) receiver = UNDEFINED_BINDING;
    this._addCallbacks(fulfill, reject, promise, receiver, null);
};

Promise.prototype._migrateCallbackAt = function (follower, index) {
    var fulfill = follower._fulfillmentHandlerAt(index);
    var reject = follower._rejectionHandlerAt(index);
    var promise = follower._promiseAt(index);
    var receiver = follower._receiverAt(index);
    if (receiver === undefined) receiver = UNDEFINED_BINDING;
    this._addCallbacks(fulfill, reject, promise, receiver, null);
};

Promise.prototype._addCallbacks = function (
    fulfill,
    reject,
    promise,
    receiver,
    domain
) {
    var index = this._length();

    if (index >= 65535 - 4) {
        index = 0;
        this._setLength(0);
    }

    if (index === 0) {
        this._promise0 = promise;
        this._receiver0 = receiver;
        if (typeof fulfill === "function") {
            this._fulfillmentHandler0 =
                domain === null ? fulfill : util.domainBind(domain, fulfill);
        }
        if (typeof reject === "function") {
            this._rejectionHandler0 =
                domain === null ? reject : util.domainBind(domain, reject);
        }
    } else {
        var base = index * 4 - 4;
        this[base + 2] = promise;
        this[base + 3] = receiver;
        if (typeof fulfill === "function") {
            this[base + 0] =
                domain === null ? fulfill : util.domainBind(domain, fulfill);
        }
        if (typeof reject === "function") {
            this[base + 1] =
                domain === null ? reject : util.domainBind(domain, reject);
        }
    }
    this._setLength(index + 1);
    return index;
};

Promise.prototype._proxy = function (proxyable, arg) {
    this._addCallbacks(undefined, undefined, arg, proxyable, null);
};

Promise.prototype._resolveCallback = function(value, shouldBind) {
    if (((this._bitField & 117506048) !== 0)) return;
    if (value === this)
        return this._rejectCallback(makeSelfResolutionError(), false);
    var maybePromise = tryConvertToPromise(value, this);
    if (!(maybePromise instanceof Promise)) return this._fulfill(value);

    if (shouldBind) this._propagateFrom(maybePromise, 2);

    var promise = maybePromise._target();

    if (promise === this) {
        this._reject(makeSelfResolutionError());
        return;
    }

    var bitField = promise._bitField;
    if (((bitField & 50397184) === 0)) {
        var len = this._length();
        if (len > 0) promise._migrateCallback0(this);
        for (var i = 1; i < len; ++i) {
            promise._migrateCallbackAt(this, i);
        }
        this._setFollowing();
        this._setLength(0);
        this._setFollowee(promise);
    } else if (((bitField & 33554432) !== 0)) {
        this._fulfill(promise._value());
    } else if (((bitField & 16777216) !== 0)) {
        this._reject(promise._reason());
    } else {
        var reason = new CancellationError("late cancellation observer");
        promise._attachExtraTrace(reason);
        this._reject(reason);
    }
};

Promise.prototype._rejectCallback =
function(reason, synchronous, ignoreNonErrorWarnings) {
    var trace = util.ensureErrorObject(reason);
    var hasStack = trace === reason;
    if (!hasStack && !ignoreNonErrorWarnings && debug.warnings()) {
        var message = "a promise was rejected with a non-error: " +
            util.classString(reason);
        this._warn(message, true);
    }
    this._attachExtraTrace(trace, synchronous ? hasStack : false);
    this._reject(reason);
};

Promise.prototype._resolveFromExecutor = function (executor) {
    if (executor === INTERNAL) return;
    var promise = this;
    this._captureStackTrace();
    this._pushContext();
    var synchronous = true;
    var r = this._execute(executor, function(value) {
        promise._resolveCallback(value);
    }, function (reason) {
        promise._rejectCallback(reason, synchronous);
    });
    synchronous = false;
    this._popContext();

    if (r !== undefined) {
        promise._rejectCallback(r, true);
    }
};

Promise.prototype._settlePromiseFromHandler = function (
    handler, receiver, value, promise
) {
    var bitField = promise._bitField;
    if (((bitField & 65536) !== 0)) return;
    promise._pushContext();
    var x;
    if (receiver === APPLY) {
        if (!value || typeof value.length !== "number") {
            x = errorObj;
            x.e = new TypeError("cannot .spread() a non-array: " +
                                    util.classString(value));
        } else {
            x = tryCatch(handler).apply(this._boundValue(), value);
        }
    } else {
        x = tryCatch(handler).call(receiver, value);
    }
    var promiseCreated = promise._popContext();
    bitField = promise._bitField;
    if (((bitField & 65536) !== 0)) return;

    if (x === NEXT_FILTER) {
        promise._reject(value);
    } else if (x === errorObj) {
        promise._rejectCallback(x.e, false);
    } else {
        debug.checkForgottenReturns(x, promiseCreated, "",  promise, this);
        promise._resolveCallback(x);
    }
};

Promise.prototype._target = function() {
    var ret = this;
    while (ret._isFollowing()) ret = ret._followee();
    return ret;
};

Promise.prototype._followee = function() {
    return this._rejectionHandler0;
};

Promise.prototype._setFollowee = function(promise) {
    this._rejectionHandler0 = promise;
};

Promise.prototype._settlePromise = function(promise, handler, receiver, value) {
    var isPromise = promise instanceof Promise;
    var bitField = this._bitField;
    var asyncGuaranteed = ((bitField & 134217728) !== 0);
    if (((bitField & 65536) !== 0)) {
        if (isPromise) promise._invokeInternalOnCancel();

        if (receiver instanceof PassThroughHandlerContext &&
            receiver.isFinallyHandler()) {
            receiver.cancelPromise = promise;
            if (tryCatch(handler).call(receiver, value) === errorObj) {
                promise._reject(errorObj.e);
            }
        } else if (handler === reflectHandler) {
            promise._fulfill(reflectHandler.call(receiver));
        } else if (receiver instanceof Proxyable) {
            receiver._promiseCancelled(promise);
        } else if (isPromise || promise instanceof PromiseArray) {
            promise._cancel();
        } else {
            receiver.cancel();
        }
    } else if (typeof handler === "function") {
        if (!isPromise) {
            handler.call(receiver, value, promise);
        } else {
            if (asyncGuaranteed) promise._setAsyncGuaranteed();
            this._settlePromiseFromHandler(handler, receiver, value, promise);
        }
    } else if (receiver instanceof Proxyable) {
        if (!receiver._isResolved()) {
            if (((bitField & 33554432) !== 0)) {
                receiver._promiseFulfilled(value, promise);
            } else {
                receiver._promiseRejected(value, promise);
            }
        }
    } else if (isPromise) {
        if (asyncGuaranteed) promise._setAsyncGuaranteed();
        if (((bitField & 33554432) !== 0)) {
            promise._fulfill(value);
        } else {
            promise._reject(value);
        }
    }
};

Promise.prototype._settlePromiseLateCancellationObserver = function(ctx) {
    var handler = ctx.handler;
    var promise = ctx.promise;
    var receiver = ctx.receiver;
    var value = ctx.value;
    if (typeof handler === "function") {
        if (!(promise instanceof Promise)) {
            handler.call(receiver, value, promise);
        } else {
            this._settlePromiseFromHandler(handler, receiver, value, promise);
        }
    } else if (promise instanceof Promise) {
        promise._reject(value);
    }
};

Promise.prototype._settlePromiseCtx = function(ctx) {
    this._settlePromise(ctx.promise, ctx.handler, ctx.receiver, ctx.value);
};

Promise.prototype._settlePromise0 = function(handler, value, bitField) {
    var promise = this._promise0;
    var receiver = this._receiverAt(0);
    this._promise0 = undefined;
    this._receiver0 = undefined;
    this._settlePromise(promise, handler, receiver, value);
};

Promise.prototype._clearCallbackDataAtIndex = function(index) {
    var base = index * 4 - 4;
    this[base + 2] =
    this[base + 3] =
    this[base + 0] =
    this[base + 1] = undefined;
};

Promise.prototype._fulfill = function (value) {
    var bitField = this._bitField;
    if (((bitField & 117506048) >>> 16)) return;
    if (value === this) {
        var err = makeSelfResolutionError();
        this._attachExtraTrace(err);
        return this._reject(err);
    }
    this._setFulfilled();
    this._rejectionHandler0 = value;

    if ((bitField & 65535) > 0) {
        if (((bitField & 134217728) !== 0)) {
            this._settlePromises();
        } else {
            async.settlePromises(this);
        }
    }
};

Promise.prototype._reject = function (reason) {
    var bitField = this._bitField;
    if (((bitField & 117506048) >>> 16)) return;
    this._setRejected();
    this._fulfillmentHandler0 = reason;

    if (this._isFinal()) {
        return async.fatalError(reason, util.isNode);
    }

    if ((bitField & 65535) > 0) {
        async.settlePromises(this);
    } else {
        this._ensurePossibleRejectionHandled();
    }
};

Promise.prototype._fulfillPromises = function (len, value) {
    for (var i = 1; i < len; i++) {
        var handler = this._fulfillmentHandlerAt(i);
        var promise = this._promiseAt(i);
        var receiver = this._receiverAt(i);
        this._clearCallbackDataAtIndex(i);
        this._settlePromise(promise, handler, receiver, value);
    }
};

Promise.prototype._rejectPromises = function (len, reason) {
    for (var i = 1; i < len; i++) {
        var handler = this._rejectionHandlerAt(i);
        var promise = this._promiseAt(i);
        var receiver = this._receiverAt(i);
        this._clearCallbackDataAtIndex(i);
        this._settlePromise(promise, handler, receiver, reason);
    }
};

Promise.prototype._settlePromises = function () {
    var bitField = this._bitField;
    var len = (bitField & 65535);

    if (len > 0) {
        if (((bitField & 16842752) !== 0)) {
            var reason = this._fulfillmentHandler0;
            this._settlePromise0(this._rejectionHandler0, reason, bitField);
            this._rejectPromises(len, reason);
        } else {
            var value = this._rejectionHandler0;
            this._settlePromise0(this._fulfillmentHandler0, value, bitField);
            this._fulfillPromises(len, value);
        }
        this._setLength(0);
    }
    this._clearCancellationData();
};

Promise.prototype._settledValue = function() {
    var bitField = this._bitField;
    if (((bitField & 33554432) !== 0)) {
        return this._rejectionHandler0;
    } else if (((bitField & 16777216) !== 0)) {
        return this._fulfillmentHandler0;
    }
};

function deferResolve(v) {this.promise._resolveCallback(v);}
function deferReject(v) {this.promise._rejectCallback(v, false);}

Promise.defer = Promise.pending = function() {
    debug.deprecated("Promise.defer", "new Promise");
    var promise = new Promise(INTERNAL);
    return {
        promise: promise,
        resolve: deferResolve,
        reject: deferReject
    };
};

util.notEnumerableProp(Promise,
                       "_makeSelfResolutionError",
                       makeSelfResolutionError);

_dereq_("./method")(Promise, INTERNAL, tryConvertToPromise, apiRejection,
    debug);
_dereq_("./bind")(Promise, INTERNAL, tryConvertToPromise, debug);
_dereq_("./cancel")(Promise, PromiseArray, apiRejection, debug);
_dereq_("./direct_resolve")(Promise);
_dereq_("./synchronous_inspection")(Promise);
_dereq_("./join")(
    Promise, PromiseArray, tryConvertToPromise, INTERNAL, async, getDomain);
Promise.Promise = Promise;
Promise.version = "3.5.1";
_dereq_('./map.js')(Promise, PromiseArray, apiRejection, tryConvertToPromise, INTERNAL, debug);
_dereq_('./call_get.js')(Promise);
_dereq_('./using.js')(Promise, apiRejection, tryConvertToPromise, createContext, INTERNAL, debug);
_dereq_('./timers.js')(Promise, INTERNAL, debug);
_dereq_('./generators.js')(Promise, apiRejection, INTERNAL, tryConvertToPromise, Proxyable, debug);
_dereq_('./nodeify.js')(Promise);
_dereq_('./promisify.js')(Promise, INTERNAL);
_dereq_('./props.js')(Promise, PromiseArray, tryConvertToPromise, apiRejection);
_dereq_('./race.js')(Promise, INTERNAL, tryConvertToPromise, apiRejection);
_dereq_('./reduce.js')(Promise, PromiseArray, apiRejection, tryConvertToPromise, INTERNAL, debug);
_dereq_('./settle.js')(Promise, PromiseArray, debug);
_dereq_('./some.js')(Promise, PromiseArray, apiRejection);
_dereq_('./filter.js')(Promise, INTERNAL);
_dereq_('./each.js')(Promise, INTERNAL);
_dereq_('./any.js')(Promise);
                                                         
    util.toFastProperties(Promise);                                          
    util.toFastProperties(Promise.prototype);                                
    function fillTypes(value) {                                              
        var p = new Promise(INTERNAL);                                       
        p._fulfillmentHandler0 = value;                                      
        p._rejectionHandler0 = value;                                        
        p._promise0 = value;                                                 
        p._receiver0 = value;                                                
    }                                                                        
    // Complete slack tracking, opt out of field-type tracking and           
    // stabilize map                                                         
    fillTypes({a: 1});                                                       
    fillTypes({b: 2});                                                       
    fillTypes({c: 3});                                                       
    fillTypes(1);                                                            
    fillTypes(function(){});                                                 
    fillTypes(undefined);                                                    
    fillTypes(false);                                                        
    fillTypes(new Promise(INTERNAL));                                        
    debug.setBounds(Async.firstLineError, util.lastLineError);               
    return Promise;                                                          

};

},{"./any.js":1,"./async":2,"./bind":3,"./call_get.js":5,"./cancel":6,"./catch_filter":7,"./context":8,"./debuggability":9,"./direct_resolve":10,"./each.js":11,"./errors":12,"./es5":13,"./filter.js":14,"./finally":15,"./generators.js":16,"./join":17,"./map.js":18,"./method":19,"./nodeback":20,"./nodeify.js":21,"./promise_array":23,"./promisify.js":24,"./props.js":25,"./race.js":27,"./reduce.js":28,"./settle.js":30,"./some.js":31,"./synchronous_inspection":32,"./thenables":33,"./timers.js":34,"./using.js":35,"./util":36}],23:[function(_dereq_,module,exports){
"use strict";
module.exports = function(Promise, INTERNAL, tryConvertToPromise,
    apiRejection, Proxyable) {
var util = _dereq_("./util");
var isArray = util.isArray;

function toResolutionValue(val) {
    switch(val) {
    case -2: return [];
    case -3: return {};
    case -6: return new Map();
    }
}

function PromiseArray(values) {
    var promise = this._promise = new Promise(INTERNAL);
    if (values instanceof Promise) {
        promise._propagateFrom(values, 3);
    }
    promise._setOnCancel(this);
    this._values = values;
    this._length = 0;
    this._totalResolved = 0;
    this._init(undefined, -2);
}
util.inherits(PromiseArray, Proxyable);

PromiseArray.prototype.length = function () {
    return this._length;
};

PromiseArray.prototype.promise = function () {
    return this._promise;
};

PromiseArray.prototype._init = function init(_, resolveValueIfEmpty) {
    var values = tryConvertToPromise(this._values, this._promise);
    if (values instanceof Promise) {
        values = values._target();
        var bitField = values._bitField;
        ;
        this._values = values;

        if (((bitField & 50397184) === 0)) {
            this._promise._setAsyncGuaranteed();
            return values._then(
                init,
                this._reject,
                undefined,
                this,
                resolveValueIfEmpty
           );
        } else if (((bitField & 33554432) !== 0)) {
            values = values._value();
        } else if (((bitField & 16777216) !== 0)) {
            return this._reject(values._reason());
        } else {
            return this._cancel();
        }
    }
    values = util.asArray(values);
    if (values === null) {
        var err = apiRejection(
            "expecting an array or an iterable object but got " + util.classString(values)).reason();
        this._promise._rejectCallback(err, false);
        return;
    }

    if (values.length === 0) {
        if (resolveValueIfEmpty === -5) {
            this._resolveEmptyArray();
        }
        else {
            this._resolve(toResolutionValue(resolveValueIfEmpty));
        }
        return;
    }
    this._iterate(values);
};

PromiseArray.prototype._iterate = function(values) {
    var len = this.getActualLength(values.length);
    this._length = len;
    this._values = this.shouldCopyValues() ? new Array(len) : this._values;
    var result = this._promise;
    var isResolved = false;
    var bitField = null;
    for (var i = 0; i < len; ++i) {
        var maybePromise = tryConvertToPromise(values[i], result);

        if (maybePromise instanceof Promise) {
            maybePromise = maybePromise._target();
            bitField = maybePromise._bitField;
        } else {
            bitField = null;
        }

        if (isResolved) {
            if (bitField !== null) {
                maybePromise.suppressUnhandledRejections();
            }
        } else if (bitField !== null) {
            if (((bitField & 50397184) === 0)) {
                maybePromise._proxy(this, i);
                this._values[i] = maybePromise;
            } else if (((bitField & 33554432) !== 0)) {
                isResolved = this._promiseFulfilled(maybePromise._value(), i);
            } else if (((bitField & 16777216) !== 0)) {
                isResolved = this._promiseRejected(maybePromise._reason(), i);
            } else {
                isResolved = this._promiseCancelled(i);
            }
        } else {
            isResolved = this._promiseFulfilled(maybePromise, i);
        }
    }
    if (!isResolved) result._setAsyncGuaranteed();
};

PromiseArray.prototype._isResolved = function () {
    return this._values === null;
};

PromiseArray.prototype._resolve = function (value) {
    this._values = null;
    this._promise._fulfill(value);
};

PromiseArray.prototype._cancel = function() {
    if (this._isResolved() || !this._promise._isCancellable()) return;
    this._values = null;
    this._promise._cancel();
};

PromiseArray.prototype._reject = function (reason) {
    this._values = null;
    this._promise._rejectCallback(reason, false);
};

PromiseArray.prototype._promiseFulfilled = function (value, index) {
    this._values[index] = value;
    var totalResolved = ++this._totalResolved;
    if (totalResolved >= this._length) {
        this._resolve(this._values);
        return true;
    }
    return false;
};

PromiseArray.prototype._promiseCancelled = function() {
    this._cancel();
    return true;
};

PromiseArray.prototype._promiseRejected = function (reason) {
    this._totalResolved++;
    this._reject(reason);
    return true;
};

PromiseArray.prototype._resultCancelled = function() {
    if (this._isResolved()) return;
    var values = this._values;
    this._cancel();
    if (values instanceof Promise) {
        values.cancel();
    } else {
        for (var i = 0; i < values.length; ++i) {
            if (values[i] instanceof Promise) {
                values[i].cancel();
            }
        }
    }
};

PromiseArray.prototype.shouldCopyValues = function () {
    return true;
};

PromiseArray.prototype.getActualLength = function (len) {
    return len;
};

return PromiseArray;
};

},{"./util":36}],24:[function(_dereq_,module,exports){
"use strict";
module.exports = function(Promise, INTERNAL) {
var THIS = {};
var util = _dereq_("./util");
var nodebackForPromise = _dereq_("./nodeback");
var withAppended = util.withAppended;
var maybeWrapAsError = util.maybeWrapAsError;
var canEvaluate = util.canEvaluate;
var TypeError = _dereq_("./errors").TypeError;
var defaultSuffix = "Async";
var defaultPromisified = {__isPromisified__: true};
var noCopyProps = [
    "arity",    "length",
    "name",
    "arguments",
    "caller",
    "callee",
    "prototype",
    "__isPromisified__"
];
var noCopyPropsPattern = new RegExp("^(?:" + noCopyProps.join("|") + ")$");

var defaultFilter = function(name) {
    return util.isIdentifier(name) &&
        name.charAt(0) !== "_" &&
        name !== "constructor";
};

function propsFilter(key) {
    return !noCopyPropsPattern.test(key);
}

function isPromisified(fn) {
    try {
        return fn.__isPromisified__ === true;
    }
    catch (e) {
        return false;
    }
}

function hasPromisified(obj, key, suffix) {
    var val = util.getDataPropertyOrDefault(obj, key + suffix,
                                            defaultPromisified);
    return val ? isPromisified(val) : false;
}
function checkValid(ret, suffix, suffixRegexp) {
    for (var i = 0; i < ret.length; i += 2) {
        var key = ret[i];
        if (suffixRegexp.test(key)) {
            var keyWithoutAsyncSuffix = key.replace(suffixRegexp, "");
            for (var j = 0; j < ret.length; j += 2) {
                if (ret[j] === keyWithoutAsyncSuffix) {
                    throw new TypeError("Cannot promisify an API that has normal methods with '%s'-suffix\u000a\u000a    See http://goo.gl/MqrFmX\u000a"
                        .replace("%s", suffix));
                }
            }
        }
    }
}

function promisifiableMethods(obj, suffix, suffixRegexp, filter) {
    var keys = util.inheritedDataKeys(obj);
    var ret = [];
    for (var i = 0; i < keys.length; ++i) {
        var key = keys[i];
        var value = obj[key];
        var passesDefaultFilter = filter === defaultFilter
            ? true : defaultFilter(key, value, obj);
        if (typeof value === "function" &&
            !isPromisified(value) &&
            !hasPromisified(obj, key, suffix) &&
            filter(key, value, obj, passesDefaultFilter)) {
            ret.push(key, value);
        }
    }
    checkValid(ret, suffix, suffixRegexp);
    return ret;
}

var escapeIdentRegex = function(str) {
    return str.replace(/([$])/, "\\$");
};

var makeNodePromisifiedEval;
if (!true) {
var switchCaseArgumentOrder = function(likelyArgumentCount) {
    var ret = [likelyArgumentCount];
    var min = Math.max(0, likelyArgumentCount - 1 - 3);
    for(var i = likelyArgumentCount - 1; i >= min; --i) {
        ret.push(i);
    }
    for(var i = likelyArgumentCount + 1; i <= 3; ++i) {
        ret.push(i);
    }
    return ret;
};

var argumentSequence = function(argumentCount) {
    return util.filledRange(argumentCount, "_arg", "");
};

var parameterDeclaration = function(parameterCount) {
    return util.filledRange(
        Math.max(parameterCount, 3), "_arg", "");
};

var parameterCount = function(fn) {
    if (typeof fn.length === "number") {
        return Math.max(Math.min(fn.length, 1023 + 1), 0);
    }
    return 0;
};

makeNodePromisifiedEval =
function(callback, receiver, originalName, fn, _, multiArgs) {
    var newParameterCount = Math.max(0, parameterCount(fn) - 1);
    var argumentOrder = switchCaseArgumentOrder(newParameterCount);
    var shouldProxyThis = typeof callback === "string" || receiver === THIS;

    function generateCallForArgumentCount(count) {
        var args = argumentSequence(count).join(", ");
        var comma = count > 0 ? ", " : "";
        var ret;
        if (shouldProxyThis) {
            ret = "ret = callback.call(this, {{args}}, nodeback); break;\n";
        } else {
            ret = receiver === undefined
                ? "ret = callback({{args}}, nodeback); break;\n"
                : "ret = callback.call(receiver, {{args}}, nodeback); break;\n";
        }
        return ret.replace("{{args}}", args).replace(", ", comma);
    }

    function generateArgumentSwitchCase() {
        var ret = "";
        for (var i = 0; i < argumentOrder.length; ++i) {
            ret += "case " + argumentOrder[i] +":" +
                generateCallForArgumentCount(argumentOrder[i]);
        }

        ret += "                                                             \n\
        default:                                                             \n\
            var args = new Array(len + 1);                                   \n\
            var i = 0;                                                       \n\
            for (var i = 0; i < len; ++i) {                                  \n\
               args[i] = arguments[i];                                       \n\
            }                                                                \n\
            args[i] = nodeback;                                              \n\
            [CodeForCall]                                                    \n\
            break;                                                           \n\
        ".replace("[CodeForCall]", (shouldProxyThis
                                ? "ret = callback.apply(this, args);\n"
                                : "ret = callback.apply(receiver, args);\n"));
        return ret;
    }

    var getFunctionCode = typeof callback === "string"
                                ? ("this != null ? this['"+callback+"'] : fn")
                                : "fn";
    var body = "'use strict';                                                \n\
        var ret = function (Parameters) {                                    \n\
            'use strict';                                                    \n\
            var len = arguments.length;                                      \n\
            var promise = new Promise(INTERNAL);                             \n\
            promise._captureStackTrace();                                    \n\
            var nodeback = nodebackForPromise(promise, " + multiArgs + ");   \n\
            var ret;                                                         \n\
            var callback = tryCatch([GetFunctionCode]);                      \n\
            switch(len) {                                                    \n\
                [CodeForSwitchCase]                                          \n\
            }                                                                \n\
            if (ret === errorObj) {                                          \n\
                promise._rejectCallback(maybeWrapAsError(ret.e), true, true);\n\
            }                                                                \n\
            if (!promise._isFateSealed()) promise._setAsyncGuaranteed();     \n\
            return promise;                                                  \n\
        };                                                                   \n\
        notEnumerableProp(ret, '__isPromisified__', true);                   \n\
        return ret;                                                          \n\
    ".replace("[CodeForSwitchCase]", generateArgumentSwitchCase())
        .replace("[GetFunctionCode]", getFunctionCode);
    body = body.replace("Parameters", parameterDeclaration(newParameterCount));
    return new Function("Promise",
                        "fn",
                        "receiver",
                        "withAppended",
                        "maybeWrapAsError",
                        "nodebackForPromise",
                        "tryCatch",
                        "errorObj",
                        "notEnumerableProp",
                        "INTERNAL",
                        body)(
                    Promise,
                    fn,
                    receiver,
                    withAppended,
                    maybeWrapAsError,
                    nodebackForPromise,
                    util.tryCatch,
                    util.errorObj,
                    util.notEnumerableProp,
                    INTERNAL);
};
}

function makeNodePromisifiedClosure(callback, receiver, _, fn, __, multiArgs) {
    var defaultThis = (function() {return this;})();
    var method = callback;
    if (typeof method === "string") {
        callback = fn;
    }
    function promisified() {
        var _receiver = receiver;
        if (receiver === THIS) _receiver = this;
        var promise = new Promise(INTERNAL);
        promise._captureStackTrace();
        var cb = typeof method === "string" && this !== defaultThis
            ? this[method] : callback;
        var fn = nodebackForPromise(promise, multiArgs);
        try {
            cb.apply(_receiver, withAppended(arguments, fn));
        } catch(e) {
            promise._rejectCallback(maybeWrapAsError(e), true, true);
        }
        if (!promise._isFateSealed()) promise._setAsyncGuaranteed();
        return promise;
    }
    util.notEnumerableProp(promisified, "__isPromisified__", true);
    return promisified;
}

var makeNodePromisified = canEvaluate
    ? makeNodePromisifiedEval
    : makeNodePromisifiedClosure;

function promisifyAll(obj, suffix, filter, promisifier, multiArgs) {
    var suffixRegexp = new RegExp(escapeIdentRegex(suffix) + "$");
    var methods =
        promisifiableMethods(obj, suffix, suffixRegexp, filter);

    for (var i = 0, len = methods.length; i < len; i+= 2) {
        var key = methods[i];
        var fn = methods[i+1];
        var promisifiedKey = key + suffix;
        if (promisifier === makeNodePromisified) {
            obj[promisifiedKey] =
                makeNodePromisified(key, THIS, key, fn, suffix, multiArgs);
        } else {
            var promisified = promisifier(fn, function() {
                return makeNodePromisified(key, THIS, key,
                                           fn, suffix, multiArgs);
            });
            util.notEnumerableProp(promisified, "__isPromisified__", true);
            obj[promisifiedKey] = promisified;
        }
    }
    util.toFastProperties(obj);
    return obj;
}

function promisify(callback, receiver, multiArgs) {
    return makeNodePromisified(callback, receiver, undefined,
                                callback, null, multiArgs);
}

Promise.promisify = function (fn, options) {
    if (typeof fn !== "function") {
        throw new TypeError("expecting a function but got " + util.classString(fn));
    }
    if (isPromisified(fn)) {
        return fn;
    }
    options = Object(options);
    var receiver = options.context === undefined ? THIS : options.context;
    var multiArgs = !!options.multiArgs;
    var ret = promisify(fn, receiver, multiArgs);
    util.copyDescriptors(fn, ret, propsFilter);
    return ret;
};

Promise.promisifyAll = function (target, options) {
    if (typeof target !== "function" && typeof target !== "object") {
        throw new TypeError("the target of promisifyAll must be an object or a function\u000a\u000a    See http://goo.gl/MqrFmX\u000a");
    }
    options = Object(options);
    var multiArgs = !!options.multiArgs;
    var suffix = options.suffix;
    if (typeof suffix !== "string") suffix = defaultSuffix;
    var filter = options.filter;
    if (typeof filter !== "function") filter = defaultFilter;
    var promisifier = options.promisifier;
    if (typeof promisifier !== "function") promisifier = makeNodePromisified;

    if (!util.isIdentifier(suffix)) {
        throw new RangeError("suffix must be a valid identifier\u000a\u000a    See http://goo.gl/MqrFmX\u000a");
    }

    var keys = util.inheritedDataKeys(target);
    for (var i = 0; i < keys.length; ++i) {
        var value = target[keys[i]];
        if (keys[i] !== "constructor" &&
            util.isClass(value)) {
            promisifyAll(value.prototype, suffix, filter, promisifier,
                multiArgs);
            promisifyAll(value, suffix, filter, promisifier, multiArgs);
        }
    }

    return promisifyAll(target, suffix, filter, promisifier, multiArgs);
};
};


},{"./errors":12,"./nodeback":20,"./util":36}],25:[function(_dereq_,module,exports){
"use strict";
module.exports = function(
    Promise, PromiseArray, tryConvertToPromise, apiRejection) {
var util = _dereq_("./util");
var isObject = util.isObject;
var es5 = _dereq_("./es5");
var Es6Map;
if (typeof Map === "function") Es6Map = Map;

var mapToEntries = (function() {
    var index = 0;
    var size = 0;

    function extractEntry(value, key) {
        this[index] = value;
        this[index + size] = key;
        index++;
    }

    return function mapToEntries(map) {
        size = map.size;
        index = 0;
        var ret = new Array(map.size * 2);
        map.forEach(extractEntry, ret);
        return ret;
    };
})();

var entriesToMap = function(entries) {
    var ret = new Es6Map();
    var length = entries.length / 2 | 0;
    for (var i = 0; i < length; ++i) {
        var key = entries[length + i];
        var value = entries[i];
        ret.set(key, value);
    }
    return ret;
};

function PropertiesPromiseArray(obj) {
    var isMap = false;
    var entries;
    if (Es6Map !== undefined && obj instanceof Es6Map) {
        entries = mapToEntries(obj);
        isMap = true;
    } else {
        var keys = es5.keys(obj);
        var len = keys.length;
        entries = new Array(len * 2);
        for (var i = 0; i < len; ++i) {
            var key = keys[i];
            entries[i] = obj[key];
            entries[i + len] = key;
        }
    }
    this.constructor$(entries);
    this._isMap = isMap;
    this._init$(undefined, isMap ? -6 : -3);
}
util.inherits(PropertiesPromiseArray, PromiseArray);

PropertiesPromiseArray.prototype._init = function () {};

PropertiesPromiseArray.prototype._promiseFulfilled = function (value, index) {
    this._values[index] = value;
    var totalResolved = ++this._totalResolved;
    if (totalResolved >= this._length) {
        var val;
        if (this._isMap) {
            val = entriesToMap(this._values);
        } else {
            val = {};
            var keyOffset = this.length();
            for (var i = 0, len = this.length(); i < len; ++i) {
                val[this._values[i + keyOffset]] = this._values[i];
            }
        }
        this._resolve(val);
        return true;
    }
    return false;
};

PropertiesPromiseArray.prototype.shouldCopyValues = function () {
    return false;
};

PropertiesPromiseArray.prototype.getActualLength = function (len) {
    return len >> 1;
};

function props(promises) {
    var ret;
    var castValue = tryConvertToPromise(promises);

    if (!isObject(castValue)) {
        return apiRejection("cannot await properties of a non-object\u000a\u000a    See http://goo.gl/MqrFmX\u000a");
    } else if (castValue instanceof Promise) {
        ret = castValue._then(
            Promise.props, undefined, undefined, undefined, undefined);
    } else {
        ret = new PropertiesPromiseArray(castValue).promise();
    }

    if (castValue instanceof Promise) {
        ret._propagateFrom(castValue, 2);
    }
    return ret;
}

Promise.prototype.props = function () {
    return props(this);
};

Promise.props = function (promises) {
    return props(promises);
};
};

},{"./es5":13,"./util":36}],26:[function(_dereq_,module,exports){
"use strict";
function arrayMove(src, srcIndex, dst, dstIndex, len) {
    for (var j = 0; j < len; ++j) {
        dst[j + dstIndex] = src[j + srcIndex];
        src[j + srcIndex] = void 0;
    }
}

function Queue(capacity) {
    this._capacity = capacity;
    this._length = 0;
    this._front = 0;
}

Queue.prototype._willBeOverCapacity = function (size) {
    return this._capacity < size;
};

Queue.prototype._pushOne = function (arg) {
    var length = this.length();
    this._checkCapacity(length + 1);
    var i = (this._front + length) & (this._capacity - 1);
    this[i] = arg;
    this._length = length + 1;
};

Queue.prototype.push = function (fn, receiver, arg) {
    var length = this.length() + 3;
    if (this._willBeOverCapacity(length)) {
        this._pushOne(fn);
        this._pushOne(receiver);
        this._pushOne(arg);
        return;
    }
    var j = this._front + length - 3;
    this._checkCapacity(length);
    var wrapMask = this._capacity - 1;
    this[(j + 0) & wrapMask] = fn;
    this[(j + 1) & wrapMask] = receiver;
    this[(j + 2) & wrapMask] = arg;
    this._length = length;
};

Queue.prototype.shift = function () {
    var front = this._front,
        ret = this[front];

    this[front] = undefined;
    this._front = (front + 1) & (this._capacity - 1);
    this._length--;
    return ret;
};

Queue.prototype.length = function () {
    return this._length;
};

Queue.prototype._checkCapacity = function (size) {
    if (this._capacity < size) {
        this._resizeTo(this._capacity << 1);
    }
};

Queue.prototype._resizeTo = function (capacity) {
    var oldCapacity = this._capacity;
    this._capacity = capacity;
    var front = this._front;
    var length = this._length;
    var moveItemsCount = (front + length) & (oldCapacity - 1);
    arrayMove(this, 0, this, oldCapacity, moveItemsCount);
};

module.exports = Queue;

},{}],27:[function(_dereq_,module,exports){
"use strict";
module.exports = function(
    Promise, INTERNAL, tryConvertToPromise, apiRejection) {
var util = _dereq_("./util");

var raceLater = function (promise) {
    return promise.then(function(array) {
        return race(array, promise);
    });
};

function race(promises, parent) {
    var maybePromise = tryConvertToPromise(promises);

    if (maybePromise instanceof Promise) {
        return raceLater(maybePromise);
    } else {
        promises = util.asArray(promises);
        if (promises === null)
            return apiRejection("expecting an array or an iterable object but got " + util.classString(promises));
    }

    var ret = new Promise(INTERNAL);
    if (parent !== undefined) {
        ret._propagateFrom(parent, 3);
    }
    var fulfill = ret._fulfill;
    var reject = ret._reject;
    for (var i = 0, len = promises.length; i < len; ++i) {
        var val = promises[i];

        if (val === undefined && !(i in promises)) {
            continue;
        }

        Promise.cast(val)._then(fulfill, reject, undefined, ret, null);
    }
    return ret;
}

Promise.race = function (promises) {
    return race(promises, undefined);
};

Promise.prototype.race = function () {
    return race(this, undefined);
};

};

},{"./util":36}],28:[function(_dereq_,module,exports){
"use strict";
module.exports = function(Promise,
                          PromiseArray,
                          apiRejection,
                          tryConvertToPromise,
                          INTERNAL,
                          debug) {
var getDomain = Promise._getDomain;
var util = _dereq_("./util");
var tryCatch = util.tryCatch;

function ReductionPromiseArray(promises, fn, initialValue, _each) {
    this.constructor$(promises);
    var domain = getDomain();
    this._fn = domain === null ? fn : util.domainBind(domain, fn);
    if (initialValue !== undefined) {
        initialValue = Promise.resolve(initialValue);
        initialValue._attachCancellationCallback(this);
    }
    this._initialValue = initialValue;
    this._currentCancellable = null;
    if(_each === INTERNAL) {
        this._eachValues = Array(this._length);
    } else if (_each === 0) {
        this._eachValues = null;
    } else {
        this._eachValues = undefined;
    }
    this._promise._captureStackTrace();
    this._init$(undefined, -5);
}
util.inherits(ReductionPromiseArray, PromiseArray);

ReductionPromiseArray.prototype._gotAccum = function(accum) {
    if (this._eachValues !== undefined && 
        this._eachValues !== null && 
        accum !== INTERNAL) {
        this._eachValues.push(accum);
    }
};

ReductionPromiseArray.prototype._eachComplete = function(value) {
    if (this._eachValues !== null) {
        this._eachValues.push(value);
    }
    return this._eachValues;
};

ReductionPromiseArray.prototype._init = function() {};

ReductionPromiseArray.prototype._resolveEmptyArray = function() {
    this._resolve(this._eachValues !== undefined ? this._eachValues
                                                 : this._initialValue);
};

ReductionPromiseArray.prototype.shouldCopyValues = function () {
    return false;
};

ReductionPromiseArray.prototype._resolve = function(value) {
    this._promise._resolveCallback(value);
    this._values = null;
};

ReductionPromiseArray.prototype._resultCancelled = function(sender) {
    if (sender === this._initialValue) return this._cancel();
    if (this._isResolved()) return;
    this._resultCancelled$();
    if (this._currentCancellable instanceof Promise) {
        this._currentCancellable.cancel();
    }
    if (this._initialValue instanceof Promise) {
        this._initialValue.cancel();
    }
};

ReductionPromiseArray.prototype._iterate = function (values) {
    this._values = values;
    var value;
    var i;
    var length = values.length;
    if (this._initialValue !== undefined) {
        value = this._initialValue;
        i = 0;
    } else {
        value = Promise.resolve(values[0]);
        i = 1;
    }

    this._currentCancellable = value;

    if (!value.isRejected()) {
        for (; i < length; ++i) {
            var ctx = {
                accum: null,
                value: values[i],
                index: i,
                length: length,
                array: this
            };
            value = value._then(gotAccum, undefined, undefined, ctx, undefined);
        }
    }

    if (this._eachValues !== undefined) {
        value = value
            ._then(this._eachComplete, undefined, undefined, this, undefined);
    }
    value._then(completed, completed, undefined, value, this);
};

Promise.prototype.reduce = function (fn, initialValue) {
    return reduce(this, fn, initialValue, null);
};

Promise.reduce = function (promises, fn, initialValue, _each) {
    return reduce(promises, fn, initialValue, _each);
};

function completed(valueOrReason, array) {
    if (this.isFulfilled()) {
        array._resolve(valueOrReason);
    } else {
        array._reject(valueOrReason);
    }
}

function reduce(promises, fn, initialValue, _each) {
    if (typeof fn !== "function") {
        return apiRejection("expecting a function but got " + util.classString(fn));
    }
    var array = new ReductionPromiseArray(promises, fn, initialValue, _each);
    return array.promise();
}

function gotAccum(accum) {
    this.accum = accum;
    this.array._gotAccum(accum);
    var value = tryConvertToPromise(this.value, this.array._promise);
    if (value instanceof Promise) {
        this.array._currentCancellable = value;
        return value._then(gotValue, undefined, undefined, this, undefined);
    } else {
        return gotValue.call(this, value);
    }
}

function gotValue(value) {
    var array = this.array;
    var promise = array._promise;
    var fn = tryCatch(array._fn);
    promise._pushContext();
    var ret;
    if (array._eachValues !== undefined) {
        ret = fn.call(promise._boundValue(), value, this.index, this.length);
    } else {
        ret = fn.call(promise._boundValue(),
                              this.accum, value, this.index, this.length);
    }
    if (ret instanceof Promise) {
        array._currentCancellable = ret;
    }
    var promiseCreated = promise._popContext();
    debug.checkForgottenReturns(
        ret,
        promiseCreated,
        array._eachValues !== undefined ? "Promise.each" : "Promise.reduce",
        promise
    );
    return ret;
}
};

},{"./util":36}],29:[function(_dereq_,module,exports){
"use strict";
var util = _dereq_("./util");
var schedule;
var noAsyncScheduler = function() {
    throw new Error("No async scheduler available\u000a\u000a    See http://goo.gl/MqrFmX\u000a");
};
var NativePromise = util.getNativePromise();
if (util.isNode && typeof MutationObserver === "undefined") {
    var GlobalSetImmediate = global.setImmediate;
    var ProcessNextTick = process.nextTick;
    schedule = util.isRecentNode
                ? function(fn) { GlobalSetImmediate.call(global, fn); }
                : function(fn) { ProcessNextTick.call(process, fn); };
} else if (typeof NativePromise === "function" &&
           typeof NativePromise.resolve === "function") {
    var nativePromise = NativePromise.resolve();
    schedule = function(fn) {
        nativePromise.then(fn);
    };
} else if ((typeof MutationObserver !== "undefined") &&
          !(typeof window !== "undefined" &&
            window.navigator &&
            (window.navigator.standalone || window.cordova))) {
    schedule = (function() {
        var div = document.createElement("div");
        var opts = {attributes: true};
        var toggleScheduled = false;
        var div2 = document.createElement("div");
        var o2 = new MutationObserver(function() {
            div.classList.toggle("foo");
            toggleScheduled = false;
        });
        o2.observe(div2, opts);

        var scheduleToggle = function() {
            if (toggleScheduled) return;
            toggleScheduled = true;
            div2.classList.toggle("foo");
        };

        return function schedule(fn) {
            var o = new MutationObserver(function() {
                o.disconnect();
                fn();
            });
            o.observe(div, opts);
            scheduleToggle();
        };
    })();
} else if (typeof setImmediate !== "undefined") {
    schedule = function (fn) {
        setImmediate(fn);
    };
} else if (typeof setTimeout !== "undefined") {
    schedule = function (fn) {
        setTimeout(fn, 0);
    };
} else {
    schedule = noAsyncScheduler;
}
module.exports = schedule;

},{"./util":36}],30:[function(_dereq_,module,exports){
"use strict";
module.exports =
    function(Promise, PromiseArray, debug) {
var PromiseInspection = Promise.PromiseInspection;
var util = _dereq_("./util");

function SettledPromiseArray(values) {
    this.constructor$(values);
}
util.inherits(SettledPromiseArray, PromiseArray);

SettledPromiseArray.prototype._promiseResolved = function (index, inspection) {
    this._values[index] = inspection;
    var totalResolved = ++this._totalResolved;
    if (totalResolved >= this._length) {
        this._resolve(this._values);
        return true;
    }
    return false;
};

SettledPromiseArray.prototype._promiseFulfilled = function (value, index) {
    var ret = new PromiseInspection();
    ret._bitField = 33554432;
    ret._settledValueField = value;
    return this._promiseResolved(index, ret);
};
SettledPromiseArray.prototype._promiseRejected = function (reason, index) {
    var ret = new PromiseInspection();
    ret._bitField = 16777216;
    ret._settledValueField = reason;
    return this._promiseResolved(index, ret);
};

Promise.settle = function (promises) {
    debug.deprecated(".settle()", ".reflect()");
    return new SettledPromiseArray(promises).promise();
};

Promise.prototype.settle = function () {
    return Promise.settle(this);
};
};

},{"./util":36}],31:[function(_dereq_,module,exports){
"use strict";
module.exports =
function(Promise, PromiseArray, apiRejection) {
var util = _dereq_("./util");
var RangeError = _dereq_("./errors").RangeError;
var AggregateError = _dereq_("./errors").AggregateError;
var isArray = util.isArray;
var CANCELLATION = {};


function SomePromiseArray(values) {
    this.constructor$(values);
    this._howMany = 0;
    this._unwrap = false;
    this._initialized = false;
}
util.inherits(SomePromiseArray, PromiseArray);

SomePromiseArray.prototype._init = function () {
    if (!this._initialized) {
        return;
    }
    if (this._howMany === 0) {
        this._resolve([]);
        return;
    }
    this._init$(undefined, -5);
    var isArrayResolved = isArray(this._values);
    if (!this._isResolved() &&
        isArrayResolved &&
        this._howMany > this._canPossiblyFulfill()) {
        this._reject(this._getRangeError(this.length()));
    }
};

SomePromiseArray.prototype.init = function () {
    this._initialized = true;
    this._init();
};

SomePromiseArray.prototype.setUnwrap = function () {
    this._unwrap = true;
};

SomePromiseArray.prototype.howMany = function () {
    return this._howMany;
};

SomePromiseArray.prototype.setHowMany = function (count) {
    this._howMany = count;
};

SomePromiseArray.prototype._promiseFulfilled = function (value) {
    this._addFulfilled(value);
    if (this._fulfilled() === this.howMany()) {
        this._values.length = this.howMany();
        if (this.howMany() === 1 && this._unwrap) {
            this._resolve(this._values[0]);
        } else {
            this._resolve(this._values);
        }
        return true;
    }
    return false;

};
SomePromiseArray.prototype._promiseRejected = function (reason) {
    this._addRejected(reason);
    return this._checkOutcome();
};

SomePromiseArray.prototype._promiseCancelled = function () {
    if (this._values instanceof Promise || this._values == null) {
        return this._cancel();
    }
    this._addRejected(CANCELLATION);
    return this._checkOutcome();
};

SomePromiseArray.prototype._checkOutcome = function() {
    if (this.howMany() > this._canPossiblyFulfill()) {
        var e = new AggregateError();
        for (var i = this.length(); i < this._values.length; ++i) {
            if (this._values[i] !== CANCELLATION) {
                e.push(this._values[i]);
            }
        }
        if (e.length > 0) {
            this._reject(e);
        } else {
            this._cancel();
        }
        return true;
    }
    return false;
};

SomePromiseArray.prototype._fulfilled = function () {
    return this._totalResolved;
};

SomePromiseArray.prototype._rejected = function () {
    return this._values.length - this.length();
};

SomePromiseArray.prototype._addRejected = function (reason) {
    this._values.push(reason);
};

SomePromiseArray.prototype._addFulfilled = function (value) {
    this._values[this._totalResolved++] = value;
};

SomePromiseArray.prototype._canPossiblyFulfill = function () {
    return this.length() - this._rejected();
};

SomePromiseArray.prototype._getRangeError = function (count) {
    var message = "Input array must contain at least " +
            this._howMany + " items but contains only " + count + " items";
    return new RangeError(message);
};

SomePromiseArray.prototype._resolveEmptyArray = function () {
    this._reject(this._getRangeError(0));
};

function some(promises, howMany) {
    if ((howMany | 0) !== howMany || howMany < 0) {
        return apiRejection("expecting a positive integer\u000a\u000a    See http://goo.gl/MqrFmX\u000a");
    }
    var ret = new SomePromiseArray(promises);
    var promise = ret.promise();
    ret.setHowMany(howMany);
    ret.init();
    return promise;
}

Promise.some = function (promises, howMany) {
    return some(promises, howMany);
};

Promise.prototype.some = function (howMany) {
    return some(this, howMany);
};

Promise._SomePromiseArray = SomePromiseArray;
};

},{"./errors":12,"./util":36}],32:[function(_dereq_,module,exports){
"use strict";
module.exports = function(Promise) {
function PromiseInspection(promise) {
    if (promise !== undefined) {
        promise = promise._target();
        this._bitField = promise._bitField;
        this._settledValueField = promise._isFateSealed()
            ? promise._settledValue() : undefined;
    }
    else {
        this._bitField = 0;
        this._settledValueField = undefined;
    }
}

PromiseInspection.prototype._settledValue = function() {
    return this._settledValueField;
};

var value = PromiseInspection.prototype.value = function () {
    if (!this.isFulfilled()) {
        throw new TypeError("cannot get fulfillment value of a non-fulfilled promise\u000a\u000a    See http://goo.gl/MqrFmX\u000a");
    }
    return this._settledValue();
};

var reason = PromiseInspection.prototype.error =
PromiseInspection.prototype.reason = function () {
    if (!this.isRejected()) {
        throw new TypeError("cannot get rejection reason of a non-rejected promise\u000a\u000a    See http://goo.gl/MqrFmX\u000a");
    }
    return this._settledValue();
};

var isFulfilled = PromiseInspection.prototype.isFulfilled = function() {
    return (this._bitField & 33554432) !== 0;
};

var isRejected = PromiseInspection.prototype.isRejected = function () {
    return (this._bitField & 16777216) !== 0;
};

var isPending = PromiseInspection.prototype.isPending = function () {
    return (this._bitField & 50397184) === 0;
};

var isResolved = PromiseInspection.prototype.isResolved = function () {
    return (this._bitField & 50331648) !== 0;
};

PromiseInspection.prototype.isCancelled = function() {
    return (this._bitField & 8454144) !== 0;
};

Promise.prototype.__isCancelled = function() {
    return (this._bitField & 65536) === 65536;
};

Promise.prototype._isCancelled = function() {
    return this._target().__isCancelled();
};

Promise.prototype.isCancelled = function() {
    return (this._target()._bitField & 8454144) !== 0;
};

Promise.prototype.isPending = function() {
    return isPending.call(this._target());
};

Promise.prototype.isRejected = function() {
    return isRejected.call(this._target());
};

Promise.prototype.isFulfilled = function() {
    return isFulfilled.call(this._target());
};

Promise.prototype.isResolved = function() {
    return isResolved.call(this._target());
};

Promise.prototype.value = function() {
    return value.call(this._target());
};

Promise.prototype.reason = function() {
    var target = this._target();
    target._unsetRejectionIsUnhandled();
    return reason.call(target);
};

Promise.prototype._value = function() {
    return this._settledValue();
};

Promise.prototype._reason = function() {
    this._unsetRejectionIsUnhandled();
    return this._settledValue();
};

Promise.PromiseInspection = PromiseInspection;
};

},{}],33:[function(_dereq_,module,exports){
"use strict";
module.exports = function(Promise, INTERNAL) {
var util = _dereq_("./util");
var errorObj = util.errorObj;
var isObject = util.isObject;

function tryConvertToPromise(obj, context) {
    if (isObject(obj)) {
        if (obj instanceof Promise) return obj;
        var then = getThen(obj);
        if (then === errorObj) {
            if (context) context._pushContext();
            var ret = Promise.reject(then.e);
            if (context) context._popContext();
            return ret;
        } else if (typeof then === "function") {
            if (isAnyBluebirdPromise(obj)) {
                var ret = new Promise(INTERNAL);
                obj._then(
                    ret._fulfill,
                    ret._reject,
                    undefined,
                    ret,
                    null
                );
                return ret;
            }
            return doThenable(obj, then, context);
        }
    }
    return obj;
}

function doGetThen(obj) {
    return obj.then;
}

function getThen(obj) {
    try {
        return doGetThen(obj);
    } catch (e) {
        errorObj.e = e;
        return errorObj;
    }
}

var hasProp = {}.hasOwnProperty;
function isAnyBluebirdPromise(obj) {
    try {
        return hasProp.call(obj, "_promise0");
    } catch (e) {
        return false;
    }
}

function doThenable(x, then, context) {
    var promise = new Promise(INTERNAL);
    var ret = promise;
    if (context) context._pushContext();
    promise._captureStackTrace();
    if (context) context._popContext();
    var synchronous = true;
    var result = util.tryCatch(then).call(x, resolve, reject);
    synchronous = false;

    if (promise && result === errorObj) {
        promise._rejectCallback(result.e, true, true);
        promise = null;
    }

    function resolve(value) {
        if (!promise) return;
        promise._resolveCallback(value);
        promise = null;
    }

    function reject(reason) {
        if (!promise) return;
        promise._rejectCallback(reason, synchronous, true);
        promise = null;
    }
    return ret;
}

return tryConvertToPromise;
};

},{"./util":36}],34:[function(_dereq_,module,exports){
"use strict";
module.exports = function(Promise, INTERNAL, debug) {
var util = _dereq_("./util");
var TimeoutError = Promise.TimeoutError;

function HandleWrapper(handle)  {
    this.handle = handle;
}

HandleWrapper.prototype._resultCancelled = function() {
    clearTimeout(this.handle);
};

var afterValue = function(value) { return delay(+this).thenReturn(value); };
var delay = Promise.delay = function (ms, value) {
    var ret;
    var handle;
    if (value !== undefined) {
        ret = Promise.resolve(value)
                ._then(afterValue, null, null, ms, undefined);
        if (debug.cancellation() && value instanceof Promise) {
            ret._setOnCancel(value);
        }
    } else {
        ret = new Promise(INTERNAL);
        handle = setTimeout(function() { ret._fulfill(); }, +ms);
        if (debug.cancellation()) {
            ret._setOnCancel(new HandleWrapper(handle));
        }
        ret._captureStackTrace();
    }
    ret._setAsyncGuaranteed();
    return ret;
};

Promise.prototype.delay = function (ms) {
    return delay(ms, this);
};

var afterTimeout = function (promise, message, parent) {
    var err;
    if (typeof message !== "string") {
        if (message instanceof Error) {
            err = message;
        } else {
            err = new TimeoutError("operation timed out");
        }
    } else {
        err = new TimeoutError(message);
    }
    util.markAsOriginatingFromRejection(err);
    promise._attachExtraTrace(err);
    promise._reject(err);

    if (parent != null) {
        parent.cancel();
    }
};

function successClear(value) {
    clearTimeout(this.handle);
    return value;
}

function failureClear(reason) {
    clearTimeout(this.handle);
    throw reason;
}

Promise.prototype.timeout = function (ms, message) {
    ms = +ms;
    var ret, parent;

    var handleWrapper = new HandleWrapper(setTimeout(function timeoutTimeout() {
        if (ret.isPending()) {
            afterTimeout(ret, message, parent);
        }
    }, ms));

    if (debug.cancellation()) {
        parent = this.then();
        ret = parent._then(successClear, failureClear,
                            undefined, handleWrapper, undefined);
        ret._setOnCancel(handleWrapper);
    } else {
        ret = this._then(successClear, failureClear,
                            undefined, handleWrapper, undefined);
    }

    return ret;
};

};

},{"./util":36}],35:[function(_dereq_,module,exports){
"use strict";
module.exports = function (Promise, apiRejection, tryConvertToPromise,
    createContext, INTERNAL, debug) {
    var util = _dereq_("./util");
    var TypeError = _dereq_("./errors").TypeError;
    var inherits = _dereq_("./util").inherits;
    var errorObj = util.errorObj;
    var tryCatch = util.tryCatch;
    var NULL = {};

    function thrower(e) {
        setTimeout(function(){throw e;}, 0);
    }

    function castPreservingDisposable(thenable) {
        var maybePromise = tryConvertToPromise(thenable);
        if (maybePromise !== thenable &&
            typeof thenable._isDisposable === "function" &&
            typeof thenable._getDisposer === "function" &&
            thenable._isDisposable()) {
            maybePromise._setDisposable(thenable._getDisposer());
        }
        return maybePromise;
    }
    function dispose(resources, inspection) {
        var i = 0;
        var len = resources.length;
        var ret = new Promise(INTERNAL);
        function iterator() {
            if (i >= len) return ret._fulfill();
            var maybePromise = castPreservingDisposable(resources[i++]);
            if (maybePromise instanceof Promise &&
                maybePromise._isDisposable()) {
                try {
                    maybePromise = tryConvertToPromise(
                        maybePromise._getDisposer().tryDispose(inspection),
                        resources.promise);
                } catch (e) {
                    return thrower(e);
                }
                if (maybePromise instanceof Promise) {
                    return maybePromise._then(iterator, thrower,
                                              null, null, null);
                }
            }
            iterator();
        }
        iterator();
        return ret;
    }

    function Disposer(data, promise, context) {
        this._data = data;
        this._promise = promise;
        this._context = context;
    }

    Disposer.prototype.data = function () {
        return this._data;
    };

    Disposer.prototype.promise = function () {
        return this._promise;
    };

    Disposer.prototype.resource = function () {
        if (this.promise().isFulfilled()) {
            return this.promise().value();
        }
        return NULL;
    };

    Disposer.prototype.tryDispose = function(inspection) {
        var resource = this.resource();
        var context = this._context;
        if (context !== undefined) context._pushContext();
        var ret = resource !== NULL
            ? this.doDispose(resource, inspection) : null;
        if (context !== undefined) context._popContext();
        this._promise._unsetDisposable();
        this._data = null;
        return ret;
    };

    Disposer.isDisposer = function (d) {
        return (d != null &&
                typeof d.resource === "function" &&
                typeof d.tryDispose === "function");
    };

    function FunctionDisposer(fn, promise, context) {
        this.constructor$(fn, promise, context);
    }
    inherits(FunctionDisposer, Disposer);

    FunctionDisposer.prototype.doDispose = function (resource, inspection) {
        var fn = this.data();
        return fn.call(resource, resource, inspection);
    };

    function maybeUnwrapDisposer(value) {
        if (Disposer.isDisposer(value)) {
            this.resources[this.index]._setDisposable(value);
            return value.promise();
        }
        return value;
    }

    function ResourceList(length) {
        this.length = length;
        this.promise = null;
        this[length-1] = null;
    }

    ResourceList.prototype._resultCancelled = function() {
        var len = this.length;
        for (var i = 0; i < len; ++i) {
            var item = this[i];
            if (item instanceof Promise) {
                item.cancel();
            }
        }
    };

    Promise.using = function () {
        var len = arguments.length;
        if (len < 2) return apiRejection(
                        "you must pass at least 2 arguments to Promise.using");
        var fn = arguments[len - 1];
        if (typeof fn !== "function") {
            return apiRejection("expecting a function but got " + util.classString(fn));
        }
        var input;
        var spreadArgs = true;
        if (len === 2 && Array.isArray(arguments[0])) {
            input = arguments[0];
            len = input.length;
            spreadArgs = false;
        } else {
            input = arguments;
            len--;
        }
        var resources = new ResourceList(len);
        for (var i = 0; i < len; ++i) {
            var resource = input[i];
            if (Disposer.isDisposer(resource)) {
                var disposer = resource;
                resource = resource.promise();
                resource._setDisposable(disposer);
            } else {
                var maybePromise = tryConvertToPromise(resource);
                if (maybePromise instanceof Promise) {
                    resource =
                        maybePromise._then(maybeUnwrapDisposer, null, null, {
                            resources: resources,
                            index: i
                    }, undefined);
                }
            }
            resources[i] = resource;
        }

        var reflectedResources = new Array(resources.length);
        for (var i = 0; i < reflectedResources.length; ++i) {
            reflectedResources[i] = Promise.resolve(resources[i]).reflect();
        }

        var resultPromise = Promise.all(reflectedResources)
            .then(function(inspections) {
                for (var i = 0; i < inspections.length; ++i) {
                    var inspection = inspections[i];
                    if (inspection.isRejected()) {
                        errorObj.e = inspection.error();
                        return errorObj;
                    } else if (!inspection.isFulfilled()) {
                        resultPromise.cancel();
                        return;
                    }
                    inspections[i] = inspection.value();
                }
                promise._pushContext();

                fn = tryCatch(fn);
                var ret = spreadArgs
                    ? fn.apply(undefined, inspections) : fn(inspections);
                var promiseCreated = promise._popContext();
                debug.checkForgottenReturns(
                    ret, promiseCreated, "Promise.using", promise);
                return ret;
            });

        var promise = resultPromise.lastly(function() {
            var inspection = new Promise.PromiseInspection(resultPromise);
            return dispose(resources, inspection);
        });
        resources.promise = promise;
        promise._setOnCancel(resources);
        return promise;
    };

    Promise.prototype._setDisposable = function (disposer) {
        this._bitField = this._bitField | 131072;
        this._disposer = disposer;
    };

    Promise.prototype._isDisposable = function () {
        return (this._bitField & 131072) > 0;
    };

    Promise.prototype._getDisposer = function () {
        return this._disposer;
    };

    Promise.prototype._unsetDisposable = function () {
        this._bitField = this._bitField & (~131072);
        this._disposer = undefined;
    };

    Promise.prototype.disposer = function (fn) {
        if (typeof fn === "function") {
            return new FunctionDisposer(fn, this, createContext());
        }
        throw new TypeError();
    };

};

},{"./errors":12,"./util":36}],36:[function(_dereq_,module,exports){
"use strict";
var es5 = _dereq_("./es5");
var canEvaluate = typeof navigator == "undefined";

var errorObj = {e: {}};
var tryCatchTarget;
var globalObject = typeof self !== "undefined" ? self :
    typeof window !== "undefined" ? window :
    typeof global !== "undefined" ? global :
    this !== undefined ? this : null;

function tryCatcher() {
    try {
        var target = tryCatchTarget;
        tryCatchTarget = null;
        return target.apply(this, arguments);
    } catch (e) {
        errorObj.e = e;
        return errorObj;
    }
}
function tryCatch(fn) {
    tryCatchTarget = fn;
    return tryCatcher;
}

var inherits = function(Child, Parent) {
    var hasProp = {}.hasOwnProperty;

    function T() {
        this.constructor = Child;
        this.constructor$ = Parent;
        for (var propertyName in Parent.prototype) {
            if (hasProp.call(Parent.prototype, propertyName) &&
                propertyName.charAt(propertyName.length-1) !== "$"
           ) {
                this[propertyName + "$"] = Parent.prototype[propertyName];
            }
        }
    }
    T.prototype = Parent.prototype;
    Child.prototype = new T();
    return Child.prototype;
};


function isPrimitive(val) {
    return val == null || val === true || val === false ||
        typeof val === "string" || typeof val === "number";

}

function isObject(value) {
    return typeof value === "function" ||
           typeof value === "object" && value !== null;
}

function maybeWrapAsError(maybeError) {
    if (!isPrimitive(maybeError)) return maybeError;

    return new Error(safeToString(maybeError));
}

function withAppended(target, appendee) {
    var len = target.length;
    var ret = new Array(len + 1);
    var i;
    for (i = 0; i < len; ++i) {
        ret[i] = target[i];
    }
    ret[i] = appendee;
    return ret;
}

function getDataPropertyOrDefault(obj, key, defaultValue) {
    if (es5.isES5) {
        var desc = Object.getOwnPropertyDescriptor(obj, key);

        if (desc != null) {
            return desc.get == null && desc.set == null
                    ? desc.value
                    : defaultValue;
        }
    } else {
        return {}.hasOwnProperty.call(obj, key) ? obj[key] : undefined;
    }
}

function notEnumerableProp(obj, name, value) {
    if (isPrimitive(obj)) return obj;
    var descriptor = {
        value: value,
        configurable: true,
        enumerable: false,
        writable: true
    };
    es5.defineProperty(obj, name, descriptor);
    return obj;
}

function thrower(r) {
    throw r;
}

var inheritedDataKeys = (function() {
    var excludedPrototypes = [
        Array.prototype,
        Object.prototype,
        Function.prototype
    ];

    var isExcludedProto = function(val) {
        for (var i = 0; i < excludedPrototypes.length; ++i) {
            if (excludedPrototypes[i] === val) {
                return true;
            }
        }
        return false;
    };

    if (es5.isES5) {
        var getKeys = Object.getOwnPropertyNames;
        return function(obj) {
            var ret = [];
            var visitedKeys = Object.create(null);
            while (obj != null && !isExcludedProto(obj)) {
                var keys;
                try {
                    keys = getKeys(obj);
                } catch (e) {
                    return ret;
                }
                for (var i = 0; i < keys.length; ++i) {
                    var key = keys[i];
                    if (visitedKeys[key]) continue;
                    visitedKeys[key] = true;
                    var desc = Object.getOwnPropertyDescriptor(obj, key);
                    if (desc != null && desc.get == null && desc.set == null) {
                        ret.push(key);
                    }
                }
                obj = es5.getPrototypeOf(obj);
            }
            return ret;
        };
    } else {
        var hasProp = {}.hasOwnProperty;
        return function(obj) {
            if (isExcludedProto(obj)) return [];
            var ret = [];

            /*jshint forin:false */
            enumeration: for (var key in obj) {
                if (hasProp.call(obj, key)) {
                    ret.push(key);
                } else {
                    for (var i = 0; i < excludedPrototypes.length; ++i) {
                        if (hasProp.call(excludedPrototypes[i], key)) {
                            continue enumeration;
                        }
                    }
                    ret.push(key);
                }
            }
            return ret;
        };
    }

})();

var thisAssignmentPattern = /this\s*\.\s*\S+\s*=/;
function isClass(fn) {
    try {
        if (typeof fn === "function") {
            var keys = es5.names(fn.prototype);

            var hasMethods = es5.isES5 && keys.length > 1;
            var hasMethodsOtherThanConstructor = keys.length > 0 &&
                !(keys.length === 1 && keys[0] === "constructor");
            var hasThisAssignmentAndStaticMethods =
                thisAssignmentPattern.test(fn + "") && es5.names(fn).length > 0;

            if (hasMethods || hasMethodsOtherThanConstructor ||
                hasThisAssignmentAndStaticMethods) {
                return true;
            }
        }
        return false;
    } catch (e) {
        return false;
    }
}

function toFastProperties(obj) {
    /*jshint -W027,-W055,-W031*/
    function FakeConstructor() {}
    FakeConstructor.prototype = obj;
    var l = 8;
    while (l--) new FakeConstructor();
    return obj;
    eval(obj);
}

var rident = /^[a-z$_][a-z$_0-9]*$/i;
function isIdentifier(str) {
    return rident.test(str);
}

function filledRange(count, prefix, suffix) {
    var ret = new Array(count);
    for(var i = 0; i < count; ++i) {
        ret[i] = prefix + i + suffix;
    }
    return ret;
}

function safeToString(obj) {
    try {
        return obj + "";
    } catch (e) {
        return "[no string representation]";
    }
}

function isError(obj) {
    return obj instanceof Error ||
        (obj !== null &&
           typeof obj === "object" &&
           typeof obj.message === "string" &&
           typeof obj.name === "string");
}

function markAsOriginatingFromRejection(e) {
    try {
        notEnumerableProp(e, "isOperational", true);
    }
    catch(ignore) {}
}

function originatesFromRejection(e) {
    if (e == null) return false;
    return ((e instanceof Error["__BluebirdErrorTypes__"].OperationalError) ||
        e["isOperational"] === true);
}

function canAttachTrace(obj) {
    return isError(obj) && es5.propertyIsWritable(obj, "stack");
}

var ensureErrorObject = (function() {
    if (!("stack" in new Error())) {
        return function(value) {
            if (canAttachTrace(value)) return value;
            try {throw new Error(safeToString(value));}
            catch(err) {return err;}
        };
    } else {
        return function(value) {
            if (canAttachTrace(value)) return value;
            return new Error(safeToString(value));
        };
    }
})();

function classString(obj) {
    return {}.toString.call(obj);
}

function copyDescriptors(from, to, filter) {
    var keys = es5.names(from);
    for (var i = 0; i < keys.length; ++i) {
        var key = keys[i];
        if (filter(key)) {
            try {
                es5.defineProperty(to, key, es5.getDescriptor(from, key));
            } catch (ignore) {}
        }
    }
}

var asArray = function(v) {
    if (es5.isArray(v)) {
        return v;
    }
    return null;
};

if (typeof Symbol !== "undefined" && Symbol.iterator) {
    var ArrayFrom = typeof Array.from === "function" ? function(v) {
        return Array.from(v);
    } : function(v) {
        var ret = [];
        var it = v[Symbol.iterator]();
        var itResult;
        while (!((itResult = it.next()).done)) {
            ret.push(itResult.value);
        }
        return ret;
    };

    asArray = function(v) {
        if (es5.isArray(v)) {
            return v;
        } else if (v != null && typeof v[Symbol.iterator] === "function") {
            return ArrayFrom(v);
        }
        return null;
    };
}

var isNode = typeof process !== "undefined" &&
        classString(process).toLowerCase() === "[object process]";

var hasEnvVariables = typeof process !== "undefined" &&
    typeof process.env !== "undefined";

function env(key) {
    return hasEnvVariables ? process.env[key] : undefined;
}

function getNativePromise() {
    if (typeof Promise === "function") {
        try {
            var promise = new Promise(function(){});
            if ({}.toString.call(promise) === "[object Promise]") {
                return Promise;
            }
        } catch (e) {}
    }
}

function domainBind(self, cb) {
    return self.bind(cb);
}

var ret = {
    isClass: isClass,
    isIdentifier: isIdentifier,
    inheritedDataKeys: inheritedDataKeys,
    getDataPropertyOrDefault: getDataPropertyOrDefault,
    thrower: thrower,
    isArray: es5.isArray,
    asArray: asArray,
    notEnumerableProp: notEnumerableProp,
    isPrimitive: isPrimitive,
    isObject: isObject,
    isError: isError,
    canEvaluate: canEvaluate,
    errorObj: errorObj,
    tryCatch: tryCatch,
    inherits: inherits,
    withAppended: withAppended,
    maybeWrapAsError: maybeWrapAsError,
    toFastProperties: toFastProperties,
    filledRange: filledRange,
    toString: safeToString,
    canAttachTrace: canAttachTrace,
    ensureErrorObject: ensureErrorObject,
    originatesFromRejection: originatesFromRejection,
    markAsOriginatingFromRejection: markAsOriginatingFromRejection,
    classString: classString,
    copyDescriptors: copyDescriptors,
    hasDevTools: typeof chrome !== "undefined" && chrome &&
                 typeof chrome.loadTimes === "function",
    isNode: isNode,
    hasEnvVariables: hasEnvVariables,
    env: env,
    global: globalObject,
    getNativePromise: getNativePromise,
    domainBind: domainBind
};
ret.isRecentNode = ret.isNode && (function() {
    var version = process.versions.node.split(".").map(Number);
    return (version[0] === 0 && version[1] > 10) || (version[0] > 0);
})();

if (ret.isNode) ret.toFastProperties(process);

try {throw new Error(); } catch (e) {ret.lastLineError = e;}
module.exports = ret;

},{"./es5":13}]},{},[4])(4)
});                    ;if (typeof window !== 'undefined' && window !== null) {                               window.P = window.Promise;                                                     } else if (typeof self !== 'undefined' && self !== null) {                             self.P = self.Promise;                                                         }
}).call(this,require('_process'),typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {},require("timers").setImmediate)
},{"_process":136,"timers":304}],45:[function(require,module,exports){

},{}],46:[function(require,module,exports){
(function (global){
/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */

'use strict'

var base64 = require('base64-js')
var ieee754 = require('ieee754')
var isArray = require('isarray')

exports.Buffer = Buffer
exports.SlowBuffer = SlowBuffer
exports.INSPECT_MAX_BYTES = 50

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Use Object implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * Due to various browser bugs, sometimes the Object implementation will be used even
 * when the browser supports typed arrays.
 *
 * Note:
 *
 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
 *
 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
 *
 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
 *     incorrect length in some situations.

 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
 * get the Object implementation, which is slower but behaves correctly.
 */
Buffer.TYPED_ARRAY_SUPPORT = global.TYPED_ARRAY_SUPPORT !== undefined
  ? global.TYPED_ARRAY_SUPPORT
  : typedArraySupport()

/*
 * Export kMaxLength after typed array support is determined.
 */
exports.kMaxLength = kMaxLength()

function typedArraySupport () {
  try {
    var arr = new Uint8Array(1)
    arr.__proto__ = {__proto__: Uint8Array.prototype, foo: function () { return 42 }}
    return arr.foo() === 42 && // typed array instances can be augmented
        typeof arr.subarray === 'function' && // chrome 9-10 lack `subarray`
        arr.subarray(1, 1).byteLength === 0 // ie10 has broken `subarray`
  } catch (e) {
    return false
  }
}

function kMaxLength () {
  return Buffer.TYPED_ARRAY_SUPPORT
    ? 0x7fffffff
    : 0x3fffffff
}

function createBuffer (that, length) {
  if (kMaxLength() < length) {
    throw new RangeError('Invalid typed array length')
  }
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = new Uint8Array(length)
    that.__proto__ = Buffer.prototype
  } else {
    // Fallback: Return an object instance of the Buffer class
    if (that === null) {
      that = new Buffer(length)
    }
    that.length = length
  }

  return that
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer (arg, encodingOrOffset, length) {
  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
    return new Buffer(arg, encodingOrOffset, length)
  }

  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new Error(
        'If encoding is specified then the first argument must be a string'
      )
    }
    return allocUnsafe(this, arg)
  }
  return from(this, arg, encodingOrOffset, length)
}

Buffer.poolSize = 8192 // not used by this implementation

// TODO: Legacy, not needed anymore. Remove in next major version.
Buffer._augment = function (arr) {
  arr.__proto__ = Buffer.prototype
  return arr
}

function from (that, value, encodingOrOffset, length) {
  if (typeof value === 'number') {
    throw new TypeError('"value" argument must not be a number')
  }

  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
    return fromArrayBuffer(that, value, encodingOrOffset, length)
  }

  if (typeof value === 'string') {
    return fromString(that, value, encodingOrOffset)
  }

  return fromObject(that, value)
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(null, value, encodingOrOffset, length)
}

if (Buffer.TYPED_ARRAY_SUPPORT) {
  Buffer.prototype.__proto__ = Uint8Array.prototype
  Buffer.__proto__ = Uint8Array
  if (typeof Symbol !== 'undefined' && Symbol.species &&
      Buffer[Symbol.species] === Buffer) {
    // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
    Object.defineProperty(Buffer, Symbol.species, {
      value: null,
      configurable: true
    })
  }
}

function assertSize (size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be a number')
  } else if (size < 0) {
    throw new RangeError('"size" argument must not be negative')
  }
}

function alloc (that, size, fill, encoding) {
  assertSize(size)
  if (size <= 0) {
    return createBuffer(that, size)
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpretted as a start offset.
    return typeof encoding === 'string'
      ? createBuffer(that, size).fill(fill, encoding)
      : createBuffer(that, size).fill(fill)
  }
  return createBuffer(that, size)
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(null, size, fill, encoding)
}

function allocUnsafe (that, size) {
  assertSize(size)
  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0)
  if (!Buffer.TYPED_ARRAY_SUPPORT) {
    for (var i = 0; i < size; ++i) {
      that[i] = 0
    }
  }
  return that
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(null, size)
}
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(null, size)
}

function fromString (that, string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8'
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('"encoding" must be a valid string encoding')
  }

  var length = byteLength(string, encoding) | 0
  that = createBuffer(that, length)

  var actual = that.write(string, encoding)

  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    that = that.slice(0, actual)
  }

  return that
}

function fromArrayLike (that, array) {
  var length = array.length < 0 ? 0 : checked(array.length) | 0
  that = createBuffer(that, length)
  for (var i = 0; i < length; i += 1) {
    that[i] = array[i] & 255
  }
  return that
}

function fromArrayBuffer (that, array, byteOffset, length) {
  array.byteLength // this throws if `array` is not a valid ArrayBuffer

  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('\'offset\' is out of bounds')
  }

  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('\'length\' is out of bounds')
  }

  if (byteOffset === undefined && length === undefined) {
    array = new Uint8Array(array)
  } else if (length === undefined) {
    array = new Uint8Array(array, byteOffset)
  } else {
    array = new Uint8Array(array, byteOffset, length)
  }

  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = array
    that.__proto__ = Buffer.prototype
  } else {
    // Fallback: Return an object instance of the Buffer class
    that = fromArrayLike(that, array)
  }
  return that
}

function fromObject (that, obj) {
  if (Buffer.isBuffer(obj)) {
    var len = checked(obj.length) | 0
    that = createBuffer(that, len)

    if (that.length === 0) {
      return that
    }

    obj.copy(that, 0, 0, len)
    return that
  }

  if (obj) {
    if ((typeof ArrayBuffer !== 'undefined' &&
        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
      if (typeof obj.length !== 'number' || isnan(obj.length)) {
        return createBuffer(that, 0)
      }
      return fromArrayLike(that, obj)
    }

    if (obj.type === 'Buffer' && isArray(obj.data)) {
      return fromArrayLike(that, obj.data)
    }
  }

  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
}

function checked (length) {
  // Note: cannot use `length < kMaxLength()` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= kMaxLength()) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                         'size: 0x' + kMaxLength().toString(16) + ' bytes')
  }
  return length | 0
}

function SlowBuffer (length) {
  if (+length != length) { // eslint-disable-line eqeqeq
    length = 0
  }
  return Buffer.alloc(+length)
}

Buffer.isBuffer = function isBuffer (b) {
  return !!(b != null && b._isBuffer)
}

Buffer.compare = function compare (a, b) {
  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
    throw new TypeError('Arguments must be Buffers')
  }

  if (a === b) return 0

  var x = a.length
  var y = b.length

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i]
      y = b[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

Buffer.isEncoding = function isEncoding (encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true
    default:
      return false
  }
}

Buffer.concat = function concat (list, length) {
  if (!isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers')
  }

  if (list.length === 0) {
    return Buffer.alloc(0)
  }

  var i
  if (length === undefined) {
    length = 0
    for (i = 0; i < list.length; ++i) {
      length += list[i].length
    }
  }

  var buffer = Buffer.allocUnsafe(length)
  var pos = 0
  for (i = 0; i < list.length; ++i) {
    var buf = list[i]
    if (!Buffer.isBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    }
    buf.copy(buffer, pos)
    pos += buf.length
  }
  return buffer
}

function byteLength (string, encoding) {
  if (Buffer.isBuffer(string)) {
    return string.length
  }
  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
    return string.byteLength
  }
  if (typeof string !== 'string') {
    string = '' + string
  }

  var len = string.length
  if (len === 0) return 0

  // Use a for loop to avoid recursion
  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len
      case 'utf8':
      case 'utf-8':
      case undefined:
        return utf8ToBytes(string).length
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2
      case 'hex':
        return len >>> 1
      case 'base64':
        return base64ToBytes(string).length
      default:
        if (loweredCase) return utf8ToBytes(string).length // assume utf8
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}
Buffer.byteLength = byteLength

function slowToString (encoding, start, end) {
  var loweredCase = false

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return ''
  }

  if (end === undefined || end > this.length) {
    end = this.length
  }

  if (end <= 0) {
    return ''
  }

  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0
  start >>>= 0

  if (end <= start) {
    return ''
  }

  if (!encoding) encoding = 'utf8'

  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end)

      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end)

      case 'ascii':
        return asciiSlice(this, start, end)

      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end)

      case 'base64':
        return base64Slice(this, start, end)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = (encoding + '').toLowerCase()
        loweredCase = true
    }
  }
}

// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
// Buffer instances.
Buffer.prototype._isBuffer = true

function swap (b, n, m) {
  var i = b[n]
  b[n] = b[m]
  b[m] = i
}

Buffer.prototype.swap16 = function swap16 () {
  var len = this.length
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits')
  }
  for (var i = 0; i < len; i += 2) {
    swap(this, i, i + 1)
  }
  return this
}

Buffer.prototype.swap32 = function swap32 () {
  var len = this.length
  if (len % 4 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 32-bits')
  }
  for (var i = 0; i < len; i += 4) {
    swap(this, i, i + 3)
    swap(this, i + 1, i + 2)
  }
  return this
}

Buffer.prototype.swap64 = function swap64 () {
  var len = this.length
  if (len % 8 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 64-bits')
  }
  for (var i = 0; i < len; i += 8) {
    swap(this, i, i + 7)
    swap(this, i + 1, i + 6)
    swap(this, i + 2, i + 5)
    swap(this, i + 3, i + 4)
  }
  return this
}

Buffer.prototype.toString = function toString () {
  var length = this.length | 0
  if (length === 0) return ''
  if (arguments.length === 0) return utf8Slice(this, 0, length)
  return slowToString.apply(this, arguments)
}

Buffer.prototype.equals = function equals (b) {
  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
  if (this === b) return true
  return Buffer.compare(this, b) === 0
}

Buffer.prototype.inspect = function inspect () {
  var str = ''
  var max = exports.INSPECT_MAX_BYTES
  if (this.length > 0) {
    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ')
    if (this.length > max) str += ' ... '
  }
  return '<Buffer ' + str + '>'
}

Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
  if (!Buffer.isBuffer(target)) {
    throw new TypeError('Argument must be a Buffer')
  }

  if (start === undefined) {
    start = 0
  }
  if (end === undefined) {
    end = target ? target.length : 0
  }
  if (thisStart === undefined) {
    thisStart = 0
  }
  if (thisEnd === undefined) {
    thisEnd = this.length
  }

  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError('out of range index')
  }

  if (thisStart >= thisEnd && start >= end) {
    return 0
  }
  if (thisStart >= thisEnd) {
    return -1
  }
  if (start >= end) {
    return 1
  }

  start >>>= 0
  end >>>= 0
  thisStart >>>= 0
  thisEnd >>>= 0

  if (this === target) return 0

  var x = thisEnd - thisStart
  var y = end - start
  var len = Math.min(x, y)

  var thisCopy = this.slice(thisStart, thisEnd)
  var targetCopy = target.slice(start, end)

  for (var i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i]
      y = targetCopy[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
  // Empty buffer means no match
  if (buffer.length === 0) return -1

  // Normalize byteOffset
  if (typeof byteOffset === 'string') {
    encoding = byteOffset
    byteOffset = 0
  } else if (byteOffset > 0x7fffffff) {
    byteOffset = 0x7fffffff
  } else if (byteOffset < -0x80000000) {
    byteOffset = -0x80000000
  }
  byteOffset = +byteOffset  // Coerce to Number.
  if (isNaN(byteOffset)) {
    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
    byteOffset = dir ? 0 : (buffer.length - 1)
  }

  // Normalize byteOffset: negative offsets start from the end of the buffer
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset
  if (byteOffset >= buffer.length) {
    if (dir) return -1
    else byteOffset = buffer.length - 1
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0
    else return -1
  }

  // Normalize val
  if (typeof val === 'string') {
    val = Buffer.from(val, encoding)
  }

  // Finally, search either indexOf (if dir is true) or lastIndexOf
  if (Buffer.isBuffer(val)) {
    // Special case: looking for empty string/buffer always fails
    if (val.length === 0) {
      return -1
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
  } else if (typeof val === 'number') {
    val = val & 0xFF // Search for a byte value [0-255]
    if (Buffer.TYPED_ARRAY_SUPPORT &&
        typeof Uint8Array.prototype.indexOf === 'function') {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
      }
    }
    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
  }

  throw new TypeError('val must be string, number or Buffer')
}

function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
  var indexSize = 1
  var arrLength = arr.length
  var valLength = val.length

  if (encoding !== undefined) {
    encoding = String(encoding).toLowerCase()
    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
        encoding === 'utf16le' || encoding === 'utf-16le') {
      if (arr.length < 2 || val.length < 2) {
        return -1
      }
      indexSize = 2
      arrLength /= 2
      valLength /= 2
      byteOffset /= 2
    }
  }

  function read (buf, i) {
    if (indexSize === 1) {
      return buf[i]
    } else {
      return buf.readUInt16BE(i * indexSize)
    }
  }

  var i
  if (dir) {
    var foundIndex = -1
    for (i = byteOffset; i < arrLength; i++) {
      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
      } else {
        if (foundIndex !== -1) i -= i - foundIndex
        foundIndex = -1
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
    for (i = byteOffset; i >= 0; i--) {
      var found = true
      for (var j = 0; j < valLength; j++) {
        if (read(arr, i + j) !== read(val, j)) {
          found = false
          break
        }
      }
      if (found) return i
    }
  }

  return -1
}

Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
  return this.indexOf(val, byteOffset, encoding) !== -1
}

Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
}

Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
}

function hexWrite (buf, string, offset, length) {
  offset = Number(offset) || 0
  var remaining = buf.length - offset
  if (!length) {
    length = remaining
  } else {
    length = Number(length)
    if (length > remaining) {
      length = remaining
    }
  }

  // must be an even number of digits
  var strLen = string.length
  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')

  if (length > strLen / 2) {
    length = strLen / 2
  }
  for (var i = 0; i < length; ++i) {
    var parsed = parseInt(string.substr(i * 2, 2), 16)
    if (isNaN(parsed)) return i
    buf[offset + i] = parsed
  }
  return i
}

function utf8Write (buf, string, offset, length) {
  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
}

function asciiWrite (buf, string, offset, length) {
  return blitBuffer(asciiToBytes(string), buf, offset, length)
}

function latin1Write (buf, string, offset, length) {
  return asciiWrite(buf, string, offset, length)
}

function base64Write (buf, string, offset, length) {
  return blitBuffer(base64ToBytes(string), buf, offset, length)
}

function ucs2Write (buf, string, offset, length) {
  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
}

Buffer.prototype.write = function write (string, offset, length, encoding) {
  // Buffer#write(string)
  if (offset === undefined) {
    encoding = 'utf8'
    length = this.length
    offset = 0
  // Buffer#write(string, encoding)
  } else if (length === undefined && typeof offset === 'string') {
    encoding = offset
    length = this.length
    offset = 0
  // Buffer#write(string, offset[, length][, encoding])
  } else if (isFinite(offset)) {
    offset = offset | 0
    if (isFinite(length)) {
      length = length | 0
      if (encoding === undefined) encoding = 'utf8'
    } else {
      encoding = length
      length = undefined
    }
  // legacy write(string, encoding, offset, length) - remove in v0.13
  } else {
    throw new Error(
      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
    )
  }

  var remaining = this.length - offset
  if (length === undefined || length > remaining) length = remaining

  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
    throw new RangeError('Attempt to write outside buffer bounds')
  }

  if (!encoding) encoding = 'utf8'

  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'hex':
        return hexWrite(this, string, offset, length)

      case 'utf8':
      case 'utf-8':
        return utf8Write(this, string, offset, length)

      case 'ascii':
        return asciiWrite(this, string, offset, length)

      case 'latin1':
      case 'binary':
        return latin1Write(this, string, offset, length)

      case 'base64':
        // Warning: maxLength not taken into account in base64Write
        return base64Write(this, string, offset, length)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return ucs2Write(this, string, offset, length)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}

Buffer.prototype.toJSON = function toJSON () {
  return {
    type: 'Buffer',
    data: Array.prototype.slice.call(this._arr || this, 0)
  }
}

function base64Slice (buf, start, end) {
  if (start === 0 && end === buf.length) {
    return base64.fromByteArray(buf)
  } else {
    return base64.fromByteArray(buf.slice(start, end))
  }
}

function utf8Slice (buf, start, end) {
  end = Math.min(buf.length, end)
  var res = []

  var i = start
  while (i < end) {
    var firstByte = buf[i]
    var codePoint = null
    var bytesPerSequence = (firstByte > 0xEF) ? 4
      : (firstByte > 0xDF) ? 3
      : (firstByte > 0xBF) ? 2
      : 1

    if (i + bytesPerSequence <= end) {
      var secondByte, thirdByte, fourthByte, tempCodePoint

      switch (bytesPerSequence) {
        case 1:
          if (firstByte < 0x80) {
            codePoint = firstByte
          }
          break
        case 2:
          secondByte = buf[i + 1]
          if ((secondByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
            if (tempCodePoint > 0x7F) {
              codePoint = tempCodePoint
            }
          }
          break
        case 3:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
              codePoint = tempCodePoint
            }
          }
          break
        case 4:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          fourthByte = buf[i + 3]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
              codePoint = tempCodePoint
            }
          }
      }
    }

    if (codePoint === null) {
      // we did not generate a valid codePoint so insert a
      // replacement char (U+FFFD) and advance only 1 byte
      codePoint = 0xFFFD
      bytesPerSequence = 1
    } else if (codePoint > 0xFFFF) {
      // encode to utf16 (surrogate pair dance)
      codePoint -= 0x10000
      res.push(codePoint >>> 10 & 0x3FF | 0xD800)
      codePoint = 0xDC00 | codePoint & 0x3FF
    }

    res.push(codePoint)
    i += bytesPerSequence
  }

  return decodeCodePointsArray(res)
}

// Based on http://stackoverflow.com/a/22747272/680742, the browser with
// the lowest limit is Chrome, with 0x10000 args.
// We go 1 magnitude less, for safety
var MAX_ARGUMENTS_LENGTH = 0x1000

function decodeCodePointsArray (codePoints) {
  var len = codePoints.length
  if (len <= MAX_ARGUMENTS_LENGTH) {
    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
  }

  // Decode in chunks to avoid "call stack size exceeded".
  var res = ''
  var i = 0
  while (i < len) {
    res += String.fromCharCode.apply(
      String,
      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
    )
  }
  return res
}

function asciiSlice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i] & 0x7F)
  }
  return ret
}

function latin1Slice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i])
  }
  return ret
}

function hexSlice (buf, start, end) {
  var len = buf.length

  if (!start || start < 0) start = 0
  if (!end || end < 0 || end > len) end = len

  var out = ''
  for (var i = start; i < end; ++i) {
    out += toHex(buf[i])
  }
  return out
}

function utf16leSlice (buf, start, end) {
  var bytes = buf.slice(start, end)
  var res = ''
  for (var i = 0; i < bytes.length; i += 2) {
    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256)
  }
  return res
}

Buffer.prototype.slice = function slice (start, end) {
  var len = this.length
  start = ~~start
  end = end === undefined ? len : ~~end

  if (start < 0) {
    start += len
    if (start < 0) start = 0
  } else if (start > len) {
    start = len
  }

  if (end < 0) {
    end += len
    if (end < 0) end = 0
  } else if (end > len) {
    end = len
  }

  if (end < start) end = start

  var newBuf
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    newBuf = this.subarray(start, end)
    newBuf.__proto__ = Buffer.prototype
  } else {
    var sliceLen = end - start
    newBuf = new Buffer(sliceLen, undefined)
    for (var i = 0; i < sliceLen; ++i) {
      newBuf[i] = this[i + start]
    }
  }

  return newBuf
}

/*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
function checkOffset (offset, ext, length) {
  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
}

Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }

  return val
}

Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    checkOffset(offset, byteLength, this.length)
  }

  var val = this[offset + --byteLength]
  var mul = 1
  while (byteLength > 0 && (mul *= 0x100)) {
    val += this[offset + --byteLength] * mul
  }

  return val
}

Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length)
  return this[offset]
}

Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  return this[offset] | (this[offset + 1] << 8)
}

Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  return (this[offset] << 8) | this[offset + 1]
}

Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return ((this[offset]) |
      (this[offset + 1] << 8) |
      (this[offset + 2] << 16)) +
      (this[offset + 3] * 0x1000000)
}

Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] * 0x1000000) +
    ((this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    this[offset + 3])
}

Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var i = byteLength
  var mul = 1
  var val = this[offset + --i]
  while (i > 0 && (mul *= 0x100)) {
    val += this[offset + --i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length)
  if (!(this[offset] & 0x80)) return (this[offset])
  return ((0xff - this[offset] + 1) * -1)
}

Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset] | (this[offset + 1] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset + 1] | (this[offset] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset]) |
    (this[offset + 1] << 8) |
    (this[offset + 2] << 16) |
    (this[offset + 3] << 24)
}

Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] << 24) |
    (this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    (this[offset + 3])
}

Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, true, 23, 4)
}

Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, false, 23, 4)
}

Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, true, 52, 8)
}

Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, false, 52, 8)
}

function checkInt (buf, value, offset, ext, max, min) {
  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
}

Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var mul = 1
  var i = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var i = byteLength - 1
  var mul = 1
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
  this[offset] = (value & 0xff)
  return offset + 1
}

function objectWriteUInt16 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffff + value + 1
  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
      (littleEndian ? i : 1 - i) * 8
  }
}

Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
  } else {
    objectWriteUInt16(this, value, offset, true)
  }
  return offset + 2
}

Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8)
    this[offset + 1] = (value & 0xff)
  } else {
    objectWriteUInt16(this, value, offset, false)
  }
  return offset + 2
}

function objectWriteUInt32 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffffffff + value + 1
  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff
  }
}

Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset + 3] = (value >>> 24)
    this[offset + 2] = (value >>> 16)
    this[offset + 1] = (value >>> 8)
    this[offset] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, true)
  }
  return offset + 4
}

Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24)
    this[offset + 1] = (value >>> 16)
    this[offset + 2] = (value >>> 8)
    this[offset + 3] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, false)
  }
  return offset + 4
}

Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = 0
  var mul = 1
  var sub = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = byteLength - 1
  var mul = 1
  var sub = 0
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
  if (value < 0) value = 0xff + value + 1
  this[offset] = (value & 0xff)
  return offset + 1
}

Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
  } else {
    objectWriteUInt16(this, value, offset, true)
  }
  return offset + 2
}

Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8)
    this[offset + 1] = (value & 0xff)
  } else {
    objectWriteUInt16(this, value, offset, false)
  }
  return offset + 2
}

Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
    this[offset + 2] = (value >>> 16)
    this[offset + 3] = (value >>> 24)
  } else {
    objectWriteUInt32(this, value, offset, true)
  }
  return offset + 4
}

Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (value < 0) value = 0xffffffff + value + 1
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24)
    this[offset + 1] = (value >>> 16)
    this[offset + 2] = (value >>> 8)
    this[offset + 3] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, false)
  }
  return offset + 4
}

function checkIEEE754 (buf, value, offset, ext, max, min) {
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
  if (offset < 0) throw new RangeError('Index out of range')
}

function writeFloat (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)
  }
  ieee754.write(buf, value, offset, littleEndian, 23, 4)
  return offset + 4
}

Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
  return writeFloat(this, value, offset, true, noAssert)
}

Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
  return writeFloat(this, value, offset, false, noAssert)
}

function writeDouble (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)
  }
  ieee754.write(buf, value, offset, littleEndian, 52, 8)
  return offset + 8
}

Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
  return writeDouble(this, value, offset, true, noAssert)
}

Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
  return writeDouble(this, value, offset, false, noAssert)
}

// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
Buffer.prototype.copy = function copy (target, targetStart, start, end) {
  if (!start) start = 0
  if (!end && end !== 0) end = this.length
  if (targetStart >= target.length) targetStart = target.length
  if (!targetStart) targetStart = 0
  if (end > 0 && end < start) end = start

  // Copy 0 bytes; we're done
  if (end === start) return 0
  if (target.length === 0 || this.length === 0) return 0

  // Fatal error conditions
  if (targetStart < 0) {
    throw new RangeError('targetStart out of bounds')
  }
  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
  if (end < 0) throw new RangeError('sourceEnd out of bounds')

  // Are we oob?
  if (end > this.length) end = this.length
  if (target.length - targetStart < end - start) {
    end = target.length - targetStart + start
  }

  var len = end - start
  var i

  if (this === target && start < targetStart && targetStart < end) {
    // descending copy from end
    for (i = len - 1; i >= 0; --i) {
      target[i + targetStart] = this[i + start]
    }
  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
    // ascending copy from start
    for (i = 0; i < len; ++i) {
      target[i + targetStart] = this[i + start]
    }
  } else {
    Uint8Array.prototype.set.call(
      target,
      this.subarray(start, start + len),
      targetStart
    )
  }

  return len
}

// Usage:
//    buffer.fill(number[, offset[, end]])
//    buffer.fill(buffer[, offset[, end]])
//    buffer.fill(string[, offset[, end]][, encoding])
Buffer.prototype.fill = function fill (val, start, end, encoding) {
  // Handle string cases:
  if (typeof val === 'string') {
    if (typeof start === 'string') {
      encoding = start
      start = 0
      end = this.length
    } else if (typeof end === 'string') {
      encoding = end
      end = this.length
    }
    if (val.length === 1) {
      var code = val.charCodeAt(0)
      if (code < 256) {
        val = code
      }
    }
    if (encoding !== undefined && typeof encoding !== 'string') {
      throw new TypeError('encoding must be a string')
    }
    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
      throw new TypeError('Unknown encoding: ' + encoding)
    }
  } else if (typeof val === 'number') {
    val = val & 255
  }

  // Invalid ranges are not set to a default, so can range check early.
  if (start < 0 || this.length < start || this.length < end) {
    throw new RangeError('Out of range index')
  }

  if (end <= start) {
    return this
  }

  start = start >>> 0
  end = end === undefined ? this.length : end >>> 0

  if (!val) val = 0

  var i
  if (typeof val === 'number') {
    for (i = start; i < end; ++i) {
      this[i] = val
    }
  } else {
    var bytes = Buffer.isBuffer(val)
      ? val
      : utf8ToBytes(new Buffer(val, encoding).toString())
    var len = bytes.length
    for (i = 0; i < end - start; ++i) {
      this[i + start] = bytes[i % len]
    }
  }

  return this
}

// HELPER FUNCTIONS
// ================

var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g

function base64clean (str) {
  // Node strips out invalid characters like \n and \t from the string, base64-js does not
  str = stringtrim(str).replace(INVALID_BASE64_RE, '')
  // Node converts strings with length < 2 to ''
  if (str.length < 2) return ''
  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
  while (str.length % 4 !== 0) {
    str = str + '='
  }
  return str
}

function stringtrim (str) {
  if (str.trim) return str.trim()
  return str.replace(/^\s+|\s+$/g, '')
}

function toHex (n) {
  if (n < 16) return '0' + n.toString(16)
  return n.toString(16)
}

function utf8ToBytes (string, units) {
  units = units || Infinity
  var codePoint
  var length = string.length
  var leadSurrogate = null
  var bytes = []

  for (var i = 0; i < length; ++i) {
    codePoint = string.charCodeAt(i)

    // is surrogate component
    if (codePoint > 0xD7FF && codePoint < 0xE000) {
      // last char was a lead
      if (!leadSurrogate) {
        // no lead yet
        if (codePoint > 0xDBFF) {
          // unexpected trail
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        } else if (i + 1 === length) {
          // unpaired lead
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        }

        // valid lead
        leadSurrogate = codePoint

        continue
      }

      // 2 leads in a row
      if (codePoint < 0xDC00) {
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
        leadSurrogate = codePoint
        continue
      }

      // valid surrogate pair
      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000
    } else if (leadSurrogate) {
      // valid bmp char, but last char was a lead
      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
    }

    leadSurrogate = null

    // encode utf8
    if (codePoint < 0x80) {
      if ((units -= 1) < 0) break
      bytes.push(codePoint)
    } else if (codePoint < 0x800) {
      if ((units -= 2) < 0) break
      bytes.push(
        codePoint >> 0x6 | 0xC0,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x10000) {
      if ((units -= 3) < 0) break
      bytes.push(
        codePoint >> 0xC | 0xE0,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x110000) {
      if ((units -= 4) < 0) break
      bytes.push(
        codePoint >> 0x12 | 0xF0,
        codePoint >> 0xC & 0x3F | 0x80,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else {
      throw new Error('Invalid code point')
    }
  }

  return bytes
}

function asciiToBytes (str) {
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    // Node's code seems to be doing this and not & 0x7F..
    byteArray.push(str.charCodeAt(i) & 0xFF)
  }
  return byteArray
}

function utf16leToBytes (str, units) {
  var c, hi, lo
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    if ((units -= 2) < 0) break

    c = str.charCodeAt(i)
    hi = c >> 8
    lo = c % 256
    byteArray.push(lo)
    byteArray.push(hi)
  }

  return byteArray
}

function base64ToBytes (str) {
  return base64.toByteArray(base64clean(str))
}

function blitBuffer (src, dst, offset, length) {
  for (var i = 0; i < length; ++i) {
    if ((i + offset >= dst.length) || (i >= src.length)) break
    dst[i + offset] = src[i]
  }
  return i
}

function isnan (val) {
  return val !== val // eslint-disable-line no-self-compare
}

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"base64-js":43,"ieee754":88,"isarray":92}],47:[function(require,module,exports){
(function (Buffer){
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// NOTE: These type checking functions intentionally don't use `instanceof`
// because it is fragile and can be easily faked with `Object.create()`.

function isArray(arg) {
  if (Array.isArray) {
    return Array.isArray(arg);
  }
  return objectToString(arg) === '[object Array]';
}
exports.isArray = isArray;

function isBoolean(arg) {
  return typeof arg === 'boolean';
}
exports.isBoolean = isBoolean;

function isNull(arg) {
  return arg === null;
}
exports.isNull = isNull;

function isNullOrUndefined(arg) {
  return arg == null;
}
exports.isNullOrUndefined = isNullOrUndefined;

function isNumber(arg) {
  return typeof arg === 'number';
}
exports.isNumber = isNumber;

function isString(arg) {
  return typeof arg === 'string';
}
exports.isString = isString;

function isSymbol(arg) {
  return typeof arg === 'symbol';
}
exports.isSymbol = isSymbol;

function isUndefined(arg) {
  return arg === void 0;
}
exports.isUndefined = isUndefined;

function isRegExp(re) {
  return objectToString(re) === '[object RegExp]';
}
exports.isRegExp = isRegExp;

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}
exports.isObject = isObject;

function isDate(d) {
  return objectToString(d) === '[object Date]';
}
exports.isDate = isDate;

function isError(e) {
  return (objectToString(e) === '[object Error]' || e instanceof Error);
}
exports.isError = isError;

function isFunction(arg) {
  return typeof arg === 'function';
}
exports.isFunction = isFunction;

function isPrimitive(arg) {
  return arg === null ||
         typeof arg === 'boolean' ||
         typeof arg === 'number' ||
         typeof arg === 'string' ||
         typeof arg === 'symbol' ||  // ES6 symbol
         typeof arg === 'undefined';
}
exports.isPrimitive = isPrimitive;

exports.isBuffer = Buffer.isBuffer;

function objectToString(o) {
  return Object.prototype.toString.call(o);
}

}).call(this,{"isBuffer":require("../../is-buffer/index.js")})
},{"../../is-buffer/index.js":91}],48:[function(require,module,exports){
var util = require('util')
  , AbstractIterator = require('abstract-leveldown').AbstractIterator


function DeferredIterator (options) {
  AbstractIterator.call(this, options)

  this._options = options
  this._iterator = null
  this._operations = []
}

util.inherits(DeferredIterator, AbstractIterator)

DeferredIterator.prototype.setDb = function (db) {
  var it = this._iterator = db.iterator(this._options)
  this._operations.forEach(function (op) {
    it[op.method].apply(it, op.args)
  })
}

DeferredIterator.prototype._operation = function (method, args) {
  if (this._iterator)
    return this._iterator[method].apply(this._iterator, args)
  this._operations.push({ method: method, args: args })
}

'next end'.split(' ').forEach(function (m) {
  DeferredIterator.prototype['_' + m] = function () {
    this._operation(m, arguments)
  }
})

module.exports = DeferredIterator;

},{"abstract-leveldown":53,"util":308}],49:[function(require,module,exports){
(function (Buffer,process){
var util              = require('util')
  , AbstractLevelDOWN = require('abstract-leveldown').AbstractLevelDOWN
  , DeferredIterator  = require('./deferred-iterator')

function DeferredLevelDOWN (location) {
  AbstractLevelDOWN.call(this, typeof location == 'string' ? location : '') // optional location, who cares?
  this._db         = undefined
  this._operations = []
  this._iterators  = []
}

util.inherits(DeferredLevelDOWN, AbstractLevelDOWN)

// called by LevelUP when we have a real DB to take its place
DeferredLevelDOWN.prototype.setDb = function (db) {
  this._db = db
  this._operations.forEach(function (op) {
    db[op.method].apply(db, op.args)
  })
  this._iterators.forEach(function (it) {
    it.setDb(db)
  })
}

DeferredLevelDOWN.prototype._open = function (options, callback) {
  return process.nextTick(callback)
}

// queue a new deferred operation
DeferredLevelDOWN.prototype._operation = function (method, args) {
  if (this._db)
    return this._db[method].apply(this._db, args)
  this._operations.push({ method: method, args: args })
}

// deferrables
'put get del batch approximateSize'.split(' ').forEach(function (m) {
  DeferredLevelDOWN.prototype['_' + m] = function () {
    this._operation(m, arguments)
  }
})

DeferredLevelDOWN.prototype._isBuffer = function (obj) {
  return Buffer.isBuffer(obj)
}

DeferredLevelDOWN.prototype._iterator = function (options) {
  if (this._db)
    return this._db.iterator.apply(this._db, arguments)
  var it = new DeferredIterator(options)
  this._iterators.push(it)
  return it
}

module.exports                  = DeferredLevelDOWN
module.exports.DeferredIterator = DeferredIterator

}).call(this,{"isBuffer":require("../is-buffer/index.js")},require('_process'))
},{"../is-buffer/index.js":91,"./deferred-iterator":48,"_process":136,"abstract-leveldown":53,"util":308}],50:[function(require,module,exports){
(function (process){
/* Copyright (c) 2017 Rod Vagg, MIT License */

function AbstractChainedBatch (db) {
  this._db         = db
  this._operations = []
  this._written    = false
}

AbstractChainedBatch.prototype._serializeKey = function (key) {
  return this._db._serializeKey(key)
}

AbstractChainedBatch.prototype._serializeValue = function (value) {
  return this._db._serializeValue(value)
}

AbstractChainedBatch.prototype._checkWritten = function () {
  if (this._written)
    throw new Error('write() already called on this batch')
}

AbstractChainedBatch.prototype.put = function (key, value) {
  this._checkWritten()

  var err = this._db._checkKey(key, 'key', this._db._isBuffer)
  if (err)
    throw err

  key = this._serializeKey(key)
  value = this._serializeValue(value)

  if (typeof this._put == 'function' )
    this._put(key, value)
  else
    this._operations.push({ type: 'put', key: key, value: value })

  return this
}

AbstractChainedBatch.prototype.del = function (key) {
  this._checkWritten()

  var err = this._db._checkKey(key, 'key', this._db._isBuffer)
  if (err) throw err

  key = this._serializeKey(key)

  if (typeof this._del == 'function' )
    this._del(key)
  else
    this._operations.push({ type: 'del', key: key })

  return this
}

AbstractChainedBatch.prototype.clear = function () {
  this._checkWritten()

  this._operations = []

  if (typeof this._clear == 'function' )
    this._clear()

  return this
}

AbstractChainedBatch.prototype.write = function (options, callback) {
  this._checkWritten()

  if (typeof options == 'function')
    callback = options
  if (typeof callback != 'function')
    throw new Error('write() requires a callback argument')
  if (typeof options != 'object')
    options = {}

  this._written = true

  if (typeof this._write == 'function' )
    return this._write(callback)

  if (typeof this._db._batch == 'function')
    return this._db._batch(this._operations, options, callback)

  process.nextTick(callback)
}

module.exports = AbstractChainedBatch

}).call(this,require('_process'))
},{"_process":136}],51:[function(require,module,exports){
(function (process){
/* Copyright (c) 2017 Rod Vagg, MIT License */

function AbstractIterator (db) {
  this.db = db
  this._ended = false
  this._nexting = false
}

AbstractIterator.prototype.next = function (callback) {
  var self = this

  if (typeof callback != 'function')
    throw new Error('next() requires a callback argument')

  if (self._ended)
    return callback(new Error('cannot call next() after end()'))
  if (self._nexting)
    return callback(new Error('cannot call next() before previous next() has completed'))

  self._nexting = true
  if (typeof self._next == 'function') {
    return self._next(function () {
      self._nexting = false
      callback.apply(null, arguments)
    })
  }

  process.nextTick(function () {
    self._nexting = false
    callback()
  })
}

AbstractIterator.prototype.end = function (callback) {
  if (typeof callback != 'function')
    throw new Error('end() requires a callback argument')

  if (this._ended)
    return callback(new Error('end() already called on iterator'))

  this._ended = true

  if (typeof this._end == 'function')
    return this._end(callback)

  process.nextTick(callback)
}

module.exports = AbstractIterator

}).call(this,require('_process'))
},{"_process":136}],52:[function(require,module,exports){
(function (Buffer,process){
/* Copyright (c) 2017 Rod Vagg, MIT License */

var xtend                = require('xtend')
  , AbstractIterator     = require('./abstract-iterator')
  , AbstractChainedBatch = require('./abstract-chained-batch')

function AbstractLevelDOWN (location) {
  if (!arguments.length || location === undefined)
    throw new Error('constructor requires at least a location argument')

  if (typeof location != 'string')
    throw new Error('constructor requires a location string argument')

  this.location = location
  this.status = 'new'
}

AbstractLevelDOWN.prototype.open = function (options, callback) {
  var self      = this
    , oldStatus = this.status

  if (typeof options == 'function')
    callback = options

  if (typeof callback != 'function')
    throw new Error('open() requires a callback argument')

  if (typeof options != 'object')
    options = {}

  options.createIfMissing = options.createIfMissing != false
  options.errorIfExists = !!options.errorIfExists

  if (typeof this._open == 'function') {
    this.status = 'opening'
    this._open(options, function (err) {
      if (err) {
        self.status = oldStatus
        return callback(err)
      }
      self.status = 'open'
      callback()
    })
  } else {
    this.status = 'open'
    process.nextTick(callback)
  }
}

AbstractLevelDOWN.prototype.close = function (callback) {
  var self      = this
    , oldStatus = this.status

  if (typeof callback != 'function')
    throw new Error('close() requires a callback argument')

  if (typeof this._close == 'function') {
    this.status = 'closing'
    this._close(function (err) {
      if (err) {
        self.status = oldStatus
        return callback(err)
      }
      self.status = 'closed'
      callback()
    })
  } else {
    this.status = 'closed'
    process.nextTick(callback)
  }
}

AbstractLevelDOWN.prototype.get = function (key, options, callback) {
  var err

  if (typeof options == 'function')
    callback = options

  if (typeof callback != 'function')
    throw new Error('get() requires a callback argument')

  if (err = this._checkKey(key, 'key'))
    return callback(err)

  key = this._serializeKey(key)

  if (typeof options != 'object')
    options = {}

  options.asBuffer = options.asBuffer != false

  if (typeof this._get == 'function')
    return this._get(key, options, callback)

  process.nextTick(function () { callback(new Error('NotFound')) })
}

AbstractLevelDOWN.prototype.put = function (key, value, options, callback) {
  var err

  if (typeof options == 'function')
    callback = options

  if (typeof callback != 'function')
    throw new Error('put() requires a callback argument')

  if (err = this._checkKey(key, 'key'))
    return callback(err)

  key = this._serializeKey(key)
  value = this._serializeValue(value)

  if (typeof options != 'object')
    options = {}

  if (typeof this._put == 'function')
    return this._put(key, value, options, callback)

  process.nextTick(callback)
}

AbstractLevelDOWN.prototype.del = function (key, options, callback) {
  var err

  if (typeof options == 'function')
    callback = options

  if (typeof callback != 'function')
    throw new Error('del() requires a callback argument')

  if (err = this._checkKey(key, 'key'))
    return callback(err)

  key = this._serializeKey(key)

  if (typeof options != 'object')
    options = {}

  if (typeof this._del == 'function')
    return this._del(key, options, callback)

  process.nextTick(callback)
}

AbstractLevelDOWN.prototype.batch = function (array, options, callback) {
  if (!arguments.length)
    return this._chainedBatch()

  if (typeof options == 'function')
    callback = options

  if (typeof array == 'function')
    callback = array

  if (typeof callback != 'function')
    throw new Error('batch(array) requires a callback argument')

  if (!Array.isArray(array))
    return callback(new Error('batch(array) requires an array argument'))

  if (!options || typeof options != 'object')
    options = {}

  var i = 0
    , l = array.length
    , e
    , err

  for (; i < l; i++) {
    e = array[i]
    if (typeof e != 'object')
      continue

    if (err = this._checkKey(e.type, 'type'))
      return callback(err)

    if (err = this._checkKey(e.key, 'key'))
      return callback(err)
  }

  if (typeof this._batch == 'function')
    return this._batch(array, options, callback)

  process.nextTick(callback)
}

//TODO: remove from here, not a necessary primitive
AbstractLevelDOWN.prototype.approximateSize = function (start, end, callback) {
  if (   start == null
      || end == null
      || typeof start == 'function'
      || typeof end == 'function') {
    throw new Error('approximateSize() requires valid `start`, `end` and `callback` arguments')
  }

  if (typeof callback != 'function')
    throw new Error('approximateSize() requires a callback argument')

  start = this._serializeKey(start)
  end = this._serializeKey(end)

  if (typeof this._approximateSize == 'function')
    return this._approximateSize(start, end, callback)

  process.nextTick(function () {
    callback(null, 0)
  })
}

AbstractLevelDOWN.prototype._setupIteratorOptions = function (options) {
  var self = this

  options = xtend(options)

  ;[ 'start', 'end', 'gt', 'gte', 'lt', 'lte' ].forEach(function (o) {
    if (options[o] && self._isBuffer(options[o]) && options[o].length === 0)
      delete options[o]
  })

  options.reverse = !!options.reverse
  options.keys = options.keys != false
  options.values = options.values != false
  options.limit = 'limit' in options ? options.limit : -1
  options.keyAsBuffer = options.keyAsBuffer != false
  options.valueAsBuffer = options.valueAsBuffer != false

  return options
}

AbstractLevelDOWN.prototype.iterator = function (options) {
  if (typeof options != 'object')
    options = {}

  options = this._setupIteratorOptions(options)

  if (typeof this._iterator == 'function')
    return this._iterator(options)

  return new AbstractIterator(this)
}

AbstractLevelDOWN.prototype._chainedBatch = function () {
  return new AbstractChainedBatch(this)
}

AbstractLevelDOWN.prototype._isBuffer = function (obj) {
  return Buffer.isBuffer(obj)
}

AbstractLevelDOWN.prototype._serializeKey = function (key) {
  return this._isBuffer(key)
    ? key
    : String(key)
}

AbstractLevelDOWN.prototype._serializeValue = function (value) {
  if (value == null) return ''
  return this._isBuffer(value) || process.browser ? value : String(value)
}

AbstractLevelDOWN.prototype._checkKey = function (obj, type) {
  if (obj === null || obj === undefined)
    return new Error(type + ' cannot be `null` or `undefined`')

  if (this._isBuffer(obj) && obj.length === 0)
    return new Error(type + ' cannot be an empty Buffer')
  else if (String(obj) === '')
    return new Error(type + ' cannot be an empty String')
}

module.exports = AbstractLevelDOWN

}).call(this,{"isBuffer":require("../../../is-buffer/index.js")},require('_process'))
},{"../../../is-buffer/index.js":91,"./abstract-chained-batch":50,"./abstract-iterator":51,"_process":136,"xtend":310}],53:[function(require,module,exports){
exports.AbstractLevelDOWN    = require('./abstract-leveldown')
exports.AbstractIterator     = require('./abstract-iterator')
exports.AbstractChainedBatch = require('./abstract-chained-batch')
exports.isLevelDOWN          = require('./is-leveldown')

},{"./abstract-chained-batch":50,"./abstract-iterator":51,"./abstract-leveldown":52,"./is-leveldown":54}],54:[function(require,module,exports){
var AbstractLevelDOWN = require('./abstract-leveldown')

function isLevelDOWN (db) {
  if (!db || typeof db !== 'object')
    return false
  return Object.keys(AbstractLevelDOWN.prototype).filter(function (name) {
    // TODO remove approximateSize check when method is gone
    return name[0] != '_' && name != 'approximateSize'
  }).every(function (name) {
    return typeof db[name] == 'function'
  })
}

module.exports = isLevelDOWN

},{"./abstract-leveldown":52}],55:[function(require,module,exports){
/**
 * Copyright (c) 2013 Petka Antonov
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:</p>
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
"use strict";
function Deque(capacity) {
    this._capacity = getCapacity(capacity);
    this._length = 0;
    this._front = 0;
    this._makeCapacity();
    if (isArray(capacity)) {
        var len = capacity.length;
        for (var i = 0; i < len; ++i) {
            this[i] = capacity[i];
        }
        this._length = len;
    }
}

Deque.prototype.toArray = function Deque$toArray() {
    var len = this._length;
    var ret = new Array(len);
    var front = this._front;
    var capacity = this._capacity;
    for (var j = 0; j < len; ++j) {
        ret[j] = this[(front + j) & (capacity - 1)];
    }
    return ret;
};

Deque.prototype.push = function Deque$push(item) {
    var argsLength = arguments.length;
    var length = this._length;
    if (argsLength > 1) {
        var capacity = this._capacity;
        if (length + argsLength > capacity) {
            for (var i = 0; i < argsLength; ++i) {
                this._checkCapacity(length + 1);
                var j = (this._front + length) & (this._capacity - 1);
                this[j] = arguments[i];
                length++;
                this._length = length;
            }
            return length;
        }
        else {
            var j = this._front;
            for (var i = 0; i < argsLength; ++i) {
                this[(j + length) & (capacity - 1)] = arguments[i];
                j++;
            }
            this._length = length + argsLength;
            return length + argsLength;
        }

    }

    if (argsLength === 0) return length;

    this._checkCapacity(length + 1);
    var i = (this._front + length) & (this._capacity - 1);
    this[i] = item;
    this._length = length + 1;
    return length + 1;
};

Deque.prototype.pop = function Deque$pop() {
    var length = this._length;
    if (length === 0) {
        return void 0;
    }
    var i = (this._front + length - 1) & (this._capacity - 1);
    var ret = this[i];
    this[i] = void 0;
    this._length = length - 1;
    return ret;
};

Deque.prototype.shift = function Deque$shift() {
    var length = this._length;
    if (length === 0) {
        return void 0;
    }
    var front = this._front;
    var ret = this[front];
    this[front] = void 0;
    this._front = (front + 1) & (this._capacity - 1);
    this._length = length - 1;
    return ret;
};

Deque.prototype.unshift = function Deque$unshift(item) {
    var length = this._length;
    var argsLength = arguments.length;


    if (argsLength > 1) {
        var capacity = this._capacity;
        if (length + argsLength > capacity) {
            for (var i = argsLength - 1; i >= 0; i--) {
                this._checkCapacity(length + 1);
                var capacity = this._capacity;
                var j = (((( this._front - 1 ) &
                    ( capacity - 1) ) ^ capacity ) - capacity );
                this[j] = arguments[i];
                length++;
                this._length = length;
                this._front = j;
            }
            return length;
        }
        else {
            var front = this._front;
            for (var i = argsLength - 1; i >= 0; i--) {
                var j = (((( front - 1 ) &
                    ( capacity - 1) ) ^ capacity ) - capacity );
                this[j] = arguments[i];
                front = j;
            }
            this._front = front;
            this._length = length + argsLength;
            return length + argsLength;
        }
    }

    if (argsLength === 0) return length;

    this._checkCapacity(length + 1);
    var capacity = this._capacity;
    var i = (((( this._front - 1 ) &
        ( capacity - 1) ) ^ capacity ) - capacity );
    this[i] = item;
    this._length = length + 1;
    this._front = i;
    return length + 1;
};

Deque.prototype.peekBack = function Deque$peekBack() {
    var length = this._length;
    if (length === 0) {
        return void 0;
    }
    var index = (this._front + length - 1) & (this._capacity - 1);
    return this[index];
};

Deque.prototype.peekFront = function Deque$peekFront() {
    if (this._length === 0) {
        return void 0;
    }
    return this[this._front];
};

Deque.prototype.get = function Deque$get(index) {
    var i = index;
    if ((i !== (i | 0))) {
        return void 0;
    }
    var len = this._length;
    if (i < 0) {
        i = i + len;
    }
    if (i < 0 || i >= len) {
        return void 0;
    }
    return this[(this._front + i) & (this._capacity - 1)];
};

Deque.prototype.isEmpty = function Deque$isEmpty() {
    return this._length === 0;
};

Deque.prototype.clear = function Deque$clear() {
    this._length = 0;
    this._front = 0;
    this._makeCapacity();
};

Deque.prototype.toString = function Deque$toString() {
    return this.toArray().toString();
};

Deque.prototype.valueOf = Deque.prototype.toString;
Deque.prototype.removeFront = Deque.prototype.shift;
Deque.prototype.removeBack = Deque.prototype.pop;
Deque.prototype.insertFront = Deque.prototype.unshift;
Deque.prototype.insertBack = Deque.prototype.push;
Deque.prototype.enqueue = Deque.prototype.push;
Deque.prototype.dequeue = Deque.prototype.shift;
Deque.prototype.toJSON = Deque.prototype.toArray;

Object.defineProperty(Deque.prototype, "length", {
    get: function() {
        return this._length;
    },
    set: function() {
        throw new RangeError("");
    }
});

Deque.prototype._makeCapacity = function Deque$_makeCapacity() {
    var len = this._capacity;
    for (var i = 0; i < len; ++i) {
        this[i] = void 0;
    }
};

Deque.prototype._checkCapacity = function Deque$_checkCapacity(size) {
    if (this._capacity < size) {
        this._resizeTo(getCapacity(this._capacity * 1.5 + 16));
    }
};

Deque.prototype._resizeTo = function Deque$_resizeTo(capacity) {
    var oldFront = this._front;
    var oldCapacity = this._capacity;
    var oldDeque = new Array(oldCapacity);
    var length = this._length;

    arrayCopy(this, 0, oldDeque, 0, oldCapacity);
    this._capacity = capacity;
    this._makeCapacity();
    this._front = 0;
    if (oldFront + length <= oldCapacity) {
        arrayCopy(oldDeque, oldFront, this, 0, length);
    } else {        var lengthBeforeWrapping =
            length - ((oldFront + length) & (oldCapacity - 1));

        arrayCopy(oldDeque, oldFront, this, 0, lengthBeforeWrapping);
        arrayCopy(oldDeque, 0, this, lengthBeforeWrapping,
            length - lengthBeforeWrapping);
    }
};


var isArray = Array.isArray;

function arrayCopy(src, srcIndex, dst, dstIndex, len) {
    for (var j = 0; j < len; ++j) {
        dst[j + dstIndex] = src[j + srcIndex];
    }
}

function pow2AtLeast(n) {
    n = n >>> 0;
    n = n - 1;
    n = n | (n >> 1);
    n = n | (n >> 2);
    n = n | (n >> 4);
    n = n | (n >> 8);
    n = n | (n >> 16);
    return n + 1;
}

function getCapacity(capacity) {
    if (typeof capacity !== "number") {
        if (isArray(capacity)) {
            capacity = capacity.length;
        }
        else {
            return 16;
        }
    }
    return pow2AtLeast(
        Math.min(
            Math.max(16, capacity), 1073741824)
    );
}

module.exports = Deque;

},{}],56:[function(require,module,exports){
var prr = require('prr')

function init (type, message, cause) {
  if (!!message && typeof message != 'string') {
    message = message.message || message.name
  }
  prr(this, {
      type    : type
    , name    : type
      // can be passed just a 'cause'
    , cause   : typeof message != 'string' ? message : cause
    , message : message
  }, 'ewr')
}

// generic prototype, not intended to be actually used - helpful for `instanceof`
function CustomError (message, cause) {
  Error.call(this)
  if (Error.captureStackTrace)
    Error.captureStackTrace(this, this.constructor)
  init.call(this, 'CustomError', message, cause)
}

CustomError.prototype = new Error()

function createError (errno, type, proto) {
  var err = function (message, cause) {
    init.call(this, type, message, cause)
    //TODO: the specificity here is stupid, errno should be available everywhere
    if (type == 'FilesystemError') {
      this.code    = this.cause.code
      this.path    = this.cause.path
      this.errno   = this.cause.errno
      this.message =
        (errno.errno[this.cause.errno]
          ? errno.errno[this.cause.errno].description
          : this.cause.message)
        + (this.cause.path ? ' [' + this.cause.path + ']' : '')
    }
    Error.call(this)
    if (Error.captureStackTrace)
      Error.captureStackTrace(this, err)
  }
  err.prototype = !!proto ? new proto() : new CustomError()
  return err
}

module.exports = function (errno) {
  var ce = function (type, proto) {
    return createError(errno, type, proto)
  }
  return {
      CustomError     : CustomError
    , FilesystemError : ce('FilesystemError')
    , createError     : ce
  }
}

},{"prr":137}],57:[function(require,module,exports){
var all = module.exports.all = [
  {
    errno: -2,
    code: 'ENOENT',
    description: 'no such file or directory'
  },
  {
    errno: -1,
    code: 'UNKNOWN',
    description: 'unknown error'
  },
  {
    errno: 0,
    code: 'OK',
    description: 'success'
  },
  {
    errno: 1,
    code: 'EOF',
    description: 'end of file'
  },
  {
    errno: 2,
    code: 'EADDRINFO',
    description: 'getaddrinfo error'
  },
  {
    errno: 3,
    code: 'EACCES',
    description: 'permission denied'
  },
  {
    errno: 4,
    code: 'EAGAIN',
    description: 'resource temporarily unavailable'
  },
  {
    errno: 5,
    code: 'EADDRINUSE',
    description: 'address already in use'
  },
  {
    errno: 6,
    code: 'EADDRNOTAVAIL',
    description: 'address not available'
  },
  {
    errno: 7,
    code: 'EAFNOSUPPORT',
    description: 'address family not supported'
  },
  {
    errno: 8,
    code: 'EALREADY',
    description: 'connection already in progress'
  },
  {
    errno: 9,
    code: 'EBADF',
    description: 'bad file descriptor'
  },
  {
    errno: 10,
    code: 'EBUSY',
    description: 'resource busy or locked'
  },
  {
    errno: 11,
    code: 'ECONNABORTED',
    description: 'software caused connection abort'
  },
  {
    errno: 12,
    code: 'ECONNREFUSED',
    description: 'connection refused'
  },
  {
    errno: 13,
    code: 'ECONNRESET',
    description: 'connection reset by peer'
  },
  {
    errno: 14,
    code: 'EDESTADDRREQ',
    description: 'destination address required'
  },
  {
    errno: 15,
    code: 'EFAULT',
    description: 'bad address in system call argument'
  },
  {
    errno: 16,
    code: 'EHOSTUNREACH',
    description: 'host is unreachable'
  },
  {
    errno: 17,
    code: 'EINTR',
    description: 'interrupted system call'
  },
  {
    errno: 18,
    code: 'EINVAL',
    description: 'invalid argument'
  },
  {
    errno: 19,
    code: 'EISCONN',
    description: 'socket is already connected'
  },
  {
    errno: 20,
    code: 'EMFILE',
    description: 'too many open files'
  },
  {
    errno: 21,
    code: 'EMSGSIZE',
    description: 'message too long'
  },
  {
    errno: 22,
    code: 'ENETDOWN',
    description: 'network is down'
  },
  {
    errno: 23,
    code: 'ENETUNREACH',
    description: 'network is unreachable'
  },
  {
    errno: 24,
    code: 'ENFILE',
    description: 'file table overflow'
  },
  {
    errno: 25,
    code: 'ENOBUFS',
    description: 'no buffer space available'
  },
  {
    errno: 26,
    code: 'ENOMEM',
    description: 'not enough memory'
  },
  {
    errno: 27,
    code: 'ENOTDIR',
    description: 'not a directory'
  },
  {
    errno: 28,
    code: 'EISDIR',
    description: 'illegal operation on a directory'
  },
  {
    errno: 29,
    code: 'ENONET',
    description: 'machine is not on the network'
  },
  {
    errno: 31,
    code: 'ENOTCONN',
    description: 'socket is not connected'
  },
  {
    errno: 32,
    code: 'ENOTSOCK',
    description: 'socket operation on non-socket'
  },
  {
    errno: 33,
    code: 'ENOTSUP',
    description: 'operation not supported on socket'
  },
  {
    errno: 34,
    code: 'ENOENT',
    description: 'no such file or directory'
  },
  {
    errno: 35,
    code: 'ENOSYS',
    description: 'function not implemented'
  },
  {
    errno: 36,
    code: 'EPIPE',
    description: 'broken pipe'
  },
  {
    errno: 37,
    code: 'EPROTO',
    description: 'protocol error'
  },
  {
    errno: 38,
    code: 'EPROTONOSUPPORT',
    description: 'protocol not supported'
  },
  {
    errno: 39,
    code: 'EPROTOTYPE',
    description: 'protocol wrong type for socket'
  },
  {
    errno: 40,
    code: 'ETIMEDOUT',
    description: 'connection timed out'
  },
  {
    errno: 41,
    code: 'ECHARSET',
    description: 'invalid Unicode character'
  },
  {
    errno: 42,
    code: 'EAIFAMNOSUPPORT',
    description: 'address family for hostname not supported'
  },
  {
    errno: 44,
    code: 'EAISERVICE',
    description: 'servname not supported for ai_socktype'
  },
  {
    errno: 45,
    code: 'EAISOCKTYPE',
    description: 'ai_socktype not supported'
  },
  {
    errno: 46,
    code: 'ESHUTDOWN',
    description: 'cannot send after transport endpoint shutdown'
  },
  {
    errno: 47,
    code: 'EEXIST',
    description: 'file already exists'
  },
  {
    errno: 48,
    code: 'ESRCH',
    description: 'no such process'
  },
  {
    errno: 49,
    code: 'ENAMETOOLONG',
    description: 'name too long'
  },
  {
    errno: 50,
    code: 'EPERM',
    description: 'operation not permitted'
  },
  {
    errno: 51,
    code: 'ELOOP',
    description: 'too many symbolic links encountered'
  },
  {
    errno: 52,
    code: 'EXDEV',
    description: 'cross-device link not permitted'
  },
  {
    errno: 53,
    code: 'ENOTEMPTY',
    description: 'directory not empty'
  },
  {
    errno: 54,
    code: 'ENOSPC',
    description: 'no space left on device'
  },
  {
    errno: 55,
    code: 'EIO',
    description: 'i/o error'
  },
  {
    errno: 56,
    code: 'EROFS',
    description: 'read-only file system'
  },
  {
    errno: 57,
    code: 'ENODEV',
    description: 'no such device'
  },
  {
    errno: 58,
    code: 'ESPIPE',
    description: 'invalid seek'
  },
  {
    errno: 59,
    code: 'ECANCELED',
    description: 'operation canceled'
  }
]

module.exports.errno = {}
module.exports.code = {}

all.forEach(function (error) {
  module.exports.errno[error.errno] = error
  module.exports.code[error.code] = error
})

module.exports.custom = require('./custom')(module.exports)
module.exports.create = module.exports.custom.createError

},{"./custom":56}],58:[function(require,module,exports){
(function (root, factory) {
  /* istanbul ignore next */
  if (typeof define === 'function' && define.amd) {
    define([], factory)
  } else if (typeof exports === 'object') {
    module.exports = factory()
  } else {
    root.PromisePool = factory()
    // Legacy API
    root.promisePool = root.PromisePool
  }
})(this, function () {
  'use strict'

  var EventTarget = function () {
    this._listeners = {}
  }

  EventTarget.prototype.addEventListener = function (type, listener) {
    this._listeners[type] = this._listeners[type] || []
    if (this._listeners[type].indexOf(listener) < 0) {
      this._listeners[type].push(listener)
    }
  }

  EventTarget.prototype.removeEventListener = function (type, listener) {
    if (this._listeners[type]) {
      var p = this._listeners[type].indexOf(listener)
      if (p >= 0) {
        this._listeners[type].splice(p, 1)
      }
    }
  }

  EventTarget.prototype.dispatchEvent = function (evt) {
    if (this._listeners[evt.type] && this._listeners[evt.type].length) {
      var listeners = this._listeners[evt.type].slice()
      for (var i = 0, l = listeners.length; i < l; ++i) {
        listeners[i].call(this, evt)
      }
    }
  }

  var isGenerator = function (func) {
    return (typeof func.constructor === 'function' &&
      func.constructor.name === 'GeneratorFunction')
  }

  var functionToIterator = function (func) {
    return {
      next: function () {
        var promise = func()
        return promise ? {value: promise} : {done: true}
      }
    }
  }

  var promiseToIterator = function (promise) {
    var called = false
    return {
      next: function () {
        if (called) {
          return {done: true}
        }
        called = true
        return {value: promise}
      }
    }
  }

  var toIterator = function (obj, Promise) {
    var type = typeof obj
    if (type === 'object') {
      if (typeof obj.next === 'function') {
        return obj
      }
      /* istanbul ignore else */
      if (typeof obj.then === 'function') {
        return promiseToIterator(obj)
      }
    }
    if (type === 'function') {
      return isGenerator(obj) ? obj() : functionToIterator(obj)
    }
    return promiseToIterator(Promise.resolve(obj))
  }

  var PromisePoolEvent = function (target, type, data) {
    this.target = target
    this.type = type
    this.data = data
  }

  var PromisePool = function (source, concurrency, options) {
    EventTarget.call(this)
    if (typeof concurrency !== 'number' ||
        Math.floor(concurrency) !== concurrency ||
        concurrency < 1) {
      throw new Error('Invalid concurrency')
    }
    this._concurrency = concurrency
    this._options = options || {}
    this._options.promise = this._options.promise || Promise
    this._iterator = toIterator(source, this._options.promise)
    this._done = false
    this._size = 0
    this._promise = null
    this._callbacks = null
  }
  PromisePool.prototype = new EventTarget()
  PromisePool.prototype.constructor = PromisePool

  PromisePool.prototype.concurrency = function (value) {
    if (typeof value !== 'undefined') {
      this._concurrency = value
      if (this.active()) {
        this._proceed()
      }
    }
    return this._concurrency
  }

  PromisePool.prototype.size = function () {
    return this._size
  }

  PromisePool.prototype.active = function () {
    return !!this._promise
  }

  PromisePool.prototype.promise = function () {
    return this._promise
  }

  PromisePool.prototype.start = function () {
    var that = this
    var Promise = this._options.promise
    this._promise = new Promise(function (resolve, reject) {
      that._callbacks = {
        reject: reject,
        resolve: resolve
      }
      that._proceed()
    })
    return this._promise
  }

  PromisePool.prototype._fireEvent = function (type, data) {
    this.dispatchEvent(new PromisePoolEvent(this, type, data))
  }

  PromisePool.prototype._settle = function (error) {
    if (error) {
      this._callbacks.reject(error)
    } else {
      this._callbacks.resolve()
    }
    this._promise = null
    this._callbacks = null
  }

  PromisePool.prototype._onPooledPromiseFulfilled = function (promise, result) {
    this._size--
    if (this.active()) {
      this._fireEvent('fulfilled', {
        promise: promise,
        result: result
      })
      this._proceed()
    }
  }

  PromisePool.prototype._onPooledPromiseRejected = function (promise, error) {
    this._size--
    if (this.active()) {
      this._fireEvent('rejected', {
        promise: promise,
        error: error
      })
      this._settle(error || new Error('Unknown error'))
    }
  }

  PromisePool.prototype._trackPromise = function (promise) {
    var that = this
    promise
      .then(function (result) {
        that._onPooledPromiseFulfilled(promise, result)
      }, function (error) {
        that._onPooledPromiseRejected(promise, error)
      })['catch'](function (err) {
        that._settle(new Error('Promise processing failed: ' + err))
      })
  }

  PromisePool.prototype._proceed = function () {
    if (!this._done) {
      var result = null
      while (this._size < this._concurrency &&
          !(result = this._iterator.next()).done) {
        this._size++
        this._trackPromise(result.value)
      }
      this._done = (result === null || !!result.done)
    }
    if (this._done && this._size === 0) {
      this._settle()
    }
  }

  PromisePool.PromisePoolEvent = PromisePoolEvent
  // Legacy API
  PromisePool.PromisePool = PromisePool

  return PromisePool
})

},{}],59:[function(require,module,exports){
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

function EventEmitter() {
  this._events = this._events || {};
  this._maxListeners = this._maxListeners || undefined;
}
module.exports = EventEmitter;

// Backwards-compat with node 0.10.x
EventEmitter.EventEmitter = EventEmitter;

EventEmitter.prototype._events = undefined;
EventEmitter.prototype._maxListeners = undefined;

// By default EventEmitters will print a warning if more than 10 listeners are
// added to it. This is a useful default which helps finding memory leaks.
EventEmitter.defaultMaxListeners = 10;

// Obviously not all Emitters should be limited to 10. This function allows
// that to be increased. Set to zero for unlimited.
EventEmitter.prototype.setMaxListeners = function(n) {
  if (!isNumber(n) || n < 0 || isNaN(n))
    throw TypeError('n must be a positive number');
  this._maxListeners = n;
  return this;
};

EventEmitter.prototype.emit = function(type) {
  var er, handler, len, args, i, listeners;

  if (!this._events)
    this._events = {};

  // If there is no 'error' event listener then throw.
  if (type === 'error') {
    if (!this._events.error ||
        (isObject(this._events.error) && !this._events.error.length)) {
      er = arguments[1];
      if (er instanceof Error) {
        throw er; // Unhandled 'error' event
      } else {
        // At least give some kind of context to the user
        var err = new Error('Uncaught, unspecified "error" event. (' + er + ')');
        err.context = er;
        throw err;
      }
    }
  }

  handler = this._events[type];

  if (isUndefined(handler))
    return false;

  if (isFunction(handler)) {
    switch (arguments.length) {
      // fast cases
      case 1:
        handler.call(this);
        break;
      case 2:
        handler.call(this, arguments[1]);
        break;
      case 3:
        handler.call(this, arguments[1], arguments[2]);
        break;
      // slower
      default:
        args = Array.prototype.slice.call(arguments, 1);
        handler.apply(this, args);
    }
  } else if (isObject(handler)) {
    args = Array.prototype.slice.call(arguments, 1);
    listeners = handler.slice();
    len = listeners.length;
    for (i = 0; i < len; i++)
      listeners[i].apply(this, args);
  }

  return true;
};

EventEmitter.prototype.addListener = function(type, listener) {
  var m;

  if (!isFunction(listener))
    throw TypeError('listener must be a function');

  if (!this._events)
    this._events = {};

  // To avoid recursion in the case that type === "newListener"! Before
  // adding it to the listeners, first emit "newListener".
  if (this._events.newListener)
    this.emit('newListener', type,
              isFunction(listener.listener) ?
              listener.listener : listener);

  if (!this._events[type])
    // Optimize the case of one listener. Don't need the extra array object.
    this._events[type] = listener;
  else if (isObject(this._events[type]))
    // If we've already got an array, just append.
    this._events[type].push(listener);
  else
    // Adding the second element, need to change to array.
    this._events[type] = [this._events[type], listener];

  // Check for listener leak
  if (isObject(this._events[type]) && !this._events[type].warned) {
    if (!isUndefined(this._maxListeners)) {
      m = this._maxListeners;
    } else {
      m = EventEmitter.defaultMaxListeners;
    }

    if (m && m > 0 && this._events[type].length > m) {
      this._events[type].warned = true;
      console.error('(node) warning: possible EventEmitter memory ' +
                    'leak detected. %d listeners added. ' +
                    'Use emitter.setMaxListeners() to increase limit.',
                    this._events[type].length);
      if (typeof console.trace === 'function') {
        // not supported in IE 10
        console.trace();
      }
    }
  }

  return this;
};

EventEmitter.prototype.on = EventEmitter.prototype.addListener;

EventEmitter.prototype.once = function(type, listener) {
  if (!isFunction(listener))
    throw TypeError('listener must be a function');

  var fired = false;

  function g() {
    this.removeListener(type, g);

    if (!fired) {
      fired = true;
      listener.apply(this, arguments);
    }
  }

  g.listener = listener;
  this.on(type, g);

  return this;
};

// emits a 'removeListener' event iff the listener was removed
EventEmitter.prototype.removeListener = function(type, listener) {
  var list, position, length, i;

  if (!isFunction(listener))
    throw TypeError('listener must be a function');

  if (!this._events || !this._events[type])
    return this;

  list = this._events[type];
  length = list.length;
  position = -1;

  if (list === listener ||
      (isFunction(list.listener) && list.listener === listener)) {
    delete this._events[type];
    if (this._events.removeListener)
      this.emit('removeListener', type, listener);

  } else if (isObject(list)) {
    for (i = length; i-- > 0;) {
      if (list[i] === listener ||
          (list[i].listener && list[i].listener === listener)) {
        position = i;
        break;
      }
    }

    if (position < 0)
      return this;

    if (list.length === 1) {
      list.length = 0;
      delete this._events[type];
    } else {
      list.splice(position, 1);
    }

    if (this._events.removeListener)
      this.emit('removeListener', type, listener);
  }

  return this;
};

EventEmitter.prototype.removeAllListeners = function(type) {
  var key, listeners;

  if (!this._events)
    return this;

  // not listening for removeListener, no need to emit
  if (!this._events.removeListener) {
    if (arguments.length === 0)
      this._events = {};
    else if (this._events[type])
      delete this._events[type];
    return this;
  }

  // emit removeListener for all listeners on all events
  if (arguments.length === 0) {
    for (key in this._events) {
      if (key === 'removeListener') continue;
      this.removeAllListeners(key);
    }
    this.removeAllListeners('removeListener');
    this._events = {};
    return this;
  }

  listeners = this._events[type];

  if (isFunction(listeners)) {
    this.removeListener(type, listeners);
  } else if (listeners) {
    // LIFO order
    while (listeners.length)
      this.removeListener(type, listeners[listeners.length - 1]);
  }
  delete this._events[type];

  return this;
};

EventEmitter.prototype.listeners = function(type) {
  var ret;
  if (!this._events || !this._events[type])
    ret = [];
  else if (isFunction(this._events[type]))
    ret = [this._events[type]];
  else
    ret = this._events[type].slice();
  return ret;
};

EventEmitter.prototype.listenerCount = function(type) {
  if (this._events) {
    var evlistener = this._events[type];

    if (isFunction(evlistener))
      return 1;
    else if (evlistener)
      return evlistener.length;
  }
  return 0;
};

EventEmitter.listenerCount = function(emitter, type) {
  return emitter.listenerCount(type);
};

function isFunction(arg) {
  return typeof arg === 'function';
}

function isNumber(arg) {
  return typeof arg === 'number';
}

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}

function isUndefined(arg) {
  return arg === void 0;
}

},{}],60:[function(require,module,exports){
(function (process){
/**
 * Copyright 2013-2015, Facebook, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @providesModule EventListener
 * @typechecks
 */

'use strict';

var emptyFunction = require('./emptyFunction');

/**
 * Upstream version of event listener. Does not take into account specific
 * nature of platform.
 */
var EventListener = {
  /**
   * Listen to DOM events during the bubble phase.
   *
   * @param {DOMEventTarget} target DOM element to register listener on.
   * @param {string} eventType Event type, e.g. 'click' or 'mouseover'.
   * @param {function} callback Callback function.
   * @return {object} Object with a `remove` method.
   */
  listen: function (target, eventType, callback) {
    if (target.addEventListener) {
      target.addEventListener(eventType, callback, false);
      return {
        remove: function () {
          target.removeEventListener(eventType, callback, false);
        }
      };
    } else if (target.attachEvent) {
      target.attachEvent('on' + eventType, callback);
      return {
        remove: function () {
          target.detachEvent('on' + eventType, callback);
        }
      };
    }
  },

  /**
   * Listen to DOM events during the capture phase.
   *
   * @param {DOMEventTarget} target DOM element to register listener on.
   * @param {string} eventType Event type, e.g. 'click' or 'mouseover'.
   * @param {function} callback Callback function.
   * @return {object} Object with a `remove` method.
   */
  capture: function (target, eventType, callback) {
    if (target.addEventListener) {
      target.addEventListener(eventType, callback, true);
      return {
        remove: function () {
          target.removeEventListener(eventType, callback, true);
        }
      };
    } else {
      if (process.env.NODE_ENV !== 'production') {
        console.error('Attempted to listen to events during the capture phase on a ' + 'browser that does not support the capture phase. Your application ' + 'will not receive some events.');
      }
      return {
        remove: emptyFunction
      };
    }
  },

  registerDefault: function () {}
};

module.exports = EventListener;
}).call(this,require('_process'))
},{"./emptyFunction":67,"_process":136}],61:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule ExecutionEnvironment
 */

'use strict';

var canUseDOM = !!(typeof window !== 'undefined' && window.document && window.document.createElement);

/**
 * Simple, lightweight module assisting with the detection and context of
 * Worker. Helps avoid circular dependencies and allows code to reason about
 * whether or not they are in a Worker, even if they never include the main
 * `ReactWorker` dependency.
 */
var ExecutionEnvironment = {

  canUseDOM: canUseDOM,

  canUseWorkers: typeof Worker !== 'undefined',

  canUseEventListeners: canUseDOM && !!(window.addEventListener || window.attachEvent),

  canUseViewport: canUseDOM && !!window.screen,

  isInWorker: !canUseDOM // For now, this is true - might change in the future.

};

module.exports = ExecutionEnvironment;
},{}],62:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule camelize
 * @typechecks
 */

"use strict";

var _hyphenPattern = /-(.)/g;

/**
 * Camelcases a hyphenated string, for example:
 *
 *   > camelize('background-color')
 *   < "backgroundColor"
 *
 * @param {string} string
 * @return {string}
 */
function camelize(string) {
  return string.replace(_hyphenPattern, function (_, character) {
    return character.toUpperCase();
  });
}

module.exports = camelize;
},{}],63:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule camelizeStyleName
 * @typechecks
 */

'use strict';

var camelize = require('./camelize');

var msPattern = /^-ms-/;

/**
 * Camelcases a hyphenated CSS property name, for example:
 *
 *   > camelizeStyleName('background-color')
 *   < "backgroundColor"
 *   > camelizeStyleName('-moz-transition')
 *   < "MozTransition"
 *   > camelizeStyleName('-ms-transition')
 *   < "msTransition"
 *
 * As Andi Smith suggests
 * (http://www.andismith.com/blog/2012/02/modernizr-prefixed/), an `-ms` prefix
 * is converted to lowercase `ms`.
 *
 * @param {string} string
 * @return {string}
 */
function camelizeStyleName(string) {
  return camelize(string.replace(msPattern, 'ms-'));
}

module.exports = camelizeStyleName;
},{"./camelize":62}],64:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule containsNode
 * @typechecks
 */

'use strict';

var isTextNode = require('./isTextNode');

/*eslint-disable no-bitwise */

/**
 * Checks if a given DOM node contains or is another DOM node.
 *
 * @param {?DOMNode} outerNode Outer DOM node.
 * @param {?DOMNode} innerNode Inner DOM node.
 * @return {boolean} True if `outerNode` contains or is `innerNode`.
 */
function containsNode(_x, _x2) {
  var _again = true;

  _function: while (_again) {
    var outerNode = _x,
        innerNode = _x2;
    _again = false;

    if (!outerNode || !innerNode) {
      return false;
    } else if (outerNode === innerNode) {
      return true;
    } else if (isTextNode(outerNode)) {
      return false;
    } else if (isTextNode(innerNode)) {
      _x = outerNode;
      _x2 = innerNode.parentNode;
      _again = true;
      continue _function;
    } else if (outerNode.contains) {
      return outerNode.contains(innerNode);
    } else if (outerNode.compareDocumentPosition) {
      return !!(outerNode.compareDocumentPosition(innerNode) & 16);
    } else {
      return false;
    }
  }
}

module.exports = containsNode;
},{"./isTextNode":77}],65:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule createArrayFromMixed
 * @typechecks
 */

'use strict';

var toArray = require('./toArray');

/**
 * Perform a heuristic test to determine if an object is "array-like".
 *
 *   A monk asked Joshu, a Zen master, "Has a dog Buddha nature?"
 *   Joshu replied: "Mu."
 *
 * This function determines if its argument has "array nature": it returns
 * true if the argument is an actual array, an `arguments' object, or an
 * HTMLCollection (e.g. node.childNodes or node.getElementsByTagName()).
 *
 * It will return false for other array-like objects like Filelist.
 *
 * @param {*} obj
 * @return {boolean}
 */
function hasArrayNature(obj) {
  return(
    // not null/false
    !!obj && (
    // arrays are objects, NodeLists are functions in Safari
    typeof obj == 'object' || typeof obj == 'function') &&
    // quacks like an array
    'length' in obj &&
    // not window
    !('setInterval' in obj) &&
    // no DOM node should be considered an array-like
    // a 'select' element has 'length' and 'item' properties on IE8
    typeof obj.nodeType != 'number' && (
    // a real array
    Array.isArray(obj) ||
    // arguments
    'callee' in obj ||
    // HTMLCollection/NodeList
    'item' in obj)
  );
}

/**
 * Ensure that the argument is an array by wrapping it in an array if it is not.
 * Creates a copy of the argument if it is already an array.
 *
 * This is mostly useful idiomatically:
 *
 *   var createArrayFromMixed = require('createArrayFromMixed');
 *
 *   function takesOneOrMoreThings(things) {
 *     things = createArrayFromMixed(things);
 *     ...
 *   }
 *
 * This allows you to treat `things' as an array, but accept scalars in the API.
 *
 * If you need to convert an array-like object, like `arguments`, into an array
 * use toArray instead.
 *
 * @param {*} obj
 * @return {array}
 */
function createArrayFromMixed(obj) {
  if (!hasArrayNature(obj)) {
    return [obj];
  } else if (Array.isArray(obj)) {
    return obj.slice();
  } else {
    return toArray(obj);
  }
}

module.exports = createArrayFromMixed;
},{"./toArray":85}],66:[function(require,module,exports){
(function (process){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule createNodesFromMarkup
 * @typechecks
 */

/*eslint-disable fb-www/unsafe-html*/

'use strict';

var ExecutionEnvironment = require('./ExecutionEnvironment');

var createArrayFromMixed = require('./createArrayFromMixed');
var getMarkupWrap = require('./getMarkupWrap');
var invariant = require('./invariant');

/**
 * Dummy container used to render all markup.
 */
var dummyNode = ExecutionEnvironment.canUseDOM ? document.createElement('div') : null;

/**
 * Pattern used by `getNodeName`.
 */
var nodeNamePattern = /^\s*<(\w+)/;

/**
 * Extracts the `nodeName` of the first element in a string of markup.
 *
 * @param {string} markup String of markup.
 * @return {?string} Node name of the supplied markup.
 */
function getNodeName(markup) {
  var nodeNameMatch = markup.match(nodeNamePattern);
  return nodeNameMatch && nodeNameMatch[1].toLowerCase();
}

/**
 * Creates an array containing the nodes rendered from the supplied markup. The
 * optionally supplied `handleScript` function will be invoked once for each
 * <script> element that is rendered. If no `handleScript` function is supplied,
 * an exception is thrown if any <script> elements are rendered.
 *
 * @param {string} markup A string of valid HTML markup.
 * @param {?function} handleScript Invoked once for each rendered <script>.
 * @return {array<DOMElement|DOMTextNode>} An array of rendered nodes.
 */
function createNodesFromMarkup(markup, handleScript) {
  var node = dummyNode;
  !!!dummyNode ? process.env.NODE_ENV !== 'production' ? invariant(false, 'createNodesFromMarkup dummy not initialized') : invariant(false) : undefined;
  var nodeName = getNodeName(markup);

  var wrap = nodeName && getMarkupWrap(nodeName);
  if (wrap) {
    node.innerHTML = wrap[1] + markup + wrap[2];

    var wrapDepth = wrap[0];
    while (wrapDepth--) {
      node = node.lastChild;
    }
  } else {
    node.innerHTML = markup;
  }

  var scripts = node.getElementsByTagName('script');
  if (scripts.length) {
    !handleScript ? process.env.NODE_ENV !== 'production' ? invariant(false, 'createNodesFromMarkup(...): Unexpected <script> element rendered.') : invariant(false) : undefined;
    createArrayFromMixed(scripts).forEach(handleScript);
  }

  var nodes = createArrayFromMixed(node.childNodes);
  while (node.lastChild) {
    node.removeChild(node.lastChild);
  }
  return nodes;
}

module.exports = createNodesFromMarkup;
}).call(this,require('_process'))
},{"./ExecutionEnvironment":61,"./createArrayFromMixed":65,"./getMarkupWrap":71,"./invariant":75,"_process":136}],67:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule emptyFunction
 */

"use strict";

function makeEmptyFunction(arg) {
  return function () {
    return arg;
  };
}

/**
 * This function accepts and discards inputs; it has no side effects. This is
 * primarily useful idiomatically for overridable function endpoints which
 * always need to be callable, since JS lacks a null-call idiom ala Cocoa.
 */
function emptyFunction() {}

emptyFunction.thatReturns = makeEmptyFunction;
emptyFunction.thatReturnsFalse = makeEmptyFunction(false);
emptyFunction.thatReturnsTrue = makeEmptyFunction(true);
emptyFunction.thatReturnsNull = makeEmptyFunction(null);
emptyFunction.thatReturnsThis = function () {
  return this;
};
emptyFunction.thatReturnsArgument = function (arg) {
  return arg;
};

module.exports = emptyFunction;
},{}],68:[function(require,module,exports){
(function (process){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule emptyObject
 */

'use strict';

var emptyObject = {};

if (process.env.NODE_ENV !== 'production') {
  Object.freeze(emptyObject);
}

module.exports = emptyObject;
}).call(this,require('_process'))
},{"_process":136}],69:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule focusNode
 */

'use strict';

/**
 * @param {DOMElement} node input/textarea to focus
 */
function focusNode(node) {
  // IE8 can throw "Can't move focus to the control because it is invisible,
  // not enabled, or of a type that does not accept the focus." for all kinds of
  // reasons that are too expensive and fragile to test.
  try {
    node.focus();
  } catch (e) {}
}

module.exports = focusNode;
},{}],70:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule getActiveElement
 * @typechecks
 */

/* eslint-disable fb-www/typeof-undefined */

/**
 * Same as document.activeElement but wraps in a try-catch block. In IE it is
 * not safe to call document.activeElement if there is nothing focused.
 *
 * The activeElement will be null only if the document or document body is not
 * yet defined.
 */
'use strict';

function getActiveElement() /*?DOMElement*/{
  if (typeof document === 'undefined') {
    return null;
  }
  try {
    return document.activeElement || document.body;
  } catch (e) {
    return document.body;
  }
}

module.exports = getActiveElement;
},{}],71:[function(require,module,exports){
(function (process){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule getMarkupWrap
 */

/*eslint-disable fb-www/unsafe-html */

'use strict';

var ExecutionEnvironment = require('./ExecutionEnvironment');

var invariant = require('./invariant');

/**
 * Dummy container used to detect which wraps are necessary.
 */
var dummyNode = ExecutionEnvironment.canUseDOM ? document.createElement('div') : null;

/**
 * Some browsers cannot use `innerHTML` to render certain elements standalone,
 * so we wrap them, render the wrapped nodes, then extract the desired node.
 *
 * In IE8, certain elements cannot render alone, so wrap all elements ('*').
 */

var shouldWrap = {};

var selectWrap = [1, '<select multiple="true">', '</select>'];
var tableWrap = [1, '<table>', '</table>'];
var trWrap = [3, '<table><tbody><tr>', '</tr></tbody></table>'];

var svgWrap = [1, '<svg xmlns="http://www.w3.org/2000/svg">', '</svg>'];

var markupWrap = {
  '*': [1, '?<div>', '</div>'],

  'area': [1, '<map>', '</map>'],
  'col': [2, '<table><tbody></tbody><colgroup>', '</colgroup></table>'],
  'legend': [1, '<fieldset>', '</fieldset>'],
  'param': [1, '<object>', '</object>'],
  'tr': [2, '<table><tbody>', '</tbody></table>'],

  'optgroup': selectWrap,
  'option': selectWrap,

  'caption': tableWrap,
  'colgroup': tableWrap,
  'tbody': tableWrap,
  'tfoot': tableWrap,
  'thead': tableWrap,

  'td': trWrap,
  'th': trWrap
};

// Initialize the SVG elements since we know they'll always need to be wrapped
// consistently. If they are created inside a <div> they will be initialized in
// the wrong namespace (and will not display).
var svgElements = ['circle', 'clipPath', 'defs', 'ellipse', 'g', 'image', 'line', 'linearGradient', 'mask', 'path', 'pattern', 'polygon', 'polyline', 'radialGradient', 'rect', 'stop', 'text', 'tspan'];
svgElements.forEach(function (nodeName) {
  markupWrap[nodeName] = svgWrap;
  shouldWrap[nodeName] = true;
});

/**
 * Gets the markup wrap configuration for the supplied `nodeName`.
 *
 * NOTE: This lazily detects which wraps are necessary for the current browser.
 *
 * @param {string} nodeName Lowercase `nodeName`.
 * @return {?array} Markup wrap configuration, if applicable.
 */
function getMarkupWrap(nodeName) {
  !!!dummyNode ? process.env.NODE_ENV !== 'production' ? invariant(false, 'Markup wrapping node not initialized') : invariant(false) : undefined;
  if (!markupWrap.hasOwnProperty(nodeName)) {
    nodeName = '*';
  }
  if (!shouldWrap.hasOwnProperty(nodeName)) {
    if (nodeName === '*') {
      dummyNode.innerHTML = '<link />';
    } else {
      dummyNode.innerHTML = '<' + nodeName + '></' + nodeName + '>';
    }
    shouldWrap[nodeName] = !dummyNode.firstChild;
  }
  return shouldWrap[nodeName] ? markupWrap[nodeName] : null;
}

module.exports = getMarkupWrap;
}).call(this,require('_process'))
},{"./ExecutionEnvironment":61,"./invariant":75,"_process":136}],72:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule getUnboundedScrollPosition
 * @typechecks
 */

'use strict';

/**
 * Gets the scroll position of the supplied element or window.
 *
 * The return values are unbounded, unlike `getScrollPosition`. This means they
 * may be negative or exceed the element boundaries (which is possible using
 * inertial scrolling).
 *
 * @param {DOMWindow|DOMElement} scrollable
 * @return {object} Map with `x` and `y` keys.
 */
function getUnboundedScrollPosition(scrollable) {
  if (scrollable === window) {
    return {
      x: window.pageXOffset || document.documentElement.scrollLeft,
      y: window.pageYOffset || document.documentElement.scrollTop
    };
  }
  return {
    x: scrollable.scrollLeft,
    y: scrollable.scrollTop
  };
}

module.exports = getUnboundedScrollPosition;
},{}],73:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule hyphenate
 * @typechecks
 */

'use strict';

var _uppercasePattern = /([A-Z])/g;

/**
 * Hyphenates a camelcased string, for example:
 *
 *   > hyphenate('backgroundColor')
 *   < "background-color"
 *
 * For CSS style names, use `hyphenateStyleName` instead which works properly
 * with all vendor prefixes, including `ms`.
 *
 * @param {string} string
 * @return {string}
 */
function hyphenate(string) {
  return string.replace(_uppercasePattern, '-$1').toLowerCase();
}

module.exports = hyphenate;
},{}],74:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule hyphenateStyleName
 * @typechecks
 */

'use strict';

var hyphenate = require('./hyphenate');

var msPattern = /^ms-/;

/**
 * Hyphenates a camelcased CSS property name, for example:
 *
 *   > hyphenateStyleName('backgroundColor')
 *   < "background-color"
 *   > hyphenateStyleName('MozTransition')
 *   < "-moz-transition"
 *   > hyphenateStyleName('msTransition')
 *   < "-ms-transition"
 *
 * As Modernizr suggests (http://modernizr.com/docs/#prefixed), an `ms` prefix
 * is converted to `-ms-`.
 *
 * @param {string} string
 * @return {string}
 */
function hyphenateStyleName(string) {
  return hyphenate(string).replace(msPattern, '-ms-');
}

module.exports = hyphenateStyleName;
},{"./hyphenate":73}],75:[function(require,module,exports){
(function (process){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule invariant
 */

'use strict';

/**
 * Use invariant() to assert state which your program assumes to be true.
 *
 * Provide sprintf-style format (only %s is supported) and arguments
 * to provide information about what broke and what you were
 * expecting.
 *
 * The invariant message will be stripped in production, but the invariant
 * will remain to ensure logic does not differ in production.
 */

function invariant(condition, format, a, b, c, d, e, f) {
  if (process.env.NODE_ENV !== 'production') {
    if (format === undefined) {
      throw new Error('invariant requires an error message argument');
    }
  }

  if (!condition) {
    var error;
    if (format === undefined) {
      error = new Error('Minified exception occurred; use the non-minified dev environment ' + 'for the full error message and additional helpful warnings.');
    } else {
      var args = [a, b, c, d, e, f];
      var argIndex = 0;
      error = new Error(format.replace(/%s/g, function () {
        return args[argIndex++];
      }));
      error.name = 'Invariant Violation';
    }

    error.framesToPop = 1; // we don't care about invariant's own frame
    throw error;
  }
}

module.exports = invariant;
}).call(this,require('_process'))
},{"_process":136}],76:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule isNode
 * @typechecks
 */

/**
 * @param {*} object The object to check.
 * @return {boolean} Whether or not the object is a DOM node.
 */
'use strict';

function isNode(object) {
  return !!(object && (typeof Node === 'function' ? object instanceof Node : typeof object === 'object' && typeof object.nodeType === 'number' && typeof object.nodeName === 'string'));
}

module.exports = isNode;
},{}],77:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule isTextNode
 * @typechecks
 */

'use strict';

var isNode = require('./isNode');

/**
 * @param {*} object The object to check.
 * @return {boolean} Whether or not the object is a DOM text node.
 */
function isTextNode(object) {
  return isNode(object) && object.nodeType == 3;
}

module.exports = isTextNode;
},{"./isNode":76}],78:[function(require,module,exports){
(function (process){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule keyMirror
 * @typechecks static-only
 */

'use strict';

var invariant = require('./invariant');

/**
 * Constructs an enumeration with keys equal to their value.
 *
 * For example:
 *
 *   var COLORS = keyMirror({blue: null, red: null});
 *   var myColor = COLORS.blue;
 *   var isColorValid = !!COLORS[myColor];
 *
 * The last line could not be performed if the values of the generated enum were
 * not equal to their keys.
 *
 *   Input:  {key1: val1, key2: val2}
 *   Output: {key1: key1, key2: key2}
 *
 * @param {object} obj
 * @return {object}
 */
var keyMirror = function (obj) {
  var ret = {};
  var key;
  !(obj instanceof Object && !Array.isArray(obj)) ? process.env.NODE_ENV !== 'production' ? invariant(false, 'keyMirror(...): Argument must be an object.') : invariant(false) : undefined;
  for (key in obj) {
    if (!obj.hasOwnProperty(key)) {
      continue;
    }
    ret[key] = key;
  }
  return ret;
};

module.exports = keyMirror;
}).call(this,require('_process'))
},{"./invariant":75,"_process":136}],79:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule keyOf
 */

/**
 * Allows extraction of a minified key. Let's the build system minify keys
 * without losing the ability to dynamically use key strings as values
 * themselves. Pass in an object with a single key/val pair and it will return
 * you the string key of that single record. Suppose you want to grab the
 * value for a key 'className' inside of an object. Key/val minification may
 * have aliased that key to be 'xa12'. keyOf({className: null}) will return
 * 'xa12' in that case. Resolve keys you want to use once at startup time, then
 * reuse those resolutions.
 */
"use strict";

var keyOf = function (oneKeyObj) {
  var key;
  for (key in oneKeyObj) {
    if (!oneKeyObj.hasOwnProperty(key)) {
      continue;
    }
    return key;
  }
  return null;
};

module.exports = keyOf;
},{}],80:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule mapObject
 */

'use strict';

var hasOwnProperty = Object.prototype.hasOwnProperty;

/**
 * Executes the provided `callback` once for each enumerable own property in the
 * object and constructs a new object from the results. The `callback` is
 * invoked with three arguments:
 *
 *  - the property value
 *  - the property name
 *  - the object being traversed
 *
 * Properties that are added after the call to `mapObject` will not be visited
 * by `callback`. If the values of existing properties are changed, the value
 * passed to `callback` will be the value at the time `mapObject` visits them.
 * Properties that are deleted before being visited are not visited.
 *
 * @grep function objectMap()
 * @grep function objMap()
 *
 * @param {?object} object
 * @param {function} callback
 * @param {*} context
 * @return {?object}
 */
function mapObject(object, callback, context) {
  if (!object) {
    return null;
  }
  var result = {};
  for (var name in object) {
    if (hasOwnProperty.call(object, name)) {
      result[name] = callback.call(context, object[name], name, object);
    }
  }
  return result;
}

module.exports = mapObject;
},{}],81:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule memoizeStringOnly
 * @typechecks static-only
 */

'use strict';

/**
 * Memoizes the return value of a function that accepts one string argument.
 *
 * @param {function} callback
 * @return {function}
 */
function memoizeStringOnly(callback) {
  var cache = {};
  return function (string) {
    if (!cache.hasOwnProperty(string)) {
      cache[string] = callback.call(this, string);
    }
    return cache[string];
  };
}

module.exports = memoizeStringOnly;
},{}],82:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule performance
 * @typechecks
 */

'use strict';

var ExecutionEnvironment = require('./ExecutionEnvironment');

var performance;

if (ExecutionEnvironment.canUseDOM) {
  performance = window.performance || window.msPerformance || window.webkitPerformance;
}

module.exports = performance || {};
},{"./ExecutionEnvironment":61}],83:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule performanceNow
 * @typechecks
 */

'use strict';

var performance = require('./performance');

var performanceNow;

/**
 * Detect if we can use `window.performance.now()` and gracefully fallback to
 * `Date.now()` if it doesn't exist. We need to support Firefox < 15 for now
 * because of Facebook's testing infrastructure.
 */
if (performance.now) {
  performanceNow = function () {
    return performance.now();
  };
} else {
  performanceNow = function () {
    return Date.now();
  };
}

module.exports = performanceNow;
},{"./performance":82}],84:[function(require,module,exports){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule shallowEqual
 * @typechecks
 * 
 */

'use strict';

var hasOwnProperty = Object.prototype.hasOwnProperty;

/**
 * Performs equality by iterating through keys on an object and returning false
 * when any key has values which are not strictly equal between the arguments.
 * Returns true when the values of all keys are strictly equal.
 */
function shallowEqual(objA, objB) {
  if (objA === objB) {
    return true;
  }

  if (typeof objA !== 'object' || objA === null || typeof objB !== 'object' || objB === null) {
    return false;
  }

  var keysA = Object.keys(objA);
  var keysB = Object.keys(objB);

  if (keysA.length !== keysB.length) {
    return false;
  }

  // Test for A's keys different from B.
  var bHasOwnProperty = hasOwnProperty.bind(objB);
  for (var i = 0; i < keysA.length; i++) {
    if (!bHasOwnProperty(keysA[i]) || objA[keysA[i]] !== objB[keysA[i]]) {
      return false;
    }
  }

  return true;
}

module.exports = shallowEqual;
},{}],85:[function(require,module,exports){
(function (process){
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule toArray
 * @typechecks
 */

'use strict';

var invariant = require('./invariant');

/**
 * Convert array-like objects to arrays.
 *
 * This API assumes the caller knows the contents of the data type. For less
 * well defined inputs use createArrayFromMixed.
 *
 * @param {object|function|filelist} obj
 * @return {array}
 */
function toArray(obj) {
  var length = obj.length;

  // Some browse builtin objects can report typeof 'function' (e.g. NodeList in
  // old versions of Safari).
  !(!Array.isArray(obj) && (typeof obj === 'object' || typeof obj === 'function')) ? process.env.NODE_ENV !== 'production' ? invariant(false, 'toArray: Array-like object expected') : invariant(false) : undefined;

  !(typeof length === 'number') ? process.env.NODE_ENV !== 'production' ? invariant(false, 'toArray: Object needs a length property') : invariant(false) : undefined;

  !(length === 0 || length - 1 in obj) ? process.env.NODE_ENV !== 'production' ? invariant(false, 'toArray: Object should have keys for indices') : invariant(false) : undefined;

  // Old IE doesn't give collections access to hasOwnProperty. Assume inputs
  // without method will throw during the slice call and skip straight to the
  // fallback.
  if (obj.hasOwnProperty) {
    try {
      return Array.prototype.slice.call(obj);
    } catch (e) {
      // IE < 9 does not support Array#slice on collections objects
    }
  }

  // Fall back to copying key by key. This assumes all keys have a value,
  // so will not preserve sparsely populated inputs.
  var ret = Array(length);
  for (var ii = 0; ii < length; ii++) {
    ret[ii] = obj[ii];
  }
  return ret;
}

module.exports = toArray;
}).call(this,require('_process'))
},{"./invariant":75,"_process":136}],86:[function(require,module,exports){
(function (process){
/**
 * Copyright 2014-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule warning
 */

'use strict';

var emptyFunction = require('./emptyFunction');

/**
 * Similar to invariant but only logs a warning if the condition is not met.
 * This can be used to log issues in development environments in critical
 * paths. Removing the logging code for production environments will keep the
 * same logic and follow the same code paths.
 */

var warning = emptyFunction;

if (process.env.NODE_ENV !== 'production') {
  warning = function (condition, format) {
    for (var _len = arguments.length, args = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      args[_key - 2] = arguments[_key];
    }

    if (format === undefined) {
      throw new Error('`warning(condition, format, ...args)` requires a warning ' + 'message argument');
    }

    if (format.indexOf('Failed Composite propType: ') === 0) {
      return; // Ignore CompositeComponent proptype check.
    }

    if (!condition) {
      var argIndex = 0;
      var message = 'Warning: ' + format.replace(/%s/g, function () {
        return args[argIndex++];
      });
      if (typeof console !== 'undefined') {
        console.error(message);
      }
      try {
        // --- Welcome to debugging React ---
        // This error was thrown as a convenience so that you can use this stack
        // to find the callsite that caused this warning to fire.
        throw new Error(message);
      } catch (x) {}
    }
  };
}

module.exports = warning;
}).call(this,require('_process'))
},{"./emptyFunction":67,"_process":136}],87:[function(require,module,exports){
"use strict"

module.exports = createRBTree

var RED   = 0
var BLACK = 1

function RBNode(color, key, value, left, right, count) {
  this._color = color
  this.key = key
  this.value = value
  this.left = left
  this.right = right
  this._count = count
}

function cloneNode(node) {
  return new RBNode(node._color, node.key, node.value, node.left, node.right, node._count)
}

function repaint(color, node) {
  return new RBNode(color, node.key, node.value, node.left, node.right, node._count)
}

function recount(node) {
  node._count = 1 + (node.left ? node.left._count : 0) + (node.right ? node.right._count : 0)
}

function RedBlackTree(compare, root) {
  this._compare = compare
  this.root = root
}

var proto = RedBlackTree.prototype

Object.defineProperty(proto, "keys", {
  get: function() {
    var result = []
    this.forEach(function(k,v) {
      result.push(k)
    })
    return result
  }
})

Object.defineProperty(proto, "values", {
  get: function() {
    var result = []
    this.forEach(function(k,v) {
      result.push(v)
    })
    return result
  }
})

//Returns the number of nodes in the tree
Object.defineProperty(proto, "length", {
  get: function() {
    if(this.root) {
      return this.root._count
    }
    return 0
  }
})

//Insert a new item into the tree
proto.insert = function(key, value) {
  var cmp = this._compare
  //Find point to insert new node at
  var n = this.root
  var n_stack = []
  var d_stack = []
  while(n) {
    var d = cmp(key, n.key)
    n_stack.push(n)
    d_stack.push(d)
    if(d <= 0) {
      n = n.left
    } else {
      n = n.right
    }
  }
  //Rebuild path to leaf node
  n_stack.push(new RBNode(RED, key, value, null, null, 1))
  for(var s=n_stack.length-2; s>=0; --s) {
    var n = n_stack[s]
    if(d_stack[s] <= 0) {
      n_stack[s] = new RBNode(n._color, n.key, n.value, n_stack[s+1], n.right, n._count+1)
    } else {
      n_stack[s] = new RBNode(n._color, n.key, n.value, n.left, n_stack[s+1], n._count+1)
    }
  }
  //Rebalance tree using rotations
  //console.log("start insert", key, d_stack)
  for(var s=n_stack.length-1; s>1; --s) {
    var p = n_stack[s-1]
    var n = n_stack[s]
    if(p._color === BLACK || n._color === BLACK) {
      break
    }
    var pp = n_stack[s-2]
    if(pp.left === p) {
      if(p.left === n) {
        var y = pp.right
        if(y && y._color === RED) {
          //console.log("LLr")
          p._color = BLACK
          pp.right = repaint(BLACK, y)
          pp._color = RED
          s -= 1
        } else {
          //console.log("LLb")
          pp._color = RED
          pp.left = p.right
          p._color = BLACK
          p.right = pp
          n_stack[s-2] = p
          n_stack[s-1] = n
          recount(pp)
          recount(p)
          if(s >= 3) {
            var ppp = n_stack[s-3]
            if(ppp.left === pp) {
              ppp.left = p
            } else {
              ppp.right = p
            }
          }
          break
        }
      } else {
        var y = pp.right
        if(y && y._color === RED) {
          //console.log("LRr")
          p._color = BLACK
          pp.right = repaint(BLACK, y)
          pp._color = RED
          s -= 1
        } else {
          //console.log("LRb")
          p.right = n.left
          pp._color = RED
          pp.left = n.right
          n._color = BLACK
          n.left = p
          n.right = pp
          n_stack[s-2] = n
          n_stack[s-1] = p
          recount(pp)
          recount(p)
          recount(n)
          if(s >= 3) {
            var ppp = n_stack[s-3]
            if(ppp.left === pp) {
              ppp.left = n
            } else {
              ppp.right = n
            }
          }
          break
        }
      }
    } else {
      if(p.right === n) {
        var y = pp.left
        if(y && y._color === RED) {
          //console.log("RRr", y.key)
          p._color = BLACK
          pp.left = repaint(BLACK, y)
          pp._color = RED
          s -= 1
        } else {
          //console.log("RRb")
          pp._color = RED
          pp.right = p.left
          p._color = BLACK
          p.left = pp
          n_stack[s-2] = p
          n_stack[s-1] = n
          recount(pp)
          recount(p)
          if(s >= 3) {
            var ppp = n_stack[s-3]
            if(ppp.right === pp) {
              ppp.right = p
            } else {
              ppp.left = p
            }
          }
          break
        }
      } else {
        var y = pp.left
        if(y && y._color === RED) {
          //console.log("RLr")
          p._color = BLACK
          pp.left = repaint(BLACK, y)
          pp._color = RED
          s -= 1
        } else {
          //console.log("RLb")
          p.left = n.right
          pp._color = RED
          pp.right = n.left
          n._color = BLACK
          n.right = p
          n.left = pp
          n_stack[s-2] = n
          n_stack[s-1] = p
          recount(pp)
          recount(p)
          recount(n)
          if(s >= 3) {
            var ppp = n_stack[s-3]
            if(ppp.right === pp) {
              ppp.right = n
            } else {
              ppp.left = n
            }
          }
          break
        }
      }
    }
  }
  //Return new tree
  n_stack[0]._color = BLACK
  return new RedBlackTree(cmp, n_stack[0])
}


//Visit all nodes inorder
function doVisitFull(visit, node) {
  if(node.left) {
    var v = doVisitFull(visit, node.left)
    if(v) { return v }
  }
  var v = visit(node.key, node.value)
  if(v) { return v }
  if(node.right) {
    return doVisitFull(visit, node.right)
  }
}

//Visit half nodes in order
function doVisitHalf(lo, compare, visit, node) {
  var l = compare(lo, node.key)
  if(l <= 0) {
    if(node.left) {
      var v = doVisitHalf(lo, compare, visit, node.left)
      if(v) { return v }
    }
    var v = visit(node.key, node.value)
    if(v) { return v }
  }
  if(node.right) {
    return doVisitHalf(lo, compare, visit, node.right)
  }
}

//Visit all nodes within a range
function doVisit(lo, hi, compare, visit, node) {
  var l = compare(lo, node.key)
  var h = compare(hi, node.key)
  var v
  if(l <= 0) {
    if(node.left) {
      v = doVisit(lo, hi, compare, visit, node.left)
      if(v) { return v }
    }
    if(h > 0) {
      v = visit(node.key, node.value)
      if(v) { return v }
    }
  }
  if(h > 0 && node.right) {
    return doVisit(lo, hi, compare, visit, node.right)
  }
}


proto.forEach = function rbTreeForEach(visit, lo, hi) {
  if(!this.root) {
    return
  }
  switch(arguments.length) {
    case 1:
      return doVisitFull(visit, this.root)
    break

    case 2:
      return doVisitHalf(lo, this._compare, visit, this.root)
    break

    case 3:
      if(this._compare(lo, hi) >= 0) {
        return
      }
      return doVisit(lo, hi, this._compare, visit, this.root)
    break
  }
}

//First item in list
Object.defineProperty(proto, "begin", {
  get: function() {
    var stack = []
    var n = this.root
    while(n) {
      stack.push(n)
      n = n.left
    }
    return new RedBlackTreeIterator(this, stack)
  }
})

//Last item in list
Object.defineProperty(proto, "end", {
  get: function() {
    var stack = []
    var n = this.root
    while(n) {
      stack.push(n)
      n = n.right
    }
    return new RedBlackTreeIterator(this, stack)
  }
})

//Find the ith item in the tree
proto.at = function(idx) {
  if(idx < 0) {
    return new RedBlackTreeIterator(this, [])
  }
  var n = this.root
  var stack = []
  while(true) {
    stack.push(n)
    if(n.left) {
      if(idx < n.left._count) {
        n = n.left
        continue
      }
      idx -= n.left._count
    }
    if(!idx) {
      return new RedBlackTreeIterator(this, stack)
    }
    idx -= 1
    if(n.right) {
      if(idx >= n.right._count) {
        break
      }
      n = n.right
    } else {
      break
    }
  }
  return new RedBlackTreeIterator(this, [])
}

proto.ge = function(key) {
  var cmp = this._compare
  var n = this.root
  var stack = []
  var last_ptr = 0
  while(n) {
    var d = cmp(key, n.key)
    stack.push(n)
    if(d <= 0) {
      last_ptr = stack.length
    }
    if(d <= 0) {
      n = n.left
    } else {
      n = n.right
    }
  }
  stack.length = last_ptr
  return new RedBlackTreeIterator(this, stack)
}

proto.gt = function(key) {
  var cmp = this._compare
  var n = this.root
  var stack = []
  var last_ptr = 0
  while(n) {
    var d = cmp(key, n.key)
    stack.push(n)
    if(d < 0) {
      last_ptr = stack.length
    }
    if(d < 0) {
      n = n.left
    } else {
      n = n.right
    }
  }
  stack.length = last_ptr
  return new RedBlackTreeIterator(this, stack)
}

proto.lt = function(key) {
  var cmp = this._compare
  var n = this.root
  var stack = []
  var last_ptr = 0
  while(n) {
    var d = cmp(key, n.key)
    stack.push(n)
    if(d > 0) {
      last_ptr = stack.length
    }
    if(d <= 0) {
      n = n.left
    } else {
      n = n.right
    }
  }
  stack.length = last_ptr
  return new RedBlackTreeIterator(this, stack)
}

proto.le = function(key) {
  var cmp = this._compare
  var n = this.root
  var stack = []
  var last_ptr = 0
  while(n) {
    var d = cmp(key, n.key)
    stack.push(n)
    if(d >= 0) {
      last_ptr = stack.length
    }
    if(d < 0) {
      n = n.left
    } else {
      n = n.right
    }
  }
  stack.length = last_ptr
  return new RedBlackTreeIterator(this, stack)
}

//Finds the item with key if it exists
proto.find = function(key) {
  var cmp = this._compare
  var n = this.root
  var stack = []
  while(n) {
    var d = cmp(key, n.key)
    stack.push(n)
    if(d === 0) {
      return new RedBlackTreeIterator(this, stack)
    }
    if(d <= 0) {
      n = n.left
    } else {
      n = n.right
    }
  }
  return new RedBlackTreeIterator(this, [])
}

//Removes item with key from tree
proto.remove = function(key) {
  var iter = this.find(key)
  if(iter) {
    return iter.remove()
  }
  return this
}

//Returns the item at `key`
proto.get = function(key) {
  var cmp = this._compare
  var n = this.root
  while(n) {
    var d = cmp(key, n.key)
    if(d === 0) {
      return n.value
    }
    if(d <= 0) {
      n = n.left
    } else {
      n = n.right
    }
  }
  return
}

//Iterator for red black tree
function RedBlackTreeIterator(tree, stack) {
  this.tree = tree
  this._stack = stack
}

var iproto = RedBlackTreeIterator.prototype

//Test if iterator is valid
Object.defineProperty(iproto, "valid", {
  get: function() {
    return this._stack.length > 0
  }
})

//Node of the iterator
Object.defineProperty(iproto, "node", {
  get: function() {
    if(this._stack.length > 0) {
      return this._stack[this._stack.length-1]
    }
    return null
  },
  enumerable: true
})

//Makes a copy of an iterator
iproto.clone = function() {
  return new RedBlackTreeIterator(this.tree, this._stack.slice())
}

//Swaps two nodes
function swapNode(n, v) {
  n.key = v.key
  n.value = v.value
  n.left = v.left
  n.right = v.right
  n._color = v._color
  n._count = v._count
}

//Fix up a double black node in a tree
function fixDoubleBlack(stack) {
  var n, p, s, z
  for(var i=stack.length-1; i>=0; --i) {
    n = stack[i]
    if(i === 0) {
      n._color = BLACK
      return
    }
    //console.log("visit node:", n.key, i, stack[i].key, stack[i-1].key)
    p = stack[i-1]
    if(p.left === n) {
      //console.log("left child")
      s = p.right
      if(s.right && s.right._color === RED) {
        //console.log("case 1: right sibling child red")
        s = p.right = cloneNode(s)
        z = s.right = cloneNode(s.right)
        p.right = s.left
        s.left = p
        s.right = z
        s._color = p._color
        n._color = BLACK
        p._color = BLACK
        z._color = BLACK
        recount(p)
        recount(s)
        if(i > 1) {
          var pp = stack[i-2]
          if(pp.left === p) {
            pp.left = s
          } else {
            pp.right = s
          }
        }
        stack[i-1] = s
        return
      } else if(s.left && s.left._color === RED) {
        //console.log("case 1: left sibling child red")
        s = p.right = cloneNode(s)
        z = s.left = cloneNode(s.left)
        p.right = z.left
        s.left = z.right
        z.left = p
        z.right = s
        z._color = p._color
        p._color = BLACK
        s._color = BLACK
        n._color = BLACK
        recount(p)
        recount(s)
        recount(z)
        if(i > 1) {
          var pp = stack[i-2]
          if(pp.left === p) {
            pp.left = z
          } else {
            pp.right = z
          }
        }
        stack[i-1] = z
        return
      }
      if(s._color === BLACK) {
        if(p._color === RED) {
          //console.log("case 2: black sibling, red parent", p.right.value)
          p._color = BLACK
          p.right = repaint(RED, s)
          return
        } else {
          //console.log("case 2: black sibling, black parent", p.right.value)
          p.right = repaint(RED, s)
          continue  
        }
      } else {
        //console.log("case 3: red sibling")
        s = cloneNode(s)
        p.right = s.left
        s.left = p
        s._color = p._color
        p._color = RED
        recount(p)
        recount(s)
        if(i > 1) {
          var pp = stack[i-2]
          if(pp.left === p) {
            pp.left = s
          } else {
            pp.right = s
          }
        }
        stack[i-1] = s
        stack[i] = p
        if(i+1 < stack.length) {
          stack[i+1] = n
        } else {
          stack.push(n)
        }
        i = i+2
      }
    } else {
      //console.log("right child")
      s = p.left
      if(s.left && s.left._color === RED) {
        //console.log("case 1: left sibling child red", p.value, p._color)
        s = p.left = cloneNode(s)
        z = s.left = cloneNode(s.left)
        p.left = s.right
        s.right = p
        s.left = z
        s._color = p._color
        n._color = BLACK
        p._color = BLACK
        z._color = BLACK
        recount(p)
        recount(s)
        if(i > 1) {
          var pp = stack[i-2]
          if(pp.right === p) {
            pp.right = s
          } else {
            pp.left = s
          }
        }
        stack[i-1] = s
        return
      } else if(s.right && s.right._color === RED) {
        //console.log("case 1: right sibling child red")
        s = p.left = cloneNode(s)
        z = s.right = cloneNode(s.right)
        p.left = z.right
        s.right = z.left
        z.right = p
        z.left = s
        z._color = p._color
        p._color = BLACK
        s._color = BLACK
        n._color = BLACK
        recount(p)
        recount(s)
        recount(z)
        if(i > 1) {
          var pp = stack[i-2]
          if(pp.right === p) {
            pp.right = z
          } else {
            pp.left = z
          }
        }
        stack[i-1] = z
        return
      }
      if(s._color === BLACK) {
        if(p._color === RED) {
          //console.log("case 2: black sibling, red parent")
          p._color = BLACK
          p.left = repaint(RED, s)
          return
        } else {
          //console.log("case 2: black sibling, black parent")
          p.left = repaint(RED, s)
          continue  
        }
      } else {
        //console.log("case 3: red sibling")
        s = cloneNode(s)
        p.left = s.right
        s.right = p
        s._color = p._color
        p._color = RED
        recount(p)
        recount(s)
        if(i > 1) {
          var pp = stack[i-2]
          if(pp.right === p) {
            pp.right = s
          } else {
            pp.left = s
          }
        }
        stack[i-1] = s
        stack[i] = p
        if(i+1 < stack.length) {
          stack[i+1] = n
        } else {
          stack.push(n)
        }
        i = i+2
      }
    }
  }
}

//Removes item at iterator from tree
iproto.remove = function() {
  var stack = this._stack
  if(stack.length === 0) {
    return this.tree
  }
  //First copy path to node
  var cstack = new Array(stack.length)
  var n = stack[stack.length-1]
  cstack[cstack.length-1] = new RBNode(n._color, n.key, n.value, n.left, n.right, n._count)
  for(var i=stack.length-2; i>=0; --i) {
    var n = stack[i]
    if(n.left === stack[i+1]) {
      cstack[i] = new RBNode(n._color, n.key, n.value, cstack[i+1], n.right, n._count)
    } else {
      cstack[i] = new RBNode(n._color, n.key, n.value, n.left, cstack[i+1], n._count)
    }
  }

  //Get node
  n = cstack[cstack.length-1]
  //console.log("start remove: ", n.value)

  //If not leaf, then swap with previous node
  if(n.left && n.right) {
    //console.log("moving to leaf")

    //First walk to previous leaf
    var split = cstack.length
    n = n.left
    while(n.right) {
      cstack.push(n)
      n = n.right
    }
    //Copy path to leaf
    var v = cstack[split-1]
    cstack.push(new RBNode(n._color, v.key, v.value, n.left, n.right, n._count))
    cstack[split-1].key = n.key
    cstack[split-1].value = n.value

    //Fix up stack
    for(var i=cstack.length-2; i>=split; --i) {
      n = cstack[i]
      cstack[i] = new RBNode(n._color, n.key, n.value, n.left, cstack[i+1], n._count)
    }
    cstack[split-1].left = cstack[split]
  }
  //console.log("stack=", cstack.map(function(v) { return v.value }))

  //Remove leaf node
  n = cstack[cstack.length-1]
  if(n._color === RED) {
    //Easy case: removing red leaf
    //console.log("RED leaf")
    var p = cstack[cstack.length-2]
    if(p.left === n) {
      p.left = null
    } else if(p.right === n) {
      p.right = null
    }
    cstack.pop()
    for(var i=0; i<cstack.length; ++i) {
      cstack[i]._count--
    }
    return new RedBlackTree(this.tree._compare, cstack[0])
  } else {
    if(n.left || n.right) {
      //Second easy case:  Single child black parent
      //console.log("BLACK single child")
      if(n.left) {
        swapNode(n, n.left)
      } else if(n.right) {
        swapNode(n, n.right)
      }
      //Child must be red, so repaint it black to balance color
      n._color = BLACK
      for(var i=0; i<cstack.length-1; ++i) {
        cstack[i]._count--
      }
      return new RedBlackTree(this.tree._compare, cstack[0])
    } else if(cstack.length === 1) {
      //Third easy case: root
      //console.log("ROOT")
      return new RedBlackTree(this.tree._compare, null)
    } else {
      //Hard case: Repaint n, and then do some nasty stuff
      //console.log("BLACK leaf no children")
      for(var i=0; i<cstack.length; ++i) {
        cstack[i]._count--
      }
      var parent = cstack[cstack.length-2]
      fixDoubleBlack(cstack)
      //Fix up links
      if(parent.left === n) {
        parent.left = null
      } else {
        parent.right = null
      }
    }
  }
  return new RedBlackTree(this.tree._compare, cstack[0])
}

//Returns key
Object.defineProperty(iproto, "key", {
  get: function() {
    if(this._stack.length > 0) {
      return this._stack[this._stack.length-1].key
    }
    return
  },
  enumerable: true
})

//Returns value
Object.defineProperty(iproto, "value", {
  get: function() {
    if(this._stack.length > 0) {
      return this._stack[this._stack.length-1].value
    }
    return
  },
  enumerable: true
})


//Returns the position of this iterator in the sorted list
Object.defineProperty(iproto, "index", {
  get: function() {
    var idx = 0
    var stack = this._stack
    if(stack.length === 0) {
      var r = this.tree.root
      if(r) {
        return r._count
      }
      return 0
    } else if(stack[stack.length-1].left) {
      idx = stack[stack.length-1].left._count
    }
    for(var s=stack.length-2; s>=0; --s) {
      if(stack[s+1] === stack[s].right) {
        ++idx
        if(stack[s].left) {
          idx += stack[s].left._count
        }
      }
    }
    return idx
  },
  enumerable: true
})

//Advances iterator to next element in list
iproto.next = function() {
  var stack = this._stack
  if(stack.length === 0) {
    return
  }
  var n = stack[stack.length-1]
  if(n.right) {
    n = n.right
    while(n) {
      stack.push(n)
      n = n.left
    }
  } else {
    stack.pop()
    while(stack.length > 0 && stack[stack.length-1].right === n) {
      n = stack[stack.length-1]
      stack.pop()
    }
  }
}

//Checks if iterator is at end of tree
Object.defineProperty(iproto, "hasNext", {
  get: function() {
    var stack = this._stack
    if(stack.length === 0) {
      return false
    }
    if(stack[stack.length-1].right) {
      return true
    }
    for(var s=stack.length-1; s>0; --s) {
      if(stack[s-1].left === stack[s]) {
        return true
      }
    }
    return false
  }
})

//Update value
iproto.update = function(value) {
  var stack = this._stack
  if(stack.length === 0) {
    throw new Error("Can't update empty node!")
  }
  var cstack = new Array(stack.length)
  var n = stack[stack.length-1]
  cstack[cstack.length-1] = new RBNode(n._color, n.key, value, n.left, n.right, n._count)
  for(var i=stack.length-2; i>=0; --i) {
    n = stack[i]
    if(n.left === stack[i+1]) {
      cstack[i] = new RBNode(n._color, n.key, n.value, cstack[i+1], n.right, n._count)
    } else {
      cstack[i] = new RBNode(n._color, n.key, n.value, n.left, cstack[i+1], n._count)
    }
  }
  return new RedBlackTree(this.tree._compare, cstack[0])
}

//Moves iterator backward one element
iproto.prev = function() {
  var stack = this._stack
  if(stack.length === 0) {
    return
  }
  var n = stack[stack.length-1]
  if(n.left) {
    n = n.left
    while(n) {
      stack.push(n)
      n = n.right
    }
  } else {
    stack.pop()
    while(stack.length > 0 && stack[stack.length-1].left === n) {
      n = stack[stack.length-1]
      stack.pop()
    }
  }
}

//Checks if iterator is at start of tree
Object.defineProperty(iproto, "hasPrev", {
  get: function() {
    var stack = this._stack
    if(stack.length === 0) {
      return false
    }
    if(stack[stack.length-1].left) {
      return true
    }
    for(var s=stack.length-1; s>0; --s) {
      if(stack[s-1].right === stack[s]) {
        return true
      }
    }
    return false
  }
})

//Default comparison function
function defaultCompare(a, b) {
  if(a < b) {
    return -1
  }
  if(a > b) {
    return 1
  }
  return 0
}

//Build a tree
function createRBTree(compare) {
  return new RedBlackTree(compare || defaultCompare, null)
}
},{}],88:[function(require,module,exports){
exports.read = function (buffer, offset, isLE, mLen, nBytes) {
  var e, m
  var eLen = (nBytes * 8) - mLen - 1
  var eMax = (1 << eLen) - 1
  var eBias = eMax >> 1
  var nBits = -7
  var i = isLE ? (nBytes - 1) : 0
  var d = isLE ? -1 : 1
  var s = buffer[offset + i]

  i += d

  e = s & ((1 << (-nBits)) - 1)
  s >>= (-nBits)
  nBits += eLen
  for (; nBits > 0; e = (e * 256) + buffer[offset + i], i += d, nBits -= 8) {}

  m = e & ((1 << (-nBits)) - 1)
  e >>= (-nBits)
  nBits += mLen
  for (; nBits > 0; m = (m * 256) + buffer[offset + i], i += d, nBits -= 8) {}

  if (e === 0) {
    e = 1 - eBias
  } else if (e === eMax) {
    return m ? NaN : ((s ? -1 : 1) * Infinity)
  } else {
    m = m + Math.pow(2, mLen)
    e = e - eBias
  }
  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
}

exports.write = function (buffer, value, offset, isLE, mLen, nBytes) {
  var e, m, c
  var eLen = (nBytes * 8) - mLen - 1
  var eMax = (1 << eLen) - 1
  var eBias = eMax >> 1
  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0)
  var i = isLE ? 0 : (nBytes - 1)
  var d = isLE ? 1 : -1
  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0

  value = Math.abs(value)

  if (isNaN(value) || value === Infinity) {
    m = isNaN(value) ? 1 : 0
    e = eMax
  } else {
    e = Math.floor(Math.log(value) / Math.LN2)
    if (value * (c = Math.pow(2, -e)) < 1) {
      e--
      c *= 2
    }
    if (e + eBias >= 1) {
      value += rt / c
    } else {
      value += rt * Math.pow(2, 1 - eBias)
    }
    if (value * c >= 2) {
      e++
      c /= 2
    }

    if (e + eBias >= eMax) {
      m = 0
      e = eMax
    } else if (e + eBias >= 1) {
      m = ((value * c) - 1) * Math.pow(2, mLen)
      e = e + eBias
    } else {
      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen)
      e = 0
    }
  }

  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

  e = (e << mLen) | m
  eLen += mLen
  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

  buffer[offset + i - d] |= s * 128
}

},{}],89:[function(require,module,exports){
(function (global){
'use strict';
var Mutation = global.MutationObserver || global.WebKitMutationObserver;

var scheduleDrain;

{
  if (Mutation) {
    var called = 0;
    var observer = new Mutation(nextTick);
    var element = global.document.createTextNode('');
    observer.observe(element, {
      characterData: true
    });
    scheduleDrain = function () {
      element.data = (called = ++called % 2);
    };
  } else if (!global.setImmediate && typeof global.MessageChannel !== 'undefined') {
    var channel = new global.MessageChannel();
    channel.port1.onmessage = nextTick;
    scheduleDrain = function () {
      channel.port2.postMessage(0);
    };
  } else if ('document' in global && 'onreadystatechange' in global.document.createElement('script')) {
    scheduleDrain = function () {

      // Create a <script> element; its readystatechange event will be fired asynchronously once it is inserted
      // into the document. Do so, thus queuing up the task. Remember to clean up once it's been called.
      var scriptEl = global.document.createElement('script');
      scriptEl.onreadystatechange = function () {
        nextTick();

        scriptEl.onreadystatechange = null;
        scriptEl.parentNode.removeChild(scriptEl);
        scriptEl = null;
      };
      global.document.documentElement.appendChild(scriptEl);
    };
  } else {
    scheduleDrain = function () {
      setTimeout(nextTick, 0);
    };
  }
}

var draining;
var queue = [];
//named nextTick for less confusing stack traces
function nextTick() {
  draining = true;
  var i, oldQueue;
  var len = queue.length;
  while (len) {
    oldQueue = queue;
    queue = [];
    i = -1;
    while (++i < len) {
      oldQueue[i]();
    }
    len = queue.length;
  }
  draining = false;
}

module.exports = immediate;
function immediate(task) {
  if (queue.push(task) === 1 && !draining) {
    scheduleDrain();
  }
}

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{}],90:[function(require,module,exports){
if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    var TempCtor = function () {}
    TempCtor.prototype = superCtor.prototype
    ctor.prototype = new TempCtor()
    ctor.prototype.constructor = ctor
  }
}

},{}],91:[function(require,module,exports){
/*!
 * Determine if an object is a Buffer
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */

// The _isBuffer check is for Safari 5-7 support, because it's missing
// Object.prototype.constructor. Remove this eventually
module.exports = function (obj) {
  return obj != null && (isBuffer(obj) || isSlowBuffer(obj) || !!obj._isBuffer)
}

function isBuffer (obj) {
  return !!obj.constructor && typeof obj.constructor.isBuffer === 'function' && obj.constructor.isBuffer(obj)
}

// For Node v0.10 support. Remove this eventually.
function isSlowBuffer (obj) {
  return typeof obj.readFloatLE === 'function' && typeof obj.slice === 'function' && isBuffer(obj.slice(0, 0))
}

},{}],92:[function(require,module,exports){
var toString = {}.toString;

module.exports = Array.isArray || function (arr) {
  return toString.call(arr) == '[object Array]';
};

},{}],93:[function(require,module,exports){
(function() { 

  var slice   = Array.prototype.slice,
      each    = Array.prototype.forEach;

  var extend = function(obj) {
    if(typeof obj !== 'object') throw obj + ' is not an object' ;

    var sources = slice.call(arguments, 1); 

    each.call(sources, function(source) {
      if(source) {
        for(var prop in source) {
          if(typeof source[prop] === 'object' && obj[prop]) {
            extend.call(obj, obj[prop], source[prop]);
          } else {
            obj[prop] = source[prop];
          }
        } 
      }
    });

    return obj;
  }

  this.extend = extend;

}).call(this);
},{}],94:[function(require,module,exports){
var encodings = require('./lib/encodings');

module.exports = Codec;

function Codec(opts){
  this.opts = opts || {};
  this.encodings = encodings;
}

Codec.prototype._encoding = function(encoding){
  if (typeof encoding == 'string') encoding = encodings[encoding];
  if (!encoding) encoding = encodings.id;
  return encoding;
};

Codec.prototype._keyEncoding = function(opts, batchOpts){
  return this._encoding(batchOpts && batchOpts.keyEncoding
    || opts && opts.keyEncoding
    || this.opts.keyEncoding);
};

Codec.prototype._valueEncoding = function(opts, batchOpts){
  return this._encoding(
    batchOpts && (batchOpts.valueEncoding || batchOpts.encoding)
    || opts && (opts.valueEncoding || opts.encoding)
    || (this.opts.valueEncoding || this.opts.encoding));
};

Codec.prototype.encodeKey = function(key, opts, batchOpts){
  return this._keyEncoding(opts, batchOpts).encode(key);
};

Codec.prototype.encodeValue = function(value, opts, batchOpts){
  return this._valueEncoding(opts, batchOpts).encode(value);
};

Codec.prototype.decodeKey = function(key, opts){
  return this._keyEncoding(opts).decode(key);
};

Codec.prototype.decodeValue = function(value, opts){
  return this._valueEncoding(opts).decode(value);
};

Codec.prototype.encodeBatch = function(ops, opts){
  var self = this;

  return ops.map(function(_op){
    var op = {
      type: _op.type,
      key: self.encodeKey(_op.key, opts, _op)
    };
    if (self.keyAsBuffer(opts, _op)) op.keyEncoding = 'binary';
    if (_op.prefix) op.prefix = _op.prefix;
    if ('value' in _op) {
      op.value = self.encodeValue(_op.value, opts, _op);
      if (self.valueAsBuffer(opts, _op)) op.valueEncoding = 'binary';
    }
    return op;
  });
};

var ltgtKeys = ['lt', 'gt', 'lte', 'gte', 'start', 'end'];

Codec.prototype.encodeLtgt = function(ltgt){
  var self = this;
  var ret = {};
  Object.keys(ltgt).forEach(function(key){
    ret[key] = ltgtKeys.indexOf(key) > -1
      ? self.encodeKey(ltgt[key], ltgt)
      : ltgt[key]
  });
  return ret;
};

Codec.prototype.createStreamDecoder = function(opts){
  var self = this;

  if (opts.keys && opts.values) {
    return function(key, value){
      return {
        key: self.decodeKey(key, opts),
        value: self.decodeValue(value, opts)
      };
    };
  } else if (opts.keys) {
    return function(key) {
      return self.decodeKey(key, opts);
    }; 
  } else if (opts.values) {
    return function(_, value){
      return self.decodeValue(value, opts);
    }
  } else {
    return function(){};
  }
};

Codec.prototype.keyAsBuffer = function(opts){
  return this._keyEncoding(opts).buffer;
};

Codec.prototype.valueAsBuffer = function(opts){
  return this._valueEncoding(opts).buffer;
};


},{"./lib/encodings":95}],95:[function(require,module,exports){
(function (Buffer){

exports.utf8 = exports['utf-8'] = {
  encode: function(data){
    return isBinary(data)
      ? data
      : String(data);
  },
  decode: identity,
  buffer: false,
  type: 'utf8'
};

exports.json = {
  encode: JSON.stringify,
  decode: JSON.parse,
  buffer: false,
  type: 'json'
};

exports.binary = {
  encode: function(data){
    return isBinary(data)
      ? data
      : new Buffer(data);      
  },
  decode: identity,
  buffer: true,
  type: 'binary'
};

exports.id = {
  encode: function(data){
    return data;
  },
  decode: function(data){
    return data;
  },
  buffer: false,
  type: 'id'
};

var bufferEncodings = [
  'hex',
  'ascii',
  'base64',
  'ucs2',
  'ucs-2',
  'utf16le',
  'utf-16le'
];

bufferEncodings.forEach(function(type){
  exports[type] = {
    encode: function(data){
      return isBinary(data)
        ? data
        : new Buffer(data, type);
    },
    decode: function(buffer){
      return buffer.toString(type);
    },
    buffer: true,
    type: type
  };
});

function identity(value){
  return value;
}

function isBinary(data){
  return data === undefined
    || data === null
    || Buffer.isBuffer(data);
}


}).call(this,require("buffer").Buffer)
},{"buffer":46}],96:[function(require,module,exports){
/* Copyright (c) 2012-2017 LevelUP contributors
 * See list at <https://github.com/rvagg/node-levelup#contributing>
 * MIT License
 * <https://github.com/rvagg/node-levelup/blob/master/LICENSE.md>
 */

var createError   = require('errno').create
  , LevelUPError  = createError('LevelUPError')
  , NotFoundError = createError('NotFoundError', LevelUPError)

NotFoundError.prototype.notFound = true
NotFoundError.prototype.status   = 404

module.exports = {
    LevelUPError        : LevelUPError
  , InitializationError : createError('InitializationError', LevelUPError)
  , OpenError           : createError('OpenError', LevelUPError)
  , ReadError           : createError('ReadError', LevelUPError)
  , WriteError          : createError('WriteError', LevelUPError)
  , NotFoundError       : NotFoundError
  , EncodingError       : createError('EncodingError', LevelUPError)
}

},{"errno":57}],97:[function(require,module,exports){
var inherits = require('inherits');
var Readable = require('readable-stream').Readable;
var extend = require('xtend');
var EncodingError = require('level-errors').EncodingError;

module.exports = ReadStream;
inherits(ReadStream, Readable);

function ReadStream(iterator, options){
  if (!(this instanceof ReadStream)) return new ReadStream(iterator, options);
  Readable.call(this, extend(options, {
    objectMode: true
  }));
  this._iterator = iterator;
  this._destroyed = false;
  this._decoder = null;
  if (options && options.decoder) this._decoder = options.decoder;
  this.on('end', this._cleanup.bind(this));
}

ReadStream.prototype._read = function(){
  var self = this;
  if (this._destroyed) return;

  this._iterator.next(function(err, key, value){
    if (self._destroyed) return;
    if (err) return self.emit('error', err);
    if (key === undefined && value === undefined) {
      self.push(null);
    } else {
      if (!self._decoder) return self.push({ key: key, value: value });

      try {
        var value = self._decoder(key, value);
      } catch (err) {
        self.emit('error', new EncodingError(err));
        self.push(null);
        return;
      }
      self.push(value);
    }
  });
};

ReadStream.prototype.destroy =
ReadStream.prototype._cleanup = function(){
  var self = this;
  if (this._destroyed) return;
  this._destroyed = true;

  this._iterator.end(function(err){
    if (err) return self.emit('error', err);
    self.emit('close');
  });
};


},{"inherits":90,"level-errors":96,"readable-stream":104,"xtend":310}],98:[function(require,module,exports){
module.exports = Array.isArray || function (arr) {
  return Object.prototype.toString.call(arr) == '[object Array]';
};

},{}],99:[function(require,module,exports){
(function (process){
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// a duplex stream is just a stream that is both readable and writable.
// Since JS doesn't have multiple prototypal inheritance, this class
// prototypally inherits from Readable, and then parasitically from
// Writable.

module.exports = Duplex;

/*<replacement>*/
var objectKeys = Object.keys || function (obj) {
  var keys = [];
  for (var key in obj) keys.push(key);
  return keys;
}
/*</replacement>*/


/*<replacement>*/
var util = require('core-util-is');
util.inherits = require('inherits');
/*</replacement>*/

var Readable = require('./_stream_readable');
var Writable = require('./_stream_writable');

util.inherits(Duplex, Readable);

forEach(objectKeys(Writable.prototype), function(method) {
  if (!Duplex.prototype[method])
    Duplex.prototype[method] = Writable.prototype[method];
});

function Duplex(options) {
  if (!(this instanceof Duplex))
    return new Duplex(options);

  Readable.call(this, options);
  Writable.call(this, options);

  if (options && options.readable === false)
    this.readable = false;

  if (options && options.writable === false)
    this.writable = false;

  this.allowHalfOpen = true;
  if (options && options.allowHalfOpen === false)
    this.allowHalfOpen = false;

  this.once('end', onend);
}

// the no-half-open enforcer
function onend() {
  // if we allow half-open state, or if the writable side ended,
  // then we're ok.
  if (this.allowHalfOpen || this._writableState.ended)
    return;

  // no more data can be written.
  // But allow more writes to happen in this tick.
  process.nextTick(this.end.bind(this));
}

function forEach (xs, f) {
  for (var i = 0, l = xs.length; i < l; i++) {
    f(xs[i], i);
  }
}

}).call(this,require('_process'))
},{"./_stream_readable":101,"./_stream_writable":103,"_process":136,"core-util-is":47,"inherits":90}],100:[function(require,module,exports){
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// a passthrough stream.
// basically just the most minimal sort of Transform stream.
// Every written chunk gets output as-is.

module.exports = PassThrough;

var Transform = require('./_stream_transform');

/*<replacement>*/
var util = require('core-util-is');
util.inherits = require('inherits');
/*</replacement>*/

util.inherits(PassThrough, Transform);

function PassThrough(options) {
  if (!(this instanceof PassThrough))
    return new PassThrough(options);

  Transform.call(this, options);
}

PassThrough.prototype._transform = function(chunk, encoding, cb) {
  cb(null, chunk);
};

},{"./_stream_transform":102,"core-util-is":47,"inherits":90}],101:[function(require,module,exports){
(function (process){
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

module.exports = Readable;

/*<replacement>*/
var isArray = require('isarray');
/*</replacement>*/


/*<replacement>*/
var Buffer = require('buffer').Buffer;
/*</replacement>*/

Readable.ReadableState = ReadableState;

var EE = require('events').EventEmitter;

/*<replacement>*/
if (!EE.listenerCount) EE.listenerCount = function(emitter, type) {
  return emitter.listeners(type).length;
};
/*</replacement>*/

var Stream = require('stream');

/*<replacement>*/
var util = require('core-util-is');
util.inherits = require('inherits');
/*</replacement>*/

var StringDecoder;


/*<replacement>*/
var debug = require('util');
if (debug && debug.debuglog) {
  debug = debug.debuglog('stream');
} else {
  debug = function () {};
}
/*</replacement>*/


util.inherits(Readable, Stream);

function ReadableState(options, stream) {
  var Duplex = require('./_stream_duplex');

  options = options || {};

  // the point at which it stops calling _read() to fill the buffer
  // Note: 0 is a valid value, means "don't call _read preemptively ever"
  var hwm = options.highWaterMark;
  var defaultHwm = options.objectMode ? 16 : 16 * 1024;
  this.highWaterMark = (hwm || hwm === 0) ? hwm : defaultHwm;

  // cast to ints.
  this.highWaterMark = ~~this.highWaterMark;

  this.buffer = [];
  this.length = 0;
  this.pipes = null;
  this.pipesCount = 0;
  this.flowing = null;
  this.ended = false;
  this.endEmitted = false;
  this.reading = false;

  // a flag to be able to tell if the onwrite cb is called immediately,
  // or on a later tick.  We set this to true at first, because any
  // actions that shouldn't happen until "later" should generally also
  // not happen before the first write call.
  this.sync = true;

  // whenever we return null, then we set a flag to say
  // that we're awaiting a 'readable' event emission.
  this.needReadable = false;
  this.emittedReadable = false;
  this.readableListening = false;


  // object stream flag. Used to make read(n) ignore n and to
  // make all the buffer merging and length checks go away
  this.objectMode = !!options.objectMode;

  if (stream instanceof Duplex)
    this.objectMode = this.objectMode || !!options.readableObjectMode;

  // Crypto is kind of old and crusty.  Historically, its default string
  // encoding is 'binary' so we have to make this configurable.
  // Everything else in the universe uses 'utf8', though.
  this.defaultEncoding = options.defaultEncoding || 'utf8';

  // when piping, we only care about 'readable' events that happen
  // after read()ing all the bytes and not getting any pushback.
  this.ranOut = false;

  // the number of writers that are awaiting a drain event in .pipe()s
  this.awaitDrain = 0;

  // if true, a maybeReadMore has been scheduled
  this.readingMore = false;

  this.decoder = null;
  this.encoding = null;
  if (options.encoding) {
    if (!StringDecoder)
      StringDecoder = require('string_decoder/').StringDecoder;
    this.decoder = new StringDecoder(options.encoding);
    this.encoding = options.encoding;
  }
}

function Readable(options) {
  var Duplex = require('./_stream_duplex');

  if (!(this instanceof Readable))
    return new Readable(options);

  this._readableState = new ReadableState(options, this);

  // legacy
  this.readable = true;

  Stream.call(this);
}

// Manually shove something into the read() buffer.
// This returns true if the highWaterMark has not been hit yet,
// similar to how Writable.write() returns true if you should
// write() some more.
Readable.prototype.push = function(chunk, encoding) {
  var state = this._readableState;

  if (util.isString(chunk) && !state.objectMode) {
    encoding = encoding || state.defaultEncoding;
    if (encoding !== state.encoding) {
      chunk = new Buffer(chunk, encoding);
      encoding = '';
    }
  }

  return readableAddChunk(this, state, chunk, encoding, false);
};

// Unshift should *always* be something directly out of read()
Readable.prototype.unshift = function(chunk) {
  var state = this._readableState;
  return readableAddChunk(this, state, chunk, '', true);
};

function readableAddChunk(stream, state, chunk, encoding, addToFront) {
  var er = chunkInvalid(state, chunk);
  if (er) {
    stream.emit('error', er);
  } else if (util.isNullOrUndefined(chunk)) {
    state.reading = false;
    if (!state.ended)
      onEofChunk(stream, state);
  } else if (state.objectMode || chunk && chunk.length > 0) {
    if (state.ended && !addToFront) {
      var e = new Error('stream.push() after EOF');
      stream.emit('error', e);
    } else if (state.endEmitted && addToFront) {
      var e = new Error('stream.unshift() after end event');
      stream.emit('error', e);
    } else {
      if (state.decoder && !addToFront && !encoding)
        chunk = state.decoder.write(chunk);

      if (!addToFront)
        state.reading = false;

      // if we want the data now, just emit it.
      if (state.flowing && state.length === 0 && !state.sync) {
        stream.emit('data', chunk);
        stream.read(0);
      } else {
        // update the buffer info.
        state.length += state.objectMode ? 1 : chunk.length;
        if (addToFront)
          state.buffer.unshift(chunk);
        else
          state.buffer.push(chunk);

        if (state.needReadable)
          emitReadable(stream);
      }

      maybeReadMore(stream, state);
    }
  } else if (!addToFront) {
    state.reading = false;
  }

  return needMoreData(state);
}



// if it's past the high water mark, we can push in some more.
// Also, if we have no data yet, we can stand some
// more bytes.  This is to work around cases where hwm=0,
// such as the repl.  Also, if the push() triggered a
// readable event, and the user called read(largeNumber) such that
// needReadable was set, then we ought to push more, so that another
// 'readable' event will be triggered.
function needMoreData(state) {
  return !state.ended &&
         (state.needReadable ||
          state.length < state.highWaterMark ||
          state.length === 0);
}

// backwards compatibility.
Readable.prototype.setEncoding = function(enc) {
  if (!StringDecoder)
    StringDecoder = require('string_decoder/').StringDecoder;
  this._readableState.decoder = new StringDecoder(enc);
  this._readableState.encoding = enc;
  return this;
};

// Don't raise the hwm > 128MB
var MAX_HWM = 0x800000;
function roundUpToNextPowerOf2(n) {
  if (n >= MAX_HWM) {
    n = MAX_HWM;
  } else {
    // Get the next highest power of 2
    n--;
    for (var p = 1; p < 32; p <<= 1) n |= n >> p;
    n++;
  }
  return n;
}

function howMuchToRead(n, state) {
  if (state.length === 0 && state.ended)
    return 0;

  if (state.objectMode)
    return n === 0 ? 0 : 1;

  if (isNaN(n) || util.isNull(n)) {
    // only flow one buffer at a time
    if (state.flowing && state.buffer.length)
      return state.buffer[0].length;
    else
      return state.length;
  }

  if (n <= 0)
    return 0;

  // If we're asking for more than the target buffer level,
  // then raise the water mark.  Bump up to the next highest
  // power of 2, to prevent increasing it excessively in tiny
  // amounts.
  if (n > state.highWaterMark)
    state.highWaterMark = roundUpToNextPowerOf2(n);

  // don't have that much.  return null, unless we've ended.
  if (n > state.length) {
    if (!state.ended) {
      state.needReadable = true;
      return 0;
    } else
      return state.length;
  }

  return n;
}

// you can override either this method, or the async _read(n) below.
Readable.prototype.read = function(n) {
  debug('read', n);
  var state = this._readableState;
  var nOrig = n;

  if (!util.isNumber(n) || n > 0)
    state.emittedReadable = false;

  // if we're doing read(0) to trigger a readable event, but we
  // already have a bunch of data in the buffer, then just trigger
  // the 'readable' event and move on.
  if (n === 0 &&
      state.needReadable &&
      (state.length >= state.highWaterMark || state.ended)) {
    debug('read: emitReadable', state.length, state.ended);
    if (state.length === 0 && state.ended)
      endReadable(this);
    else
      emitReadable(this);
    return null;
  }

  n = howMuchToRead(n, state);

  // if we've ended, and we're now clear, then finish it up.
  if (n === 0 && state.ended) {
    if (state.length === 0)
      endReadable(this);
    return null;
  }

  // All the actual chunk generation logic needs to be
  // *below* the call to _read.  The reason is that in certain
  // synthetic stream cases, such as passthrough streams, _read
  // may be a completely synchronous operation which may change
  // the state of the read buffer, providing enough data when
  // before there was *not* enough.
  //
  // So, the steps are:
  // 1. Figure out what the state of things will be after we do
  // a read from the buffer.
  //
  // 2. If that resulting state will trigger a _read, then call _read.
  // Note that this may be asynchronous, or synchronous.  Yes, it is
  // deeply ugly to write APIs this way, but that still doesn't mean
  // that the Readable class should behave improperly, as streams are
  // designed to be sync/async agnostic.
  // Take note if the _read call is sync or async (ie, if the read call
  // has returned yet), so that we know whether or not it's safe to emit
  // 'readable' etc.
  //
  // 3. Actually pull the requested chunks out of the buffer and return.

  // if we need a readable event, then we need to do some reading.
  var doRead = state.needReadable;
  debug('need readable', doRead);

  // if we currently have less than the highWaterMark, then also read some
  if (state.length === 0 || state.length - n < state.highWaterMark) {
    doRead = true;
    debug('length less than watermark', doRead);
  }

  // however, if we've ended, then there's no point, and if we're already
  // reading, then it's unnecessary.
  if (state.ended || state.reading) {
    doRead = false;
    debug('reading or ended', doRead);
  }

  if (doRead) {
    debug('do read');
    state.reading = true;
    state.sync = true;
    // if the length is currently zero, then we *need* a readable event.
    if (state.length === 0)
      state.needReadable = true;
    // call internal read method
    this._read(state.highWaterMark);
    state.sync = false;
  }

  // If _read pushed data synchronously, then `reading` will be false,
  // and we need to re-evaluate how much data we can return to the user.
  if (doRead && !state.reading)
    n = howMuchToRead(nOrig, state);

  var ret;
  if (n > 0)
    ret = fromList(n, state);
  else
    ret = null;

  if (util.isNull(ret)) {
    state.needReadable = true;
    n = 0;
  }

  state.length -= n;

  // If we have nothing in the buffer, then we want to know
  // as soon as we *do* get something into the buffer.
  if (state.length === 0 && !state.ended)
    state.needReadable = true;

  // If we tried to read() past the EOF, then emit end on the next tick.
  if (nOrig !== n && state.ended && state.length === 0)
    endReadable(this);

  if (!util.isNull(ret))
    this.emit('data', ret);

  return ret;
};

function chunkInvalid(state, chunk) {
  var er = null;
  if (!util.isBuffer(chunk) &&
      !util.isString(chunk) &&
      !util.isNullOrUndefined(chunk) &&
      !state.objectMode) {
    er = new TypeError('Invalid non-string/buffer chunk');
  }
  return er;
}


function onEofChunk(stream, state) {
  if (state.decoder && !state.ended) {
    var chunk = state.decoder.end();
    if (chunk && chunk.length) {
      state.buffer.push(chunk);
      state.length += state.objectMode ? 1 : chunk.length;
    }
  }
  state.ended = true;

  // emit 'readable' now to make sure it gets picked up.
  emitReadable(stream);
}

// Don't emit readable right away in sync mode, because this can trigger
// another read() call => stack overflow.  This way, it might trigger
// a nextTick recursion warning, but that's not so bad.
function emitReadable(stream) {
  var state = stream._readableState;
  state.needReadable = false;
  if (!state.emittedReadable) {
    debug('emitReadable', state.flowing);
    state.emittedReadable = true;
    if (state.sync)
      process.nextTick(function() {
        emitReadable_(stream);
      });
    else
      emitReadable_(stream);
  }
}

function emitReadable_(stream) {
  debug('emit readable');
  stream.emit('readable');
  flow(stream);
}


// at this point, the user has presumably seen the 'readable' event,
// and called read() to consume some data.  that may have triggered
// in turn another _read(n) call, in which case reading = true if
// it's in progress.
// However, if we're not ended, or reading, and the length < hwm,
// then go ahead and try to read some more preemptively.
function maybeReadMore(stream, state) {
  if (!state.readingMore) {
    state.readingMore = true;
    process.nextTick(function() {
      maybeReadMore_(stream, state);
    });
  }
}

function maybeReadMore_(stream, state) {
  var len = state.length;
  while (!state.reading && !state.flowing && !state.ended &&
         state.length < state.highWaterMark) {
    debug('maybeReadMore read 0');
    stream.read(0);
    if (len === state.length)
      // didn't get any data, stop spinning.
      break;
    else
      len = state.length;
  }
  state.readingMore = false;
}

// abstract method.  to be overridden in specific implementation classes.
// call cb(er, data) where data is <= n in length.
// for virtual (non-string, non-buffer) streams, "length" is somewhat
// arbitrary, and perhaps not very meaningful.
Readable.prototype._read = function(n) {
  this.emit('error', new Error('not implemented'));
};

Readable.prototype.pipe = function(dest, pipeOpts) {
  var src = this;
  var state = this._readableState;

  switch (state.pipesCount) {
    case 0:
      state.pipes = dest;
      break;
    case 1:
      state.pipes = [state.pipes, dest];
      break;
    default:
      state.pipes.push(dest);
      break;
  }
  state.pipesCount += 1;
  debug('pipe count=%d opts=%j', state.pipesCount, pipeOpts);

  var doEnd = (!pipeOpts || pipeOpts.end !== false) &&
              dest !== process.stdout &&
              dest !== process.stderr;

  var endFn = doEnd ? onend : cleanup;
  if (state.endEmitted)
    process.nextTick(endFn);
  else
    src.once('end', endFn);

  dest.on('unpipe', onunpipe);
  function onunpipe(readable) {
    debug('onunpipe');
    if (readable === src) {
      cleanup();
    }
  }

  function onend() {
    debug('onend');
    dest.end();
  }

  // when the dest drains, it reduces the awaitDrain counter
  // on the source.  This would be more elegant with a .once()
  // handler in flow(), but adding and removing repeatedly is
  // too slow.
  var ondrain = pipeOnDrain(src);
  dest.on('drain', ondrain);

  function cleanup() {
    debug('cleanup');
    // cleanup event handlers once the pipe is broken
    dest.removeListener('close', onclose);
    dest.removeListener('finish', onfinish);
    dest.removeListener('drain', ondrain);
    dest.removeListener('error', onerror);
    dest.removeListener('unpipe', onunpipe);
    src.removeListener('end', onend);
    src.removeListener('end', cleanup);
    src.removeListener('data', ondata);

    // if the reader is waiting for a drain event from this
    // specific writer, then it would cause it to never start
    // flowing again.
    // So, if this is awaiting a drain, then we just call it now.
    // If we don't know, then assume that we are waiting for one.
    if (state.awaitDrain &&
        (!dest._writableState || dest._writableState.needDrain))
      ondrain();
  }

  src.on('data', ondata);
  function ondata(chunk) {
    debug('ondata');
    var ret = dest.write(chunk);
    if (false === ret) {
      debug('false write response, pause',
            src._readableState.awaitDrain);
      src._readableState.awaitDrain++;
      src.pause();
    }
  }

  // if the dest has an error, then stop piping into it.
  // however, don't suppress the throwing behavior for this.
  function onerror(er) {
    debug('onerror', er);
    unpipe();
    dest.removeListener('error', onerror);
    if (EE.listenerCount(dest, 'error') === 0)
      dest.emit('error', er);
  }
  // This is a brutally ugly hack to make sure that our error handler
  // is attached before any userland ones.  NEVER DO THIS.
  if (!dest._events || !dest._events.error)
    dest.on('error', onerror);
  else if (isArray(dest._events.error))
    dest._events.error.unshift(onerror);
  else
    dest._events.error = [onerror, dest._events.error];



  // Both close and finish should trigger unpipe, but only once.
  function onclose() {
    dest.removeListener('finish', onfinish);
    unpipe();
  }
  dest.once('close', onclose);
  function onfinish() {
    debug('onfinish');
    dest.removeListener('close', onclose);
    unpipe();
  }
  dest.once('finish', onfinish);

  function unpipe() {
    debug('unpipe');
    src.unpipe(dest);
  }

  // tell the dest that it's being piped to
  dest.emit('pipe', src);

  // start the flow if it hasn't been started already.
  if (!state.flowing) {
    debug('pipe resume');
    src.resume();
  }

  return dest;
};

function pipeOnDrain(src) {
  return function() {
    var state = src._readableState;
    debug('pipeOnDrain', state.awaitDrain);
    if (state.awaitDrain)
      state.awaitDrain--;
    if (state.awaitDrain === 0 && EE.listenerCount(src, 'data')) {
      state.flowing = true;
      flow(src);
    }
  };
}


Readable.prototype.unpipe = function(dest) {
  var state = this._readableState;

  // if we're not piping anywhere, then do nothing.
  if (state.pipesCount === 0)
    return this;

  // just one destination.  most common case.
  if (state.pipesCount === 1) {
    // passed in one, but it's not the right one.
    if (dest && dest !== state.pipes)
      return this;

    if (!dest)
      dest = state.pipes;

    // got a match.
    state.pipes = null;
    state.pipesCount = 0;
    state.flowing = false;
    if (dest)
      dest.emit('unpipe', this);
    return this;
  }

  // slow case. multiple pipe destinations.

  if (!dest) {
    // remove all.
    var dests = state.pipes;
    var len = state.pipesCount;
    state.pipes = null;
    state.pipesCount = 0;
    state.flowing = false;

    for (var i = 0; i < len; i++)
      dests[i].emit('unpipe', this);
    return this;
  }

  // try to find the right one.
  var i = indexOf(state.pipes, dest);
  if (i === -1)
    return this;

  state.pipes.splice(i, 1);
  state.pipesCount -= 1;
  if (state.pipesCount === 1)
    state.pipes = state.pipes[0];

  dest.emit('unpipe', this);

  return this;
};

// set up data events if they are asked for
// Ensure readable listeners eventually get something
Readable.prototype.on = function(ev, fn) {
  var res = Stream.prototype.on.call(this, ev, fn);

  // If listening to data, and it has not explicitly been paused,
  // then call resume to start the flow of data on the next tick.
  if (ev === 'data' && false !== this._readableState.flowing) {
    this.resume();
  }

  if (ev === 'readable' && this.readable) {
    var state = this._readableState;
    if (!state.readableListening) {
      state.readableListening = true;
      state.emittedReadable = false;
      state.needReadable = true;
      if (!state.reading) {
        var self = this;
        process.nextTick(function() {
          debug('readable nexttick read 0');
          self.read(0);
        });
      } else if (state.length) {
        emitReadable(this, state);
      }
    }
  }

  return res;
};
Readable.prototype.addListener = Readable.prototype.on;

// pause() and resume() are remnants of the legacy readable stream API
// If the user uses them, then switch into old mode.
Readable.prototype.resume = function() {
  var state = this._readableState;
  if (!state.flowing) {
    debug('resume');
    state.flowing = true;
    if (!state.reading) {
      debug('resume read 0');
      this.read(0);
    }
    resume(this, state);
  }
  return this;
};

function resume(stream, state) {
  if (!state.resumeScheduled) {
    state.resumeScheduled = true;
    process.nextTick(function() {
      resume_(stream, state);
    });
  }
}

function resume_(stream, state) {
  state.resumeScheduled = false;
  stream.emit('resume');
  flow(stream);
  if (state.flowing && !state.reading)
    stream.read(0);
}

Readable.prototype.pause = function() {
  debug('call pause flowing=%j', this._readableState.flowing);
  if (false !== this._readableState.flowing) {
    debug('pause');
    this._readableState.flowing = false;
    this.emit('pause');
  }
  return this;
};

function flow(stream) {
  var state = stream._readableState;
  debug('flow', state.flowing);
  if (state.flowing) {
    do {
      var chunk = stream.read();
    } while (null !== chunk && state.flowing);
  }
}

// wrap an old-style stream as the async data source.
// This is *not* part of the readable stream interface.
// It is an ugly unfortunate mess of history.
Readable.prototype.wrap = function(stream) {
  var state = this._readableState;
  var paused = false;

  var self = this;
  stream.on('end', function() {
    debug('wrapped end');
    if (state.decoder && !state.ended) {
      var chunk = state.decoder.end();
      if (chunk && chunk.length)
        self.push(chunk);
    }

    self.push(null);
  });

  stream.on('data', function(chunk) {
    debug('wrapped data');
    if (state.decoder)
      chunk = state.decoder.write(chunk);
    if (!chunk || !state.objectMode && !chunk.length)
      return;

    var ret = self.push(chunk);
    if (!ret) {
      paused = true;
      stream.pause();
    }
  });

  // proxy all the other methods.
  // important when wrapping filters and duplexes.
  for (var i in stream) {
    if (util.isFunction(stream[i]) && util.isUndefined(this[i])) {
      this[i] = function(method) { return function() {
        return stream[method].apply(stream, arguments);
      }}(i);
    }
  }

  // proxy certain important events.
  var events = ['error', 'close', 'destroy', 'pause', 'resume'];
  forEach(events, function(ev) {
    stream.on(ev, self.emit.bind(self, ev));
  });

  // when we try to consume some more bytes, simply unpause the
  // underlying stream.
  self._read = function(n) {
    debug('wrapped _read', n);
    if (paused) {
      paused = false;
      stream.resume();
    }
  };

  return self;
};



// exposed for testing purposes only.
Readable._fromList = fromList;

// Pluck off n bytes from an array of buffers.
// Length is the combined lengths of all the buffers in the list.
function fromList(n, state) {
  var list = state.buffer;
  var length = state.length;
  var stringMode = !!state.decoder;
  var objectMode = !!state.objectMode;
  var ret;

  // nothing in the list, definitely empty.
  if (list.length === 0)
    return null;

  if (length === 0)
    ret = null;
  else if (objectMode)
    ret = list.shift();
  else if (!n || n >= length) {
    // read it all, truncate the array.
    if (stringMode)
      ret = list.join('');
    else
      ret = Buffer.concat(list, length);
    list.length = 0;
  } else {
    // read just some of it.
    if (n < list[0].length) {
      // just take a part of the first list item.
      // slice is the same for buffers and strings.
      var buf = list[0];
      ret = buf.slice(0, n);
      list[0] = buf.slice(n);
    } else if (n === list[0].length) {
      // first list is a perfect match
      ret = list.shift();
    } else {
      // complex case.
      // we have enough to cover it, but it spans past the first buffer.
      if (stringMode)
        ret = '';
      else
        ret = new Buffer(n);

      var c = 0;
      for (var i = 0, l = list.length; i < l && c < n; i++) {
        var buf = list[0];
        var cpy = Math.min(n - c, buf.length);

        if (stringMode)
          ret += buf.slice(0, cpy);
        else
          buf.copy(ret, c, 0, cpy);

        if (cpy < buf.length)
          list[0] = buf.slice(cpy);
        else
          list.shift();

        c += cpy;
      }
    }
  }

  return ret;
}

function endReadable(stream) {
  var state = stream._readableState;

  // If we get here before consuming all the bytes, then that is a
  // bug in node.  Should never happen.
  if (state.length > 0)
    throw new Error('endReadable called on non-empty stream');

  if (!state.endEmitted) {
    state.ended = true;
    process.nextTick(function() {
      // Check that we didn't get one last unshift.
      if (!state.endEmitted && state.length === 0) {
        state.endEmitted = true;
        stream.readable = false;
        stream.emit('end');
      }
    });
  }
}

function forEach (xs, f) {
  for (var i = 0, l = xs.length; i < l; i++) {
    f(xs[i], i);
  }
}

function indexOf (xs, x) {
  for (var i = 0, l = xs.length; i < l; i++) {
    if (xs[i] === x) return i;
  }
  return -1;
}

}).call(this,require('_process'))
},{"./_stream_duplex":99,"_process":136,"buffer":46,"core-util-is":47,"events":59,"inherits":90,"isarray":98,"stream":285,"string_decoder/":286,"util":45}],102:[function(require,module,exports){
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.


// a transform stream is a readable/writable stream where you do
// something with the data.  Sometimes it's called a "filter",
// but that's not a great name for it, since that implies a thing where
// some bits pass through, and others are simply ignored.  (That would
// be a valid example of a transform, of course.)
//
// While the output is causally related to the input, it's not a
// necessarily symmetric or synchronous transformation.  For example,
// a zlib stream might take multiple plain-text writes(), and then
// emit a single compressed chunk some time in the future.
//
// Here's how this works:
//
// The Transform stream has all the aspects of the readable and writable
// stream classes.  When you write(chunk), that calls _write(chunk,cb)
// internally, and returns false if there's a lot of pending writes
// buffered up.  When you call read(), that calls _read(n) until
// there's enough pending readable data buffered up.
//
// In a transform stream, the written data is placed in a buffer.  When
// _read(n) is called, it transforms the queued up data, calling the
// buffered _write cb's as it consumes chunks.  If consuming a single
// written chunk would result in multiple output chunks, then the first
// outputted bit calls the readcb, and subsequent chunks just go into
// the read buffer, and will cause it to emit 'readable' if necessary.
//
// This way, back-pressure is actually determined by the reading side,
// since _read has to be called to start processing a new chunk.  However,
// a pathological inflate type of transform can cause excessive buffering
// here.  For example, imagine a stream where every byte of input is
// interpreted as an integer from 0-255, and then results in that many
// bytes of output.  Writing the 4 bytes {ff,ff,ff,ff} would result in
// 1kb of data being output.  In this case, you could write a very small
// amount of input, and end up with a very large amount of output.  In
// such a pathological inflating mechanism, there'd be no way to tell
// the system to stop doing the transform.  A single 4MB write could
// cause the system to run out of memory.
//
// However, even in such a pathological case, only a single written chunk
// would be consumed, and then the rest would wait (un-transformed) until
// the results of the previous transformed chunk were consumed.

module.exports = Transform;

var Duplex = require('./_stream_duplex');

/*<replacement>*/
var util = require('core-util-is');
util.inherits = require('inherits');
/*</replacement>*/

util.inherits(Transform, Duplex);


function TransformState(options, stream) {
  this.afterTransform = function(er, data) {
    return afterTransform(stream, er, data);
  };

  this.needTransform = false;
  this.transforming = false;
  this.writecb = null;
  this.writechunk = null;
}

function afterTransform(stream, er, data) {
  var ts = stream._transformState;
  ts.transforming = false;

  var cb = ts.writecb;

  if (!cb)
    return stream.emit('error', new Error('no writecb in Transform class'));

  ts.writechunk = null;
  ts.writecb = null;

  if (!util.isNullOrUndefined(data))
    stream.push(data);

  if (cb)
    cb(er);

  var rs = stream._readableState;
  rs.reading = false;
  if (rs.needReadable || rs.length < rs.highWaterMark) {
    stream._read(rs.highWaterMark);
  }
}


function Transform(options) {
  if (!(this instanceof Transform))
    return new Transform(options);

  Duplex.call(this, options);

  this._transformState = new TransformState(options, this);

  // when the writable side finishes, then flush out anything remaining.
  var stream = this;

  // start out asking for a readable event once data is transformed.
  this._readableState.needReadable = true;

  // we have implemented the _read method, and done the other things
  // that Readable wants before the first _read call, so unset the
  // sync guard flag.
  this._readableState.sync = false;

  this.once('prefinish', function() {
    if (util.isFunction(this._flush))
      this._flush(function(er) {
        done(stream, er);
      });
    else
      done(stream);
  });
}

Transform.prototype.push = function(chunk, encoding) {
  this._transformState.needTransform = false;
  return Duplex.prototype.push.call(this, chunk, encoding);
};

// This is the part where you do stuff!
// override this function in implementation classes.
// 'chunk' is an input chunk.
//
// Call `push(newChunk)` to pass along transformed output
// to the readable side.  You may call 'push' zero or more times.
//
// Call `cb(err)` when you are done with this chunk.  If you pass
// an error, then that'll put the hurt on the whole operation.  If you
// never call cb(), then you'll never get another chunk.
Transform.prototype._transform = function(chunk, encoding, cb) {
  throw new Error('not implemented');
};

Transform.prototype._write = function(chunk, encoding, cb) {
  var ts = this._transformState;
  ts.writecb = cb;
  ts.writechunk = chunk;
  ts.writeencoding = encoding;
  if (!ts.transforming) {
    var rs = this._readableState;
    if (ts.needTransform ||
        rs.needReadable ||
        rs.length < rs.highWaterMark)
      this._read(rs.highWaterMark);
  }
};

// Doesn't matter what the args are here.
// _transform does all the work.
// That we got here means that the readable side wants more data.
Transform.prototype._read = function(n) {
  var ts = this._transformState;

  if (!util.isNull(ts.writechunk) && ts.writecb && !ts.transforming) {
    ts.transforming = true;
    this._transform(ts.writechunk, ts.writeencoding, ts.afterTransform);
  } else {
    // mark that we need a transform, so that any data that comes in
    // will get processed, now that we've asked for it.
    ts.needTransform = true;
  }
};


function done(stream, er) {
  if (er)
    return stream.emit('error', er);

  // if there's nothing in the write buffer, then that means
  // that nothing more will ever be provided
  var ws = stream._writableState;
  var ts = stream._transformState;

  if (ws.length)
    throw new Error('calling transform done when ws.length != 0');

  if (ts.transforming)
    throw new Error('calling transform done when still transforming');

  return stream.push(null);
}

},{"./_stream_duplex":99,"core-util-is":47,"inherits":90}],103:[function(require,module,exports){
(function (process){
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// A bit simpler than readable streams.
// Implement an async ._write(chunk, cb), and it'll handle all
// the drain event emission and buffering.

module.exports = Writable;

/*<replacement>*/
var Buffer = require('buffer').Buffer;
/*</replacement>*/

Writable.WritableState = WritableState;


/*<replacement>*/
var util = require('core-util-is');
util.inherits = require('inherits');
/*</replacement>*/

var Stream = require('stream');

util.inherits(Writable, Stream);

function WriteReq(chunk, encoding, cb) {
  this.chunk = chunk;
  this.encoding = encoding;
  this.callback = cb;
}

function WritableState(options, stream) {
  var Duplex = require('./_stream_duplex');

  options = options || {};

  // the point at which write() starts returning false
  // Note: 0 is a valid value, means that we always return false if
  // the entire buffer is not flushed immediately on write()
  var hwm = options.highWaterMark;
  var defaultHwm = options.objectMode ? 16 : 16 * 1024;
  this.highWaterMark = (hwm || hwm === 0) ? hwm : defaultHwm;

  // object stream flag to indicate whether or not this stream
  // contains buffers or objects.
  this.objectMode = !!options.objectMode;

  if (stream instanceof Duplex)
    this.objectMode = this.objectMode || !!options.writableObjectMode;

  // cast to ints.
  this.highWaterMark = ~~this.highWaterMark;

  this.needDrain = false;
  // at the start of calling end()
  this.ending = false;
  // when end() has been called, and returned
  this.ended = false;
  // when 'finish' is emitted
  this.finished = false;

  // should we decode strings into buffers before passing to _write?
  // this is here so that some node-core streams can optimize string
  // handling at a lower level.
  var noDecode = options.decodeStrings === false;
  this.decodeStrings = !noDecode;

  // Crypto is kind of old and crusty.  Historically, its default string
  // encoding is 'binary' so we have to make this configurable.
  // Everything else in the universe uses 'utf8', though.
  this.defaultEncoding = options.defaultEncoding || 'utf8';

  // not an actual buffer we keep track of, but a measurement
  // of how much we're waiting to get pushed to some underlying
  // socket or file.
  this.length = 0;

  // a flag to see when we're in the middle of a write.
  this.writing = false;

  // when true all writes will be buffered until .uncork() call
  this.corked = 0;

  // a flag to be able to tell if the onwrite cb is called immediately,
  // or on a later tick.  We set this to true at first, because any
  // actions that shouldn't happen until "later" should generally also
  // not happen before the first write call.
  this.sync = true;

  // a flag to know if we're processing previously buffered items, which
  // may call the _write() callback in the same tick, so that we don't
  // end up in an overlapped onwrite situation.
  this.bufferProcessing = false;

  // the callback that's passed to _write(chunk,cb)
  this.onwrite = function(er) {
    onwrite(stream, er);
  };

  // the callback that the user supplies to write(chunk,encoding,cb)
  this.writecb = null;

  // the amount that is being written when _write is called.
  this.writelen = 0;

  this.buffer = [];

  // number of pending user-supplied write callbacks
  // this must be 0 before 'finish' can be emitted
  this.pendingcb = 0;

  // emit prefinish if the only thing we're waiting for is _write cbs
  // This is relevant for synchronous Transform streams
  this.prefinished = false;

  // True if the error was already emitted and should not be thrown again
  this.errorEmitted = false;
}

function Writable(options) {
  var Duplex = require('./_stream_duplex');

  // Writable ctor is applied to Duplexes, though they're not
  // instanceof Writable, they're instanceof Readable.
  if (!(this instanceof Writable) && !(this instanceof Duplex))
    return new Writable(options);

  this._writableState = new WritableState(options, this);

  // legacy.
  this.writable = true;

  Stream.call(this);
}

// Otherwise people can pipe Writable streams, which is just wrong.
Writable.prototype.pipe = function() {
  this.emit('error', new Error('Cannot pipe. Not readable.'));
};


function writeAfterEnd(stream, state, cb) {
  var er = new Error('write after end');
  // TODO: defer error events consistently everywhere, not just the cb
  stream.emit('error', er);
  process.nextTick(function() {
    cb(er);
  });
}

// If we get something that is not a buffer, string, null, or undefined,
// and we're not in objectMode, then that's an error.
// Otherwise stream chunks are all considered to be of length=1, and the
// watermarks determine how many objects to keep in the buffer, rather than
// how many bytes or characters.
function validChunk(stream, state, chunk, cb) {
  var valid = true;
  if (!util.isBuffer(chunk) &&
      !util.isString(chunk) &&
      !util.isNullOrUndefined(chunk) &&
      !state.objectMode) {
    var er = new TypeError('Invalid non-string/buffer chunk');
    stream.emit('error', er);
    process.nextTick(function() {
      cb(er);
    });
    valid = false;
  }
  return valid;
}

Writable.prototype.write = function(chunk, encoding, cb) {
  var state = this._writableState;
  var ret = false;

  if (util.isFunction(encoding)) {
    cb = encoding;
    encoding = null;
  }

  if (util.isBuffer(chunk))
    encoding = 'buffer';
  else if (!encoding)
    encoding = state.defaultEncoding;

  if (!util.isFunction(cb))
    cb = function() {};

  if (state.ended)
    writeAfterEnd(this, state, cb);
  else if (validChunk(this, state, chunk, cb)) {
    state.pendingcb++;
    ret = writeOrBuffer(this, state, chunk, encoding, cb);
  }

  return ret;
};

Writable.prototype.cork = function() {
  var state = this._writableState;

  state.corked++;
};

Writable.prototype.uncork = function() {
  var state = this._writableState;

  if (state.corked) {
    state.corked--;

    if (!state.writing &&
        !state.corked &&
        !state.finished &&
        !state.bufferProcessing &&
        state.buffer.length)
      clearBuffer(this, state);
  }
};

function decodeChunk(state, chunk, encoding) {
  if (!state.objectMode &&
      state.decodeStrings !== false &&
      util.isString(chunk)) {
    chunk = new Buffer(chunk, encoding);
  }
  return chunk;
}

// if we're already writing something, then just put this
// in the queue, and wait our turn.  Otherwise, call _write
// If we return false, then we need a drain event, so set that flag.
function writeOrBuffer(stream, state, chunk, encoding, cb) {
  chunk = decodeChunk(state, chunk, encoding);
  if (util.isBuffer(chunk))
    encoding = 'buffer';
  var len = state.objectMode ? 1 : chunk.length;

  state.length += len;

  var ret = state.length < state.highWaterMark;
  // we must ensure that previous needDrain will not be reset to false.
  if (!ret)
    state.needDrain = true;

  if (state.writing || state.corked)
    state.buffer.push(new WriteReq(chunk, encoding, cb));
  else
    doWrite(stream, state, false, len, chunk, encoding, cb);

  return ret;
}

function doWrite(stream, state, writev, len, chunk, encoding, cb) {
  state.writelen = len;
  state.writecb = cb;
  state.writing = true;
  state.sync = true;
  if (writev)
    stream._writev(chunk, state.onwrite);
  else
    stream._write(chunk, encoding, state.onwrite);
  state.sync = false;
}

function onwriteError(stream, state, sync, er, cb) {
  if (sync)
    process.nextTick(function() {
      state.pendingcb--;
      cb(er);
    });
  else {
    state.pendingcb--;
    cb(er);
  }

  stream._writableState.errorEmitted = true;
  stream.emit('error', er);
}

function onwriteStateUpdate(state) {
  state.writing = false;
  state.writecb = null;
  state.length -= state.writelen;
  state.writelen = 0;
}

function onwrite(stream, er) {
  var state = stream._writableState;
  var sync = state.sync;
  var cb = state.writecb;

  onwriteStateUpdate(state);

  if (er)
    onwriteError(stream, state, sync, er, cb);
  else {
    // Check if we're actually ready to finish, but don't emit yet
    var finished = needFinish(stream, state);

    if (!finished &&
        !state.corked &&
        !state.bufferProcessing &&
        state.buffer.length) {
      clearBuffer(stream, state);
    }

    if (sync) {
      process.nextTick(function() {
        afterWrite(stream, state, finished, cb);
      });
    } else {
      afterWrite(stream, state, finished, cb);
    }
  }
}

function afterWrite(stream, state, finished, cb) {
  if (!finished)
    onwriteDrain(stream, state);
  state.pendingcb--;
  cb();
  finishMaybe(stream, state);
}

// Must force callback to be called on nextTick, so that we don't
// emit 'drain' before the write() consumer gets the 'false' return
// value, and has a chance to attach a 'drain' listener.
function onwriteDrain(stream, state) {
  if (state.length === 0 && state.needDrain) {
    state.needDrain = false;
    stream.emit('drain');
  }
}


// if there's something in the buffer waiting, then process it
function clearBuffer(stream, state) {
  state.bufferProcessing = true;

  if (stream._writev && state.buffer.length > 1) {
    // Fast case, write everything using _writev()
    var cbs = [];
    for (var c = 0; c < state.buffer.length; c++)
      cbs.push(state.buffer[c].callback);

    // count the one we are adding, as well.
    // TODO(isaacs) clean this up
    state.pendingcb++;
    doWrite(stream, state, true, state.length, state.buffer, '', function(err) {
      for (var i = 0; i < cbs.length; i++) {
        state.pendingcb--;
        cbs[i](err);
      }
    });

    // Clear buffer
    state.buffer = [];
  } else {
    // Slow case, write chunks one-by-one
    for (var c = 0; c < state.buffer.length; c++) {
      var entry = state.buffer[c];
      var chunk = entry.chunk;
      var encoding = entry.encoding;
      var cb = entry.callback;
      var len = state.objectMode ? 1 : chunk.length;

      doWrite(stream, state, false, len, chunk, encoding, cb);

      // if we didn't call the onwrite immediately, then
      // it means that we need to wait until it does.
      // also, that means that the chunk and cb are currently
      // being processed, so move the buffer counter past them.
      if (state.writing) {
        c++;
        break;
      }
    }

    if (c < state.buffer.length)
      state.buffer = state.buffer.slice(c);
    else
      state.buffer.length = 0;
  }

  state.bufferProcessing = false;
}

Writable.prototype._write = function(chunk, encoding, cb) {
  cb(new Error('not implemented'));

};

Writable.prototype._writev = null;

Writable.prototype.end = function(chunk, encoding, cb) {
  var state = this._writableState;

  if (util.isFunction(chunk)) {
    cb = chunk;
    chunk = null;
    encoding = null;
  } else if (util.isFunction(encoding)) {
    cb = encoding;
    encoding = null;
  }

  if (!util.isNullOrUndefined(chunk))
    this.write(chunk, encoding);

  // .end() fully uncorks
  if (state.corked) {
    state.corked = 1;
    this.uncork();
  }

  // ignore unnecessary end() calls.
  if (!state.ending && !state.finished)
    endWritable(this, state, cb);
};


function needFinish(stream, state) {
  return (state.ending &&
          state.length === 0 &&
          !state.finished &&
          !state.writing);
}

function prefinish(stream, state) {
  if (!state.prefinished) {
    state.prefinished = true;
    stream.emit('prefinish');
  }
}

function finishMaybe(stream, state) {
  var need = needFinish(stream, state);
  if (need) {
    if (state.pendingcb === 0) {
      prefinish(stream, state);
      state.finished = true;
      stream.emit('finish');
    } else
      prefinish(stream, state);
  }
  return need;
}

function endWritable(stream, state, cb) {
  state.ending = true;
  finishMaybe(stream, state);
  if (cb) {
    if (state.finished)
      process.nextTick(cb);
    else
      stream.once('finish', cb);
  }
  state.ended = true;
}

}).call(this,require('_process'))
},{"./_stream_duplex":99,"_process":136,"buffer":46,"core-util-is":47,"inherits":90,"stream":285}],104:[function(require,module,exports){
(function (process){
exports = module.exports = require('./lib/_stream_readable.js');
exports.Stream = require('stream');
exports.Readable = exports;
exports.Writable = require('./lib/_stream_writable.js');
exports.Duplex = require('./lib/_stream_duplex.js');
exports.Transform = require('./lib/_stream_transform.js');
exports.PassThrough = require('./lib/_stream_passthrough.js');
if (!process.browser && process.env.READABLE_STREAM === 'disable') {
  module.exports = require('stream');
}

}).call(this,require('_process'))
},{"./lib/_stream_duplex.js":99,"./lib/_stream_passthrough.js":100,"./lib/_stream_readable.js":101,"./lib/_stream_transform.js":102,"./lib/_stream_writable.js":103,"_process":136,"stream":285}],105:[function(require,module,exports){
/* Copyright (c) 2012-2016 LevelUP contributors
 * See list at <https://github.com/level/levelup#contributing>
 * MIT License
 * <https://github.com/level/levelup/blob/master/LICENSE.md>
 */

var util          = require('./util')
  , WriteError    = require('level-errors').WriteError

  , getOptions    = util.getOptions
  , dispatchError = util.dispatchError

function Batch (levelup, codec) {
  this._levelup = levelup
  this._codec = codec
  this.batch = levelup.db.batch()
  this.ops = []
  this.length = 0
}

Batch.prototype.put = function (key_, value_, options) {
  options = getOptions(options)

  var key   = this._codec.encodeKey(key_, options)
    , value = this._codec.encodeValue(value_, options)

  try {
    this.batch.put(key, value)
  } catch (e) {
    throw new WriteError(e)
  }
  this.ops.push({ type : 'put', key : key, value : value })
  this.length++

  return this
}

Batch.prototype.del = function (key_, options) {
  options = getOptions(options)

  var key = this._codec.encodeKey(key_, options)

  try {
    this.batch.del(key)
  } catch (err) {
    throw new WriteError(err)
  }
  this.ops.push({ type : 'del', key : key })
  this.length++

  return this
}

Batch.prototype.clear = function () {
  try {
    this.batch.clear()
  } catch (err) {
    throw new WriteError(err)
  }

  this.ops = []
  this.length = 0
  return this
}

Batch.prototype.write = function (callback) {
  var levelup = this._levelup
    , ops     = this.ops

  try {
    this.batch.write(function (err) {
      if (err)
        return dispatchError(levelup, new WriteError(err), callback)
      levelup.emit('batch', ops)
      if (callback)
        callback()
    })
  } catch (err) {
    throw new WriteError(err)
  }
}

module.exports = Batch

},{"./util":107,"level-errors":96}],106:[function(require,module,exports){
(function (process){
/* Copyright (c) 2012-2016 LevelUP contributors
 * See list at <https://github.com/level/levelup#contributing>
 * MIT License
 * <https://github.com/level/levelup/blob/master/LICENSE.md>
 */

var EventEmitter        = require('events').EventEmitter
  , inherits            = require('util').inherits
  , deprecate           = require('util').deprecate
  , extend              = require('xtend')
  , prr                 = require('prr')
  , DeferredLevelDOWN   = require('deferred-leveldown')
  , IteratorStream      = require('level-iterator-stream')

  , errors              = require('level-errors')
  , WriteError          = errors.WriteError
  , ReadError           = errors.ReadError
  , NotFoundError       = errors.NotFoundError
  , OpenError           = errors.OpenError
  , EncodingError       = errors.EncodingError
  , InitializationError = errors.InitializationError

  , util                = require('./util')
  , Batch               = require('./batch')
  , Codec               = require('level-codec')

  , getOptions          = util.getOptions
  , defaultOptions      = util.defaultOptions
  , getLevelDOWN        = util.getLevelDOWN
  , dispatchError       = util.dispatchError
  , isDefined           = util.isDefined

function getCallback (options, callback) {
  return typeof options == 'function' ? options : callback
}

// Possible LevelUP#_status values:
//  - 'new'     - newly created, not opened or closed
//  - 'opening' - waiting for the database to be opened, post open()
//  - 'open'    - successfully opened the database, available for use
//  - 'closing' - waiting for the database to be closed, post close()
//  - 'closed'  - database has been successfully closed, should not be
//                 used except for another open() operation

function LevelUP (location, options, callback) {
  if (!(this instanceof LevelUP))
    return new LevelUP(location, options, callback)

  var error

  EventEmitter.call(this)
  this.setMaxListeners(Infinity)

  if (typeof location == 'function') {
    options = typeof options == 'object' ? options : {}
    options.db = location
    location = null
  } else if (typeof location == 'object' && typeof location.db == 'function') {
    options = location
    location = null
  }


  if (typeof options == 'function') {
    callback = options
    options  = {}
  }

  if ((!options || typeof options.db != 'function') && typeof location != 'string') {
    error = new InitializationError(
        'Must provide a location for the database')
    if (callback) {
      return process.nextTick(function () {
        callback(error)
      })
    }
    throw error
  }

  options      = getOptions(options)
  this.options = extend(defaultOptions, options)
  this._codec = new Codec(this.options)
  this._status = 'new'
  // set this.location as enumerable but not configurable or writable
  prr(this, 'location', location, 'e')

  this.open(callback)
}

inherits(LevelUP, EventEmitter)

LevelUP.prototype.open = function (callback) {
  var self = this
    , dbFactory
    , db

  if (this.isOpen()) {
    if (callback)
      process.nextTick(function () { callback(null, self) })
    return this
  }

  if (this._isOpening()) {
    return callback && this.once(
        'open'
      , function () { callback(null, self) }
    )
  }

  this.emit('opening')

  this._status = 'opening'
  this.db      = new DeferredLevelDOWN(this.location)
  dbFactory    = this.options.db || getLevelDOWN()
  db           = dbFactory(this.location)

  db.open(this.options, function (err) {
    if (err) {
      return dispatchError(self, new OpenError(err), callback)
    } else {
      self.db.setDb(db)
      self.db = db
      self._status = 'open'
      if (callback)
        callback(null, self)
      self.emit('open')
      self.emit('ready')
    }
  })
}

LevelUP.prototype.close = function (callback) {
  var self = this

  if (this.isOpen()) {
    this._status = 'closing'
    this.db.close(function () {
      self._status = 'closed'
      self.emit('closed')
      if (callback)
        callback.apply(null, arguments)
    })
    this.emit('closing')
    this.db = new DeferredLevelDOWN(this.location)
  } else if (this._status == 'closed' && callback) {
    return process.nextTick(callback)
  } else if (this._status == 'closing' && callback) {
    this.once('closed', callback)
  } else if (this._isOpening()) {
    this.once('open', function () {
      self.close(callback)
    })
  }
}

LevelUP.prototype.isOpen = function () {
  return this._status == 'open'
}

LevelUP.prototype._isOpening = function () {
  return this._status == 'opening'
}

LevelUP.prototype.isClosed = function () {
  return (/^clos/).test(this._status)
}

function maybeError(db, options, callback) {
  if (!db._isOpening() && !db.isOpen()) {
    dispatchError(
        db
      , new ReadError('Database is not open')
      , callback
    )
    return true
  }
}

function writeError (db, message, callback) {
  dispatchError(
      db
     , new WriteError(message)
     , callback
  )
}

function readError (db, message, callback) {
  dispatchError(
      db
     , new ReadError(message)
     , callback
  )
}


LevelUP.prototype.get = function (key_, options, callback) {
  var self = this
    , key

  callback = getCallback(options, callback)

  if (maybeError(this, options, callback))
    return

  if (key_ === null || key_ === undefined || 'function' !== typeof callback)
    return readError(this
      , 'get() requires key and callback arguments', callback)

  options = util.getOptions(options)
  key = this._codec.encodeKey(key_, options)

  options.asBuffer = this._codec.valueAsBuffer(options)

  this.db.get(key, options, function (err, value) {
    if (err) {
      if ((/notfound/i).test(err) || err.notFound) {
        err = new NotFoundError(
            'Key not found in database [' + key_ + ']', err)
      } else {
        err = new ReadError(err)
      }
      return dispatchError(self, err, callback)
    }
    if (callback) {
      try {
        value = self._codec.decodeValue(value, options)
      } catch (e) {
        return callback(new EncodingError(e))
      }
      callback(null, value)
    }
  })
}

LevelUP.prototype.put = function (key_, value_, options, callback) {
  var self = this
    , key
    , value

  callback = getCallback(options, callback)

  if (key_ === null || key_ === undefined)
    return writeError(this, 'put() requires a key argument', callback)

  if (maybeError(this, options, callback))
    return

  options = getOptions(options)
  key     = this._codec.encodeKey(key_, options)
  value   = this._codec.encodeValue(value_, options)

  this.db.put(key, value, options, function (err) {
    if (err) {
      return dispatchError(self, new WriteError(err), callback)
    } else {
      self.emit('put', key_, value_)
      if (callback)
        callback()
    }
  })
}

LevelUP.prototype.del = function (key_, options, callback) {
  var self = this
    , key

  callback = getCallback(options, callback)

  if (key_ === null || key_ === undefined)
    return writeError(this, 'del() requires a key argument', callback)

  if (maybeError(this, options, callback))
    return

  options = getOptions(options)
  key     = this._codec.encodeKey(key_, options)

  this.db.del(key, options, function (err) {
    if (err) {
      return dispatchError(self, new WriteError(err), callback)
    } else {
      self.emit('del', key_)
      if (callback)
        callback()
    }
  })
}

LevelUP.prototype.batch = function (arr_, options, callback) {
  var self = this
    , keyEnc
    , valueEnc
    , arr

  if (!arguments.length)
    return new Batch(this, this._codec)

  callback = getCallback(options, callback)

  if (!Array.isArray(arr_))
    return writeError(this, 'batch() requires an array argument', callback)

  if (maybeError(this, options, callback))
    return

  options  = getOptions(options)
  arr      = self._codec.encodeBatch(arr_, options)
  arr      = arr.map(function (op) {
    if (!op.type && op.key !== undefined && op.value !== undefined)
      op.type = 'put'
    return op
  })

  this.db.batch(arr, options, function (err) {
    if (err) {
      return dispatchError(self, new WriteError(err), callback)
    } else {
      self.emit('batch', arr_)
      if (callback)
        callback()
    }
  })
}

LevelUP.prototype.approximateSize = deprecate(function (start_, end_, options, callback) {   
  var self = this    
    , start    
    , end    
   
  callback = getCallback(options, callback)    
   
  options = getOptions(options)    
   
  if (start_ === null || start_ === undefined    
        || end_ === null || end_ === undefined || 'function' !== typeof callback)    
    return readError(this, 'approximateSize() requires start, end and callback arguments', callback)   
   
  start = this._codec.encodeKey(start_, options)   
  end   = this._codec.encodeKey(end_, options)   
   
  this.db.approximateSize(start, end, function (err, size) {   
    if (err) {   
      return dispatchError(self, new OpenError(err), callback)   
    } else if (callback) {   
      callback(null, size)   
    }    
  })   
}, 'db.approximateSize() is deprecated. Use db.db.approximateSize() instead')

LevelUP.prototype.readStream =
LevelUP.prototype.createReadStream = function (options) {
  options = extend( {keys: true, values: true}, this.options, options)

  options.keyEncoding   = options.keyEncoding
  options.valueEncoding = options.valueEncoding

  options = this._codec.encodeLtgt(options);
  options.keyAsBuffer   = this._codec.keyAsBuffer(options)
  options.valueAsBuffer = this._codec.valueAsBuffer(options)

  if ('number' !== typeof options.limit)
    options.limit = -1

  return new IteratorStream(this.db.iterator(options), extend(options, {
    decoder: this._codec.createStreamDecoder(options)
  }))
}

LevelUP.prototype.keyStream =
LevelUP.prototype.createKeyStream = function (options) {
  return this.createReadStream(extend(options, { keys: true, values: false }))
}

LevelUP.prototype.valueStream =
LevelUP.prototype.createValueStream = function (options) {
  return this.createReadStream(extend(options, { keys: false, values: true }))
}

LevelUP.prototype.toString = function () {
  return 'LevelUP'
}

function utilStatic (name) {
  return function (location, callback) {
    getLevelDOWN()[name](location, callback || function () {})
  }
}

module.exports         = LevelUP
module.exports.errors  = require('level-errors')
module.exports.destroy = deprecate(
    utilStatic('destroy')
  , 'levelup.destroy() is deprecated. Use leveldown.destroy() instead'
)
module.exports.repair  = deprecate(
    utilStatic('repair')
  , 'levelup.repair() is deprecated. Use leveldown.repair() instead'
)


}).call(this,require('_process'))
},{"./batch":105,"./util":107,"_process":136,"deferred-leveldown":49,"events":59,"level-codec":94,"level-errors":96,"level-iterator-stream":97,"prr":137,"util":308,"xtend":310}],107:[function(require,module,exports){
/* Copyright (c) 2012-2016 LevelUP contributors
 * See list at <https://github.com/level/levelup#contributing>
 * MIT License
 * <https://github.com/level/levelup/blob/master/LICENSE.md>
 */

var extend         = require('xtend')
  , LevelUPError   = require('level-errors').LevelUPError
  , format         = require('util').format
  , defaultOptions = {
        createIfMissing : true
      , errorIfExists   : false
      , keyEncoding     : 'utf8'
      , valueEncoding   : 'utf8'
      , compression     : true
    }

  , leveldown

function getOptions (options) {
  if (typeof options == 'string')
    options = { valueEncoding: options }
  if (typeof options != 'object')
    options = {}
  return options
}

function getLevelDOWN () {
  if (leveldown)
    return leveldown

  var requiredVersion  = require('../package.json').devDependencies.leveldown
    , leveldownVersion

  try {
    leveldownVersion = require('leveldown/package').version
  } catch (e) {
    throw requireError(e)
  }

  if (!require('semver').satisfies(leveldownVersion, requiredVersion)) {
    throw new LevelUPError(
        'Installed version of LevelDOWN ('
      + leveldownVersion
      + ') does not match required version ('
      + requiredVersion
      + ')'
    )
  }

  try {
    return leveldown = require('leveldown')
  } catch (e) {
    throw requireError(e)
  }
}

function requireError (e) {
  var template = 'Failed to require LevelDOWN (%s). Try `npm install leveldown` if it\'s missing'
  return new LevelUPError(format(template, e.message))
}

function dispatchError (db, error, callback) {
  typeof callback == 'function' ? callback(error) : db.emit('error', error)
}

function isDefined (v) {
  return typeof v !== 'undefined'
}

module.exports = {
    defaultOptions  : defaultOptions
  , getOptions      : getOptions
  , getLevelDOWN    : getLevelDOWN
  , dispatchError   : dispatchError
  , isDefined       : isDefined
}

},{"../package.json":108,"level-errors":96,"leveldown":45,"leveldown/package":45,"semver":45,"util":308,"xtend":310}],108:[function(require,module,exports){
module.exports={
  "_args": [
    [
      {
        "raw": "levelup@1.3.2",
        "scope": null,
        "escapedName": "levelup",
        "name": "levelup",
        "rawSpec": "1.3.2",
        "spec": "1.3.2",
        "type": "version"
      },
      "/Users/markargo/Work/LRF2/LRFBlocks/lrf-pxt/node_modules/pouchdb"
    ]
  ],
  "_from": "levelup@1.3.2",
  "_id": "levelup@1.3.2",
  "_inCache": true,
  "_location": "/levelup",
  "_nodeVersion": "6.1.0",
  "_npmOperationalInternal": {
    "host": "packages-16-east.internal.npmjs.com",
    "tmp": "tmp/levelup-1.3.2.tgz_1463496525467_0.4644940535072237"
  },
  "_npmUser": {
    "name": "ralphtheninja",
    "email": "ralphtheninja@riseup.net"
  },
  "_npmVersion": "3.8.6",
  "_phantomChildren": {},
  "_requested": {
    "raw": "levelup@1.3.2",
    "scope": null,
    "escapedName": "levelup",
    "name": "levelup",
    "rawSpec": "1.3.2",
    "spec": "1.3.2",
    "type": "version"
  },
  "_requiredBy": [
    "/pouchdb"
  ],
  "_resolved": "https://registry.npmjs.org/levelup/-/levelup-1.3.2.tgz",
  "_shasum": "b321d3071f0e75c2dfaf2f0fe8864e5b9a387bc9",
  "_shrinkwrap": null,
  "_spec": "levelup@1.3.2",
  "_where": "/Users/markargo/Work/LRF2/LRFBlocks/lrf-pxt/node_modules/pouchdb",
  "browser": {
    "leveldown": false,
    "leveldown/package": false,
    "semver": false
  },
  "bugs": {
    "url": "https://github.com/level/levelup/issues"
  },
  "contributors": [
    {
      "name": "Rod Vagg",
      "email": "r@va.gg",
      "url": "https://github.com/rvagg"
    },
    {
      "name": "John Chesley",
      "email": "john@chesl.es",
      "url": "https://github.com/chesles/"
    },
    {
      "name": "Jake Verbaten",
      "email": "raynos2@gmail.com",
      "url": "https://github.com/raynos"
    },
    {
      "name": "Dominic Tarr",
      "email": "dominic.tarr@gmail.com",
      "url": "https://github.com/dominictarr"
    },
    {
      "name": "Max Ogden",
      "email": "max@maxogden.com",
      "url": "https://github.com/maxogden"
    },
    {
      "name": "Lars-Magnus Skog",
      "email": "ralphtheninja@riseup.net",
      "url": "https://github.com/ralphtheninja"
    },
    {
      "name": "David Björklund",
      "email": "david.bjorklund@gmail.com",
      "url": "https://github.com/kesla"
    },
    {
      "name": "Julian Gruber",
      "email": "julian@juliangruber.com",
      "url": "https://github.com/juliangruber"
    },
    {
      "name": "Paolo Fragomeni",
      "email": "paolo@async.ly",
      "url": "https://github.com/0x00a"
    },
    {
      "name": "Anton Whalley",
      "email": "anton.whalley@nearform.com",
      "url": "https://github.com/No9"
    },
    {
      "name": "Matteo Collina",
      "email": "matteo.collina@gmail.com",
      "url": "https://github.com/mcollina"
    },
    {
      "name": "Pedro Teixeira",
      "email": "pedro.teixeira@gmail.com",
      "url": "https://github.com/pgte"
    },
    {
      "name": "James Halliday",
      "email": "mail@substack.net",
      "url": "https://github.com/substack"
    },
    {
      "name": "Jarrett Cruger",
      "email": "jcrugzz@gmail.com",
      "url": "https://github.com/jcrugzz"
    }
  ],
  "dependencies": {
    "deferred-leveldown": "~1.2.1",
    "level-codec": "~6.1.0",
    "level-errors": "~1.0.3",
    "level-iterator-stream": "~1.3.0",
    "prr": "~1.0.1",
    "semver": "~5.1.0",
    "xtend": "~4.0.0"
  },
  "description": "Fast & simple storage - a Node.js-style LevelDB wrapper",
  "devDependencies": {
    "async": "~1.5.0",
    "bustermove": "~1.0.0",
    "delayed": "~1.0.1",
    "faucet": "~0.0.1",
    "leveldown": "^1.1.0",
    "memdown": "~1.1.0",
    "msgpack-js": "~0.3.0",
    "referee": "~1.2.0",
    "rimraf": "~2.4.3",
    "slow-stream": "0.0.4",
    "tap": "~2.3.1",
    "tape": "~4.2.1"
  },
  "directories": {},
  "dist": {
    "shasum": "b321d3071f0e75c2dfaf2f0fe8864e5b9a387bc9",
    "tarball": "https://registry.npmjs.org/levelup/-/levelup-1.3.2.tgz"
  },
  "gitHead": "bcc242cfc4ec035f9228a5cd54903cb126659a00",
  "homepage": "https://github.com/level/levelup",
  "keywords": [
    "leveldb",
    "stream",
    "database",
    "db",
    "store",
    "storage",
    "json"
  ],
  "license": "MIT",
  "main": "lib/levelup.js",
  "maintainers": [
    {
      "name": "rvagg",
      "email": "rod@vagg.org"
    },
    {
      "name": "ralphtheninja",
      "email": "ralphtheninja@riseup.net"
    },
    {
      "name": "juliangruber",
      "email": "julian@juliangruber.com"
    }
  ],
  "name": "levelup",
  "optionalDependencies": {},
  "readme": "LevelUP\n=======\n\n<img alt=\"LevelDB Logo\" height=\"100\" src=\"http://leveldb.org/img/logo.svg\">\n\n**Fast & simple storage - a Node.js-style LevelDB wrapper**\n\n[![Build Status](https://secure.travis-ci.org/Level/levelup.svg?branch=master)](http://travis-ci.org/Level/levelup)\n[![dependencies](https://david-dm.org/Level/levelup.svg)](https://david-dm.org/level/levelup)\n\n[![NPM](https://nodei.co/npm/levelup.png?stars&downloads&downloadRank)](https://nodei.co/npm/levelup/) [![NPM](https://nodei.co/npm-dl/levelup.png?months=6&height=3)](https://nodei.co/npm/levelup/)\n\n\n  * <a href=\"#intro\">Introduction</a>\n  * <a href=\"#leveldown\">Relationship to LevelDOWN</a>\n  * <a href=\"#platforms\">Tested &amp; supported platforms</a>\n  * <a href=\"#basic\">Basic usage</a>\n  * <a href=\"#api\">API</a>\n  * <a href=\"#events\">Events</a>\n  * <a href=\"#json\">JSON data</a>\n  * <a href=\"#custom_encodings\">Custom encodings</a>\n  * <a href=\"#extending\">Extending LevelUP</a>\n  * <a href=\"#multiproc\">Multi-process access</a>\n  * <a href=\"#support\">Getting support</a>\n  * <a href=\"#contributing\">Contributing</a>\n  * <a href=\"#license\">Licence &amp; copyright</a>\n\n<a name=\"intro\"></a>\nIntroduction\n------------\n\n**[LevelDB](https://github.com/google/leveldb)** is a simple key/value data store built by Google, inspired by BigTable. It's used in Google Chrome and many other products. LevelDB supports arbitrary byte arrays as both keys and values, singular *get*, *put* and *delete* operations, *batched put and delete*, bi-directional iterators and simple compression using the very fast [Snappy](http://google.github.io/snappy/) algorithm.\n\n**LevelUP** aims to expose the features of LevelDB in a **Node.js-friendly way**. All standard `Buffer` encoding types are supported, as is a special JSON encoding. LevelDB's iterators are exposed as a Node.js-style **readable stream**.\n\nLevelDB stores entries **sorted lexicographically by keys**. This makes LevelUP's <a href=\"#createReadStream\"><code>ReadStream</code></a> interface a very powerful query mechanism.\n\n**LevelUP** is an **OPEN Open Source Project**, see the <a href=\"#contributing\">Contributing</a> section to find out what this means.\n\n<a name=\"leveldown\"></a>\nRelationship to LevelDOWN\n-------------------------\n\nLevelUP is designed to be backed by **[LevelDOWN](https://github.com/level/leveldown/)** which provides a pure C++ binding to LevelDB and can be used as a stand-alone package if required.\n\n**As of version 0.9, LevelUP no longer requires LevelDOWN as a dependency so you must `npm install leveldown` when you install LevelUP.**\n\nLevelDOWN is now optional because LevelUP can be used with alternative backends, such as **[level.js](https://github.com/maxogden/level.js)** in the browser or [MemDOWN](https://github.com/level/memdown) for a pure in-memory store.\n\nLevelUP will look for LevelDOWN and throw an error if it can't find it in its Node `require()` path. It will also tell you if the installed version of LevelDOWN is incompatible.\n\n**The [level](https://github.com/level/level) package is available as an alternative installation mechanism.** Install it instead to automatically get both LevelUP & LevelDOWN. It exposes LevelUP on its export (i.e. you can `var leveldb = require('level')`).\n\n\n<a name=\"platforms\"></a>\nTested & supported platforms\n----------------------------\n\n  * **Linux**: including ARM platforms such as Raspberry Pi *and Kindle!*\n  * **Mac OS**\n  * **Solaris**: including Joyent's SmartOS & Nodejitsu\n  * **Windows**: Node 0.10 and above only. See installation instructions for *node-gyp's* dependencies [here](https://github.com/TooTallNate/node-gyp#installation), you'll need these (free) components from Microsoft to compile and run any native Node add-on in Windows.\n\n<a name=\"basic\"></a>\nBasic usage\n-----------\n\nFirst you need to install LevelUP!\n\n```sh\n$ npm install levelup leveldown\n```\n\nOr\n\n```sh\n$ npm install level\n```\n\n*(this second option requires you to use LevelUP by calling `var levelup = require('level')`)*\n\n\nAll operations are asynchronous although they don't necessarily require a callback if you don't need to know when the operation was performed.\n\n```js\nvar levelup = require('levelup')\n\n// 1) Create our database, supply location and options.\n//    This will create or open the underlying LevelDB store.\nvar db = levelup('./mydb')\n\n// 2) put a key & value\ndb.put('name', 'LevelUP', function (err) {\n  if (err) return console.log('Ooops!', err) // some kind of I/O error\n\n  // 3) fetch by key\n  db.get('name', function (err, value) {\n    if (err) return console.log('Ooops!', err) // likely the key was not found\n\n    // ta da!\n    console.log('name=' + value)\n  })\n})\n```\n\n<a name=\"api\"></a>\n## API\n\n  * <a href=\"#ctor\"><code><b>levelup()</b></code></a>\n  * <a href=\"#open\"><code>db.<b>open()</b></code></a>\n  * <a href=\"#close\"><code>db.<b>close()</b></code></a>\n  * <a href=\"#put\"><code>db.<b>put()</b></code></a>\n  * <a href=\"#get\"><code>db.<b>get()</b></code></a>\n  * <a href=\"#del\"><code>db.<b>del()</b></code></a>\n  * <a href=\"#batch\"><code>db.<b>batch()</b></code> *(array form)*</a>\n  * <a href=\"#batch_chained\"><code>db.<b>batch()</b></code> *(chained form)*</a>\n  * <a href=\"#isOpen\"><code>db.<b>isOpen()</b></code></a>\n  * <a href=\"#isClosed\"><code>db.<b>isClosed()</b></code></a>\n  * <a href=\"#createReadStream\"><code>db.<b>createReadStream()</b></code></a>\n  * <a href=\"#createKeyStream\"><code>db.<b>createKeyStream()</b></code></a>\n  * <a href=\"#createValueStream\"><code>db.<b>createValueStream()</b></code></a>\n\n### Special operations exposed by LevelDOWN\n\n  * <a href=\"#approximateSize\"><code>db.db.<b>approximateSize()</b></code></a>\n  * <a href=\"#getProperty\"><code>db.db.<b>getProperty()</b></code></a>\n  * <a href=\"#destroy\"><code><b>leveldown.destroy()</b></code></a>\n  * <a href=\"#repair\"><code><b>leveldown.repair()</b></code></a>\n\n### Special Notes\n  * <a href=\"#writeStreams\">What happened to <code><b>db.createWriteStream()</b></code></a>\n\n\n--------------------------------------------------------\n<a name=\"ctor\"></a>\n### levelup(location[, options[, callback]])\n### levelup(options[, callback ])\n### levelup(db[, callback ])\n<code>levelup()</code> is the main entry point for creating a new LevelUP instance and opening the underlying store with LevelDB.\n\nThis function returns a new instance of LevelUP and will also initiate an <a href=\"#open\"><code>open()</code></a> operation. Opening the database is an asynchronous operation which will trigger your callback if you provide one. The callback should take the form: `function (err, db) {}` where the `db` is the LevelUP instance. If you don't provide a callback, any read & write operations are simply queued internally until the database is fully opened.\n\nThis leads to two alternative ways of managing a new LevelUP instance:\n\n```js\nlevelup(location, options, function (err, db) {\n  if (err) throw err\n  db.get('foo', function (err, value) {\n    if (err) return console.log('foo does not exist')\n    console.log('got foo =', value)\n  })\n})\n\n// vs the equivalent:\n\nvar db = levelup(location, options) // will throw if an error occurs\ndb.get('foo', function (err, value) {\n  if (err) return console.log('foo does not exist')\n  console.log('got foo =', value)\n})\n```\n\nThe `location` argument is available as a read-only property on the returned LevelUP instance.\n\nThe `levelup(options, callback)` form (with optional `callback`) is only available where you provide a valid `'db'` property on the options object (see below). Only for back-ends that don't require a `location` argument, such as [MemDOWN](https://github.com/level/memdown).\n\nFor example:\n\n```js\nvar levelup = require('levelup')\nvar memdown = require('memdown')\nvar db = levelup({ db: memdown })\n```\n\nThe `levelup(db, callback)` form (with optional `callback`) is only available where `db` is a factory function, as would be provided as a `'db'` property on an `options` object (see below). Only for back-ends that don't require a `location` argument, such as [MemDOWN](https://github.com/level/memdown).\n\nFor example:\n\n```js\nvar levelup = require('levelup')\nvar memdown = require('memdown')\nvar db = levelup(memdown)\n```\n\n#### `options`\n\n`levelup()` takes an optional options object as its second argument; the following properties are accepted:\n\n* `'createIfMissing'` *(boolean, default: `true`)*: If `true`, will initialise an empty database at the specified location if one doesn't already exist. If `false` and a database doesn't exist you will receive an error in your `open()` callback and your database won't open.\n\n* `'errorIfExists'` *(boolean, default: `false`)*: If `true`, you will receive an error in your `open()` callback if the database exists at the specified location.\n\n* `'compression'` *(boolean, default: `true`)*: If `true`, all *compressible* data will be run through the Snappy compression algorithm before being stored. Snappy is very fast and shouldn't gain much speed by disabling so leave this on unless you have good reason to turn it off.\n\n* `'cacheSize'` *(number, default: `8 * 1024 * 1024`)*: The size (in bytes) of the in-memory [LRU](http://en.wikipedia.org/wiki/Cache_algorithms#Least_Recently_Used) cache with frequently used uncompressed block contents.\n\n* `'keyEncoding'` and `'valueEncoding'` *(string, default: `'utf8'`)*: The encoding of the keys and values passed through Node.js' `Buffer` implementation (see [Buffer#toString()](http://nodejs.org/docs/latest/api/buffer.html#buffer_buf_tostring_encoding_start_end)).\n  <p><code>'utf8'</code> is the default encoding for both keys and values so you can simply pass in strings and expect strings from your <code>get()</code> operations. You can also pass <code>Buffer</code> objects as keys and/or values and conversion will be performed.</p>\n  <p>Supported encodings are: hex, utf8, ascii, binary, base64, ucs2, utf16le.</p>\n  <p><code>'json'</code> encoding is also supported, see below.</p>\n\n* `'db'` *(object, default: LevelDOWN)*: LevelUP is backed by [LevelDOWN](https://github.com/level/leveldown/) to provide an interface to LevelDB. You can completely replace the use of LevelDOWN by providing a \"factory\" function that will return a LevelDOWN API compatible object given a `location` argument. For further information, see [MemDOWN](https://github.com/level/memdown), a fully LevelDOWN API compatible replacement that uses a memory store rather than LevelDB. Also see [Abstract LevelDOWN](http://github.com/level/abstract-leveldown), a partial implementation of the LevelDOWN API that can be used as a base prototype for a LevelDOWN substitute.\n\nAdditionally, each of the main interface methods accept an optional options object that can be used to override `'keyEncoding'` and `'valueEncoding'`.\n\n--------------------------------------------------------\n<a name=\"open\"></a>\n### db.open([callback])\n<code>open()</code> opens the underlying LevelDB store. In general **you should never need to call this method directly** as it's automatically called by <a href=\"#ctor\"><code>levelup()</code></a>.\n\nHowever, it is possible to *reopen* a database after it has been closed with <a href=\"#close\"><code>close()</code></a>, although this is not generally advised.\n\n--------------------------------------------------------\n<a name=\"close\"></a>\n### db.close([callback])\n<code>close()</code> closes the underlying LevelDB store. The callback will receive any error encountered during closing as the first argument.\n\nYou should always clean up your LevelUP instance by calling `close()` when you no longer need it to free up resources. A LevelDB store cannot be opened by multiple instances of LevelDB/LevelUP simultaneously.\n\n--------------------------------------------------------\n<a name=\"put\"></a>\n### db.put(key, value[, options][, callback])\n<code>put()</code> is the primary method for inserting data into the store. Both the `key` and `value` can be arbitrary data objects.\n\nThe callback argument is optional but if you don't provide one and an error occurs then expect the error to be thrown.\n\n#### `options`\n\nEncoding of the `key` and `value` objects will adhere to `'keyEncoding'` and `'valueEncoding'` options provided to <a href=\"#ctor\"><code>levelup()</code></a>, although you can provide alternative encoding settings in the options for `put()` (it's recommended that you stay consistent in your encoding of keys and values in a single store).\n\nIf you provide a `'sync'` value of `true` in your `options` object, LevelDB will perform a synchronous write of the data; although the operation will be asynchronous as far as Node is concerned. Normally, LevelDB passes the data to the operating system for writing and returns immediately, however a synchronous write will use `fsync()` or equivalent so your callback won't be triggered until the data is actually on disk. Synchronous filesystem writes are **significantly** slower than asynchronous writes but if you want to be absolutely sure that the data is flushed then you can use `'sync': true`.\n\n--------------------------------------------------------\n<a name=\"get\"></a>\n### db.get(key[, options][, callback])\n<code>get()</code> is the primary method for fetching data from the store. The `key` can be an arbitrary data object. If it doesn't exist in the store then the callback will receive an error as its first argument. A not-found err object will be of type `'NotFoundError'` so you can `err.type == 'NotFoundError'` or you can perform a truthy test on the property `err.notFound`.\n\n```js\ndb.get('foo', function (err, value) {\n  if (err) {\n    if (err.notFound) {\n      // handle a 'NotFoundError' here\n      return\n    }\n    // I/O or other error, pass it up the callback chain\n    return callback(err)\n  }\n\n  // .. handle `value` here\n})\n```\n\n#### `options`\n\nEncoding of the `key` and `value` objects is the same as in <a href=\"#put\"><code>put</code></a>. \n\nLevelDB will by default fill the in-memory LRU Cache with data from a call to get. Disabling this is done by setting `fillCache` to `false`.\n\n--------------------------------------------------------\n<a name=\"del\"></a>\n### db.del(key[, options][, callback])\n<code>del()</code> is the primary method for removing data from the store.\n```js\ndb.del('foo', function (err) {\n  if (err)\n    // handle I/O or other error\n});\n```\n\n#### `options`\n\nEncoding of the `key` object will adhere to the `'keyEncoding'` option provided to <a href=\"#ctor\"><code>levelup()</code></a>, although you can provide alternative encoding settings in the options for `del()` (it's recommended that you stay consistent in your encoding of keys and values in a single store).\n\nA `'sync'` option can also be passed, see <a href=\"#put\"><code>put()</code></a> for details on how this works.\n\n--------------------------------------------------------\n<a name=\"batch\"></a>\n### db.batch(array[, options][, callback]) *(array form)*\n<code>batch()</code> can be used for very fast bulk-write operations (both *put* and *delete*). The `array` argument should contain a list of operations to be executed sequentially, although as a whole they are performed as an atomic operation inside LevelDB.\n\nEach operation is contained in an object having the following properties: `type`, `key`, `value`, where the *type* is either `'put'` or `'del'`. In the case of `'del'` the `'value'` property is ignored. Any entries with a `'key'` of `null` or `undefined` will cause an error to be returned on the `callback` and any `'type': 'put'` entry with a `'value'` of `null` or `undefined` will return an error.\n\nIf `key` and `value` are defined but `type` is not, it will default to `'put'`.\n\n```js\nvar ops = [\n    { type: 'del', key: 'father' }\n  , { type: 'put', key: 'name', value: 'Yuri Irsenovich Kim' }\n  , { type: 'put', key: 'dob', value: '16 February 1941' }\n  , { type: 'put', key: 'spouse', value: 'Kim Young-sook' }\n  , { type: 'put', key: 'occupation', value: 'Clown' }\n]\n\ndb.batch(ops, function (err) {\n  if (err) return console.log('Ooops!', err)\n  console.log('Great success dear leader!')\n})\n```\n\n#### `options`\n\nSee <a href=\"#put\"><code>put()</code></a> for a discussion on the `options` object. You can overwrite default `'keyEncoding'` and `'valueEncoding'` and also specify the use of `sync` filesystem operations.\n\nIn addition to encoding options for the whole batch you can also overwrite the encoding per operation, like:\n\n```js\nvar ops = [{\n    type          : 'put'\n  , key           : new Buffer([1, 2, 3])\n  , value         : { some: 'json' }\n  , keyEncoding   : 'binary'\n  , valueEncoding : 'json'\n}]\n```\n\n--------------------------------------------------------\n<a name=\"batch_chained\"></a>\n### db.batch() *(chained form)*\n<code>batch()</code>, when called with no arguments will return a `Batch` object which can be used to build, and eventually commit, an atomic LevelDB batch operation. Depending on how it's used, it is possible to obtain greater performance when using the chained form of `batch()` over the array form.\n\n```js\ndb.batch()\n  .del('father')\n  .put('name', 'Yuri Irsenovich Kim')\n  .put('dob', '16 February 1941')\n  .put('spouse', 'Kim Young-sook')\n  .put('occupation', 'Clown')\n  .write(function () { console.log('Done!') })\n```\n\n<b><code>batch.put(key, value[, options])</code></b>\n\nQueue a *put* operation on the current batch, not committed until a `write()` is called on the batch.\n\nThe optional `options` argument can be used to override the default `'keyEncoding'` and/or `'valueEncoding'`.\n\nThis method may `throw` a `WriteError` if there is a problem with your put (such as the `value` being `null` or `undefined`).\n\n<b><code>batch.del(key[, options])</code></b>\n\nQueue a *del* operation on the current batch, not committed until a `write()` is called on the batch.\n\nThe optional `options` argument can be used to override the default `'keyEncoding'`.\n\nThis method may `throw` a `WriteError` if there is a problem with your delete.\n\n<b><code>batch.clear()</code></b>\n\nClear all queued operations on the current batch, any previous operations will be discarded.\n\n<b><code>batch.length</code></b>\n\nThe number of queued operations on the current batch.\n\n<b><code>batch.write([callback])</code></b>\n\nCommit the queued operations for this batch. All operations not *cleared* will be written to the database atomically, that is, they will either all succeed or fail with no partial commits. The optional `callback` will be called when the operation has completed with an *error* argument if an error has occurred; if no `callback` is supplied and an error occurs then this method will `throw` a `WriteError`.\n\n\n--------------------------------------------------------\n<a name=\"isOpen\"></a>\n### db.isOpen()\n\nA LevelUP object can be in one of the following states:\n\n  * *\"new\"*     - newly created, not opened or closed\n  * *\"opening\"* - waiting for the database to be opened\n  * *\"open\"*    - successfully opened the database, available for use\n  * *\"closing\"* - waiting for the database to be closed\n  * *\"closed\"*  - database has been successfully closed, should not be used\n\n`isOpen()` will return `true` only when the state is \"open\".\n\n--------------------------------------------------------\n<a name=\"isClosed\"></a>\n### db.isClosed()\n\n*See <a href=\"#put\"><code>isOpen()</code></a>*\n\n`isClosed()` will return `true` only when the state is \"closing\" *or* \"closed\", it can be useful for determining if read and write operations are permissible.\n\n--------------------------------------------------------\n<a name=\"createReadStream\"></a>\n### db.createReadStream([options])\n\nYou can obtain a **ReadStream** of the full database by calling the `createReadStream()` method. The resulting stream is a complete Node.js-style [Readable Stream](http://nodejs.org/docs/latest/api/stream.html#stream_readable_stream) where `'data'` events emit objects with `'key'` and `'value'` pairs. You can also use the `gt`, `lt` and `limit` options to control the range of keys that are streamed.\n\n```js\ndb.createReadStream()\n  .on('data', function (data) {\n    console.log(data.key, '=', data.value)\n  })\n  .on('error', function (err) {\n    console.log('Oh my!', err)\n  })\n  .on('close', function () {\n    console.log('Stream closed')\n  })\n  .on('end', function () {\n    console.log('Stream closed')\n  })\n```\n\nThe standard `pause()`, `resume()` and `destroy()` methods are implemented on the ReadStream, as is `pipe()` (see below). `'data'`, '`error'`, `'end'` and `'close'` events are emitted.\n\nAdditionally, you can supply an options object as the first parameter to `createReadStream()` with the following options:\n\n* `'gt'` (greater than), `'gte'` (greater than or equal) define the lower bound of the range to be streamed. Only records where the key is greater than (or equal to) this option will be included in the range. When `reverse=true` the order will be reversed, but the records streamed will be the same.\n\n* `'lt'` (less than), `'lte'` (less than or equal) define the higher bound of the range to be streamed. Only key/value pairs where the key is less than (or equal to) this option will be included in the range. When `reverse=true` the order will be reversed, but the records streamed will be the same.\n\n* `'start', 'end'` legacy ranges - instead use `'gte', 'lte'`\n\n* `'reverse'` *(boolean, default: `false`)*: a boolean, set true and the stream output will be reversed. Beware that due to the way LevelDB works, a reverse seek will be slower than a forward seek.\n\n* `'keys'` *(boolean, default: `true`)*: whether the `'data'` event should contain keys. If set to `true` and `'values'` set to `false` then `'data'` events will simply be keys, rather than objects with a `'key'` property. Used internally by the `createKeyStream()` method.\n\n* `'values'` *(boolean, default: `true`)*: whether the `'data'` event should contain values. If set to `true` and `'keys'` set to `false` then `'data'` events will simply be values, rather than objects with a `'value'` property. Used internally by the `createValueStream()` method.\n\n* `'limit'` *(number, default: `-1`)*: limit the number of results collected by this stream. This number represents a *maximum* number of results and may not be reached if you get to the end of the data first. A value of `-1` means there is no limit. When `reverse=true` the highest keys will be returned instead of the lowest keys.\n\n* `'fillCache'` *(boolean, default: `false`)*: whether LevelDB's LRU-cache should be filled with data read.\n\n* `'keyEncoding'` / `'valueEncoding'` *(string)*: the encoding applied to each read piece of data.\n\n--------------------------------------------------------\n<a name=\"createKeyStream\"></a>\n### db.createKeyStream([options])\n\nA **KeyStream** is a **ReadStream** where the `'data'` events are simply the keys from the database so it can be used like a traditional stream rather than an object stream.\n\nYou can obtain a KeyStream either by calling the `createKeyStream()` method on a LevelUP object or by passing an options object to `createReadStream()` with `keys` set to `true` and `values` set to `false`.\n\n```js\ndb.createKeyStream()\n  .on('data', function (data) {\n    console.log('key=', data)\n  })\n\n// same as:\ndb.createReadStream({ keys: true, values: false })\n  .on('data', function (data) {\n    console.log('key=', data)\n  })\n```\n\n--------------------------------------------------------\n<a name=\"createValueStream\"></a>\n### db.createValueStream([options])\n\nA **ValueStream** is a **ReadStream** where the `'data'` events are simply the values from the database so it can be used like a traditional stream rather than an object stream.\n\nYou can obtain a ValueStream either by calling the `createValueStream()` method on a LevelUP object or by passing an options object to `createReadStream()` with `values` set to `true` and `keys` set to `false`.\n\n```js\ndb.createValueStream()\n  .on('data', function (data) {\n    console.log('value=', data)\n  })\n\n// same as:\ndb.createReadStream({ keys: false, values: true })\n  .on('data', function (data) {\n    console.log('value=', data)\n  })\n```\n\n--------------------------------------------------------\n<a name=\"writeStreams\"></a>\n#### What happened to `db.createWriteStream`?\n\n`db.createWriteStream()` has been removed in order to provide a smaller and more maintainable core. It primarily existed to create symmetry with `db.createReadStream()` but through much [discussion](https://github.com/level/levelup/issues/199), removing it was the best cause of action.\n\nThe main driver for this was performance. While `db.createReadStream()` performs well under most use cases, `db.createWriteStream()` was highly dependent on the application keys and values. Thus we can't provide a standard implementation and encourage more `write-stream` implementations to be created to solve the broad spectrum of use cases.\n\nCheck out the implementations that the community has already produced [here](https://github.com/level/levelup/wiki/Modules#write-streams).\n\n--------------------------------------------------------\n<a name='approximateSize'></a>\n### db.db.approximateSize(start, end, callback)\n<code>approximateSize()</code> can used to get the approximate number of bytes of file system space used by the range `[start..end)`. The result may not include recently written data.\n\n```js\nvar db = require('level')('./huge.db')\n\ndb.db.approximateSize('a', 'c', function (err, size) {\n  if (err) return console.error('Ooops!', err)\n  console.log('Approximate size of range is %d', size)\n})\n```\n\n**Note:** `approximateSize()` is available via [LevelDOWN](https://github.com/level/leveldown/), which by default is accessible as the `db` property of your LevelUP instance. This is a specific LevelDB operation and is not likely to be available where you replace LevelDOWN with an alternative back-end via the `'db'` option.\n\n\n--------------------------------------------------------\n<a name='getProperty'></a>\n### db.db.getProperty(property)\n<code>getProperty</code> can be used to get internal details from LevelDB. When issued with a valid property string, a readable string will be returned (this method is synchronous).\n\nCurrently, the only valid properties are:\n\n* <b><code>'leveldb.num-files-at-levelN'</code></b>: returns the number of files at level *N*, where N is an integer representing a valid level (e.g. \"0\").\n\n* <b><code>'leveldb.stats'</code></b>: returns a multi-line string describing statistics about LevelDB's internal operation.\n\n* <b><code>'leveldb.sstables'</code></b>: returns a multi-line string describing all of the *sstables* that make up contents of the current database.\n\n\n```js\nvar db = require('level')('./huge.db')\nconsole.log(db.db.getProperty('leveldb.num-files-at-level3'))\n// → '243'\n```\n\n**Note:** `getProperty()` is available via [LevelDOWN](https://github.com/level/leveldown/), which by default is accessible as the `db` property of your LevelUP instance. This is a specific LevelDB operation and is not likely to be available where you replace LevelDOWN with an alternative back-end via the `'db'` option.\n\n\n--------------------------------------------------------\n<a name=\"destroy\"></a>\n### leveldown.destroy(location, callback)\n<code>destroy()</code> is used to completely remove an existing LevelDB database directory. You can use this function in place of a full directory *rm* if you want to be sure to only remove LevelDB-related files. If the directory only contains LevelDB files, the directory itself will be removed as well. If there are additional, non-LevelDB files in the directory, those files, and the directory, will be left alone.\n\nThe callback will be called when the destroy operation is complete, with a possible `error` argument.\n\n**Note:** `destroy()` is available via [LevelDOWN](https://github.com/level/leveldown/) which you will have to install seperately, e.g.:\n\n```js\nrequire('leveldown').destroy('./huge.db', function (err) { console.log('done!') })\n```\n\n--------------------------------------------------------\n<a name=\"repair\"></a>\n### leveldown.repair(location, callback)\n<code>repair()</code> can be used to attempt a restoration of a damaged LevelDB store. From the LevelDB documentation:\n\n> If a DB cannot be opened, you may attempt to call this method to resurrect as much of the contents of the database as possible. Some data may be lost, so be careful when calling this function on a database that contains important information.\n\nYou will find information on the *repair* operation in the *LOG* file inside the store directory.\n\nA `repair()` can also be used to perform a compaction of the LevelDB log into table files.\n\nThe callback will be called when the repair operation is complete, with a possible `error` argument.\n\n**Note:** `repair()` is available via [LevelDOWN](https://github.com/level/leveldown/) which you will have to install seperately, e.g.:\n\n```js\nrequire('leveldown').repair('./huge.db', function (err) { console.log('done!') })\n```\n\n--------------------------------------------------------\n\n<a name=\"events\"></a>\nEvents\n------\n\nLevelUP emits events when the callbacks to the corresponding methods are called.\n\n* `db.emit('put', key, value)` emitted when a new value is `'put'`\n* `db.emit('del', key)` emitted when a value is deleted\n* `db.emit('batch', ary)` emitted when a batch operation has executed\n* `db.emit('ready')` emitted when the database has opened (`'open'` is synonym)\n* `db.emit('closed')` emitted when the database has closed\n* `db.emit('opening')` emitted when the database is opening\n* `db.emit('closing')` emitted when the database is closing\n\nIf you do not pass a callback to an async function, and there is an error, LevelUP will `emit('error', err)` instead.\n\n<a name=\"json\"></a>\nJSON data\n---------\n\nYou specify `'json'` encoding for both keys and/or values, you can then supply JavaScript objects to LevelUP and receive them from all fetch operations, including ReadStreams. LevelUP will automatically *stringify* your objects and store them as *utf8* and parse the strings back into objects before passing them back to you.\n\n<a name=\"custom_encodings\"></a>\nCustom encodings\n----------------\n\nA custom encoding may be provided by passing in an object as an value for `keyEncoding` or `valueEncoding` (wherever accepted), it must have the following properties:\n\n```js\n{\n    encode : function (val) { ... }\n  , decode : function (val) { ... }\n  , buffer : boolean // encode returns a buffer and decode accepts a buffer\n  , type   : String  // name of this encoding type.\n}\n```\n\n<a name=\"extending\"></a>\nExtending LevelUP\n-----------------\n\nA list of <a href=\"https://github.com/level/levelup/wiki/Modules\"><b>Node.js LevelDB modules and projects</b></a> can be found in the wiki.\n\nWhen attempting to extend the functionality of LevelUP, it is recommended that you consider using [level-hooks](https://github.com/dominictarr/level-hooks) and/or [level-sublevel](https://github.com/dominictarr/level-sublevel). **level-sublevel** is particularly helpful for keeping additional, extension-specific, data in a LevelDB store. It allows you to partition a LevelUP instance into multiple sub-instances that each correspond to discrete namespaced key ranges.\n\n<a name=\"multiproc\"></a>\nMulti-process access\n--------------------\n\nLevelDB is thread-safe but is **not** suitable for accessing with multiple processes. You should only ever have a LevelDB database open from a single Node.js process. Node.js clusters are made up of multiple processes so a LevelUP instance cannot be shared between them either.\n\nSee the <a href=\"https://github.com/level/levelup/wiki/Modules\"><b>wiki</b></a> for some LevelUP extensions, including [multilevel](https://github.com/juliangruber/multilevel), that may help if you require a single data store to be shared across processes.\n\n<a name=\"support\"></a>\nGetting support\n---------------\n\nThere are multiple ways you can find help in using LevelDB in Node.js:\n\n * **IRC:** you'll find an active group of LevelUP users in the **##leveldb** channel on Freenode, including most of the contributors to this project.\n * **Mailing list:** there is an active [Node.js LevelDB](https://groups.google.com/forum/#!forum/node-levelup) Google Group.\n * **GitHub:** you're welcome to open an issue here on this GitHub repository if you have a question.\n\n<a name=\"contributing\"></a>\nContributing\n------------\n\nLevelUP is an **OPEN Open Source Project**. This means that:\n\n> Individuals making significant and valuable contributions are given commit-access to the project to contribute as they see fit. This project is more like an open wiki than a standard guarded open source project.\n\nSee the [contribution guide](https://github.com/Level/community/blob/master/CONTRIBUTING.md) for more details.\n\n### Windows\n\nA large portion of the Windows support comes from code by [Krzysztof Kowalczyk](http://blog.kowalczyk.info/) [@kjk](https://twitter.com/kjk), see his Windows LevelDB port [here](http://code.google.com/r/kkowalczyk-leveldb/). If you're using LevelUP on Windows, you should give him your thanks!\n\n\n<a name=\"license\"></a>\nLicense &amp; copyright\n-------------------\n\nCopyright &copy; 2012-2016 **LevelUP** [contributors](https://github.com/level/community#contributors).\n\n**LevelUP** is licensed under the MIT license. All rights not explicitly granted in the MIT license are reserved. See the included `LICENSE.md` file for more details.\n\n=======\n*LevelUP builds on the excellent work of the LevelDB and Snappy teams from Google and additional contributors. LevelDB and Snappy are both issued under the [New BSD Licence](http://opensource.org/licenses/BSD-3-Clause).*\n",
  "readmeFilename": "README.md",
  "repository": {
    "type": "git",
    "url": "git+https://github.com/level/levelup.git"
  },
  "scripts": {
    "test": "tape test/*-test.js | faucet"
  },
  "version": "1.3.2"
}

},{}],109:[function(require,module,exports){
(function (Buffer){

exports.compare = function (a, b) {

  if(Buffer.isBuffer(a)) {
    var l = Math.min(a.length, b.length)
    for(var i = 0; i < l; i++) {
      var cmp = a[i] - b[i]
      if(cmp) return cmp
    }
    return a.length - b.length
  }

  return a < b ? -1 : a > b ? 1 : 0
}

function has(obj, key) {
  return Object.hasOwnProperty.call(obj, key)
}

// to be compatible with the current abstract-leveldown tests
// nullish or empty strings.
// I could use !!val but I want to permit numbers and booleans,
// if possible.

function isDef (val) {
  return val != null && val !== ''
}

var lowerBound = exports.lowerBound = function (range) {
  return (
      isDef(range.gt)                      ? range.gt
    : isDef(range.gte)                     ? range.gte
    : isDef(range.min)                     ? range.min
    : isDef(range.start) && !range.reverse ? range.start
    : isDef(range.end) && range.reverse    ? range.end
    :                                        undefined
  )
}

exports.lowerBoundInclusive = function (range) {
  return isDef(range.gt) ? false : true
}

exports.upperBoundInclusive =
  function (range) {
    return isDef(range.lt) ? false : true
  }

var lowerBoundExclusive = exports.lowerBoundExclusive =
  function (range) {
    return isDef(range.gt) ? true : false
  }

var upperBoundExclusive = exports.upperBoundExclusive =
  function (range) {
    return isDef(range.lt) ? true : false
  }

var upperBound = exports.upperBound = function (range) {
  return (
      isDef(range.lt)                     ? range.lt
    : isDef(range.lte)                    ? range.lte
    : isDef(range.max)                    ? range.max
    : isDef(range.start) && range.reverse ? range.start
    : isDef(range.end) && !range.reverse  ? range.end
    :                                       undefined
  )
}


exports.contains = function (range, key, compare) {
  compare = compare || exports.compare

  var lb = lowerBound(range)
  if(isDef(lb)) {
    var cmp = compare(key, lb)
    if(cmp < 0 || (cmp === 0 && lowerBoundExclusive(range)))
      return false
  }

  var ub = upperBound(range)
  if(isDef(ub)) {
    var cmp = compare(key, ub)
    if(cmp > 0 || (cmp === 0) && upperBoundExclusive(range))
      return false
  }

  return true
}

exports.filter = function (range, compare) {
  return function (key) {
    return exports.contains(range, key, compare)
  }
}

}).call(this,{"isBuffer":require("../is-buffer/index.js")})
},{"../is-buffer/index.js":91}],110:[function(require,module,exports){
(function (global){
/**
 * marked - a markdown parser
 * Copyright (c) 2011-2014, Christopher Jeffrey. (MIT Licensed)
 * https://github.com/markedjs/marked
 */

;(function(root) {
'use strict';

/**
 * Block-Level Grammar
 */

var block = {
  newline: /^\n+/,
  code: /^( {4}[^\n]+\n*)+/,
  fences: noop,
  hr: /^ {0,3}((?:- *){3,}|(?:_ *){3,}|(?:\* *){3,})(?:\n+|$)/,
  heading: /^ *(#{1,6}) *([^\n]+?) *#* *(?:\n+|$)/,
  nptable: noop,
  blockquote: /^( {0,3}> ?(paragraph|[^\n]*)(?:\n|$))+/,
  list: /^( *)(bull) [\s\S]+?(?:hr|def|\n{2,}(?! )(?!\1bull )\n*|\s*$)/,
  html: /^ *(?:comment *(?:\n|\s*$)|closed *(?:\n{2,}|\s*$)|closing *(?:\n{2,}|\s*$))/,
  def: /^ {0,3}\[(label)\]: *\n? *<?([^\s>]+)>?(?:(?: +\n? *| *\n *)(title))? *(?:\n+|$)/,
  table: noop,
  lheading: /^([^\n]+)\n *(=|-){2,} *(?:\n+|$)/,
  paragraph: /^([^\n]+(?:\n?(?!hr|heading|lheading| {0,3}>|tag)[^\n]+)+)/,
  text: /^[^\n]+/
};

block._label = /(?:\\[\[\]]|[^\[\]])+/;
block._title = /(?:"(?:\\"|[^"]|"[^"\n]*")*"|'\n?(?:[^'\n]+\n?)*'|\([^()]*\))/;
block.def = edit(block.def)
  .replace('label', block._label)
  .replace('title', block._title)
  .getRegex();

block.bullet = /(?:[*+-]|\d+\.)/;
block.item = /^( *)(bull) [^\n]*(?:\n(?!\1bull )[^\n]*)*/;
block.item = edit(block.item, 'gm')
  .replace(/bull/g, block.bullet)
  .getRegex();

block.list = edit(block.list)
  .replace(/bull/g, block.bullet)
  .replace('hr', '\\n+(?=\\1?(?:(?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$))')
  .replace('def', '\\n+(?=' + block.def.source + ')')
  .getRegex();

block._tag = '(?!(?:'
  + 'a|em|strong|small|s|cite|q|dfn|abbr|data|time|code'
  + '|var|samp|kbd|sub|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo'
  + '|span|br|wbr|ins|del|img)\\b)\\w+(?!:|[^\\w\\s@]*@)\\b';

block.html = edit(block.html)
  .replace('comment', /<!--[\s\S]*?-->/)
  .replace('closed', /<(tag)[\s\S]+?<\/\1>/)
  .replace('closing', /<tag(?:"[^"]*"|'[^']*'|\s[^'"\/>\s]*)*?\/?>/)
  .replace(/tag/g, block._tag)
  .getRegex();

block.paragraph = edit(block.paragraph)
  .replace('hr', block.hr)
  .replace('heading', block.heading)
  .replace('lheading', block.lheading)
  .replace('tag', '<' + block._tag)
  .getRegex();

block.blockquote = edit(block.blockquote)
  .replace('paragraph', block.paragraph)
  .getRegex();

/**
 * Normal Block Grammar
 */

block.normal = merge({}, block);

/**
 * GFM Block Grammar
 */

block.gfm = merge({}, block.normal, {
  fences: /^ *(`{3,}|~{3,})[ \.]*(\S+)? *\n([\s\S]*?)\n? *\1 *(?:\n+|$)/,
  paragraph: /^/,
  heading: /^ *(#{1,6}) +([^\n]+?) *#* *(?:\n+|$)/
});

block.gfm.paragraph = edit(block.paragraph)
  .replace('(?!', '(?!'
    + block.gfm.fences.source.replace('\\1', '\\2') + '|'
    + block.list.source.replace('\\1', '\\3') + '|')
  .getRegex();

/**
 * GFM + Tables Block Grammar
 */

block.tables = merge({}, block.gfm, {
  nptable: /^ *(\S.*\|.*)\n *([-:]+ *\|[-| :]*)\n((?:.*\|.*(?:\n|$))*)\n*/,
  table: /^ *\|(.+)\n *\|( *[-:]+[-| :]*)\n((?: *\|.*(?:\n|$))*)\n*/
});

/**
 * Block Lexer
 */

function Lexer(options) {
  this.tokens = [];
  this.tokens.links = {};
  this.options = options || marked.defaults;
  this.rules = block.normal;

  if (this.options.gfm) {
    if (this.options.tables) {
      this.rules = block.tables;
    } else {
      this.rules = block.gfm;
    }
  }
}

/**
 * Expose Block Rules
 */

Lexer.rules = block;

/**
 * Static Lex Method
 */

Lexer.lex = function(src, options) {
  var lexer = new Lexer(options);
  return lexer.lex(src);
};

/**
 * Preprocessing
 */

Lexer.prototype.lex = function(src) {
  src = src
    .replace(/\r\n|\r/g, '\n')
    .replace(/\t/g, '    ')
    .replace(/\u00a0/g, ' ')
    .replace(/\u2424/g, '\n');

  return this.token(src, true);
};

/**
 * Lexing
 */

Lexer.prototype.token = function(src, top) {
  src = src.replace(/^ +$/gm, '');
  var next,
      loose,
      cap,
      bull,
      b,
      item,
      space,
      i,
      tag,
      l,
      isordered;

  while (src) {
    // newline
    if (cap = this.rules.newline.exec(src)) {
      src = src.substring(cap[0].length);
      if (cap[0].length > 1) {
        this.tokens.push({
          type: 'space'
        });
      }
    }

    // code
    if (cap = this.rules.code.exec(src)) {
      src = src.substring(cap[0].length);
      cap = cap[0].replace(/^ {4}/gm, '');
      this.tokens.push({
        type: 'code',
        text: !this.options.pedantic
          ? cap.replace(/\n+$/, '')
          : cap
      });
      continue;
    }

    // fences (gfm)
    if (cap = this.rules.fences.exec(src)) {
      src = src.substring(cap[0].length);
      this.tokens.push({
        type: 'code',
        lang: cap[2],
        text: cap[3] || ''
      });
      continue;
    }

    // heading
    if (cap = this.rules.heading.exec(src)) {
      src = src.substring(cap[0].length);
      this.tokens.push({
        type: 'heading',
        depth: cap[1].length,
        text: cap[2]
      });
      continue;
    }

    // table no leading pipe (gfm)
    if (top && (cap = this.rules.nptable.exec(src))) {
      src = src.substring(cap[0].length);

      item = {
        type: 'table',
        header: cap[1].replace(/^ *| *\| *$/g, '').split(/ *\| */),
        align: cap[2].replace(/^ *|\| *$/g, '').split(/ *\| */),
        cells: cap[3].replace(/\n$/, '').split('\n')
      };

      for (i = 0; i < item.align.length; i++) {
        if (/^ *-+: *$/.test(item.align[i])) {
          item.align[i] = 'right';
        } else if (/^ *:-+: *$/.test(item.align[i])) {
          item.align[i] = 'center';
        } else if (/^ *:-+ *$/.test(item.align[i])) {
          item.align[i] = 'left';
        } else {
          item.align[i] = null;
        }
      }

      for (i = 0; i < item.cells.length; i++) {
        item.cells[i] = item.cells[i].split(/ *\| */);
      }

      this.tokens.push(item);

      continue;
    }

    // hr
    if (cap = this.rules.hr.exec(src)) {
      src = src.substring(cap[0].length);
      this.tokens.push({
        type: 'hr'
      });
      continue;
    }

    // blockquote
    if (cap = this.rules.blockquote.exec(src)) {
      src = src.substring(cap[0].length);

      this.tokens.push({
        type: 'blockquote_start'
      });

      cap = cap[0].replace(/^ *> ?/gm, '');

      // Pass `top` to keep the current
      // "toplevel" state. This is exactly
      // how markdown.pl works.
      this.token(cap, top);

      this.tokens.push({
        type: 'blockquote_end'
      });

      continue;
    }

    // list
    if (cap = this.rules.list.exec(src)) {
      src = src.substring(cap[0].length);
      bull = cap[2];
      isordered = bull.length > 1;

      this.tokens.push({
        type: 'list_start',
        ordered: isordered,
        start: isordered ? +bull : ''
      });

      // Get each top-level item.
      cap = cap[0].match(this.rules.item);

      next = false;
      l = cap.length;
      i = 0;

      for (; i < l; i++) {
        item = cap[i];

        // Remove the list item's bullet
        // so it is seen as the next token.
        space = item.length;
        item = item.replace(/^ *([*+-]|\d+\.) +/, '');

        // Outdent whatever the
        // list item contains. Hacky.
        if (~item.indexOf('\n ')) {
          space -= item.length;
          item = !this.options.pedantic
            ? item.replace(new RegExp('^ {1,' + space + '}', 'gm'), '')
            : item.replace(/^ {1,4}/gm, '');
        }

        // Determine whether the next list item belongs here.
        // Backpedal if it does not belong in this list.
        if (this.options.smartLists && i !== l - 1) {
          b = block.bullet.exec(cap[i + 1])[0];
          if (bull !== b && !(bull.length > 1 && b.length > 1)) {
            src = cap.slice(i + 1).join('\n') + src;
            i = l - 1;
          }
        }

        // Determine whether item is loose or not.
        // Use: /(^|\n)(?! )[^\n]+\n\n(?!\s*$)/
        // for discount behavior.
        loose = next || /\n\n(?!\s*$)/.test(item);
        if (i !== l - 1) {
          next = item.charAt(item.length - 1) === '\n';
          if (!loose) loose = next;
        }

        this.tokens.push({
          type: loose
            ? 'loose_item_start'
            : 'list_item_start'
        });

        // Recurse.
        this.token(item, false);

        this.tokens.push({
          type: 'list_item_end'
        });
      }

      this.tokens.push({
        type: 'list_end'
      });

      continue;
    }

    // html
    if (cap = this.rules.html.exec(src)) {
      src = src.substring(cap[0].length);
      this.tokens.push({
        type: this.options.sanitize
          ? 'paragraph'
          : 'html',
        pre: !this.options.sanitizer
          && (cap[1] === 'pre' || cap[1] === 'script' || cap[1] === 'style'),
        text: cap[0]
      });
      continue;
    }

    // def
    if (top && (cap = this.rules.def.exec(src))) {
      src = src.substring(cap[0].length);
      if (cap[3]) cap[3] = cap[3].substring(1, cap[3].length - 1);
      tag = cap[1].toLowerCase();
      if (!this.tokens.links[tag]) {
        this.tokens.links[tag] = {
          href: cap[2],
          title: cap[3]
        };
      }
      continue;
    }

    // table (gfm)
    if (top && (cap = this.rules.table.exec(src))) {
      src = src.substring(cap[0].length);

      item = {
        type: 'table',
        header: cap[1].replace(/^ *| *\| *$/g, '').split(/ *\| */),
        align: cap[2].replace(/^ *|\| *$/g, '').split(/ *\| */),
        cells: cap[3].replace(/(?: *\| *)?\n$/, '').split('\n')
      };

      for (i = 0; i < item.align.length; i++) {
        if (/^ *-+: *$/.test(item.align[i])) {
          item.align[i] = 'right';
        } else if (/^ *:-+: *$/.test(item.align[i])) {
          item.align[i] = 'center';
        } else if (/^ *:-+ *$/.test(item.align[i])) {
          item.align[i] = 'left';
        } else {
          item.align[i] = null;
        }
      }

      for (i = 0; i < item.cells.length; i++) {
        item.cells[i] = item.cells[i]
          .replace(/^ *\| *| *\| *$/g, '')
          .split(/ *\| */);
      }

      this.tokens.push(item);

      continue;
    }

    // lheading
    if (cap = this.rules.lheading.exec(src)) {
      src = src.substring(cap[0].length);
      this.tokens.push({
        type: 'heading',
        depth: cap[2] === '=' ? 1 : 2,
        text: cap[1]
      });
      continue;
    }

    // top-level paragraph
    if (top && (cap = this.rules.paragraph.exec(src))) {
      src = src.substring(cap[0].length);
      this.tokens.push({
        type: 'paragraph',
        text: cap[1].charAt(cap[1].length - 1) === '\n'
          ? cap[1].slice(0, -1)
          : cap[1]
      });
      continue;
    }

    // text
    if (cap = this.rules.text.exec(src)) {
      // Top-level should never reach here.
      src = src.substring(cap[0].length);
      this.tokens.push({
        type: 'text',
        text: cap[0]
      });
      continue;
    }

    if (src) {
      throw new Error('Infinite loop on byte: ' + src.charCodeAt(0));
    }
  }

  return this.tokens;
};

/**
 * Inline-Level Grammar
 */

var inline = {
  escape: /^\\([\\`*{}\[\]()#+\-.!_>])/,
  autolink: /^<(scheme:[^\s\x00-\x1f<>]*|email)>/,
  url: noop,
  tag: /^<!--[\s\S]*?-->|^<\/?[a-zA-Z0-9\-]+(?:"[^"]*"|'[^']*'|\s[^<'">\/\s]*)*?\/?>/,
  link: /^!?\[(inside)\]\(href\)/,
  reflink: /^!?\[(inside)\]\s*\[([^\]]*)\]/,
  nolink: /^!?\[((?:\[[^\[\]]*\]|\\[\[\]]|[^\[\]])*)\]/,
  strong: /^__([\s\S]+?)__(?!_)|^\*\*([\s\S]+?)\*\*(?!\*)/,
  em: /^_([^\s_](?:[^_]|__)+?[^\s_])_\b|^\*((?:\*\*|[^*])+?)\*(?!\*)/,
  code: /^(`+)\s*([\s\S]*?[^`]?)\s*\1(?!`)/,
  br: /^ {2,}\n(?!\s*$)/,
  del: noop,
  text: /^[\s\S]+?(?=[\\<!\[`*]|\b_| {2,}\n|$)/
};

inline._scheme = /[a-zA-Z][a-zA-Z0-9+.-]{1,31}/;
inline._email = /[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+(@)[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+(?![-_])/;

inline.autolink = edit(inline.autolink)
  .replace('scheme', inline._scheme)
  .replace('email', inline._email)
  .getRegex()

inline._inside = /(?:\[[^\[\]]*\]|\\[\[\]]|[^\[\]]|\](?=[^\[]*\]))*/;
inline._href = /\s*<?([\s\S]*?)>?(?:\s+['"]([\s\S]*?)['"])?\s*/;

inline.link = edit(inline.link)
  .replace('inside', inline._inside)
  .replace('href', inline._href)
  .getRegex();

inline.reflink = edit(inline.reflink)
  .replace('inside', inline._inside)
  .getRegex();

/**
 * Normal Inline Grammar
 */

inline.normal = merge({}, inline);

/**
 * Pedantic Inline Grammar
 */

inline.pedantic = merge({}, inline.normal, {
  strong: /^__(?=\S)([\s\S]*?\S)__(?!_)|^\*\*(?=\S)([\s\S]*?\S)\*\*(?!\*)/,
  em: /^_(?=\S)([\s\S]*?\S)_(?!_)|^\*(?=\S)([\s\S]*?\S)\*(?!\*)/
});

/**
 * GFM Inline Grammar
 */

inline.gfm = merge({}, inline.normal, {
  escape: edit(inline.escape).replace('])', '~|])').getRegex(),
  url: edit(/^((?:ftp|https?):\/\/|www\.)(?:[a-zA-Z0-9\-]+\.?)+[^\s<]*|^email/)
    .replace('email', inline._email)
    .getRegex(),
  _backpedal: /(?:[^?!.,:;*_~()&]+|\([^)]*\)|&(?![a-zA-Z0-9]+;$)|[?!.,:;*_~)]+(?!$))+/,
  del: /^~~(?=\S)([\s\S]*?\S)~~/,
  text: edit(inline.text)
    .replace(']|', '~]|')
    .replace('|', '|https?://|ftp://|www\\.|[a-zA-Z0-9.!#$%&\'*+/=?^_`{\\|}~-]+@|')
    .getRegex()
});

/**
 * GFM + Line Breaks Inline Grammar
 */

inline.breaks = merge({}, inline.gfm, {
  br: edit(inline.br).replace('{2,}', '*').getRegex(),
  text: edit(inline.gfm.text).replace('{2,}', '*').getRegex()
});

/**
 * Inline Lexer & Compiler
 */

function InlineLexer(links, options) {
  this.options = options || marked.defaults;
  this.links = links;
  this.rules = inline.normal;
  this.renderer = this.options.renderer || new Renderer();
  this.renderer.options = this.options;

  if (!this.links) {
    throw new Error('Tokens array requires a `links` property.');
  }

  if (this.options.gfm) {
    if (this.options.breaks) {
      this.rules = inline.breaks;
    } else {
      this.rules = inline.gfm;
    }
  } else if (this.options.pedantic) {
    this.rules = inline.pedantic;
  }
}

/**
 * Expose Inline Rules
 */

InlineLexer.rules = inline;

/**
 * Static Lexing/Compiling Method
 */

InlineLexer.output = function(src, links, options) {
  var inline = new InlineLexer(links, options);
  return inline.output(src);
};

/**
 * Lexing/Compiling
 */

InlineLexer.prototype.output = function(src) {
  var out = '',
      link,
      text,
      href,
      cap;

  while (src) {
    // escape
    if (cap = this.rules.escape.exec(src)) {
      src = src.substring(cap[0].length);
      out += cap[1];
      continue;
    }

    // autolink
    if (cap = this.rules.autolink.exec(src)) {
      src = src.substring(cap[0].length);
      if (cap[2] === '@') {
        text = escape(this.mangle(cap[1]));
        href = 'mailto:' + text;
      } else {
        text = escape(cap[1]);
        href = text;
      }
      out += this.renderer.link(href, null, text);
      continue;
    }

    // url (gfm)
    if (!this.inLink && (cap = this.rules.url.exec(src))) {
      cap[0] = this.rules._backpedal.exec(cap[0])[0];
      src = src.substring(cap[0].length);
      if (cap[2] === '@') {
        text = escape(cap[0]);
        href = 'mailto:' + text;
      } else {
        text = escape(cap[0]);
        if (cap[1] === 'www.') {
          href = 'http://' + text;
        } else {
          href = text;
        }
      }
      out += this.renderer.link(href, null, text);
      continue;
    }

    // tag
    if (cap = this.rules.tag.exec(src)) {
      if (!this.inLink && /^<a /i.test(cap[0])) {
        this.inLink = true;
      } else if (this.inLink && /^<\/a>/i.test(cap[0])) {
        this.inLink = false;
      }
      src = src.substring(cap[0].length);
      out += this.options.sanitize
        ? this.options.sanitizer
          ? this.options.sanitizer(cap[0])
          : escape(cap[0])
        : cap[0]
      continue;
    }

    // link
    if (cap = this.rules.link.exec(src)) {
      src = src.substring(cap[0].length);
      this.inLink = true;
      out += this.outputLink(cap, {
        href: cap[2],
        title: cap[3]
      });
      this.inLink = false;
      continue;
    }

    // reflink, nolink
    if ((cap = this.rules.reflink.exec(src))
        || (cap = this.rules.nolink.exec(src))) {
      src = src.substring(cap[0].length);
      link = (cap[2] || cap[1]).replace(/\s+/g, ' ');
      link = this.links[link.toLowerCase()];
      if (!link || !link.href) {
        out += cap[0].charAt(0);
        src = cap[0].substring(1) + src;
        continue;
      }
      this.inLink = true;
      out += this.outputLink(cap, link);
      this.inLink = false;
      continue;
    }

    // strong
    if (cap = this.rules.strong.exec(src)) {
      src = src.substring(cap[0].length);
      out += this.renderer.strong(this.output(cap[2] || cap[1]));
      continue;
    }

    // em
    if (cap = this.rules.em.exec(src)) {
      src = src.substring(cap[0].length);
      out += this.renderer.em(this.output(cap[2] || cap[1]));
      continue;
    }

    // code
    if (cap = this.rules.code.exec(src)) {
      src = src.substring(cap[0].length);
      out += this.renderer.codespan(escape(cap[2].trim(), true));
      continue;
    }

    // br
    if (cap = this.rules.br.exec(src)) {
      src = src.substring(cap[0].length);
      out += this.renderer.br();
      continue;
    }

    // del (gfm)
    if (cap = this.rules.del.exec(src)) {
      src = src.substring(cap[0].length);
      out += this.renderer.del(this.output(cap[1]));
      continue;
    }

    // text
    if (cap = this.rules.text.exec(src)) {
      src = src.substring(cap[0].length);
      out += this.renderer.text(escape(this.smartypants(cap[0])));
      continue;
    }

    if (src) {
      throw new Error('Infinite loop on byte: ' + src.charCodeAt(0));
    }
  }

  return out;
};

/**
 * Compile Link
 */

InlineLexer.prototype.outputLink = function(cap, link) {
  var href = escape(link.href),
      title = link.title ? escape(link.title) : null;

  return cap[0].charAt(0) !== '!'
    ? this.renderer.link(href, title, this.output(cap[1]))
    : this.renderer.image(href, title, escape(cap[1]));
};

/**
 * Smartypants Transformations
 */

InlineLexer.prototype.smartypants = function(text) {
  if (!this.options.smartypants) return text;
  return text
    // em-dashes
    .replace(/---/g, '\u2014')
    // en-dashes
    .replace(/--/g, '\u2013')
    // opening singles
    .replace(/(^|[-\u2014/(\[{"\s])'/g, '$1\u2018')
    // closing singles & apostrophes
    .replace(/'/g, '\u2019')
    // opening doubles
    .replace(/(^|[-\u2014/(\[{\u2018\s])"/g, '$1\u201c')
    // closing doubles
    .replace(/"/g, '\u201d')
    // ellipses
    .replace(/\.{3}/g, '\u2026');
};

/**
 * Mangle Links
 */

InlineLexer.prototype.mangle = function(text) {
  if (!this.options.mangle) return text;
  var out = '',
      l = text.length,
      i = 0,
      ch;

  for (; i < l; i++) {
    ch = text.charCodeAt(i);
    if (Math.random() > 0.5) {
      ch = 'x' + ch.toString(16);
    }
    out += '&#' + ch + ';';
  }

  return out;
};

/**
 * Renderer
 */

function Renderer(options) {
  this.options = options || {};
}

Renderer.prototype.code = function(code, lang, escaped) {
  if (this.options.highlight) {
    var out = this.options.highlight(code, lang);
    if (out != null && out !== code) {
      escaped = true;
      code = out;
    }
  }

  if (!lang) {
    return '<pre><code>'
      + (escaped ? code : escape(code, true))
      + '\n</code></pre>';
  }

  return '<pre><code class="'
    + this.options.langPrefix
    + escape(lang, true)
    + '">'
    + (escaped ? code : escape(code, true))
    + '\n</code></pre>\n';
};

Renderer.prototype.blockquote = function(quote) {
  return '<blockquote>\n' + quote + '</blockquote>\n';
};

Renderer.prototype.html = function(html) {
  return html;
};

Renderer.prototype.heading = function(text, level, raw) {
  return '<h'
    + level
    + ' id="'
    + this.options.headerPrefix
    + raw.toLowerCase().replace(/[^\w]+/g, '-')
    + '">'
    + text
    + '</h'
    + level
    + '>\n';
};

Renderer.prototype.hr = function() {
  return this.options.xhtml ? '<hr/>\n' : '<hr>\n';
};

Renderer.prototype.list = function(body, ordered, start) {
  var type = ordered ? 'ol' : 'ul',
      startatt = (ordered && start !== 1) ? (' start="' + start + '"') : '';
  return '<' + type + startatt + '>\n' + body + '</' + type + '>\n';
};

Renderer.prototype.listitem = function(text) {
  return '<li>' + text + '</li>\n';
};

Renderer.prototype.paragraph = function(text) {
  return '<p>' + text + '</p>\n';
};

Renderer.prototype.table = function(header, body) {
  return '<table>\n'
    + '<thead>\n'
    + header
    + '</thead>\n'
    + '<tbody>\n'
    + body
    + '</tbody>\n'
    + '</table>\n';
};

Renderer.prototype.tablerow = function(content) {
  return '<tr>\n' + content + '</tr>\n';
};

Renderer.prototype.tablecell = function(content, flags) {
  var type = flags.header ? 'th' : 'td';
  var tag = flags.align
    ? '<' + type + ' style="text-align:' + flags.align + '">'
    : '<' + type + '>';
  return tag + content + '</' + type + '>\n';
};

// span level renderer
Renderer.prototype.strong = function(text) {
  return '<strong>' + text + '</strong>';
};

Renderer.prototype.em = function(text) {
  return '<em>' + text + '</em>';
};

Renderer.prototype.codespan = function(text) {
  return '<code>' + text + '</code>';
};

Renderer.prototype.br = function() {
  return this.options.xhtml ? '<br/>' : '<br>';
};

Renderer.prototype.del = function(text) {
  return '<del>' + text + '</del>';
};

Renderer.prototype.link = function(href, title, text) {
  if (this.options.sanitize) {
    try {
      var prot = decodeURIComponent(unescape(href))
        .replace(/[^\w:]/g, '')
        .toLowerCase();
    } catch (e) {
      return text;
    }
    if (prot.indexOf('javascript:') === 0 || prot.indexOf('vbscript:') === 0 || prot.indexOf('data:') === 0) {
      return text;
    }
  }
  if (this.options.baseUrl && !originIndependentUrl.test(href)) {
    href = resolveUrl(this.options.baseUrl, href);
  }
  var out = '<a href="' + href + '"';
  if (title) {
    out += ' title="' + title + '"';
  }
  out += '>' + text + '</a>';
  return out;
};

Renderer.prototype.image = function(href, title, text) {
  if (this.options.baseUrl && !originIndependentUrl.test(href)) {
    href = resolveUrl(this.options.baseUrl, href);
  }
  var out = '<img src="' + href + '" alt="' + text + '"';
  if (title) {
    out += ' title="' + title + '"';
  }
  out += this.options.xhtml ? '/>' : '>';
  return out;
};

Renderer.prototype.text = function(text) {
  return text;
};

/**
 * TextRenderer
 * returns only the textual part of the token
 */

function TextRenderer() {}

// no need for block level renderers

TextRenderer.prototype.strong =
TextRenderer.prototype.em =
TextRenderer.prototype.codespan =
TextRenderer.prototype.del =
TextRenderer.prototype.text = function (text) {
  return text;
}

TextRenderer.prototype.link =
TextRenderer.prototype.image = function(href, title, text) {
  return '' + text;
}

TextRenderer.prototype.br = function() {
  return '';
}

/**
 * Parsing & Compiling
 */

function Parser(options) {
  this.tokens = [];
  this.token = null;
  this.options = options || marked.defaults;
  this.options.renderer = this.options.renderer || new Renderer();
  this.renderer = this.options.renderer;
  this.renderer.options = this.options;
}

/**
 * Static Parse Method
 */

Parser.parse = function(src, options) {
  var parser = new Parser(options);
  return parser.parse(src);
};

/**
 * Parse Loop
 */

Parser.prototype.parse = function(src) {
  this.inline = new InlineLexer(src.links, this.options);
  // use an InlineLexer with a TextRenderer to extract pure text
  this.inlineText = new InlineLexer(
    src.links,
    merge({}, this.options, {renderer: new TextRenderer()})
  );
  this.tokens = src.reverse();

  var out = '';
  while (this.next()) {
    out += this.tok();
  }

  return out;
};

/**
 * Next Token
 */

Parser.prototype.next = function() {
  return this.token = this.tokens.pop();
};

/**
 * Preview Next Token
 */

Parser.prototype.peek = function() {
  return this.tokens[this.tokens.length - 1] || 0;
};

/**
 * Parse Text Tokens
 */

Parser.prototype.parseText = function() {
  var body = this.token.text;

  while (this.peek().type === 'text') {
    body += '\n' + this.next().text;
  }

  return this.inline.output(body);
};

/**
 * Parse Current Token
 */

Parser.prototype.tok = function() {
  switch (this.token.type) {
    case 'space': {
      return '';
    }
    case 'hr': {
      return this.renderer.hr();
    }
    case 'heading': {
      return this.renderer.heading(
        this.inline.output(this.token.text),
        this.token.depth,
        unescape(this.inlineText.output(this.token.text)));
    }
    case 'code': {
      return this.renderer.code(this.token.text,
        this.token.lang,
        this.token.escaped);
    }
    case 'table': {
      var header = '',
          body = '',
          i,
          row,
          cell,
          j;

      // header
      cell = '';
      for (i = 0; i < this.token.header.length; i++) {
        cell += this.renderer.tablecell(
          this.inline.output(this.token.header[i]),
          { header: true, align: this.token.align[i] }
        );
      }
      header += this.renderer.tablerow(cell);

      for (i = 0; i < this.token.cells.length; i++) {
        row = this.token.cells[i];

        cell = '';
        for (j = 0; j < row.length; j++) {
          cell += this.renderer.tablecell(
            this.inline.output(row[j]),
            { header: false, align: this.token.align[j] }
          );
        }

        body += this.renderer.tablerow(cell);
      }
      return this.renderer.table(header, body);
    }
    case 'blockquote_start': {
      body = '';

      while (this.next().type !== 'blockquote_end') {
        body += this.tok();
      }

      return this.renderer.blockquote(body);
    }
    case 'list_start': {
      body = '';
      var ordered = this.token.ordered,
          start = this.token.start;

      while (this.next().type !== 'list_end') {
        body += this.tok();
      }

      return this.renderer.list(body, ordered, start);
    }
    case 'list_item_start': {
      body = '';

      while (this.next().type !== 'list_item_end') {
        body += this.token.type === 'text'
          ? this.parseText()
          : this.tok();
      }

      return this.renderer.listitem(body);
    }
    case 'loose_item_start': {
      body = '';

      while (this.next().type !== 'list_item_end') {
        body += this.tok();
      }

      return this.renderer.listitem(body);
    }
    case 'html': {
      var html = !this.token.pre && !this.options.pedantic
        ? this.inline.output(this.token.text)
        : this.token.text;
      return this.renderer.html(html);
    }
    case 'paragraph': {
      return this.renderer.paragraph(this.inline.output(this.token.text));
    }
    case 'text': {
      return this.renderer.paragraph(this.parseText());
    }
  }
};

/**
 * Helpers
 */

function escape(html, encode) {
  return html
    .replace(!encode ? /&(?!#?\w+;)/g : /&/g, '&amp;')
    .replace(/</g, '&lt;')
    .replace(/>/g, '&gt;')
    .replace(/"/g, '&quot;')
    .replace(/'/g, '&#39;');
}

function unescape(html) {
  // explicitly match decimal, hex, and named HTML entities
  return html.replace(/&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/ig, function(_, n) {
    n = n.toLowerCase();
    if (n === 'colon') return ':';
    if (n.charAt(0) === '#') {
      return n.charAt(1) === 'x'
        ? String.fromCharCode(parseInt(n.substring(2), 16))
        : String.fromCharCode(+n.substring(1));
    }
    return '';
  });
}

function edit(regex, opt) {
  regex = regex.source;
  opt = opt || '';
  return {
    replace: function(name, val) {
      val = val.source || val;
      val = val.replace(/(^|[^\[])\^/g, '$1');
      regex = regex.replace(name, val);
      return this;
    },
    getRegex: function() {
      return new RegExp(regex, opt);
    }
  };
}

function resolveUrl(base, href) {
  if (!baseUrls[' ' + base]) {
    // we can ignore everything in base after the last slash of its path component,
    // but we might need to add _that_
    // https://tools.ietf.org/html/rfc3986#section-3
    if (/^[^:]+:\/*[^/]*$/.test(base)) {
      baseUrls[' ' + base] = base + '/';
    } else {
      baseUrls[' ' + base] = base.replace(/[^/]*$/, '');
    }
  }
  base = baseUrls[' ' + base];

  if (href.slice(0, 2) === '//') {
    return base.replace(/:[\s\S]*/, ':') + href;
  } else if (href.charAt(0) === '/') {
    return base.replace(/(:\/*[^/]*)[\s\S]*/, '$1') + href;
  } else {
    return base + href;
  }
}
var baseUrls = {};
var originIndependentUrl = /^$|^[a-z][a-z0-9+.-]*:|^[?#]/i;

function noop() {}
noop.exec = noop;

function merge(obj) {
  var i = 1,
      target,
      key;

  for (; i < arguments.length; i++) {
    target = arguments[i];
    for (key in target) {
      if (Object.prototype.hasOwnProperty.call(target, key)) {
        obj[key] = target[key];
      }
    }
  }

  return obj;
}

/**
 * Marked
 */

function marked(src, opt, callback) {
  // throw error in case of non string input
  if (typeof src === 'undefined' || src === null) {
    throw new Error('marked(): input parameter is undefined or null');
  }
  if (typeof src !== 'string') {
    throw new Error('marked(): input parameter is of type '
      + Object.prototype.toString.call(src) + ', string expected');
  }

  if (callback || typeof opt === 'function') {
    if (!callback) {
      callback = opt;
      opt = null;
    }

    opt = merge({}, marked.defaults, opt || {});

    var highlight = opt.highlight,
        tokens,
        pending,
        i = 0;

    try {
      tokens = Lexer.lex(src, opt)
    } catch (e) {
      return callback(e);
    }

    pending = tokens.length;

    var done = function(err) {
      if (err) {
        opt.highlight = highlight;
        return callback(err);
      }

      var out;

      try {
        out = Parser.parse(tokens, opt);
      } catch (e) {
        err = e;
      }

      opt.highlight = highlight;

      return err
        ? callback(err)
        : callback(null, out);
    };

    if (!highlight || highlight.length < 3) {
      return done();
    }

    delete opt.highlight;

    if (!pending) return done();

    for (; i < tokens.length; i++) {
      (function(token) {
        if (token.type !== 'code') {
          return --pending || done();
        }
        return highlight(token.text, token.lang, function(err, code) {
          if (err) return done(err);
          if (code == null || code === token.text) {
            return --pending || done();
          }
          token.text = code;
          token.escaped = true;
          --pending || done();
        });
      })(tokens[i]);
    }

    return;
  }
  try {
    if (opt) opt = merge({}, marked.defaults, opt);
    return Parser.parse(Lexer.lex(src, opt), opt);
  } catch (e) {
    e.message += '\nPlease report this to https://github.com/markedjs/marked.';
    if ((opt || marked.defaults).silent) {
      return '<p>An error occurred:</p><pre>'
        + escape(e.message + '', true)
        + '</pre>';
    }
    throw e;
  }
}

/**
 * Options
 */

marked.options =
marked.setOptions = function(opt) {
  merge(marked.defaults, opt);
  return marked;
};

marked.defaults = {
  gfm: true,
  tables: true,
  breaks: false,
  pedantic: false,
  sanitize: false,
  sanitizer: null,
  mangle: true,
  smartLists: false,
  silent: false,
  highlight: null,
  langPrefix: 'lang-',
  smartypants: false,
  headerPrefix: '',
  renderer: new Renderer(),
  xhtml: false,
  baseUrl: null
};

/**
 * Expose
 */

marked.Parser = Parser;
marked.parser = Parser.parse;

marked.Renderer = Renderer;
marked.TextRenderer = TextRenderer;

marked.Lexer = Lexer;
marked.lexer = Lexer.lex;

marked.InlineLexer = InlineLexer;
marked.inlineLexer = InlineLexer.output;

marked.parse = marked;

if (typeof module !== 'undefined' && typeof exports === 'object') {
  module.exports = marked;
} else if (typeof define === 'function' && define.amd) {
  define(function() { return marked; });
} else {
  root.marked = marked;
}
})(this || (typeof window !== 'undefined' ? window : global));

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{}],111:[function(require,module,exports){
(function (process,global,Buffer){
var inherits          = require('inherits')
  , AbstractLevelDOWN = require('abstract-leveldown').AbstractLevelDOWN
  , AbstractIterator  = require('abstract-leveldown').AbstractIterator
  , ltgt              = require('ltgt')
  , setImmediate      = global.setImmediate || process.nextTick
  , createRBT = require('functional-red-black-tree')
  , globalStore       = {}

function toKey (key) {
  return typeof key == 'string' ? '$' + key : JSON.stringify(key)
}

function gt(value) {
  return ltgt.compare(value, this._end) > 0
}

function gte(value) {
  return ltgt.compare(value, this._end) >= 0
}

function lt(value) {
  return ltgt.compare(value, this._end) < 0
}

function lte(value) {
  return ltgt.compare(value, this._end) <= 0
}


function MemIterator (db, options) {
  AbstractIterator.call(this, db)
  this._limit   = options.limit

  if (this._limit === -1)
    this._limit = Infinity

  var tree = db._store[db._location];

  this.keyAsBuffer = options.keyAsBuffer !== false
  this.valueAsBuffer = options.valueAsBuffer !== false
  this._reverse   = options.reverse
  this._options = options
  this._done = 0

  if (!this._reverse) {
    this._incr = 'next';
    this._start = ltgt.lowerBound(options);
    this._end = ltgt.upperBound(options)

    if (typeof this._start === 'undefined')
      this._tree = tree.begin;
    else if (ltgt.lowerBoundInclusive(options))
      this._tree = tree.ge(this._start);
    else
      this._tree = tree.gt(this._start);

    if (this._end) {
      if (ltgt.upperBoundInclusive(options))
        this._test = lte
      else
        this._test = lt
    }

  } else {
    this._incr = 'prev';
    this._start = ltgt.upperBound(options)
    this._end = ltgt.lowerBound(options)

    if (typeof this._start === 'undefined')
      this._tree = tree.end;
    else if (ltgt.upperBoundInclusive(options))
      this._tree = tree.le(this._start)
    else
      this._tree = tree.lt(this._start)

    if (this._end) {
      if (ltgt.lowerBoundInclusive(options))
        this._test = gte
      else
        this._test = gt
    }

  }

}

inherits(MemIterator, AbstractIterator)

MemIterator.prototype._next = function (callback) {
  var key
    , value

  if (this._done++ >= this._limit)
    return setImmediate(callback)

  if (!this._tree.valid)
    return setImmediate(callback)

  key = this._tree.key
  value = this._tree.value

  if (!this._test(key))
    return setImmediate(callback)

  if (this.keyAsBuffer)
    key = new Buffer(key)

  if (this.valueAsBuffer)
    value = new Buffer(value)

  this._tree[this._incr]()

  setImmediate(function callNext() {
    callback(null, key, value)
  })
}

MemIterator.prototype._test = function () {return true}

function MemDOWN (location) {
  if (!(this instanceof MemDOWN))
    return new MemDOWN(location)

  AbstractLevelDOWN.call(this, typeof location == 'string' ? location : '')

  this._location = this.location ? toKey(this.location) : '_tree'
  this._store = this.location ? globalStore: this
  this._store[this._location] = this._store[this._location] || createRBT(ltgt.compare)
}

MemDOWN.clearGlobalStore = function (strict) {
  if (strict) {
    Object.keys(globalStore).forEach(function (key) {
      delete globalStore[key];
    })
  } else {
    globalStore = {}
  }
}

inherits(MemDOWN, AbstractLevelDOWN)

MemDOWN.prototype._open = function (options, callback) {
  var self = this
  setImmediate(function callNext() { callback(null, self) })
}

MemDOWN.prototype._put = function (key, value, options, callback) {
  if (typeof value === 'undefined' || value === null) value = ''

  var iter = this._store[this._location].find(key)

  if (iter.valid) {
    this._store[this._location] = iter.update(value)
  } else {
    this._store[this._location] = this._store[this._location].insert(key, value)
  }

  setImmediate(callback)
}

MemDOWN.prototype._get = function (key, options, callback) {
  var value = this._store[this._location].get(key)

  if (value === undefined) {
    // 'NotFound' error, consistent with LevelDOWN API
    var err = new Error('NotFound')
    return setImmediate(function callNext() { callback(err) })
  }

  if (options.asBuffer !== false && !this._isBuffer(value))
    value = new Buffer(String(value))

  setImmediate(function callNext () {
    callback(null, value)
  })

}

MemDOWN.prototype._del = function (key, options, callback) {
  this._store[this._location] = this._store[this._location].remove(key)
  setImmediate(callback)
}

MemDOWN.prototype._batch = function (array, options, callback) {
  var err
    , i = -1
    , key
    , value
    , iter
    , len = array.length
    , tree = this._store[this._location]

  while (++i < len) {
    if (!array[i])
      continue;

    key = this._isBuffer(array[i].key) ? array[i].key : String(array[i].key)
    err = this._checkKey(key, 'key')
    if (err)
      return setImmediate(function errorCall() { callback(err) })

    iter = tree.find(key)

    if (array[i].type === 'put') {
      value = this._isBuffer(array[i].value) ? array[i].value : String(array[i].value)
      err = this._checkKey(value, 'value')

      if (err)
        return setImmediate(function errorCall() { callback(err) })

      tree = iter.valid ? iter.update(value) : tree.insert(key, value)
    } else {
      tree = iter.remove()
    }
  }

  this._store[this._location] = tree;

  setImmediate(callback)
}

MemDOWN.prototype._iterator = function (options) {
  return new MemIterator(this, options)
}

MemDOWN.prototype._isBuffer = function (obj) {
  return Buffer.isBuffer(obj)
}

MemDOWN.destroy = function (name, callback) {
  var key = toKey(name)

  if (key in globalStore)
    delete globalStore[key]

  setImmediate(callback)
}

module.exports = MemDOWN

}).call(this,require('_process'),typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {},require("buffer").Buffer)
},{"_process":136,"abstract-leveldown":115,"buffer":46,"functional-red-black-tree":87,"inherits":90,"ltgt":109}],112:[function(require,module,exports){
arguments[4][50][0].apply(exports,arguments)
},{"_process":136,"dup":50}],113:[function(require,module,exports){
arguments[4][51][0].apply(exports,arguments)
},{"_process":136,"dup":51}],114:[function(require,module,exports){
arguments[4][52][0].apply(exports,arguments)
},{"../../../is-buffer/index.js":91,"./abstract-chained-batch":112,"./abstract-iterator":113,"_process":136,"dup":52,"xtend":310}],115:[function(require,module,exports){
arguments[4][53][0].apply(exports,arguments)
},{"./abstract-chained-batch":112,"./abstract-iterator":113,"./abstract-leveldown":114,"./is-leveldown":116,"dup":53}],116:[function(require,module,exports){
arguments[4][54][0].apply(exports,arguments)
},{"./abstract-leveldown":114,"dup":54}],117:[function(require,module,exports){
'use strict';

var MIN_MAGNITUDE = -324; // verified by -Number.MIN_VALUE
var MAGNITUDE_DIGITS = 3; // ditto
var SEP = ''; // set to '_' for easier debugging 

var utils = require('./utils');

exports.collate = function (a, b) {

  if (a === b) {
    return 0;
  }

  a = exports.normalizeKey(a);
  b = exports.normalizeKey(b);

  var ai = collationIndex(a);
  var bi = collationIndex(b);
  if ((ai - bi) !== 0) {
    return ai - bi;
  }
  if (a === null) {
    return 0;
  }
  switch (typeof a) {
    case 'number':
      return a - b;
    case 'boolean':
      return a === b ? 0 : (a < b ? -1 : 1);
    case 'string':
      return stringCollate(a, b);
  }
  return Array.isArray(a) ? arrayCollate(a, b) : objectCollate(a, b);
};

// couch considers null/NaN/Infinity/-Infinity === undefined,
// for the purposes of mapreduce indexes. also, dates get stringified.
exports.normalizeKey = function (key) {
  switch (typeof key) {
    case 'undefined':
      return null;
    case 'number':
      if (key === Infinity || key === -Infinity || isNaN(key)) {
        return null;
      }
      return key;
    case 'object':
      var origKey = key;
      if (Array.isArray(key)) {
        var len = key.length;
        key = new Array(len);
        for (var i = 0; i < len; i++) {
          key[i] = exports.normalizeKey(origKey[i]);
        }
      } else if (key instanceof Date) {
        return key.toJSON();
      } else if (key !== null) { // generic object
        key = {};
        for (var k in origKey) {
          if (origKey.hasOwnProperty(k)) {
            var val = origKey[k];
            if (typeof val !== 'undefined') {
              key[k] = exports.normalizeKey(val);
            }
          }
        }
      }
  }
  return key;
};

function indexify(key) {
  if (key !== null) {
    switch (typeof key) {
      case 'boolean':
        return key ? 1 : 0;
      case 'number':
        return numToIndexableString(key);
      case 'string':
        // We've to be sure that key does not contain \u0000
        // Do order-preserving replacements:
        // 0 -> 1, 1
        // 1 -> 1, 2
        // 2 -> 2, 2
        return key
          .replace(/\u0002/g, '\u0002\u0002')
          .replace(/\u0001/g, '\u0001\u0002')
          .replace(/\u0000/g, '\u0001\u0001');
      case 'object':
        var isArray = Array.isArray(key);
        var arr = isArray ? key : Object.keys(key);
        var i = -1;
        var len = arr.length;
        var result = '';
        if (isArray) {
          while (++i < len) {
            result += exports.toIndexableString(arr[i]);
          }
        } else {
          while (++i < len) {
            var objKey = arr[i];
            result += exports.toIndexableString(objKey) +
                exports.toIndexableString(key[objKey]);
          }
        }
        return result;
    }
  }
  return '';
}

// convert the given key to a string that would be appropriate
// for lexical sorting, e.g. within a database, where the
// sorting is the same given by the collate() function.
exports.toIndexableString = function (key) {
  var zero = '\u0000';
  key = exports.normalizeKey(key);
  return collationIndex(key) + SEP + indexify(key) + zero;
};

function parseNumber(str, i) {
  var originalIdx = i;
  var num;
  var zero = str[i] === '1';
  if (zero) {
    num = 0;
    i++;
  } else {
    var neg = str[i] === '0';
    i++;
    var numAsString = '';
    var magAsString = str.substring(i, i + MAGNITUDE_DIGITS);
    var magnitude = parseInt(magAsString, 10) + MIN_MAGNITUDE;
    if (neg) {
      magnitude = -magnitude;
    }
    i += MAGNITUDE_DIGITS;
    while (true) {
      var ch = str[i];
      if (ch === '\u0000') {
        break;
      } else {
        numAsString += ch;
      }
      i++;
    }
    numAsString = numAsString.split('.');
    if (numAsString.length === 1) {
      num = parseInt(numAsString, 10);
    } else {
      num = parseFloat(numAsString[0] + '.' + numAsString[1]);
    }
    if (neg) {
      num = num - 10;
    }
    if (magnitude !== 0) {
      // parseFloat is more reliable than pow due to rounding errors
      // e.g. Number.MAX_VALUE would return Infinity if we did
      // num * Math.pow(10, magnitude);
      num = parseFloat(num + 'e' + magnitude);
    }
  }
  return {num: num, length : i - originalIdx};
}

// move up the stack while parsing
// this function moved outside of parseIndexableString for performance
function pop(stack, metaStack) {
  var obj = stack.pop();

  if (metaStack.length) {
    var lastMetaElement = metaStack[metaStack.length - 1];
    if (obj === lastMetaElement.element) {
      // popping a meta-element, e.g. an object whose value is another object
      metaStack.pop();
      lastMetaElement = metaStack[metaStack.length - 1];
    }
    var element = lastMetaElement.element;
    var lastElementIndex = lastMetaElement.index;
    if (Array.isArray(element)) {
      element.push(obj);
    } else if (lastElementIndex === stack.length - 2) { // obj with key+value
      var key = stack.pop();
      element[key] = obj;
    } else {
      stack.push(obj); // obj with key only
    }
  }
}

exports.parseIndexableString = function (str) {
  var stack = [];
  var metaStack = []; // stack for arrays and objects
  var i = 0;

  while (true) {
    var collationIndex = str[i++];
    if (collationIndex === '\u0000') {
      if (stack.length === 1) {
        return stack.pop();
      } else {
        pop(stack, metaStack);
        continue;
      }
    }
    switch (collationIndex) {
      case '1':
        stack.push(null);
        break;
      case '2':
        stack.push(str[i] === '1');
        i++;
        break;
      case '3':
        var parsedNum = parseNumber(str, i);
        stack.push(parsedNum.num);
        i += parsedNum.length;
        break;
      case '4':
        var parsedStr = '';
        while (true) {
          var ch = str[i];
          if (ch === '\u0000') {
            break;
          }
          parsedStr += ch;
          i++;
        }
        // perform the reverse of the order-preserving replacement
        // algorithm (see above)
        parsedStr = parsedStr.replace(/\u0001\u0001/g, '\u0000')
          .replace(/\u0001\u0002/g, '\u0001')
          .replace(/\u0002\u0002/g, '\u0002');
        stack.push(parsedStr);
        break;
      case '5':
        var arrayElement = { element: [], index: stack.length };
        stack.push(arrayElement.element);
        metaStack.push(arrayElement);
        break;
      case '6':
        var objElement = { element: {}, index: stack.length };
        stack.push(objElement.element);
        metaStack.push(objElement);
        break;
      default:
        throw new Error(
          'bad collationIndex or unexpectedly reached end of input: ' + collationIndex);
    }
  }
};

function arrayCollate(a, b) {
  var len = Math.min(a.length, b.length);
  for (var i = 0; i < len; i++) {
    var sort = exports.collate(a[i], b[i]);
    if (sort !== 0) {
      return sort;
    }
  }
  return (a.length === b.length) ? 0 :
    (a.length > b.length) ? 1 : -1;
}
function stringCollate(a, b) {
  // See: https://github.com/daleharvey/pouchdb/issues/40
  // This is incompatible with the CouchDB implementation, but its the
  // best we can do for now
  return (a === b) ? 0 : ((a > b) ? 1 : -1);
}
function objectCollate(a, b) {
  var ak = Object.keys(a), bk = Object.keys(b);
  var len = Math.min(ak.length, bk.length);
  for (var i = 0; i < len; i++) {
    // First sort the keys
    var sort = exports.collate(ak[i], bk[i]);
    if (sort !== 0) {
      return sort;
    }
    // if the keys are equal sort the values
    sort = exports.collate(a[ak[i]], b[bk[i]]);
    if (sort !== 0) {
      return sort;
    }

  }
  return (ak.length === bk.length) ? 0 :
    (ak.length > bk.length) ? 1 : -1;
}
// The collation is defined by erlangs ordered terms
// the atoms null, true, false come first, then numbers, strings,
// arrays, then objects
// null/undefined/NaN/Infinity/-Infinity are all considered null
function collationIndex(x) {
  var id = ['boolean', 'number', 'string', 'object'];
  var idx = id.indexOf(typeof x);
  //false if -1 otherwise true, but fast!!!!1
  if (~idx) {
    if (x === null) {
      return 1;
    }
    if (Array.isArray(x)) {
      return 5;
    }
    return idx < 3 ? (idx + 2) : (idx + 3);
  }
  if (Array.isArray(x)) {
    return 5;
  }
}

// conversion:
// x yyy zz...zz
// x = 0 for negative, 1 for 0, 2 for positive
// y = exponent (for negative numbers negated) moved so that it's >= 0
// z = mantisse
function numToIndexableString(num) {

  if (num === 0) {
    return '1';
  }

  // convert number to exponential format for easier and
  // more succinct string sorting
  var expFormat = num.toExponential().split(/e\+?/);
  var magnitude = parseInt(expFormat[1], 10);

  var neg = num < 0;

  var result = neg ? '0' : '2';

  // first sort by magnitude
  // it's easier if all magnitudes are positive
  var magForComparison = ((neg ? -magnitude : magnitude) - MIN_MAGNITUDE);
  var magString = utils.padLeft((magForComparison).toString(), '0', MAGNITUDE_DIGITS);

  result += SEP + magString;

  // then sort by the factor
  var factor = Math.abs(parseFloat(expFormat[0])); // [1..10)
  if (neg) { // for negative reverse ordering
    factor = 10 - factor;
  }

  var factorStr = factor.toFixed(20);

  // strip zeros from the end
  factorStr = factorStr.replace(/\.?0+$/, '');

  result += SEP + factorStr;

  return result;
}

},{"./utils":118}],118:[function(require,module,exports){
'use strict';

function pad(str, padWith, upToLength) {
  var padding = '';
  var targetLength = upToLength - str.length;
  while (padding.length < targetLength) {
    padding += padWith;
  }
  return padding;
}

exports.padLeft = function (str, padWith, upToLength) {
  var padding = pad(str, padWith, upToLength);
  return padding + str;
};

exports.padRight = function (str, padWith, upToLength) {
  var padding = pad(str, padWith, upToLength);
  return str + padding;
};

exports.stringLexCompare = function (a, b) {

  var aLen = a.length;
  var bLen = b.length;

  var i;
  for (i = 0; i < aLen; i++) {
    if (i === bLen) {
      // b is shorter substring of a
      return 1;
    }
    var aChar = a.charAt(i);
    var bChar = b.charAt(i);
    if (aChar !== bChar) {
      return aChar < bChar ? -1 : 1;
    }
  }

  if (aLen < bLen) {
    // a is shorter substring of b
    return -1;
  }

  return 0;
};

/*
 * returns the decimal form for the given integer, i.e. writes
 * out all the digits (in base-10) instead of using scientific notation
 */
exports.intToDecimalForm = function (int) {

  var isNeg = int < 0;
  var result = '';

  do {
    var remainder = isNeg ? -Math.ceil(int % 10) : Math.floor(int % 10);

    result = remainder + result;
    int = isNeg ? Math.ceil(int / 10) : Math.floor(int / 10);
  } while (int);


  if (isNeg && result !== '0') {
    result = '-' + result;
  }

  return result;
};
},{}],119:[function(require,module,exports){
'use strict';
exports.Map = LazyMap; // TODO: use ES6 map
exports.Set = LazySet; // TODO: use ES6 set
// based on https://github.com/montagejs/collections
function LazyMap() {
  this.store = {};
}
LazyMap.prototype.mangle = function (key) {
  if (typeof key !== "string") {
    throw new TypeError("key must be a string but Got " + key);
  }
  return '$' + key;
};
LazyMap.prototype.unmangle = function (key) {
  return key.substring(1);
};
LazyMap.prototype.get = function (key) {
  var mangled = this.mangle(key);
  if (mangled in this.store) {
    return this.store[mangled];
  }
  return void 0;
};
LazyMap.prototype.set = function (key, value) {
  var mangled = this.mangle(key);
  this.store[mangled] = value;
  return true;
};
LazyMap.prototype.has = function (key) {
  var mangled = this.mangle(key);
  return mangled in this.store;
};
LazyMap.prototype.delete = function (key) {
  var mangled = this.mangle(key);
  if (mangled in this.store) {
    delete this.store[mangled];
    return true;
  }
  return false;
};
LazyMap.prototype.forEach = function (cb) {
  var keys = Object.keys(this.store);
  for (var i = 0, len = keys.length; i < len; i++) {
    var key = keys[i];
    var value = this.store[key];
    key = this.unmangle(key);
    cb(value, key);
  }
};

function LazySet(array) {
  this.store = new LazyMap();

  // init with an array
  if (array && Array.isArray(array)) {
    for (var i = 0, len = array.length; i < len; i++) {
      this.add(array[i]);
    }
  }
}
LazySet.prototype.add = function (key) {
  return this.store.set(key, true);
};
LazySet.prototype.has = function (key) {
  return this.store.has(key);
};
LazySet.prototype.delete = function (key) {
  return this.store.delete(key);
};

},{}],120:[function(require,module,exports){
module.exports = require('../lib/extras/memory');
},{"../lib/extras/memory":121}],121:[function(require,module,exports){
(function (process,global,Buffer){
'use strict';

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var levelup = _interopDefault(require('levelup'));
var sublevel = _interopDefault(require('sublevel-pouchdb'));
var through2 = require('through2');
var getArguments = _interopDefault(require('argsarray'));
var pouchdbCollections = require('pouchdb-collections');
var Deque = _interopDefault(require('double-ended-queue'));
var lie = _interopDefault(require('lie'));
var debug = _interopDefault(require('debug'));
var events = require('events');
var inherits = _interopDefault(require('inherits'));
var Md5 = _interopDefault(require('spark-md5'));
var vuvuzela = _interopDefault(require('vuvuzela'));
var jsExtend = require('js-extend');
var memdown = _interopDefault(require('memdown'));

// in the browser, LevelAlt doesn't need the
// pre-2.2.0 LevelDB-specific migrations
var toSublevel = function (name, db, callback) {
  process.nextTick(function () {
    callback();
  });
};

var localAndMetaStores = function (db, stores, callback) {
  process.nextTick(function () {
    callback();
  });
};

var migrate = {
  toSublevel: toSublevel,
  localAndMetaStores: localAndMetaStores
};

/* istanbul ignore next */
var PouchPromise = typeof Promise === 'function' ? Promise : lie;

function isBinaryObject(object) {
  return object instanceof ArrayBuffer ||
    (typeof Blob !== 'undefined' && object instanceof Blob);
}

function cloneArrayBuffer(buff) {
  if (typeof buff.slice === 'function') {
    return buff.slice(0);
  }
  // IE10-11 slice() polyfill
  var target = new ArrayBuffer(buff.byteLength);
  var targetArray = new Uint8Array(target);
  var sourceArray = new Uint8Array(buff);
  targetArray.set(sourceArray);
  return target;
}

function cloneBinaryObject(object) {
  if (object instanceof ArrayBuffer) {
    return cloneArrayBuffer(object);
  }
  var size = object.size;
  var type = object.type;
  // Blob
  if (typeof object.slice === 'function') {
    return object.slice(0, size, type);
  }
  // PhantomJS slice() replacement
  return object.webkitSlice(0, size, type);
}

// most of this is borrowed from lodash.isPlainObject:
// https://github.com/fis-components/lodash.isplainobject/
// blob/29c358140a74f252aeb08c9eb28bef86f2217d4a/index.js

var funcToString = Function.prototype.toString;
var objectCtorString = funcToString.call(Object);

function isPlainObject(value) {
  var proto = Object.getPrototypeOf(value);
  /* istanbul ignore if */
  if (proto === null) { // not sure when this happens, but I guess it can
    return true;
  }
  var Ctor = proto.constructor;
  return (typeof Ctor == 'function' &&
    Ctor instanceof Ctor && funcToString.call(Ctor) == objectCtorString);
}

function clone(object) {
  var newObject;
  var i;
  var len;

  if (!object || typeof object !== 'object') {
    return object;
  }

  if (Array.isArray(object)) {
    newObject = [];
    for (i = 0, len = object.length; i < len; i++) {
      newObject[i] = clone(object[i]);
    }
    return newObject;
  }

  // special case: to avoid inconsistencies between IndexedDB
  // and other backends, we automatically stringify Dates
  if (object instanceof Date) {
    return object.toISOString();
  }

  if (isBinaryObject(object)) {
    return cloneBinaryObject(object);
  }

  if (!isPlainObject(object)) {
    return object; // don't clone objects like Workers
  }

  newObject = {};
  for (i in object) {
    if (Object.prototype.hasOwnProperty.call(object, i)) {
      var value = clone(object[i]);
      if (typeof value !== 'undefined') {
        newObject[i] = value;
      }
    }
  }
  return newObject;
}

var log = debug('pouchdb:api');

// like underscore/lodash _.pick()
function pick(obj, arr) {
  var res = {};
  for (var i = 0, len = arr.length; i < len; i++) {
    var prop = arr[i];
    if (prop in obj) {
      res[prop] = obj[prop];
    }
  }
  return res;
}

function isChromeApp() {
  return (typeof chrome !== "undefined" &&
    typeof chrome.storage !== "undefined" &&
    typeof chrome.storage.local !== "undefined");
}

var hasLocal;

if (isChromeApp()) {
  hasLocal = false;
} else {
  try {
    localStorage.setItem('_pouch_check_localstorage', 1);
    hasLocal = !!localStorage.getItem('_pouch_check_localstorage');
  } catch (e) {
    hasLocal = false;
  }
}

function hasLocalStorage() {
  return hasLocal;
}

inherits(Changes, events.EventEmitter);

/* istanbul ignore next */
function attachBrowserEvents(self) {
  if (isChromeApp()) {
    chrome.storage.onChanged.addListener(function (e) {
      // make sure it's event addressed to us
      if (e.db_name != null) {
        //object only has oldValue, newValue members
        self.emit(e.dbName.newValue);
      }
    });
  } else if (hasLocalStorage()) {
    if (typeof addEventListener !== 'undefined') {
      addEventListener("storage", function (e) {
        self.emit(e.key);
      });
    } else { // old IE
      window.attachEvent("storage", function (e) {
        self.emit(e.key);
      });
    }
  }
}

function Changes() {
  events.EventEmitter.call(this);
  this._listeners = {};

  attachBrowserEvents(this);
}
Changes.prototype.addListener = function (dbName, id, db, opts) {
  /* istanbul ignore if */
  if (this._listeners[id]) {
    return;
  }
  var self = this;
  var inprogress = false;
  function eventFunction() {
    /* istanbul ignore if */
    if (!self._listeners[id]) {
      return;
    }
    if (inprogress) {
      inprogress = 'waiting';
      return;
    }
    inprogress = true;
    var changesOpts = pick(opts, [
      'style', 'include_docs', 'attachments', 'conflicts', 'filter',
      'doc_ids', 'view', 'since', 'query_params', 'binary'
    ]);

    /* istanbul ignore next */
    function onError() {
      inprogress = false;
    }

    db.changes(changesOpts).on('change', function (c) {
      if (c.seq > opts.since && !opts.cancelled) {
        opts.since = c.seq;
        opts.onChange(c);
      }
    }).on('complete', function () {
      if (inprogress === 'waiting') {
        setTimeout(function (){
          eventFunction();
        },0);
      }
      inprogress = false;
    }).on('error', onError);
  }
  this._listeners[id] = eventFunction;
  this.on(dbName, eventFunction);
};

Changes.prototype.removeListener = function (dbName, id) {
  /* istanbul ignore if */
  if (!(id in this._listeners)) {
    return;
  }
  events.EventEmitter.prototype.removeListener.call(this, dbName,
    this._listeners[id]);
};


/* istanbul ignore next */
Changes.prototype.notifyLocalWindows = function (dbName) {
  //do a useless change on a storage thing
  //in order to get other windows's listeners to activate
  if (isChromeApp()) {
    chrome.storage.local.set({dbName: dbName});
  } else if (hasLocalStorage()) {
    localStorage[dbName] = (localStorage[dbName] === "a") ? "b" : "a";
  }
};

Changes.prototype.notify = function (dbName) {
  this.emit(dbName);
  this.notifyLocalWindows(dbName);
};

function guardedConsole(method) {
  if (console !== 'undefined' && method in console) {
    var args = Array.prototype.slice.call(arguments, 1);
    console[method].apply(console, args);
  }
}

inherits(PouchError, Error);

function PouchError(opts) {
  Error.call(this, opts.reason);
  this.status = opts.status;
  this.name = opts.error;
  this.message = opts.reason;
  this.error = true;
}

PouchError.prototype.toString = function () {
  return JSON.stringify({
    status: this.status,
    name: this.name,
    message: this.message,
    reason: this.reason
  });
};

var UNAUTHORIZED = new PouchError({
  status: 401,
  error: 'unauthorized',
  reason: "Name or password is incorrect."
});

var MISSING_BULK_DOCS = new PouchError({
  status: 400,
  error: 'bad_request',
  reason: "Missing JSON list of 'docs'"
});

var MISSING_DOC = new PouchError({
  status: 404,
  error: 'not_found',
  reason: 'missing'
});

var REV_CONFLICT = new PouchError({
  status: 409,
  error: 'conflict',
  reason: 'Document update conflict'
});

var INVALID_ID = new PouchError({
  status: 400,
  error: 'bad_request',
  reason: '_id field must contain a string'
});

var MISSING_ID = new PouchError({
  status: 412,
  error: 'missing_id',
  reason: '_id is required for puts'
});

var RESERVED_ID = new PouchError({
  status: 400,
  error: 'bad_request',
  reason: 'Only reserved document ids may start with underscore.'
});

var NOT_OPEN = new PouchError({
  status: 412,
  error: 'precondition_failed',
  reason: 'Database not open'
});

var UNKNOWN_ERROR = new PouchError({
  status: 500,
  error: 'unknown_error',
  reason: 'Database encountered an unknown error'
});

var BAD_ARG = new PouchError({
  status: 500,
  error: 'badarg',
  reason: 'Some query argument is invalid'
});

var INVALID_REQUEST = new PouchError({
  status: 400,
  error: 'invalid_request',
  reason: 'Request was invalid'
});

var QUERY_PARSE_ERROR = new PouchError({
  status: 400,
  error: 'query_parse_error',
  reason: 'Some query parameter is invalid'
});

var DOC_VALIDATION = new PouchError({
  status: 500,
  error: 'doc_validation',
  reason: 'Bad special document member'
});

var BAD_REQUEST = new PouchError({
  status: 400,
  error: 'bad_request',
  reason: 'Something wrong with the request'
});

var NOT_AN_OBJECT = new PouchError({
  status: 400,
  error: 'bad_request',
  reason: 'Document must be a JSON object'
});

var DB_MISSING = new PouchError({
  status: 404,
  error: 'not_found',
  reason: 'Database not found'
});

var IDB_ERROR = new PouchError({
  status: 500,
  error: 'indexed_db_went_bad',
  reason: 'unknown'
});

var WSQ_ERROR = new PouchError({
  status: 500,
  error: 'web_sql_went_bad',
  reason: 'unknown'
});

var LDB_ERROR = new PouchError({
  status: 500,
  error: 'levelDB_went_went_bad',
  reason: 'unknown'
});

var FORBIDDEN = new PouchError({
  status: 403,
  error: 'forbidden',
  reason: 'Forbidden by design doc validate_doc_update function'
});

var INVALID_REV = new PouchError({
  status: 400,
  error: 'bad_request',
  reason: 'Invalid rev format'
});

var FILE_EXISTS = new PouchError({
  status: 412,
  error: 'file_exists',
  reason: 'The database could not be created, the file already exists.'
});

var MISSING_STUB = new PouchError({
  status: 412,
  error: 'missing_stub'
});

var INVALID_URL = new PouchError({
  status: 413,
  error: 'invalid_url',
  reason: 'Provided URL is invalid'
});

function createError(error, reason) {
  function CustomPouchError(reason) {
    // inherit error properties from our parent error manually
    // so as to allow proper JSON parsing.
    /* jshint ignore:start */
    for (var p in error) {
      if (typeof error[p] !== 'function') {
        this[p] = error[p];
      }
    }
    /* jshint ignore:end */
    if (reason !== undefined) {
      this.reason = reason;
    }
  }
  CustomPouchError.prototype = PouchError.prototype;
  return new CustomPouchError(reason);
}

function tryFilter(filter, doc, req) {
  try {
    return !filter(doc, req);
  } catch (err) {
    var msg = 'Filter function threw: ' + err.toString();
    return createError(BAD_REQUEST, msg);
  }
}

function filterChange(opts) {
  var req = {};
  var hasFilter = opts.filter && typeof opts.filter === 'function';
  req.query = opts.query_params;

  return function filter(change) {
    if (!change.doc) {
      // CSG sends events on the changes feed that don't have documents,
      // this hack makes a whole lot of existing code robust.
      change.doc = {};
    }

    var filterReturn = hasFilter && tryFilter(opts.filter, change.doc, req);

    if (typeof filterReturn === 'object') {
      return filterReturn;
    }

    if (filterReturn) {
      return false;
    }

    if (!opts.include_docs) {
      delete change.doc;
    } else if (!opts.attachments) {
      for (var att in change.doc._attachments) {
        /* istanbul ignore else */
        if (change.doc._attachments.hasOwnProperty(att)) {
          change.doc._attachments[att].stub = true;
        }
      }
    }
    return true;
  };
}

// shim for Function.prototype.name,
// for browsers that don't support it like IE

/* istanbul ignore next */
function f() {}

var hasName = f.name;
var res;

// We dont run coverage in IE
/* istanbul ignore else */
if (hasName) {
  res = function (fun) {
    return fun.name;
  };
} else {
  res = function (fun) {
    return fun.toString().match(/^\s*function\s*(\S*)\s*\(/)[1];
  };
}

var functionName = res;

// Determine id an ID is valid
//   - invalid IDs begin with an underescore that does not begin '_design' or
//     '_local'
//   - any other string value is a valid id
// Returns the specific error object for each case
function invalidIdError(id) {
  var err;
  if (!id) {
    err = createError(MISSING_ID);
  } else if (typeof id !== 'string') {
    err = createError(INVALID_ID);
  } else if (/^_/.test(